/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.I18nManager;
import tim.prune.function.settings.SetMapBgFunction;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.OsmMapSource;

public class AddMapSourceDialog {
    private SetMapBgFunction _parent = null;
    private JDialog _addDialog = null;
    private MapSource _originalSource = null;
    private JTextField _oNameField = null;
    private JTextField _baseUrlField = null;
    private JTextField _topUrlField = null;
    private JRadioButton[] _baseTypeRadios = null;
    private JRadioButton[] _topTypeRadios = null;
    private JComboBox<Integer> _oZoomCombo = null;
    private JButton _okButton = null;
    private static final String[] FILE_TYPES = new String[]{"png", "jpg", "gif"};

    public AddMapSourceDialog(JDialog jDialog, SetMapBgFunction setMapBgFunction) {
        this._parent = setMapBgFunction;
        this._addDialog = new JDialog(jDialog, I18nManager.getText("dialog.addmapsource.title"), true);
        this._addDialog.add(this.makeDialogComponents());
        this._addDialog.setLocationRelativeTo(jDialog);
        this._addDialog.pack();
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(" "), "North");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                if (keyEvent.getKeyCode() == 27) {
                    AddMapSourceDialog.this._addDialog.dispose();
                } else {
                    AddMapSourceDialog.this.enableOK();
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this.enableOK();
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 3, 4, 3));
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 23;
        jPanel3.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.sourcename")), gridBagConstraints);
        this._oNameField = new JTextField(18);
        this._oNameField.addKeyListener(keyAdapter);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this._oNameField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.layer1url")), gridBagConstraints);
        this._baseUrlField = new JTextField(18);
        this._baseUrlField.addKeyListener(keyAdapter);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this._baseUrlField, gridBagConstraints);
        this._baseTypeRadios = new JRadioButton[3];
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < 3) {
            this._baseTypeRadios[n] = new JRadioButton(FILE_TYPES[n]);
            buttonGroup.add(this._baseTypeRadios[n]);
            gridBagConstraints.gridx = 2 + n;
            gridBagConstraints.weightx = 0.0;
            jPanel3.add((Component)this._baseTypeRadios[n], gridBagConstraints);
            this._baseTypeRadios[n].addActionListener(actionListener);
            ++n;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel3.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.layer2url")), gridBagConstraints);
        this._topUrlField = new JTextField(18);
        this._topUrlField.addKeyListener(keyAdapter);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this._topUrlField, gridBagConstraints);
        this._topTypeRadios = new JRadioButton[3];
        buttonGroup = new ButtonGroup();
        n = 0;
        while (n < 3) {
            this._topTypeRadios[n] = new JRadioButton(FILE_TYPES[n]);
            buttonGroup.add(this._topTypeRadios[n]);
            gridBagConstraints.gridx = 2 + n;
            gridBagConstraints.weightx = 0.0;
            jPanel3.add((Component)this._topTypeRadios[n], gridBagConstraints);
            this._topTypeRadios[n].addActionListener(actionListener);
            ++n;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel3.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.maxzoom")), gridBagConstraints);
        this._oZoomCombo = new JComboBox();
        n = 10;
        while (n <= 20) {
            this._oZoomCombo.addItem(n);
            ++n;
        }
        this._oZoomCombo.addActionListener(actionListener);
        gridBagConstraints.gridx = 1;
        jPanel3.add(this._oZoomCombo, gridBagConstraints);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener2);
        jPanel5.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this._addDialog.dispose();
            }
        });
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    public void showDialog(MapSource mapSource) {
        this._originalSource = mapSource;
        this.populateFields();
    }

    private void clearAllFields() {
        this._oNameField.setText("");
        this._baseUrlField.setText("");
        this._baseTypeRadios[0].setSelected(true);
        this._topUrlField.setText("");
        this._topTypeRadios[0].setSelected(true);
        this._oZoomCombo.setSelectedIndex(8);
        this._okButton.setEnabled(false);
        this._addDialog.setVisible(true);
    }

    private void populateFields() {
        if (this._originalSource == null) {
            this.clearAllFields();
            return;
        }
        try {
            OsmMapSource osmMapSource = (OsmMapSource)this._originalSource;
            this._oNameField.setText(osmMapSource.getName());
            this._baseUrlField.setText(osmMapSource.getBaseUrl(0));
            int n = AddMapSourceDialog.getBaseType(osmMapSource.getFileExtension(0));
            this._baseTypeRadios[n].setSelected(true);
            this._topUrlField.setText(osmMapSource.getNumLayers() == 0 ? "" : osmMapSource.getBaseUrl(1));
            int n2 = AddMapSourceDialog.getBaseType(osmMapSource.getFileExtension(1));
            this._topTypeRadios[n2].setSelected(true);
            this._oZoomCombo.setSelectedIndex(AddMapSourceDialog.getZoomIndex(osmMapSource.getMaxZoomLevel()));
        }
        catch (ClassCastException classCastException) {}
        this._okButton.setEnabled(false);
        this._addDialog.setVisible(true);
    }

    private void enableOK() {
        this._okButton.setEnabled(this.isOsmPanelOk());
    }

    private boolean isOsmPanelOk() {
        boolean bl = this._oNameField.getText().trim().length() > 1;
        String string = null;
        String string2 = null;
        String string3 = this._baseUrlField.getText().trim();
        string = MapSource.fixBaseUrl(string3);
        if (string3.length() > 0 && string == null) {
            bl = false;
        }
        String string4 = this._topUrlField.getText().trim();
        string2 = MapSource.fixBaseUrl(string4);
        if (string4.length() > 0 && string2 == null) {
            bl = false;
        }
        return bl && (string != null || string2 != null);
    }

    private void finish() {
        String string;
        OsmMapSource osmMapSource = null;
        String string2 = string = this._originalSource == null ? null : this._originalSource.getName();
        if (this.isOsmPanelOk()) {
            String string3 = AddMapSourceDialog.getValidSourcename(this._oNameField.getText(), string);
            String string4 = this._baseUrlField.getText().trim();
            String string5 = this.getFileExtension(this._baseTypeRadios);
            String string6 = this._topUrlField.getText().trim();
            String string7 = this.getFileExtension(this._topTypeRadios);
            osmMapSource = new OsmMapSource(string3, string4, string5, string6, string7, this._oZoomCombo.getSelectedIndex() + 10);
        }
        if (osmMapSource != null) {
            if (this._originalSource == null) {
                MapSourceLibrary.addSource(osmMapSource);
            } else {
                MapSourceLibrary.editSource(this._originalSource, osmMapSource);
            }
            this._parent.updateList();
            this._addDialog.setVisible(false);
        }
    }

    private static String getValidSourcename(String string, String string2) {
        String string3 = string;
        string3 = string3 == null ? "" : string3.trim();
        if (string3.equals("")) {
            string3 = I18nManager.getText("dialog.addmapsource.noname");
        }
        if ((string2 == null || !string2.equals(string3)) && MapSourceLibrary.hasSourceName(string3)) {
            int n = 1;
            while (MapSourceLibrary.hasSourceName(String.valueOf(string3) + n)) {
                ++n;
            }
            string3 = String.valueOf(string3) + n;
        }
        return string3;
    }

    private String getFileExtension(JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray != null) {
            int n = 0;
            while (n < jRadioButtonArray.length) {
                if (jRadioButtonArray[n] != null && jRadioButtonArray[n].isSelected()) {
                    return FILE_TYPES[n];
                }
                ++n;
            }
        }
        return FILE_TYPES[0];
    }

    private static int getBaseType(String string) {
        int n = 0;
        while (n < FILE_TYPES.length) {
            if (FILE_TYPES[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private static int getZoomIndex(int n) {
        return Math.max(0, n - 10);
    }
}

