/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.nio.charset.Charset;
import tim.prune.save.xml.XmlUtils;

public class ByteBuffer {
    private byte[] _bytes = new byte[1024];
    private int _currPos = 0;
    private boolean _streamUtf8 = false;
    private final boolean _systemUtf8 = XmlUtils.isSystemUtf8();

    public void appendByte(byte by) {
        if (this._currPos >= this._bytes.length) {
            byte[] byArray = new byte[this._bytes.length * 2];
            System.arraycopy(this._bytes, 0, byArray, 0, this._bytes.length);
            this._bytes = byArray;
        }
        this._bytes[this._currPos] = by;
        ++this._currPos;
    }

    public void clear() {
        this._currPos = 0;
        if (this._bytes.length > 5000) {
            this._bytes = new byte[1024];
        }
    }

    public void setEncodingUtf8() {
        this._streamUtf8 = true;
    }

    public String toString() {
        if (this._streamUtf8 && !this._systemUtf8) {
            return new String(this._bytes, 0, this._currPos, Charset.forName("UTF-8"));
        }
        return new String(this._bytes, 0, this._currPos);
    }

    public boolean foundSequence(char[] cArray) {
        int n = cArray.length;
        if (this._currPos < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n - 1 - n2];
            char c2 = (char)this._bytes[this._currPos - 1 - n2];
            if (c != c2) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

