/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.annotations;

import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttribute;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AnnotationsList
implements IAttribute {
    private final Map<String, IAnnotation> map;

    public static void attach(ICodeNode node, List<IAnnotation> annotationList) {
        AnnotationsList attrList = AnnotationsList.pack(annotationList);
        if (attrList != null) {
            node.addAttr(attrList);
        }
    }

    @Nullable
    public static AnnotationsList pack(List<IAnnotation> annotationList) {
        if (annotationList.isEmpty()) {
            return null;
        }
        HashMap<String, IAnnotation> annMap = new HashMap<String, IAnnotation>(annotationList.size());
        for (IAnnotation ann : annotationList) {
            annMap.put(ann.getAnnotationClass(), ann);
        }
        return new AnnotationsList(annMap);
    }

    public AnnotationsList(Map<String, IAnnotation> map) {
        this.map = map;
    }

    public IAnnotation get(String className) {
        return this.map.get(className);
    }

    public Collection<IAnnotation> getAll() {
        return this.map.values();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public AType<AnnotationsList> getType() {
        return AType.ANNOTATION_LIST;
    }

    public String toString() {
        return Utils.listToString(this.map.values());
    }
}

