/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.utils.ErrorsCounter;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationAttrNode
extends LineAttrNode
implements ICodeNode {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationAttrNode.class);

    public void addError(String errStr, Throwable e) {
        ErrorsCounter.error(this, errStr, e);
    }

    public void addWarn(String warnStr) {
        ErrorsCounter.warning(this, warnStr);
    }

    public void addWarnComment(String warn) {
        this.addWarnComment(warn, null);
    }

    public void addWarnComment(String warn, @Nullable Throwable exc) {
        String commentStr = "JADX WARN: " + warn;
        this.addAttr(AType.COMMENTS, commentStr);
        if (exc != null) {
            LOG.warn("{} in {}", new Object[]{warn, this, exc});
        } else {
            LOG.warn("{} in {}", (Object)warn, (Object)this);
        }
    }

    public void addComment(String commentStr) {
        this.addAttr(AType.COMMENTS, commentStr);
        LOG.info("{} in {}", (Object)commentStr, (Object)this);
    }

    public void addDebugComment(String commentStr) {
        this.addAttr(AType.COMMENTS, "JADX DEBUG: " + commentStr);
        LOG.debug("{} in {}", (Object)commentStr, (Object)this);
    }
}

