/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import javax.annotation.Nonnull;

class BufferSegment
implements CharSequence {
    private final char[] data;
    private final int offset;
    private final int len;
    private final BufferSegment next;

    public BufferSegment(char[] cArray, int n, int n2) {
        this(cArray, n, n2, null);
    }

    public BufferSegment(char[] cArray, int n, int n2, BufferSegment bufferSegment) {
        this.data = cArray;
        this.offset = n;
        this.len = n2;
        this.next = bufferSegment;
    }

    @Override
    public char charAt(int n) {
        if (n < this.len) {
            return this.data[this.offset + n];
        }
        if (this.next != null) {
            return this.next.charAt(n - this.len);
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public int length() {
        return this.len + (this.next != null ? this.next.length() : 0);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.subSegment(n, n2);
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    private void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.data, this.offset, this.len);
        if (this.next != null) {
            this.next.toString(stringBuilder);
        }
    }

    private BufferSegment subSegment(int n, int n2) {
        if (0 <= n && n <= n2) {
            if (n2 <= this.len) {
                return new BufferSegment(this.data, this.offset + n, n2 - n);
            }
            if (this.next != null) {
                if (n < this.len) {
                    return new BufferSegment(this.data, this.offset + n, this.len - n, this.next.subSegment(0, n2 - this.len));
                }
                return this.next.subSegment(n - this.len, n2 - this.len);
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

