/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.helpers;

import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.osmand.PlatformUtil;
import org.apache.commons.logging.Log;

public class Kml2Gpx {
    public static final Log LOG = PlatformUtil.getLog(Kml2Gpx.class);

    public static String toGpx(InputStream kml) {
        try {
            StreamSource xmlSource = new StreamSource(kml);
            StreamSource xsltSource = new StreamSource(Kml2Gpx.class.getResourceAsStream("kml2gpx.xslt"));
            StringWriter sw = new StringWriter();
            TransformerFactory.newInstance().newTransformer(xsltSource).transform(xmlSource, new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerConfigurationException e) {
            LOG.error((Object)e.toString(), (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            LOG.error((Object)e.toString(), (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error((Object)e.toString(), (Throwable)e);
        }
        return null;
    }
}

