# Generated by ffi_gen. Please do not change this file by hand.

require 'ffi'

module Aubio::Api
  extend FFI::Library
  lib_paths = Array(ENV["AUBIO_LIB"] || Dir["/{opt,usr}/{,local/}{lib,lib64,Cellar/aubio**,lib/arm-linux-gnueabihf}/libaubio.{*.dylib,so.*}"])
  fallback_names = %w(libaubio.4.2.2.dylib libaubio.so.1 aubio1.dll libaubio-5.dll)
  ffi_lib(lib_paths + fallback_names)

  def self.attach_function(name, *_)
    begin; super; rescue FFI::NotFoundError => e
      (class << self; self; end).class_eval { define_method(name) { |*_| raise e } }
    end
  end

  HAVE_AUBIO_DOUBLE = 0

  AUBIO_SMPL_FMT = "%f"

  AUBIO_LSMP_FMT = "%lf"

  # (Not documented)
  #
  # = Fields:
  # :length ::
  #   (Integer) < length of buffer
  # :data ::
  #   (FFI::Pointer(*SmplT)) < data vector of length ::fvec_t.length
  class FvecT < FFI::Struct
    layout :length, :uint,
           :data, :pointer
  end

  # (Not documented)
  #
  # @method new_fvec(length)
  # @param [Integer] length
  # @return [FvecT]
  # @scope class
  attach_function :new_fvec, :new_fvec, [:uint], FvecT

  # (Not documented)
  #
  # @method del_fvec(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :del_fvec, :del_fvec, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_get_sample(s, position)
  # @param [FvecT] s
  # @param [Integer] position
  # @return [Float]
  # @scope class
  attach_function :fvec_get_sample, :fvec_get_sample, [FvecT, :uint], :float

  # (Not documented)
  #
  # @method fvec_set_sample(s, data, position)
  # @param [FvecT] s
  # @param [Float] data
  # @param [Integer] position
  # @return [nil]
  # @scope class
  attach_function :fvec_set_sample, :fvec_set_sample, [FvecT, :float, :uint], :void

  # (Not documented)
  #
  # @method fvec_get_data(s)
  # @param [FvecT] s
  # @return [FFI::Pointer(*SmplT)]
  # @scope class
  attach_function :fvec_get_data, :fvec_get_data, [FvecT], :pointer

  # (Not documented)
  #
  # @method fvec_print(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_print, :fvec_print, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_set_all(s, val)
  # @param [FvecT] s
  # @param [Float] val
  # @return [nil]
  # @scope class
  attach_function :fvec_set_all, :fvec_set_all, [FvecT, :float], :void

  # (Not documented)
  #
  # @method fvec_zeros(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_zeros, :fvec_zeros, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_ones(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_ones, :fvec_ones, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_rev(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_rev, :fvec_rev, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_weight(s, weight)
  # @param [FvecT] s
  # @param [FvecT] weight
  # @return [nil]
  # @scope class
  attach_function :fvec_weight, :fvec_weight, [FvecT, FvecT], :void

  # (Not documented)
  #
  # @method fvec_copy(s, t)
  # @param [FvecT] s
  # @param [FvecT] t
  # @return [nil]
  # @scope class
  attach_function :fvec_copy, :fvec_copy, [FvecT, FvecT], :void

  # (Not documented)
  #
  # @method fvec_weighted_copy(in_, weight, out)
  # @param [FvecT] in_
  # @param [FvecT] weight
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :fvec_weighted_copy, :fvec_weighted_copy, [FvecT, FvecT, FvecT], :void

  # (Not documented)
  #
  # = Fields:
  # :length ::
  #   (Integer) < length of buffer = (requested length)/2 + 1
  # :norm ::
  #   (FFI::Pointer(*SmplT)) < norm array of size ::cvec_t.length
  # :phas ::
  #   (FFI::Pointer(*SmplT)) < phase array of size ::cvec_t.length
  class CvecT < FFI::Struct
    layout :length, :uint,
           :norm, :pointer,
           :phas, :pointer
  end

  # (Not documented)
  #
  # @method new_cvec(length)
  # @param [Integer] length
  # @return [CvecT]
  # @scope class
  attach_function :new_cvec, :new_cvec, [:uint], CvecT

  # (Not documented)
  #
  # @method del_cvec(s)
  # @param [CvecT] s
  # @return [nil]
  # @scope class
  attach_function :del_cvec, :del_cvec, [CvecT], :void

  # (Not documented)
  #
  # @method cvec_norm_set_sample(s, val, position)
  # @param [CvecT] s
  # @param [Float] val
  # @param [Integer] position
  # @return [nil]
  # @scope class
  attach_function :cvec_norm_set_sample, :cvec_norm_set_sample, [CvecT, :float, :uint], :void

  # (Not documented)
  #
  # @method cvec_phas_set_sample(s, val, position)
  # @param [CvecT] s
  # @param [Float] val
  # @param [Integer] position
  # @return [nil]
  # @scope class
  attach_function :cvec_phas_set_sample, :cvec_phas_set_sample, [CvecT, :float, :uint], :void

  # (Not documented)
  #
  # @method cvec_norm_get_sample(s, position)
  # @param [CvecT] s
  # @param [Integer] position
  # @return [Float]
  # @scope class
  attach_function :cvec_norm_get_sample, :cvec_norm_get_sample, [CvecT, :uint], :float

  # (Not documented)
  #
  # @method cvec_phas_get_sample(s, position)
  # @param [CvecT] s
  # @param [Integer] position
  # @return [Float]
  # @scope class
  attach_function :cvec_phas_get_sample, :cvec_phas_get_sample, [CvecT, :uint], :float

  # (Not documented)
  #
  # @method cvec_norm_get_data(s)
  # @param [CvecT] s
  # @return [FFI::Pointer(*SmplT)]
  # @scope class
  attach_function :cvec_norm_get_data, :cvec_norm_get_data, [CvecT], :pointer

  # (Not documented)
  #
  # @method cvec_phas_get_data(s)
  # @param [CvecT] s
  # @return [FFI::Pointer(*SmplT)]
  # @scope class
  attach_function :cvec_phas_get_data, :cvec_phas_get_data, [CvecT], :pointer

  # (Not documented)
  #
  # @method cvec_print(s)
  # @param [CvecT] s
  # @return [nil]
  # @scope class
  attach_function :cvec_print, :cvec_print, [CvecT], :void

  # (Not documented)
  #
  # @method cvec_copy(s, t)
  # @param [CvecT] s
  # @param [CvecT] t
  # @return [nil]
  # @scope class
  attach_function :cvec_copy, :cvec_copy, [CvecT, CvecT], :void

  # (Not documented)
  #
  # @method cvec_norm_set_all(s, val)
  # @param [CvecT] s
  # @param [Float] val
  # @return [nil]
  # @scope class
  attach_function :cvec_norm_set_all, :cvec_norm_set_all, [CvecT, :float], :void

  # (Not documented)
  #
  # @method cvec_norm_zeros(s)
  # @param [CvecT] s
  # @return [nil]
  # @scope class
  attach_function :cvec_norm_zeros, :cvec_norm_zeros, [CvecT], :void

  # (Not documented)
  #
  # @method cvec_norm_ones(s)
  # @param [CvecT] s
  # @return [nil]
  # @scope class
  attach_function :cvec_norm_ones, :cvec_norm_ones, [CvecT], :void

  # (Not documented)
  #
  # @method cvec_phas_set_all(s, val)
  # @param [CvecT] s
  # @param [Float] val
  # @return [nil]
  # @scope class
  attach_function :cvec_phas_set_all, :cvec_phas_set_all, [CvecT, :float], :void

  # (Not documented)
  #
  # @method cvec_phas_zeros(s)
  # @param [CvecT] s
  # @return [nil]
  # @scope class
  attach_function :cvec_phas_zeros, :cvec_phas_zeros, [CvecT], :void

  # (Not documented)
  #
  # @method cvec_phas_ones(s)
  # @param [CvecT] s
  # @return [nil]
  # @scope class
  attach_function :cvec_phas_ones, :cvec_phas_ones, [CvecT], :void

  # (Not documented)
  #
  # @method cvec_zeros(s)
  # @param [CvecT] s
  # @return [nil]
  # @scope class
  attach_function :cvec_zeros, :cvec_zeros, [CvecT], :void

  # (Not documented)
  #
  # = Fields:
  # :length ::
  #   (Integer) < length of buffer
  # :data ::
  #   (FFI::Pointer(*LsmpT)) < data array of size (length)
  class LvecT < FFI::Struct
    layout :length, :uint,
           :data, :pointer
  end

  # (Not documented)
  #
  # @method new_lvec(length)
  # @param [Integer] length
  # @return [LvecT]
  # @scope class
  attach_function :new_lvec, :new_lvec, [:uint], LvecT

  # (Not documented)
  #
  # @method del_lvec(s)
  # @param [LvecT] s
  # @return [nil]
  # @scope class
  attach_function :del_lvec, :del_lvec, [LvecT], :void

  # (Not documented)
  #
  # @method lvec_get_sample(s, position)
  # @param [LvecT] s
  # @param [Integer] position
  # @return [Float]
  # @scope class
  attach_function :lvec_get_sample, :lvec_get_sample, [LvecT, :uint], :double

  # (Not documented)
  #
  # @method lvec_set_sample(s, data, position)
  # @param [LvecT] s
  # @param [Float] data
  # @param [Integer] position
  # @return [nil]
  # @scope class
  attach_function :lvec_set_sample, :lvec_set_sample, [LvecT, :double, :uint], :void

  # (Not documented)
  #
  # @method lvec_get_data(s)
  # @param [LvecT] s
  # @return [FFI::Pointer(*LsmpT)]
  # @scope class
  attach_function :lvec_get_data, :lvec_get_data, [LvecT], :pointer

  # (Not documented)
  #
  # @method lvec_print(s)
  # @param [LvecT] s
  # @return [nil]
  # @scope class
  attach_function :lvec_print, :lvec_print, [LvecT], :void

  # (Not documented)
  #
  # @method lvec_set_all(s, val)
  # @param [LvecT] s
  # @param [Float] val
  # @return [nil]
  # @scope class
  attach_function :lvec_set_all, :lvec_set_all, [LvecT, :float], :void

  # (Not documented)
  #
  # @method lvec_zeros(s)
  # @param [LvecT] s
  # @return [nil]
  # @scope class
  attach_function :lvec_zeros, :lvec_zeros, [LvecT], :void

  # (Not documented)
  #
  # @method lvec_ones(s)
  # @param [LvecT] s
  # @return [nil]
  # @scope class
  attach_function :lvec_ones, :lvec_ones, [LvecT], :void

  # (Not documented)
  #
  # = Fields:
  # :length ::
  #   (Integer) < length of matrix
  # :height ::
  #   (Integer) < height of matrix
  # :data ::
  #   (FFI::Pointer(**SmplT)) < data array of size (length) * (height)
  class FmatT < FFI::Struct
    layout :length, :uint,
           :height, :uint,
           :data, :pointer
  end

  # (Not documented)
  #
  # @method new_fmat(height, length)
  # @param [Integer] height
  # @param [Integer] length
  # @return [FmatT]
  # @scope class
  attach_function :new_fmat, :new_fmat, [:uint, :uint], FmatT

  # (Not documented)
  #
  # @method del_fmat(s)
  # @param [FmatT] s
  # @return [nil]
  # @scope class
  attach_function :del_fmat, :del_fmat, [FmatT], :void

  # (Not documented)
  #
  # @method fmat_get_sample(s, channel, position)
  # @param [FmatT] s
  # @param [Integer] channel
  # @param [Integer] position
  # @return [Float]
  # @scope class
  attach_function :fmat_get_sample, :fmat_get_sample, [FmatT, :uint, :uint], :float

  # (Not documented)
  #
  # @method fmat_set_sample(s, data, channel, position)
  # @param [FmatT] s
  # @param [Float] data
  # @param [Integer] channel
  # @param [Integer] position
  # @return [nil]
  # @scope class
  attach_function :fmat_set_sample, :fmat_set_sample, [FmatT, :float, :uint, :uint], :void

  # (Not documented)
  #
  # @method fmat_get_channel(s, channel, output)
  # @param [FmatT] s
  # @param [Integer] channel
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :fmat_get_channel, :fmat_get_channel, [FmatT, :uint, FvecT], :void

  # (Not documented)
  #
  # @method fmat_get_channel_data(s, channel)
  # @param [FmatT] s
  # @param [Integer] channel
  # @return [FFI::Pointer(*SmplT)]
  # @scope class
  attach_function :fmat_get_channel_data, :fmat_get_channel_data, [FmatT, :uint], :pointer

  # (Not documented)
  #
  # @method fmat_get_data(s)
  # @param [FmatT] s
  # @return [FFI::Pointer(**SmplT)]
  # @scope class
  attach_function :fmat_get_data, :fmat_get_data, [FmatT], :pointer

  # (Not documented)
  #
  # @method fmat_print(s)
  # @param [FmatT] s
  # @return [nil]
  # @scope class
  attach_function :fmat_print, :fmat_print, [FmatT], :void

  # (Not documented)
  #
  # @method fmat_set(s, val)
  # @param [FmatT] s
  # @param [Float] val
  # @return [nil]
  # @scope class
  attach_function :fmat_set, :fmat_set, [FmatT, :float], :void

  # (Not documented)
  #
  # @method fmat_zeros(s)
  # @param [FmatT] s
  # @return [nil]
  # @scope class
  attach_function :fmat_zeros, :fmat_zeros, [FmatT], :void

  # (Not documented)
  #
  # @method fmat_ones(s)
  # @param [FmatT] s
  # @return [nil]
  # @scope class
  attach_function :fmat_ones, :fmat_ones, [FmatT], :void

  # (Not documented)
  #
  # @method fmat_rev(s)
  # @param [FmatT] s
  # @return [nil]
  # @scope class
  attach_function :fmat_rev, :fmat_rev, [FmatT], :void

  # (Not documented)
  #
  # @method fmat_weight(s, weight)
  # @param [FmatT] s
  # @param [FmatT] weight
  # @return [nil]
  # @scope class
  attach_function :fmat_weight, :fmat_weight, [FmatT, FmatT], :void

  # (Not documented)
  #
  # @method fmat_copy(s, t)
  # @param [FmatT] s
  # @param [FmatT] t
  # @return [nil]
  # @scope class
  attach_function :fmat_copy, :fmat_copy, [FmatT, FmatT], :void

  # (Not documented)
  #
  # @method fmat_vecmul(s, scale, output)
  # @param [FmatT] s
  # @param [FvecT] scale
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :fmat_vecmul, :fmat_vecmul, [FmatT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method new_aubio_window(window_type, size)
  # @param [String] window_type
  # @param [Integer] size
  # @return [FvecT]
  # @scope class
  attach_function :new_aubio_window, :new_aubio_window, [:string, :uint], FvecT

  # (Not documented)
  #
  # @method fvec_set_window(window, window_type)
  # @param [FvecT] window
  # @param [String] window_type
  # @return [Integer]
  # @scope class
  attach_function :fvec_set_window, :fvec_set_window, [FvecT, :string], :uint

  # (Not documented)
  #
  # @method aubio_unwrap2pi(phase)
  # @param [Float] phase
  # @return [Float]
  # @scope class
  attach_function :aubio_unwrap2pi, :aubio_unwrap2pi, [:float], :float

  # (Not documented)
  #
  # @method aubio_bintomidi(bin, samplerate, fftsize)
  # @param [Float] bin
  # @param [Float] samplerate
  # @param [Float] fftsize
  # @return [Float]
  # @scope class
  attach_function :aubio_bintomidi, :aubio_bintomidi, [:float, :float, :float], :float

  # (Not documented)
  #
  # @method aubio_miditobin(midi, samplerate, fftsize)
  # @param [Float] midi
  # @param [Float] samplerate
  # @param [Float] fftsize
  # @return [Float]
  # @scope class
  attach_function :aubio_miditobin, :aubio_miditobin, [:float, :float, :float], :float

  # (Not documented)
  #
  # @method aubio_bintofreq(bin, samplerate, fftsize)
  # @param [Float] bin
  # @param [Float] samplerate
  # @param [Float] fftsize
  # @return [Float]
  # @scope class
  attach_function :aubio_bintofreq, :aubio_bintofreq, [:float, :float, :float], :float

  # (Not documented)
  #
  # @method aubio_freqtobin(freq, samplerate, fftsize)
  # @param [Float] freq
  # @param [Float] samplerate
  # @param [Float] fftsize
  # @return [Float]
  # @scope class
  attach_function :aubio_freqtobin, :aubio_freqtobin, [:float, :float, :float], :float

  # (Not documented)
  #
  # @method aubio_freqtomidi(freq)
  # @param [Float] freq
  # @return [Float]
  # @scope class
  attach_function :aubio_freqtomidi, :aubio_freqtomidi, [:float], :float

  # (Not documented)
  #
  # @method aubio_miditofreq(midi)
  # @param [Float] midi
  # @return [Float]
  # @scope class
  attach_function :aubio_miditofreq, :aubio_miditofreq, [:float], :float

  # (Not documented)
  #
  # @method aubio_cleanup()
  # @return [nil]
  # @scope class
  attach_function :aubio_cleanup, :aubio_cleanup, [], :void

  # (Not documented)
  #
  # @method aubio_zero_crossing_rate(v)
  # @param [FvecT] v
  # @return [Float]
  # @scope class
  attach_function :aubio_zero_crossing_rate, :aubio_zero_crossing_rate, [FvecT], :float

  # (Not documented)
  #
  # @method aubio_level_lin(v)
  # @param [FvecT] v
  # @return [Float]
  # @scope class
  attach_function :aubio_level_lin, :aubio_level_lin, [FvecT], :float

  # (Not documented)
  #
  # @method aubio_db_spl(v)
  # @param [FvecT] v
  # @return [Float]
  # @scope class
  attach_function :aubio_db_spl, :aubio_db_spl, [FvecT], :float

  # (Not documented)
  #
  # @method aubio_silence_detection(v, threshold)
  # @param [FvecT] v
  # @param [Float] threshold
  # @return [Integer]
  # @scope class
  attach_function :aubio_silence_detection, :aubio_silence_detection, [FvecT, :float], :uint

  # (Not documented)
  #
  # @method aubio_level_detection(v, threshold)
  # @param [FvecT] v
  # @param [Float] threshold
  # @return [Float]
  # @scope class
  attach_function :aubio_level_detection, :aubio_level_detection, [FvecT, :float], :float

  # (Not documented)
  #
  # @method fvec_exp(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_exp, :fvec_exp, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_cos(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_cos, :fvec_cos, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_sin(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_sin, :fvec_sin, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_abs(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_abs, :fvec_abs, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_sqrt(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_sqrt, :fvec_sqrt, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_log10(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_log10, :fvec_log10, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_log(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_log, :fvec_log, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_floor(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_floor, :fvec_floor, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_ceil(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_ceil, :fvec_ceil, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_round(s)
  # @param [FvecT] s
  # @return [nil]
  # @scope class
  attach_function :fvec_round, :fvec_round, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_pow(s, pow)
  # @param [FvecT] s
  # @param [Float] pow
  # @return [nil]
  # @scope class
  attach_function :fvec_pow, :fvec_pow, [FvecT, :float], :void

  # (Not documented)
  class AubioResamplerT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_resampler(ratio, type)
  # @param [Float] ratio
  # @param [Integer] type
  # @return [AubioResamplerT]
  # @scope class
  attach_function :new_aubio_resampler, :new_aubio_resampler, [:float, :uint], AubioResamplerT

  # (Not documented)
  #
  # @method del_aubio_resampler(s)
  # @param [AubioResamplerT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_resampler, :del_aubio_resampler, [AubioResamplerT], :void

  # (Not documented)
  #
  # @method aubio_resampler_do(s, input, output)
  # @param [AubioResamplerT] s
  # @param [FvecT] input
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_resampler_do, :aubio_resampler_do, [AubioResamplerT, FvecT, FvecT], :void

  # (Not documented)
  class AubioFilterT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_filter_do(f, in_)
  # @param [AubioFilterT] f
  # @param [FvecT] in_
  # @return [nil]
  # @scope class
  attach_function :aubio_filter_do, :aubio_filter_do, [AubioFilterT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_filter_do_outplace(f, in_, out)
  # @param [AubioFilterT] f
  # @param [FvecT] in_
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :aubio_filter_do_outplace, :aubio_filter_do_outplace, [AubioFilterT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_filter_do_filtfilt(f, in_, tmp)
  # @param [AubioFilterT] f
  # @param [FvecT] in_
  # @param [FvecT] tmp
  # @return [nil]
  # @scope class
  attach_function :aubio_filter_do_filtfilt, :aubio_filter_do_filtfilt, [AubioFilterT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_filter_get_feedback(f)
  # @param [AubioFilterT] f
  # @return [LvecT]
  # @scope class
  attach_function :aubio_filter_get_feedback, :aubio_filter_get_feedback, [AubioFilterT], LvecT

  # (Not documented)
  #
  # @method aubio_filter_get_feedforward(f)
  # @param [AubioFilterT] f
  # @return [LvecT]
  # @scope class
  attach_function :aubio_filter_get_feedforward, :aubio_filter_get_feedforward, [AubioFilterT], LvecT

  # (Not documented)
  #
  # @method aubio_filter_get_order(f)
  # @param [AubioFilterT] f
  # @return [Integer]
  # @scope class
  attach_function :aubio_filter_get_order, :aubio_filter_get_order, [AubioFilterT], :uint

  # (Not documented)
  #
  # @method aubio_filter_get_samplerate(f)
  # @param [AubioFilterT] f
  # @return [Integer]
  # @scope class
  attach_function :aubio_filter_get_samplerate, :aubio_filter_get_samplerate, [AubioFilterT], :uint

  # (Not documented)
  #
  # @method aubio_filter_set_samplerate(f, samplerate)
  # @param [AubioFilterT] f
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_filter_set_samplerate, :aubio_filter_set_samplerate, [AubioFilterT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_filter_do_reset(f)
  # @param [AubioFilterT] f
  # @return [nil]
  # @scope class
  attach_function :aubio_filter_do_reset, :aubio_filter_do_reset, [AubioFilterT], :void

  # (Not documented)
  #
  # @method new_aubio_filter(order)
  # @param [Integer] order
  # @return [AubioFilterT]
  # @scope class
  attach_function :new_aubio_filter, :new_aubio_filter, [:uint], AubioFilterT

  # (Not documented)
  #
  # @method del_aubio_filter(f)
  # @param [AubioFilterT] f
  # @return [nil]
  # @scope class
  attach_function :del_aubio_filter, :del_aubio_filter, [AubioFilterT], :void

  # (Not documented)
  #
  # @method aubio_filter_set_biquad(f, b0, b1, b2, a1, a2)
  # @param [AubioFilterT] f
  # @param [Float] b0
  # @param [Float] b1
  # @param [Float] b2
  # @param [Float] a1
  # @param [Float] a2
  # @return [Integer]
  # @scope class
  attach_function :aubio_filter_set_biquad, :aubio_filter_set_biquad, [AubioFilterT, :double, :double, :double, :double, :double], :uint

  # (Not documented)
  #
  # @method new_aubio_filter_biquad(b0, b1, b2, a1, a2)
  # @param [Float] b0
  # @param [Float] b1
  # @param [Float] b2
  # @param [Float] a1
  # @param [Float] a2
  # @return [AubioFilterT]
  # @scope class
  attach_function :new_aubio_filter_biquad, :new_aubio_filter_biquad, [:double, :double, :double, :double, :double], AubioFilterT

  # (Not documented)
  #
  # @method new_aubio_filter_a_weighting(samplerate)
  # @param [Integer] samplerate
  # @return [AubioFilterT]
  # @scope class
  attach_function :new_aubio_filter_a_weighting, :new_aubio_filter_a_weighting, [:uint], AubioFilterT

  # (Not documented)
  #
  # @method aubio_filter_set_a_weighting(f, samplerate)
  # @param [AubioFilterT] f
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_filter_set_a_weighting, :aubio_filter_set_a_weighting, [AubioFilterT, :uint], :uint

  # (Not documented)
  #
  # @method new_aubio_filter_c_weighting(samplerate)
  # @param [Integer] samplerate
  # @return [AubioFilterT]
  # @scope class
  attach_function :new_aubio_filter_c_weighting, :new_aubio_filter_c_weighting, [:uint], AubioFilterT

  # (Not documented)
  #
  # @method aubio_filter_set_c_weighting(f, samplerate)
  # @param [AubioFilterT] f
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_filter_set_c_weighting, :aubio_filter_set_c_weighting, [AubioFilterT, :uint], :uint

  # (Not documented)
  class AubioFftT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_fft(size)
  # @param [Integer] size
  # @return [AubioFftT]
  # @scope class
  attach_function :new_aubio_fft, :new_aubio_fft, [:uint], AubioFftT

  # (Not documented)
  #
  # @method del_aubio_fft(s)
  # @param [AubioFftT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_fft, :del_aubio_fft, [AubioFftT], :void

  # (Not documented)
  #
  # @method aubio_fft_do(s, input, spectrum)
  # @param [AubioFftT] s
  # @param [FvecT] input
  # @param [CvecT] spectrum
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_do, :aubio_fft_do, [AubioFftT, FvecT, CvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_rdo(s, spectrum, output)
  # @param [AubioFftT] s
  # @param [CvecT] spectrum
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_rdo, :aubio_fft_rdo, [AubioFftT, CvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_do_complex(s, input, compspec)
  # @param [AubioFftT] s
  # @param [FvecT] input
  # @param [FvecT] compspec
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_do_complex, :aubio_fft_do_complex, [AubioFftT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_rdo_complex(s, compspec, output)
  # @param [AubioFftT] s
  # @param [FvecT] compspec
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_rdo_complex, :aubio_fft_rdo_complex, [AubioFftT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_get_spectrum(compspec, spectrum)
  # @param [FvecT] compspec
  # @param [CvecT] spectrum
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_get_spectrum, :aubio_fft_get_spectrum, [FvecT, CvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_get_realimag(spectrum, compspec)
  # @param [CvecT] spectrum
  # @param [FvecT] compspec
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_get_realimag, :aubio_fft_get_realimag, [CvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_get_phas(compspec, spectrum)
  # @param [FvecT] compspec
  # @param [CvecT] spectrum
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_get_phas, :aubio_fft_get_phas, [FvecT, CvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_get_imag(spectrum, compspec)
  # @param [CvecT] spectrum
  # @param [FvecT] compspec
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_get_imag, :aubio_fft_get_imag, [CvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_get_norm(compspec, spectrum)
  # @param [FvecT] compspec
  # @param [CvecT] spectrum
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_get_norm, :aubio_fft_get_norm, [FvecT, CvecT], :void

  # (Not documented)
  #
  # @method aubio_fft_get_real(spectrum, compspec)
  # @param [CvecT] spectrum
  # @param [FvecT] compspec
  # @return [nil]
  # @scope class
  attach_function :aubio_fft_get_real, :aubio_fft_get_real, [CvecT, FvecT], :void

  # (Not documented)
  class AubioPvocT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_pvoc(win_s, hop_s)
  # @param [Integer] win_s
  # @param [Integer] hop_s
  # @return [AubioPvocT]
  # @scope class
  attach_function :new_aubio_pvoc, :new_aubio_pvoc, [:uint, :uint], AubioPvocT

  # (Not documented)
  #
  # @method del_aubio_pvoc(pv)
  # @param [AubioPvocT] pv
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pvoc, :del_aubio_pvoc, [AubioPvocT], :void

  # (Not documented)
  #
  # @method aubio_pvoc_do(pv, in_, fftgrain)
  # @param [AubioPvocT] pv
  # @param [FvecT] in_
  # @param [CvecT] fftgrain
  # @return [nil]
  # @scope class
  attach_function :aubio_pvoc_do, :aubio_pvoc_do, [AubioPvocT, FvecT, CvecT], :void

  # (Not documented)
  #
  # @method aubio_pvoc_rdo(pv, fftgrain, out)
  # @param [AubioPvocT] pv
  # @param [CvecT] fftgrain
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :aubio_pvoc_rdo, :aubio_pvoc_rdo, [AubioPvocT, CvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_pvoc_get_win(pv)
  # @param [AubioPvocT] pv
  # @return [Integer]
  # @scope class
  attach_function :aubio_pvoc_get_win, :aubio_pvoc_get_win, [AubioPvocT], :uint

  # (Not documented)
  #
  # @method aubio_pvoc_get_hop(pv)
  # @param [AubioPvocT] pv
  # @return [Integer]
  # @scope class
  attach_function :aubio_pvoc_get_hop, :aubio_pvoc_get_hop, [AubioPvocT], :uint

  # (Not documented)
  class AubioFilterbankT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_filterbank(n_filters, win_s)
  # @param [Integer] n_filters
  # @param [Integer] win_s
  # @return [AubioFilterbankT]
  # @scope class
  attach_function :new_aubio_filterbank, :new_aubio_filterbank, [:uint, :uint], AubioFilterbankT

  # (Not documented)
  #
  # @method del_aubio_filterbank(f)
  # @param [AubioFilterbankT] f
  # @return [nil]
  # @scope class
  attach_function :del_aubio_filterbank, :del_aubio_filterbank, [AubioFilterbankT], :void

  # (Not documented)
  #
  # @method aubio_filterbank_do(f, in_, out)
  # @param [AubioFilterbankT] f
  # @param [CvecT] in_
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :aubio_filterbank_do, :aubio_filterbank_do, [AubioFilterbankT, CvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_filterbank_get_coeffs(f)
  # @param [AubioFilterbankT] f
  # @return [FmatT]
  # @scope class
  attach_function :aubio_filterbank_get_coeffs, :aubio_filterbank_get_coeffs, [AubioFilterbankT], FmatT

  # (Not documented)
  #
  # @method aubio_filterbank_set_coeffs(f, filters)
  # @param [AubioFilterbankT] f
  # @param [FmatT] filters
  # @return [Integer]
  # @scope class
  attach_function :aubio_filterbank_set_coeffs, :aubio_filterbank_set_coeffs, [AubioFilterbankT, FmatT], :uint

  # (Not documented)
  #
  # @method aubio_filterbank_set_triangle_bands(fb, freqs, samplerate)
  # @param [AubioFilterbankT] fb
  # @param [FvecT] freqs
  # @param [Float] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_filterbank_set_triangle_bands, :aubio_filterbank_set_triangle_bands, [AubioFilterbankT, FvecT, :float], :uint

  # (Not documented)
  #
  # @method aubio_filterbank_set_mel_coeffs_slaney(fb, samplerate)
  # @param [AubioFilterbankT] fb
  # @param [Float] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_filterbank_set_mel_coeffs_slaney, :aubio_filterbank_set_mel_coeffs_slaney, [AubioFilterbankT, :float], :uint

  # (Not documented)
  class AubioMfccT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_mfcc(buf_size, n_filters, n_coeffs, samplerate)
  # @param [Integer] buf_size
  # @param [Integer] n_filters
  # @param [Integer] n_coeffs
  # @param [Integer] samplerate
  # @return [AubioMfccT]
  # @scope class
  attach_function :new_aubio_mfcc, :new_aubio_mfcc, [:uint, :uint, :uint, :uint], AubioMfccT

  # (Not documented)
  #
  # @method del_aubio_mfcc(mf)
  # @param [AubioMfccT] mf
  # @return [nil]
  # @scope class
  attach_function :del_aubio_mfcc, :del_aubio_mfcc, [AubioMfccT], :void

  # (Not documented)
  #
  # @method aubio_mfcc_do(mf, in_, out)
  # @param [AubioMfccT] mf
  # @param [CvecT] in_
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :aubio_mfcc_do, :aubio_mfcc_do, [AubioMfccT, CvecT, FvecT], :void

  # (Not documented)
  class AubioSpecdescT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_specdesc_do(o, fftgrain, desc)
  # @param [AubioSpecdescT] o
  # @param [CvecT] fftgrain
  # @param [FvecT] desc
  # @return [nil]
  # @scope class
  attach_function :aubio_specdesc_do, :aubio_specdesc_do, [AubioSpecdescT, CvecT, FvecT], :void

  # (Not documented)
  #
  # @method new_aubio_specdesc(method, buf_size)
  # @param [String] method
  # @param [Integer] buf_size
  # @return [AubioSpecdescT]
  # @scope class
  attach_function :new_aubio_specdesc, :new_aubio_specdesc, [:string, :uint], AubioSpecdescT

  # (Not documented)
  #
  # @method del_aubio_specdesc(o)
  # @param [AubioSpecdescT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_specdesc, :del_aubio_specdesc, [AubioSpecdescT], :void

  # (Not documented)
  class AubioTssT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_tss(buf_size, hop_size)
  # @param [Integer] buf_size
  # @param [Integer] hop_size
  # @return [AubioTssT]
  # @scope class
  attach_function :new_aubio_tss, :new_aubio_tss, [:uint, :uint], AubioTssT

  # (Not documented)
  #
  # @method del_aubio_tss(o)
  # @param [AubioTssT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_tss, :del_aubio_tss, [AubioTssT], :void

  # (Not documented)
  #
  # @method aubio_tss_do(o, input, trans, stead)
  # @param [AubioTssT] o
  # @param [CvecT] input
  # @param [CvecT] trans
  # @param [CvecT] stead
  # @return [nil]
  # @scope class
  attach_function :aubio_tss_do, :aubio_tss_do, [AubioTssT, CvecT, CvecT, CvecT], :void

  # (Not documented)
  #
  # @method aubio_tss_set_threshold(o, thrs)
  # @param [AubioTssT] o
  # @param [Float] thrs
  # @return [Integer]
  # @scope class
  attach_function :aubio_tss_set_threshold, :aubio_tss_set_threshold, [AubioTssT, :float], :uint

  # (Not documented)
  #
  # @method aubio_tss_set_alpha(o, alpha)
  # @param [AubioTssT] o
  # @param [Float] alpha
  # @return [Integer]
  # @scope class
  attach_function :aubio_tss_set_alpha, :aubio_tss_set_alpha, [AubioTssT, :float], :uint

  # (Not documented)
  #
  # @method aubio_tss_set_beta(o, beta)
  # @param [AubioTssT] o
  # @param [Float] beta
  # @return [Integer]
  # @scope class
  attach_function :aubio_tss_set_beta, :aubio_tss_set_beta, [AubioTssT, :float], :uint

  # (Not documented)
  class AubioPitchT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_pitch_do(o, in_, out)
  # @param [AubioPitchT] o
  # @param [FvecT] in_
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :aubio_pitch_do, :aubio_pitch_do, [AubioPitchT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_pitch_set_tolerance(o, tol)
  # @param [AubioPitchT] o
  # @param [Float] tol
  # @return [Integer]
  # @scope class
  attach_function :aubio_pitch_set_tolerance, :aubio_pitch_set_tolerance, [AubioPitchT, :float], :uint

  # (Not documented)
  #
  # @method aubio_pitch_get_tolerance(o)
  # @param [AubioPitchT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitch_get_tolerance, :aubio_pitch_get_tolerance, [AubioPitchT], :float

  # (Not documented)
  #
  # @method del_aubio_pitch(o)
  # @param [AubioPitchT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pitch, :del_aubio_pitch, [AubioPitchT], :void

  # (Not documented)
  #
  # @method new_aubio_pitch(method, buf_size, hop_size, samplerate)
  # @param [String] method
  # @param [Integer] buf_size
  # @param [Integer] hop_size
  # @param [Integer] samplerate
  # @return [AubioPitchT]
  # @scope class
  attach_function :new_aubio_pitch, :new_aubio_pitch, [:string, :uint, :uint, :uint], AubioPitchT

  # (Not documented)
  #
  # @method aubio_pitch_set_unit(o, mode)
  # @param [AubioPitchT] o
  # @param [String] mode
  # @return [Integer]
  # @scope class
  attach_function :aubio_pitch_set_unit, :aubio_pitch_set_unit, [AubioPitchT, :string], :uint

  # (Not documented)
  #
  # @method aubio_pitch_set_silence(o, silence)
  # @param [AubioPitchT] o
  # @param [Float] silence
  # @return [Integer]
  # @scope class
  attach_function :aubio_pitch_set_silence, :aubio_pitch_set_silence, [AubioPitchT, :float], :uint

  # (Not documented)
  #
  # @method aubio_pitch_get_silence(o)
  # @param [AubioPitchT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitch_get_silence, :aubio_pitch_get_silence, [AubioPitchT], :float

  # (Not documented)
  #
  # @method aubio_pitch_get_confidence(o)
  # @param [AubioPitchT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitch_get_confidence, :aubio_pitch_get_confidence, [AubioPitchT], :float

  # (Not documented)
  class AubioOnsetT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_onset(method, buf_size, hop_size, samplerate)
  # @param [String] method
  # @param [Integer] buf_size
  # @param [Integer] hop_size
  # @param [Integer] samplerate
  # @return [AubioOnsetT]
  # @scope class
  attach_function :new_aubio_onset, :new_aubio_onset, [:string, :uint, :uint, :uint], AubioOnsetT

  # (Not documented)
  #
  # @method aubio_onset_do(o, input, onset)
  # @param [AubioOnsetT] o
  # @param [FvecT] input
  # @param [FvecT] onset
  # @return [nil]
  # @scope class
  attach_function :aubio_onset_do, :aubio_onset_do, [AubioOnsetT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_onset_get_last(o)
  # @param [AubioOnsetT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_get_last, :aubio_onset_get_last, [AubioOnsetT], :uint

  # (Not documented)
  #
  # @method aubio_onset_get_last_s(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_last_s, :aubio_onset_get_last_s, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_get_last_ms(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_last_ms, :aubio_onset_get_last_ms, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_set_silence(o, silence)
  # @param [AubioOnsetT] o
  # @param [Float] silence
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_silence, :aubio_onset_set_silence, [AubioOnsetT, :float], :uint

  # (Not documented)
  #
  # @method aubio_onset_get_silence(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_silence, :aubio_onset_get_silence, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_get_descriptor(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_descriptor, :aubio_onset_get_descriptor, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_get_thresholded_descriptor(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_thresholded_descriptor, :aubio_onset_get_thresholded_descriptor, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_set_threshold(o, threshold)
  # @param [AubioOnsetT] o
  # @param [Float] threshold
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_threshold, :aubio_onset_set_threshold, [AubioOnsetT, :float], :uint

  # (Not documented)
  #
  # @method aubio_onset_set_minioi(o, minioi)
  # @param [AubioOnsetT] o
  # @param [Integer] minioi
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_minioi, :aubio_onset_set_minioi, [AubioOnsetT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_onset_set_minioi_s(o, minioi)
  # @param [AubioOnsetT] o
  # @param [Float] minioi
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_minioi_s, :aubio_onset_set_minioi_s, [AubioOnsetT, :float], :uint

  # (Not documented)
  #
  # @method aubio_onset_set_minioi_ms(o, minioi)
  # @param [AubioOnsetT] o
  # @param [Float] minioi
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_minioi_ms, :aubio_onset_set_minioi_ms, [AubioOnsetT, :float], :uint

  # (Not documented)
  #
  # @method aubio_onset_set_delay(o, delay)
  # @param [AubioOnsetT] o
  # @param [Integer] delay
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_delay, :aubio_onset_set_delay, [AubioOnsetT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_onset_set_delay_s(o, delay)
  # @param [AubioOnsetT] o
  # @param [Float] delay
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_delay_s, :aubio_onset_set_delay_s, [AubioOnsetT, :float], :uint

  # (Not documented)
  #
  # @method aubio_onset_set_delay_ms(o, delay)
  # @param [AubioOnsetT] o
  # @param [Float] delay
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_set_delay_ms, :aubio_onset_set_delay_ms, [AubioOnsetT, :float], :uint

  # (Not documented)
  #
  # @method aubio_onset_get_minioi(o)
  # @param [AubioOnsetT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_get_minioi, :aubio_onset_get_minioi, [AubioOnsetT], :uint

  # (Not documented)
  #
  # @method aubio_onset_get_minioi_s(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_minioi_s, :aubio_onset_get_minioi_s, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_get_minioi_ms(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_minioi_ms, :aubio_onset_get_minioi_ms, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_get_delay(o)
  # @param [AubioOnsetT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_onset_get_delay, :aubio_onset_get_delay, [AubioOnsetT], :uint

  # (Not documented)
  #
  # @method aubio_onset_get_delay_s(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_delay_s, :aubio_onset_get_delay_s, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_get_delay_ms(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_delay_ms, :aubio_onset_get_delay_ms, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method aubio_onset_get_threshold(o)
  # @param [AubioOnsetT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_onset_get_threshold, :aubio_onset_get_threshold, [AubioOnsetT], :float

  # (Not documented)
  #
  # @method del_aubio_onset(o)
  # @param [AubioOnsetT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_onset, :del_aubio_onset, [AubioOnsetT], :void

  # (Not documented)
  class AubioTempoT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_tempo(method, buf_size, hop_size, samplerate)
  # @param [String] method
  # @param [Integer] buf_size
  # @param [Integer] hop_size
  # @param [Integer] samplerate
  # @return [AubioTempoT]
  # @scope class
  attach_function :new_aubio_tempo, :new_aubio_tempo, [:string, :uint, :uint, :uint], AubioTempoT

  # (Not documented)
  #
  # @method aubio_tempo_do(o, input, tempo)
  # @param [AubioTempoT] o
  # @param [FvecT] input
  # @param [FvecT] tempo
  # @return [nil]
  # @scope class
  attach_function :aubio_tempo_do, :aubio_tempo_do, [AubioTempoT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_tempo_get_last(o)
  # @param [AubioTempoT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_get_last, :aubio_tempo_get_last, [AubioTempoT], :uint

  # (Not documented)
  #
  # @method aubio_tempo_get_last_s(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_last_s, :aubio_tempo_get_last_s, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_get_last_ms(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_last_ms, :aubio_tempo_get_last_ms, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_set_silence(o, silence)
  # @param [AubioTempoT] o
  # @param [Float] silence
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_set_silence, :aubio_tempo_set_silence, [AubioTempoT, :float], :uint

  # (Not documented)
  #
  # @method aubio_tempo_get_silence(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_silence, :aubio_tempo_get_silence, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_set_threshold(o, threshold)
  # @param [AubioTempoT] o
  # @param [Float] threshold
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_set_threshold, :aubio_tempo_set_threshold, [AubioTempoT, :float], :uint

  # (Not documented)
  #
  # @method aubio_tempo_get_threshold(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_threshold, :aubio_tempo_get_threshold, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_get_period(bt)
  # @param [AubioTempoT] bt
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_period, :aubio_tempo_get_period, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_get_period_s(bt)
  # @param [AubioTempoT] bt
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_period_s, :aubio_tempo_get_period_s, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_get_bpm(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_bpm, :aubio_tempo_get_bpm, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_get_confidence(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_confidence, :aubio_tempo_get_confidence, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_set_tatum_signature(o, signature)
  # @param [AubioTempoT] o
  # @param [Integer] signature
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_set_tatum_signature, :aubio_tempo_set_tatum_signature, [AubioTempoT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_tempo_was_tatum(o)
  # @param [AubioTempoT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_was_tatum, :aubio_tempo_was_tatum, [AubioTempoT], :uint

  # (Not documented)
  #
  # @method aubio_tempo_get_last_tatum(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_last_tatum, :aubio_tempo_get_last_tatum, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_get_delay(o)
  # @param [AubioTempoT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_get_delay, :aubio_tempo_get_delay, [AubioTempoT], :uint

  # (Not documented)
  #
  # @method aubio_tempo_get_delay_s(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_delay_s, :aubio_tempo_get_delay_s, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_get_delay_ms(o)
  # @param [AubioTempoT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_tempo_get_delay_ms, :aubio_tempo_get_delay_ms, [AubioTempoT], :float

  # (Not documented)
  #
  # @method aubio_tempo_set_delay(o, delay)
  # @param [AubioTempoT] o
  # @param [Integer] delay
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_set_delay, :aubio_tempo_set_delay, [AubioTempoT, :int], :uint

  # (Not documented)
  #
  # @method aubio_tempo_set_delay_s(o, delay)
  # @param [AubioTempoT] o
  # @param [Float] delay
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_set_delay_s, :aubio_tempo_set_delay_s, [AubioTempoT, :float], :uint

  # (Not documented)
  #
  # @method aubio_tempo_set_delay_ms(o, delay)
  # @param [AubioTempoT] o
  # @param [Float] delay
  # @return [Integer]
  # @scope class
  attach_function :aubio_tempo_set_delay_ms, :aubio_tempo_set_delay_ms, [AubioTempoT, :float], :uint

  # (Not documented)
  #
  # @method del_aubio_tempo(o)
  # @param [AubioTempoT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_tempo, :del_aubio_tempo, [AubioTempoT], :void

  # (Not documented)
  class AubioNotesT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_notes(method, buf_size, hop_size, samplerate)
  # @param [String] method
  # @param [Integer] buf_size
  # @param [Integer] hop_size
  # @param [Integer] samplerate
  # @return [AubioNotesT]
  # @scope class
  attach_function :new_aubio_notes, :new_aubio_notes, [:string, :uint, :uint, :uint], AubioNotesT

  # (Not documented)
  #
  # @method del_aubio_notes(o)
  # @param [AubioNotesT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_notes, :del_aubio_notes, [AubioNotesT], :void

  # (Not documented)
  #
  # @method aubio_notes_do(o, input, output)
  # @param [AubioNotesT] o
  # @param [FvecT] input
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_notes_do, :aubio_notes_do, [AubioNotesT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_notes_set_silence(o, silence)
  # @param [AubioNotesT] o
  # @param [Float] silence
  # @return [Integer]
  # @scope class
  attach_function :aubio_notes_set_silence, :aubio_notes_set_silence, [AubioNotesT, :float], :uint

  # (Not documented)
  #
  # @method aubio_notes_get_silence(o)
  # @param [AubioNotesT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_notes_get_silence, :aubio_notes_get_silence, [AubioNotesT], :float

  # (Not documented)
  #
  # @method aubio_notes_get_minioi_ms(o)
  # @param [AubioNotesT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_notes_get_minioi_ms, :aubio_notes_get_minioi_ms, [AubioNotesT], :float

  # (Not documented)
  #
  # @method aubio_notes_set_minioi_ms(o, minioi_ms)
  # @param [AubioNotesT] o
  # @param [Float] minioi_ms
  # @return [Integer]
  # @scope class
  attach_function :aubio_notes_set_minioi_ms, :aubio_notes_set_minioi_ms, [AubioNotesT, :float], :uint

  # (Not documented)
  class AubioSourceT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_source(uri, samplerate, hop_size)
  # @param [String] uri
  # @param [Integer] samplerate
  # @param [Integer] hop_size
  # @return [AubioSourceT]
  # @scope class
  attach_function :new_aubio_source, :new_aubio_source, [:string, :uint, :uint], AubioSourceT

  # (Not documented)
  #
  # @method aubio_source_do(s, read_to, read)
  # @param [AubioSourceT] s
  # @param [FvecT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_do, :aubio_source_do, [AubioSourceT, FvecT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_do_multi(s, read_to, read)
  # @param [AubioSourceT] s
  # @param [FmatT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_do_multi, :aubio_source_do_multi, [AubioSourceT, FmatT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_get_samplerate(s)
  # @param [AubioSourceT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_get_samplerate, :aubio_source_get_samplerate, [AubioSourceT], :uint

  # (Not documented)
  #
  # @method aubio_source_get_channels(s)
  # @param [AubioSourceT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_get_channels, :aubio_source_get_channels, [AubioSourceT], :uint

  # (Not documented)
  #
  # @method aubio_source_seek(s, pos)
  # @param [AubioSourceT] s
  # @param [Integer] pos
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_seek, :aubio_source_seek, [AubioSourceT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_source_get_duration(s)
  # @param [AubioSourceT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_get_duration, :aubio_source_get_duration, [AubioSourceT], :uint

  # (Not documented)
  #
  # @method aubio_source_close(s)
  # @param [AubioSourceT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_close, :aubio_source_close, [AubioSourceT], :uint

  # (Not documented)
  #
  # @method del_aubio_source(s)
  # @param [AubioSourceT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_source, :del_aubio_source, [AubioSourceT], :void

  # (Not documented)
  class AubioSinkT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_sink(uri, samplerate)
  # @param [String] uri
  # @param [Integer] samplerate
  # @return [AubioSinkT]
  # @scope class
  attach_function :new_aubio_sink, :new_aubio_sink, [:string, :uint], AubioSinkT

  # (Not documented)
  #
  # @method aubio_sink_preset_samplerate(s, samplerate)
  # @param [AubioSinkT] s
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_preset_samplerate, :aubio_sink_preset_samplerate, [AubioSinkT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_preset_channels(s, channels)
  # @param [AubioSinkT] s
  # @param [Integer] channels
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_preset_channels, :aubio_sink_preset_channels, [AubioSinkT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_get_samplerate(s)
  # @param [AubioSinkT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_get_samplerate, :aubio_sink_get_samplerate, [AubioSinkT], :uint

  # (Not documented)
  #
  # @method aubio_sink_get_channels(s)
  # @param [AubioSinkT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_get_channels, :aubio_sink_get_channels, [AubioSinkT], :uint

  # (Not documented)
  #
  # @method aubio_sink_do(s, write_data, write)
  # @param [AubioSinkT] s
  # @param [FvecT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_do, :aubio_sink_do, [AubioSinkT, FvecT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_do_multi(s, write_data, write)
  # @param [AubioSinkT] s
  # @param [FmatT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_do_multi, :aubio_sink_do_multi, [AubioSinkT, FmatT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_close(s)
  # @param [AubioSinkT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_close, :aubio_sink_close, [AubioSinkT], :uint

  # (Not documented)
  #
  # @method del_aubio_sink(s)
  # @param [AubioSinkT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_sink, :del_aubio_sink, [AubioSinkT], :void

  # (Not documented)
  class AubioSamplerT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_sampler(samplerate, hop_size)
  # @param [Integer] samplerate
  # @param [Integer] hop_size
  # @return [AubioSamplerT]
  # @scope class
  attach_function :new_aubio_sampler, :new_aubio_sampler, [:uint, :uint], AubioSamplerT

  # (Not documented)
  #
  # @method aubio_sampler_load(o, uri)
  # @param [AubioSamplerT] o
  # @param [String] uri
  # @return [Integer]
  # @scope class
  attach_function :aubio_sampler_load, :aubio_sampler_load, [AubioSamplerT, :string], :uint

  # (Not documented)
  #
  # @method aubio_sampler_do(o, input, output)
  # @param [AubioSamplerT] o
  # @param [FvecT] input
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_sampler_do, :aubio_sampler_do, [AubioSamplerT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_sampler_do_multi(o, input, output)
  # @param [AubioSamplerT] o
  # @param [FmatT] input
  # @param [FmatT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_sampler_do_multi, :aubio_sampler_do_multi, [AubioSamplerT, FmatT, FmatT], :void

  # (Not documented)
  #
  # @method aubio_sampler_get_playing(o)
  # @param [AubioSamplerT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_sampler_get_playing, :aubio_sampler_get_playing, [AubioSamplerT], :uint

  # (Not documented)
  #
  # @method aubio_sampler_set_playing(o, playing)
  # @param [AubioSamplerT] o
  # @param [Integer] playing
  # @return [Integer]
  # @scope class
  attach_function :aubio_sampler_set_playing, :aubio_sampler_set_playing, [AubioSamplerT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sampler_play(o)
  # @param [AubioSamplerT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_sampler_play, :aubio_sampler_play, [AubioSamplerT], :uint

  # (Not documented)
  #
  # @method aubio_sampler_stop(o)
  # @param [AubioSamplerT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_sampler_stop, :aubio_sampler_stop, [AubioSamplerT], :uint

  # (Not documented)
  #
  # @method del_aubio_sampler(o)
  # @param [AubioSamplerT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_sampler, :del_aubio_sampler, [AubioSamplerT], :void

  # (Not documented)
  class AubioWavetableT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_wavetable(samplerate, hop_size)
  # @param [Integer] samplerate
  # @param [Integer] hop_size
  # @return [AubioWavetableT]
  # @scope class
  attach_function :new_aubio_wavetable, :new_aubio_wavetable, [:uint, :uint], AubioWavetableT

  # (Not documented)
  #
  # @method aubio_wavetable_load(o, uri)
  # @param [AubioWavetableT] o
  # @param [String] uri
  # @return [Integer]
  # @scope class
  attach_function :aubio_wavetable_load, :aubio_wavetable_load, [AubioWavetableT, :string], :uint

  # (Not documented)
  #
  # @method aubio_wavetable_do(o, input, output)
  # @param [AubioWavetableT] o
  # @param [FvecT] input
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_wavetable_do, :aubio_wavetable_do, [AubioWavetableT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_wavetable_do_multi(o, input, output)
  # @param [AubioWavetableT] o
  # @param [FmatT] input
  # @param [FmatT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_wavetable_do_multi, :aubio_wavetable_do_multi, [AubioWavetableT, FmatT, FmatT], :void

  # (Not documented)
  #
  # @method aubio_wavetable_get_playing(o)
  # @param [AubioWavetableT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_wavetable_get_playing, :aubio_wavetable_get_playing, [AubioWavetableT], :uint

  # (Not documented)
  #
  # @method aubio_wavetable_set_playing(o, playing)
  # @param [AubioWavetableT] o
  # @param [Integer] playing
  # @return [Integer]
  # @scope class
  attach_function :aubio_wavetable_set_playing, :aubio_wavetable_set_playing, [AubioWavetableT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_wavetable_play(o)
  # @param [AubioWavetableT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_wavetable_play, :aubio_wavetable_play, [AubioWavetableT], :uint

  # (Not documented)
  #
  # @method aubio_wavetable_stop(o)
  # @param [AubioWavetableT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_wavetable_stop, :aubio_wavetable_stop, [AubioWavetableT], :uint

  # (Not documented)
  #
  # @method aubio_wavetable_set_freq(o, freq)
  # @param [AubioWavetableT] o
  # @param [Float] freq
  # @return [Integer]
  # @scope class
  attach_function :aubio_wavetable_set_freq, :aubio_wavetable_set_freq, [AubioWavetableT, :float], :uint

  # (Not documented)
  #
  # @method aubio_wavetable_get_freq(o)
  # @param [AubioWavetableT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_wavetable_get_freq, :aubio_wavetable_get_freq, [AubioWavetableT], :float

  # (Not documented)
  #
  # @method aubio_wavetable_set_amp(o, amp)
  # @param [AubioWavetableT] o
  # @param [Float] amp
  # @return [Integer]
  # @scope class
  attach_function :aubio_wavetable_set_amp, :aubio_wavetable_set_amp, [AubioWavetableT, :float], :uint

  # (Not documented)
  #
  # @method aubio_wavetable_get_amp(o)
  # @param [AubioWavetableT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_wavetable_get_amp, :aubio_wavetable_get_amp, [AubioWavetableT], :float

  # (Not documented)
  #
  # @method del_aubio_wavetable(o)
  # @param [AubioWavetableT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_wavetable, :del_aubio_wavetable, [AubioWavetableT], :void

  # (Not documented)
  class AubioParameterT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_parameter(min_value, max_value, steps)
  # @param [Float] min_value
  # @param [Float] max_value
  # @param [Integer] steps
  # @return [AubioParameterT]
  # @scope class
  attach_function :new_aubio_parameter, :new_aubio_parameter, [:float, :float, :uint], AubioParameterT

  # (Not documented)
  #
  # @method aubio_parameter_set_target_value(param, value)
  # @param [AubioParameterT] param
  # @param [Float] value
  # @return [Integer]
  # @scope class
  attach_function :aubio_parameter_set_target_value, :aubio_parameter_set_target_value, [AubioParameterT, :float], :uint

  # (Not documented)
  #
  # @method aubio_parameter_get_next_value(param)
  # @param [AubioParameterT] param
  # @return [Float]
  # @scope class
  attach_function :aubio_parameter_get_next_value, :aubio_parameter_get_next_value, [AubioParameterT], :float

  # (Not documented)
  #
  # @method aubio_parameter_get_current_value(param)
  # @param [AubioParameterT] param
  # @return [Float]
  # @scope class
  attach_function :aubio_parameter_get_current_value, :aubio_parameter_get_current_value, [AubioParameterT], :float

  # (Not documented)
  #
  # @method aubio_parameter_set_current_value(param, value)
  # @param [AubioParameterT] param
  # @param [Float] value
  # @return [Integer]
  # @scope class
  attach_function :aubio_parameter_set_current_value, :aubio_parameter_set_current_value, [AubioParameterT, :float], :uint

  # (Not documented)
  #
  # @method aubio_parameter_set_steps(param, steps)
  # @param [AubioParameterT] param
  # @param [Integer] steps
  # @return [Integer]
  # @scope class
  attach_function :aubio_parameter_set_steps, :aubio_parameter_set_steps, [AubioParameterT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_parameter_get_steps(param)
  # @param [AubioParameterT] param
  # @return [Integer]
  # @scope class
  attach_function :aubio_parameter_get_steps, :aubio_parameter_get_steps, [AubioParameterT], :uint

  # (Not documented)
  #
  # @method aubio_parameter_set_min_value(param, min_value)
  # @param [AubioParameterT] param
  # @param [Float] min_value
  # @return [Integer]
  # @scope class
  attach_function :aubio_parameter_set_min_value, :aubio_parameter_set_min_value, [AubioParameterT, :float], :uint

  # (Not documented)
  #
  # @method aubio_parameter_get_min_value(param)
  # @param [AubioParameterT] param
  # @return [Float]
  # @scope class
  attach_function :aubio_parameter_get_min_value, :aubio_parameter_get_min_value, [AubioParameterT], :float

  # (Not documented)
  #
  # @method aubio_parameter_set_max_value(param, max_value)
  # @param [AubioParameterT] param
  # @param [Float] max_value
  # @return [Integer]
  # @scope class
  attach_function :aubio_parameter_set_max_value, :aubio_parameter_set_max_value, [AubioParameterT, :float], :uint

  # (Not documented)
  #
  # @method aubio_parameter_get_max_value(param)
  # @param [AubioParameterT] param
  # @return [Float]
  # @scope class
  attach_function :aubio_parameter_get_max_value, :aubio_parameter_get_max_value, [AubioParameterT], :float

  # (Not documented)
  #
  # @method del_aubio_parameter(param)
  # @param [AubioParameterT] param
  # @return [nil]
  # @scope class
  attach_function :del_aubio_parameter, :del_aubio_parameter, [AubioParameterT], :void

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:aubio_log_level).</em>
  #
  # === Options:
  # :err ::
  #
  # :inf ::
  #   < critical errors
  # :msg ::
  #   < infos
  # :dbg ::
  #   < general messages
  # :wrn ::
  #   < debug messages
  # :last_level ::
  #   < warnings
  #
  # @method _enum_aubio_log_level_
  # @return [Symbol]
  # @scope class
  enum :aubio_log_level, [
    :err, 0,
    :inf, 1,
    :msg, 2,
    :dbg, 3,
    :wrn, 4,
    :last_level, 5
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method.</em>
  #
  # @method _callback_aubio_log_function_t_(level, message, data)
  # @param [Integer] level
  # @param [String] message
  # @param [FFI::Pointer(*Void)] data
  # @return [Integer]
  # @scope class
  callback :aubio_log_function_t, [:int, :string, :pointer], :int

  # (Not documented)
  #
  # @method aubio_log_set_function(fun, data)
  # @param [Proc(_callback_aubio_log_function_t_)] fun
  # @param [FFI::Pointer(*Void)] data
  # @return [nil]
  # @scope class
  attach_function :aubio_log_set_function, :aubio_log_set_function, [:aubio_log_function_t, :pointer], :void

  # (Not documented)
  #
  # @method aubio_log_set_level_function(level, fun, data)
  # @param [Integer] level
  # @param [Proc(_callback_aubio_log_function_t_)] fun
  # @param [FFI::Pointer(*Void)] data
  # @return [Proc(_callback_aubio_log_function_t_)]
  # @scope class
  attach_function :aubio_log_set_level_function, :aubio_log_set_level_function, [:int, :aubio_log_function_t, :pointer], :aubio_log_function_t

  # (Not documented)
  #
  # @method aubio_log_reset()
  # @return [nil]
  # @scope class
  attach_function :aubio_log_reset, :aubio_log_reset, [], :void

  # (Not documented)
  class AubioAudioUnitT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_audio_unit(samplerate, inchannels, outchannels, blocksize)
  # @param [Integer] samplerate
  # @param [Integer] inchannels
  # @param [Integer] outchannels
  # @param [Integer] blocksize
  # @return [AubioAudioUnitT]
  # @scope class
  attach_function :new_aubio_audio_unit, :new_aubio_audio_unit, [:uint, :uint, :uint, :uint], AubioAudioUnitT

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method.</em>
  #
  # @method _callback_aubio_device_callback_t_(uint_t, closure, ibuf, obuf)
  # @param [Integer] uint_t
  # @param [FFI::Pointer(*Void)] closure
  # @param [FmatT] ibuf
  # @param [FmatT] obuf
  # @return [Integer]
  # @scope class
  callback :aubio_device_callback_t, [:uint, :pointer, FmatT, FmatT], :uint

  # (Not documented)
  #
  # @method aubio_audio_unit_set_callback(o, callback, closure)
  # @param [AubioAudioUnitT] o
  # @param [Proc(_callback_aubio_device_callback_t_)] callback
  # @param [FFI::Pointer(*Void)] closure
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_set_callback, :aubio_audio_unit_set_callback, [AubioAudioUnitT, :aubio_device_callback_t, :pointer], :uint

  # (Not documented)
  #
  # @method aubio_audio_unit_set_verbose(o, verbose)
  # @param [AubioAudioUnitT] o
  # @param [Integer] verbose
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_set_verbose, :aubio_audio_unit_set_verbose, [AubioAudioUnitT, :uint], :int

  # (Not documented)
  #
  # @method aubio_audio_unit_set_preferred_latency(o, latency)
  # @param [AubioAudioUnitT] o
  # @param [Float] latency
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_set_preferred_latency, :aubio_audio_unit_set_preferred_latency, [AubioAudioUnitT, :float], :int

  # (Not documented)
  #
  # @method aubio_audio_unit_set_prevent_feedback(o, prevent_feedback)
  # @param [AubioAudioUnitT] o
  # @param [Integer] prevent_feedback
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_set_prevent_feedback, :aubio_audio_unit_set_prevent_feedback, [AubioAudioUnitT, :uint], :int

  # (Not documented)
  #
  # @method aubio_audio_unit_get_info(o)
  # @param [AubioAudioUnitT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_get_info, :aubio_audio_unit_get_info, [AubioAudioUnitT], :int

  # (Not documented)
  #
  # @method aubio_audio_unit_init(o)
  # @param [AubioAudioUnitT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_init, :aubio_audio_unit_init, [AubioAudioUnitT], :int

  # (Not documented)
  #
  # @method aubio_audio_unit_start(o)
  # @param [AubioAudioUnitT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_start, :aubio_audio_unit_start, [AubioAudioUnitT], :int

  # (Not documented)
  #
  # @method aubio_audio_unit_stop(o)
  # @param [AubioAudioUnitT] o
  # @return [Integer]
  # @scope class
  attach_function :aubio_audio_unit_stop, :aubio_audio_unit_stop, [AubioAudioUnitT], :int

  # (Not documented)
  #
  # @method del_aubio_audio_unit(o)
  # @param [AubioAudioUnitT] o
  # @return [Integer]
  # @scope class
  attach_function :del_aubio_audio_unit, :del_aubio_audio_unit, [AubioAudioUnitT], :uint

  # (Not documented)
  #
  # @method aubio_io_validate_samplerate(kind, path, samplerate)
  # @param [String] kind
  # @param [String] path
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_io_validate_samplerate, :aubio_io_validate_samplerate, [:string, :string, :uint], :uint

  # (Not documented)
  #
  # @method aubio_io_validate_channels(kind, path, channels)
  # @param [String] kind
  # @param [String] path
  # @param [Integer] channels
  # @return [Integer]
  # @scope class
  attach_function :aubio_io_validate_channels, :aubio_io_validate_channels, [:string, :string, :uint], :uint

  # (Not documented)
  class AubioSinkAppleAudioT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_sink_apple_audio(uri, samplerate)
  # @param [String] uri
  # @param [Integer] samplerate
  # @return [AubioSinkAppleAudioT]
  # @scope class
  attach_function :new_aubio_sink_apple_audio, :new_aubio_sink_apple_audio, [:string, :uint], AubioSinkAppleAudioT

  # (Not documented)
  #
  # @method aubio_sink_apple_audio_preset_samplerate(s, samplerate)
  # @param [AubioSinkAppleAudioT] s
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_apple_audio_preset_samplerate, :aubio_sink_apple_audio_preset_samplerate, [AubioSinkAppleAudioT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_apple_audio_preset_channels(s, channels)
  # @param [AubioSinkAppleAudioT] s
  # @param [Integer] channels
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_apple_audio_preset_channels, :aubio_sink_apple_audio_preset_channels, [AubioSinkAppleAudioT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_apple_audio_get_samplerate(s)
  # @param [AubioSinkAppleAudioT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_apple_audio_get_samplerate, :aubio_sink_apple_audio_get_samplerate, [AubioSinkAppleAudioT], :uint

  # (Not documented)
  #
  # @method aubio_sink_apple_audio_get_channels(s)
  # @param [AubioSinkAppleAudioT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_apple_audio_get_channels, :aubio_sink_apple_audio_get_channels, [AubioSinkAppleAudioT], :uint

  # (Not documented)
  #
  # @method aubio_sink_apple_audio_do(s, write_data, write)
  # @param [AubioSinkAppleAudioT] s
  # @param [FvecT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_apple_audio_do, :aubio_sink_apple_audio_do, [AubioSinkAppleAudioT, FvecT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_apple_audio_do_multi(s, write_data, write)
  # @param [AubioSinkAppleAudioT] s
  # @param [FmatT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_apple_audio_do_multi, :aubio_sink_apple_audio_do_multi, [AubioSinkAppleAudioT, FmatT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_apple_audio_close(s)
  # @param [AubioSinkAppleAudioT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_apple_audio_close, :aubio_sink_apple_audio_close, [AubioSinkAppleAudioT], :uint

  # (Not documented)
  #
  # @method del_aubio_sink_apple_audio(s)
  # @param [AubioSinkAppleAudioT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_sink_apple_audio, :del_aubio_sink_apple_audio, [AubioSinkAppleAudioT], :void

  # (Not documented)
  class AubioSinkSndfileT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_sink_sndfile(uri, samplerate)
  # @param [String] uri
  # @param [Integer] samplerate
  # @return [AubioSinkSndfileT]
  # @scope class
  attach_function :new_aubio_sink_sndfile, :new_aubio_sink_sndfile, [:string, :uint], AubioSinkSndfileT

  # (Not documented)
  #
  # @method aubio_sink_sndfile_preset_samplerate(s, samplerate)
  # @param [AubioSinkSndfileT] s
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_sndfile_preset_samplerate, :aubio_sink_sndfile_preset_samplerate, [AubioSinkSndfileT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_sndfile_preset_channels(s, channels)
  # @param [AubioSinkSndfileT] s
  # @param [Integer] channels
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_sndfile_preset_channels, :aubio_sink_sndfile_preset_channels, [AubioSinkSndfileT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_sndfile_get_samplerate(s)
  # @param [AubioSinkSndfileT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_sndfile_get_samplerate, :aubio_sink_sndfile_get_samplerate, [AubioSinkSndfileT], :uint

  # (Not documented)
  #
  # @method aubio_sink_sndfile_get_channels(s)
  # @param [AubioSinkSndfileT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_sndfile_get_channels, :aubio_sink_sndfile_get_channels, [AubioSinkSndfileT], :uint

  # (Not documented)
  #
  # @method aubio_sink_sndfile_do(s, write_data, write)
  # @param [AubioSinkSndfileT] s
  # @param [FvecT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_sndfile_do, :aubio_sink_sndfile_do, [AubioSinkSndfileT, FvecT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_sndfile_do_multi(s, write_data, write)
  # @param [AubioSinkSndfileT] s
  # @param [FmatT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_sndfile_do_multi, :aubio_sink_sndfile_do_multi, [AubioSinkSndfileT, FmatT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_sndfile_close(s)
  # @param [AubioSinkSndfileT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_sndfile_close, :aubio_sink_sndfile_close, [AubioSinkSndfileT], :uint

  # (Not documented)
  #
  # @method del_aubio_sink_sndfile(s)
  # @param [AubioSinkSndfileT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_sink_sndfile, :del_aubio_sink_sndfile, [AubioSinkSndfileT], :void

  # (Not documented)
  class AubioSinkWavwriteT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_sink_wavwrite(uri, samplerate)
  # @param [String] uri
  # @param [Integer] samplerate
  # @return [AubioSinkWavwriteT]
  # @scope class
  attach_function :new_aubio_sink_wavwrite, :new_aubio_sink_wavwrite, [:string, :uint], AubioSinkWavwriteT

  # (Not documented)
  #
  # @method aubio_sink_wavwrite_preset_samplerate(s, samplerate)
  # @param [AubioSinkWavwriteT] s
  # @param [Integer] samplerate
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_wavwrite_preset_samplerate, :aubio_sink_wavwrite_preset_samplerate, [AubioSinkWavwriteT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_wavwrite_preset_channels(s, channels)
  # @param [AubioSinkWavwriteT] s
  # @param [Integer] channels
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_wavwrite_preset_channels, :aubio_sink_wavwrite_preset_channels, [AubioSinkWavwriteT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_sink_wavwrite_get_samplerate(s)
  # @param [AubioSinkWavwriteT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_wavwrite_get_samplerate, :aubio_sink_wavwrite_get_samplerate, [AubioSinkWavwriteT], :uint

  # (Not documented)
  #
  # @method aubio_sink_wavwrite_get_channels(s)
  # @param [AubioSinkWavwriteT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_wavwrite_get_channels, :aubio_sink_wavwrite_get_channels, [AubioSinkWavwriteT], :uint

  # (Not documented)
  #
  # @method aubio_sink_wavwrite_do(s, write_data, write)
  # @param [AubioSinkWavwriteT] s
  # @param [FvecT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_wavwrite_do, :aubio_sink_wavwrite_do, [AubioSinkWavwriteT, FvecT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_wavwrite_do_multi(s, write_data, write)
  # @param [AubioSinkWavwriteT] s
  # @param [FmatT] write_data
  # @param [Integer] write
  # @return [nil]
  # @scope class
  attach_function :aubio_sink_wavwrite_do_multi, :aubio_sink_wavwrite_do_multi, [AubioSinkWavwriteT, FmatT, :uint], :void

  # (Not documented)
  #
  # @method aubio_sink_wavwrite_close(s)
  # @param [AubioSinkWavwriteT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_sink_wavwrite_close, :aubio_sink_wavwrite_close, [AubioSinkWavwriteT], :uint

  # (Not documented)
  #
  # @method del_aubio_sink_wavwrite(s)
  # @param [AubioSinkWavwriteT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_sink_wavwrite, :del_aubio_sink_wavwrite, [AubioSinkWavwriteT], :void

  # (Not documented)
  class AubioSourceAppleAudioT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_source_apple_audio(uri, samplerate, hop_size)
  # @param [String] uri
  # @param [Integer] samplerate
  # @param [Integer] hop_size
  # @return [AubioSourceAppleAudioT]
  # @scope class
  attach_function :new_aubio_source_apple_audio, :new_aubio_source_apple_audio, [:string, :uint, :uint], AubioSourceAppleAudioT

  # (Not documented)
  #
  # @method aubio_source_apple_audio_do(s, read_to, read)
  # @param [AubioSourceAppleAudioT] s
  # @param [FvecT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_apple_audio_do, :aubio_source_apple_audio_do, [AubioSourceAppleAudioT, FvecT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_apple_audio_do_multi(s, read_to, read)
  # @param [AubioSourceAppleAudioT] s
  # @param [FmatT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_apple_audio_do_multi, :aubio_source_apple_audio_do_multi, [AubioSourceAppleAudioT, FmatT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_apple_audio_get_samplerate(s)
  # @param [AubioSourceAppleAudioT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_apple_audio_get_samplerate, :aubio_source_apple_audio_get_samplerate, [AubioSourceAppleAudioT], :uint

  # (Not documented)
  #
  # @method aubio_source_apple_audio_get_channels(s)
  # @param [AubioSourceAppleAudioT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_apple_audio_get_channels, :aubio_source_apple_audio_get_channels, [AubioSourceAppleAudioT], :uint

  # (Not documented)
  #
  # @method aubio_source_apple_audio_get_duration(s)
  # @param [AubioSourceAppleAudioT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_apple_audio_get_duration, :aubio_source_apple_audio_get_duration, [AubioSourceAppleAudioT], :uint

  # (Not documented)
  #
  # @method aubio_source_apple_audio_seek(s, pos)
  # @param [AubioSourceAppleAudioT] s
  # @param [Integer] pos
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_apple_audio_seek, :aubio_source_apple_audio_seek, [AubioSourceAppleAudioT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_source_apple_audio_close(s)
  # @param [AubioSourceAppleAudioT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_apple_audio_close, :aubio_source_apple_audio_close, [AubioSourceAppleAudioT], :uint

  # (Not documented)
  #
  # @method del_aubio_source_apple_audio(s)
  # @param [AubioSourceAppleAudioT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_source_apple_audio, :del_aubio_source_apple_audio, [AubioSourceAppleAudioT], :void

  # (Not documented)
  class AubioSourceAvcodecT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_source_avcodec(uri, samplerate, hop_size)
  # @param [String] uri
  # @param [Integer] samplerate
  # @param [Integer] hop_size
  # @return [AubioSourceAvcodecT]
  # @scope class
  attach_function :new_aubio_source_avcodec, :new_aubio_source_avcodec, [:string, :uint, :uint], AubioSourceAvcodecT

  # (Not documented)
  #
  # @method aubio_source_avcodec_do(s, read_to, read)
  # @param [AubioSourceAvcodecT] s
  # @param [FvecT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_avcodec_do, :aubio_source_avcodec_do, [AubioSourceAvcodecT, FvecT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_avcodec_do_multi(s, read_to, read)
  # @param [AubioSourceAvcodecT] s
  # @param [FmatT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_avcodec_do_multi, :aubio_source_avcodec_do_multi, [AubioSourceAvcodecT, FmatT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_avcodec_get_samplerate(s)
  # @param [AubioSourceAvcodecT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_avcodec_get_samplerate, :aubio_source_avcodec_get_samplerate, [AubioSourceAvcodecT], :uint

  # (Not documented)
  #
  # @method aubio_source_avcodec_get_channels(s)
  # @param [AubioSourceAvcodecT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_avcodec_get_channels, :aubio_source_avcodec_get_channels, [AubioSourceAvcodecT], :uint

  # (Not documented)
  #
  # @method aubio_source_avcodec_seek(s, pos)
  # @param [AubioSourceAvcodecT] s
  # @param [Integer] pos
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_avcodec_seek, :aubio_source_avcodec_seek, [AubioSourceAvcodecT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_source_avcodec_get_duration(s)
  # @param [AubioSourceAvcodecT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_avcodec_get_duration, :aubio_source_avcodec_get_duration, [AubioSourceAvcodecT], :uint

  # (Not documented)
  #
  # @method aubio_source_avcodec_close(s)
  # @param [AubioSourceAvcodecT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_avcodec_close, :aubio_source_avcodec_close, [AubioSourceAvcodecT], :uint

  # (Not documented)
  #
  # @method del_aubio_source_avcodec(s)
  # @param [AubioSourceAvcodecT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_source_avcodec, :del_aubio_source_avcodec, [AubioSourceAvcodecT], :void

  # (Not documented)
  class AubioSourceSndfileT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_source_sndfile(uri, samplerate, hop_size)
  # @param [String] uri
  # @param [Integer] samplerate
  # @param [Integer] hop_size
  # @return [AubioSourceSndfileT]
  # @scope class
  attach_function :new_aubio_source_sndfile, :new_aubio_source_sndfile, [:string, :uint, :uint], AubioSourceSndfileT

  # (Not documented)
  #
  # @method aubio_source_sndfile_do(s, read_to, read)
  # @param [AubioSourceSndfileT] s
  # @param [FvecT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_sndfile_do, :aubio_source_sndfile_do, [AubioSourceSndfileT, FvecT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_sndfile_do_multi(s, read_to, read)
  # @param [AubioSourceSndfileT] s
  # @param [FmatT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_sndfile_do_multi, :aubio_source_sndfile_do_multi, [AubioSourceSndfileT, FmatT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_sndfile_get_samplerate(s)
  # @param [AubioSourceSndfileT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_sndfile_get_samplerate, :aubio_source_sndfile_get_samplerate, [AubioSourceSndfileT], :uint

  # (Not documented)
  #
  # @method aubio_source_sndfile_get_channels(s)
  # @param [AubioSourceSndfileT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_sndfile_get_channels, :aubio_source_sndfile_get_channels, [AubioSourceSndfileT], :uint

  # (Not documented)
  #
  # @method aubio_source_sndfile_seek(s, pos)
  # @param [AubioSourceSndfileT] s
  # @param [Integer] pos
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_sndfile_seek, :aubio_source_sndfile_seek, [AubioSourceSndfileT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_source_sndfile_get_duration(s)
  # @param [AubioSourceSndfileT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_sndfile_get_duration, :aubio_source_sndfile_get_duration, [AubioSourceSndfileT], :uint

  # (Not documented)
  #
  # @method aubio_source_sndfile_close(s)
  # @param [AubioSourceSndfileT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_sndfile_close, :aubio_source_sndfile_close, [AubioSourceSndfileT], :uint

  # (Not documented)
  #
  # @method del_aubio_source_sndfile(s)
  # @param [AubioSourceSndfileT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_source_sndfile, :del_aubio_source_sndfile, [AubioSourceSndfileT], :void

  # (Not documented)
  class AubioSourceWavreadT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_source_wavread(uri, samplerate, hop_size)
  # @param [String] uri
  # @param [Integer] samplerate
  # @param [Integer] hop_size
  # @return [AubioSourceWavreadT]
  # @scope class
  attach_function :new_aubio_source_wavread, :new_aubio_source_wavread, [:string, :uint, :uint], AubioSourceWavreadT

  # (Not documented)
  #
  # @method aubio_source_wavread_do(s, read_to, read)
  # @param [AubioSourceWavreadT] s
  # @param [FvecT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_wavread_do, :aubio_source_wavread_do, [AubioSourceWavreadT, FvecT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_wavread_do_multi(s, read_to, read)
  # @param [AubioSourceWavreadT] s
  # @param [FmatT] read_to
  # @param [FFI::Pointer(*UintT)] read
  # @return [nil]
  # @scope class
  attach_function :aubio_source_wavread_do_multi, :aubio_source_wavread_do_multi, [AubioSourceWavreadT, FmatT, :pointer], :void

  # (Not documented)
  #
  # @method aubio_source_wavread_get_samplerate(s)
  # @param [AubioSourceWavreadT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_wavread_get_samplerate, :aubio_source_wavread_get_samplerate, [AubioSourceWavreadT], :uint

  # (Not documented)
  #
  # @method aubio_source_wavread_get_channels(s)
  # @param [AubioSourceWavreadT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_wavread_get_channels, :aubio_source_wavread_get_channels, [AubioSourceWavreadT], :uint

  # (Not documented)
  #
  # @method aubio_source_wavread_seek(s, pos)
  # @param [AubioSourceWavreadT] s
  # @param [Integer] pos
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_wavread_seek, :aubio_source_wavread_seek, [AubioSourceWavreadT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_source_wavread_get_duration(s)
  # @param [AubioSourceWavreadT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_wavread_get_duration, :aubio_source_wavread_get_duration, [AubioSourceWavreadT], :uint

  # (Not documented)
  #
  # @method aubio_source_wavread_close(s)
  # @param [AubioSourceWavreadT] s
  # @return [Integer]
  # @scope class
  attach_function :aubio_source_wavread_close, :aubio_source_wavread_close, [AubioSourceWavreadT], :uint

  # (Not documented)
  #
  # @method del_aubio_source_wavread(s)
  # @param [AubioSourceWavreadT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_source_wavread, :del_aubio_source_wavread, [AubioSourceWavreadT], :void

  # (Not documented)
  #
  # @method fvec_mean(s)
  # @param [FvecT] s
  # @return [Float]
  # @scope class
  attach_function :fvec_mean, :fvec_mean, [FvecT], :float

  # (Not documented)
  #
  # @method fvec_max(s)
  # @param [FvecT] s
  # @return [Float]
  # @scope class
  attach_function :fvec_max, :fvec_max, [FvecT], :float

  # (Not documented)
  #
  # @method fvec_min(s)
  # @param [FvecT] s
  # @return [Float]
  # @scope class
  attach_function :fvec_min, :fvec_min, [FvecT], :float

  # (Not documented)
  #
  # @method fvec_min_elem(s)
  # @param [FvecT] s
  # @return [Integer]
  # @scope class
  attach_function :fvec_min_elem, :fvec_min_elem, [FvecT], :uint

  # (Not documented)
  #
  # @method fvec_max_elem(s)
  # @param [FvecT] s
  # @return [Integer]
  # @scope class
  attach_function :fvec_max_elem, :fvec_max_elem, [FvecT], :uint

  # (Not documented)
  #
  # @method fvec_shift(v)
  # @param [FvecT] v
  # @return [nil]
  # @scope class
  attach_function :fvec_shift, :fvec_shift, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_ishift(v)
  # @param [FvecT] v
  # @return [nil]
  # @scope class
  attach_function :fvec_ishift, :fvec_ishift, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_sum(v)
  # @param [FvecT] v
  # @return [Float]
  # @scope class
  attach_function :fvec_sum, :fvec_sum, [FvecT], :float

  # (Not documented)
  #
  # @method fvec_local_hfc(v)
  # @param [FvecT] v
  # @return [Float]
  # @scope class
  attach_function :fvec_local_hfc, :fvec_local_hfc, [FvecT], :float

  # (Not documented)
  #
  # @method fvec_alpha_norm(v, p)
  # @param [FvecT] v
  # @param [Float] p
  # @return [Float]
  # @scope class
  attach_function :fvec_alpha_norm, :fvec_alpha_norm, [FvecT, :float], :float

  # (Not documented)
  #
  # @method fvec_alpha_normalise(v, p)
  # @param [FvecT] v
  # @param [Float] p
  # @return [nil]
  # @scope class
  attach_function :fvec_alpha_normalise, :fvec_alpha_normalise, [FvecT, :float], :void

  # (Not documented)
  #
  # @method fvec_add(v, c)
  # @param [FvecT] v
  # @param [Float] c
  # @return [nil]
  # @scope class
  attach_function :fvec_add, :fvec_add, [FvecT, :float], :void

  # (Not documented)
  #
  # @method fvec_min_removal(v)
  # @param [FvecT] v
  # @return [nil]
  # @scope class
  attach_function :fvec_min_removal, :fvec_min_removal, [FvecT], :void

  # (Not documented)
  #
  # @method fvec_moving_thres(v, tmp, post, pre, pos)
  # @param [FvecT] v
  # @param [FvecT] tmp
  # @param [Integer] post
  # @param [Integer] pre
  # @param [Integer] pos
  # @return [Float]
  # @scope class
  attach_function :fvec_moving_thres, :fvec_moving_thres, [FvecT, FvecT, :uint, :uint, :uint], :float

  # (Not documented)
  #
  # @method fvec_adapt_thres(v, tmp, post, pre)
  # @param [FvecT] v
  # @param [FvecT] tmp
  # @param [Integer] post
  # @param [Integer] pre
  # @return [nil]
  # @scope class
  attach_function :fvec_adapt_thres, :fvec_adapt_thres, [FvecT, FvecT, :uint, :uint], :void

  # (Not documented)
  #
  # @method fvec_median(v)
  # @param [FvecT] v
  # @return [Float]
  # @scope class
  attach_function :fvec_median, :fvec_median, [FvecT], :float

  # (Not documented)
  #
  # @method fvec_quadratic_peak_pos(x, p)
  # @param [FvecT] x
  # @param [Integer] p
  # @return [Float]
  # @scope class
  attach_function :fvec_quadratic_peak_pos, :fvec_quadratic_peak_pos, [FvecT, :uint], :float

  # (Not documented)
  #
  # @method fvec_quadratic_peak_mag(x, p)
  # @param [FvecT] x
  # @param [Float] p
  # @return [Float]
  # @scope class
  attach_function :fvec_quadratic_peak_mag, :fvec_quadratic_peak_mag, [FvecT, :float], :float

  # (Not documented)
  #
  # @method aubio_quadfrac(s0, s1, s2, pf)
  # @param [Float] s0
  # @param [Float] s1
  # @param [Float] s2
  # @param [Float] pf
  # @return [Float]
  # @scope class
  attach_function :aubio_quadfrac, :aubio_quadfrac, [:float, :float, :float, :float], :float

  # (Not documented)
  #
  # @method fvec_peakpick(v, p)
  # @param [FvecT] v
  # @param [Integer] p
  # @return [Integer]
  # @scope class
  attach_function :fvec_peakpick, :fvec_peakpick, [FvecT, :uint], :uint

  # (Not documented)
  #
  # @method aubio_is_power_of_two(a)
  # @param [Integer] a
  # @return [Integer]
  # @scope class
  attach_function :aubio_is_power_of_two, :aubio_is_power_of_two, [:uint], :uint

  # (Not documented)
  #
  # @method aubio_next_power_of_two(a)
  # @param [Integer] a
  # @return [Integer]
  # @scope class
  attach_function :aubio_next_power_of_two, :aubio_next_power_of_two, [:uint], :uint

  # (Not documented)
  #
  # @method aubio_autocorr(input, output)
  # @param [FvecT] input
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_autocorr, :aubio_autocorr, [FvecT, FvecT], :void

  # (Not documented)
  class AubioPeakpickerT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_peakpicker()
  # @return [AubioPeakpickerT]
  # @scope class
  attach_function :new_aubio_peakpicker, :new_aubio_peakpicker, [], AubioPeakpickerT

  # (Not documented)
  #
  # @method aubio_peakpicker_do(p, in_, out)
  # @param [AubioPeakpickerT] p
  # @param [FvecT] in_
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :aubio_peakpicker_do, :aubio_peakpicker_do, [AubioPeakpickerT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method del_aubio_peakpicker(p)
  # @param [AubioPeakpickerT] p
  # @return [nil]
  # @scope class
  attach_function :del_aubio_peakpicker, :del_aubio_peakpicker, [AubioPeakpickerT], :void

  # (Not documented)
  #
  # @method aubio_peakpicker_get_thresholded_input(p)
  # @param [AubioPeakpickerT] p
  # @return [FvecT]
  # @scope class
  attach_function :aubio_peakpicker_get_thresholded_input, :aubio_peakpicker_get_thresholded_input, [AubioPeakpickerT], FvecT

  # (Not documented)
  #
  # @method aubio_peakpicker_set_threshold(p, threshold)
  # @param [AubioPeakpickerT] p
  # @param [Float] threshold
  # @return [Integer]
  # @scope class
  attach_function :aubio_peakpicker_set_threshold, :aubio_peakpicker_set_threshold, [AubioPeakpickerT, :float], :uint

  # (Not documented)
  #
  # @method aubio_peakpicker_get_threshold(p)
  # @param [AubioPeakpickerT] p
  # @return [Float]
  # @scope class
  attach_function :aubio_peakpicker_get_threshold, :aubio_peakpicker_get_threshold, [AubioPeakpickerT], :float

  # (Not documented)
  class AubioPitchfcombT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_pitchfcomb_do(p, input, output)
  # @param [AubioPitchfcombT] p
  # @param [FvecT] input
  # @param [FvecT] output
  # @return [nil]
  # @scope class
  attach_function :aubio_pitchfcomb_do, :aubio_pitchfcomb_do, [AubioPitchfcombT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method new_aubio_pitchfcomb(buf_size, hop_size)
  # @param [Integer] buf_size
  # @param [Integer] hop_size
  # @return [AubioPitchfcombT]
  # @scope class
  attach_function :new_aubio_pitchfcomb, :new_aubio_pitchfcomb, [:uint, :uint], AubioPitchfcombT

  # (Not documented)
  #
  # @method del_aubio_pitchfcomb(p)
  # @param [AubioPitchfcombT] p
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pitchfcomb, :del_aubio_pitchfcomb, [AubioPitchfcombT], :void

  # (Not documented)
  class AubioPitchmcombT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_pitchmcomb_do(p, in_fftgrain, out_cands)
  # @param [AubioPitchmcombT] p
  # @param [CvecT] in_fftgrain
  # @param [FvecT] out_cands
  # @return [nil]
  # @scope class
  attach_function :aubio_pitchmcomb_do, :aubio_pitchmcomb_do, [AubioPitchmcombT, CvecT, FvecT], :void

  # (Not documented)
  #
  # @method new_aubio_pitchmcomb(buf_size, hop_size)
  # @param [Integer] buf_size
  # @param [Integer] hop_size
  # @return [AubioPitchmcombT]
  # @scope class
  attach_function :new_aubio_pitchmcomb, :new_aubio_pitchmcomb, [:uint, :uint], AubioPitchmcombT

  # (Not documented)
  #
  # @method del_aubio_pitchmcomb(p)
  # @param [AubioPitchmcombT] p
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pitchmcomb, :del_aubio_pitchmcomb, [AubioPitchmcombT], :void

  # (Not documented)
  class AubioPitchschmittT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_pitchschmitt_do(p, samples_in, cands_out)
  # @param [AubioPitchschmittT] p
  # @param [FvecT] samples_in
  # @param [FvecT] cands_out
  # @return [nil]
  # @scope class
  attach_function :aubio_pitchschmitt_do, :aubio_pitchschmitt_do, [AubioPitchschmittT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method new_aubio_pitchschmitt(buf_size)
  # @param [Integer] buf_size
  # @return [AubioPitchschmittT]
  # @scope class
  attach_function :new_aubio_pitchschmitt, :new_aubio_pitchschmitt, [:uint], AubioPitchschmittT

  # (Not documented)
  #
  # @method del_aubio_pitchschmitt(p)
  # @param [AubioPitchschmittT] p
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pitchschmitt, :del_aubio_pitchschmitt, [AubioPitchschmittT], :void

  # (Not documented)
  class AubioPitchspecacfT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_pitchspecacf_do(o, samples_in, cands_out)
  # @param [AubioPitchspecacfT] o
  # @param [FvecT] samples_in
  # @param [FvecT] cands_out
  # @return [nil]
  # @scope class
  attach_function :aubio_pitchspecacf_do, :aubio_pitchspecacf_do, [AubioPitchspecacfT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method new_aubio_pitchspecacf(buf_size)
  # @param [Integer] buf_size
  # @return [AubioPitchspecacfT]
  # @scope class
  attach_function :new_aubio_pitchspecacf, :new_aubio_pitchspecacf, [:uint], AubioPitchspecacfT

  # (Not documented)
  #
  # @method del_aubio_pitchspecacf(o)
  # @param [AubioPitchspecacfT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pitchspecacf, :del_aubio_pitchspecacf, [AubioPitchspecacfT], :void

  # (Not documented)
  #
  # @method aubio_pitchspecacf_get_tolerance(o)
  # @param [AubioPitchspecacfT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitchspecacf_get_tolerance, :aubio_pitchspecacf_get_tolerance, [AubioPitchspecacfT], :float

  # (Not documented)
  #
  # @method aubio_pitchspecacf_set_tolerance(o, tol)
  # @param [AubioPitchspecacfT] o
  # @param [Float] tol
  # @return [Integer]
  # @scope class
  attach_function :aubio_pitchspecacf_set_tolerance, :aubio_pitchspecacf_set_tolerance, [AubioPitchspecacfT, :float], :uint

  # (Not documented)
  #
  # @method aubio_pitchspecacf_get_confidence(o)
  # @param [AubioPitchspecacfT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitchspecacf_get_confidence, :aubio_pitchspecacf_get_confidence, [AubioPitchspecacfT], :float

  # (Not documented)
  class AubioPitchyinT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_pitchyin(buf_size)
  # @param [Integer] buf_size
  # @return [AubioPitchyinT]
  # @scope class
  attach_function :new_aubio_pitchyin, :new_aubio_pitchyin, [:uint], AubioPitchyinT

  # (Not documented)
  #
  # @method del_aubio_pitchyin(o)
  # @param [AubioPitchyinT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pitchyin, :del_aubio_pitchyin, [AubioPitchyinT], :void

  # (Not documented)
  #
  # @method aubio_pitchyin_do(o, samples_in, cands_out)
  # @param [AubioPitchyinT] o
  # @param [FvecT] samples_in
  # @param [FvecT] cands_out
  # @return [nil]
  # @scope class
  attach_function :aubio_pitchyin_do, :aubio_pitchyin_do, [AubioPitchyinT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_pitchyin_set_tolerance(o, tol)
  # @param [AubioPitchyinT] o
  # @param [Float] tol
  # @return [Integer]
  # @scope class
  attach_function :aubio_pitchyin_set_tolerance, :aubio_pitchyin_set_tolerance, [AubioPitchyinT, :float], :uint

  # (Not documented)
  #
  # @method aubio_pitchyin_get_tolerance(o)
  # @param [AubioPitchyinT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitchyin_get_tolerance, :aubio_pitchyin_get_tolerance, [AubioPitchyinT], :float

  # (Not documented)
  #
  # @method aubio_pitchyin_get_confidence(o)
  # @param [AubioPitchyinT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitchyin_get_confidence, :aubio_pitchyin_get_confidence, [AubioPitchyinT], :float

  # (Not documented)
  class AubioPitchyinfftT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method aubio_pitchyinfft_do(o, samples_in, cands_out)
  # @param [AubioPitchyinfftT] o
  # @param [FvecT] samples_in
  # @param [FvecT] cands_out
  # @return [nil]
  # @scope class
  attach_function :aubio_pitchyinfft_do, :aubio_pitchyinfft_do, [AubioPitchyinfftT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method new_aubio_pitchyinfft(samplerate, buf_size)
  # @param [Integer] samplerate
  # @param [Integer] buf_size
  # @return [AubioPitchyinfftT]
  # @scope class
  attach_function :new_aubio_pitchyinfft, :new_aubio_pitchyinfft, [:uint, :uint], AubioPitchyinfftT

  # (Not documented)
  #
  # @method del_aubio_pitchyinfft(o)
  # @param [AubioPitchyinfftT] o
  # @return [nil]
  # @scope class
  attach_function :del_aubio_pitchyinfft, :del_aubio_pitchyinfft, [AubioPitchyinfftT], :void

  # (Not documented)
  #
  # @method aubio_pitchyinfft_get_tolerance(o)
  # @param [AubioPitchyinfftT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitchyinfft_get_tolerance, :aubio_pitchyinfft_get_tolerance, [AubioPitchyinfftT], :float

  # (Not documented)
  #
  # @method aubio_pitchyinfft_set_tolerance(o, tol)
  # @param [AubioPitchyinfftT] o
  # @param [Float] tol
  # @return [Integer]
  # @scope class
  attach_function :aubio_pitchyinfft_set_tolerance, :aubio_pitchyinfft_set_tolerance, [AubioPitchyinfftT, :float], :uint

  # (Not documented)
  #
  # @method aubio_pitchyinfft_get_confidence(o)
  # @param [AubioPitchyinfftT] o
  # @return [Float]
  # @scope class
  attach_function :aubio_pitchyinfft_get_confidence, :aubio_pitchyinfft_get_confidence, [AubioPitchyinfftT], :float

  # (Not documented)
  class AubioBeattrackingT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_beattracking(winlen, hop_size, samplerate)
  # @param [Integer] winlen
  # @param [Integer] hop_size
  # @param [Integer] samplerate
  # @return [AubioBeattrackingT]
  # @scope class
  attach_function :new_aubio_beattracking, :new_aubio_beattracking, [:uint, :uint, :uint], AubioBeattrackingT

  # (Not documented)
  #
  # @method aubio_beattracking_do(bt, dfframes, out)
  # @param [AubioBeattrackingT] bt
  # @param [FvecT] dfframes
  # @param [FvecT] out
  # @return [nil]
  # @scope class
  attach_function :aubio_beattracking_do, :aubio_beattracking_do, [AubioBeattrackingT, FvecT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_beattracking_get_period(bt)
  # @param [AubioBeattrackingT] bt
  # @return [Float]
  # @scope class
  attach_function :aubio_beattracking_get_period, :aubio_beattracking_get_period, [AubioBeattrackingT], :float

  # (Not documented)
  #
  # @method aubio_beattracking_get_period_s(bt)
  # @param [AubioBeattrackingT] bt
  # @return [Float]
  # @scope class
  attach_function :aubio_beattracking_get_period_s, :aubio_beattracking_get_period_s, [AubioBeattrackingT], :float

  # (Not documented)
  #
  # @method aubio_beattracking_get_bpm(bt)
  # @param [AubioBeattrackingT] bt
  # @return [Float]
  # @scope class
  attach_function :aubio_beattracking_get_bpm, :aubio_beattracking_get_bpm, [AubioBeattrackingT], :float

  # (Not documented)
  #
  # @method aubio_beattracking_get_confidence(bt)
  # @param [AubioBeattrackingT] bt
  # @return [Float]
  # @scope class
  attach_function :aubio_beattracking_get_confidence, :aubio_beattracking_get_confidence, [AubioBeattrackingT], :float

  # (Not documented)
  #
  # @method del_aubio_beattracking(p)
  # @param [AubioBeattrackingT] p
  # @return [nil]
  # @scope class
  attach_function :del_aubio_beattracking, :del_aubio_beattracking, [AubioBeattrackingT], :void

  # (Not documented)
  class AubioHistT < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method new_aubio_hist(flow, fhig, nelems)
  # @param [Float] flow
  # @param [Float] fhig
  # @param [Integer] nelems
  # @return [AubioHistT]
  # @scope class
  attach_function :new_aubio_hist, :new_aubio_hist, [:float, :float, :uint], AubioHistT

  # (Not documented)
  #
  # @method del_aubio_hist(s)
  # @param [AubioHistT] s
  # @return [nil]
  # @scope class
  attach_function :del_aubio_hist, :del_aubio_hist, [AubioHistT], :void

  # (Not documented)
  #
  # @method aubio_hist_do(s, input)
  # @param [AubioHistT] s
  # @param [FvecT] input
  # @return [nil]
  # @scope class
  attach_function :aubio_hist_do, :aubio_hist_do, [AubioHistT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_hist_do_notnull(s, input)
  # @param [AubioHistT] s
  # @param [FvecT] input
  # @return [nil]
  # @scope class
  attach_function :aubio_hist_do_notnull, :aubio_hist_do_notnull, [AubioHistT, FvecT], :void

  # (Not documented)
  #
  # @method aubio_hist_mean(s)
  # @param [AubioHistT] s
  # @return [Float]
  # @scope class
  attach_function :aubio_hist_mean, :aubio_hist_mean, [AubioHistT], :float

  # (Not documented)
  #
  # @method aubio_hist_weight(s)
  # @param [AubioHistT] s
  # @return [nil]
  # @scope class
  attach_function :aubio_hist_weight, :aubio_hist_weight, [AubioHistT], :void

  # (Not documented)
  #
  # @method aubio_hist_dyn_notnull(s, input)
  # @param [AubioHistT] s
  # @param [FvecT] input
  # @return [nil]
  # @scope class
  attach_function :aubio_hist_dyn_notnull, :aubio_hist_dyn_notnull, [AubioHistT, FvecT], :void

  # (Not documented)
  class AubioScaleT < FFI::Struct
    layout :dummy, :char
  end

  # create a scale object
  #
  # @method new_aubio_scale(flow, fhig, ilow, ihig)
  # @param [Float] flow lower value of output function
  # @param [Float] fhig higher value of output function
  # @param [Float] ilow lower value of input function
  # @param [Float] ihig higher value of output function
  # @return [AubioScaleT]
  # @scope class
  attach_function :new_aubio_scale, :new_aubio_scale, [:float, :float, :float, :float], AubioScaleT

  # delete a scale object
  #
  # @method del_aubio_scale(s)
  # @param [AubioScaleT] s scale object as returned by new_aubio_scale
  # @return [nil]
  # @scope class
  attach_function :del_aubio_scale, :del_aubio_scale, [AubioScaleT], :void

  # scale input vector
  #
  # @method aubio_scale_do(s, input)
  # @param [AubioScaleT] s scale object as returned by new_aubio_scale
  # @param [FvecT] input vector to scale
  # @return [nil]
  # @scope class
  attach_function :aubio_scale_do, :aubio_scale_do, [AubioScaleT, FvecT], :void

  # modify scale parameters after object creation
  #
  # @method aubio_scale_set_limits(s, ilow, ihig, olow, ohig)
  # @param [AubioScaleT] s scale object as returned by new_aubio_scale
  # @param [Float] ilow lower value of input function
  # @param [Float] ihig higher value of output function
  # @param [Float] olow lower value of output function
  # @param [Float] ohig higher value of output function
  # @return [Integer]
  # @scope class
  attach_function :aubio_scale_set_limits, :aubio_scale_set_limits, [AubioScaleT, :float, :float, :float, :float], :uint

end
