# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.volume_mapper import VolumeMapper


class MultiBlockVolumeMapper(VolumeMapper):
    """
    MultiBlockVolumeMapper - Mapper to render volumes defined as
    MultiBlockDataSet.
    
    Superclass: VolumeMapper
    
    MultiBlockVolumeMapper renders MultiBlockDataSet instances
    containing ImageData blocks (all of the blocks are expected to be
    ImageData). Bounds containing the full set of blocks are computed
    so that Renderer can adjust the clipping planes appropriately.
    
    This mapper creates an instance of SmartVolumeMapper per block to
    which it defers the actual rendering.  At render time, blocks
    (mappers) are sorted back-to-front and each block is rendered
    independently.  It attempts to load all of the blocks at the same
    time but tries to catch allocation errors in which case it falls back
    to using a single mapper instance and reloading data for each block.
    
    Jittering is used to alleviate seam artifacts at the block edges due
    to the discontinuous resolution between blocks.  Jittering is enabled
    by default. Jittering is only supported in gpu_render_mode.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMultiBlockVolumeMapper, obj, update, **traits)
    
    array_access_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        API Superclass
        \sa AbstractVolumeMapper
        """
    )

    def _array_access_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayAccessMode,
                        self.array_access_mode)

    cropping_region_planes = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(0.0, 1.0, 0.0, 1.0, 0.0, 1.0), cols=3, desc=\
        """
        \sa VolumeMapper::SetCroppingRegionPlanes
        """
    )

    def _cropping_region_planes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCroppingRegionPlanes,
                        self.cropping_region_planes)

    vector_component = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        vector_mode interface exposed from SmartVolumeMapper.
        """
    )

    def _vector_component_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVectorComponent,
                        self.vector_component)

    vector_mode = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        """
        vector_mode interface exposed from SmartVolumeMapper.
        """
    )

    def _vector_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVectorMode,
                        self.vector_mode)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> ImageData
        C++: virtual ImageData *GetInput()
        V.get_input(int) -> ImageData
        C++: virtual ImageData *GetInput(const int port)
        Set/Get the input data
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('cropping', 'GetCropping'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('blend_mode',
    'GetBlendMode'), ('cropping_region_flags', 'GetCroppingRegionFlags'),
    ('scalar_mode', 'GetScalarMode'), ('array_access_mode',
    'GetArrayAccessMode'), ('cropping_region_planes',
    'GetCroppingRegionPlanes'), ('vector_component',
    'GetVectorComponent'), ('vector_mode', 'GetVectorMode'),
    ('average_ip_scalar_range', 'GetAverageIPScalarRange'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'cropping', 'debug', 'global_warning_display',
    'release_data_flag', 'blend_mode', 'cropping_region_flags',
    'scalar_mode', 'array_access_mode', 'average_ip_scalar_range',
    'cropping_region_planes', 'progress_text', 'vector_component',
    'vector_mode'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MultiBlockVolumeMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MultiBlockVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['cropping'], ['blend_mode', 'cropping_region_flags',
            'scalar_mode'], ['array_access_mode', 'average_ip_scalar_range',
            'cropping_region_planes', 'vector_component', 'vector_mode']),
            title='Edit MultiBlockVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MultiBlockVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

