# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class PlaneCutter(DataSetAlgorithm):
    """
    PlaneCutter - cut any dataset with a plane and generate a
    polygonal cut surface
    
    Superclass: DataSetAlgorithm
    
    PlaneCutter is a specialization of the Cutter algorithm to cut
    a dataset grid with a single plane. It is designed for performance
    and an exploratory, fast workflow. It produces output polygons that
    result from cutting the icnput dataset with the specified plane.
    
    This algorithm is fast because it is threaded, and may build (in a
    preprocessing step) a spatial search structure that accelerates the
    plane cuts. The search structure, which is typically a sphere tree,
    is used to quickly cull candidate cells. Also unlike Cutter, the
    Plane implicit function (representing the plane) does not need to
    be evaluated with each cut. (Note that other methods of acceleration
    are delegated to for image data, see FlyingEdgesPlaneCutter
    documentation.)
    
    Because this filter builds an initial data structure during a
    preprocessing step, the first execution of the filter may take longer
    than subsequent operations. Typically the first execution is still
    faster than Cutter (especially with threading enabled), but for
    certain types of data this may not be true. However if you are using
    the filter to cut a dataset multiple times (as in an exploratory or
    interactive workflow) this filter works well.
    
    @warning
    This filter outputs a MultiPieceDataSet.
    
    @warning
    This filter delegates to FlyingEdgesPlaneCutter to process image
    data, but output and input have been standardized when possible.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    Cutter FlyingEdgesPlaneCutter Plane
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPlaneCutter, obj, update, **traits)
    
    build_hierarchy = tvtk_base.true_bool_trait(desc=\
        """
        Indicate whether to build tree hierarchy. Computing the tree
        hierarchy can take some time on the first computation but if the
        input does not change, the computation of all further slice will
        be faster. Default is on.
        """
    )

    def _build_hierarchy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildHierarchy,
                        self.build_hierarchy_)

    build_tree = tvtk_base.true_bool_trait(desc=\
        """
        Indicate whether to build the sphere tree. Computing the sphere
        will take some time on the first computation but if the input
        does not change, the computation of all further slice will be
        much faster. Default is on.
        """
    )

    def _build_tree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildTree,
                        self.build_tree_)

    compute_normals = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get the computation of normals. The normal generated is
        simply the cut plane normal. The normal, if generated, is defined
        by cell data associated with the output polygons. By default
        computing of normals is disabled.
        """
    )

    def _compute_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormals,
                        self.compute_normals_)

    generate_polygons = tvtk_base.true_bool_trait(desc=\
        """
        Indicate whether to generate polygons instead of triangles when
        cutting structured and rectilinear grid. No effect with other
        kinds of inputs, enabled by default.
        """
    )

    def _generate_polygons_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGeneratePolygons,
                        self.generate_polygons_)

    interpolate_attributes = tvtk_base.true_bool_trait(desc=\
        """
        Indicate whether to interpolate attribute data. By default this
        is enabled. Note that both cell data and point data is
        interpolated and outputted, except for image data input where
        only point data are outputted.
        """
    )

    def _interpolate_attributes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateAttributes,
                        self.interpolate_attributes_)

    def _get_plane(self):
        return wrap_vtk(self._vtk_obj.GetPlane())
    def _set_plane(self, arg):
        old_val = self._get_plane()
        self._wrap_call(self._vtk_obj.SetPlane,
                        deref_vtk(arg))
        self.trait_property_changed('plane', old_val, arg)
    plane = traits.Property(_get_plane, _set_plane, desc=\
        """
        Specify the plane (an implicit function) to perform the cutting.
        The definition of the plane (its origin and normal) is controlled
        via this instance of Plane.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('build_hierarchy', 'GetBuildHierarchy'), ('build_tree',
    'GetBuildTree'), ('compute_normals', 'GetComputeNormals'),
    ('generate_polygons', 'GetGeneratePolygons'),
    ('interpolate_attributes', 'GetInterpolateAttributes'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'build_hierarchy', 'build_tree', 'compute_normals',
    'debug', 'generate_polygons', 'global_warning_display',
    'interpolate_attributes', 'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PlaneCutter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['build_hierarchy', 'build_tree', 'compute_normals',
            'generate_polygons', 'interpolate_attributes'], [], []),
            title='Edit PlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

