  JAAppletContext = interface external 'java.applet' name 'AppletContext' 
    function getAudioClip(para1: JNURL): JAAudioClip; overload;
    function getImage(para1: JNURL): JAImage; overload;
    function getApplet(para1: JLString): JAApplet; overload;
    function getApplets(): JUEnumeration; overload;
    procedure showDocument(para1: JNURL); overload;
    procedure showDocument(para1: JNURL; para2: JLString); overload;
    procedure showStatus(para1: JLString); overload;
    procedure setStream(para1: JLString; para2: JIInputStream); overload;  // throws java.io.IOException
    function getStream(para1: JLString): JIInputStream; overload;
    function getStreamKeys(): JUIterator; overload;
  end;

  JAAppletStub = interface external 'java.applet' name 'AppletStub' 
    function isActive(): jboolean; overload;
    function getDocumentBase(): JNURL; overload;
    function getCodeBase(): JNURL; overload;
    function getParameter(para1: JLString): JLString; overload;
    function getAppletContext(): JAAppletContext; overload;
    procedure appletResize(para1: jint; para2: jint); overload;
  end;

  JAAudioClip = interface external 'java.applet' name 'AudioClip' 
    procedure play(); overload;
    procedure loop(); overload;
    procedure stop(); overload;
  end;

  JAActiveEvent = interface external 'java.awt' name 'ActiveEvent' 
    procedure dispatch(); overload;
  end;

  JAAdjustable = interface external 'java.awt' name 'Adjustable' 
    const
      HORIZONTAL = 0;
      VERTICAL = 1;
      NO_ORIENTATION = 2;
    function getOrientation(): jint; overload;
    procedure setMinimum(para1: jint); overload;
    function getMinimum(): jint; overload;
    procedure setMaximum(para1: jint); overload;
    function getMaximum(): jint; overload;
    procedure setUnitIncrement(para1: jint); overload;
    function getUnitIncrement(): jint; overload;
    procedure setBlockIncrement(para1: jint); overload;
    function getBlockIncrement(): jint; overload;
    procedure setVisibleAmount(para1: jint); overload;
    function getVisibleAmount(): jint; overload;
    procedure setValue(para1: jint); overload;
    function getValue(): jint; overload;
    procedure addAdjustmentListener(para1: JAEAdjustmentListener); overload;
    procedure removeAdjustmentListener(para1: JAEAdjustmentListener); overload;
  end;

  JAAttributeValue = class abstract external 'java.awt' name 'AttributeValue' (JLObject)
  strict protected
    constructor create(para1: jint; para2: Arr1JLString); overload;
    constructor create(para1: jint; const para2: array of JLString); overload;
  public
    function hashCode(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JAComposite = interface external 'java.awt' name 'Composite' 
    function createContext(para1: JAIColorModel; para2: JAIColorModel; para3: JARenderingHints): JACompositeContext; overload;
  end;

  JACompositeContext = interface external 'java.awt' name 'CompositeContext' 
    procedure dispose(); overload;
    procedure compose(para1: JAIRaster; para2: JAIRaster; para3: JAIWritableRaster); overload;
  end;

  JAConditional = interface external 'java.awt' name 'Conditional' 
    function evaluate(): jboolean; overload;
  end;

  JADisplayMode = class sealed external 'java.awt' name 'DisplayMode' (JLObject)
  public
    const
      BIT_DEPTH_MULTI = -1;
      REFRESH_RATE_UNKNOWN = 0;
  public
    constructor create(para1: jint; para2: jint; para3: jint; para4: jint); overload;
    function getHeight(): jint; overload; virtual;
    function getWidth(): jint; overload; virtual;
    function getBitDepth(): jint; overload; virtual;
    function getRefreshRate(): jint; overload; virtual;
    function equals(para1: JADisplayMode): jboolean; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  JAEventQueue = class external 'java.awt' name 'EventQueue' (JLObject)
  public
    constructor create(); overload;
    procedure postEvent(para1: JAAWTEvent); overload; virtual;
    function getNextEvent(): JAAWTEvent; overload; virtual;  // throws java.lang.InterruptedException
    function peekEvent(): JAAWTEvent; overload; virtual;
    function peekEvent(para1: jint): JAAWTEvent; overload; virtual;
  strict protected
    procedure dispatchEvent(para1: JAAWTEvent); overload; virtual;
  public
    class function getMostRecentEventTime(): jlong; static; overload;
    class function getCurrentEvent(): JAAWTEvent; static; overload;
    procedure push(para1: JAEventQueue); overload; virtual;
  strict protected
    procedure pop(); overload; virtual;  // throws java.util.EmptyStackException
  public
    class function isDispatchThread(): jboolean; static; overload;
    class procedure invokeLater(para1: JLRunnable); static; overload;
    class procedure invokeAndWait(para1: JLRunnable); static; overload;  // throws java.lang.InterruptedException, java.lang.reflect.InvocationTargetException
  end;

  JAEventQueueItem = class external 'java.awt' name 'EventQueueItem' (JLObject)
  end;

  JAFocusTraversalPolicy = class abstract external 'java.awt' name 'FocusTraversalPolicy' (JLObject)
  public
    constructor create(); overload;
    function getComponentAfter(para1: JAContainer; para2: JAComponent): JAComponent; overload; virtual; abstract;
    function getComponentBefore(para1: JAContainer; para2: JAComponent): JAComponent; overload; virtual; abstract;
    function getFirstComponent(para1: JAContainer): JAComponent; overload; virtual; abstract;
    function getLastComponent(para1: JAContainer): JAComponent; overload; virtual; abstract;
    function getDefaultComponent(para1: JAContainer): JAComponent; overload; virtual; abstract;
    function getInitialComponent(para1: JAWindow): JAComponent; overload; virtual;
  end;

  JAGraphics = class abstract external 'java.awt' name 'Graphics' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function create_(): JAGraphics; external name 'create'; overload; virtual; abstract;
    function create_(para1: jint; para2: jint; para3: jint; para4: jint): JAGraphics; external name 'create'; overload; virtual;
    procedure translate(para1: jint; para2: jint); overload; virtual; abstract;
    function getColor(): JAColor; overload; virtual; abstract;
    procedure setColor(para1: JAColor); overload; virtual; abstract;
    procedure setPaintMode(); overload; virtual; abstract;
    procedure setXORMode(para1: JAColor); overload; virtual; abstract;
    function getFont(): JAFont; overload; virtual; abstract;
    procedure setFont(para1: JAFont); overload; virtual; abstract;
    function getFontMetrics(): JAFontMetrics; overload; virtual;
    function getFontMetrics(para1: JAFont): JAFontMetrics; overload; virtual; abstract;
    function getClipBounds(): JARectangle; overload; virtual; abstract;
    procedure clipRect(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual; abstract;
    procedure setClip(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual; abstract;
    function getClip(): JAShape; overload; virtual; abstract;
    procedure setClip(para1: JAShape); overload; virtual; abstract;
    procedure copyArea(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual; abstract;
    procedure drawLine(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual; abstract;
    procedure fillRect(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual; abstract;
    procedure drawRect(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual;
    procedure clearRect(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual; abstract;
    procedure drawRoundRect(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual; abstract;
    procedure fillRoundRect(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual; abstract;
    procedure draw3DRect(para1: jint; para2: jint; para3: jint; para4: jint; para5: jboolean); overload; virtual;
    procedure fill3DRect(para1: jint; para2: jint; para3: jint; para4: jint; para5: jboolean); overload; virtual;
    procedure drawOval(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual; abstract;
    procedure fillOval(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual; abstract;
    procedure drawArc(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual; abstract;
    procedure fillArc(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual; abstract;
    procedure drawPolyline(para1: Arr1jint; para2: Arr1jint; para3: jint); overload; virtual; abstract;
    procedure drawPolyline(var para1: array of jint; var para2: array of jint; para3: jint); overload; virtual; abstract;
    procedure drawPolygon(para1: Arr1jint; para2: Arr1jint; para3: jint); overload; virtual; abstract;
    procedure drawPolygon(var para1: array of jint; var para2: array of jint; para3: jint); overload; virtual; abstract;
    procedure drawPolygon(para1: JAPolygon); overload; virtual;
    procedure fillPolygon(para1: Arr1jint; para2: Arr1jint; para3: jint); overload; virtual; abstract;
    procedure fillPolygon(var para1: array of jint; var para2: array of jint; para3: jint); overload; virtual; abstract;
    procedure fillPolygon(para1: JAPolygon); overload; virtual;
    procedure drawString(para1: JLString; para2: jint; para3: jint); overload; virtual; abstract;
    procedure drawString(para1: JTAttributedCharacterIterator; para2: jint; para3: jint); overload; virtual; abstract;
    procedure drawChars(para1: Arr1jchar; para2: jint; para3: jint; para4: jint; para5: jint); overload; virtual;
    procedure drawChars(var para1: array of jchar; para2: jint; para3: jint; para4: jint; para5: jint); overload; virtual;
    procedure drawBytes(para1: Arr1jbyte; para2: jint; para3: jint; para4: jint; para5: jint); overload; virtual;
    procedure drawBytes(var para1: array of jbyte; para2: jint; para3: jint; para4: jint; para5: jint); overload; virtual;
    function drawImage(para1: JAImage; para2: jint; para3: jint; para4: JAIImageObserver): jboolean; overload; virtual; abstract;
    function drawImage(para1: JAImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: JAIImageObserver): jboolean; overload; virtual; abstract;
    function drawImage(para1: JAImage; para2: jint; para3: jint; para4: JAColor; para5: JAIImageObserver): jboolean; overload; virtual; abstract;
    function drawImage(para1: JAImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: JAColor; para7: JAIImageObserver): jboolean; overload; virtual; abstract;
    function drawImage(para1: JAImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint; para9: jint; para10: JAIImageObserver): jboolean; overload; virtual; abstract;
    function drawImage(para1: JAImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint; para9: jint; para10: JAColor; para11: JAIImageObserver): jboolean; overload; virtual; abstract;
    procedure dispose(); overload; virtual; abstract;
    procedure finalize(); overload; virtual;
    function toString(): JLString; overload; virtual;
    function getClipRect(): JARectangle; overload; virtual;
    function hitClip(para1: jint; para2: jint; para3: jint; para4: jint): jboolean; overload; virtual;
    function getClipBounds(para1: JARectangle): JARectangle; overload; virtual;
  end;

  JAGraphicsConfiguration = class abstract external 'java.awt' name 'GraphicsConfiguration' (JLObject)
  public
    type
      InnerDefaultBufferCapabilities = class;
      Arr1InnerDefaultBufferCapabilities = array of InnerDefaultBufferCapabilities;
      Arr2InnerDefaultBufferCapabilities = array of Arr1InnerDefaultBufferCapabilities;
      Arr3InnerDefaultBufferCapabilities = array of Arr2InnerDefaultBufferCapabilities;
      InnerDefaultBufferCapabilities = class external 'java.awt' name 'DefaultBufferCapabilities' 
      end;

  strict protected
    constructor create(); overload;
  public
    function getDevice(): JAGraphicsDevice; overload; virtual; abstract;
    function createCompatibleImage(para1: jint; para2: jint): JAIBufferedImage; overload; virtual; abstract;
    function createCompatibleImage(para1: jint; para2: jint; para3: jint): JAIBufferedImage; overload; virtual;
    function createCompatibleVolatileImage(para1: jint; para2: jint): JAIVolatileImage; overload; virtual;
    function createCompatibleVolatileImage(para1: jint; para2: jint; para3: jint): JAIVolatileImage; overload; virtual;
    function createCompatibleVolatileImage(para1: jint; para2: jint; para3: JAImageCapabilities): JAIVolatileImage; overload; virtual;  // throws java.awt.AWTException
    function createCompatibleVolatileImage(para1: jint; para2: jint; para3: JAImageCapabilities; para4: jint): JAIVolatileImage; overload; virtual;  // throws java.awt.AWTException
    function getColorModel(): JAIColorModel; overload; virtual; abstract;
    function getColorModel(para1: jint): JAIColorModel; overload; virtual; abstract;
    function getDefaultTransform(): JAGAffineTransform; overload; virtual; abstract;
    function getNormalizingTransform(): JAGAffineTransform; overload; virtual; abstract;
    function getBounds(): JARectangle; overload; virtual; abstract;
    function getBufferCapabilities(): JABufferCapabilities; overload; virtual;
    function getImageCapabilities(): JAImageCapabilities; overload; virtual;
  end;

  JAGraphicsDevice = class abstract external 'java.awt' name 'GraphicsDevice' (JLObject)
  public
    const
      TYPE_RASTER_SCREEN = 0;
      TYPE_PRINTER = 1;
      TYPE_IMAGE_BUFFER = 2;
  strict protected
    constructor create(); overload;
  public
    function getType(): jint; overload; virtual; abstract;
    function getIDstring(): JLString; overload; virtual; abstract;
    function getConfigurations(): Arr1JAGraphicsConfiguration; overload; virtual; abstract;
    function getDefaultConfiguration(): JAGraphicsConfiguration; overload; virtual; abstract;
    function getBestConfiguration(para1: JAGraphicsConfigTemplate): JAGraphicsConfiguration; overload; virtual;
    function isFullScreenSupported(): jboolean; overload; virtual;
    procedure setFullScreenWindow(para1: JAWindow); overload; virtual;
    function getFullScreenWindow(): JAWindow; overload; virtual;
    function isDisplayChangeSupported(): jboolean; overload; virtual;
    procedure setDisplayMode(para1: JADisplayMode); overload; virtual;
    function getDisplayMode(): JADisplayMode; overload; virtual;
    function getDisplayModes(): Arr1JADisplayMode; overload; virtual;
    function getAvailableAcceleratedMemory(): jint; overload; virtual;
  end;

  JAGraphicsEnvironment = class abstract external 'java.awt' name 'GraphicsEnvironment' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function getLocalGraphicsEnvironment(): JAGraphicsEnvironment; static; overload;
    class function isHeadless(): jboolean; static; overload;
    function isHeadlessInstance(): jboolean; overload; virtual;
    function getScreenDevices(): Arr1JAGraphicsDevice; overload; virtual; abstract;  // throws java.awt.HeadlessException
    function getDefaultScreenDevice(): JAGraphicsDevice; overload; virtual; abstract;  // throws java.awt.HeadlessException
    function createGraphics(para1: JAIBufferedImage): JAGraphics2D; overload; virtual; abstract;
    function getAllFonts(): Arr1JAFont; overload; virtual; abstract;
    function getAvailableFontFamilyNames(): Arr1JLString; overload; virtual; abstract;
    function getAvailableFontFamilyNames(para1: JULocale): Arr1JLString; overload; virtual; abstract;
    function registerFont(para1: JAFont): jboolean; overload; virtual;
    procedure preferLocaleFonts(); overload; virtual;
    procedure preferProportionalFonts(); overload; virtual;
    function getCenterPoint(): JAPoint; overload; virtual;  // throws java.awt.HeadlessException
    function getMaximumWindowBounds(): JARectangle; overload; virtual;  // throws java.awt.HeadlessException
  end;

  JAImage = class abstract external 'java.awt' name 'Image' (JLObject)
  strict protected
    var
      faccelerationPriority: jfloat; external name 'accelerationPriority';
  public
    final class var
      fUndefinedProperty: JLObject; external name 'UndefinedProperty';
  public
    const
      SCALE_DEFAULT = 1;
      SCALE_FAST = 2;
      SCALE_SMOOTH = 4;
      SCALE_REPLICATE = 8;
      SCALE_AREA_AVERAGING = 16;
  public
    constructor create(); overload;
    function getWidth(para1: JAIImageObserver): jint; overload; virtual; abstract;
    function getHeight(para1: JAIImageObserver): jint; overload; virtual; abstract;
    function getSource(): JAIImageProducer; overload; virtual; abstract;
    function getGraphics(): JAGraphics; overload; virtual; abstract;
    function getProperty(para1: JLString; para2: JAIImageObserver): JLObject; overload; virtual; abstract;
    function getScaledInstance(para1: jint; para2: jint; para3: jint): JAImage; overload; virtual;
    procedure flush(); overload; virtual;
    function getCapabilities(para1: JAGraphicsConfiguration): JAImageCapabilities; overload; virtual;
    procedure setAccelerationPriority(para1: jfloat); overload; virtual;
    function getAccelerationPriority(): jfloat; overload; virtual;
  end;

  JAItemSelectable = interface external 'java.awt' name 'ItemSelectable' 
    function getSelectedObjects(): Arr1JLObject; overload;
    procedure addItemListener(para1: JAEItemListener); overload;
    procedure removeItemListener(para1: JAEItemListener); overload;
  end;

  JAKeyEventDispatcher = interface external 'java.awt' name 'KeyEventDispatcher' 
    function dispatchKeyEvent(para1: JAEKeyEvent): jboolean; overload;
  end;

  JAKeyEventPostProcessor = interface external 'java.awt' name 'KeyEventPostProcessor' 
    function postProcessKeyEvent(para1: JAEKeyEvent): jboolean; overload;
  end;

  JALayoutManager = interface external 'java.awt' name 'LayoutManager' 
    procedure addLayoutComponent(para1: JLString; para2: JAComponent); overload;
    procedure removeLayoutComponent(para1: JAComponent); overload;
    function preferredLayoutSize(para1: JAContainer): JADimension; overload;
    function minimumLayoutSize(para1: JAContainer): JADimension; overload;
    procedure layoutContainer(para1: JAContainer); overload;
  end;

  JAMediaEntry = class abstract external 'java.awt' name 'MediaEntry' (JLObject)
  end;

  JAMenuContainer = interface external 'java.awt' name 'MenuContainer' 
    function getFont(): JAFont; overload;
    procedure remove(para1: JAMenuComponent); overload;
    function postEvent(para1: JAEvent): jboolean; overload;
  end;

  JAMouseInfo = class external 'java.awt' name 'MouseInfo' (JLObject)
  public
    class function getPointerInfo(): JAPointerInfo; static; overload;  // throws java.awt.HeadlessException
    class function getNumberOfButtons(): jint; static; overload;  // throws java.awt.HeadlessException
  end;

  JAMutableBoolean = class external 'java.awt' name 'MutableBoolean' (JLObject)
  end;

  JAPaintContext = interface external 'java.awt' name 'PaintContext' 
    procedure dispose(); overload;
    function getColorModel(): JAIColorModel; overload;
    function getRaster(para1: jint; para2: jint; para3: jint; para4: jint): JAIRaster; overload;
  end;

  JAPointerInfo = class external 'java.awt' name 'PointerInfo' (JLObject)
  public
    function getDevice(): JAGraphicsDevice; overload; virtual;
    function getLocation(): JAPoint; overload; virtual;
  end;

  JAPrintGraphics = interface external 'java.awt' name 'PrintGraphics' 
    function getPrintJob(): JAPrintJob; overload;
  end;

  JAPrintJob = class abstract external 'java.awt' name 'PrintJob' (JLObject)
  public
    constructor create(); overload;
    function getGraphics(): JAGraphics; overload; virtual; abstract;
    function getPageDimension(): JADimension; overload; virtual; abstract;
    function getPageResolution(): jint; overload; virtual; abstract;
    function lastPageFirst(): jboolean; overload; virtual; abstract;
    procedure &end(); overload; virtual; abstract;
    procedure finalize(); overload; virtual;
  end;

  JAQueue = class external 'java.awt' name 'Queue' (JLObject)
  end;

  JARobot = class external 'java.awt' name 'Robot' (JLObject)
  public
    type
      InnerRobotDisposer = class;
      Arr1InnerRobotDisposer = array of InnerRobotDisposer;
      Arr2InnerRobotDisposer = array of Arr1InnerRobotDisposer;
      Arr3InnerRobotDisposer = array of Arr2InnerRobotDisposer;
      InnerRobotDisposer = class external 'java.awt' name 'RobotDisposer' 
      end;

  public
    constructor create(); overload;  // throws java.awt.AWTException
    constructor create(para1: JAGraphicsDevice); overload;  // throws java.awt.AWTException
    procedure mouseMove(para1: jint; para2: jint); overload; virtual;
    procedure mousePress(para1: jint); overload; virtual;
    procedure mouseRelease(para1: jint); overload; virtual;
    procedure mouseWheel(para1: jint); overload; virtual;
    procedure keyPress(para1: jint); overload; virtual;
    procedure keyRelease(para1: jint); overload; virtual;
    function getPixelColor(para1: jint; para2: jint): JAColor; overload; virtual;
    function createScreenCapture(para1: JARectangle): JAIBufferedImage; overload; virtual;
    function isAutoWaitForIdle(): jboolean; overload; virtual;
    procedure setAutoWaitForIdle(para1: jboolean); overload; virtual;
    function getAutoDelay(): jint; overload; virtual;
    procedure setAutoDelay(para1: jint); overload; virtual;
    procedure delay(para1: jint); overload; virtual;
    procedure waitForIdle(); overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JAShape = interface external 'java.awt' name 'Shape' 
    function getBounds(): JARectangle; overload;
    function getBounds2D(): JAGRectangle2D; overload;
    function contains(para1: jdouble; para2: jdouble): jboolean; overload;
    function contains(para1: JAGPoint2D): jboolean; overload;
    function intersects(para1: jdouble; para2: jdouble; para3: jdouble; para4: jdouble): jboolean; overload;
    function intersects(para1: JAGRectangle2D): jboolean; overload;
    function contains(para1: jdouble; para2: jdouble; para3: jdouble; para4: jdouble): jboolean; overload;
    function contains(para1: JAGRectangle2D): jboolean; overload;
    function getPathIterator(para1: JAGAffineTransform): JAGPathIterator; overload;
    function getPathIterator(para1: JAGAffineTransform; para2: jdouble): JAGPathIterator; overload;
  end;

  JASplashScreen = class sealed external 'java.awt' name 'SplashScreen' (JLObject)
  public
    class function getSplashScreen(): JASplashScreen; static; overload;
    procedure setImageURL(para1: JNURL); overload; virtual;  // throws java.lang.NullPointerException, java.io.IOException, java.lang.IllegalStateException
    function getImageURL(): JNURL; overload; virtual;  // throws java.lang.IllegalStateException
    function getBounds(): JARectangle; overload; virtual;  // throws java.lang.IllegalStateException
    function getSize(): JADimension; overload; virtual;  // throws java.lang.IllegalStateException
    function createGraphics(): JAGraphics2D; overload; virtual;  // throws java.lang.IllegalStateException
    procedure update(); overload; virtual;  // throws java.lang.IllegalStateException
    procedure close(); overload; virtual;  // throws java.lang.IllegalStateException
    function isVisible(): jboolean; overload; virtual;
  end;

  JAStroke = interface external 'java.awt' name 'Stroke' 
    function createStrokedShape(para1: JAShape): JAShape; overload;
  end;

  JASystemTray = class external 'java.awt' name 'SystemTray' (JLObject)
  public
    class function getSystemTray(): JASystemTray; static; overload;
    class function isSupported(): jboolean; static; overload;
    procedure add(para1: JATrayIcon); overload; virtual;  // throws java.awt.AWTException
    procedure remove(para1: JATrayIcon); overload; virtual;
    function getTrayIcons(): Arr1JATrayIcon; overload; virtual;
    function getTrayIconSize(): JADimension; overload; virtual;
    procedure addPropertyChangeListener(para1: JLString; para2: JBPropertyChangeListener); overload; virtual;
    procedure removePropertyChangeListener(para1: JLString; para2: JBPropertyChangeListener); overload; virtual;
    function getPropertyChangeListeners(para1: JLString): Arr1JBPropertyChangeListener; overload; virtual;
  end;

  JATransparency = interface external 'java.awt' name 'Transparency' 
    const
      OPAQUE = 1;
      BITMASK = 2;
      TRANSLUCENT = 3;
    function getTransparency(): jint; overload;
  end;

  JAVKCollection = class external 'java.awt' name 'VKCollection' (JLObject)
  public
    constructor create(); overload;
    procedure put(para1: JLString; para2: JLInteger); overload; virtual;
    function findCode(para1: JLString): JLInteger; overload; virtual;
    function findName(para1: JLInteger): JLString; overload; virtual;
  end;

  JADClipboard = class external 'java.awt.datatransfer' name 'Clipboard' (JLObject)
  strict protected
    var
      fowner: JADClipboardOwner; external name 'owner';
      fcontents: JADTransferable; external name 'contents';
  public
    constructor create(para1: JLString); overload;
    function getName(): JLString; overload; virtual;
    procedure setContents(para1: JADTransferable; para2: JADClipboardOwner); overload; virtual;
    function getContents(para1: JLObject): JADTransferable; overload; virtual;
    function getAvailableDataFlavors(): Arr1JADDataFlavor; overload; virtual;
    function isDataFlavorAvailable(para1: JADDataFlavor): jboolean; overload; virtual;
    function getData(para1: JADDataFlavor): JLObject; overload; virtual;  // throws java.awt.datatransfer.UnsupportedFlavorException, java.io.IOException
    procedure addFlavorListener(para1: JADFlavorListener); overload; virtual;
    procedure removeFlavorListener(para1: JADFlavorListener); overload; virtual;
    function getFlavorListeners(): Arr1JADFlavorListener; overload; virtual;
  end;

  JADClipboardOwner = interface external 'java.awt.datatransfer' name 'ClipboardOwner' 
    procedure lostOwnership(para1: JADClipboard; para2: JADTransferable); overload;
  end;

  JADFlavorMap = interface external 'java.awt.datatransfer' name 'FlavorMap' 
    function getNativesForFlavors(para1: Arr1JADDataFlavor): JUMap; overload;
    function getNativesForFlavors(var para1: array of JADDataFlavor): JUMap; overload;
    function getFlavorsForNatives(para1: Arr1JLString): JUMap; overload;
    function getFlavorsForNatives(var para1: array of JLString): JUMap; overload;
  end;

  JADTransferable = interface external 'java.awt.datatransfer' name 'Transferable' 
    function getTransferDataFlavors(): Arr1JADDataFlavor; overload;
    function isDataFlavorSupported(para1: JADDataFlavor): jboolean; overload;
    function getTransferData(para1: JADDataFlavor): JLObject; overload;  // throws java.awt.datatransfer.UnsupportedFlavorException, java.io.IOException
  end;

  JADAutoscroll = interface external 'java.awt.dnd' name 'Autoscroll' 
    function getAutoscrollInsets(): JAInsets; overload;
    procedure autoscroll(para1: JAPoint); overload;
  end;

  JADDnDConstants = class sealed external 'java.awt.dnd' name 'DnDConstants' (JLObject)
  public
    const
      ACTION_NONE = 0;
      ACTION_COPY = 1;
      ACTION_MOVE = 2;
      ACTION_COPY_OR_MOVE = 3;
      ACTION_LINK = 1073741824;
      ACTION_REFERENCE = 1073741824;
  end;

  JADSerializationTester = class sealed external 'java.awt.dnd' name 'SerializationTester' (JLObject)
  end;

  JADPDragSourceContextPeer = interface external 'java.awt.dnd.peer' name 'DragSourceContextPeer' 
    procedure startDrag(para1: JADDragSourceContext; para2: JACursor; para3: JAImage; para4: JAPoint); overload;  // throws java.awt.dnd.InvalidDnDOperationException
    function getCursor(): JACursor; overload;
    procedure setCursor(para1: JACursor); overload;  // throws java.awt.dnd.InvalidDnDOperationException
    procedure transferablesFlavorsChanged(); overload;
  end;

  JADPDropTargetContextPeer = interface external 'java.awt.dnd.peer' name 'DropTargetContextPeer' 
    procedure setTargetActions(para1: jint); overload;
    function getTargetActions(): jint; overload;
    function getDropTarget(): JADDropTarget; overload;
    function getTransferDataFlavors(): Arr1JADDataFlavor; overload;
    function getTransferable(): JADTransferable; overload;  // throws java.awt.dnd.InvalidDnDOperationException
    function isTransferableJVMLocal(): jboolean; overload;
    procedure acceptDrag(para1: jint); overload;
    procedure rejectDrag(); overload;
    procedure acceptDrop(para1: jint); overload;
    procedure rejectDrop(); overload;
    procedure dropComplete(para1: jboolean); overload;
  end;

  JADPDropTargetPeer = interface external 'java.awt.dnd.peer' name 'DropTargetPeer' 
    procedure addDropTarget(para1: JADDropTarget); overload;
    procedure removeDropTarget(para1: JADDropTarget); overload;
  end;

  JAENativeLibLoader = class external 'java.awt.event' name 'NativeLibLoader' (JLObject)
  end;

  JAFFontRenderContext = class external 'java.awt.font' name 'FontRenderContext' (JLObject)
  strict protected
    constructor create(); overload;
  public
    constructor create(para1: JAGAffineTransform; para2: jboolean; para3: jboolean); overload;
    constructor create(para1: JAGAffineTransform; para2: JLObject; para3: JLObject); overload;
    function isTransformed(): jboolean; overload; virtual;
    function getTransformType(): jint; overload; virtual;
    function getTransform(): JAGAffineTransform; overload; virtual;
    function isAntiAliased(): jboolean; overload; virtual;
    function usesFractionalMetrics(): jboolean; overload; virtual;
    function getAntiAliasingHint(): JLObject; overload; virtual;
    function getFractionalMetricsHint(): JLObject; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function equals(para1: JAFFontRenderContext): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  JAFGlyphJustificationInfo = class sealed external 'java.awt.font' name 'GlyphJustificationInfo' (JLObject)
  public
    const
      PRIORITY_KASHIDA = 0;
      PRIORITY_WHITESPACE = 1;
      PRIORITY_INTERCHAR = 2;
      PRIORITY_NONE = 3;
  public
    final var
      fweight: jfloat; external name 'weight';
      fgrowPriority: jint; external name 'growPriority';
      fgrowAbsorb: jboolean; external name 'growAbsorb';
      fgrowLeftLimit: jfloat; external name 'growLeftLimit';
      fgrowRightLimit: jfloat; external name 'growRightLimit';
      fshrinkPriority: jint; external name 'shrinkPriority';
      fshrinkAbsorb: jboolean; external name 'shrinkAbsorb';
      fshrinkLeftLimit: jfloat; external name 'shrinkLeftLimit';
      fshrinkRightLimit: jfloat; external name 'shrinkRightLimit';
  public
    constructor create(para1: jfloat; para2: jboolean; para3: jint; para4: jfloat; para5: jfloat; para6: jboolean; para7: jint; para8: jfloat; para9: jfloat); overload;
  end;

  JAFGlyphMetrics = class sealed external 'java.awt.font' name 'GlyphMetrics' (JLObject)
  public
    const
      STANDARD = 0;
      LIGATURE = 1;
      COMBINING = 2;
      COMPONENT = 3;
      WHITESPACE = 4;
  public
    constructor create(para1: jfloat; para2: JAGRectangle2D; para3: jbyte); overload;
    constructor create(para1: jboolean; para2: jfloat; para3: jfloat; para4: JAGRectangle2D; para5: jbyte); overload;
    function getAdvance(): jfloat; overload; virtual;
    function getAdvanceX(): jfloat; overload; virtual;
    function getAdvanceY(): jfloat; overload; virtual;
    function getBounds2D(): JAGRectangle2D; overload; virtual;
    function getLSB(): jfloat; overload; virtual;
    function getRSB(): jfloat; overload; virtual;
    function getType(): jint; overload; virtual;
    function isStandard(): jboolean; overload; virtual;
    function isLigature(): jboolean; overload; virtual;
    function isCombining(): jboolean; overload; virtual;
    function isComponent(): jboolean; overload; virtual;
    function isWhitespace(): jboolean; overload; virtual;
  end;

  JAFGraphicAttribute = class abstract external 'java.awt.font' name 'GraphicAttribute' (JLObject)
  public
    const
      TOP_ALIGNMENT = -1;
      BOTTOM_ALIGNMENT = -2;
      ROMAN_BASELINE = 0;
      CENTER_BASELINE = 1;
      HANGING_BASELINE = 2;
  strict protected
    constructor create(para1: jint); overload;
  public
    function getAscent(): jfloat; overload; virtual; abstract;
    function getDescent(): jfloat; overload; virtual; abstract;
    function getAdvance(): jfloat; overload; virtual; abstract;
    function getBounds(): JAGRectangle2D; overload; virtual;
    function getOutline(para1: JAGAffineTransform): JAShape; overload; virtual;
    procedure draw(para1: JAGraphics2D; para2: jfloat; para3: jfloat); overload; virtual; abstract;
    function getAlignment(): jint; overload; virtual; final;
    function getJustificationInfo(): JAFGlyphJustificationInfo; overload; virtual;
  end;

  JAFLayoutPath = class abstract external 'java.awt.font' name 'LayoutPath' (JLObject)
  public
    constructor create(); overload;
    function pointToPath(para1: JAGPoint2D; para2: JAGPoint2D): jboolean; overload; virtual; abstract;
    procedure pathToPoint(para1: JAGPoint2D; para2: jboolean; para3: JAGPoint2D); overload; virtual; abstract;
  end;

  JAFLineBreakMeasurer = class sealed external 'java.awt.font' name 'LineBreakMeasurer' (JLObject)
  public
    constructor create(para1: JTAttributedCharacterIterator; para2: JAFFontRenderContext); overload;
    constructor create(para1: JTAttributedCharacterIterator; para2: JTBreakIterator; para3: JAFFontRenderContext); overload;
    function nextOffset(para1: jfloat): jint; overload; virtual;
    function nextOffset(para1: jfloat; para2: jint; para3: jboolean): jint; overload; virtual;
    function nextLayout(para1: jfloat): JAFTextLayout; overload; virtual;
    function nextLayout(para1: jfloat; para2: jint; para3: jboolean): JAFTextLayout; overload; virtual;
    function getPosition(): jint; overload; virtual;
    procedure setPosition(para1: jint); overload; virtual;
    procedure insertChar(para1: JTAttributedCharacterIterator; para2: jint); overload; virtual;
    procedure deleteChar(para1: JTAttributedCharacterIterator; para2: jint); overload; virtual;
  end;

  JAFLineMetrics = class abstract external 'java.awt.font' name 'LineMetrics' (JLObject)
  public
    constructor create(); overload;
    function getNumChars(): jint; overload; virtual; abstract;
    function getAscent(): jfloat; overload; virtual; abstract;
    function getDescent(): jfloat; overload; virtual; abstract;
    function getLeading(): jfloat; overload; virtual; abstract;
    function getHeight(): jfloat; overload; virtual; abstract;
    function getBaselineIndex(): jint; overload; virtual; abstract;
    function getBaselineOffsets(): Arr1jfloat; overload; virtual; abstract;
    function getStrikethroughOffset(): jfloat; overload; virtual; abstract;
    function getStrikethroughThickness(): jfloat; overload; virtual; abstract;
    function getUnderlineOffset(): jfloat; overload; virtual; abstract;
    function getUnderlineThickness(): jfloat; overload; virtual; abstract;
  end;

  JAFMultipleMaster = interface external 'java.awt.font' name 'MultipleMaster' 
    function getNumDesignAxes(): jint; overload;
    function getDesignAxisRanges(): Arr1jfloat; overload;
    function getDesignAxisDefaults(): Arr1jfloat; overload;
    function getDesignAxisNames(): Arr1JLString; overload;
    function deriveMMFont(para1: Arr1jfloat): JAFont; overload;
    function deriveMMFont(var para1: array of jfloat): JAFont; overload;
    function deriveMMFont(para1: Arr1jfloat; para2: jfloat; para3: jfloat; para4: jfloat; para5: jfloat): JAFont; overload;
    function deriveMMFont(var para1: array of jfloat; para2: jfloat; para3: jfloat; para4: jfloat; para5: jfloat): JAFont; overload;
  end;

  JAFOpenType = interface external 'java.awt.font' name 'OpenType' 
    const
      TAG_CMAP = 1668112752;
      TAG_HEAD = 1751474532;
      TAG_NAME = 1851878757;
      TAG_GLYF = 1735162214;
      TAG_MAXP = 1835104368;
      TAG_PREP = 1886545264;
      TAG_HMTX = 1752003704;
      TAG_KERN = 1801810542;
      TAG_HDMX = 1751412088;
      TAG_LOCA = 1819239265;
      TAG_POST = 1886352244;
      TAG_OS2 = 1330851634;
      TAG_CVT = 1668707360;
      TAG_GASP = 1734439792;
      TAG_VDMX = 1447316824;
      TAG_VMTX = 1986884728;
      TAG_VHEA = 1986553185;
      TAG_HHEA = 1751672161;
      TAG_TYP1 = 1954115633;
      TAG_BSLN = 1651731566;
      TAG_GSUB = 1196643650;
      TAG_DSIG = 1146308935;
      TAG_FPGM = 1718642541;
      TAG_FVAR = 1719034226;
      TAG_GVAR = 1735811442;
      TAG_CFF = 1128678944;
      TAG_MMSD = 1296913220;
      TAG_MMFX = 1296909912;
      TAG_BASE = 1111577413;
      TAG_GDEF = 1195656518;
      TAG_GPOS = 1196445523;
      TAG_JSTF = 1246975046;
      TAG_EBDT = 1161970772;
      TAG_EBLC = 1161972803;
      TAG_EBSC = 1161974595;
      TAG_LTSH = 1280594760;
      TAG_PCLT = 1346587732;
      TAG_ACNT = 1633906292;
      TAG_AVAR = 1635148146;
      TAG_BDAT = 1650745716;
      TAG_BLOC = 1651273571;
      TAG_CVAR = 1668702578;
      TAG_FEAT = 1717920116;
      TAG_FDSC = 1717859171;
      TAG_FMTX = 1718449272;
      TAG_JUST = 1786082164;
      TAG_LCAR = 1818452338;
      TAG_MORT = 1836020340;
      TAG_OPBD = 1836020340;
      TAG_PROP = 1886547824;
      TAG_TRAK = 1953653099;
    function getVersion(): jint; overload;
    function getFontTable(para1: jint): Arr1jbyte; overload;
    function getFontTable(para1: JLString): Arr1jbyte; overload;
    function getFontTable(para1: jint; para2: jint; para3: jint): Arr1jbyte; overload;
    function getFontTable(para1: JLString; para2: jint; para3: jint): Arr1jbyte; overload;
    function getFontTableSize(para1: jint): jint; overload;
    function getFontTableSize(para1: JLString): jint; overload;
  end;

  JAFStyledParagraph = class sealed external 'java.awt.font' name 'StyledParagraph' (JLObject)
  public
    constructor create(para1: JTAttributedCharacterIterator; para2: Arr1jchar); overload;
    constructor create(para1: JTAttributedCharacterIterator; const para2: array of jchar); overload;
    class function insertChar(para1: JTAttributedCharacterIterator; para2: Arr1jchar; para3: jint; para4: JAFStyledParagraph): JAFStyledParagraph; static; overload;
    class function insertChar(para1: JTAttributedCharacterIterator; var para2: array of jchar; para3: jint; para4: JAFStyledParagraph): JAFStyledParagraph; static; overload;
    class function deleteChar(para1: JTAttributedCharacterIterator; para2: Arr1jchar; para3: jint; para4: JAFStyledParagraph): JAFStyledParagraph; static; overload;
    class function deleteChar(para1: JTAttributedCharacterIterator; var para2: array of jchar; para3: jint; para4: JAFStyledParagraph): JAFStyledParagraph; static; overload;
    function getRunLimit(para1: jint): jint; overload; virtual;
    function getDecorationAt(para1: jint): SFDecoration; overload; virtual;
    function getFontOrGraphicAt(para1: jint): JLObject; overload; virtual;
  end;

  JAFTextHitInfo = class sealed external 'java.awt.font' name 'TextHitInfo' (JLObject)
  public
    function getCharIndex(): jint; overload; virtual;
    function isLeadingEdge(): jboolean; overload; virtual;
    function getInsertionIndex(): jint; overload; virtual;
    function hashCode(): jint; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function equals(para1: JAFTextHitInfo): jboolean; overload; virtual;
    function toString(): JLString; overload; virtual;
    class function leading(para1: jint): JAFTextHitInfo; static; overload;
    class function trailing(para1: jint): JAFTextHitInfo; static; overload;
    class function beforeOffset(para1: jint): JAFTextHitInfo; static; overload;
    class function afterOffset(para1: jint): JAFTextHitInfo; static; overload;
    function getOtherHit(): JAFTextHitInfo; overload; virtual;
    function getOffsetHit(para1: jint): JAFTextHitInfo; overload; virtual;
  end;

  JAFTextJustifier = class external 'java.awt.font' name 'TextJustifier' (JLObject)
  public
    const
      MAX_PRIORITY = 3;
  public
    function justify(para1: jfloat): Arr1jfloat; overload; virtual;
  end;

  JAFTextLine = class sealed external 'java.awt.font' name 'TextLine' (JLObject)
  public
    type
      InnerFunction = class;
      Arr1InnerFunction = array of InnerFunction;
      Arr2InnerFunction = array of Arr1InnerFunction;
      Arr3InnerFunction = array of Arr2InnerFunction;
      InnerTextLineMetrics = class;
      Arr1InnerTextLineMetrics = array of InnerTextLineMetrics;
      Arr2InnerTextLineMetrics = array of Arr1InnerTextLineMetrics;
      Arr3InnerTextLineMetrics = array of Arr2InnerTextLineMetrics;
      InnerFunction = class abstract external 'java.awt.font' name 'Function' 
      end;

      InnerTextLineMetrics = class sealed external 'java.awt.font' name 'TextLineMetrics' 
      end;

  public
    constructor create(para1: JAFFontRenderContext; para2: Arr1SFTextLineComponent; para3: Arr1jfloat; para4: Arr1jchar; para5: jint; para6: jint; para7: Arr1jint; para8: Arr1jbyte; para9: jboolean); overload;
    constructor create(para1: JAFFontRenderContext; const para2: array of SFTextLineComponent; const para3: array of jfloat; const para4: array of jchar; para5: jint; para6: jint; const para7: array of jint; const para8: array of jbyte; para9: jboolean); overload;
    function getPixelBounds(para1: JAFFontRenderContext; para2: jfloat; para3: jfloat): JARectangle; overload; virtual;
    function characterCount(): jint; overload; virtual;
    function isDirectionLTR(): jboolean; overload; virtual;
    function getMetrics(): JAFTextLine.InnerTextLineMetrics; overload; virtual;
    function visualToLogical(para1: jint): jint; overload; virtual;
    function logicalToVisual(para1: jint): jint; overload; virtual;
    function getCharLevel(para1: jint): jbyte; overload; virtual;
    function isCharLTR(para1: jint): jboolean; overload; virtual;
    function getCharType(para1: jint): jint; overload; virtual;
    function isCharSpace(para1: jint): jboolean; overload; virtual;
    function isCharWhitespace(para1: jint): jboolean; overload; virtual;
    function getCharAngle(para1: jint): jfloat; overload; virtual;
    function getCoreMetricsAt(para1: jint): SFCoreMetrics; overload; virtual;
    function getCharAscent(para1: jint): jfloat; overload; virtual;
    function getCharDescent(para1: jint): jfloat; overload; virtual;
    function getCharShift(para1: jint): jfloat; overload; virtual;
    function getCharAdvance(para1: jint): jfloat; overload; virtual;
    function getCharXPosition(para1: jint): jfloat; overload; virtual;
    function getCharYPosition(para1: jint): jfloat; overload; virtual;
    function getCharLinePosition(para1: jint): jfloat; overload; virtual;
    function getCharLinePosition(para1: jint; para2: jboolean): jfloat; overload; virtual;
    function caretAtOffsetIsValid(para1: jint): jboolean; overload; virtual;
    function getCharBounds(para1: jint): JAGRectangle2D; overload; virtual;
    procedure draw(para1: JAGraphics2D; para2: jfloat; para3: jfloat); overload; virtual;
    function getVisualBounds(): JAGRectangle2D; overload; virtual;
    function getItalicBounds(): JAGRectangle2D; overload; virtual;
    function getOutline(para1: JAGAffineTransform): JAShape; overload; virtual;
    function hashCode(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
    class function fastCreateTextLine(para1: JAFFontRenderContext; para2: Arr1jchar; para3: JAFont; para4: SFCoreMetrics; para5: JUMap): JAFTextLine; static; overload;
    class function fastCreateTextLine(para1: JAFFontRenderContext; var para2: array of jchar; para3: JAFont; para4: SFCoreMetrics; para5: JUMap): JAFTextLine; static; overload;
    class function createComponentsOnRun(para1: jint; para2: jint; para3: Arr1jchar; para4: Arr1jint; para5: Arr1jbyte; para6: SFTextLabelFactory; para7: JAFont; para8: SFCoreMetrics; para9: JAFFontRenderContext; para10: SFDecoration; para11: Arr1SFTextLineComponent; para12: jint): Arr1SFTextLineComponent; static; overload;
    class function createComponentsOnRun(para1: jint; para2: jint; var para3: array of jchar; var para4: array of jint; var para5: array of jbyte; para6: SFTextLabelFactory; para7: JAFont; para8: SFCoreMetrics; para9: JAFFontRenderContext; para10: SFDecoration; var para11: array of SFTextLineComponent; para12: jint): Arr1SFTextLineComponent; static; overload;
    class function getComponents(para1: JAFStyledParagraph; para2: Arr1jchar; para3: jint; para4: jint; para5: Arr1jint; para6: Arr1jbyte; para7: SFTextLabelFactory): Arr1SFTextLineComponent; static; overload;
    class function getComponents(para1: JAFStyledParagraph; var para2: array of jchar; para3: jint; para4: jint; var para5: array of jint; var para6: array of jbyte; para7: SFTextLabelFactory): Arr1SFTextLineComponent; static; overload;
    class function createLineFromText(para1: Arr1jchar; para2: JAFStyledParagraph; para3: SFTextLabelFactory; para4: jboolean; para5: Arr1jfloat): JAFTextLine; static; overload;
    class function createLineFromText(var para1: array of jchar; para2: JAFStyledParagraph; para3: SFTextLabelFactory; para4: jboolean; var para5: array of jfloat): JAFTextLine; static; overload;
    class function standardCreateTextLine(para1: JAFFontRenderContext; para2: JTAttributedCharacterIterator; para3: Arr1jchar; para4: Arr1jfloat): JAFTextLine; static; overload;
    class function standardCreateTextLine(para1: JAFFontRenderContext; para2: JTAttributedCharacterIterator; var para3: array of jchar; var para4: array of jfloat): JAFTextLine; static; overload;
    function getJustifiedLine(para1: jfloat; para2: jfloat; para3: jint; para4: jint): JAFTextLine; overload; virtual;
    class function getAdvanceBetween(para1: Arr1SFTextLineComponent; para2: jint; para3: jint): jfloat; static; overload;
    class function getAdvanceBetween(var para1: array of SFTextLineComponent; para2: jint; para3: jint): jfloat; static; overload;
  end;

  JAGPathIterator = interface external 'java.awt.geom' name 'PathIterator' 
    const
      WIND_EVEN_ODD = 0;
      WIND_NON_ZERO = 1;
      SEG_MOVETO = 0;
      SEG_LINETO = 1;
      SEG_QUADTO = 2;
      SEG_CUBICTO = 3;
      SEG_CLOSE = 4;
    function getWindingRule(): jint; overload;
    function isDone(): jboolean; overload;
    procedure next(); overload;
    function currentSegment(para1: Arr1jfloat): jint; overload;
    function currentSegment(var para1: array of jfloat): jint; overload;
    function currentSegment(para1: Arr1jdouble): jint; overload;
    function currentSegment(var para1: array of jdouble): jint; overload;
  end;

  JAIInputMethodHighlight = class external 'java.awt.im' name 'InputMethodHighlight' (JLObject)
  public
    const
      RAW_TEXT = 0;
      CONVERTED_TEXT = 1;
  public
    final class var
      fUNSELECTED_RAW_TEXT_HIGHLIGHT: JAIInputMethodHighlight; external name 'UNSELECTED_RAW_TEXT_HIGHLIGHT';
      fSELECTED_RAW_TEXT_HIGHLIGHT: JAIInputMethodHighlight; external name 'SELECTED_RAW_TEXT_HIGHLIGHT';
      fUNSELECTED_CONVERTED_TEXT_HIGHLIGHT: JAIInputMethodHighlight; external name 'UNSELECTED_CONVERTED_TEXT_HIGHLIGHT';
      fSELECTED_CONVERTED_TEXT_HIGHLIGHT: JAIInputMethodHighlight; external name 'SELECTED_CONVERTED_TEXT_HIGHLIGHT';
  public
    constructor create(para1: jboolean; para2: jint); overload;
    constructor create(para1: jboolean; para2: jint; para3: jint); overload;
    constructor create(para1: jboolean; para2: jint; para3: jint; para4: JUMap); overload;
    function isSelected(): jboolean; overload; virtual;
    function getState(): jint; overload; virtual;
    function getVariation(): jint; overload; virtual;
    function getStyle(): JUMap; overload; virtual;
  end;

  JAISInputMethodDescriptor = interface external 'java.awt.im.spi' name 'InputMethodDescriptor' 
    function getAvailableLocales(): Arr1JULocale; overload;  // throws java.awt.AWTException
    function hasDynamicLocaleList(): jboolean; overload;
    function getInputMethodDisplayName(para1: JULocale; para2: JULocale): JLString; overload;
    function getInputMethodIcon(para1: JULocale): JAImage; overload;
    function createInputMethod(): JAISInputMethod; overload;  // throws java.lang.Exception
  end;

  JAIBufferStrategy = class abstract external 'java.awt.image' name 'BufferStrategy' (JLObject)
  public
    constructor create(); overload;
    function getCapabilities(): JABufferCapabilities; overload; virtual; abstract;
    function getDrawGraphics(): JAGraphics; overload; virtual; abstract;
    function contentsLost(): jboolean; overload; virtual; abstract;
    function contentsRestored(): jboolean; overload; virtual; abstract;
    procedure show(); overload; virtual; abstract;
    procedure dispose(); overload; virtual;
  end;

  JAIBufferedImageOp = interface external 'java.awt.image' name 'BufferedImageOp' 
    function filter(para1: JAIBufferedImage; para2: JAIBufferedImage): JAIBufferedImage; overload;
    function getBounds2D(para1: JAIBufferedImage): JAGRectangle2D; overload;
    function createCompatibleDestImage(para1: JAIBufferedImage; para2: JAIColorModel): JAIBufferedImage; overload;
    function getPoint2D(para1: JAGPoint2D; para2: JAGPoint2D): JAGPoint2D; overload;
    function getRenderingHints(): JARenderingHints; overload;
  end;

  JAIDataBuffer = class abstract external 'java.awt.image' name 'DataBuffer' (JLObject)
  public
    const
      TYPE_BYTE = 0;
      TYPE_USHORT = 1;
      TYPE_SHORT = 2;
      TYPE_INT = 3;
      TYPE_FLOAT = 4;
      TYPE_DOUBLE = 5;
      TYPE_UNDEFINED = 32;
  strict protected
    var
      fdataType: jint; external name 'dataType';
      fbanks: jint; external name 'banks';
      foffset: jint; external name 'offset';
      fsize: jint; external name 'size';
      foffsets: Arr1jint; external name 'offsets';
  public
    class function getDataTypeSize(para1: jint): jint; static; overload;
  strict protected
    constructor create(para1: jint; para2: jint); overload;
    constructor create(para1: jint; para2: jint; para3: jint); overload;
    constructor create(para1: jint; para2: jint; para3: jint; para4: jint); overload;
    constructor create(para1: jint; para2: jint; para3: jint; para4: Arr1jint); overload;
    constructor create(para1: jint; para2: jint; para3: jint; const para4: array of jint); overload;
  public
    function getDataType(): jint; overload; virtual;
    function getSize(): jint; overload; virtual;
    function getOffset(): jint; overload; virtual;
    function getOffsets(): Arr1jint; overload; virtual;
    function getNumBanks(): jint; overload; virtual;
    function getElem(para1: jint): jint; overload; virtual;
    function getElem(para1: jint; para2: jint): jint; overload; virtual; abstract;
    procedure setElem(para1: jint; para2: jint); overload; virtual;
    procedure setElem(para1: jint; para2: jint; para3: jint); overload; virtual; abstract;
    function getElemFloat(para1: jint): jfloat; overload; virtual;
    function getElemFloat(para1: jint; para2: jint): jfloat; overload; virtual;
    procedure setElemFloat(para1: jint; para2: jfloat); overload; virtual;
    procedure setElemFloat(para1: jint; para2: jint; para3: jfloat); overload; virtual;
    function getElemDouble(para1: jint): jdouble; overload; virtual;
    function getElemDouble(para1: jint; para2: jint): jdouble; overload; virtual;
    procedure setElemDouble(para1: jint; para2: jdouble); overload; virtual;
    procedure setElemDouble(para1: jint; para2: jint; para3: jdouble); overload; virtual;
  end;

  JAIImageConsumer = interface external 'java.awt.image' name 'ImageConsumer' 
    const
      RANDOMPIXELORDER = 1;
      TOPDOWNLEFTRIGHT = 2;
      COMPLETESCANLINES = 4;
      SINGLEPASS = 8;
      SINGLEFRAME = 16;
      IMAGEERROR = 1;
      SINGLEFRAMEDONE = 2;
      STATICIMAGEDONE = 3;
      IMAGEABORTED = 4;
    procedure setDimensions(para1: jint; para2: jint); overload;
    procedure setProperties(para1: JUHashtable); overload;
    procedure setColorModel(para1: JAIColorModel); overload;
    procedure setHints(para1: jint); overload;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAIColorModel; para6: Arr1jbyte; para7: jint; para8: jint); overload;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAIColorModel; var para6: array of jbyte; para7: jint; para8: jint); overload;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAIColorModel; para6: Arr1jint; para7: jint; para8: jint); overload;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAIColorModel; var para6: array of jint; para7: jint; para8: jint); overload;
    procedure imageComplete(para1: jint); overload;
  end;

  JAIImageObserver = interface external 'java.awt.image' name 'ImageObserver' 
    const
      WIDTH = 1;
      HEIGHT = 2;
      PROPERTIES = 4;
      SOMEBITS = 8;
      FRAMEBITS = 16;
      ALLBITS = 32;
      ERROR = 64;
      ABORT = 128;
    function imageUpdate(para1: JAImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint): jboolean; overload;
  end;

  JAIImageProducer = interface external 'java.awt.image' name 'ImageProducer' 
    procedure addConsumer(para1: JAIImageConsumer); overload;
    function isConsumer(para1: JAIImageConsumer): jboolean; overload;
    procedure removeConsumer(para1: JAIImageConsumer); overload;
    procedure startProduction(para1: JAIImageConsumer); overload;
    procedure requestTopDownLeftRightResend(para1: JAIImageConsumer); overload;
  end;

  JAILookupTable = class abstract external 'java.awt.image' name 'LookupTable' (JLObject)
  strict protected
    constructor create(para1: jint; para2: jint); overload;
  public
    function getNumComponents(): jint; overload; virtual;
    function getOffset(): jint; overload; virtual;
    function lookupPixel(para1: Arr1jint; para2: Arr1jint): Arr1jint; overload; virtual; abstract;
    function lookupPixel(var para1: array of jint; var para2: array of jint): Arr1jint; overload; virtual; abstract;
  end;

  JAIRaster = class external 'java.awt.image' name 'Raster' (JLObject)
  strict protected
    var
      fsampleModel: JAISampleModel; external name 'sampleModel';
      fdataBuffer: JAIDataBuffer; external name 'dataBuffer';
      fminX: jint; external name 'minX';
      fminY: jint; external name 'minY';
      fwidth: jint; external name 'width';
      fheight: jint; external name 'height';
      fsampleModelTranslateX: jint; external name 'sampleModelTranslateX';
      fsampleModelTranslateY: jint; external name 'sampleModelTranslateY';
      fnumBands: jint; external name 'numBands';
      fnumDataElements: jint; external name 'numDataElements';
      fparent: JAIRaster; external name 'parent';
  public
    class function createInterleavedRaster(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAPoint): JAIWritableRaster; static; overload;
    class function createInterleavedRaster(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createInterleavedRaster(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createBandedRaster(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAPoint): JAIWritableRaster; static; overload;
    class function createBandedRaster(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jint; para6: Arr1jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createBandedRaster(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jint; var para6: array of jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createPackedRaster(para1: jint; para2: jint; para3: jint; para4: Arr1jint; para5: JAPoint): JAIWritableRaster; static; overload;
    class function createPackedRaster(para1: jint; para2: jint; para3: jint; var para4: array of jint; para5: JAPoint): JAIWritableRaster; static; overload;
    class function createPackedRaster(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: JAPoint): JAIWritableRaster; static; overload;
    class function createInterleavedRaster(para1: JAIDataBuffer; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createInterleavedRaster(para1: JAIDataBuffer; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createBandedRaster(para1: JAIDataBuffer; para2: jint; para3: jint; para4: jint; para5: Arr1jint; para6: Arr1jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createBandedRaster(para1: JAIDataBuffer; para2: jint; para3: jint; para4: jint; var para5: array of jint; var para6: array of jint; para7: JAPoint): JAIWritableRaster; static; overload;
    class function createPackedRaster(para1: JAIDataBuffer; para2: jint; para3: jint; para4: jint; para5: Arr1jint; para6: JAPoint): JAIWritableRaster; static; overload;
    class function createPackedRaster(para1: JAIDataBuffer; para2: jint; para3: jint; para4: jint; var para5: array of jint; para6: JAPoint): JAIWritableRaster; static; overload;
    class function createPackedRaster(para1: JAIDataBuffer; para2: jint; para3: jint; para4: jint; para5: JAPoint): JAIWritableRaster; static; overload;
    class function createRaster(para1: JAISampleModel; para2: JAIDataBuffer; para3: JAPoint): JAIRaster; static; overload;
    class function createWritableRaster(para1: JAISampleModel; para2: JAPoint): JAIWritableRaster; static; overload;
    class function createWritableRaster(para1: JAISampleModel; para2: JAIDataBuffer; para3: JAPoint): JAIWritableRaster; static; overload;
  strict protected
    constructor create(para1: JAISampleModel; para2: JAPoint); overload;
    constructor create(para1: JAISampleModel; para2: JAIDataBuffer; para3: JAPoint); overload;
    constructor create(para1: JAISampleModel; para2: JAIDataBuffer; para3: JARectangle; para4: JAPoint; para5: JAIRaster); overload;
  public
    function getParent(): JAIRaster; overload; virtual;
    function getSampleModelTranslateX(): jint; overload; virtual; final;
    function getSampleModelTranslateY(): jint; overload; virtual; final;
    function createCompatibleWritableRaster(): JAIWritableRaster; overload; virtual;
    function createCompatibleWritableRaster(para1: jint; para2: jint): JAIWritableRaster; overload; virtual;
    function createCompatibleWritableRaster(para1: JARectangle): JAIWritableRaster; overload; virtual;
    function createCompatibleWritableRaster(para1: jint; para2: jint; para3: jint; para4: jint): JAIWritableRaster; overload; virtual;
    function createTranslatedChild(para1: jint; para2: jint): JAIRaster; overload; virtual;
    function createChild(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: Arr1jint): JAIRaster; overload; virtual;
    function createChild(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; var para7: array of jint): JAIRaster; overload; virtual;
    function getBounds(): JARectangle; overload; virtual;
    function getMinX(): jint; overload; virtual; final;
    function getMinY(): jint; overload; virtual; final;
    function getWidth(): jint; overload; virtual; final;
    function getHeight(): jint; overload; virtual; final;
    function getNumBands(): jint; overload; virtual; final;
    function getNumDataElements(): jint; overload; virtual; final;
    function getTransferType(): jint; overload; virtual; final;
    function getDataBuffer(): JAIDataBuffer; overload; virtual;
    function getSampleModel(): JAISampleModel; overload; virtual;
    function getDataElements(para1: jint; para2: jint; para3: JLObject): JLObject; overload; virtual;
    function getDataElements(para1: jint; para2: jint; para3: jint; para4: jint; para5: JLObject): JLObject; overload; virtual;
    function getPixel(para1: jint; para2: jint; para3: Arr1jint): Arr1jint; overload; virtual;
    function getPixel(para1: jint; para2: jint; var para3: array of jint): Arr1jint; overload; virtual;
    function getPixel(para1: jint; para2: jint; para3: Arr1jfloat): Arr1jfloat; overload; virtual;
    function getPixel(para1: jint; para2: jint; var para3: array of jfloat): Arr1jfloat; overload; virtual;
    function getPixel(para1: jint; para2: jint; para3: Arr1jdouble): Arr1jdouble; overload; virtual;
    function getPixel(para1: jint; para2: jint; var para3: array of jdouble): Arr1jdouble; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jint): Arr1jint; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jint): Arr1jint; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jfloat): Arr1jfloat; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jfloat): Arr1jfloat; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jdouble): Arr1jdouble; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jdouble): Arr1jdouble; overload; virtual;
    function getSample(para1: jint; para2: jint; para3: jint): jint; overload; virtual;
    function getSampleFloat(para1: jint; para2: jint; para3: jint): jfloat; overload; virtual;
    function getSampleDouble(para1: jint; para2: jint; para3: jint): jdouble; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jint): Arr1jint; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jint): Arr1jint; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jfloat): Arr1jfloat; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jfloat): Arr1jfloat; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jdouble): Arr1jdouble; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jdouble): Arr1jdouble; overload; virtual;
  end;

  JAIRasterOp = interface external 'java.awt.image' name 'RasterOp' 
    function filter(para1: JAIRaster; para2: JAIWritableRaster): JAIWritableRaster; overload;
    function getBounds2D(para1: JAIRaster): JAGRectangle2D; overload;
    function createCompatibleDestRaster(para1: JAIRaster): JAIWritableRaster; overload;
    function getPoint2D(para1: JAGPoint2D; para2: JAGPoint2D): JAGPoint2D; overload;
    function getRenderingHints(): JARenderingHints; overload;
  end;

  JAIRenderedImage = interface external 'java.awt.image' name 'RenderedImage' 
    function getSources(): JUVector; overload;
    function getProperty(para1: JLString): JLObject; overload;
    function getPropertyNames(): Arr1JLString; overload;
    function getColorModel(): JAIColorModel; overload;
    function getSampleModel(): JAISampleModel; overload;
    function getWidth(): jint; overload;
    function getHeight(): jint; overload;
    function getMinX(): jint; overload;
    function getMinY(): jint; overload;
    function getNumXTiles(): jint; overload;
    function getNumYTiles(): jint; overload;
    function getMinTileX(): jint; overload;
    function getMinTileY(): jint; overload;
    function getTileWidth(): jint; overload;
    function getTileHeight(): jint; overload;
    function getTileGridXOffset(): jint; overload;
    function getTileGridYOffset(): jint; overload;
    function getTile(para1: jint; para2: jint): JAIRaster; overload;
    function getData(): JAIRaster; overload;
    function getData(para1: JARectangle): JAIRaster; overload;
    function copyData(para1: JAIWritableRaster): JAIWritableRaster; overload;
  end;

  JAISampleModel = class abstract external 'java.awt.image' name 'SampleModel' (JLObject)
  strict protected
    var
      fwidth: jint; external name 'width';
      fheight: jint; external name 'height';
      fnumBands: jint; external name 'numBands';
      fdataType: jint; external name 'dataType';
  public
    constructor create(para1: jint; para2: jint; para3: jint; para4: jint); overload;
    function getWidth(): jint; overload; virtual; final;
    function getHeight(): jint; overload; virtual; final;
    function getNumBands(): jint; overload; virtual; final;
    function getNumDataElements(): jint; overload; virtual; abstract;
    function getDataType(): jint; overload; virtual; final;
    function getTransferType(): jint; overload; virtual;
    function getPixel(para1: jint; para2: jint; para3: Arr1jint; para4: JAIDataBuffer): Arr1jint; overload; virtual;
    function getPixel(para1: jint; para2: jint; var para3: array of jint; para4: JAIDataBuffer): Arr1jint; overload; virtual;
    function getDataElements(para1: jint; para2: jint; para3: JLObject; para4: JAIDataBuffer): JLObject; overload; virtual; abstract;
    function getDataElements(para1: jint; para2: jint; para3: jint; para4: jint; para5: JLObject; para6: JAIDataBuffer): JLObject; overload; virtual;
    procedure setDataElements(para1: jint; para2: jint; para3: JLObject; para4: JAIDataBuffer); overload; virtual; abstract;
    procedure setDataElements(para1: jint; para2: jint; para3: jint; para4: jint; para5: JLObject; para6: JAIDataBuffer); overload; virtual;
    function getPixel(para1: jint; para2: jint; para3: Arr1jfloat; para4: JAIDataBuffer): Arr1jfloat; overload; virtual;
    function getPixel(para1: jint; para2: jint; var para3: array of jfloat; para4: JAIDataBuffer): Arr1jfloat; overload; virtual;
    function getPixel(para1: jint; para2: jint; para3: Arr1jdouble; para4: JAIDataBuffer): Arr1jdouble; overload; virtual;
    function getPixel(para1: jint; para2: jint; var para3: array of jdouble; para4: JAIDataBuffer): Arr1jdouble; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jint; para6: JAIDataBuffer): Arr1jint; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jint; para6: JAIDataBuffer): Arr1jint; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jfloat; para6: JAIDataBuffer): Arr1jfloat; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jfloat; para6: JAIDataBuffer): Arr1jfloat; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jdouble; para6: JAIDataBuffer): Arr1jdouble; overload; virtual;
    function getPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jdouble; para6: JAIDataBuffer): Arr1jdouble; overload; virtual;
    function getSample(para1: jint; para2: jint; para3: jint; para4: JAIDataBuffer): jint; overload; virtual; abstract;
    function getSampleFloat(para1: jint; para2: jint; para3: jint; para4: JAIDataBuffer): jfloat; overload; virtual;
    function getSampleDouble(para1: jint; para2: jint; para3: jint; para4: JAIDataBuffer): jdouble; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jint; para7: JAIDataBuffer): Arr1jint; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jint; para7: JAIDataBuffer): Arr1jint; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jfloat; para7: JAIDataBuffer): Arr1jfloat; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jfloat; para7: JAIDataBuffer): Arr1jfloat; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jdouble; para7: JAIDataBuffer): Arr1jdouble; overload; virtual;
    function getSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jdouble; para7: JAIDataBuffer): Arr1jdouble; overload; virtual;
    procedure setPixel(para1: jint; para2: jint; para3: Arr1jint; para4: JAIDataBuffer); overload; virtual;
    procedure setPixel(para1: jint; para2: jint; var para3: array of jint; para4: JAIDataBuffer); overload; virtual;
    procedure setPixel(para1: jint; para2: jint; para3: Arr1jfloat; para4: JAIDataBuffer); overload; virtual;
    procedure setPixel(para1: jint; para2: jint; var para3: array of jfloat; para4: JAIDataBuffer); overload; virtual;
    procedure setPixel(para1: jint; para2: jint; para3: Arr1jdouble; para4: JAIDataBuffer); overload; virtual;
    procedure setPixel(para1: jint; para2: jint; var para3: array of jdouble; para4: JAIDataBuffer); overload; virtual;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jint; para6: JAIDataBuffer); overload; virtual;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jint; para6: JAIDataBuffer); overload; virtual;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jfloat; para6: JAIDataBuffer); overload; virtual;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jfloat; para6: JAIDataBuffer); overload; virtual;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; para5: Arr1jdouble; para6: JAIDataBuffer); overload; virtual;
    procedure setPixels(para1: jint; para2: jint; para3: jint; para4: jint; var para5: array of jdouble; para6: JAIDataBuffer); overload; virtual;
    procedure setSample(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAIDataBuffer); overload; virtual; abstract;
    procedure setSample(para1: jint; para2: jint; para3: jint; para4: jfloat; para5: JAIDataBuffer); overload; virtual;
    procedure setSample(para1: jint; para2: jint; para3: jint; para4: jdouble; para5: JAIDataBuffer); overload; virtual;
    procedure setSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jint; para7: JAIDataBuffer); overload; virtual;
    procedure setSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jint; para7: JAIDataBuffer); overload; virtual;
    procedure setSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jfloat; para7: JAIDataBuffer); overload; virtual;
    procedure setSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jfloat; para7: JAIDataBuffer); overload; virtual;
    procedure setSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: Arr1jdouble; para7: JAIDataBuffer); overload; virtual;
    procedure setSamples(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; var para6: array of jdouble; para7: JAIDataBuffer); overload; virtual;
    function createCompatibleSampleModel(para1: jint; para2: jint): JAISampleModel; overload; virtual; abstract;
    function createSubsetSampleModel(para1: Arr1jint): JAISampleModel; overload; virtual; abstract;
    function createSubsetSampleModel(var para1: array of jint): JAISampleModel; overload; virtual; abstract;
    function createDataBuffer(): JAIDataBuffer; overload; virtual; abstract;
    function getSampleSize(): Arr1jint; overload; virtual; abstract;
    function getSampleSize(para1: jint): jint; overload; virtual; abstract;
  end;

  JAITileObserver = interface external 'java.awt.image' name 'TileObserver' 
    procedure tileUpdate(para1: JAIWritableRenderedImage; para2: jint; para3: jint; para4: jboolean); overload;
  end;

  JAIRRenderableImage = interface external 'java.awt.image.renderable' name 'RenderableImage' 
    const
      HINTS_OBSERVED = 'HINTS_OBSERVED';
    function getSources(): JUVector; overload;
    function getProperty(para1: JLString): JLObject; overload;
    function getPropertyNames(): Arr1JLString; overload;
    function isDynamic(): jboolean; overload;
    function getWidth(): jfloat; overload;
    function getHeight(): jfloat; overload;
    function getMinX(): jfloat; overload;
    function getMinY(): jfloat; overload;
    function createScaledRendering(para1: jint; para2: jint; para3: JARenderingHints): JAIRenderedImage; overload;
    function createDefaultRendering(): JAIRenderedImage; overload;
    function createRendering(para1: JAIRRenderContext): JAIRenderedImage; overload;
  end;

  JAIRRenderedImageFactory = interface external 'java.awt.image.renderable' name 'RenderedImageFactory' 
    function create_(para1: JAIRParameterBlock; para2: JARenderingHints): JAIRenderedImage; external name 'create'; overload;
  end;

  JAPFontPeer = interface external 'java.awt.peer' name 'FontPeer' 
  end;

  JAPKeyboardFocusManagerPeer = interface external 'java.awt.peer' name 'KeyboardFocusManagerPeer' 
    procedure setCurrentFocusedWindow(para1: JAWindow); overload;
    function getCurrentFocusedWindow(): JAWindow; overload;
    procedure setCurrentFocusOwner(para1: JAComponent); overload;
    function getCurrentFocusOwner(): JAComponent; overload;
    procedure clearGlobalFocusOwner(para1: JAWindow); overload;
  end;

  JAPMenuComponentPeer = interface external 'java.awt.peer' name 'MenuComponentPeer' 
    procedure dispose(); overload;
    procedure setFont(para1: JAFont); overload;
  end;

  JAPMouseInfoPeer = interface external 'java.awt.peer' name 'MouseInfoPeer' 
    function fillPointWithCoords(para1: JAPoint): jint; overload;
    function isWindowUnderMouse(para1: JAWindow): jboolean; overload;
  end;

  JAPRobotPeer = interface external 'java.awt.peer' name 'RobotPeer' 
    procedure mouseMove(para1: jint; para2: jint); overload;
    procedure mousePress(para1: jint); overload;
    procedure mouseRelease(para1: jint); overload;
    procedure mouseWheel(para1: jint); overload;
    procedure keyPress(para1: jint); overload;
    procedure keyRelease(para1: jint); overload;
    function getRGBPixel(para1: jint; para2: jint): jint; overload;
    function getRGBPixels(para1: JARectangle): Arr1jint; overload;
    procedure dispose(); overload;
  end;

  JAPSystemTrayPeer = interface external 'java.awt.peer' name 'SystemTrayPeer' 
    function getTrayIconSize(): JADimension; overload;
  end;

  JAPTrayIconPeer = interface external 'java.awt.peer' name 'TrayIconPeer' 
    procedure dispose(); overload;
    procedure setToolTip(para1: JLString); overload;
    procedure updateImage(); overload;
    procedure displayMessage(para1: JLString; para2: JLString; para3: JLString); overload;
    procedure showPopupMenu(para1: jint; para2: jint); overload;
  end;

  JAPPageable = interface external 'java.awt.print' name 'Pageable' 
    const
      UNKNOWN_NUMBER_OF_PAGES = -1;
    function getNumberOfPages(): jint; overload;
    function getPageFormat(para1: jint): JAPPageFormat; overload;  // throws java.lang.IndexOutOfBoundsException
    function getPrintable(para1: jint): JAPPrintable; overload;  // throws java.lang.IndexOutOfBoundsException
  end;

  JAPPrintable = interface external 'java.awt.print' name 'Printable' 
    const
      PAGE_EXISTS = 0;
      NO_SUCH_PAGE = 1;
    function print(para1: JAGraphics; para2: JAPPageFormat; para3: jint): jint; overload;  // throws java.awt.print.PrinterException
  end;

  JAPPrinterGraphics = interface external 'java.awt.print' name 'PrinterGraphics' 
    function getPrinterJob(): JAPPrinterJob; overload;
  end;

  JAPPrinterJob = class abstract external 'java.awt.print' name 'PrinterJob' (JLObject)
  public
    class function getPrinterJob(): JAPPrinterJob; static; overload;
    class function lookupPrintServices(): Arr1JPPrintService; static; overload;
    class function lookupStreamPrintServices(para1: JLString): Arr1JPStreamPrintServiceFactory; static; overload;
    constructor create(); overload;
    function getPrintService(): JPPrintService; overload; virtual;
    procedure setPrintService(para1: JPPrintService); overload; virtual;  // throws java.awt.print.PrinterException
    procedure setPrintable(para1: JAPPrintable); overload; virtual; abstract;
    procedure setPrintable(para1: JAPPrintable; para2: JAPPageFormat); overload; virtual; abstract;
    procedure setPageable(para1: JAPPageable); overload; virtual; abstract;  // throws java.lang.NullPointerException
    function printDialog(): jboolean; overload; virtual; abstract;  // throws java.awt.HeadlessException
    function printDialog(para1: JPAPrintRequestAttributeSet): jboolean; overload; virtual;  // throws java.awt.HeadlessException
    function pageDialog(para1: JAPPageFormat): JAPPageFormat; overload; virtual; abstract;  // throws java.awt.HeadlessException
    function pageDialog(para1: JPAPrintRequestAttributeSet): JAPPageFormat; overload; virtual;  // throws java.awt.HeadlessException
    function defaultPage(para1: JAPPageFormat): JAPPageFormat; overload; virtual; abstract;
    function defaultPage(): JAPPageFormat; overload; virtual;
    function getPageFormat(para1: JPAPrintRequestAttributeSet): JAPPageFormat; overload; virtual;
    function validatePage(para1: JAPPageFormat): JAPPageFormat; overload; virtual; abstract;
    procedure print(); overload; virtual; abstract;  // throws java.awt.print.PrinterException
    procedure print(para1: JPAPrintRequestAttributeSet); overload; virtual;  // throws java.awt.print.PrinterException
    procedure setCopies(para1: jint); overload; virtual; abstract;
    function getCopies(): jint; overload; virtual; abstract;
    function getUserName(): JLString; overload; virtual; abstract;
    procedure setJobName(para1: JLString); overload; virtual; abstract;
    function getJobName(): JLString; overload; virtual; abstract;
    procedure cancel(); overload; virtual; abstract;
    function isCancelled(): jboolean; overload; virtual; abstract;
  end;

  JBAppletInitializer = interface external 'java.beans' name 'AppletInitializer' 
    procedure initialize(para1: JAApplet; para2: JBBBeanContext); overload;
    procedure activate(para1: JAApplet); overload;
  end;

  JBBeanInfo = interface external 'java.beans' name 'BeanInfo' 
    const
      ICON_COLOR_16x16 = 1;
      ICON_COLOR_32x32 = 2;
      ICON_MONO_16x16 = 3;
      ICON_MONO_32x32 = 4;
    function getBeanDescriptor(): JBBeanDescriptor; overload;
    function getEventSetDescriptors(): Arr1JBEventSetDescriptor; overload;
    function getDefaultEventIndex(): jint; overload;
    function getPropertyDescriptors(): Arr1JBPropertyDescriptor; overload;
    function getDefaultPropertyIndex(): jint; overload;
    function getMethodDescriptors(): Arr1JBMethodDescriptor; overload;
    function getAdditionalBeanInfo(): Arr1JBBeanInfo; overload;
    function getIcon(para1: jint): JAImage; overload;
  end;

  JBBeans = class external 'java.beans' name 'Beans' (JLObject)
  public
    constructor create(); overload;
    class function instantiate(para1: JLClassLoader; para2: JLString): JLObject; static; overload;  // throws java.io.IOException, java.lang.ClassNotFoundException
    class function instantiate(para1: JLClassLoader; para2: JLString; para3: JBBBeanContext): JLObject; static; overload;  // throws java.io.IOException, java.lang.ClassNotFoundException
    class function instantiate(para1: JLClassLoader; para2: JLString; para3: JBBBeanContext; para4: JBAppletInitializer): JLObject; static; overload;  // throws java.io.IOException, java.lang.ClassNotFoundException
    class function getInstanceOf(para1: JLObject; para2: JLClass): JLObject; static; overload;
    class function isInstanceOf(para1: JLObject; para2: JLClass): jboolean; static; overload;
    class function isDesignTime(): jboolean; static; overload;
    class function isGuiAvailable(): jboolean; static; overload;
    class procedure setDesignTime(para1: jboolean); static; overload;  // throws java.lang.SecurityException
    class procedure setGuiAvailable(para1: jboolean); static; overload;  // throws java.lang.SecurityException
  end;

  JBCustomizer = interface external 'java.beans' name 'Customizer' 
    procedure setObject(para1: JLObject); overload;
    procedure addPropertyChangeListener(para1: JBPropertyChangeListener); overload;
    procedure removePropertyChangeListener(para1: JBPropertyChangeListener); overload;
  end;

  JBDesignMode = interface external 'java.beans' name 'DesignMode' 
    const
      PROPERTYNAME = 'designTime';
    procedure setDesignTime(para1: jboolean); overload;
    function isDesignTime(): jboolean; overload;
  end;

  JBEncoder = class external 'java.beans' name 'Encoder' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure writeObject(para1: JLObject); overload; virtual;
  public
    procedure setExceptionListener(para1: JBExceptionListener); overload; virtual;
    function getExceptionListener(): JBExceptionListener; overload; virtual;
    function getPersistenceDelegate(para1: JLClass): JBPersistenceDelegate; overload; virtual;
    procedure setPersistenceDelegate(para1: JLClass; para2: JBPersistenceDelegate); overload; virtual;
    function remove(para1: JLObject): JLObject; overload; virtual;
    function get(para1: JLObject): JLObject; overload; virtual;
    procedure writeStatement(para1: JBStatement); overload; virtual;
    procedure writeExpression(para1: JBExpression); overload; virtual;
  end;

  JBExceptionListener = interface external 'java.beans' name 'ExceptionListener' 
    procedure exceptionThrown(para1: JLException); overload;
  end;

  JBFeatureDescriptor = class external 'java.beans' name 'FeatureDescriptor' (JLObject)
  public
    constructor create(); overload;
    function getName(): JLString; overload; virtual;
    procedure setName(para1: JLString); overload; virtual;
    function getDisplayName(): JLString; overload; virtual;
    procedure setDisplayName(para1: JLString); overload; virtual;
    function isExpert(): jboolean; overload; virtual;
    procedure setExpert(para1: jboolean); overload; virtual;
    function isHidden(): jboolean; overload; virtual;
    procedure setHidden(para1: jboolean); overload; virtual;
    function isPreferred(): jboolean; overload; virtual;
    procedure setPreferred(para1: jboolean); overload; virtual;
    function getShortDescription(): JLString; overload; virtual;
    procedure setShortDescription(para1: JLString); overload; virtual;
    procedure setValue(para1: JLString; para2: JLObject); overload; virtual;
    function getValue(para1: JLString): JLObject; overload; virtual;
    function attributeNames(): JUEnumeration; overload; virtual;
  end;

  JBIntrospector = class external 'java.beans' name 'Introspector' (JLObject)
  public
    const
      USE_ALL_BEANINFO = 1;
      IGNORE_IMMEDIATE_BEANINFO = 2;
      IGNORE_ALL_BEANINFO = 3;
  public
    class function getBeanInfo(para1: JLClass): JBBeanInfo; static; overload;  // throws java.beans.IntrospectionException
    class function getBeanInfo(para1: JLClass; para2: jint): JBBeanInfo; static; overload;  // throws java.beans.IntrospectionException
    class function getBeanInfo(para1: JLClass; para2: JLClass): JBBeanInfo; static; overload;  // throws java.beans.IntrospectionException
    class function decapitalize(para1: JLString): JLString; static; overload;
    class function getBeanInfoSearchPath(): Arr1JLString; static; overload;
    class procedure setBeanInfoSearchPath(para1: Arr1JLString); static; overload;
    class procedure setBeanInfoSearchPath(var para1: array of JLString); static; overload;
    class procedure flushCaches(); static; overload;
    class procedure flushFromCaches(para1: JLClass); static; overload;
  end;

  JBMetaData = class external 'java.beans' name 'MetaData' (JLObject)
  public
    class procedure setPersistenceDelegate(para1: JLClass; para2: JBPersistenceDelegate); static; overload;
    class function getPersistenceDelegate(para1: JLClass): JBPersistenceDelegate; static; overload;
    class function getBeanInfo(para1: JLClass): JBBeanInfo; static; overload;
  end;

  JBNameGenerator = class external 'java.beans' name 'NameGenerator' (JLObject)
  public
    constructor create(); overload;
    procedure clear(); overload; virtual;
    class function unqualifiedClassName(para1: JLClass): JLString; static; overload;
    class function capitalize(para1: JLString): JLString; static; overload;
    function instanceName(para1: JLObject): JLString; overload; virtual;
  end;

  JBPersistenceDelegate = class abstract external 'java.beans' name 'PersistenceDelegate' (JLObject)
  public
    constructor create(); overload;
    procedure writeObject(para1: JLObject; para2: JBEncoder); overload; virtual;
  strict protected
    function mutatesTo(para1: JLObject; para2: JLObject): jboolean; overload; virtual;
    function instantiate(para1: JLObject; para2: JBEncoder): JBExpression; overload; virtual; abstract;
    procedure initialize(para1: JLClass; para2: JLObject; para3: JLObject; para4: JBEncoder); overload; virtual;
  end;

  JBPropertyEditor = interface external 'java.beans' name 'PropertyEditor' 
    procedure setValue(para1: JLObject); overload;
    function getValue(): JLObject; overload;
    function isPaintable(): jboolean; overload;
    procedure paintValue(para1: JAGraphics; para2: JARectangle); overload;
    function getJavaInitializationString(): JLString; overload;
    function getAsText(): JLString; overload;
    procedure setAsText(para1: JLString); overload;  // throws java.lang.IllegalArgumentException
    function getTags(): Arr1JLString; overload;
    function getCustomEditor(): JAComponent; overload;
    function supportsCustomEditor(): jboolean; overload;
    procedure addPropertyChangeListener(para1: JBPropertyChangeListener); overload;
    procedure removePropertyChangeListener(para1: JBPropertyChangeListener); overload;
  end;

  JBPropertyEditorManager = class external 'java.beans' name 'PropertyEditorManager' (JLObject)
  public
    constructor create(); overload;
    class procedure registerEditor(para1: JLClass; para2: JLClass); static; overload;
    class function findEditor(para1: JLClass): JBPropertyEditor; static; overload;
    class function getEditorSearchPath(): Arr1JLString; static; overload;
    class procedure setEditorSearchPath(para1: Arr1JLString); static; overload;
    class procedure setEditorSearchPath(var para1: array of JLString); static; overload;
  end;

  JBReflectionUtils = class external 'java.beans' name 'ReflectionUtils' (JLObject)
  public
    type
      InnerSignature = class;
      Arr1InnerSignature = array of InnerSignature;
      Arr2InnerSignature = array of Arr1InnerSignature;
      Arr3InnerSignature = array of Arr2InnerSignature;
      InnerSignature = class external 'java.beans' name 'Signature' 
      end;

  public
    class function typeToClass(para1: JLClass): JLClass; static; overload;
    class function isPrimitive(para1: JLClass): jboolean; static; overload;
    class function primitiveTypeFor(para1: JLClass): JLClass; static; overload;
    class function findPublicMethod(para1: JLClass; para2: JLString; para3: Arr1JLClass): JLRMethod; static; overload;
    class function findPublicMethod(para1: JLClass; para2: JLString; var para3: array of JLClass): JLRMethod; static; overload;
    class function findMethod(para1: JLClass; para2: JLString; para3: Arr1JLClass): JLRMethod; static; overload;
    class function findMethod(para1: JLClass; para2: JLString; var para3: array of JLClass): JLRMethod; static; overload;
    class function getMethod(para1: JLClass; para2: JLString; para3: Arr1JLClass): JLRMethod; static; overload;
    class function getMethod(para1: JLClass; para2: JLString; var para3: array of JLClass): JLRMethod; static; overload;
    class function getConstructor(para1: JLClass; para2: Arr1JLClass): JLRConstructor; static; overload;
    class function getConstructor(para1: JLClass; var para2: array of JLClass): JLRConstructor; static; overload;
    class function getPrivateField(para1: JLObject; para2: JLClass; para3: JLString): JLObject; static; overload;
    class function getPrivateField(para1: JLObject; para2: JLClass; para3: JLString; para4: JBExceptionListener): JLObject; static; overload;
  end;

  JBStatement = class external 'java.beans' name 'Statement' (JLObject)
  public
    constructor create(para1: JLObject; para2: JLString; para3: Arr1JLObject); overload;
    constructor create(para1: JLObject; para2: JLString; const para3: array of JLObject); overload;
    function getTarget(): JLObject; overload; virtual;
    function getMethodName(): JLString; overload; virtual;
    function getArguments(): Arr1JLObject; overload; virtual;
    procedure execute(); overload; virtual;  // throws java.lang.Exception
    function toString(): JLString; overload; virtual;
  end;

  JBVisibility = interface external 'java.beans' name 'Visibility' 
    function needsGui(): jboolean; overload;
    procedure dontUseGui(); overload;
    procedure okToUseGui(); overload;
    function avoidingGui(): jboolean; overload;
  end;

  JBXMLDecoder = class external 'java.beans' name 'XMLDecoder' (JLObject)
  public
    constructor create(para1: JIInputStream); overload;
    constructor create(para1: JIInputStream; para2: JLObject); overload;
    constructor create(para1: JIInputStream; para2: JLObject; para3: JBExceptionListener); overload;
    constructor create(para1: JIInputStream; para2: JLObject; para3: JBExceptionListener; para4: JLClassLoader); overload;
    procedure close(); overload; virtual;
    procedure setExceptionListener(para1: JBExceptionListener); overload; virtual;
    function getExceptionListener(): JBExceptionListener; overload; virtual;
    function readObject(): JLObject; overload; virtual;
    procedure setOwner(para1: JLObject); overload; virtual;
    function getOwner(): JLObject; overload; virtual;
  end;

  JBBBeanContextChild = interface external 'java.beans.beancontext' name 'BeanContextChild' 
    procedure setBeanContext(para1: JBBBeanContext); overload;  // throws java.beans.PropertyVetoException
    function getBeanContext(): JBBBeanContext; overload;
    procedure addPropertyChangeListener(para1: JLString; para2: JBPropertyChangeListener); overload;
    procedure removePropertyChangeListener(para1: JLString; para2: JBPropertyChangeListener); overload;
    procedure addVetoableChangeListener(para1: JLString; para2: JBVetoableChangeListener); overload;
    procedure removeVetoableChangeListener(para1: JLString; para2: JBVetoableChangeListener); overload;
  end;

  JBBBeanContextChildComponentProxy = interface external 'java.beans.beancontext' name 'BeanContextChildComponentProxy' 
    function getComponent(): JAComponent; overload;
  end;

  JBBBeanContextContainerProxy = interface external 'java.beans.beancontext' name 'BeanContextContainerProxy' 
    function getContainer(): JAContainer; overload;
  end;

  JBBBeanContextProxy = interface external 'java.beans.beancontext' name 'BeanContextProxy' 
    function getBeanContextProxy(): JBBBeanContextChild; overload;
  end;

  JBBBeanContextServiceProvider = interface external 'java.beans.beancontext' name 'BeanContextServiceProvider' 
    function getService(para1: JBBBeanContextServices; para2: JLObject; para3: JLClass; para4: JLObject): JLObject; overload;
    procedure releaseService(para1: JBBBeanContextServices; para2: JLObject; para3: JLObject); overload;
    function getCurrentServiceSelectors(para1: JBBBeanContextServices; para2: JLClass): JUIterator; overload;
  end;

  JIBits = class external 'java.io' name 'Bits' (JLObject)
  end;

  JICloseable = interface external 'java.io' name 'Closeable' 
    procedure close(); overload;  // throws java.io.IOException
  end;

  JIDataInput = interface external 'java.io' name 'DataInput' 
    procedure readFully(para1: Arr1jbyte); overload;  // throws java.io.IOException
    procedure readFully(var para1: array of jbyte); overload;  // throws java.io.IOException
    procedure readFully(para1: Arr1jbyte; para2: jint; para3: jint); overload;  // throws java.io.IOException
    procedure readFully(var para1: array of jbyte; para2: jint; para3: jint); overload;  // throws java.io.IOException
    function skipBytes(para1: jint): jint; overload;  // throws java.io.IOException
    function readBoolean(): jboolean; overload;  // throws java.io.IOException
    function readByte(): jbyte; overload;  // throws java.io.IOException
    function readUnsignedByte(): jint; overload;  // throws java.io.IOException
    function readShort(): jshort; overload;  // throws java.io.IOException
    function readUnsignedShort(): jint; overload;  // throws java.io.IOException
    function readChar(): jchar; overload;  // throws java.io.IOException
    function readInt(): jint; overload;  // throws java.io.IOException
    function readLong(): jlong; overload;  // throws java.io.IOException
    function readFloat(): jfloat; overload;  // throws java.io.IOException
    function readDouble(): jdouble; overload;  // throws java.io.IOException
    function readLine(): JLString; overload;  // throws java.io.IOException
    function readUTF(): JLString; overload;  // throws java.io.IOException
  end;

  JIDataOutput = interface external 'java.io' name 'DataOutput' 
    procedure write(para1: jint); overload;  // throws java.io.IOException
    procedure write(para1: Arr1jbyte); overload;  // throws java.io.IOException
    procedure write(var para1: array of jbyte); overload;  // throws java.io.IOException
    procedure write(para1: Arr1jbyte; para2: jint; para3: jint); overload;  // throws java.io.IOException
    procedure write(var para1: array of jbyte; para2: jint; para3: jint); overload;  // throws java.io.IOException
    procedure writeBoolean(para1: jboolean); overload;  // throws java.io.IOException
    procedure writeByte(para1: jint); overload;  // throws java.io.IOException
    procedure writeShort(para1: jint); overload;  // throws java.io.IOException
    procedure writeChar(para1: jint); overload;  // throws java.io.IOException
    procedure writeInt(para1: jint); overload;  // throws java.io.IOException
    procedure writeLong(para1: jlong); overload;  // throws java.io.IOException
    procedure writeFloat(para1: jfloat); overload;  // throws java.io.IOException
    procedure writeDouble(para1: jdouble); overload;  // throws java.io.IOException
    procedure writeBytes(para1: JLString); overload;  // throws java.io.IOException
    procedure writeChars(para1: JLString); overload;  // throws java.io.IOException
    procedure writeUTF(para1: JLString); overload;  // throws java.io.IOException
  end;

  JIDeleteOnExitHook = class external 'java.io' name 'DeleteOnExitHook' (JLObject)
  end;

  JIExpiringCache = class external 'java.io' name 'ExpiringCache' (JLObject)
  public
    type
      InnerEntry = class;
      Arr1InnerEntry = array of InnerEntry;
      Arr2InnerEntry = array of Arr1InnerEntry;
      Arr3InnerEntry = array of Arr2InnerEntry;
      InnerEntry = class external 'java.io' name 'Entry' 
      end;

  end;

  JIFileDescriptor = class sealed external 'java.io' name 'FileDescriptor' (JLObject)
  public
    final class var
      fin: JIFileDescriptor; external name 'in';
      fout: JIFileDescriptor; external name 'out';
      ferr: JIFileDescriptor; external name 'err';
  public
    constructor create(); overload;
    function valid(): jboolean; overload; virtual;
    procedure sync(); overload; virtual;  // throws java.io.SyncFailedException
  end;

  JIFileFilter = interface external 'java.io' name 'FileFilter' 
    function accept(para1: JIFile): jboolean; overload;
  end;

  JIFileSystem = class abstract external 'java.io' name 'FileSystem' (JLObject)
  public
    const
      BA_EXISTS = 1;
      BA_REGULAR = 2;
      BA_DIRECTORY = 4;
      BA_HIDDEN = 8;
      ACCESS_READ = 4;
      ACCESS_WRITE = 2;
      ACCESS_EXECUTE = 1;
      SPACE_TOTAL = 0;
      SPACE_FREE = 1;
      SPACE_USABLE = 2;
  public
    class function getFileSystem(): JIFileSystem; static; overload;
    function getSeparator(): jchar; overload; virtual; abstract;
    function getPathSeparator(): jchar; overload; virtual; abstract;
    function normalize(para1: JLString): JLString; overload; virtual; abstract;
    function prefixLength(para1: JLString): jint; overload; virtual; abstract;
    function resolve(para1: JLString; para2: JLString): JLString; overload; virtual; abstract;
    function getDefaultParent(): JLString; overload; virtual; abstract;
    function fromURIPath(para1: JLString): JLString; overload; virtual; abstract;
    function isAbsolute(para1: JIFile): jboolean; overload; virtual; abstract;
    function resolve(para1: JIFile): JLString; overload; virtual; abstract;
    function canonicalize(para1: JLString): JLString; overload; virtual; abstract;  // throws java.io.IOException
    function getBooleanAttributes(para1: JIFile): jint; overload; virtual; abstract;
    function checkAccess(para1: JIFile; para2: jint): jboolean; overload; virtual; abstract;
    function setPermission(para1: JIFile; para2: jint; para3: jboolean; para4: jboolean): jboolean; overload; virtual; abstract;
    function getLastModifiedTime(para1: JIFile): jlong; overload; virtual; abstract;
    function getLength(para1: JIFile): jlong; overload; virtual; abstract;
    function createFileExclusively(para1: JLString): jboolean; overload; virtual; abstract;  // throws java.io.IOException
    function delete(para1: JIFile): jboolean; overload; virtual; abstract;
    function list(para1: JIFile): Arr1JLString; overload; virtual; abstract;
    function createDirectory(para1: JIFile): jboolean; overload; virtual; abstract;
    function rename(para1: JIFile; para2: JIFile): jboolean; overload; virtual; abstract;
    function setLastModifiedTime(para1: JIFile; para2: jlong): jboolean; overload; virtual; abstract;
    function setReadOnly(para1: JIFile): jboolean; overload; virtual; abstract;
    function listRoots(): Arr1JIFile; overload; virtual; abstract;
    function getSpace(para1: JIFile; para2: jint): jlong; overload; virtual; abstract;
    function compare(para1: JIFile; para2: JIFile): jint; overload; virtual; abstract;
    function hashCode(para1: JIFile): jint; overload; virtual; abstract;
  end;

  JIFilenameFilter = interface external 'java.io' name 'FilenameFilter' 
    function accept(para1: JIFile; para2: JLString): jboolean; overload;
  end;

  JIFlushable = interface external 'java.io' name 'Flushable' 
    procedure flush(); overload;  // throws java.io.IOException
  end;

  JIObjectInputValidation = interface external 'java.io' name 'ObjectInputValidation' 
    procedure validateObject(); overload;  // throws java.io.InvalidObjectException
  end;

  JIObjectStreamConstants = interface external 'java.io' name 'ObjectStreamConstants' 
    const
      STREAM_MAGIC = -21267;
      STREAM_VERSION = 5;
      TC_BASE = 112;
      TC_NULL = 112;
      TC_REFERENCE = 113;
      TC_CLASSDESC = 114;
      TC_OBJECT = 115;
      TC_STRING = 116;
      TC_ARRAY = 117;
      TC_CLASS = 118;
      TC_BLOCKDATA = 119;
      TC_ENDBLOCKDATA = 120;
      TC_RESET = 121;
      TC_BLOCKDATALONG = 122;
      TC_EXCEPTION = 123;
      TC_LONGSTRING = 124;
      TC_PROXYCLASSDESC = 125;
      TC_ENUM = 126;
      TC_MAX = 126;
      baseWireHandle = 8257536;
      SC_WRITE_METHOD = 1;
      SC_BLOCK_DATA = 8;
      SC_SERIALIZABLE = 2;
      SC_EXTERNALIZABLE = 4;
      SC_ENUM = 16;
    final class var
      fSUBSTITUTION_PERMISSION: JISerializablePermission; external name 'SUBSTITUTION_PERMISSION';
      fSUBCLASS_IMPLEMENTATION_PERMISSION: JISerializablePermission; external name 'SUBCLASS_IMPLEMENTATION_PERMISSION';
    const
      PROTOCOL_VERSION_1 = 1;
      PROTOCOL_VERSION_2 = 2;
  end;

  JISerialCallbackContext = class sealed external 'java.io' name 'SerialCallbackContext' (JLObject)
  public
    constructor create(para1: JLObject; para2: JIObjectStreamClass); overload;
    function getObj(): JLObject; overload; virtual;  // throws java.io.NotActiveException
    function getDesc(): JIObjectStreamClass; overload; virtual;
    procedure setUsed(); overload; virtual;
  end;

  JIStreamTokenizer = class external 'java.io' name 'StreamTokenizer' (JLObject)
  public
    var
      fttype: jint; external name 'ttype';
  public
    const
      TT_EOF = -1;
      TT_EOL = 10;
      TT_NUMBER = -2;
      TT_WORD = -3;
  public
    var
      fsval: JLString; external name 'sval';
      fnval: jdouble; external name 'nval';
  public
    constructor create(para1: JIInputStream); overload;
    constructor create(para1: JIReader); overload;
    procedure resetSyntax(); overload; virtual;
    procedure wordChars(para1: jint; para2: jint); overload; virtual;
    procedure whitespaceChars(para1: jint; para2: jint); overload; virtual;
    procedure ordinaryChars(para1: jint; para2: jint); overload; virtual;
    procedure ordinaryChar(para1: jint); overload; virtual;
    procedure commentChar(para1: jint); overload; virtual;
    procedure quoteChar(para1: jint); overload; virtual;
    procedure parseNumbers(); overload; virtual;
    procedure eolIsSignificant(para1: jboolean); overload; virtual;
    procedure slashStarComments(para1: jboolean); overload; virtual;
    procedure slashSlashComments(para1: jboolean); overload; virtual;
    procedure lowerCaseMode(para1: jboolean); overload; virtual;
    function nextToken(): jint; overload; virtual;  // throws java.io.IOException
    procedure pushBack(); overload; virtual;
    function lineno(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JLApplicationShutdownHooks = class external 'java.lang' name 'ApplicationShutdownHooks' (JLObject)
  end;

  JLAssertionStatusDirectives = class external 'java.lang' name 'AssertionStatusDirectives' (JLObject)
  end;

  JLCharacterData00 = class external 'java.lang' name 'CharacterData00' (JLObject)
  end;

  JLCharacterData01 = class external 'java.lang' name 'CharacterData01' (JLObject)
  end;

  JLCharacterData02 = class external 'java.lang' name 'CharacterData02' (JLObject)
  end;

  JLCharacterData0E = class external 'java.lang' name 'CharacterData0E' (JLObject)
  end;

  JLCharacterDataLatin1 = class external 'java.lang' name 'CharacterDataLatin1' (JLObject)
  end;

  JLCharacterDataPrivateUse = class external 'java.lang' name 'CharacterDataPrivateUse' (JLObject)
  end;

  JLCharacterDataUndefined = class external 'java.lang' name 'CharacterDataUndefined' (JLObject)
  end;

  JLClassLoader = class abstract external 'java.lang' name 'ClassLoader' (JLObject)
  public
    type
      InnerNativeLibrary = class;
      Arr1InnerNativeLibrary = array of InnerNativeLibrary;
      Arr2InnerNativeLibrary = array of Arr1InnerNativeLibrary;
      Arr3InnerNativeLibrary = array of Arr2InnerNativeLibrary;
      InnerNativeLibrary = class external 'java.lang' name 'NativeLibrary' 
      end;

  strict protected
    constructor create(para1: JLClassLoader); overload;
    constructor create(); overload;
  public
    function loadClass(para1: JLString): JLClass; overload; virtual;  // throws java.lang.ClassNotFoundException
  strict protected
    function loadClass(para1: JLString; para2: jboolean): JLClass; overload; virtual;  // throws java.lang.ClassNotFoundException
    function findClass(para1: JLString): JLClass; overload; virtual;  // throws java.lang.ClassNotFoundException
    function defineClass(para1: Arr1jbyte; para2: jint; para3: jint): JLClass; overload; virtual; final;  // throws java.lang.ClassFormatError
    function defineClass(var para1: array of jbyte; para2: jint; para3: jint): JLClass; overload; virtual; final;  // throws java.lang.ClassFormatError
    function defineClass(para1: JLString; para2: Arr1jbyte; para3: jint; para4: jint): JLClass; overload; virtual; final;  // throws java.lang.ClassFormatError
    function defineClass(para1: JLString; var para2: array of jbyte; para3: jint; para4: jint): JLClass; overload; virtual; final;  // throws java.lang.ClassFormatError
    function defineClass(para1: JLString; para2: Arr1jbyte; para3: jint; para4: jint; para5: JSProtectionDomain): JLClass; overload; virtual; final;  // throws java.lang.ClassFormatError
    function defineClass(para1: JLString; var para2: array of jbyte; para3: jint; para4: jint; para5: JSProtectionDomain): JLClass; overload; virtual; final;  // throws java.lang.ClassFormatError
    function defineClass(para1: JLString; para2: JNByteBuffer; para3: JSProtectionDomain): JLClass; overload; virtual; final;  // throws java.lang.ClassFormatError
    procedure resolveClass(para1: JLClass); overload; virtual; final;
    function findSystemClass(para1: JLString): JLClass; overload; virtual; final;  // throws java.lang.ClassNotFoundException
    function findLoadedClass(para1: JLString): JLClass; overload; virtual; final;
    procedure setSigners(para1: JLClass; para2: Arr1JLObject); overload; virtual; final;
    procedure setSigners(para1: JLClass; var para2: array of JLObject); overload; virtual; final;
  public
    function getResource(para1: JLString): JNURL; overload; virtual;
    function getResources(para1: JLString): JUEnumeration; overload; virtual;  // throws java.io.IOException
  strict protected
    function findResource(para1: JLString): JNURL; overload; virtual;
    function findResources(para1: JLString): JUEnumeration; overload; virtual;  // throws java.io.IOException
  public
    class function getSystemResource(para1: JLString): JNURL; static; overload;
    class function getSystemResources(para1: JLString): JUEnumeration; static; overload;  // throws java.io.IOException
    function getResourceAsStream(para1: JLString): JIInputStream; overload; virtual;
    class function getSystemResourceAsStream(para1: JLString): JIInputStream; static; overload;
    function getParent(): JLClassLoader; overload; virtual; final;
    class function getSystemClassLoader(): JLClassLoader; static; overload;
  strict protected
    function definePackage(para1: JLString; para2: JLString; para3: JLString; para4: JLString; para5: JLString; para6: JLString; para7: JLString; para8: JNURL): JLPackage; overload; virtual;  // throws java.lang.IllegalArgumentException
    function getPackage(para1: JLString): JLPackage; overload; virtual;
    function getPackages(): Arr1JLPackage; overload; virtual;
    function findLibrary(para1: JLString): JLString; overload; virtual;
  public
    procedure setDefaultAssertionStatus(para1: jboolean); overload; virtual;
    procedure setPackageAssertionStatus(para1: JLString; para2: jboolean); overload; virtual;
    procedure setClassAssertionStatus(para1: JLString; para2: jboolean); overload; virtual;
    procedure clearAssertionStatus(); overload; virtual;
  end;

  JLCompiler = class sealed external 'java.lang' name 'Compiler' (JLObject)
  public
    class function compileClass(para1: JLClass): jboolean; static; overload;
    class function compileClasses(para1: JLString): jboolean; static; overload;
    class function command(para1: JLObject): JLObject; static; overload;
    class procedure enable(); static; overload;
    class procedure disable(); static; overload;
  end;

  JLConditionalSpecialCasing = class sealed external 'java.lang' name 'ConditionalSpecialCasing' (JLObject)
  public
    type
      InnerEntry = class;
      Arr1InnerEntry = array of InnerEntry;
      Arr2InnerEntry = array of Arr1InnerEntry;
      Arr3InnerEntry = array of Arr2InnerEntry;
      InnerEntry = class external 'java.lang' name 'Entry' 
      end;

  end;

  JLProcess = class abstract external 'java.lang' name 'Process' (JLObject)
  public
    constructor create(); overload;
    function getOutputStream(): JIOutputStream; overload; virtual; abstract;
    function getInputStream(): JIInputStream; overload; virtual; abstract;
    function getErrorStream(): JIInputStream; overload; virtual; abstract;
    function waitFor(): jint; overload; virtual; abstract;  // throws java.lang.InterruptedException
    function exitValue(): jint; overload; virtual; abstract;
    procedure destroy(); overload; virtual; abstract;
  end;

  JLProcessBuilder = class sealed external 'java.lang' name 'ProcessBuilder' (JLObject)
  public
    constructor create(para1: JUList); overload;
    constructor create(para1: Arr1JLString); overload;
    constructor create(const para1: array of JLString); overload;
    function command(para1: JUList): JLProcessBuilder; overload; virtual;
    function command(para1: Arr1JLString): JLProcessBuilder; overload; virtual;
    function command(const para1: array of JLString): JLProcessBuilder; overload; virtual;
    function command(): JUList; overload; virtual;
    function environment(): JUMap; overload; virtual;
    function directory(): JIFile; overload; virtual;
    function directory(para1: JIFile): JLProcessBuilder; overload; virtual;
    function redirectErrorStream(): jboolean; overload; virtual;
    function redirectErrorStream(para1: jboolean): JLProcessBuilder; overload; virtual;
    function start(): JLProcess; overload; virtual;  // throws java.io.IOException
  end;

  JLProcessEnvironment = class sealed external 'java.lang' name 'ProcessEnvironment' (JLObject)
  public
    type
      InnerExternalData = class;
      Arr1InnerExternalData = array of InnerExternalData;
      Arr2InnerExternalData = array of Arr1InnerExternalData;
      Arr3InnerExternalData = array of Arr2InnerExternalData;
      InnerStringEntry = class;
      Arr1InnerStringEntry = array of InnerStringEntry;
      Arr2InnerStringEntry = array of Arr1InnerStringEntry;
      Arr3InnerStringEntry = array of Arr2InnerStringEntry;
      InnerStringEntrySet = class;
      Arr1InnerStringEntrySet = array of InnerStringEntrySet;
      Arr2InnerStringEntrySet = array of Arr1InnerStringEntrySet;
      Arr3InnerStringEntrySet = array of Arr2InnerStringEntrySet;
      InnerStringKeySet = class;
      Arr1InnerStringKeySet = array of InnerStringKeySet;
      Arr2InnerStringKeySet = array of Arr1InnerStringKeySet;
      Arr3InnerStringKeySet = array of Arr2InnerStringKeySet;
      InnerStringEnvironment = class;
      Arr1InnerStringEnvironment = array of InnerStringEnvironment;
      Arr2InnerStringEnvironment = array of Arr1InnerStringEnvironment;
      Arr3InnerStringEnvironment = array of Arr2InnerStringEnvironment;
      InnerStringValues = class;
      Arr1InnerStringValues = array of InnerStringValues;
      Arr2InnerStringValues = array of Arr1InnerStringValues;
      Arr3InnerStringValues = array of Arr2InnerStringValues;
      InnerValue = class;
      Arr1InnerValue = array of InnerValue;
      Arr2InnerValue = array of Arr1InnerValue;
      Arr3InnerValue = array of Arr2InnerValue;
      InnerVariable = class;
      Arr1InnerVariable = array of InnerVariable;
      Arr2InnerVariable = array of Arr1InnerVariable;
      Arr3InnerVariable = array of Arr2InnerVariable;
      InnerExternalData = class abstract external 'java.lang' name 'ExternalData' 
      end;

      InnerStringEntry = class external 'java.lang' name 'StringEntry' 
      end;

      InnerStringEntrySet = class external 'java.lang' name 'StringEntrySet' 
      end;

      InnerStringKeySet = class external 'java.lang' name 'StringKeySet' 
      end;

      InnerStringEnvironment = class external 'java.lang' name 'StringEnvironment' 
      end;

      InnerStringValues = class external 'java.lang' name 'StringValues' 
      end;

      InnerValue = class external 'java.lang' name 'Value' 
      end;

      InnerVariable = class external 'java.lang' name 'Variable' 
      end;

  end;

  JLProcessImpl = class sealed external 'java.lang' name 'ProcessImpl' (JLObject)
  end;

  JLRunnable = interface external 'java.lang' name 'Runnable' 
    procedure run(); overload;
  end;

  JLSecurityManager = class external 'java.lang' name 'SecurityManager' (JLObject)
  strict protected
    var
      finCheck: jboolean deprecated; external name 'inCheck';
  public
    function getInCheck(): jboolean; overload; virtual;
    constructor create(); overload;
  strict protected
    function getClassContext(): Arr1JLClass; overload; virtual;
    function currentClassLoader(): JLClassLoader; overload; virtual;
    function currentLoadedClass(): JLClass; overload; virtual;
    function classDepth(para1: JLString): jint; overload; virtual;
    function classLoaderDepth(): jint; overload; virtual;
    function inClass(para1: JLString): jboolean; overload; virtual;
    function inClassLoader(): jboolean; overload; virtual;
  public
    function getSecurityContext(): JLObject; overload; virtual;
    procedure checkPermission(para1: JSPermission); overload; virtual;
    procedure checkPermission(para1: JSPermission; para2: JLObject); overload; virtual;
    procedure checkCreateClassLoader(); overload; virtual;
    procedure checkAccess(para1: JLThread); overload; virtual;
    procedure checkAccess(para1: JLThreadGroup); overload; virtual;
    procedure checkExit(para1: jint); overload; virtual;
    procedure checkExec(para1: JLString); overload; virtual;
    procedure checkLink(para1: JLString); overload; virtual;
    procedure checkRead(para1: JIFileDescriptor); overload; virtual;
    procedure checkRead(para1: JLString); overload; virtual;
    procedure checkRead(para1: JLString; para2: JLObject); overload; virtual;
    procedure checkWrite(para1: JIFileDescriptor); overload; virtual;
    procedure checkWrite(para1: JLString); overload; virtual;
    procedure checkDelete(para1: JLString); overload; virtual;
    procedure checkConnect(para1: JLString; para2: jint); overload; virtual;
    procedure checkConnect(para1: JLString; para2: jint; para3: JLObject); overload; virtual;
    procedure checkListen(para1: jint); overload; virtual;
    procedure checkAccept(para1: JLString; para2: jint); overload; virtual;
    procedure checkMulticast(para1: JNInetAddress); overload; virtual;
    procedure checkMulticast(para1: JNInetAddress; para2: jbyte); overload; virtual;
    procedure checkPropertiesAccess(); overload; virtual;
    procedure checkPropertyAccess(para1: JLString); overload; virtual;
    function checkTopLevelWindow(para1: JLObject): jboolean; overload; virtual;
    procedure checkPrintJobAccess(); overload; virtual;
    procedure checkSystemClipboardAccess(); overload; virtual;
    procedure checkAwtEventQueueAccess(); overload; virtual;
    procedure checkPackageAccess(para1: JLString); overload; virtual;
    procedure checkPackageDefinition(para1: JLString); overload; virtual;
    procedure checkSetFactory(); overload; virtual;
    procedure checkMemberAccess(para1: JLClass; para2: jint); overload; virtual;
    procedure checkSecurityAccess(para1: JLString); overload; virtual;
    function getThreadGroup(): JLThreadGroup; overload; virtual;
  end;

  JLShutdown = class external 'java.lang' name 'Shutdown' (JLObject)
  public
    type
      InnerLock = class;
      Arr1InnerLock = array of InnerLock;
      Arr2InnerLock = array of Arr1InnerLock;
      Arr3InnerLock = array of Arr2InnerLock;
      InnerLock = class external 'java.lang' name 'Lock' 
      end;

  end;

  JLStrictMath = class sealed external 'java.lang' name 'StrictMath' (JLObject)
  public
    const
      E = jdouble(2.718281828459045);
      PI = jdouble(3.141592653589793);
  public
    class function sin(para1: jdouble): jdouble; static; overload;
    class function cos(para1: jdouble): jdouble; static; overload;
    class function tan(para1: jdouble): jdouble; static; overload;
    class function asin(para1: jdouble): jdouble; static; overload;
    class function acos(para1: jdouble): jdouble; static; overload;
    class function atan(para1: jdouble): jdouble; static; overload;
    class function toRadians(para1: jdouble): jdouble; static; overload;
    class function toDegrees(para1: jdouble): jdouble; static; overload;
    class function exp(para1: jdouble): jdouble; static; overload;
    class function log(para1: jdouble): jdouble; static; overload;
    class function log10(para1: jdouble): jdouble; static; overload;
    class function sqrt(para1: jdouble): jdouble; static; overload;
    class function cbrt(para1: jdouble): jdouble; static; overload;
    class function IEEEremainder(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function ceil(para1: jdouble): jdouble; static; overload;
    class function floor(para1: jdouble): jdouble; static; overload;
    class function rint(para1: jdouble): jdouble; static; overload;
    class function atan2(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function pow(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function round(para1: jfloat): jint; static; overload;
    class function round(para1: jdouble): jlong; static; overload;
    class function random(): jdouble; static; overload;
    class function abs(para1: jint): jint; static; overload;
    class function abs(para1: jlong): jlong; static; overload;
    class function abs(para1: jfloat): jfloat; static; overload;
    class function abs(para1: jdouble): jdouble; static; overload;
    class function max(para1: jint; para2: jint): jint; static; overload;
    class function max(para1: jlong; para2: jlong): jlong; static; overload;
    class function max(para1: jfloat; para2: jfloat): jfloat; static; overload;
    class function max(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function min(para1: jint; para2: jint): jint; static; overload;
    class function min(para1: jlong; para2: jlong): jlong; static; overload;
    class function min(para1: jfloat; para2: jfloat): jfloat; static; overload;
    class function min(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function ulp(para1: jdouble): jdouble; static; overload;
    class function ulp(para1: jfloat): jfloat; static; overload;
    class function signum(para1: jdouble): jdouble; static; overload;
    class function signum(para1: jfloat): jfloat; static; overload;
    class function sinh(para1: jdouble): jdouble; static; overload;
    class function cosh(para1: jdouble): jdouble; static; overload;
    class function tanh(para1: jdouble): jdouble; static; overload;
    class function hypot(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function expm1(para1: jdouble): jdouble; static; overload;
    class function log1p(para1: jdouble): jdouble; static; overload;
    class function copySign(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function copySign(para1: jfloat; para2: jfloat): jfloat; static; overload;
    class function getExponent(para1: jfloat): jint; static; overload;
    class function getExponent(para1: jdouble): jint; static; overload;
    class function nextAfter(para1: jdouble; para2: jdouble): jdouble; static; overload;
    class function nextAfter(para1: jfloat; para2: jdouble): jfloat; static; overload;
    class function nextUp(para1: jdouble): jdouble; static; overload;
    class function nextUp(para1: jfloat): jfloat; static; overload;
    class function scalb(para1: jdouble; para2: jint): jdouble; static; overload;
    class function scalb(para1: jfloat; para2: jint): jfloat; static; overload;
  end;

  JLStringCoding = class external 'java.lang' name 'StringCoding' (JLObject)
  public
    type
      InnerStringDecoder = class;
      Arr1InnerStringDecoder = array of InnerStringDecoder;
      Arr2InnerStringDecoder = array of Arr1InnerStringDecoder;
      Arr3InnerStringDecoder = array of Arr2InnerStringDecoder;
      InnerStringEncoder = class;
      Arr1InnerStringEncoder = array of InnerStringEncoder;
      Arr2InnerStringEncoder = array of Arr1InnerStringEncoder;
      Arr3InnerStringEncoder = array of Arr2InnerStringEncoder;
      InnerStringDecoder = class external 'java.lang' name 'StringDecoder' 
      end;

      InnerStringEncoder = class external 'java.lang' name 'StringEncoder' 
      end;

  end;

  JLStringValue = class external 'java.lang' name 'StringValue' (JLObject)
  end;

  JLTerminator = class external 'java.lang' name 'Terminator' (JLObject)
  end;

  JLVoid = class sealed external 'java.lang' name 'Void' (JLObject)
  public
    final class var
      fTYPE: JLClass; external name 'TYPE';
  end;

  JLAAnnotation = interface external 'java.lang.annotation' name 'Annotation' 
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
    function annotationType(): JLClass; overload;
  end;

  JLIClassDefinition = class sealed external 'java.lang.instrument' name 'ClassDefinition' (JLObject)
  public
    constructor create(para1: JLClass; para2: Arr1jbyte); overload;
    constructor create(para1: JLClass; const para2: array of jbyte); overload;
    function getDefinitionClass(): JLClass; overload; virtual;
    function getDefinitionClassFile(): Arr1jbyte; overload; virtual;
  end;

  JLIClassFileTransformer = interface external 'java.lang.instrument' name 'ClassFileTransformer' 
    function transform(para1: JLClassLoader; para2: JLString; para3: JLClass; para4: JSProtectionDomain; para5: Arr1jbyte): Arr1jbyte; overload;  // throws java.lang.instrument.IllegalClassFormatException
    function transform(para1: JLClassLoader; para2: JLString; para3: JLClass; para4: JSProtectionDomain; var para5: array of jbyte): Arr1jbyte; overload;  // throws java.lang.instrument.IllegalClassFormatException
  end;

  JLIInstrumentation = interface external 'java.lang.instrument' name 'Instrumentation' 
    procedure addTransformer(para1: JLIClassFileTransformer; para2: jboolean); overload;
    procedure addTransformer(para1: JLIClassFileTransformer); overload;
    function removeTransformer(para1: JLIClassFileTransformer): jboolean; overload;
    function isRetransformClassesSupported(): jboolean; overload;
    procedure retransformClasses(para1: Arr1JLClass); overload;  // throws java.lang.instrument.UnmodifiableClassException
    procedure retransformClasses(const para1: array of JLClass); overload;  // throws java.lang.instrument.UnmodifiableClassException
    function isRedefineClassesSupported(): jboolean; overload;
    procedure redefineClasses(para1: Arr1JLIClassDefinition); overload;  // throws java.lang.ClassNotFoundException, java.lang.instrument.UnmodifiableClassException
    procedure redefineClasses(const para1: array of JLIClassDefinition); overload;  // throws java.lang.ClassNotFoundException, java.lang.instrument.UnmodifiableClassException
    function isModifiableClass(para1: JLClass): jboolean; overload;
    function getAllLoadedClasses(): Arr1JLClass; overload;
    function getInitiatedClasses(para1: JLClassLoader): Arr1JLClass; overload;
    function getObjectSize(para1: JLObject): jlong; overload;
    procedure appendToBootstrapClassLoaderSearch(para1: JUJJarFile); overload;
    procedure appendToSystemClassLoaderSearch(para1: JUJJarFile); overload;
    function isNativeMethodPrefixSupported(): jboolean; overload;
    procedure setNativeMethodPrefix(para1: JLIClassFileTransformer; para2: JLString); overload;
  end;

  JLMClassLoadingMXBean = interface external 'java.lang.management' name 'ClassLoadingMXBean' 
    function getTotalLoadedClassCount(): jlong; overload;
    function getLoadedClassCount(): jint; overload;
    function getUnloadedClassCount(): jlong; overload;
    function isVerbose(): jboolean; overload;
    procedure setVerbose(para1: jboolean); overload;
  end;

  JLMCompilationMXBean = interface external 'java.lang.management' name 'CompilationMXBean' 
    function getName(): JLString; overload;
    function isCompilationTimeMonitoringSupported(): jboolean; overload;
    function getTotalCompilationTime(): jlong; overload;
  end;

  JLMLockInfo = class external 'java.lang.management' name 'LockInfo' (JLObject)
  public
    constructor create(para1: JLString; para2: jint); overload;
    function getClassName(): JLString; overload; virtual;
    function getIdentityHashCode(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JLMManagementFactory = class external 'java.lang.management' name 'ManagementFactory' (JLObject)
  public
    const
      CLASS_LOADING_MXBEAN_NAME = 'java.lang:type=ClassLoading';
      COMPILATION_MXBEAN_NAME = 'java.lang:type=Compilation';
      MEMORY_MXBEAN_NAME = 'java.lang:type=Memory';
      OPERATING_SYSTEM_MXBEAN_NAME = 'java.lang:type=OperatingSystem';
      RUNTIME_MXBEAN_NAME = 'java.lang:type=Runtime';
      THREAD_MXBEAN_NAME = 'java.lang:type=Threading';
      GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = 'java.lang:type=GarbageCollector';
      MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = 'java.lang:type=MemoryManager';
      MEMORY_POOL_MXBEAN_DOMAIN_TYPE = 'java.lang:type=MemoryPool';
  public
    class function getClassLoadingMXBean(): JLMClassLoadingMXBean; static; overload;
    class function getMemoryMXBean(): JLMMemoryMXBean; static; overload;
    class function getThreadMXBean(): JLMThreadMXBean; static; overload;
    class function getRuntimeMXBean(): JLMRuntimeMXBean; static; overload;
    class function getCompilationMXBean(): JLMCompilationMXBean; static; overload;
    class function getOperatingSystemMXBean(): JLMOperatingSystemMXBean; static; overload;
    class function getMemoryPoolMXBeans(): JUList; static; overload;
    class function getMemoryManagerMXBeans(): JUList; static; overload;
    class function getGarbageCollectorMXBeans(): JUList; static; overload;
    class function getPlatformMBeanServer(): JMMBeanServer; static; overload;
    class function newPlatformMXBeanProxy(para1: JMMBeanServerConnection; para2: JLString; para3: JLClass): JLObject; static; overload;  // throws java.io.IOException
  end;

  JLMMemoryMXBean = interface external 'java.lang.management' name 'MemoryMXBean' 
    function getObjectPendingFinalizationCount(): jint; overload;
    function getHeapMemoryUsage(): JLMMemoryUsage; overload;
    function getNonHeapMemoryUsage(): JLMMemoryUsage; overload;
    function isVerbose(): jboolean; overload;
    procedure setVerbose(para1: jboolean); overload;
    procedure gc(); overload;
  end;

  JLMMemoryManagerMXBean = interface external 'java.lang.management' name 'MemoryManagerMXBean' 
    function getName(): JLString; overload;
    function isValid(): jboolean; overload;
    function getMemoryPoolNames(): Arr1JLString; overload;
  end;

  JLMMemoryNotificationInfo = class external 'java.lang.management' name 'MemoryNotificationInfo' (JLObject)
  public
    const
      MEMORY_THRESHOLD_EXCEEDED = 'java.management.memory.threshold.exceeded';
      MEMORY_COLLECTION_THRESHOLD_EXCEEDED = 'java.management.memory.collection.threshold.exceeded';
  public
    constructor create(para1: JLString; para2: JLMMemoryUsage; para3: jlong); overload;
    function getPoolName(): JLString; overload; virtual;
    function getUsage(): JLMMemoryUsage; overload; virtual;
    function getCount(): jlong; overload; virtual;
    class function from(para1: JMOCompositeData): JLMMemoryNotificationInfo; static; overload;
  end;

  JLMMemoryPoolMXBean = interface external 'java.lang.management' name 'MemoryPoolMXBean' 
    function getName(): JLString; overload;
    function getType(): JLMMemoryType; overload;
    function getUsage(): JLMMemoryUsage; overload;
    function getPeakUsage(): JLMMemoryUsage; overload;
    procedure resetPeakUsage(); overload;
    function isValid(): jboolean; overload;
    function getMemoryManagerNames(): Arr1JLString; overload;
    function getUsageThreshold(): jlong; overload;
    procedure setUsageThreshold(para1: jlong); overload;
    function isUsageThresholdExceeded(): jboolean; overload;
    function getUsageThresholdCount(): jlong; overload;
    function isUsageThresholdSupported(): jboolean; overload;
    function getCollectionUsageThreshold(): jlong; overload;
    procedure setCollectionUsageThreshold(para1: jlong); overload;
    function isCollectionUsageThresholdExceeded(): jboolean; overload;
    function getCollectionUsageThresholdCount(): jlong; overload;
    function getCollectionUsage(): JLMMemoryUsage; overload;
    function isCollectionUsageThresholdSupported(): jboolean; overload;
  end;

  JLMMemoryUsage = class external 'java.lang.management' name 'MemoryUsage' (JLObject)
  public
    constructor create(para1: jlong; para2: jlong; para3: jlong; para4: jlong); overload;
    function getInit(): jlong; overload; virtual;
    function getUsed(): jlong; overload; virtual;
    function getCommitted(): jlong; overload; virtual;
    function getMax(): jlong; overload; virtual;
    function toString(): JLString; overload; virtual;
    class function from(para1: JMOCompositeData): JLMMemoryUsage; static; overload;
  end;

  JLMOperatingSystemMXBean = interface external 'java.lang.management' name 'OperatingSystemMXBean' 
    function getName(): JLString; overload;
    function getArch(): JLString; overload;
    function getVersion(): JLString; overload;
    function getAvailableProcessors(): jint; overload;
    function getSystemLoadAverage(): jdouble; overload;
  end;

  JLMRuntimeMXBean = interface external 'java.lang.management' name 'RuntimeMXBean' 
    function getName(): JLString; overload;
    function getVmName(): JLString; overload;
    function getVmVendor(): JLString; overload;
    function getVmVersion(): JLString; overload;
    function getSpecName(): JLString; overload;
    function getSpecVendor(): JLString; overload;
    function getSpecVersion(): JLString; overload;
    function getManagementSpecVersion(): JLString; overload;
    function getClassPath(): JLString; overload;
    function getLibraryPath(): JLString; overload;
    function isBootClassPathSupported(): jboolean; overload;
    function getBootClassPath(): JLString; overload;
    function getInputArguments(): JUList; overload;
    function getUptime(): jlong; overload;
    function getStartTime(): jlong; overload;
    function getSystemProperties(): JUMap; overload;
  end;

  JLMThreadMXBean = interface external 'java.lang.management' name 'ThreadMXBean' 
    function getThreadCount(): jint; overload;
    function getPeakThreadCount(): jint; overload;
    function getTotalStartedThreadCount(): jlong; overload;
    function getDaemonThreadCount(): jint; overload;
    function getAllThreadIds(): Arr1jlong; overload;
    function getThreadInfo(para1: jlong): JLMThreadInfo; overload;
    function getThreadInfo(para1: Arr1jlong): Arr1JLMThreadInfo; overload;
    function getThreadInfo(var para1: array of jlong): Arr1JLMThreadInfo; overload;
    function getThreadInfo(para1: jlong; para2: jint): JLMThreadInfo; overload;
    function getThreadInfo(para1: Arr1jlong; para2: jint): Arr1JLMThreadInfo; overload;
    function getThreadInfo(var para1: array of jlong; para2: jint): Arr1JLMThreadInfo; overload;
    function isThreadContentionMonitoringSupported(): jboolean; overload;
    function isThreadContentionMonitoringEnabled(): jboolean; overload;
    procedure setThreadContentionMonitoringEnabled(para1: jboolean); overload;
    function getCurrentThreadCpuTime(): jlong; overload;
    function getCurrentThreadUserTime(): jlong; overload;
    function getThreadCpuTime(para1: jlong): jlong; overload;
    function getThreadUserTime(para1: jlong): jlong; overload;
    function isThreadCpuTimeSupported(): jboolean; overload;
    function isCurrentThreadCpuTimeSupported(): jboolean; overload;
    function isThreadCpuTimeEnabled(): jboolean; overload;
    procedure setThreadCpuTimeEnabled(para1: jboolean); overload;
    function findMonitorDeadlockedThreads(): Arr1jlong; overload;
    procedure resetPeakThreadCount(); overload;
    function findDeadlockedThreads(): Arr1jlong; overload;
    function isObjectMonitorUsageSupported(): jboolean; overload;
    function isSynchronizerUsageSupported(): jboolean; overload;
    function getThreadInfo(para1: Arr1jlong; para2: jboolean; para3: jboolean): Arr1JLMThreadInfo; overload;
    function getThreadInfo(var para1: array of jlong; para2: jboolean; para3: jboolean): Arr1JLMThreadInfo; overload;
    function dumpAllThreads(para1: jboolean; para2: jboolean): Arr1JLMThreadInfo; overload;
  end;

  JLRReference = class abstract external 'java.lang.ref' name 'Reference' (JLObject)
  public
    type
      InnerLock = class;
      Arr1InnerLock = array of InnerLock;
      Arr2InnerLock = array of Arr1InnerLock;
      Arr3InnerLock = array of Arr2InnerLock;
      InnerReferenceHandler = class;
      Arr1InnerReferenceHandler = array of InnerReferenceHandler;
      Arr2InnerReferenceHandler = array of Arr1InnerReferenceHandler;
      Arr3InnerReferenceHandler = array of Arr2InnerReferenceHandler;
      InnerLock = class external 'java.lang.ref' name 'Lock' 
      end;

      InnerReferenceHandler = class external 'java.lang.ref' name 'ReferenceHandler' 
      end;

  public
    function get(): JLObject; overload; virtual;
    procedure clear(); overload; virtual;
    function isEnqueued(): jboolean; overload; virtual;
    function enqueue(): jboolean; overload; virtual;
  end;

  JLRReferenceQueue = class external 'java.lang.ref' name 'ReferenceQueue' (JLObject)
  public
    type
      InnerLock = class;
      Arr1InnerLock = array of InnerLock;
      Arr2InnerLock = array of Arr1InnerLock;
      Arr3InnerLock = array of Arr2InnerLock;
      InnerNull = class;
      Arr1InnerNull = array of InnerNull;
      Arr2InnerNull = array of Arr1InnerNull;
      Arr3InnerNull = array of Arr2InnerNull;
      InnerLock = class external 'java.lang.ref' name 'Lock' 
      end;

      InnerNull = class external 'java.lang.ref' name 'Null' 
      end;

  public
    constructor create(); overload;
    function poll(): JLRReference; overload; virtual;
    function remove(para1: jlong): JLRReference; overload; virtual;  // throws java.lang.IllegalArgumentException, java.lang.InterruptedException
    function remove(): JLRReference; overload; virtual;  // throws java.lang.InterruptedException
  end;

  JLRInvocationHandler = interface external 'java.lang.reflect' name 'InvocationHandler' 
    function invoke(para1: JLObject; para2: JLRMethod; para3: Arr1JLObject): JLObject; overload;  // throws java.lang.Throwable
    function invoke(para1: JLObject; para2: JLRMethod; var para3: array of JLObject): JLObject; overload;  // throws java.lang.Throwable
  end;

  JLRModifier = class external 'java.lang.reflect' name 'Modifier' (JLObject)
  public
    const
      &PUBLIC = 1;
      &PRIVATE = 2;
      &PROTECTED = 4;
      STATIC = 8;
      &FINAL = 16;
      SYNCHRONIZED = 32;
      VOLATILE = 64;
      TRANSIENT = 128;
      NATIVE = 256;
      &INTERFACE = 512;
      &ABSTRACT = 1024;
      &STRICT = 2048;
  public
    constructor create(); overload;
    class function isPublic(para1: jint): jboolean; static; overload;
    class function isPrivate(para1: jint): jboolean; static; overload;
    class function isProtected(para1: jint): jboolean; static; overload;
    class function isStatic(para1: jint): jboolean; static; overload;
    class function isFinal(para1: jint): jboolean; static; overload;
    class function isSynchronized(para1: jint): jboolean; static; overload;
    class function isVolatile(para1: jint): jboolean; static; overload;
    class function isTransient(para1: jint): jboolean; static; overload;
    class function isNative(para1: jint): jboolean; static; overload;
    class function isInterface(para1: jint): jboolean; static; overload;
    class function isAbstract(para1: jint): jboolean; static; overload;
    class function isStrict(para1: jint): jboolean; static; overload;
    class function toString(para1: jint): JLString; static; overload;
  end;

  JMBitSieve = class external 'java.math' name 'BitSieve' (JLObject)
  end;

  JMMutableBigInteger = class external 'java.math' name 'MutableBigInteger' (JLObject)
  public
    function toString(): JLString; overload; virtual;
  end;

  JNCacheRequest = class abstract external 'java.net' name 'CacheRequest' (JLObject)
  public
    constructor create(); overload;
    function getBody(): JIOutputStream; overload; virtual; abstract;  // throws java.io.IOException
    procedure abort(); overload; virtual; abstract;
  end;

  JNCacheResponse = class abstract external 'java.net' name 'CacheResponse' (JLObject)
  public
    constructor create(); overload;
    function getHeaders(): JUMap; overload; virtual; abstract;  // throws java.io.IOException
    function getBody(): JIInputStream; overload; virtual; abstract;  // throws java.io.IOException
  end;

  JNContentHandler = class abstract external 'java.net' name 'ContentHandler' (JLObject)
  public
    constructor create(); overload;
    function getContent(para1: JNURLConnection): JLObject; overload; virtual; abstract;  // throws java.io.IOException
    function getContent(para1: JNURLConnection; para2: Arr1JLClass): JLObject; overload; virtual;  // throws java.io.IOException
    function getContent(para1: JNURLConnection; var para2: array of JLClass): JLObject; overload; virtual;  // throws java.io.IOException
  end;

  JNContentHandlerFactory = interface external 'java.net' name 'ContentHandlerFactory' 
    function createContentHandler(para1: JLString): JNContentHandler; overload;
  end;

  JNCookieHandler = class abstract external 'java.net' name 'CookieHandler' (JLObject)
  public
    constructor create(); overload;
    class function getDefault(): JNCookieHandler; static; overload;
    class procedure setDefault(para1: JNCookieHandler); static; overload;
    function get(para1: JNURI; para2: JUMap): JUMap; overload; virtual; abstract;  // throws java.io.IOException
    procedure put(para1: JNURI; para2: JUMap); overload; virtual; abstract;  // throws java.io.IOException
  end;

  JNCookiePolicy = interface external 'java.net' name 'CookiePolicy' 
    final class var
      fACCEPT_ALL: JNCookiePolicy; external name 'ACCEPT_ALL';
      fACCEPT_NONE: JNCookiePolicy; external name 'ACCEPT_NONE';
      fACCEPT_ORIGINAL_SERVER: JNCookiePolicy; external name 'ACCEPT_ORIGINAL_SERVER';
    function shouldAccept(para1: JNURI; para2: JNHttpCookie): jboolean; overload;
  end;

  JNCookieStore = interface external 'java.net' name 'CookieStore' 
    procedure add(para1: JNURI; para2: JNHttpCookie); overload;
    function get(para1: JNURI): JUList; overload;
    function getCookies(): JUList; overload;
    function getURIs(): JUList; overload;
    function remove(para1: JNURI; para2: JNHttpCookie): jboolean; overload;
    function removeAll(): jboolean; overload;
  end;

  JNDatagramPacket = class sealed external 'java.net' name 'DatagramPacket' (JLObject)
  public
    constructor create(para1: Arr1jbyte; para2: jint; para3: jint); overload;
    constructor create(const para1: array of jbyte; para2: jint; para3: jint); overload;
    constructor create(para1: Arr1jbyte; para2: jint); overload;
    constructor create(const para1: array of jbyte; para2: jint); overload;
    constructor create(para1: Arr1jbyte; para2: jint; para3: jint; para4: JNInetAddress; para5: jint); overload;
    constructor create(const para1: array of jbyte; para2: jint; para3: jint; para4: JNInetAddress; para5: jint); overload;
    constructor create(para1: Arr1jbyte; para2: jint; para3: jint; para4: JNSocketAddress); overload;  // throws java.net.SocketException
    constructor create(const para1: array of jbyte; para2: jint; para3: jint; para4: JNSocketAddress); overload;  // throws java.net.SocketException
    constructor create(para1: Arr1jbyte; para2: jint; para3: JNInetAddress; para4: jint); overload;
    constructor create(const para1: array of jbyte; para2: jint; para3: JNInetAddress; para4: jint); overload;
    constructor create(para1: Arr1jbyte; para2: jint; para3: JNSocketAddress); overload;  // throws java.net.SocketException
    constructor create(const para1: array of jbyte; para2: jint; para3: JNSocketAddress); overload;  // throws java.net.SocketException
    function getAddress(): JNInetAddress; overload; virtual;
    function getPort(): jint; overload; virtual;
    function getData(): Arr1jbyte; overload; virtual;
    function getOffset(): jint; overload; virtual;
    function getLength(): jint; overload; virtual;
    procedure setData(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setData(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setAddress(para1: JNInetAddress); overload; virtual;
    procedure setPort(para1: jint); overload; virtual;
    procedure setSocketAddress(para1: JNSocketAddress); overload; virtual;
    function getSocketAddress(): JNSocketAddress; overload; virtual;
    procedure setData(para1: Arr1jbyte); overload; virtual;
    procedure setData(var para1: array of jbyte); overload; virtual;
    procedure setLength(para1: jint); overload; virtual;
  end;

  JNDatagramSocket = class external 'java.net' name 'DatagramSocket' (JLObject)
  public
    constructor create(); overload;  // throws java.net.SocketException
  strict protected
    constructor create(para1: JNDatagramSocketImpl); overload;
  public
    constructor create(para1: JNSocketAddress); overload;  // throws java.net.SocketException
    constructor create(para1: jint); overload;  // throws java.net.SocketException
    constructor create(para1: jint; para2: JNInetAddress); overload;  // throws java.net.SocketException
    procedure bind(para1: JNSocketAddress); overload; virtual;  // throws java.net.SocketException
    procedure connect(para1: JNInetAddress; para2: jint); overload; virtual;
    procedure connect(para1: JNSocketAddress); overload; virtual;  // throws java.net.SocketException
    procedure disconnect(); overload; virtual;
    function isBound(): jboolean; overload; virtual;
    function isConnected(): jboolean; overload; virtual;
    function getInetAddress(): JNInetAddress; overload; virtual;
    function getPort(): jint; overload; virtual;
    function getRemoteSocketAddress(): JNSocketAddress; overload; virtual;
    function getLocalSocketAddress(): JNSocketAddress; overload; virtual;
    procedure send(para1: JNDatagramPacket); overload; virtual;  // throws java.io.IOException
    procedure receive(para1: JNDatagramPacket); overload; virtual;  // throws java.io.IOException
    function getLocalAddress(): JNInetAddress; overload; virtual;
    function getLocalPort(): jint; overload; virtual;
    procedure setSoTimeout(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getSoTimeout(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setSendBufferSize(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getSendBufferSize(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setReceiveBufferSize(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getReceiveBufferSize(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setReuseAddress(para1: jboolean); overload; virtual;  // throws java.net.SocketException
    function getReuseAddress(): jboolean; overload; virtual;  // throws java.net.SocketException
    procedure setBroadcast(para1: jboolean); overload; virtual;  // throws java.net.SocketException
    function getBroadcast(): jboolean; overload; virtual;  // throws java.net.SocketException
    procedure setTrafficClass(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getTrafficClass(): jint; overload; virtual;  // throws java.net.SocketException
    procedure close(); overload; virtual;
    function isClosed(): jboolean; overload; virtual;
    function getChannel(): JNCDatagramChannel; overload; virtual;
    class procedure setDatagramSocketImplFactory(para1: JNDatagramSocketImplFactory); static; overload;  // throws java.io.IOException
  end;

  JNDatagramSocketImplFactory = interface external 'java.net' name 'DatagramSocketImplFactory' 
    function createDatagramSocketImpl(): JNDatagramSocketImpl; overload;
  end;

  JNFileNameMap = interface external 'java.net' name 'FileNameMap' 
    function getContentTypeFor(para1: JLString): JLString; overload;
  end;

  JNIDN = class sealed external 'java.net' name 'IDN' (JLObject)
  public
    const
      ALLOW_UNASSIGNED = 1;
      USE_STD3_ASCII_RULES = 2;
  public
    class function toASCII(para1: JLString; para2: jint): JLString; static; overload;
    class function toASCII(para1: JLString): JLString; static; overload;
    class function toUnicode(para1: JLString; para2: jint): JLString; static; overload;
    class function toUnicode(para1: JLString): JLString; static; overload;
  end;

  JNInetAddressContainer = class external 'java.net' name 'InetAddressContainer' (JLObject)
  end;

  JNInetAddressImpl = interface external 'java.net' name 'InetAddressImpl' 
    function getLocalHostName(): JLString; overload;  // throws java.net.UnknownHostException
    function lookupAllHostAddr(para1: JLString): Arr1JNInetAddress; overload;  // throws java.net.UnknownHostException
    function getHostByAddr(para1: Arr1jbyte): JLString; overload;  // throws java.net.UnknownHostException
    function getHostByAddr(var para1: array of jbyte): JLString; overload;  // throws java.net.UnknownHostException
    function anyLocalAddress(): JNInetAddress; overload;
    function loopbackAddress(): JNInetAddress; overload;
    function isReachable(para1: JNInetAddress; para2: jint; para3: JNNetworkInterface; para4: jint): jboolean; overload;  // throws java.io.IOException
  end;

  JNInetAddressImplFactory = class external 'java.net' name 'InetAddressImplFactory' (JLObject)
  end;

  JNInterfaceAddress = class external 'java.net' name 'InterfaceAddress' (JLObject)
  public
    function getAddress(): JNInetAddress; overload; virtual;
    function getBroadcast(): JNInetAddress; overload; virtual;
    function getNetworkPrefixLength(): jshort; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JNNetworkInterface = class sealed external 'java.net' name 'NetworkInterface' (JLObject)
  public
    function getName(): JLString; overload; virtual;
    function getInetAddresses(): JUEnumeration; overload; virtual;
    function getInterfaceAddresses(): JUList; overload; virtual;
    function getSubInterfaces(): JUEnumeration; overload; virtual;
    function getParent(): JNNetworkInterface; overload; virtual;
    function getDisplayName(): JLString; overload; virtual;
    class function getByName(para1: JLString): JNNetworkInterface; static; overload;  // throws java.net.SocketException
    class function getByInetAddress(para1: JNInetAddress): JNNetworkInterface; static; overload;  // throws java.net.SocketException
    class function getNetworkInterfaces(): JUEnumeration; static; overload;  // throws java.net.SocketException
    function isUp(): jboolean; overload; virtual;  // throws java.net.SocketException
    function isLoopback(): jboolean; overload; virtual;  // throws java.net.SocketException
    function isPointToPoint(): jboolean; overload; virtual;  // throws java.net.SocketException
    function supportsMulticast(): jboolean; overload; virtual;  // throws java.net.SocketException
    function getHardwareAddress(): Arr1jbyte; overload; virtual;  // throws java.net.SocketException
    function getMTU(): jint; overload; virtual;  // throws java.net.SocketException
    function isVirtual(): jboolean; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JNParts = class external 'java.net' name 'Parts' (JLObject)
  end;

  JNPasswordAuthentication = class sealed external 'java.net' name 'PasswordAuthentication' (JLObject)
  public
    constructor create(para1: JLString; para2: Arr1jchar); overload;
    constructor create(para1: JLString; const para2: array of jchar); overload;
    function getUserName(): JLString; overload; virtual;
    function getPassword(): Arr1jchar; overload; virtual;
  end;

  JNProxySelector = class abstract external 'java.net' name 'ProxySelector' (JLObject)
  public
    constructor create(); overload;
    class function getDefault(): JNProxySelector; static; overload;
    class procedure setDefault(para1: JNProxySelector); static; overload;
    function select(para1: JNURI): JUList; overload; virtual; abstract;
    procedure connectFailed(para1: JNURI; para2: JNSocketAddress; para3: JIIOException); overload; virtual; abstract;
  end;

  JNResponseCache = class abstract external 'java.net' name 'ResponseCache' (JLObject)
  public
    constructor create(); overload;
    class function getDefault(): JNResponseCache; static; overload;
    class procedure setDefault(para1: JNResponseCache); static; overload;
    function get(para1: JNURI; para2: JLString; para3: JUMap): JNCacheResponse; overload; virtual; abstract;  // throws java.io.IOException
    function put(para1: JNURI; para2: JNURLConnection): JNCacheRequest; overload; virtual; abstract;  // throws java.io.IOException
  end;

  JNServerSocket = class external 'java.net' name 'ServerSocket' (JLObject)
  public
    constructor create(); overload;  // throws java.io.IOException
    constructor create(para1: jint); overload;  // throws java.io.IOException
    constructor create(para1: jint; para2: jint); overload;  // throws java.io.IOException
    constructor create(para1: jint; para2: jint; para3: JNInetAddress); overload;  // throws java.io.IOException
    procedure bind(para1: JNSocketAddress); overload; virtual;  // throws java.io.IOException
    procedure bind(para1: JNSocketAddress; para2: jint); overload; virtual;  // throws java.io.IOException
    function getInetAddress(): JNInetAddress; overload; virtual;
    function getLocalPort(): jint; overload; virtual;
    function getLocalSocketAddress(): JNSocketAddress; overload; virtual;
    function accept(): JNSocket; overload; virtual;  // throws java.io.IOException
  strict protected
    procedure implAccept(para1: JNSocket); overload; virtual; final;  // throws java.io.IOException
  public
    procedure close(); overload; virtual;  // throws java.io.IOException
    function getChannel(): JNCServerSocketChannel; overload; virtual;
    function isBound(): jboolean; overload; virtual;
    function isClosed(): jboolean; overload; virtual;
    procedure setSoTimeout(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getSoTimeout(): jint; overload; virtual;  // throws java.io.IOException
    procedure setReuseAddress(para1: jboolean); overload; virtual;  // throws java.net.SocketException
    function getReuseAddress(): jboolean; overload; virtual;  // throws java.net.SocketException
    function toString(): JLString; overload; virtual;
    class procedure setSocketFactory(para1: JNSocketImplFactory); static; overload;  // throws java.io.IOException
    procedure setReceiveBufferSize(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getReceiveBufferSize(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setPerformancePreferences(para1: jint; para2: jint; para3: jint); overload; virtual;
  end;

  JNSocket = class external 'java.net' name 'Socket' (JLObject)
  public
    constructor create(); overload;
    constructor create(para1: JNProxy); overload;
  strict protected
    constructor create(para1: JNSocketImpl); overload;  // throws java.net.SocketException
  public
    constructor create(para1: JLString; para2: jint); overload;  // throws java.net.UnknownHostException, java.io.IOException
    constructor create(para1: JNInetAddress; para2: jint); overload;  // throws java.io.IOException
    constructor create(para1: JLString; para2: jint; para3: JNInetAddress; para4: jint); overload;  // throws java.io.IOException
    constructor create(para1: JNInetAddress; para2: jint; para3: JNInetAddress; para4: jint); overload;  // throws java.io.IOException
    constructor create(para1: JLString; para2: jint; para3: jboolean); overload;  // throws java.io.IOException
    constructor create(para1: JNInetAddress; para2: jint; para3: jboolean); overload;  // throws java.io.IOException
    procedure connect(para1: JNSocketAddress); overload; virtual;  // throws java.io.IOException
    procedure connect(para1: JNSocketAddress; para2: jint); overload; virtual;  // throws java.io.IOException
    procedure bind(para1: JNSocketAddress); overload; virtual;  // throws java.io.IOException
    function getInetAddress(): JNInetAddress; overload; virtual;
    function getLocalAddress(): JNInetAddress; overload; virtual;
    function getPort(): jint; overload; virtual;
    function getLocalPort(): jint; overload; virtual;
    function getRemoteSocketAddress(): JNSocketAddress; overload; virtual;
    function getLocalSocketAddress(): JNSocketAddress; overload; virtual;
    function getChannel(): JNCSocketChannel; overload; virtual;
    function getInputStream(): JIInputStream; overload; virtual;  // throws java.io.IOException
    function getOutputStream(): JIOutputStream; overload; virtual;  // throws java.io.IOException
    procedure setTcpNoDelay(para1: jboolean); overload; virtual;  // throws java.net.SocketException
    function getTcpNoDelay(): jboolean; overload; virtual;  // throws java.net.SocketException
    procedure setSoLinger(para1: jboolean; para2: jint); overload; virtual;  // throws java.net.SocketException
    function getSoLinger(): jint; overload; virtual;  // throws java.net.SocketException
    procedure sendUrgentData(para1: jint); overload; virtual;  // throws java.io.IOException
    procedure setOOBInline(para1: jboolean); overload; virtual;  // throws java.net.SocketException
    function getOOBInline(): jboolean; overload; virtual;  // throws java.net.SocketException
    procedure setSoTimeout(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getSoTimeout(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setSendBufferSize(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getSendBufferSize(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setReceiveBufferSize(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getReceiveBufferSize(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setKeepAlive(para1: jboolean); overload; virtual;  // throws java.net.SocketException
    function getKeepAlive(): jboolean; overload; virtual;  // throws java.net.SocketException
    procedure setTrafficClass(para1: jint); overload; virtual;  // throws java.net.SocketException
    function getTrafficClass(): jint; overload; virtual;  // throws java.net.SocketException
    procedure setReuseAddress(para1: jboolean); overload; virtual;  // throws java.net.SocketException
    function getReuseAddress(): jboolean; overload; virtual;  // throws java.net.SocketException
    procedure close(); overload; virtual;  // throws java.io.IOException
    procedure shutdownInput(); overload; virtual;  // throws java.io.IOException
    procedure shutdownOutput(); overload; virtual;  // throws java.io.IOException
    function toString(): JLString; overload; virtual;
    function isConnected(): jboolean; overload; virtual;
    function isBound(): jboolean; overload; virtual;
    function isClosed(): jboolean; overload; virtual;
    function isInputShutdown(): jboolean; overload; virtual;
    function isOutputShutdown(): jboolean; overload; virtual;
    class procedure setSocketImplFactory(para1: JNSocketImplFactory); static; overload;  // throws java.io.IOException
    procedure setPerformancePreferences(para1: jint; para2: jint; para3: jint); overload; virtual;
  end;

  JNSocketImplFactory = interface external 'java.net' name 'SocketImplFactory' 
    function createSocketImpl(): JNSocketImpl; overload;
  end;

  JNSocketOptions = interface external 'java.net' name 'SocketOptions' 
    const
      TCP_NODELAY = 1;
      SO_BINDADDR = 15;
      SO_REUSEADDR = 4;
      SO_BROADCAST = 32;
      IP_MULTICAST_IF = 16;
      IP_MULTICAST_IF2 = 31;
      IP_MULTICAST_LOOP = 18;
      IP_TOS = 3;
      SO_LINGER = 128;
      SO_TIMEOUT = 4102;
      SO_SNDBUF = 4097;
      SO_RCVBUF = 4098;
      SO_KEEPALIVE = 8;
      SO_OOBINLINE = 4099;
    procedure setOption(para1: jint; para2: JLObject); overload;  // throws java.net.SocketException
    function getOption(para1: jint): JLObject; overload;  // throws java.net.SocketException
  end;

  JNSocksConsts = interface external 'java.net' name 'SocksConsts' 
    const
      PROTO_VERS4 = 4;
      PROTO_VERS = 5;
      DEFAULT_PORT = 1080;
      NO_AUTH = 0;
      GSSAPI = 1;
      USER_PASSW = 2;
      NO_METHODS = -1;
      CONNECT = 1;
      BIND = 2;
      UDP_ASSOC = 3;
      IPV4 = 1;
      DOMAIN_NAME = 3;
      IPV6 = 4;
      REQUEST_OK = 0;
      GENERAL_FAILURE = 1;
      NOT_ALLOWED = 2;
      NET_UNREACHABLE = 3;
      HOST_UNREACHABLE = 4;
      CONN_REFUSED = 5;
      TTL_EXPIRED = 6;
      CMD_NOT_SUPPORTED = 7;
      ADDR_TYPE_NOT_SUP = 8;
  end;

  JNURLConnection = class abstract external 'java.net' name 'URLConnection' (JLObject)
  strict protected
    var
      furl: JNURL; external name 'url';
      fdoInput: jboolean; external name 'doInput';
      fdoOutput: jboolean; external name 'doOutput';
      fallowUserInteraction: jboolean; external name 'allowUserInteraction';
      fuseCaches: jboolean; external name 'useCaches';
      fifModifiedSince: jlong; external name 'ifModifiedSince';
      fconnected: jboolean; external name 'connected';
  public
    class function getFileNameMap(): JNFileNameMap; static; overload;
    class procedure setFileNameMap(para1: JNFileNameMap); static; overload;
    procedure connect(); overload; virtual; abstract;  // throws java.io.IOException
    procedure setConnectTimeout(para1: jint); overload; virtual;
    function getConnectTimeout(): jint; overload; virtual;
    procedure setReadTimeout(para1: jint); overload; virtual;
    function getReadTimeout(): jint; overload; virtual;
  strict protected
    constructor create(para1: JNURL); overload;
  public
    function getURL(): JNURL; overload; virtual;
    function getContentLength(): jint; overload; virtual;
    function getContentType(): JLString; overload; virtual;
    function getContentEncoding(): JLString; overload; virtual;
    function getExpiration(): jlong; overload; virtual;
    function getDate(): jlong; overload; virtual;
    function getLastModified(): jlong; overload; virtual;
    function getHeaderField(para1: JLString): JLString; overload; virtual;
    function getHeaderFields(): JUMap; overload; virtual;
    function getHeaderFieldInt(para1: JLString; para2: jint): jint; overload; virtual;
    function getHeaderFieldDate(para1: JLString; para2: jlong): jlong; overload; virtual;
    function getHeaderFieldKey(para1: jint): JLString; overload; virtual;
    function getHeaderField(para1: jint): JLString; overload; virtual;
    function getContent(): JLObject; overload; virtual;  // throws java.io.IOException
    function getContent(para1: Arr1JLClass): JLObject; overload; virtual;  // throws java.io.IOException
    function getContent(var para1: array of JLClass): JLObject; overload; virtual;  // throws java.io.IOException
    function getPermission(): JSPermission; overload; virtual;  // throws java.io.IOException
    function getInputStream(): JIInputStream; overload; virtual;  // throws java.io.IOException
    function getOutputStream(): JIOutputStream; overload; virtual;  // throws java.io.IOException
    function toString(): JLString; overload; virtual;
    procedure setDoInput(para1: jboolean); overload; virtual;
    function getDoInput(): jboolean; overload; virtual;
    procedure setDoOutput(para1: jboolean); overload; virtual;
    function getDoOutput(): jboolean; overload; virtual;
    procedure setAllowUserInteraction(para1: jboolean); overload; virtual;
    function getAllowUserInteraction(): jboolean; overload; virtual;
    class procedure setDefaultAllowUserInteraction(para1: jboolean); static; overload;
    class function getDefaultAllowUserInteraction(): jboolean; static; overload;
    procedure setUseCaches(para1: jboolean); overload; virtual;
    function getUseCaches(): jboolean; overload; virtual;
    procedure setIfModifiedSince(para1: jlong); overload; virtual;
    function getIfModifiedSince(): jlong; overload; virtual;
    function getDefaultUseCaches(): jboolean; overload; virtual;
    procedure setDefaultUseCaches(para1: jboolean); overload; virtual;
    procedure setRequestProperty(para1: JLString; para2: JLString); overload; virtual;
    procedure addRequestProperty(para1: JLString; para2: JLString); overload; virtual;
    function getRequestProperty(para1: JLString): JLString; overload; virtual;
    function getRequestProperties(): JUMap; overload; virtual;
    class procedure setDefaultRequestProperty(para1: JLString; para2: JLString); static; overload;
    class function getDefaultRequestProperty(para1: JLString): JLString; static; overload;
    class procedure setContentHandlerFactory(para1: JNContentHandlerFactory); static; overload;
    class function guessContentTypeFromName(para1: JLString): JLString; static; overload;
    class function guessContentTypeFromStream(para1: JIInputStream): JLString; static; overload;  // throws java.io.IOException
  end;

  JNURLDecoder = class external 'java.net' name 'URLDecoder' (JLObject)
  public
    constructor create(); overload;
    class function decode(para1: JLString): JLString; static; overload;
    class function decode(para1: JLString; para2: JLString): JLString; static; overload;  // throws java.io.UnsupportedEncodingException
  end;

  JNURLEncoder = class external 'java.net' name 'URLEncoder' (JLObject)
  public
    class function encode(para1: JLString): JLString; static; overload;
    class function encode(para1: JLString; para2: JLString): JLString; static; overload;  // throws java.io.UnsupportedEncodingException
  end;

  JNURLStreamHandler = class abstract external 'java.net' name 'URLStreamHandler' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function openConnection(para1: JNURL): JNURLConnection; overload; virtual; abstract;  // throws java.io.IOException
    function openConnection(para1: JNURL; para2: JNProxy): JNURLConnection; overload; virtual;  // throws java.io.IOException
    procedure parseURL(para1: JNURL; para2: JLString; para3: jint; para4: jint); overload; virtual;
    function getDefaultPort(): jint; overload; virtual;
    function equals(para1: JNURL; para2: JNURL): jboolean; overload; virtual;
    function hashCode(para1: JNURL): jint; overload; virtual;
    function sameFile(para1: JNURL; para2: JNURL): jboolean; overload; virtual;
    function getHostAddress(para1: JNURL): JNInetAddress; overload; virtual;
    function hostsEqual(para1: JNURL; para2: JNURL): jboolean; overload; virtual;
    function toExternalForm(para1: JNURL): JLString; overload; virtual;
    procedure setURL(para1: JNURL; para2: JLString; para3: JLString; para4: jint; para5: JLString; para6: JLString; para7: JLString; para8: JLString; para9: JLString); overload; virtual;
    procedure setURL(para1: JNURL; para2: JLString; para3: JLString; para4: jint; para5: JLString; para6: JLString); overload; virtual;
  end;

  JNURLStreamHandlerFactory = interface external 'java.net' name 'URLStreamHandlerFactory' 
    function createURLStreamHandler(para1: JLString): JNURLStreamHandler; overload;
  end;

  JNBits = class external 'java.nio' name 'Bits' (JLObject)
  end;

  JNByteOrder = class sealed external 'java.nio' name 'ByteOrder' (JLObject)
  public
    final class var
      fBIG_ENDIAN: JNByteOrder; external name 'BIG_ENDIAN';
      fLITTLE_ENDIAN: JNByteOrder; external name 'LITTLE_ENDIAN';
  public
    class function nativeOrder(): JNByteOrder; static; overload;
    function toString(): JLString; overload; virtual;
  end;

  JNCChannels = class sealed external 'java.nio.channels' name 'Channels' (JLObject)
  public
    type
      InnerReadableByteChannelImpl = class;
      Arr1InnerReadableByteChannelImpl = array of InnerReadableByteChannelImpl;
      Arr2InnerReadableByteChannelImpl = array of Arr1InnerReadableByteChannelImpl;
      Arr3InnerReadableByteChannelImpl = array of Arr2InnerReadableByteChannelImpl;
      InnerWritableByteChannelImpl = class;
      Arr1InnerWritableByteChannelImpl = array of InnerWritableByteChannelImpl;
      Arr2InnerWritableByteChannelImpl = array of Arr1InnerWritableByteChannelImpl;
      Arr3InnerWritableByteChannelImpl = array of Arr2InnerWritableByteChannelImpl;
      InnerReadableByteChannelImpl = class external 'java.nio.channels' name 'ReadableByteChannelImpl' 
      end;

      InnerWritableByteChannelImpl = class external 'java.nio.channels' name 'WritableByteChannelImpl' 
      end;

  public
    class function newInputStream(para1: JNCReadableByteChannel): JIInputStream; static; overload;
    class function newOutputStream(para1: JNCWritableByteChannel): JIOutputStream; static; overload;
    class function newChannel(para1: JIInputStream): JNCReadableByteChannel; static; overload;
    class function newChannel(para1: JIOutputStream): JNCWritableByteChannel; static; overload;
    class function newReader(para1: JNCReadableByteChannel; para2: JNCCharsetDecoder; para3: jint): JIReader; static; overload;
    class function newReader(para1: JNCReadableByteChannel; para2: JLString): JIReader; static; overload;
    class function newWriter(para1: JNCWritableByteChannel; para2: JNCCharsetEncoder; para3: jint): JIWriter; static; overload;
    class function newWriter(para1: JNCWritableByteChannel; para2: JLString): JIWriter; static; overload;
  end;

  JNCFileLock = class abstract external 'java.nio.channels' name 'FileLock' (JLObject)
  strict protected
    constructor create(para1: JNCFileChannel; para2: jlong; para3: jlong; para4: jboolean); overload;
  public
    function channel(): JNCFileChannel; overload; virtual; final;
    function position(): jlong; overload; virtual; final;
    function size(): jlong; overload; virtual; final;
    function isShared(): jboolean; overload; virtual; final;
    function overlaps(para1: jlong; para2: jlong): jboolean; overload; virtual; final;
    function isValid(): jboolean; overload; virtual; abstract;
    procedure release(); overload; virtual; abstract;  // throws java.io.IOException
    function toString(): JLString; overload; virtual; final;
  end;

  JNCSelectionKey = class abstract external 'java.nio.channels' name 'SelectionKey' (JLObject)
  public
    const
      OP_READ = 1;
      OP_WRITE = 4;
      OP_CONNECT = 8;
      OP_ACCEPT = 16;
  strict protected
    constructor create(); overload;
  public
    function channel(): JNCSelectableChannel; overload; virtual; abstract;
    function selector(): JNCSelector; overload; virtual; abstract;
    function isValid(): jboolean; overload; virtual; abstract;
    procedure cancel(); overload; virtual; abstract;
    function interestOps(): jint; overload; virtual; abstract;
    function interestOps(para1: jint): JNCSelectionKey; overload; virtual; abstract;
    function readyOps(): jint; overload; virtual; abstract;
    function isReadable(): jboolean; overload; virtual; final;
    function isWritable(): jboolean; overload; virtual; final;
    function isConnectable(): jboolean; overload; virtual; final;
    function isAcceptable(): jboolean; overload; virtual; final;
    function attach(para1: JLObject): JLObject; overload; virtual; final;
    function attachment(): JLObject; overload; virtual; final;
  end;

  JNCSelector = class abstract external 'java.nio.channels' name 'Selector' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function open(): JNCSelector; static; overload;  // throws java.io.IOException
    function isOpen(): jboolean; overload; virtual; abstract;
    function provider(): JNCSSelectorProvider; overload; virtual; abstract;
    function keys(): JUSet; overload; virtual; abstract;
    function selectedKeys(): JUSet; overload; virtual; abstract;
    function selectNow(): jint; overload; virtual; abstract;  // throws java.io.IOException
    function select(para1: jlong): jint; overload; virtual; abstract;  // throws java.io.IOException
    function select(): jint; overload; virtual; abstract;  // throws java.io.IOException
    function wakeup(): JNCSelector; overload; virtual; abstract;
    procedure close(); overload; virtual; abstract;  // throws java.io.IOException
  end;

  JNCSSelectorProvider = class abstract external 'java.nio.channels.spi' name 'SelectorProvider' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function provider(): JNCSSelectorProvider; static; overload;
    function openDatagramChannel(): JNCDatagramChannel; overload; virtual; abstract;  // throws java.io.IOException
    function openPipe(): JNCPipe; overload; virtual; abstract;  // throws java.io.IOException
    function openSelector(): JNCSAbstractSelector; overload; virtual; abstract;  // throws java.io.IOException
    function openServerSocketChannel(): JNCServerSocketChannel; overload; virtual; abstract;  // throws java.io.IOException
    function openSocketChannel(): JNCSocketChannel; overload; virtual; abstract;  // throws java.io.IOException
    function inheritedChannel(): JNCChannel; overload; virtual;  // throws java.io.IOException
  end;

  JRNaming = class sealed external 'java.rmi' name 'Naming' (JLObject)
  public
    type
      InnerParsedNamingURL = class;
      Arr1InnerParsedNamingURL = array of InnerParsedNamingURL;
      Arr2InnerParsedNamingURL = array of Arr1InnerParsedNamingURL;
      Arr3InnerParsedNamingURL = array of Arr2InnerParsedNamingURL;
      InnerParsedNamingURL = class external 'java.rmi' name 'ParsedNamingURL' 
      end;

  public
    class function lookup(para1: JLString): JRRemote; static; overload;  // throws java.rmi.NotBoundException, java.net.MalformedURLException, java.rmi.RemoteException
    class procedure bind(para1: JLString; para2: JRRemote); static; overload;  // throws java.rmi.AlreadyBoundException, java.net.MalformedURLException, java.rmi.RemoteException
    class procedure unbind(para1: JLString); static; overload;  // throws java.rmi.RemoteException, java.rmi.NotBoundException, java.net.MalformedURLException
    class procedure rebind(para1: JLString; para2: JRRemote); static; overload;  // throws java.rmi.RemoteException, java.net.MalformedURLException
    class function list(para1: JLString): Arr1JLString; static; overload;  // throws java.rmi.RemoteException, java.net.MalformedURLException
  end;

  JRRemote = interface external 'java.rmi' name 'Remote' 
  end;

  JRRLocateRegistry = class sealed external 'java.rmi.registry' name 'LocateRegistry' (JLObject)
  public
    class function getRegistry(): JRRRegistry; static; overload;  // throws java.rmi.RemoteException
    class function getRegistry(para1: jint): JRRRegistry; static; overload;  // throws java.rmi.RemoteException
    class function getRegistry(para1: JLString): JRRRegistry; static; overload;  // throws java.rmi.RemoteException
    class function getRegistry(para1: JLString; para2: jint): JRRRegistry; static; overload;  // throws java.rmi.RemoteException
    class function getRegistry(para1: JLString; para2: jint; para3: JRSRMIClientSocketFactory): JRRRegistry; static; overload;  // throws java.rmi.RemoteException
    class function createRegistry(para1: jint): JRRRegistry; static; overload;  // throws java.rmi.RemoteException
    class function createRegistry(para1: jint; para2: JRSRMIClientSocketFactory; para3: JRSRMIServerSocketFactory): JRRRegistry; static; overload;  // throws java.rmi.RemoteException
  end;

  JRRRegistryHandler = interface external 'java.rmi.registry' name 'RegistryHandler' 
    function registryStub(para1: JLString; para2: jint): JRRRegistry; overload;  // throws java.rmi.RemoteException, java.rmi.UnknownHostException
    function registryImpl(para1: jint): JRRRegistry; overload;  // throws java.rmi.RemoteException
  end;

  JRSLoaderHandler = interface external 'java.rmi.server' name 'LoaderHandler' 
    const
      packagePrefix = 'sun.rmi.server';
    function loadClass(para1: JLString): JLClass; overload;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    function loadClass(para1: JNURL; para2: JLString): JLClass; overload;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    function getSecurityContext(para1: JLClassLoader): JLObject; overload;
  end;

  JRSOperation = class external 'java.rmi.server' name 'Operation' (JLObject)
  public
    constructor create(para1: JLString); overload;
    function getOperation(): JLString; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JRSRMIClassLoader = class external 'java.rmi.server' name 'RMIClassLoader' (JLObject)
  public
    class function loadClass(para1: JLString): JLClass; static; overload;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    class function loadClass(para1: JNURL; para2: JLString): JLClass; static; overload;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    class function loadClass(para1: JLString; para2: JLString): JLClass; static; overload;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    class function loadClass(para1: JLString; para2: JLString; para3: JLClassLoader): JLClass; static; overload;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    class function loadProxyClass(para1: JLString; para2: Arr1JLString; para3: JLClassLoader): JLClass; static; overload;  // throws java.lang.ClassNotFoundException, java.net.MalformedURLException
    class function loadProxyClass(para1: JLString; var para2: array of JLString; para3: JLClassLoader): JLClass; static; overload;  // throws java.lang.ClassNotFoundException, java.net.MalformedURLException
    class function getClassLoader(para1: JLString): JLClassLoader; static; overload;  // throws java.net.MalformedURLException, java.lang.SecurityException
    class function getClassAnnotation(para1: JLClass): JLString; static; overload;
    class function getDefaultProviderInstance(): JRSRMIClassLoaderSpi; static; overload;
    class function getSecurityContext(para1: JLClassLoader): JLObject; static; overload;
  end;

  JRSRMIClassLoaderSpi = class abstract external 'java.rmi.server' name 'RMIClassLoaderSpi' (JLObject)
  public
    constructor create(); overload;
    function loadClass(para1: JLString; para2: JLString; para3: JLClassLoader): JLClass; overload; virtual; abstract;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    function loadProxyClass(para1: JLString; para2: Arr1JLString; para3: JLClassLoader): JLClass; overload; virtual; abstract;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    function loadProxyClass(para1: JLString; var para2: array of JLString; para3: JLClassLoader): JLClass; overload; virtual; abstract;  // throws java.net.MalformedURLException, java.lang.ClassNotFoundException
    function getClassLoader(para1: JLString): JLClassLoader; overload; virtual; abstract;  // throws java.net.MalformedURLException
    function getClassAnnotation(para1: JLClass): JLString; overload; virtual; abstract;
  end;

  JRSRMIClientSocketFactory = interface external 'java.rmi.server' name 'RMIClientSocketFactory' 
    function createSocket(para1: JLString; para2: jint): JNSocket; overload;  // throws java.io.IOException
  end;

  JRSRMIFailureHandler = interface external 'java.rmi.server' name 'RMIFailureHandler' 
    function failure(para1: JLException): jboolean; overload;
  end;

  JRSRMIServerSocketFactory = interface external 'java.rmi.server' name 'RMIServerSocketFactory' 
    function createServerSocket(para1: jint): JNServerSocket; overload;  // throws java.io.IOException
  end;

  JRSRemoteCall = interface external 'java.rmi.server' name 'RemoteCall' 
    function getOutputStream(): JIObjectOutput; overload;  // throws java.io.IOException
    procedure releaseOutputStream(); overload;  // throws java.io.IOException
    function getInputStream(): JIObjectInput; overload;  // throws java.io.IOException
    procedure releaseInputStream(); overload;  // throws java.io.IOException
    function getResultStream(para1: jboolean): JIObjectOutput; overload;  // throws java.io.IOException, java.io.StreamCorruptedException
    procedure executeCall(); overload;  // throws java.lang.Exception
    procedure done(); overload;  // throws java.io.IOException
  end;

  JRSSkeleton = interface external 'java.rmi.server' name 'Skeleton' 
    procedure dispatch(para1: JRRemote; para2: JRSRemoteCall; para3: jint; para4: jlong); overload;  // throws java.lang.Exception
    function getOperations(): Arr1JRSOperation; overload;
  end;

  JRSUnreferenced = interface external 'java.rmi.server' name 'Unreferenced' 
    procedure unreferenced(); overload;
  end;

  JSAccessControlContext = class sealed external 'java.security' name 'AccessControlContext' (JLObject)
  public
    constructor create(para1: Arr1JSProtectionDomain); overload;
    constructor create(const para1: array of JSProtectionDomain); overload;
    constructor create(para1: JSAccessControlContext; para2: JSDomainCombiner); overload;
    function getDomainCombiner(): JSDomainCombiner; overload; virtual;
    procedure checkPermission(para1: JSPermission); overload; virtual;  // throws java.security.AccessControlException
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  JSAccessController = class sealed external 'java.security' name 'AccessController' (JLObject)
  public
    class function doPrivileged(para1: JSPrivilegedAction): JLObject; static; overload;
    class function doPrivilegedWithCombiner(para1: JSPrivilegedAction): JLObject; static; overload;
    class function doPrivileged(para1: JSPrivilegedAction; para2: JSAccessControlContext): JLObject; static; overload;
    class function doPrivileged(para1: JSPrivilegedExceptionAction): JLObject; static; overload;  // throws java.security.PrivilegedActionException
    class function doPrivilegedWithCombiner(para1: JSPrivilegedExceptionAction): JLObject; static; overload;  // throws java.security.PrivilegedActionException
    class function doPrivileged(para1: JSPrivilegedExceptionAction; para2: JSAccessControlContext): JLObject; static; overload;  // throws java.security.PrivilegedActionException
    class function getContext(): JSAccessControlContext; static; overload;
    class procedure checkPermission(para1: JSPermission); static; overload;  // throws java.security.AccessControlException
  end;

  JSAlgorithmParameterGenerator = class external 'java.security' name 'AlgorithmParameterGenerator' (JLObject)
  strict protected
    constructor create(para1: JSAlgorithmParameterGeneratorSpi; para2: JSProvider; para3: JLString); overload;
  public
    function getAlgorithm(): JLString; overload; virtual; final;
    class function getInstance(para1: JLString): JSAlgorithmParameterGenerator; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JSAlgorithmParameterGenerator; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JSAlgorithmParameterGenerator; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    procedure init(para1: jint); overload; virtual; final;
    procedure init(para1: jint; para2: JSSecureRandom); overload; virtual; final;
    procedure init(para1: JSSAlgorithmParameterSpec); overload; virtual; final;  // throws java.security.InvalidAlgorithmParameterException
    procedure init(para1: JSSAlgorithmParameterSpec; para2: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidAlgorithmParameterException
    function generateParameters(): JSAlgorithmParameters; overload; virtual; final;
  end;

  JSAlgorithmParameterGeneratorSpi = class abstract external 'java.security' name 'AlgorithmParameterGeneratorSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineInit(para1: jint; para2: JSSecureRandom); overload; virtual; abstract;
    procedure engineInit(para1: JSSAlgorithmParameterSpec; para2: JSSecureRandom); overload; virtual; abstract;  // throws java.security.InvalidAlgorithmParameterException
    function engineGenerateParameters(): JSAlgorithmParameters; overload; virtual; abstract;
  end;

  JSAlgorithmParameters = class external 'java.security' name 'AlgorithmParameters' (JLObject)
  strict protected
    constructor create(para1: JSAlgorithmParametersSpi; para2: JSProvider; para3: JLString); overload;
  public
    function getAlgorithm(): JLString; overload; virtual; final;
    class function getInstance(para1: JLString): JSAlgorithmParameters; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JSAlgorithmParameters; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JSAlgorithmParameters; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    procedure init(para1: JSSAlgorithmParameterSpec); overload; virtual; final;  // throws java.security.spec.InvalidParameterSpecException
    procedure init(para1: Arr1jbyte); overload; virtual; final;  // throws java.io.IOException
    procedure init(var para1: array of jbyte); overload; virtual; final;  // throws java.io.IOException
    procedure init(para1: Arr1jbyte; para2: JLString); overload; virtual; final;  // throws java.io.IOException
    procedure init(var para1: array of jbyte; para2: JLString); overload; virtual; final;  // throws java.io.IOException
    function getParameterSpec(para1: JLClass): JSSAlgorithmParameterSpec; overload; virtual; final;  // throws java.security.spec.InvalidParameterSpecException
    function getEncoded(): Arr1jbyte; overload; virtual; final;  // throws java.io.IOException
    function getEncoded(para1: JLString): Arr1jbyte; overload; virtual; final;  // throws java.io.IOException
    function toString(): JLString; overload; virtual; final;
  end;

  JSAlgorithmParametersSpi = class abstract external 'java.security' name 'AlgorithmParametersSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineInit(para1: JSSAlgorithmParameterSpec); overload; virtual; abstract;  // throws java.security.spec.InvalidParameterSpecException
    procedure engineInit(para1: Arr1jbyte); overload; virtual; abstract;  // throws java.io.IOException
    procedure engineInit(var para1: array of jbyte); overload; virtual; abstract;  // throws java.io.IOException
    procedure engineInit(para1: Arr1jbyte; para2: JLString); overload; virtual; abstract;  // throws java.io.IOException
    procedure engineInit(var para1: array of jbyte; para2: JLString); overload; virtual; abstract;  // throws java.io.IOException
    function engineGetParameterSpec(para1: JLClass): JSSAlgorithmParameterSpec; overload; virtual; abstract;  // throws java.security.spec.InvalidParameterSpecException
    function engineGetEncoded(): Arr1jbyte; overload; virtual; abstract;  // throws java.io.IOException
    function engineGetEncoded(para1: JLString): Arr1jbyte; overload; virtual; abstract;  // throws java.io.IOException
    function engineToString(): JLString; overload; virtual; abstract;
  end;

  JSCertificate = interface external 'java.security' name 'Certificate' 
    function getGuarantor(): JSPrincipal; overload;
    function getPrincipal(): JSPrincipal; overload;
    function getPublicKey(): JSPublicKey; overload;
    procedure encode(para1: JIOutputStream); overload;  // throws java.security.KeyException, java.io.IOException
    procedure decode(para1: JIInputStream); overload;  // throws java.security.KeyException, java.io.IOException
    function getFormat(): JLString; overload;
    function toString(para1: jboolean): JLString; overload;
  end;

  JSDomainCombiner = interface external 'java.security' name 'DomainCombiner' 
    function combine(para1: Arr1JSProtectionDomain; para2: Arr1JSProtectionDomain): Arr1JSProtectionDomain; overload;
    function combine(var para1: array of JSProtectionDomain; var para2: array of JSProtectionDomain): Arr1JSProtectionDomain; overload;
  end;

  JSGuard = interface external 'java.security' name 'Guard' 
    procedure checkGuard(para1: JLObject); overload;  // throws java.lang.SecurityException
  end;

  JSKeyFactory = class external 'java.security' name 'KeyFactory' (JLObject)
  strict protected
    constructor create(para1: JSKeyFactorySpi; para2: JSProvider; para3: JLString); overload;
  public
    class function getInstance(para1: JLString): JSKeyFactory; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JSKeyFactory; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JSKeyFactory; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    function getAlgorithm(): JLString; overload; virtual; final;
    function generatePublic(para1: JSSKeySpec): JSPublicKey; overload; virtual; final;  // throws java.security.spec.InvalidKeySpecException
    function generatePrivate(para1: JSSKeySpec): JSPrivateKey; overload; virtual; final;  // throws java.security.spec.InvalidKeySpecException
    function getKeySpec(para1: JSKey; para2: JLClass): JSSKeySpec; overload; virtual; final;  // throws java.security.spec.InvalidKeySpecException
    function translateKey(para1: JSKey): JSKey; overload; virtual; final;  // throws java.security.InvalidKeyException
  end;

  JSKeyFactorySpi = class abstract external 'java.security' name 'KeyFactorySpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function engineGeneratePublic(para1: JSSKeySpec): JSPublicKey; overload; virtual; abstract;  // throws java.security.spec.InvalidKeySpecException
    function engineGeneratePrivate(para1: JSSKeySpec): JSPrivateKey; overload; virtual; abstract;  // throws java.security.spec.InvalidKeySpecException
    function engineGetKeySpec(para1: JSKey; para2: JLClass): JSSKeySpec; overload; virtual; abstract;  // throws java.security.spec.InvalidKeySpecException
    function engineTranslateKey(para1: JSKey): JSKey; overload; virtual; abstract;  // throws java.security.InvalidKeyException
  end;

  JSKeyPairGeneratorSpi = class abstract external 'java.security' name 'KeyPairGeneratorSpi' (JLObject)
  public
    constructor create(); overload;
    procedure initialize(para1: jint; para2: JSSecureRandom); overload; virtual; abstract;
    procedure initialize(para1: JSSAlgorithmParameterSpec; para2: JSSecureRandom); overload; virtual;  // throws java.security.InvalidAlgorithmParameterException
    function generateKeyPair(): JSKeyPair; overload; virtual; abstract;
  end;

  JSMessageDigestSpi = class abstract external 'java.security' name 'MessageDigestSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function engineGetDigestLength(): jint; overload; virtual;
    procedure engineUpdate(para1: jbyte); overload; virtual; abstract;
    procedure engineUpdate(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual; abstract;
    procedure engineUpdate(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual; abstract;
    procedure engineUpdate(para1: JNByteBuffer); overload; virtual;
    function engineDigest(): Arr1jbyte; overload; virtual; abstract;
    function engineDigest(para1: Arr1jbyte; para2: jint; para3: jint): jint; overload; virtual;  // throws java.security.DigestException
    function engineDigest(var para1: array of jbyte; para2: jint; para3: jint): jint; overload; virtual;  // throws java.security.DigestException
    procedure engineReset(); overload; virtual; abstract;
  public
    function clone(): JLObject; overload; virtual;  // throws java.lang.CloneNotSupportedException
  end;

  JSPolicy = class abstract external 'java.security' name 'Policy' (JLObject)
  public
    type
      InnerPolicyDelegate = class;
      Arr1InnerPolicyDelegate = array of InnerPolicyDelegate;
      Arr2InnerPolicyDelegate = array of Arr1InnerPolicyDelegate;
      Arr3InnerPolicyDelegate = array of Arr2InnerPolicyDelegate;
      InnerUnsupportedEmptyCollection = class;
      Arr1InnerUnsupportedEmptyCollection = array of InnerUnsupportedEmptyCollection;
      Arr2InnerUnsupportedEmptyCollection = array of Arr1InnerUnsupportedEmptyCollection;
      Arr3InnerUnsupportedEmptyCollection = array of Arr2InnerUnsupportedEmptyCollection;
      InnerPolicyDelegate = class external 'java.security' name 'PolicyDelegate' 
      end;

      InnerUnsupportedEmptyCollection = class external 'java.security' name 'UnsupportedEmptyCollection' 
      end;

  public
    type
      InnerParameters = interface;
      Arr1InnerParameters = array of InnerParameters;
      Arr2InnerParameters = array of Arr1InnerParameters;
      Arr3InnerParameters = array of Arr2InnerParameters;
      InnerParameters = interface external 'java.security' name 'Parameters' 
      end;

  public
    final class var
      fUNSUPPORTED_EMPTY_COLLECTION: JSPermissionCollection; external name 'UNSUPPORTED_EMPTY_COLLECTION';
  public
    constructor create(); overload;
    class function getPolicy(): JSPolicy; static; overload;
    class procedure setPolicy(para1: JSPolicy); static; overload;
    class function getInstance(para1: JLString; para2: JSPolicy.InnerParameters): JSPolicy; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JSPolicy.InnerParameters; para3: JLString): JSPolicy; static; overload;  // throws java.security.NoSuchProviderException, java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JSPolicy.InnerParameters; para3: JSProvider): JSPolicy; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual;
    function getType(): JLString; overload; virtual;
    function getParameters(): JSPolicy.InnerParameters; overload; virtual;
    function getPermissions(para1: JSCodeSource): JSPermissionCollection; overload; virtual;
    function getPermissions(para1: JSProtectionDomain): JSPermissionCollection; overload; virtual;
    function implies(para1: JSProtectionDomain; para2: JSPermission): jboolean; overload; virtual;
    procedure refresh(); overload; virtual;
  end;

  JSPolicySpi = class abstract external 'java.security' name 'PolicySpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function engineImplies(para1: JSProtectionDomain; para2: JSPermission): jboolean; overload; virtual; abstract;
    procedure engineRefresh(); overload; virtual;
    function engineGetPermissions(para1: JSCodeSource): JSPermissionCollection; overload; virtual;
    function engineGetPermissions(para1: JSProtectionDomain): JSPermissionCollection; overload; virtual;
  end;

  JSPrincipal = interface external 'java.security' name 'Principal' 
    function equals(para1: JLObject): jboolean; overload;
    function toString(): JLString; overload;
    function hashCode(): jint; overload;
    function getName(): JLString; overload;
  end;

  JSPrivilegedAction = interface external 'java.security' name 'PrivilegedAction' 
    function run(): JLObject; overload;
  end;

  JSPrivilegedExceptionAction = interface external 'java.security' name 'PrivilegedExceptionAction' 
    function run(): JLObject; overload;  // throws java.lang.Exception
  end;

  JSProtectionDomain = class external 'java.security' name 'ProtectionDomain' (JLObject)
  public
    type
      InnerKey = class;
      Arr1InnerKey = array of InnerKey;
      Arr2InnerKey = array of Arr1InnerKey;
      Arr3InnerKey = array of Arr2InnerKey;
      InnerKey = class sealed external 'java.security' name 'Key' 
      end;

  public
    constructor create(para1: JSCodeSource; para2: JSPermissionCollection); overload;
    constructor create(para1: JSCodeSource; para2: JSPermissionCollection; para3: JLClassLoader; para4: Arr1JSPrincipal); overload;
    constructor create(para1: JSCodeSource; para2: JSPermissionCollection; para3: JLClassLoader; const para4: array of JSPrincipal); overload;
    function getCodeSource(): JSCodeSource; overload; virtual; final;
    function getClassLoader(): JLClassLoader; overload; virtual; final;
    function getPrincipals(): Arr1JSPrincipal; overload; virtual; final;
    function getPermissions(): JSPermissionCollection; overload; virtual; final;
    function implies(para1: JSPermission): jboolean; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JSSecurity = class sealed external 'java.security' name 'Security' (JLObject)
  public
    type
      InnerProviderProperty = class;
      Arr1InnerProviderProperty = array of InnerProviderProperty;
      Arr2InnerProviderProperty = array of Arr1InnerProviderProperty;
      Arr3InnerProviderProperty = array of Arr2InnerProviderProperty;
      InnerProviderProperty = class external 'java.security' name 'ProviderProperty' 
      end;

  public
    class function getAlgorithmProperty(para1: JLString; para2: JLString): JLString; static; overload;
    class function insertProviderAt(para1: JSProvider; para2: jint): jint; static; overload;
    class function addProvider(para1: JSProvider): jint; static; overload;
    class procedure removeProvider(para1: JLString); static; overload;
    class function getProviders(): Arr1JSProvider; static; overload;
    class function getProvider(para1: JLString): JSProvider; static; overload;
    class function getProviders(para1: JLString): Arr1JSProvider; static; overload;
    class function getProviders(para1: JUMap): Arr1JSProvider; static; overload;
    class function getProperty(para1: JLString): JLString; static; overload;
    class procedure setProperty(para1: JLString; para2: JLString); static; overload;
    class function getAlgorithms(para1: JLString): JUSet; static; overload;
  end;

  JSSignatureSpi = class abstract external 'java.security' name 'SignatureSpi' (JLObject)
  strict protected
    var
      fappRandom: JSSecureRandom; external name 'appRandom';
  public
    constructor create(); overload;
  strict protected
    procedure engineInitVerify(para1: JSPublicKey); overload; virtual; abstract;  // throws java.security.InvalidKeyException
    procedure engineInitSign(para1: JSPrivateKey); overload; virtual; abstract;  // throws java.security.InvalidKeyException
    procedure engineInitSign(para1: JSPrivateKey; para2: JSSecureRandom); overload; virtual;  // throws java.security.InvalidKeyException
    procedure engineUpdate(para1: jbyte); overload; virtual; abstract;  // throws java.security.SignatureException
    procedure engineUpdate(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual; abstract;  // throws java.security.SignatureException
    procedure engineUpdate(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual; abstract;  // throws java.security.SignatureException
    procedure engineUpdate(para1: JNByteBuffer); overload; virtual;
    function engineSign(): Arr1jbyte; overload; virtual; abstract;  // throws java.security.SignatureException
    function engineSign(para1: Arr1jbyte; para2: jint; para3: jint): jint; overload; virtual;  // throws java.security.SignatureException
    function engineSign(var para1: array of jbyte; para2: jint; para3: jint): jint; overload; virtual;  // throws java.security.SignatureException
    function engineVerify(para1: Arr1jbyte): jboolean; overload; virtual; abstract;  // throws java.security.SignatureException
    function engineVerify(var para1: array of jbyte): jboolean; overload; virtual; abstract;  // throws java.security.SignatureException
    function engineVerify(para1: Arr1jbyte; para2: jint; para3: jint): jboolean; overload; virtual;  // throws java.security.SignatureException
    function engineVerify(var para1: array of jbyte; para2: jint; para3: jint): jboolean; overload; virtual;  // throws java.security.SignatureException
    procedure engineSetParameter(para1: JLString; para2: JLObject); overload; virtual; abstract;  // throws java.security.InvalidParameterException
    procedure engineSetParameter(para1: JSSAlgorithmParameterSpec); overload; virtual;  // throws java.security.InvalidAlgorithmParameterException
    function engineGetParameters(): JSAlgorithmParameters; overload; virtual;
    function engineGetParameter(para1: JLString): JLObject; overload; virtual; abstract;  // throws java.security.InvalidParameterException
  public
    function clone(): JLObject; overload; virtual;  // throws java.lang.CloneNotSupportedException
  end;

  JSAOwner = interface external 'java.security.acl' name 'Owner' 
    function addOwner(para1: JSPrincipal; para2: JSPrincipal): jboolean; overload;  // throws java.security.acl.NotOwnerException
    function deleteOwner(para1: JSPrincipal; para2: JSPrincipal): jboolean; overload;  // throws java.security.acl.NotOwnerException, java.security.acl.LastOwnerException
    function isOwner(para1: JSPrincipal): jboolean; overload;
  end;

  JSAPermission = interface external 'java.security.acl' name 'Permission' 
    function equals(para1: JLObject): jboolean; overload;
    function toString(): JLString; overload;
  end;

  JSCCRL = class abstract external 'java.security.cert' name 'CRL' (JLObject)
  strict protected
    constructor create(para1: JLString); overload;
  public
    function getType(): JLString; overload; virtual; final;
    function toString(): JLString; overload; virtual; abstract;
    function isRevoked(para1: JSCCertificate): jboolean; overload; virtual; abstract;
  end;

  JSCCertPathBuilder = class external 'java.security.cert' name 'CertPathBuilder' (JLObject)
  strict protected
    constructor create(para1: JSCCertPathBuilderSpi; para2: JSProvider; para3: JLString); overload;
  public
    class function getInstance(para1: JLString): JSCCertPathBuilder; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JSCCertPathBuilder; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JSCCertPathBuilder; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    function getAlgorithm(): JLString; overload; virtual; final;
    function build(para1: JSCCertPathParameters): JSCCertPathBuilderResult; overload; virtual; final;  // throws java.security.cert.CertPathBuilderException, java.security.InvalidAlgorithmParameterException
    class function getDefaultType(): JLString; static; overload; final;
  end;

  JSCCertPathBuilderSpi = class abstract external 'java.security.cert' name 'CertPathBuilderSpi' (JLObject)
  public
    constructor create(); overload;
    function engineBuild(para1: JSCCertPathParameters): JSCCertPathBuilderResult; overload; virtual; abstract;  // throws java.security.cert.CertPathBuilderException, java.security.InvalidAlgorithmParameterException
  end;

  JSCCertPathValidator = class external 'java.security.cert' name 'CertPathValidator' (JLObject)
  strict protected
    constructor create(para1: JSCCertPathValidatorSpi; para2: JSProvider; para3: JLString); overload;
  public
    class function getInstance(para1: JLString): JSCCertPathValidator; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JSCCertPathValidator; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JSCCertPathValidator; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    function getAlgorithm(): JLString; overload; virtual; final;
    function validate(para1: JSCCertPath; para2: JSCCertPathParameters): JSCCertPathValidatorResult; overload; virtual; final;  // throws java.security.cert.CertPathValidatorException, java.security.InvalidAlgorithmParameterException
    class function getDefaultType(): JLString; static; overload; final;
  end;

  JSCCertPathValidatorSpi = class abstract external 'java.security.cert' name 'CertPathValidatorSpi' (JLObject)
  public
    constructor create(); overload;
    function engineValidate(para1: JSCCertPath; para2: JSCCertPathParameters): JSCCertPathValidatorResult; overload; virtual; abstract;  // throws java.security.cert.CertPathValidatorException, java.security.InvalidAlgorithmParameterException
  end;

  JSCCertStore = class external 'java.security.cert' name 'CertStore' (JLObject)
  strict protected
    constructor create(para1: JSCCertStoreSpi; para2: JSProvider; para3: JLString; para4: JSCCertStoreParameters); overload;
  public
    function getCertificates(para1: JSCCertSelector): JUCollection; overload; virtual; final;  // throws java.security.cert.CertStoreException
    function getCRLs(para1: JSCCRLSelector): JUCollection; overload; virtual; final;  // throws java.security.cert.CertStoreException
    class function getInstance(para1: JLString; para2: JSCCertStoreParameters): JSCCertStore; static; overload;  // throws java.security.InvalidAlgorithmParameterException, java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JSCCertStoreParameters; para3: JLString): JSCCertStore; static; overload;  // throws java.security.InvalidAlgorithmParameterException, java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSCCertStoreParameters; para3: JSProvider): JSCCertStore; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidAlgorithmParameterException
    function getCertStoreParameters(): JSCCertStoreParameters; overload; virtual; final;
    function getType(): JLString; overload; virtual; final;
    function getProvider(): JSProvider; overload; virtual; final;
    class function getDefaultType(): JLString; static; overload; final;
  end;

  JSCCertStoreSpi = class abstract external 'java.security.cert' name 'CertStoreSpi' (JLObject)
  public
    constructor create(para1: JSCCertStoreParameters); overload;  // throws java.security.InvalidAlgorithmParameterException
    function engineGetCertificates(para1: JSCCertSelector): JUCollection; overload; virtual; abstract;  // throws java.security.cert.CertStoreException
    function engineGetCRLs(para1: JSCCRLSelector): JUCollection; overload; virtual; abstract;  // throws java.security.cert.CertStoreException
  end;

  JSCCertificateFactory = class external 'java.security.cert' name 'CertificateFactory' (JLObject)
  strict protected
    constructor create(para1: JSCCertificateFactorySpi; para2: JSProvider; para3: JLString); overload;
  public
    class function getInstance(para1: JLString): JSCCertificateFactory; static; overload; final;  // throws java.security.cert.CertificateException
    class function getInstance(para1: JLString; para2: JLString): JSCCertificateFactory; static; overload; final;  // throws java.security.cert.CertificateException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JSCCertificateFactory; static; overload; final;  // throws java.security.cert.CertificateException
    function getProvider(): JSProvider; overload; virtual; final;
    function getType(): JLString; overload; virtual; final;
    function generateCertificate(para1: JIInputStream): JSCCertificate; overload; virtual; final;  // throws java.security.cert.CertificateException
    function getCertPathEncodings(): JUIterator; overload; virtual; final;
    function generateCertPath(para1: JIInputStream): JSCCertPath; overload; virtual; final;  // throws java.security.cert.CertificateException
    function generateCertPath(para1: JIInputStream; para2: JLString): JSCCertPath; overload; virtual; final;  // throws java.security.cert.CertificateException
    function generateCertPath(para1: JUList): JSCCertPath; overload; virtual; final;  // throws java.security.cert.CertificateException
    function generateCertificates(para1: JIInputStream): JUCollection; overload; virtual; final;  // throws java.security.cert.CertificateException
    function generateCRL(para1: JIInputStream): JSCCRL; overload; virtual; final;  // throws java.security.cert.CRLException
    function generateCRLs(para1: JIInputStream): JUCollection; overload; virtual; final;  // throws java.security.cert.CRLException
  end;

  JSCCertificateFactorySpi = class abstract external 'java.security.cert' name 'CertificateFactorySpi' (JLObject)
  public
    constructor create(); overload;
    function engineGenerateCertificate(para1: JIInputStream): JSCCertificate; overload; virtual; abstract;  // throws java.security.cert.CertificateException
    function engineGenerateCertPath(para1: JIInputStream): JSCCertPath; overload; virtual;  // throws java.security.cert.CertificateException
    function engineGenerateCertPath(para1: JIInputStream; para2: JLString): JSCCertPath; overload; virtual;  // throws java.security.cert.CertificateException
    function engineGenerateCertPath(para1: JUList): JSCCertPath; overload; virtual;  // throws java.security.cert.CertificateException
    function engineGetCertPathEncodings(): JUIterator; overload; virtual;
    function engineGenerateCertificates(para1: JIInputStream): JUCollection; overload; virtual; abstract;  // throws java.security.cert.CertificateException
    function engineGenerateCRL(para1: JIInputStream): JSCCRL; overload; virtual; abstract;  // throws java.security.cert.CRLException
    function engineGenerateCRLs(para1: JIInputStream): JUCollection; overload; virtual; abstract;  // throws java.security.cert.CRLException
  end;

  JSCPolicyNode = interface external 'java.security.cert' name 'PolicyNode' 
    function getParent(): JSCPolicyNode; overload;
    function getChildren(): JUIterator; overload;
    function getDepth(): jint; overload;
    function getValidPolicy(): JLString; overload;
    function getPolicyQualifiers(): JUSet; overload;
    function getExpectedPolicies(): JUSet; overload;
    function isCritical(): jboolean; overload;
  end;

  JSCPolicyQualifierInfo = class external 'java.security.cert' name 'PolicyQualifierInfo' (JLObject)
  public
    constructor create(para1: Arr1jbyte); overload;  // throws java.io.IOException
    constructor create(const para1: array of jbyte); overload;  // throws java.io.IOException
    function getPolicyQualifierId(): JLString; overload; virtual; final;
    function getEncoded(): Arr1jbyte; overload; virtual; final;
    function getPolicyQualifier(): Arr1jbyte; overload; virtual; final;
    function toString(): JLString; overload; virtual;
  end;

  JSCTrustAnchor = class external 'java.security.cert' name 'TrustAnchor' (JLObject)
  public
    constructor create(para1: JSCX509Certificate; para2: Arr1jbyte); overload;
    constructor create(para1: JSCX509Certificate; const para2: array of jbyte); overload;
    constructor create(para1: JSAXX500Principal; para2: JSPublicKey; para3: Arr1jbyte); overload;
    constructor create(para1: JSAXX500Principal; para2: JSPublicKey; const para3: array of jbyte); overload;
    constructor create(para1: JLString; para2: JSPublicKey; para3: Arr1jbyte); overload;
    constructor create(para1: JLString; para2: JSPublicKey; const para3: array of jbyte); overload;
    function getTrustedCert(): JSCX509Certificate; overload; virtual; final;
    function getCA(): JSAXX500Principal; overload; virtual; final;
    function getCAName(): JLString; overload; virtual; final;
    function getCAPublicKey(): JSPublicKey; overload; virtual; final;
    function getNameConstraints(): Arr1jbyte; overload; virtual; final;
    function toString(): JLString; overload; virtual;
  end;

  JSCX509Extension = interface external 'java.security.cert' name 'X509Extension' 
    function hasUnsupportedCriticalExtension(): jboolean; overload;
    function getCriticalExtensionOIDs(): JUSet; overload;
    function getNonCriticalExtensionOIDs(): JUSet; overload;
    function getExtensionValue(para1: JLString): Arr1jbyte; overload;
  end;

  JSIDSAKey = interface external 'java.security.interfaces' name 'DSAKey' 
    function getParams(): JSIDSAParams; overload;
  end;

  JSIDSAKeyPairGenerator = interface external 'java.security.interfaces' name 'DSAKeyPairGenerator' 
    procedure initialize(para1: JSIDSAParams; para2: JSSecureRandom); overload;  // throws java.security.InvalidParameterException
    procedure initialize(para1: jint; para2: jboolean; para3: JSSecureRandom); overload;  // throws java.security.InvalidParameterException
  end;

  JSIDSAParams = interface external 'java.security.interfaces' name 'DSAParams' 
    function getP(): JMBigInteger; overload;
    function getQ(): JMBigInteger; overload;
    function getG(): JMBigInteger; overload;
  end;

  JSIECKey = interface external 'java.security.interfaces' name 'ECKey' 
    function getParams(): JSSECParameterSpec; overload;
  end;

  JSIRSAKey = interface external 'java.security.interfaces' name 'RSAKey' 
    function getModulus(): JMBigInteger; overload;
  end;

  JSSAlgorithmParameterSpec = interface external 'java.security.spec' name 'AlgorithmParameterSpec' 
  end;

  JSSECField = interface external 'java.security.spec' name 'ECField' 
    function getFieldSize(): jint; overload;
  end;

  JSSECPoint = class external 'java.security.spec' name 'ECPoint' (JLObject)
  public
    final class var
      fPOINT_INFINITY: JSSECPoint; external name 'POINT_INFINITY';
  public
    constructor create(para1: JMBigInteger; para2: JMBigInteger); overload;
    function getAffineX(): JMBigInteger; overload; virtual;
    function getAffineY(): JMBigInteger; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  JSSEllipticCurve = class external 'java.security.spec' name 'EllipticCurve' (JLObject)
  public
    constructor create(para1: JSSECField; para2: JMBigInteger; para3: JMBigInteger); overload;
    constructor create(para1: JSSECField; para2: JMBigInteger; para3: JMBigInteger; para4: Arr1jbyte); overload;
    constructor create(para1: JSSECField; para2: JMBigInteger; para3: JMBigInteger; const para4: array of jbyte); overload;
    function getField(): JSSECField; overload; virtual;
    function getA(): JMBigInteger; overload; virtual;
    function getB(): JMBigInteger; overload; virtual;
    function getSeed(): Arr1jbyte; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  JSSKeySpec = interface external 'java.security.spec' name 'KeySpec' 
  end;

  JSSRSAOtherPrimeInfo = class external 'java.security.spec' name 'RSAOtherPrimeInfo' (JLObject)
  public
    constructor create(para1: JMBigInteger; para2: JMBigInteger; para3: JMBigInteger); overload;
    function getPrime(): JMBigInteger; overload; virtual; final;
    function getExponent(): JMBigInteger; overload; virtual; final;
    function getCrtCoefficient(): JMBigInteger; overload; virtual; final;
  end;

  JSArray = interface external 'java.sql' name 'Array' 
    function getBaseTypeName(): JLString; overload;  // throws java.sql.SQLException
    function getBaseType(): jint; overload;  // throws java.sql.SQLException
    function getArray(): JLObject; overload;  // throws java.sql.SQLException
    function getArray(para1: JUMap): JLObject; overload;  // throws java.sql.SQLException
    function getArray(para1: jlong; para2: jint): JLObject; overload;  // throws java.sql.SQLException
    function getArray(para1: jlong; para2: jint; para3: JUMap): JLObject; overload;  // throws java.sql.SQLException
    function getResultSet(): JSResultSet; overload;  // throws java.sql.SQLException
    function getResultSet(para1: JUMap): JSResultSet; overload;  // throws java.sql.SQLException
    function getResultSet(para1: jlong; para2: jint): JSResultSet; overload;  // throws java.sql.SQLException
    function getResultSet(para1: jlong; para2: jint; para3: JUMap): JSResultSet; overload;  // throws java.sql.SQLException
    procedure free(); overload;  // throws java.sql.SQLException
  end;

  JSBlob = interface external 'java.sql' name 'Blob' 
    function length(): jlong; overload;  // throws java.sql.SQLException
    function getBytes(para1: jlong; para2: jint): Arr1jbyte; overload;  // throws java.sql.SQLException
    function getBinaryStream(): JIInputStream; overload;  // throws java.sql.SQLException
    function position(para1: Arr1jbyte; para2: jlong): jlong; overload;  // throws java.sql.SQLException
    function position(var para1: array of jbyte; para2: jlong): jlong; overload;  // throws java.sql.SQLException
    function position(para1: JSBlob; para2: jlong): jlong; overload;  // throws java.sql.SQLException
    function setBytes(para1: jlong; para2: Arr1jbyte): jint; overload;  // throws java.sql.SQLException
    function setBytes(para1: jlong; var para2: array of jbyte): jint; overload;  // throws java.sql.SQLException
    function setBytes(para1: jlong; para2: Arr1jbyte; para3: jint; para4: jint): jint; overload;  // throws java.sql.SQLException
    function setBytes(para1: jlong; var para2: array of jbyte; para3: jint; para4: jint): jint; overload;  // throws java.sql.SQLException
    function setBinaryStream(para1: jlong): JIOutputStream; overload;  // throws java.sql.SQLException
    procedure truncate(para1: jlong); overload;  // throws java.sql.SQLException
    procedure free(); overload;  // throws java.sql.SQLException
    function getBinaryStream(para1: jlong; para2: jlong): JIInputStream; overload;  // throws java.sql.SQLException
  end;

  JSClob = interface external 'java.sql' name 'Clob' 
    function length(): jlong; overload;  // throws java.sql.SQLException
    function getSubString(para1: jlong; para2: jint): JLString; overload;  // throws java.sql.SQLException
    function getCharacterStream(): JIReader; overload;  // throws java.sql.SQLException
    function getAsciiStream(): JIInputStream; overload;  // throws java.sql.SQLException
    function position(para1: JLString; para2: jlong): jlong; overload;  // throws java.sql.SQLException
    function position(para1: JSClob; para2: jlong): jlong; overload;  // throws java.sql.SQLException
    function setString(para1: jlong; para2: JLString): jint; overload;  // throws java.sql.SQLException
    function setString(para1: jlong; para2: JLString; para3: jint; para4: jint): jint; overload;  // throws java.sql.SQLException
    function setAsciiStream(para1: jlong): JIOutputStream; overload;  // throws java.sql.SQLException
    function setCharacterStream(para1: jlong): JIWriter; overload;  // throws java.sql.SQLException
    procedure truncate(para1: jlong); overload;  // throws java.sql.SQLException
    procedure free(); overload;  // throws java.sql.SQLException
    function getCharacterStream(para1: jlong; para2: jlong): JIReader; overload;  // throws java.sql.SQLException
  end;

  JSDriver = interface external 'java.sql' name 'Driver' 
    function connect(para1: JLString; para2: JUProperties): JSConnection; overload;  // throws java.sql.SQLException
    function acceptsURL(para1: JLString): jboolean; overload;  // throws java.sql.SQLException
    function getPropertyInfo(para1: JLString; para2: JUProperties): Arr1JSDriverPropertyInfo; overload;  // throws java.sql.SQLException
    function getMajorVersion(): jint; overload;
    function getMinorVersion(): jint; overload;
    function jdbcCompliant(): jboolean; overload;
  end;

  JSDriverInfo = class external 'java.sql' name 'DriverInfo' (JLObject)
  public
    function toString(): JLString; overload; virtual;
  end;

  JSDriverManager = class external 'java.sql' name 'DriverManager' (JLObject)
  public
    class function getLogWriter(): JIPrintWriter; static; overload;
    class procedure setLogWriter(para1: JIPrintWriter); static; overload;
    class function getConnection(para1: JLString; para2: JUProperties): JSConnection; static; overload;  // throws java.sql.SQLException
    class function getConnection(para1: JLString; para2: JLString; para3: JLString): JSConnection; static; overload;  // throws java.sql.SQLException
    class function getConnection(para1: JLString): JSConnection; static; overload;  // throws java.sql.SQLException
    class function getDriver(para1: JLString): JSDriver; static; overload;  // throws java.sql.SQLException
    class procedure registerDriver(para1: JSDriver); static; overload;  // throws java.sql.SQLException
    class procedure deregisterDriver(para1: JSDriver); static; overload;  // throws java.sql.SQLException
    class function getDrivers(): JUEnumeration; static; overload;
    class procedure setLoginTimeout(para1: jint); static; overload;
    class function getLoginTimeout(): jint; static; overload;
    class procedure setLogStream(para1: JIPrintStream); static; overload;
    class function getLogStream(): JIPrintStream; static; overload;
    class procedure println(para1: JLString); static; overload;
  end;

  JSDriverPropertyInfo = class external 'java.sql' name 'DriverPropertyInfo' (JLObject)
  public
    var
      fname: JLString; external name 'name';
      fdescription: JLString; external name 'description';
      frequired: jboolean; external name 'required';
      fvalue: JLString; external name 'value';
      fchoices: Arr1JLString; external name 'choices';
  public
    constructor create(para1: JLString; para2: JLString); overload;
  end;

  JSRef = interface external 'java.sql' name 'Ref' 
    function getBaseTypeName(): JLString; overload;  // throws java.sql.SQLException
    function getObject(para1: JUMap): JLObject; overload;  // throws java.sql.SQLException
    function getObject(): JLObject; overload;  // throws java.sql.SQLException
    procedure setObject(para1: JLObject); overload;  // throws java.sql.SQLException
  end;

  JSRowId = interface external 'java.sql' name 'RowId' 
    function equals(para1: JLObject): jboolean; overload;
    function getBytes(): Arr1jbyte; overload;
    function toString(): JLString; overload;
    function hashCode(): jint; overload;
  end;

  JSSQLData = interface external 'java.sql' name 'SQLData' 
    function getSQLTypeName(): JLString; overload;  // throws java.sql.SQLException
    procedure readSQL(para1: JSSQLInput; para2: JLString); overload;  // throws java.sql.SQLException
    procedure writeSQL(para1: JSSQLOutput); overload;  // throws java.sql.SQLException
  end;

  JSSQLInput = interface external 'java.sql' name 'SQLInput' 
    function readString(): JLString; overload;  // throws java.sql.SQLException
    function readBoolean(): jboolean; overload;  // throws java.sql.SQLException
    function readByte(): jbyte; overload;  // throws java.sql.SQLException
    function readShort(): jshort; overload;  // throws java.sql.SQLException
    function readInt(): jint; overload;  // throws java.sql.SQLException
    function readLong(): jlong; overload;  // throws java.sql.SQLException
    function readFloat(): jfloat; overload;  // throws java.sql.SQLException
    function readDouble(): jdouble; overload;  // throws java.sql.SQLException
    function readBigDecimal(): JMBigDecimal; overload;  // throws java.sql.SQLException
    function readBytes(): Arr1jbyte; overload;  // throws java.sql.SQLException
    function readDate(): JSDate; overload;  // throws java.sql.SQLException
    function readTime(): JSTime; overload;  // throws java.sql.SQLException
    function readTimestamp(): JSqlTimestamp; overload;  // throws java.sql.SQLException
    function readCharacterStream(): JIReader; overload;  // throws java.sql.SQLException
    function readAsciiStream(): JIInputStream; overload;  // throws java.sql.SQLException
    function readBinaryStream(): JIInputStream; overload;  // throws java.sql.SQLException
    function readObject(): JLObject; overload;  // throws java.sql.SQLException
    function readRef(): JSRef; overload;  // throws java.sql.SQLException
    function readBlob(): JSBlob; overload;  // throws java.sql.SQLException
    function readClob(): JSClob; overload;  // throws java.sql.SQLException
    function readArray(): JSArray; overload;  // throws java.sql.SQLException
    function wasNull(): jboolean; overload;  // throws java.sql.SQLException
    function readURL(): JNURL; overload;  // throws java.sql.SQLException
    function readNClob(): JSNClob; overload;  // throws java.sql.SQLException
    function readNString(): JLString; overload;  // throws java.sql.SQLException
    function readSQLXML(): JSSQLXML; overload;  // throws java.sql.SQLException
    function readRowId(): JSRowId; overload;  // throws java.sql.SQLException
  end;

  JSSQLOutput = interface external 'java.sql' name 'SQLOutput' 
    procedure writeString(para1: JLString); overload;  // throws java.sql.SQLException
    procedure writeBoolean(para1: jboolean); overload;  // throws java.sql.SQLException
    procedure writeByte(para1: jbyte); overload;  // throws java.sql.SQLException
    procedure writeShort(para1: jshort); overload;  // throws java.sql.SQLException
    procedure writeInt(para1: jint); overload;  // throws java.sql.SQLException
    procedure writeLong(para1: jlong); overload;  // throws java.sql.SQLException
    procedure writeFloat(para1: jfloat); overload;  // throws java.sql.SQLException
    procedure writeDouble(para1: jdouble); overload;  // throws java.sql.SQLException
    procedure writeBigDecimal(para1: JMBigDecimal); overload;  // throws java.sql.SQLException
    procedure writeBytes(para1: Arr1jbyte); overload;  // throws java.sql.SQLException
    procedure writeBytes(var para1: array of jbyte); overload;  // throws java.sql.SQLException
    procedure writeDate(para1: JSDate); overload;  // throws java.sql.SQLException
    procedure writeTime(para1: JSTime); overload;  // throws java.sql.SQLException
    procedure writeTimestamp(para1: JSqlTimestamp); overload;  // throws java.sql.SQLException
    procedure writeCharacterStream(para1: JIReader); overload;  // throws java.sql.SQLException
    procedure writeAsciiStream(para1: JIInputStream); overload;  // throws java.sql.SQLException
    procedure writeBinaryStream(para1: JIInputStream); overload;  // throws java.sql.SQLException
    procedure writeObject(para1: JSSQLData); overload;  // throws java.sql.SQLException
    procedure writeRef(para1: JSRef); overload;  // throws java.sql.SQLException
    procedure writeBlob(para1: JSBlob); overload;  // throws java.sql.SQLException
    procedure writeClob(para1: JSClob); overload;  // throws java.sql.SQLException
    procedure writeStruct(para1: JSStruct); overload;  // throws java.sql.SQLException
    procedure writeArray(para1: JSArray); overload;  // throws java.sql.SQLException
    procedure writeURL(para1: JNURL); overload;  // throws java.sql.SQLException
    procedure writeNString(para1: JLString); overload;  // throws java.sql.SQLException
    procedure writeNClob(para1: JSNClob); overload;  // throws java.sql.SQLException
    procedure writeRowId(para1: JSRowId); overload;  // throws java.sql.SQLException
    procedure writeSQLXML(para1: JSSQLXML); overload;  // throws java.sql.SQLException
  end;

  JSSQLXML = interface external 'java.sql' name 'SQLXML' 
    procedure free(); overload;  // throws java.sql.SQLException
    function getBinaryStream(): JIInputStream; overload;  // throws java.sql.SQLException
    function setBinaryStream(): JIOutputStream; overload;  // throws java.sql.SQLException
    function getCharacterStream(): JIReader; overload;  // throws java.sql.SQLException
    function setCharacterStream(): JIWriter; overload;  // throws java.sql.SQLException
    function getString(): JLString; overload;  // throws java.sql.SQLException
    procedure setString(para1: JLString); overload;  // throws java.sql.SQLException
    function getSource(para1: JLClass): JXTSource; overload;  // throws java.sql.SQLException
    function setResult(para1: JLClass): JXTResult; overload;  // throws java.sql.SQLException
  end;

  JSSavepoint = interface external 'java.sql' name 'Savepoint' 
    function getSavepointId(): jint; overload;  // throws java.sql.SQLException
    function getSavepointName(): JLString; overload;  // throws java.sql.SQLException
  end;

  JSStruct = interface external 'java.sql' name 'Struct' 
    function getSQLTypeName(): JLString; overload;  // throws java.sql.SQLException
    function getAttributes(): Arr1JLObject; overload;  // throws java.sql.SQLException
    function getAttributes(para1: JUMap): Arr1JLObject; overload;  // throws java.sql.SQLException
  end;

  JSTypes = class external 'java.sql' name 'Types' (JLObject)
  public
    const
      BIT = -7;
      TINYINT = -6;
      SMALLINT = 5;
      INTEGER = 4;
      BIGINT = -5;
      FLOAT = 6;
      REAL = 7;
      DOUBLE = 8;
      NUMERIC = 2;
      DECIMAL = 3;
      CHAR = 1;
      VARCHAR = 12;
      LONGVARCHAR = -1;
      DATE = 91;
      TIME = 92;
      TIMESTAMP = 93;
      BINARY = -2;
      VARBINARY = -3;
      LONGVARBINARY = -4;
      NULL = 0;
      OTHER = 1111;
      JAVA_OBJECT = 2000;
      DISTINCT = 2001;
      STRUCT = 2002;
      &ARRAY = 2003;
      BLOB = 2004;
      CLOB = 2005;
      REF = 2006;
      DATALINK = 70;
      BOOLEAN = 16;
      ROWID = -8;
      NCHAR = -15;
      NVARCHAR = -9;
      LONGNVARCHAR = -16;
      NCLOB = 2011;
      SQLXML = 2009;
  end;

  JSWrapper = interface external 'java.sql' name 'Wrapper' 
    function unwrap(para1: JLClass): JLObject; overload;  // throws java.sql.SQLException
    function isWrapperFor(para1: JLClass): jboolean; overload;  // throws java.sql.SQLException
  end;

  JTAnnotation = class external 'java.text' name 'Annotation' (JLObject)
  public
    constructor create(para1: JLObject); overload;
    function getValue(): JLObject; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JTBidi = class sealed external 'java.text' name 'Bidi' (JLObject)
  public
    const
      DIRECTION_LEFT_TO_RIGHT = 0;
      DIRECTION_RIGHT_TO_LEFT = 1;
      DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
      DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
  public
    constructor create(para1: JLString; para2: jint); overload;
    constructor create(para1: JTAttributedCharacterIterator); overload;
    constructor create(para1: Arr1jchar; para2: jint; para3: Arr1jbyte; para4: jint; para5: jint; para6: jint); overload;
    constructor create(const para1: array of jchar; para2: jint; const para3: array of jbyte; para4: jint; para5: jint; para6: jint); overload;
    function createLineBidi(para1: jint; para2: jint): JTBidi; overload; virtual;
    function isMixed(): jboolean; overload; virtual;
    function isLeftToRight(): jboolean; overload; virtual;
    function isRightToLeft(): jboolean; overload; virtual;
    function getLength(): jint; overload; virtual;
    function baseIsLeftToRight(): jboolean; overload; virtual;
    function getBaseLevel(): jint; overload; virtual;
    function getLevelAt(para1: jint): jint; overload; virtual;
    function getRunCount(): jint; overload; virtual;
    function getRunLevel(para1: jint): jint; overload; virtual;
    function getRunStart(para1: jint): jint; overload; virtual;
    function getRunLimit(para1: jint): jint; overload; virtual;
    class function requiresBidi(para1: Arr1jchar; para2: jint; para3: jint): jboolean; static; overload;
    class function requiresBidi(var para1: array of jchar; para2: jint; para3: jint): jboolean; static; overload;
    class procedure reorderVisually(para1: Arr1jbyte; para2: jint; para3: Arr1JLObject; para4: jint; para5: jint); static; overload;
    class procedure reorderVisually(var para1: array of jbyte; para2: jint; var para3: array of JLObject; para4: jint; para5: jint); static; overload;
    function toString(): JLString; overload; virtual;
  end;

  JTBreakDictionary = class external 'java.text' name 'BreakDictionary' (JLObject)
  public
    constructor create(para1: JLString); overload;  // throws java.io.IOException, java.util.MissingResourceException
    function getNextStateFromCharacter(para1: jint; para2: jint): jshort; overload; virtual; final;
    function getNextState(para1: jint; para2: jint): jshort; overload; virtual; final;
  end;

  JTCollationElementIterator = class sealed external 'java.text' name 'CollationElementIterator' (JLObject)
  public
    const
      NULLORDER = -1;
  public
    procedure reset(); overload; virtual;
    function next(): jint; overload; virtual;
    function previous(): jint; overload; virtual;
    class function primaryOrder(para1: jint): jint; static; overload; final;
    class function secondaryOrder(para1: jint): jshort; static; overload; final;
    class function tertiaryOrder(para1: jint): jshort; static; overload; final;
    procedure setOffset(para1: jint); overload; virtual;
    function getOffset(): jint; overload; virtual;
    function getMaxExpansion(para1: jint): jint; overload; virtual;
    procedure setText(para1: JLString); overload; virtual;
    procedure setText(para1: JTCharacterIterator); overload; virtual;
  end;

  JTCollationRules = class sealed external 'java.text' name 'CollationRules' (JLObject)
  end;

  JTEntryPair = class sealed external 'java.text' name 'EntryPair' (JLObject)
  public
    var
      fentryName: JLString; external name 'entryName';
      fvalue: jint; external name 'value';
      ffwd: jboolean; external name 'fwd';
  public
    constructor create(para1: JLString; para2: jint); overload;
    constructor create(para1: JLString; para2: jint; para3: jboolean); overload;
  end;

  JTMergeCollation = class sealed external 'java.text' name 'MergeCollation' (JLObject)
  public
    constructor create(para1: JLString); overload;  // throws java.text.ParseException
    function getPattern(): JLString; overload; virtual;
    function getPattern(para1: jboolean): JLString; overload; virtual;
    function emitPattern(): JLString; overload; virtual;
    function emitPattern(para1: jboolean): JLString; overload; virtual;
    procedure setPattern(para1: JLString); overload; virtual;  // throws java.text.ParseException
    procedure addPattern(para1: JLString); overload; virtual;  // throws java.text.ParseException
    function getCount(): jint; overload; virtual;
    function getItemAt(para1: jint): JTPatternEntry; overload; virtual;
  end;

  JTParsePosition = class external 'java.text' name 'ParsePosition' (JLObject)
  public
    function getIndex(): jint; overload; virtual;
    procedure setIndex(para1: jint); overload; virtual;
    constructor create(para1: jint); overload;
    procedure setErrorIndex(para1: jint); overload; virtual;
    function getErrorIndex(): jint; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JTPatternEntry = class external 'java.text' name 'PatternEntry' (JLObject)
  public
    type
      InnerParser = class;
      Arr1InnerParser = array of InnerParser;
      Arr2InnerParser = array of Arr1InnerParser;
      Arr3InnerParser = array of Arr2InnerParser;
      InnerParser = class external 'java.text' name 'Parser' 
      end;

  public
    procedure appendQuotedExtension(para1: JLStringBuffer); overload; virtual;
    procedure appendQuotedChars(para1: JLStringBuffer); overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JTRBCollationTables = class sealed external 'java.text' name 'RBCollationTables' (JLObject)
  public
    type
      InnerBuildAPI = class;
      Arr1InnerBuildAPI = array of InnerBuildAPI;
      Arr2InnerBuildAPI = array of Arr1InnerBuildAPI;
      Arr3InnerBuildAPI = array of Arr2InnerBuildAPI;
      InnerBuildAPI = class sealed external 'java.text' name 'BuildAPI' 
      end;

  public
    constructor create(para1: JLString; para2: jint); overload;  // throws java.text.ParseException
    function getRules(): JLString; overload; virtual;
    function isFrenchSec(): jboolean; overload; virtual;
    function isSEAsianSwapping(): jboolean; overload; virtual;
  end;

  JUCollections = class external 'java.util' name 'Collections' (JLObject)
  public
    type
      InnerAsLIFOQueue = class;
      Arr1InnerAsLIFOQueue = array of InnerAsLIFOQueue;
      Arr2InnerAsLIFOQueue = array of Arr1InnerAsLIFOQueue;
      Arr3InnerAsLIFOQueue = array of Arr2InnerAsLIFOQueue;
      InnerCheckedCollection = class;
      Arr1InnerCheckedCollection = array of InnerCheckedCollection;
      Arr2InnerCheckedCollection = array of Arr1InnerCheckedCollection;
      Arr3InnerCheckedCollection = array of Arr2InnerCheckedCollection;
      InnerSynchronizedCollection = class;
      Arr1InnerSynchronizedCollection = array of InnerSynchronizedCollection;
      Arr2InnerSynchronizedCollection = array of Arr1InnerSynchronizedCollection;
      Arr3InnerSynchronizedCollection = array of Arr2InnerSynchronizedCollection;
      InnerUnmodifiableCollection = class;
      Arr1InnerUnmodifiableCollection = array of InnerUnmodifiableCollection;
      Arr2InnerUnmodifiableCollection = array of Arr1InnerUnmodifiableCollection;
      Arr3InnerUnmodifiableCollection = array of Arr2InnerUnmodifiableCollection;
      InnerCheckedList = class;
      Arr1InnerCheckedList = array of InnerCheckedList;
      Arr2InnerCheckedList = array of Arr1InnerCheckedList;
      Arr3InnerCheckedList = array of Arr2InnerCheckedList;
      InnerSynchronizedList = class;
      Arr1InnerSynchronizedList = array of InnerSynchronizedList;
      Arr2InnerSynchronizedList = array of Arr1InnerSynchronizedList;
      Arr3InnerSynchronizedList = array of Arr2InnerSynchronizedList;
      InnerUnmodifiableList = class;
      Arr1InnerUnmodifiableList = array of InnerUnmodifiableList;
      Arr2InnerUnmodifiableList = array of Arr1InnerUnmodifiableList;
      Arr3InnerUnmodifiableList = array of Arr2InnerUnmodifiableList;
      InnerCheckedMap = class;
      Arr1InnerCheckedMap = array of InnerCheckedMap;
      Arr2InnerCheckedMap = array of Arr1InnerCheckedMap;
      Arr3InnerCheckedMap = array of Arr2InnerCheckedMap;
      InnerSynchronizedMap = class;
      Arr1InnerSynchronizedMap = array of InnerSynchronizedMap;
      Arr2InnerSynchronizedMap = array of Arr1InnerSynchronizedMap;
      Arr3InnerSynchronizedMap = array of Arr2InnerSynchronizedMap;
      InnerUnmodifiableMap = class;
      Arr1InnerUnmodifiableMap = array of InnerUnmodifiableMap;
      Arr2InnerUnmodifiableMap = array of Arr1InnerUnmodifiableMap;
      Arr3InnerUnmodifiableMap = array of Arr2InnerUnmodifiableMap;
      InnerCheckedRandomAccessList = class;
      Arr1InnerCheckedRandomAccessList = array of InnerCheckedRandomAccessList;
      Arr2InnerCheckedRandomAccessList = array of Arr1InnerCheckedRandomAccessList;
      Arr3InnerCheckedRandomAccessList = array of Arr2InnerCheckedRandomAccessList;
      InnerSynchronizedRandomAccessList = class;
      Arr1InnerSynchronizedRandomAccessList = array of InnerSynchronizedRandomAccessList;
      Arr2InnerSynchronizedRandomAccessList = array of Arr1InnerSynchronizedRandomAccessList;
      Arr3InnerSynchronizedRandomAccessList = array of Arr2InnerSynchronizedRandomAccessList;
      InnerUnmodifiableRandomAccessList = class;
      Arr1InnerUnmodifiableRandomAccessList = array of InnerUnmodifiableRandomAccessList;
      Arr2InnerUnmodifiableRandomAccessList = array of Arr1InnerUnmodifiableRandomAccessList;
      Arr3InnerUnmodifiableRandomAccessList = array of Arr2InnerUnmodifiableRandomAccessList;
      InnerCheckedSet = class;
      Arr1InnerCheckedSet = array of InnerCheckedSet;
      Arr2InnerCheckedSet = array of Arr1InnerCheckedSet;
      Arr3InnerCheckedSet = array of Arr2InnerCheckedSet;
      InnerSynchronizedSet = class;
      Arr1InnerSynchronizedSet = array of InnerSynchronizedSet;
      Arr2InnerSynchronizedSet = array of Arr1InnerSynchronizedSet;
      Arr3InnerSynchronizedSet = array of Arr2InnerSynchronizedSet;
      InnerUnmodifiableSet = class;
      Arr1InnerUnmodifiableSet = array of InnerUnmodifiableSet;
      Arr2InnerUnmodifiableSet = array of Arr1InnerUnmodifiableSet;
      Arr3InnerUnmodifiableSet = array of Arr2InnerUnmodifiableSet;
      InnerCheckedSortedMap = class;
      Arr1InnerCheckedSortedMap = array of InnerCheckedSortedMap;
      Arr2InnerCheckedSortedMap = array of Arr1InnerCheckedSortedMap;
      Arr3InnerCheckedSortedMap = array of Arr2InnerCheckedSortedMap;
      InnerSynchronizedSortedMap = class;
      Arr1InnerSynchronizedSortedMap = array of InnerSynchronizedSortedMap;
      Arr2InnerSynchronizedSortedMap = array of Arr1InnerSynchronizedSortedMap;
      Arr3InnerSynchronizedSortedMap = array of Arr2InnerSynchronizedSortedMap;
      InnerUnmodifiableSortedMap = class;
      Arr1InnerUnmodifiableSortedMap = array of InnerUnmodifiableSortedMap;
      Arr2InnerUnmodifiableSortedMap = array of Arr1InnerUnmodifiableSortedMap;
      Arr3InnerUnmodifiableSortedMap = array of Arr2InnerUnmodifiableSortedMap;
      InnerCheckedSortedSet = class;
      Arr1InnerCheckedSortedSet = array of InnerCheckedSortedSet;
      Arr2InnerCheckedSortedSet = array of Arr1InnerCheckedSortedSet;
      Arr3InnerCheckedSortedSet = array of Arr2InnerCheckedSortedSet;
      InnerSynchronizedSortedSet = class;
      Arr1InnerSynchronizedSortedSet = array of InnerSynchronizedSortedSet;
      Arr2InnerSynchronizedSortedSet = array of Arr1InnerSynchronizedSortedSet;
      Arr3InnerSynchronizedSortedSet = array of Arr2InnerSynchronizedSortedSet;
      InnerUnmodifiableSortedSet = class;
      Arr1InnerUnmodifiableSortedSet = array of InnerUnmodifiableSortedSet;
      Arr2InnerUnmodifiableSortedSet = array of Arr1InnerUnmodifiableSortedSet;
      Arr3InnerUnmodifiableSortedSet = array of Arr2InnerUnmodifiableSortedSet;
      InnerCopiesList = class;
      Arr1InnerCopiesList = array of InnerCopiesList;
      Arr2InnerCopiesList = array of Arr1InnerCopiesList;
      Arr3InnerCopiesList = array of Arr2InnerCopiesList;
      InnerEmptyList = class;
      Arr1InnerEmptyList = array of InnerEmptyList;
      Arr2InnerEmptyList = array of Arr1InnerEmptyList;
      Arr3InnerEmptyList = array of Arr2InnerEmptyList;
      InnerSingletonList = class;
      Arr1InnerSingletonList = array of InnerSingletonList;
      Arr2InnerSingletonList = array of Arr1InnerSingletonList;
      Arr3InnerSingletonList = array of Arr2InnerSingletonList;
      InnerEmptyMap = class;
      Arr1InnerEmptyMap = array of InnerEmptyMap;
      Arr2InnerEmptyMap = array of Arr1InnerEmptyMap;
      Arr3InnerEmptyMap = array of Arr2InnerEmptyMap;
      InnerSingletonMap = class;
      Arr1InnerSingletonMap = array of InnerSingletonMap;
      Arr2InnerSingletonMap = array of Arr1InnerSingletonMap;
      Arr3InnerSingletonMap = array of Arr2InnerSingletonMap;
      InnerEmptySet = class;
      Arr1InnerEmptySet = array of InnerEmptySet;
      Arr2InnerEmptySet = array of Arr1InnerEmptySet;
      Arr3InnerEmptySet = array of Arr2InnerEmptySet;
      InnerSetFromMap = class;
      Arr1InnerSetFromMap = array of InnerSetFromMap;
      Arr2InnerSetFromMap = array of Arr1InnerSetFromMap;
      Arr3InnerSetFromMap = array of Arr2InnerSetFromMap;
      InnerSingletonSet = class;
      Arr1InnerSingletonSet = array of InnerSingletonSet;
      Arr2InnerSingletonSet = array of Arr1InnerSingletonSet;
      Arr3InnerSingletonSet = array of Arr2InnerSingletonSet;
      InnerReverseComparator = class;
      Arr1InnerReverseComparator = array of InnerReverseComparator;
      Arr2InnerReverseComparator = array of Arr1InnerReverseComparator;
      Arr3InnerReverseComparator = array of Arr2InnerReverseComparator;
      InnerReverseComparator2 = class;
      Arr1InnerReverseComparator2 = array of InnerReverseComparator2;
      Arr2InnerReverseComparator2 = array of Arr1InnerReverseComparator2;
      Arr3InnerReverseComparator2 = array of Arr2InnerReverseComparator2;
      InnerSelfComparable = interface;
      Arr1InnerSelfComparable = array of InnerSelfComparable;
      Arr2InnerSelfComparable = array of Arr1InnerSelfComparable;
      Arr3InnerSelfComparable = array of Arr2InnerSelfComparable;
      InnerAsLIFOQueue = class external 'java.util' name 'AsLIFOQueue' 
      end;

      InnerCheckedCollection = class external 'java.util' name 'CheckedCollection' 
      end;

      InnerSynchronizedCollection = class external 'java.util' name 'SynchronizedCollection' 
      end;

      InnerUnmodifiableCollection = class external 'java.util' name 'UnmodifiableCollection' 
      end;

      InnerCheckedList = class external 'java.util' name 'CheckedList' 
      end;

      InnerSynchronizedList = class external 'java.util' name 'SynchronizedList' 
      end;

      InnerUnmodifiableList = class external 'java.util' name 'UnmodifiableList' 
      end;

      InnerCheckedMap = class external 'java.util' name 'CheckedMap' 
      public
        type
          InnerCheckedEntrySet = class;
          Arr1InnerCheckedEntrySet = array of InnerCheckedEntrySet;
          Arr2InnerCheckedEntrySet = array of Arr1InnerCheckedEntrySet;
          Arr3InnerCheckedEntrySet = array of Arr2InnerCheckedEntrySet;
          InnerCheckedEntrySet = class external 'java.util' name 'CheckedEntrySet' 
          public
            type
              InnerCheckedEntry = class;
              Arr1InnerCheckedEntry = array of InnerCheckedEntry;
              Arr2InnerCheckedEntry = array of Arr1InnerCheckedEntry;
              Arr3InnerCheckedEntry = array of Arr2InnerCheckedEntry;
              InnerCheckedEntry = class external 'java.util' name 'CheckedEntry' 
              end;

          end;

      end;

      InnerSynchronizedMap = class external 'java.util' name 'SynchronizedMap' 
      end;

      InnerUnmodifiableMap = class external 'java.util' name 'UnmodifiableMap' 
      public
        type
          InnerUnmodifiableEntrySet = class;
          Arr1InnerUnmodifiableEntrySet = array of InnerUnmodifiableEntrySet;
          Arr2InnerUnmodifiableEntrySet = array of Arr1InnerUnmodifiableEntrySet;
          Arr3InnerUnmodifiableEntrySet = array of Arr2InnerUnmodifiableEntrySet;
          InnerUnmodifiableEntrySet = class external 'java.util' name 'UnmodifiableEntrySet' 
          public
            type
              InnerUnmodifiableEntry = class;
              Arr1InnerUnmodifiableEntry = array of InnerUnmodifiableEntry;
              Arr2InnerUnmodifiableEntry = array of Arr1InnerUnmodifiableEntry;
              Arr3InnerUnmodifiableEntry = array of Arr2InnerUnmodifiableEntry;
              InnerUnmodifiableEntry = class external 'java.util' name 'UnmodifiableEntry' 
              end;

          end;

      end;

      InnerCheckedRandomAccessList = class external 'java.util' name 'CheckedRandomAccessList' 
      end;

      InnerSynchronizedRandomAccessList = class external 'java.util' name 'SynchronizedRandomAccessList' 
      end;

      InnerUnmodifiableRandomAccessList = class external 'java.util' name 'UnmodifiableRandomAccessList' 
      end;

      InnerCheckedSet = class external 'java.util' name 'CheckedSet' 
      end;

      InnerSynchronizedSet = class external 'java.util' name 'SynchronizedSet' 
      end;

      InnerUnmodifiableSet = class external 'java.util' name 'UnmodifiableSet' 
      end;

      InnerCheckedSortedMap = class external 'java.util' name 'CheckedSortedMap' 
      end;

      InnerSynchronizedSortedMap = class external 'java.util' name 'SynchronizedSortedMap' 
      end;

      InnerUnmodifiableSortedMap = class external 'java.util' name 'UnmodifiableSortedMap' 
      end;

      InnerCheckedSortedSet = class external 'java.util' name 'CheckedSortedSet' 
      end;

      InnerSynchronizedSortedSet = class external 'java.util' name 'SynchronizedSortedSet' 
      end;

      InnerUnmodifiableSortedSet = class external 'java.util' name 'UnmodifiableSortedSet' 
      end;

      InnerCopiesList = class external 'java.util' name 'CopiesList' 
      end;

      InnerEmptyList = class external 'java.util' name 'EmptyList' 
      end;

      InnerSingletonList = class external 'java.util' name 'SingletonList' 
      end;

      InnerEmptyMap = class external 'java.util' name 'EmptyMap' 
      end;

      InnerSingletonMap = class external 'java.util' name 'SingletonMap' 
      end;

      InnerEmptySet = class external 'java.util' name 'EmptySet' 
      end;

      InnerSetFromMap = class external 'java.util' name 'SetFromMap' 
      end;

      InnerSingletonSet = class external 'java.util' name 'SingletonSet' 
      end;

      InnerReverseComparator = class external 'java.util' name 'ReverseComparator' 
      end;

      InnerReverseComparator2 = class external 'java.util' name 'ReverseComparator2' 
      end;

      InnerSelfComparable = interface external 'java.util' name 'SelfComparable' 
      end;

  public
    final class var
      fEMPTY_SET: JUSet; external name 'EMPTY_SET';
      fEMPTY_LIST: JUList; external name 'EMPTY_LIST';
      fEMPTY_MAP: JUMap; external name 'EMPTY_MAP';
  public
    class procedure sort(para1: JUList); static; overload;
    class procedure sort(para1: JUList; para2: JUComparator); static; overload;
    class function binarySearch(para1: JUList; para2: JLObject): jint; static; overload;
    class function binarySearch(para1: JUList; para2: JLObject; para3: JUComparator): jint; static; overload;
    class procedure reverse(para1: JUList); static; overload;
    class procedure shuffle(para1: JUList); static; overload;
    class procedure shuffle(para1: JUList; para2: JURandom); static; overload;
    class procedure swap(para1: JUList; para2: jint; para3: jint); static; overload;
    class procedure fill(para1: JUList; para2: JLObject); static; overload;
    class procedure copy(para1: JUList; para2: JUList); static; overload;
    class function min(para1: JUCollection): JLObject; static; overload;
    class function min(para1: JUCollection; para2: JUComparator): JLObject; static; overload;
    class function max(para1: JUCollection): JLObject; static; overload;
    class function max(para1: JUCollection; para2: JUComparator): JLObject; static; overload;
    class procedure rotate(para1: JUList; para2: jint); static; overload;
    class function replaceAll(para1: JUList; para2: JLObject; para3: JLObject): jboolean; static; overload;
    class function indexOfSubList(para1: JUList; para2: JUList): jint; static; overload;
    class function lastIndexOfSubList(para1: JUList; para2: JUList): jint; static; overload;
    class function unmodifiableCollection(para1: JUCollection): JUCollection; static; overload;
    class function unmodifiableSet(para1: JUSet): JUSet; static; overload;
    class function unmodifiableSortedSet(para1: JUSortedSet): JUSortedSet; static; overload;
    class function unmodifiableList(para1: JUList): JUList; static; overload;
    class function unmodifiableMap(para1: JUMap): JUMap; static; overload;
    class function unmodifiableSortedMap(para1: JUSortedMap): JUSortedMap; static; overload;
    class function synchronizedCollection(para1: JUCollection): JUCollection; static; overload;
    class function synchronizedSet(para1: JUSet): JUSet; static; overload;
    class function synchronizedSortedSet(para1: JUSortedSet): JUSortedSet; static; overload;
    class function synchronizedList(para1: JUList): JUList; static; overload;
    class function synchronizedMap(para1: JUMap): JUMap; static; overload;
    class function synchronizedSortedMap(para1: JUSortedMap): JUSortedMap; static; overload;
    class function checkedCollection(para1: JUCollection; para2: JLClass): JUCollection; static; overload;
    class function checkedSet(para1: JUSet; para2: JLClass): JUSet; static; overload;
    class function checkedSortedSet(para1: JUSortedSet; para2: JLClass): JUSortedSet; static; overload;
    class function checkedList(para1: JUList; para2: JLClass): JUList; static; overload;
    class function checkedMap(para1: JUMap; para2: JLClass; para3: JLClass): JUMap; static; overload;
    class function checkedSortedMap(para1: JUSortedMap; para2: JLClass; para3: JLClass): JUSortedMap; static; overload;
    class function emptySet(): JUSet; static; overload; final;
    class function emptyList(): JUList; static; overload; final;
    class function emptyMap(): JUMap; static; overload; final;
    class function singleton(para1: JLObject): JUSet; static; overload;
    class function singletonList(para1: JLObject): JUList; static; overload;
    class function singletonMap(para1: JLObject; para2: JLObject): JUMap; static; overload;
    class function nCopies(para1: jint; para2: JLObject): JUList; static; overload;
    class function reverseOrder(): JUComparator; static; overload;
    class function reverseOrder(para1: JUComparator): JUComparator; static; overload;
    class function enumeration(para1: JUCollection): JUEnumeration; static; overload;
    class function list(para1: JUEnumeration): JUArrayList; static; overload;
    class function frequency(para1: JUCollection; para2: JLObject): jint; static; overload;
    class function disjoint(para1: JUCollection; para2: JUCollection): jboolean; static; overload;
    class function addAll(para1: JUCollection; para2: Arr1JLObject): jboolean; static; overload;
    class function addAll(para1: JUCollection; const para2: array of JLObject): jboolean; static; overload;
    class function newSetFromMap(para1: JUMap): JUSet; static; overload;
    class function asLifoQueue(para1: JUDeque): JUQueue; static; overload;
  end;

  JUCurrencyData = class external 'java.util' name 'CurrencyData' (JLObject)
  end;

  JUDictionary = class abstract external 'java.util' name 'Dictionary' (JLObject)
  public
    constructor create(); overload;
    function size(): jint; overload; virtual; abstract;
    function isEmpty(): jboolean; overload; virtual; abstract;
    function keys(): JUEnumeration; overload; virtual; abstract;
    function elements(): JUEnumeration; overload; virtual; abstract;
    function get(para1: JLObject): JLObject; overload; virtual; abstract;
    function put(para1: JLObject; para2: JLObject): JLObject; overload; virtual; abstract;
    function remove(para1: JLObject): JLObject; overload; virtual; abstract;
  end;

  JUEnumeration = interface external 'java.util' name 'Enumeration' 
    function hasMoreElements(): jboolean; overload;
    function nextElement(): JLObject; overload;
  end;

  JUEventListener = interface external 'java.util' name 'EventListener' 
  end;

  JUFormattable = interface external 'java.util' name 'Formattable' 
    procedure formatTo(para1: JUFormatter; para2: jint; para3: jint; para4: jint); overload;
  end;

  JUFormattableFlags = class external 'java.util' name 'FormattableFlags' (JLObject)
  public
    const
      LEFT_JUSTIFY = 1;
      UPPERCASE = 2;
      ALTERNATE = 4;
  end;

  JULocaleISOData = class external 'java.util' name 'LocaleISOData' (JLObject)
  end;

  JUObservable = class external 'java.util' name 'Observable' (JLObject)
  public
    constructor create(); overload;
    procedure addObserver(para1: JUObserver); overload; virtual;
    procedure deleteObserver(para1: JUObserver); overload; virtual;
    procedure notifyObservers(); overload; virtual;
    procedure notifyObservers(para1: JLObject); overload; virtual;
    procedure deleteObservers(); overload; virtual;
  strict protected
    procedure setChanged(); overload; virtual;
    procedure clearChanged(); overload; virtual;
  public
    function hasChanged(): jboolean; overload; virtual;
    function countObservers(): jint; overload; virtual;
  end;

  JUObserver = interface external 'java.util' name 'Observer' 
    procedure update(para1: JUObservable; para2: JLObject); overload;
  end;

  JURandomAccess = interface external 'java.util' name 'RandomAccess' 
  end;

  JUResourceBundle = class abstract external 'java.util' name 'ResourceBundle' (JLObject)
  public
    type
      InnerBundleReference = class;
      Arr1InnerBundleReference = array of InnerBundleReference;
      Arr2InnerBundleReference = array of Arr1InnerBundleReference;
      Arr3InnerBundleReference = array of Arr2InnerBundleReference;
      InnerNoFallbackControl = class;
      Arr1InnerNoFallbackControl = array of InnerNoFallbackControl;
      Arr2InnerNoFallbackControl = array of Arr1InnerNoFallbackControl;
      Arr3InnerNoFallbackControl = array of Arr2InnerNoFallbackControl;
      InnerSingleFormatControl = class;
      Arr1InnerSingleFormatControl = array of InnerSingleFormatControl;
      Arr2InnerSingleFormatControl = array of Arr1InnerSingleFormatControl;
      Arr3InnerSingleFormatControl = array of Arr2InnerSingleFormatControl;
      InnerCacheKeyReference = interface;
      Arr1InnerCacheKeyReference = array of InnerCacheKeyReference;
      Arr2InnerCacheKeyReference = array of Arr1InnerCacheKeyReference;
      Arr3InnerCacheKeyReference = array of Arr2InnerCacheKeyReference;
      InnerCacheKey = class;
      Arr1InnerCacheKey = array of InnerCacheKey;
      Arr2InnerCacheKey = array of Arr1InnerCacheKey;
      Arr3InnerCacheKey = array of Arr2InnerCacheKey;
      InnerLoaderReference = class;
      Arr1InnerLoaderReference = array of InnerLoaderReference;
      Arr2InnerLoaderReference = array of Arr1InnerLoaderReference;
      Arr3InnerLoaderReference = array of Arr2InnerLoaderReference;
      InnerRBClassLoader = class;
      Arr1InnerRBClassLoader = array of InnerRBClassLoader;
      Arr2InnerRBClassLoader = array of Arr1InnerRBClassLoader;
      Arr3InnerRBClassLoader = array of Arr2InnerRBClassLoader;
      InnerBundleReference = class sealed external 'java.util' name 'BundleReference' 
      end;

      InnerNoFallbackControl = class sealed external 'java.util' name 'NoFallbackControl' 
      end;

      InnerSingleFormatControl = class external 'java.util' name 'SingleFormatControl' 
      end;

      InnerCacheKeyReference = interface external 'java.util' name 'CacheKeyReference' 
      end;

      InnerCacheKey = class sealed external 'java.util' name 'CacheKey' 
      end;

      InnerLoaderReference = class sealed external 'java.util' name 'LoaderReference' 
      end;

      InnerRBClassLoader = class external 'java.util' name 'RBClassLoader' 
      end;

  public
    type
      InnerControl = class;
      Arr1InnerControl = array of InnerControl;
      Arr2InnerControl = array of Arr1InnerControl;
      Arr3InnerControl = array of Arr2InnerControl;
      InnerControl = class external 'java.util' name 'Control' (JLObject)
      public
        final class var
          fFORMAT_DEFAULT: JUList; external name 'FORMAT_DEFAULT';
          fFORMAT_CLASS: JUList; external name 'FORMAT_CLASS';
          fFORMAT_PROPERTIES: JUList; external name 'FORMAT_PROPERTIES';
      public
        const
          TTL_DONT_CACHE = jlong(-1);
          TTL_NO_EXPIRATION_CONTROL = jlong(-2);
      strict protected
        constructor create(); overload;
      public
        class function getControl(para1: JUList): JUResourceBundle.InnerControl; static; overload; final;
        class function getNoFallbackControl(para1: JUList): JUResourceBundle.InnerControl; static; overload; final;
        function getFormats(para1: JLString): JUList; overload; virtual;
        function getCandidateLocales(para1: JLString; para2: JULocale): JUList; overload; virtual;
        function getFallbackLocale(para1: JLString; para2: JULocale): JULocale; overload; virtual;
        function newBundle(para1: JLString; para2: JULocale; para3: JLString; para4: JLClassLoader; para5: jboolean): JUResourceBundle; overload; virtual;  // throws java.lang.IllegalAccessException, java.lang.InstantiationException, java.io.IOException
        function getTimeToLive(para1: JLString; para2: JULocale): jlong; overload; virtual;
        function needsReload(para1: JLString; para2: JULocale; para3: JLString; para4: JLClassLoader; para5: JUResourceBundle; para6: jlong): jboolean; overload; virtual;
        function toBundleName(para1: JLString; para2: JULocale): JLString; overload; virtual;
        function toResourceName(para1: JLString; para2: JLString): JLString; overload; virtual; final;
      end;

  strict protected
    var
      fparent: JUResourceBundle; external name 'parent';
  public
    constructor create(); overload;
    function getString(para1: JLString): JLString; overload; virtual; final;
    function getStringArray(para1: JLString): Arr1JLString; overload; virtual; final;
    function getObject(para1: JLString): JLObject; overload; virtual; final;
    function getLocale(): JULocale; overload; virtual;
  strict protected
    procedure setParent(para1: JUResourceBundle); overload; virtual;
  public
    class function getBundle(para1: JLString): JUResourceBundle; static; overload; final;
    class function getBundle(para1: JLString; para2: JUResourceBundle.InnerControl): JUResourceBundle; static; overload; final;
    class function getBundle(para1: JLString; para2: JULocale): JUResourceBundle; static; overload; final;
    class function getBundle(para1: JLString; para2: JULocale; para3: JUResourceBundle.InnerControl): JUResourceBundle; static; overload; final;
    class function getBundle(para1: JLString; para2: JULocale; para3: JLClassLoader): JUResourceBundle; static; overload;
    class function getBundle(para1: JLString; para2: JULocale; para3: JLClassLoader; para4: JUResourceBundle.InnerControl): JUResourceBundle; static; overload;
    class procedure clearCache(); static; overload; final;
    class procedure clearCache(para1: JLClassLoader); static; overload; final;
  strict protected
    function handleGetObject(para1: JLString): JLObject; overload; virtual; abstract;
  public
    function getKeys(): JUEnumeration; overload; virtual; abstract;
    function containsKey(para1: JLString): jboolean; overload; virtual;
    function keySet(): JUSet; overload; virtual;
  strict protected
    function handleKeySet(): JUSet; overload; virtual;
  end;

  JUTaskQueue = class external 'java.util' name 'TaskQueue' (JLObject)
  end;

  JUTimer = class external 'java.util' name 'Timer' (JLObject)
  public
    constructor create(); overload;
    constructor create(para1: jboolean); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: jboolean); overload;
    procedure schedule(para1: JUTimerTask; para2: jlong); overload; virtual;
    procedure schedule(para1: JUTimerTask; para2: JUDate); overload; virtual;
    procedure schedule(para1: JUTimerTask; para2: jlong; para3: jlong); overload; virtual;
    procedure schedule(para1: JUTimerTask; para2: JUDate; para3: jlong); overload; virtual;
    procedure scheduleAtFixedRate(para1: JUTimerTask; para2: jlong; para3: jlong); overload; virtual;
    procedure scheduleAtFixedRate(para1: JUTimerTask; para2: JUDate; para3: jlong); overload; virtual;
    procedure cancel(); overload; virtual;
    function purge(): jint; overload; virtual;
  end;

  JUXMLUtils = class external 'java.util' name 'XMLUtils' (JLObject)
  public
    type
      InnerEH = class;
      Arr1InnerEH = array of InnerEH;
      Arr2InnerEH = array of Arr1InnerEH;
      Arr3InnerEH = array of Arr2InnerEH;
      InnerResolver = class;
      Arr1InnerResolver = array of InnerResolver;
      Arr2InnerResolver = array of Arr1InnerResolver;
      Arr3InnerResolver = array of Arr2InnerResolver;
      InnerEH = class external 'java.util' name 'EH' 
      end;

      InnerResolver = class external 'java.util' name 'Resolver' 
      end;

  end;

  JUCCallable = interface external 'java.util.concurrent' name 'Callable' 
    function call(): JLObject; overload;  // throws java.lang.Exception
  end;

  JUCCompletionService = interface external 'java.util.concurrent' name 'CompletionService' 
    function submit(para1: JUCCallable): JUCFuture; overload;
    function submit(para1: JLRunnable; para2: JLObject): JUCFuture; overload;
    function take(): JUCFuture; overload;  // throws java.lang.InterruptedException
    function poll(): JUCFuture; overload;
    function poll(para1: jlong; para2: JUCTimeUnit): JUCFuture; overload;  // throws java.lang.InterruptedException
  end;

  JUCCountDownLatch = class external 'java.util.concurrent' name 'CountDownLatch' (JLObject)
  public
    type
      InnerSync = class;
      Arr1InnerSync = array of InnerSync;
      Arr2InnerSync = array of Arr1InnerSync;
      Arr3InnerSync = array of Arr2InnerSync;
      InnerSync = class sealed external 'java.util.concurrent' name 'Sync' 
      end;

  public
    constructor create(para1: jint); overload;
    procedure await(); overload; virtual;  // throws java.lang.InterruptedException
    function await(para1: jlong; para2: JUCTimeUnit): jboolean; overload; virtual;  // throws java.lang.InterruptedException
    procedure countDown(); overload; virtual;
    function getCount(): jlong; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JUCCyclicBarrier = class external 'java.util.concurrent' name 'CyclicBarrier' (JLObject)
  public
    type
      InnerGeneration = class;
      Arr1InnerGeneration = array of InnerGeneration;
      Arr2InnerGeneration = array of Arr1InnerGeneration;
      Arr3InnerGeneration = array of Arr2InnerGeneration;
      InnerGeneration = class external 'java.util.concurrent' name 'Generation' 
      end;

  public
    constructor create(para1: jint; para2: JLRunnable); overload;
    constructor create(para1: jint); overload;
    function getParties(): jint; overload; virtual;
    function await(): jint; overload; virtual;  // throws java.lang.InterruptedException, java.util.concurrent.BrokenBarrierException
    function await(para1: jlong; para2: JUCTimeUnit): jint; overload; virtual;  // throws java.lang.InterruptedException, java.util.concurrent.BrokenBarrierException, java.util.concurrent.TimeoutException
    function isBroken(): jboolean; overload; virtual;
    procedure reset(); overload; virtual;
    function getNumberWaiting(): jint; overload; virtual;
  end;

  JUCExchanger = class external 'java.util.concurrent' name 'Exchanger' (JLObject)
  public
    type
      InnerNode = class;
      Arr1InnerNode = array of InnerNode;
      Arr2InnerNode = array of Arr1InnerNode;
      Arr3InnerNode = array of Arr2InnerNode;
      InnerSlot = class;
      Arr1InnerSlot = array of InnerSlot;
      Arr2InnerSlot = array of Arr1InnerSlot;
      Arr3InnerSlot = array of Arr2InnerSlot;
      InnerNode = class sealed external 'java.util.concurrent' name 'Node' 
      end;

      InnerSlot = class sealed external 'java.util.concurrent' name 'Slot' 
      end;

  public
    constructor create(); overload;
    function exchange(para1: JLObject): JLObject; overload; virtual;  // throws java.lang.InterruptedException
    function exchange(para1: JLObject; para2: jlong; para3: JUCTimeUnit): JLObject; overload; virtual;  // throws java.lang.InterruptedException, java.util.concurrent.TimeoutException
  end;

  JUCExecutor = interface external 'java.util.concurrent' name 'Executor' 
    procedure execute(para1: JLRunnable); overload;
  end;

  JUCExecutors = class external 'java.util.concurrent' name 'Executors' (JLObject)
  public
    type
      InnerDefaultThreadFactory = class;
      Arr1InnerDefaultThreadFactory = array of InnerDefaultThreadFactory;
      Arr2InnerDefaultThreadFactory = array of Arr1InnerDefaultThreadFactory;
      Arr3InnerDefaultThreadFactory = array of Arr2InnerDefaultThreadFactory;
      InnerDelegatedExecutorService = class;
      Arr1InnerDelegatedExecutorService = array of InnerDelegatedExecutorService;
      Arr2InnerDelegatedExecutorService = array of Arr1InnerDelegatedExecutorService;
      Arr3InnerDelegatedExecutorService = array of Arr2InnerDelegatedExecutorService;
      InnerDelegatedScheduledExecutorService = class;
      Arr1InnerDelegatedScheduledExecutorService = array of InnerDelegatedScheduledExecutorService;
      Arr2InnerDelegatedScheduledExecutorService = array of Arr1InnerDelegatedScheduledExecutorService;
      Arr3InnerDelegatedScheduledExecutorService = array of Arr2InnerDelegatedScheduledExecutorService;
      InnerFinalizableDelegatedExecutorService = class;
      Arr1InnerFinalizableDelegatedExecutorService = array of InnerFinalizableDelegatedExecutorService;
      Arr2InnerFinalizableDelegatedExecutorService = array of Arr1InnerFinalizableDelegatedExecutorService;
      Arr3InnerFinalizableDelegatedExecutorService = array of Arr2InnerFinalizableDelegatedExecutorService;
      InnerPrivilegedThreadFactory = class;
      Arr1InnerPrivilegedThreadFactory = array of InnerPrivilegedThreadFactory;
      Arr2InnerPrivilegedThreadFactory = array of Arr1InnerPrivilegedThreadFactory;
      Arr3InnerPrivilegedThreadFactory = array of Arr2InnerPrivilegedThreadFactory;
      InnerPrivilegedCallable = class;
      Arr1InnerPrivilegedCallable = array of InnerPrivilegedCallable;
      Arr2InnerPrivilegedCallable = array of Arr1InnerPrivilegedCallable;
      Arr3InnerPrivilegedCallable = array of Arr2InnerPrivilegedCallable;
      InnerPrivilegedCallableUsingCurrentClassLoader = class;
      Arr1InnerPrivilegedCallableUsingCurrentClassLoader = array of InnerPrivilegedCallableUsingCurrentClassLoader;
      Arr2InnerPrivilegedCallableUsingCurrentClassLoader = array of Arr1InnerPrivilegedCallableUsingCurrentClassLoader;
      Arr3InnerPrivilegedCallableUsingCurrentClassLoader = array of Arr2InnerPrivilegedCallableUsingCurrentClassLoader;
      InnerRunnableAdapter = class;
      Arr1InnerRunnableAdapter = array of InnerRunnableAdapter;
      Arr2InnerRunnableAdapter = array of Arr1InnerRunnableAdapter;
      Arr3InnerRunnableAdapter = array of Arr2InnerRunnableAdapter;
      InnerDefaultThreadFactory = class external 'java.util.concurrent' name 'DefaultThreadFactory' 
      end;

      InnerDelegatedExecutorService = class external 'java.util.concurrent' name 'DelegatedExecutorService' 
      end;

      InnerDelegatedScheduledExecutorService = class external 'java.util.concurrent' name 'DelegatedScheduledExecutorService' 
      end;

      InnerFinalizableDelegatedExecutorService = class external 'java.util.concurrent' name 'FinalizableDelegatedExecutorService' 
      end;

      InnerPrivilegedThreadFactory = class external 'java.util.concurrent' name 'PrivilegedThreadFactory' 
      end;

      InnerPrivilegedCallable = class sealed external 'java.util.concurrent' name 'PrivilegedCallable' 
      end;

      InnerPrivilegedCallableUsingCurrentClassLoader = class sealed external 'java.util.concurrent' name 'PrivilegedCallableUsingCurrentClassLoader' 
      end;

      InnerRunnableAdapter = class sealed external 'java.util.concurrent' name 'RunnableAdapter' 
      end;

  public
    class function newFixedThreadPool(para1: jint): JUCExecutorService; static; overload;
    class function newFixedThreadPool(para1: jint; para2: JUCThreadFactory): JUCExecutorService; static; overload;
    class function newSingleThreadExecutor(): JUCExecutorService; static; overload;
    class function newSingleThreadExecutor(para1: JUCThreadFactory): JUCExecutorService; static; overload;
    class function newCachedThreadPool(): JUCExecutorService; static; overload;
    class function newCachedThreadPool(para1: JUCThreadFactory): JUCExecutorService; static; overload;
    class function newSingleThreadScheduledExecutor(): JUCScheduledExecutorService; static; overload;
    class function newSingleThreadScheduledExecutor(para1: JUCThreadFactory): JUCScheduledExecutorService; static; overload;
    class function newScheduledThreadPool(para1: jint): JUCScheduledExecutorService; static; overload;
    class function newScheduledThreadPool(para1: jint; para2: JUCThreadFactory): JUCScheduledExecutorService; static; overload;
    class function unconfigurableExecutorService(para1: JUCExecutorService): JUCExecutorService; static; overload;
    class function unconfigurableScheduledExecutorService(para1: JUCScheduledExecutorService): JUCScheduledExecutorService; static; overload;
    class function defaultThreadFactory(): JUCThreadFactory; static; overload;
    class function privilegedThreadFactory(): JUCThreadFactory; static; overload;
    class function callable(para1: JLRunnable; para2: JLObject): JUCCallable; static; overload;
    class function callable(para1: JLRunnable): JUCCallable; static; overload;
    class function callable(para1: JSPrivilegedAction): JUCCallable; static; overload;
    class function callable(para1: JSPrivilegedExceptionAction): JUCCallable; static; overload;
    class function privilegedCallable(para1: JUCCallable): JUCCallable; static; overload;
    class function privilegedCallableUsingCurrentClassLoader(para1: JUCCallable): JUCCallable; static; overload;
  end;

  JUCFuture = interface external 'java.util.concurrent' name 'Future' 
    function cancel(para1: jboolean): jboolean; overload;
    function isCancelled(): jboolean; overload;
    function isDone(): jboolean; overload;
    function get(): JLObject; overload;  // throws java.lang.InterruptedException, java.util.concurrent.ExecutionException
    function get(para1: jlong; para2: JUCTimeUnit): JLObject; overload;  // throws java.lang.InterruptedException, java.util.concurrent.ExecutionException, java.util.concurrent.TimeoutException
  end;

  JUCRejectedExecutionHandler = interface external 'java.util.concurrent' name 'RejectedExecutionHandler' 
    procedure rejectedExecution(para1: JLRunnable; para2: JUCThreadPoolExecutor); overload;
  end;

  JUCThreadFactory = interface external 'java.util.concurrent' name 'ThreadFactory' 
    function newThread(para1: JLRunnable): JLThread; overload;
  end;

  JUCAAtomicIntegerFieldUpdater = class abstract external 'java.util.concurrent.atomic' name 'AtomicIntegerFieldUpdater' (JLObject)
  public
    type
      InnerAtomicIntegerFieldUpdaterImpl = class;
      Arr1InnerAtomicIntegerFieldUpdaterImpl = array of InnerAtomicIntegerFieldUpdaterImpl;
      Arr2InnerAtomicIntegerFieldUpdaterImpl = array of Arr1InnerAtomicIntegerFieldUpdaterImpl;
      Arr3InnerAtomicIntegerFieldUpdaterImpl = array of Arr2InnerAtomicIntegerFieldUpdaterImpl;
      InnerAtomicIntegerFieldUpdaterImpl = class external 'java.util.concurrent.atomic' name 'AtomicIntegerFieldUpdaterImpl' 
      end;

  public
    class function newUpdater(para1: JLClass; para2: JLString): JUCAAtomicIntegerFieldUpdater; static; overload;
  strict protected
    constructor create(); overload;
  public
    function compareAndSet(para1: JLObject; para2: jint; para3: jint): jboolean; overload; virtual; abstract;
    function weakCompareAndSet(para1: JLObject; para2: jint; para3: jint): jboolean; overload; virtual; abstract;
    procedure &set(para1: JLObject; para2: jint); overload; virtual; abstract;
    procedure lazySet(para1: JLObject; para2: jint); overload; virtual; abstract;
    function get(para1: JLObject): jint; overload; virtual; abstract;
    function getAndSet(para1: JLObject; para2: jint): jint; overload; virtual;
    function getAndIncrement(para1: JLObject): jint; overload; virtual;
    function getAndDecrement(para1: JLObject): jint; overload; virtual;
    function getAndAdd(para1: JLObject; para2: jint): jint; overload; virtual;
    function incrementAndGet(para1: JLObject): jint; overload; virtual;
    function decrementAndGet(para1: JLObject): jint; overload; virtual;
    function addAndGet(para1: JLObject; para2: jint): jint; overload; virtual;
  end;

  JUCAAtomicLongFieldUpdater = class abstract external 'java.util.concurrent.atomic' name 'AtomicLongFieldUpdater' (JLObject)
  public
    type
      InnerCASUpdater = class;
      Arr1InnerCASUpdater = array of InnerCASUpdater;
      Arr2InnerCASUpdater = array of Arr1InnerCASUpdater;
      Arr3InnerCASUpdater = array of Arr2InnerCASUpdater;
      InnerLockedUpdater = class;
      Arr1InnerLockedUpdater = array of InnerLockedUpdater;
      Arr2InnerLockedUpdater = array of Arr1InnerLockedUpdater;
      Arr3InnerLockedUpdater = array of Arr2InnerLockedUpdater;
      InnerCASUpdater = class external 'java.util.concurrent.atomic' name 'CASUpdater' 
      end;

      InnerLockedUpdater = class external 'java.util.concurrent.atomic' name 'LockedUpdater' 
      end;

  public
    class function newUpdater(para1: JLClass; para2: JLString): JUCAAtomicLongFieldUpdater; static; overload;
  strict protected
    constructor create(); overload;
  public
    function compareAndSet(para1: JLObject; para2: jlong; para3: jlong): jboolean; overload; virtual; abstract;
    function weakCompareAndSet(para1: JLObject; para2: jlong; para3: jlong): jboolean; overload; virtual; abstract;
    procedure &set(para1: JLObject; para2: jlong); overload; virtual; abstract;
    procedure lazySet(para1: JLObject; para2: jlong); overload; virtual; abstract;
    function get(para1: JLObject): jlong; overload; virtual; abstract;
    function getAndSet(para1: JLObject; para2: jlong): jlong; overload; virtual;
    function getAndIncrement(para1: JLObject): jlong; overload; virtual;
    function getAndDecrement(para1: JLObject): jlong; overload; virtual;
    function getAndAdd(para1: JLObject; para2: jlong): jlong; overload; virtual;
    function incrementAndGet(para1: JLObject): jlong; overload; virtual;
    function decrementAndGet(para1: JLObject): jlong; overload; virtual;
    function addAndGet(para1: JLObject; para2: jlong): jlong; overload; virtual;
  end;

  JUCAAtomicMarkableReference = class external 'java.util.concurrent.atomic' name 'AtomicMarkableReference' (JLObject)
  public
    type
      InnerReferenceBooleanPair = class;
      Arr1InnerReferenceBooleanPair = array of InnerReferenceBooleanPair;
      Arr2InnerReferenceBooleanPair = array of Arr1InnerReferenceBooleanPair;
      Arr3InnerReferenceBooleanPair = array of Arr2InnerReferenceBooleanPair;
      InnerReferenceBooleanPair = class external 'java.util.concurrent.atomic' name 'ReferenceBooleanPair' 
      end;

  public
    constructor create(para1: JLObject; para2: jboolean); overload;
    function getReference(): JLObject; overload; virtual;
    function isMarked(): jboolean; overload; virtual;
    function get(para1: Arr1jboolean): JLObject; overload; virtual;
    function get(var para1: array of jboolean): JLObject; overload; virtual;
    function weakCompareAndSet(para1: JLObject; para2: JLObject; para3: jboolean; para4: jboolean): jboolean; overload; virtual;
    function compareAndSet(para1: JLObject; para2: JLObject; para3: jboolean; para4: jboolean): jboolean; overload; virtual;
    procedure &set(para1: JLObject; para2: jboolean); overload; virtual;
    function attemptMark(para1: JLObject; para2: jboolean): jboolean; overload; virtual;
  end;

  JUCAAtomicReferenceFieldUpdater = class abstract external 'java.util.concurrent.atomic' name 'AtomicReferenceFieldUpdater' (JLObject)
  public
    type
      InnerAtomicReferenceFieldUpdaterImpl = class;
      Arr1InnerAtomicReferenceFieldUpdaterImpl = array of InnerAtomicReferenceFieldUpdaterImpl;
      Arr2InnerAtomicReferenceFieldUpdaterImpl = array of Arr1InnerAtomicReferenceFieldUpdaterImpl;
      Arr3InnerAtomicReferenceFieldUpdaterImpl = array of Arr2InnerAtomicReferenceFieldUpdaterImpl;
      InnerAtomicReferenceFieldUpdaterImpl = class sealed external 'java.util.concurrent.atomic' name 'AtomicReferenceFieldUpdaterImpl' 
      end;

  public
    class function newUpdater(para1: JLClass; para2: JLClass; para3: JLString): JUCAAtomicReferenceFieldUpdater; static; overload;
  strict protected
    constructor create(); overload;
  public
    function compareAndSet(para1: JLObject; para2: JLObject; para3: JLObject): jboolean; overload; virtual; abstract;
    function weakCompareAndSet(para1: JLObject; para2: JLObject; para3: JLObject): jboolean; overload; virtual; abstract;
    procedure &set(para1: JLObject; para2: JLObject); overload; virtual; abstract;
    procedure lazySet(para1: JLObject; para2: JLObject); overload; virtual; abstract;
    function get(para1: JLObject): JLObject; overload; virtual; abstract;
    function getAndSet(para1: JLObject; para2: JLObject): JLObject; overload; virtual;
  end;

  JUCAAtomicStampedReference = class external 'java.util.concurrent.atomic' name 'AtomicStampedReference' (JLObject)
  public
    type
      InnerReferenceIntegerPair = class;
      Arr1InnerReferenceIntegerPair = array of InnerReferenceIntegerPair;
      Arr2InnerReferenceIntegerPair = array of Arr1InnerReferenceIntegerPair;
      Arr3InnerReferenceIntegerPair = array of Arr2InnerReferenceIntegerPair;
      InnerReferenceIntegerPair = class external 'java.util.concurrent.atomic' name 'ReferenceIntegerPair' 
      end;

  public
    constructor create(para1: JLObject; para2: jint); overload;
    function getReference(): JLObject; overload; virtual;
    function getStamp(): jint; overload; virtual;
    function get(para1: Arr1jint): JLObject; overload; virtual;
    function get(var para1: array of jint): JLObject; overload; virtual;
    function weakCompareAndSet(para1: JLObject; para2: JLObject; para3: jint; para4: jint): jboolean; overload; virtual;
    function compareAndSet(para1: JLObject; para2: JLObject; para3: jint; para4: jint): jboolean; overload; virtual;
    procedure &set(para1: JLObject; para2: jint); overload; virtual;
    function attemptStamp(para1: JLObject; para2: jint): jboolean; overload; virtual;
  end;

  JUCLCondition = interface external 'java.util.concurrent.locks' name 'Condition' 
    procedure await(); overload;  // throws java.lang.InterruptedException
    procedure awaitUninterruptibly(); overload;
    function awaitNanos(para1: jlong): jlong; overload;  // throws java.lang.InterruptedException
    function await(para1: jlong; para2: JUCTimeUnit): jboolean; overload;  // throws java.lang.InterruptedException
    function awaitUntil(para1: JUDate): jboolean; overload;  // throws java.lang.InterruptedException
    procedure signal(); overload;
    procedure signalAll(); overload;
  end;

  JUCLLock = interface external 'java.util.concurrent.locks' name 'Lock' 
    procedure lock(); overload;
    procedure lockInterruptibly(); overload;  // throws java.lang.InterruptedException
    function tryLock(): jboolean; overload;
    function tryLock(para1: jlong; para2: JUCTimeUnit): jboolean; overload;  // throws java.lang.InterruptedException
    procedure unlock(); overload;
    function newCondition(): JUCLCondition; overload;
  end;

  JUCLLockSupport = class external 'java.util.concurrent.locks' name 'LockSupport' (JLObject)
  public
    class procedure unpark(para1: JLThread); static; overload;
    class procedure park(para1: JLObject); static; overload;
    class procedure parkNanos(para1: JLObject; para2: jlong); static; overload;
    class procedure parkUntil(para1: JLObject; para2: jlong); static; overload;
    class function getBlocker(para1: JLThread): JLObject; static; overload;
    class procedure park(); static; overload;
    class procedure parkNanos(para1: jlong); static; overload;
    class procedure parkUntil(para1: jlong); static; overload;
  end;

  JUCLReadWriteLock = interface external 'java.util.concurrent.locks' name 'ReadWriteLock' 
    function readLock(): JUCLLock; overload;
    function writeLock(): JUCLLock; overload;
  end;

  JUJJarVerifier = class external 'java.util.jar' name 'JarVerifier' (JLObject)
  public
    type
      InnerVerifierCodeSource = class;
      Arr1InnerVerifierCodeSource = array of InnerVerifierCodeSource;
      Arr2InnerVerifierCodeSource = array of Arr1InnerVerifierCodeSource;
      Arr3InnerVerifierCodeSource = array of Arr2InnerVerifierCodeSource;
      InnerVerifierStream = class;
      Arr1InnerVerifierStream = array of InnerVerifierStream;
      Arr2InnerVerifierStream = array of Arr1InnerVerifierStream;
      Arr3InnerVerifierStream = array of Arr2InnerVerifierStream;
      InnerVerifierCodeSource = class external 'java.util.jar' name 'VerifierCodeSource' 
      end;

      InnerVerifierStream = class external 'java.util.jar' name 'VerifierStream' 
      end;

  public
    constructor create(para1: Arr1jbyte); overload;
    constructor create(const para1: array of jbyte); overload;
    procedure beginEntry(para1: JUJJarEntry; para2: SSUManifestEntryVerifier); overload; virtual;  // throws java.io.IOException
    procedure update(para1: jint; para2: SSUManifestEntryVerifier); overload; virtual;  // throws java.io.IOException
    procedure update(para1: jint; para2: Arr1jbyte; para3: jint; para4: jint; para5: SSUManifestEntryVerifier); overload; virtual;  // throws java.io.IOException
    procedure update(para1: jint; var para2: array of jbyte; para3: jint; para4: jint; para5: SSUManifestEntryVerifier); overload; virtual;  // throws java.io.IOException
    function getCerts(para1: JLString): Arr1JSCCertificate; overload; virtual;
    function getCerts(para1: JUJJarFile; para2: JUJJarEntry): Arr1JSCCertificate; overload; virtual;
    function getCodeSigners(para1: JLString): Arr1JSCodeSigner; overload; virtual;
    function getCodeSigners(para1: JUJJarFile; para2: JUJJarEntry): Arr1JSCodeSigner; overload; virtual;
    function entryNames(para1: JUJJarFile; para2: Arr1JSCodeSource): JUEnumeration; overload; virtual;
    function entryNames(para1: JUJJarFile; var para2: array of JSCodeSource): JUEnumeration; overload; virtual;
    function entries2(para1: JUJJarFile; para2: JUEnumeration): JUEnumeration; overload; virtual;
    function getCodeSources(para1: JUJJarFile; para2: JNURL): Arr1JSCodeSource; overload; virtual;
    function getCodeSource(para1: JNURL; para2: JLString): JSCodeSource; overload; virtual;
    function getCodeSource(para1: JNURL; para2: JUJJarFile; para3: JUJJarEntry): JSCodeSource; overload; virtual;
    procedure setEagerValidation(para1: jboolean); overload; virtual;
    function getManifestDigests(): JUList; overload; virtual;
  end;

  JUJPack200 = class abstract external 'java.util.jar' name 'Pack200' (JLObject)
  public
    type
      InnerPacker = interface;
      Arr1InnerPacker = array of InnerPacker;
      Arr2InnerPacker = array of Arr1InnerPacker;
      Arr3InnerPacker = array of Arr2InnerPacker;
      InnerUnpacker = interface;
      Arr1InnerUnpacker = array of InnerUnpacker;
      Arr2InnerUnpacker = array of Arr1InnerUnpacker;
      Arr3InnerUnpacker = array of Arr2InnerUnpacker;
      InnerPacker = interface external 'java.util.jar' name 'Packer' 
        const
          SEGMENT_LIMIT = 'pack.segment.limit';
          KEEP_FILE_ORDER = 'pack.keep.file.order';
          EFFORT = 'pack.effort';
          DEFLATE_HINT = 'pack.deflate.hint';
          MODIFICATION_TIME = 'pack.modification.time';
          PASS_FILE_PFX = 'pack.pass.file.';
          UNKNOWN_ATTRIBUTE = 'pack.unknown.attribute';
          CLASS_ATTRIBUTE_PFX = 'pack.class.attribute.';
          FIELD_ATTRIBUTE_PFX = 'pack.field.attribute.';
          METHOD_ATTRIBUTE_PFX = 'pack.method.attribute.';
          CODE_ATTRIBUTE_PFX = 'pack.code.attribute.';
          PROGRESS = 'pack.progress';
          KEEP = 'keep';
          PASS = 'pass';
          STRIP = 'strip';
          ERROR = 'error';
          &TRUE = 'true';
          &FALSE = 'false';
          LATEST = 'latest';
        function properties(): JUSortedMap; overload;
        procedure pack(para1: JUJJarFile; para2: JIOutputStream); overload;  // throws java.io.IOException
        procedure pack(para1: JUJJarInputStream; para2: JIOutputStream); overload;  // throws java.io.IOException
        procedure addPropertyChangeListener(para1: JBPropertyChangeListener); overload;
        procedure removePropertyChangeListener(para1: JBPropertyChangeListener); overload;
      end;

      InnerUnpacker = interface external 'java.util.jar' name 'Unpacker' 
        const
          KEEP = 'keep';
          &TRUE = 'true';
          &FALSE = 'false';
          DEFLATE_HINT = 'unpack.deflate.hint';
          PROGRESS = 'unpack.progress';
        function properties(): JUSortedMap; overload;
        procedure unpack(para1: JIInputStream; para2: JUJJarOutputStream); overload;  // throws java.io.IOException
        procedure unpack(para1: JIFile; para2: JUJJarOutputStream); overload;  // throws java.io.IOException
        procedure addPropertyChangeListener(para1: JBPropertyChangeListener); overload;
        procedure removePropertyChangeListener(para1: JBPropertyChangeListener); overload;
      end;

  public
    class function newPacker(): JUJPack200.InnerPacker; static; overload;
    class function newUnpacker(): JUJPack200.InnerUnpacker; static; overload;
  end;

  JULErrorManager = class external 'java.util.logging' name 'ErrorManager' (JLObject)
  public
    const
      GENERIC_FAILURE = 0;
      WRITE_FAILURE = 1;
      FLUSH_FAILURE = 2;
      CLOSE_FAILURE = 3;
      OPEN_FAILURE = 4;
      FORMAT_FAILURE = 5;
  public
    constructor create(); overload;
    procedure error(para1: JLString; para2: JLException; para3: jint); overload; virtual;
  end;

  JULFilter = interface external 'java.util.logging' name 'Filter' 
    function isLoggable(para1: JULLogRecord): jboolean; overload;
  end;

  JULFormatter = class abstract external 'java.util.logging' name 'Formatter' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function format(para1: JULLogRecord): JLString; overload; virtual; abstract;
    function getHead(para1: JULHandler): JLString; overload; virtual;
    function getTail(para1: JULHandler): JLString; overload; virtual;
    function formatMessage(para1: JULLogRecord): JLString; overload; virtual;
  end;

  JULHandler = class abstract external 'java.util.logging' name 'Handler' (JLObject)
  strict protected
    constructor create(); overload;
  public
    procedure publish(para1: JULLogRecord); overload; virtual; abstract;
    procedure flush(); overload; virtual; abstract;
    procedure close(); overload; virtual; abstract;  // throws java.lang.SecurityException
    procedure setFormatter(para1: JULFormatter); overload; virtual;  // throws java.lang.SecurityException
    function getFormatter(): JULFormatter; overload; virtual;
    procedure setEncoding(para1: JLString); overload; virtual;  // throws java.lang.SecurityException, java.io.UnsupportedEncodingException
    function getEncoding(): JLString; overload; virtual;
    procedure setFilter(para1: JULFilter); overload; virtual;  // throws java.lang.SecurityException
    function getFilter(): JULFilter; overload; virtual;
    procedure setErrorManager(para1: JULErrorManager); overload; virtual;
    function getErrorManager(): JULErrorManager; overload; virtual;
  strict protected
    procedure reportError(para1: JLString; para2: JLException; para3: jint); overload; virtual;
  public
    procedure setLevel(para1: JULLevel); overload; virtual;  // throws java.lang.SecurityException
    function getLevel(): JULLevel; overload; virtual;
    function isLoggable(para1: JULLogRecord): jboolean; overload; virtual;
  end;

  JULLogManager = class external 'java.util.logging' name 'LogManager' (JLObject)
  public
    type
      InnerCleaner = class;
      Arr1InnerCleaner = array of InnerCleaner;
      Arr2InnerCleaner = array of Arr1InnerCleaner;
      Arr3InnerCleaner = array of Arr2InnerCleaner;
      InnerLogNode = class;
      Arr1InnerLogNode = array of InnerLogNode;
      Arr2InnerLogNode = array of Arr1InnerLogNode;
      Arr3InnerLogNode = array of Arr2InnerLogNode;
      InnerLoggerWeakRef = class;
      Arr1InnerLoggerWeakRef = array of InnerLoggerWeakRef;
      Arr2InnerLoggerWeakRef = array of Arr1InnerLoggerWeakRef;
      Arr3InnerLoggerWeakRef = array of Arr2InnerLoggerWeakRef;
      InnerRootLogger = class;
      Arr1InnerRootLogger = array of InnerRootLogger;
      Arr2InnerRootLogger = array of Arr1InnerRootLogger;
      Arr3InnerRootLogger = array of Arr2InnerRootLogger;
      InnerCleaner = class external 'java.util.logging' name 'Cleaner' 
      end;

      InnerLogNode = class external 'java.util.logging' name 'LogNode' 
      end;

      InnerLoggerWeakRef = class sealed external 'java.util.logging' name 'LoggerWeakRef' 
      end;

      InnerRootLogger = class external 'java.util.logging' name 'RootLogger' 
      end;

  public
    const
      LOGGING_MXBEAN_NAME = 'java.util.logging:type=Logging';
  strict protected
    constructor create(); overload;
  public
    class function getLogManager(): JULLogManager; static; overload;
    procedure addPropertyChangeListener(para1: JBPropertyChangeListener); overload; virtual;  // throws java.lang.SecurityException
    procedure removePropertyChangeListener(para1: JBPropertyChangeListener); overload; virtual;  // throws java.lang.SecurityException
    function addLogger(para1: JULLogger): jboolean; overload; virtual;
    function getLogger(para1: JLString): JULLogger; overload; virtual;
    function getLoggerNames(): JUEnumeration; overload; virtual;
    procedure readConfiguration(); overload; virtual;  // throws java.io.IOException, java.lang.SecurityException
    procedure reset(); overload; virtual;  // throws java.lang.SecurityException
    procedure readConfiguration(para1: JIInputStream); overload; virtual;  // throws java.io.IOException, java.lang.SecurityException
    function getProperty(para1: JLString): JLString; overload; virtual;
    procedure checkAccess(); overload; virtual;  // throws java.lang.SecurityException
    class function getLoggingMXBean(): JULLoggingMXBean; static; overload;
  end;

  JULLogger = class external 'java.util.logging' name 'Logger' (JLObject)
  public
    const
      GLOBAL_LOGGER_NAME = 'global';
  public
    final class var
      fglobal: JULLogger deprecated; external name 'global';
  strict protected
    constructor create(para1: JLString; para2: JLString); overload;
  public
    class function getLogger(para1: JLString): JULLogger; static; overload;
    class function getLogger(para1: JLString; para2: JLString): JULLogger; static; overload;
    class function getAnonymousLogger(): JULLogger; static; overload;
    class function getAnonymousLogger(para1: JLString): JULLogger; static; overload;
    function getResourceBundle(): JUResourceBundle; overload; virtual;
    function getResourceBundleName(): JLString; overload; virtual;
    procedure setFilter(para1: JULFilter); overload; virtual;  // throws java.lang.SecurityException
    function getFilter(): JULFilter; overload; virtual;
    procedure log(para1: JULLogRecord); overload; virtual;
    procedure log(para1: JULLevel; para2: JLString); overload; virtual;
    procedure log(para1: JULLevel; para2: JLString; para3: JLObject); overload; virtual;
    procedure log(para1: JULLevel; para2: JLString; para3: Arr1JLObject); overload; virtual;
    procedure log(para1: JULLevel; para2: JLString; var para3: array of JLObject); overload; virtual;
    procedure log(para1: JULLevel; para2: JLString; para3: JLThrowable); overload; virtual;
    procedure logp(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString); overload; virtual;
    procedure logp(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: JLObject); overload; virtual;
    procedure logp(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: Arr1JLObject); overload; virtual;
    procedure logp(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; var para5: array of JLObject); overload; virtual;
    procedure logp(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: JLThrowable); overload; virtual;
    procedure logrb(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: JLString); overload; virtual;
    procedure logrb(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: JLString; para6: JLObject); overload; virtual;
    procedure logrb(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: JLString; para6: Arr1JLObject); overload; virtual;
    procedure logrb(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: JLString; var para6: array of JLObject); overload; virtual;
    procedure logrb(para1: JULLevel; para2: JLString; para3: JLString; para4: JLString; para5: JLString; para6: JLThrowable); overload; virtual;
    procedure entering(para1: JLString; para2: JLString); overload; virtual;
    procedure entering(para1: JLString; para2: JLString; para3: JLObject); overload; virtual;
    procedure entering(para1: JLString; para2: JLString; para3: Arr1JLObject); overload; virtual;
    procedure entering(para1: JLString; para2: JLString; var para3: array of JLObject); overload; virtual;
    procedure exiting(para1: JLString; para2: JLString); overload; virtual;
    procedure exiting(para1: JLString; para2: JLString; para3: JLObject); overload; virtual;
    procedure throwing(para1: JLString; para2: JLString; para3: JLThrowable); overload; virtual;
    procedure severe(para1: JLString); overload; virtual;
    procedure warning(para1: JLString); overload; virtual;
    procedure info(para1: JLString); overload; virtual;
    procedure config(para1: JLString); overload; virtual;
    procedure fine(para1: JLString); overload; virtual;
    procedure finer(para1: JLString); overload; virtual;
    procedure finest(para1: JLString); overload; virtual;
    procedure setLevel(para1: JULLevel); overload; virtual;  // throws java.lang.SecurityException
    function getLevel(): JULLevel; overload; virtual;
    function isLoggable(para1: JULLevel): jboolean; overload; virtual;
    function getName(): JLString; overload; virtual;
    procedure addHandler(para1: JULHandler); overload; virtual;  // throws java.lang.SecurityException
    procedure removeHandler(para1: JULHandler); overload; virtual;  // throws java.lang.SecurityException
    function getHandlers(): Arr1JULHandler; overload; virtual;
    procedure setUseParentHandlers(para1: jboolean); overload; virtual;
    function getUseParentHandlers(): jboolean; overload; virtual;
    function getParent(): JULLogger; overload; virtual;
    procedure setParent(para1: JULLogger); overload; virtual;
  end;

  JULLoggingMXBean = interface external 'java.util.logging' name 'LoggingMXBean' 
    function getLoggerNames(): JUList; overload;
    function getLoggerLevel(para1: JLString): JLString; overload;
    procedure setLoggerLevel(para1: JLString; para2: JLString); overload;
    function getParentLoggerName(para1: JLString): JLString; overload;
  end;

  JUPBase64 = class external 'java.util.prefs' name 'Base64' (JLObject)
  public
    class procedure main(para1: Arr1JLString); static; overload;
    class procedure main(var para1: array of JLString); static; overload;
  end;

  JUPPreferences = class abstract external 'java.util.prefs' name 'Preferences' (JLObject)
  public
    const
      MAX_KEY_LENGTH = 80;
      MAX_VALUE_LENGTH = 8192;
      MAX_NAME_LENGTH = 80;
  public
    class function userNodeForPackage(para1: JLClass): JUPPreferences; static; overload;
    class function systemNodeForPackage(para1: JLClass): JUPPreferences; static; overload;
    class function userRoot(): JUPPreferences; static; overload;
    class function systemRoot(): JUPPreferences; static; overload;
  strict protected
    constructor create(); overload;
  public
    procedure put(para1: JLString; para2: JLString); overload; virtual; abstract;
    function get(para1: JLString; para2: JLString): JLString; overload; virtual; abstract;
    procedure remove(para1: JLString); overload; virtual; abstract;
    procedure clear(); overload; virtual; abstract;  // throws java.util.prefs.BackingStoreException
    procedure putInt(para1: JLString; para2: jint); overload; virtual; abstract;
    function getInt(para1: JLString; para2: jint): jint; overload; virtual; abstract;
    procedure putLong(para1: JLString; para2: jlong); overload; virtual; abstract;
    function getLong(para1: JLString; para2: jlong): jlong; overload; virtual; abstract;
    procedure putBoolean(para1: JLString; para2: jboolean); overload; virtual; abstract;
    function getBoolean(para1: JLString; para2: jboolean): jboolean; overload; virtual; abstract;
    procedure putFloat(para1: JLString; para2: jfloat); overload; virtual; abstract;
    function getFloat(para1: JLString; para2: jfloat): jfloat; overload; virtual; abstract;
    procedure putDouble(para1: JLString; para2: jdouble); overload; virtual; abstract;
    function getDouble(para1: JLString; para2: jdouble): jdouble; overload; virtual; abstract;
    procedure putByteArray(para1: JLString; para2: Arr1jbyte); overload; virtual; abstract;
    procedure putByteArray(para1: JLString; var para2: array of jbyte); overload; virtual; abstract;
    function getByteArray(para1: JLString; para2: Arr1jbyte): Arr1jbyte; overload; virtual; abstract;
    function getByteArray(para1: JLString; var para2: array of jbyte): Arr1jbyte; overload; virtual; abstract;
    function keys(): Arr1JLString; overload; virtual; abstract;  // throws java.util.prefs.BackingStoreException
    function childrenNames(): Arr1JLString; overload; virtual; abstract;  // throws java.util.prefs.BackingStoreException
    function parent(): JUPPreferences; overload; virtual; abstract;
    function node(para1: JLString): JUPPreferences; overload; virtual; abstract;
    function nodeExists(para1: JLString): jboolean; overload; virtual; abstract;  // throws java.util.prefs.BackingStoreException
    procedure removeNode(); overload; virtual; abstract;  // throws java.util.prefs.BackingStoreException
    function name(): JLString; overload; virtual; abstract;
    function absolutePath(): JLString; overload; virtual; abstract;
    function isUserNode(): jboolean; overload; virtual; abstract;
    function toString(): JLString; overload; virtual; abstract;
    procedure flush(); overload; virtual; abstract;  // throws java.util.prefs.BackingStoreException
    procedure sync(); overload; virtual; abstract;  // throws java.util.prefs.BackingStoreException
    procedure addPreferenceChangeListener(para1: JUPPreferenceChangeListener); overload; virtual; abstract;
    procedure removePreferenceChangeListener(para1: JUPPreferenceChangeListener); overload; virtual; abstract;
    procedure addNodeChangeListener(para1: JUPNodeChangeListener); overload; virtual; abstract;
    procedure removeNodeChangeListener(para1: JUPNodeChangeListener); overload; virtual; abstract;
    procedure exportNode(para1: JIOutputStream); overload; virtual; abstract;  // throws java.io.IOException, java.util.prefs.BackingStoreException
    procedure exportSubtree(para1: JIOutputStream); overload; virtual; abstract;  // throws java.io.IOException, java.util.prefs.BackingStoreException
    class procedure importPreferences(para1: JIInputStream); static; overload;  // throws java.io.IOException, java.util.prefs.InvalidPreferencesFormatException
  end;

  JUPPreferencesFactory = interface external 'java.util.prefs' name 'PreferencesFactory' 
    function systemRoot(): JUPPreferences; overload;
    function userRoot(): JUPPreferences; overload;
  end;

  JUPXmlSupport = class external 'java.util.prefs' name 'XmlSupport' (JLObject)
  public
    type
      InnerEH = class;
      Arr1InnerEH = array of InnerEH;
      Arr2InnerEH = array of Arr1InnerEH;
      Arr3InnerEH = array of Arr2InnerEH;
      InnerResolver = class;
      Arr1InnerResolver = array of InnerResolver;
      Arr2InnerResolver = array of Arr1InnerResolver;
      Arr3InnerResolver = array of Arr2InnerResolver;
      InnerEH = class external 'java.util.prefs' name 'EH' 
      end;

      InnerResolver = class external 'java.util.prefs' name 'Resolver' 
      end;

  end;

  JURASCII = class sealed external 'java.util.regex' name 'ASCII' (JLObject)
  end;

  JURMatchResult = interface external 'java.util.regex' name 'MatchResult' 
    function start(): jint; overload;
    function start(para1: jint): jint; overload;
    function &end(): jint; overload;
    function &end(para1: jint): jint; overload;
    function group(): JLString; overload;
    function group(para1: jint): JLString; overload;
    function groupCount(): jint; overload;
  end;

  JUSLocaleServiceProvider = class abstract external 'java.util.spi' name 'LocaleServiceProvider' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function getAvailableLocales(): Arr1JULocale; overload; virtual; abstract;
  end;

  JUZChecksum = interface external 'java.util.zip' name 'Checksum' 
    procedure update(para1: jint); overload;
    procedure update(para1: Arr1jbyte; para2: jint; para3: jint); overload;
    procedure update(var para1: array of jbyte; para2: jint; para3: jint); overload;
    function getValue(): jlong; overload;
    procedure reset(); overload;
  end;

  JUZDeflater = class external 'java.util.zip' name 'Deflater' (JLObject)
  public
    const
      DEFLATED = 8;
      NO_COMPRESSION = 0;
      BEST_SPEED = 1;
      BEST_COMPRESSION = 9;
      DEFAULT_COMPRESSION = -1;
      FILTERED = 1;
      HUFFMAN_ONLY = 2;
      DEFAULT_STRATEGY = 0;
  public
    constructor create(para1: jint; para2: jboolean); overload;
    constructor create(para1: jint); overload;
    constructor create(); overload;
    procedure setInput(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setInput(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setInput(para1: Arr1jbyte); overload; virtual;
    procedure setInput(var para1: array of jbyte); overload; virtual;
    procedure setDictionary(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setDictionary(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setDictionary(para1: Arr1jbyte); overload; virtual;
    procedure setDictionary(var para1: array of jbyte); overload; virtual;
    procedure setStrategy(para1: jint); overload; virtual;
    procedure setLevel(para1: jint); overload; virtual;
    function needsInput(): jboolean; overload; virtual;
    procedure finish(); overload; virtual;
    function finished(): jboolean; overload; virtual;
    function deflate(para1: Arr1jbyte; para2: jint; para3: jint): jint; overload; virtual;
    function deflate(var para1: array of jbyte; para2: jint; para3: jint): jint; overload; virtual;
    function deflate(para1: Arr1jbyte): jint; overload; virtual;
    function deflate(var para1: array of jbyte): jint; overload; virtual;
    function getAdler(): jint; overload; virtual;
    function getTotalIn(): jint; overload; virtual;
    function getBytesRead(): jlong; overload; virtual;
    function getTotalOut(): jint; overload; virtual;
    function getBytesWritten(): jlong; overload; virtual;
    procedure reset(); overload; virtual;
    procedure &end(); overload; virtual;
  strict protected
    procedure finalize(); overload; virtual;
  end;

  JUZInflater = class external 'java.util.zip' name 'Inflater' (JLObject)
  public
    constructor create(para1: jboolean); overload;
    constructor create(); overload;
    procedure setInput(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setInput(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setInput(para1: Arr1jbyte); overload; virtual;
    procedure setInput(var para1: array of jbyte); overload; virtual;
    procedure setDictionary(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setDictionary(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual;
    procedure setDictionary(para1: Arr1jbyte); overload; virtual;
    procedure setDictionary(var para1: array of jbyte); overload; virtual;
    function getRemaining(): jint; overload; virtual;
    function needsInput(): jboolean; overload; virtual;
    function needsDictionary(): jboolean; overload; virtual;
    function finished(): jboolean; overload; virtual;
    function inflate(para1: Arr1jbyte; para2: jint; para3: jint): jint; overload; virtual;  // throws java.util.zip.DataFormatException
    function inflate(var para1: array of jbyte; para2: jint; para3: jint): jint; overload; virtual;  // throws java.util.zip.DataFormatException
    function inflate(para1: Arr1jbyte): jint; overload; virtual;  // throws java.util.zip.DataFormatException
    function inflate(var para1: array of jbyte): jint; overload; virtual;  // throws java.util.zip.DataFormatException
    function getAdler(): jint; overload; virtual;
    function getTotalIn(): jint; overload; virtual;
    function getBytesRead(): jlong; overload; virtual;
    function getTotalOut(): jint; overload; virtual;
    function getBytesWritten(): jlong; overload; virtual;
    procedure reset(); overload; virtual;
    procedure &end(); overload; virtual;
  strict protected
    procedure finalize(); overload; virtual;
  end;

  JUZZStreamRef = class external 'java.util.zip' name 'ZStreamRef' (JLObject)
  end;

  JUZZipConstants = interface external 'java.util.zip' name 'ZipConstants' 
    const
      LOCSIG = jlong(67324752);
      EXTSIG = jlong(134695760);
      CENSIG = jlong(33639248);
      ENDSIG = jlong(101010256);
      LOCHDR = 30;
      EXTHDR = 16;
      CENHDR = 46;
      ENDHDR = 22;
      LOCVER = 4;
      LOCFLG = 6;
      LOCHOW = 8;
      LOCTIM = 10;
      LOCCRC = 14;
      LOCSIZ = 18;
      LOCLEN = 22;
      LOCNAM = 26;
      LOCEXT = 28;
      EXTCRC = 4;
      EXTSIZ = 8;
      EXTLEN = 12;
      CENVEM = 4;
      CENVER = 6;
      CENFLG = 8;
      CENHOW = 10;
      CENTIM = 12;
      CENCRC = 16;
      CENSIZ = 20;
      CENLEN = 24;
      CENNAM = 28;
      CENEXT = 30;
      CENCOM = 32;
      CENDSK = 34;
      CENATT = 36;
      CENATX = 38;
      CENOFF = 42;
      ENDSUB = 8;
      ENDTOT = 10;
      ENDSIZ = 12;
      ENDOFF = 16;
      ENDCOM = 20;
  end;

  JAAccessible = interface external 'javax.accessibility' name 'Accessible' 
    function getAccessibleContext(): JAAccessibleContext; overload;
  end;

  JAAccessibleAction = interface external 'javax.accessibility' name 'AccessibleAction' 
    final class var
      fTOGGLE_EXPAND: JLString; external name 'TOGGLE_EXPAND';
      fINCREMENT: JLString; external name 'INCREMENT';
      fDECREMENT: JLString; external name 'DECREMENT';
      fCLICK: JLString; external name 'CLICK';
      fTOGGLE_POPUP: JLString; external name 'TOGGLE_POPUP';
    function getAccessibleActionCount(): jint; overload;
    function getAccessibleActionDescription(para1: jint): JLString; overload;
    function doAccessibleAction(para1: jint): jboolean; overload;
  end;

  JAAccessibleAttributeSequence = class external 'javax.accessibility' name 'AccessibleAttributeSequence' (JLObject)
  public
    var
      fstartIndex: jint; external name 'startIndex';
      fendIndex: jint; external name 'endIndex';
      fattributes: JSTAttributeSet; external name 'attributes';
  public
    constructor create(para1: jint; para2: jint; para3: JSTAttributeSet); overload;
  end;

  JAAccessibleBundle = class abstract external 'javax.accessibility' name 'AccessibleBundle' (JLObject)
  strict protected
    var
      fkey: JLString; external name 'key';
  public
    constructor create(); overload;
  strict protected
    function toDisplayString(para1: JLString; para2: JULocale): JLString; overload; virtual;
  public
    function toDisplayString(para1: JULocale): JLString; overload; virtual;
    function toDisplayString(): JLString; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JAAccessibleComponent = interface external 'javax.accessibility' name 'AccessibleComponent' 
    function getBackground(): JAColor; overload;
    procedure setBackground(para1: JAColor); overload;
    function getForeground(): JAColor; overload;
    procedure setForeground(para1: JAColor); overload;
    function getCursor(): JACursor; overload;
    procedure setCursor(para1: JACursor); overload;
    function getFont(): JAFont; overload;
    procedure setFont(para1: JAFont); overload;
    function getFontMetrics(para1: JAFont): JAFontMetrics; overload;
    function isEnabled(): jboolean; overload;
    procedure setEnabled(para1: jboolean); overload;
    function isVisible(): jboolean; overload;
    procedure setVisible(para1: jboolean); overload;
    function isShowing(): jboolean; overload;
    function contains(para1: JAPoint): jboolean; overload;
    function getLocationOnScreen(): JAPoint; overload;
    function getLocation(): JAPoint; overload;
    procedure setLocation(para1: JAPoint); overload;
    function getBounds(): JARectangle; overload;
    procedure setBounds(para1: JARectangle); overload;
    function getSize(): JADimension; overload;
    procedure setSize(para1: JADimension); overload;
    function getAccessibleAt(para1: JAPoint): JAAccessible; overload;
    function isFocusTraversable(): jboolean; overload;
    procedure requestFocus(); overload;
    procedure addFocusListener(para1: JAEFocusListener); overload;
    procedure removeFocusListener(para1: JAEFocusListener); overload;
  end;

  JAAccessibleContext = class abstract external 'javax.accessibility' name 'AccessibleContext' (JLObject)
  public
    const
      ACCESSIBLE_NAME_PROPERTY = 'AccessibleName';
      ACCESSIBLE_DESCRIPTION_PROPERTY = 'AccessibleDescription';
      ACCESSIBLE_STATE_PROPERTY = 'AccessibleState';
      ACCESSIBLE_VALUE_PROPERTY = 'AccessibleValue';
      ACCESSIBLE_SELECTION_PROPERTY = 'AccessibleSelection';
      ACCESSIBLE_CARET_PROPERTY = 'AccessibleCaret';
      ACCESSIBLE_VISIBLE_DATA_PROPERTY = 'AccessibleVisibleData';
      ACCESSIBLE_CHILD_PROPERTY = 'AccessibleChild';
      ACCESSIBLE_ACTIVE_DESCENDANT_PROPERTY = 'AccessibleActiveDescendant';
      ACCESSIBLE_TABLE_CAPTION_CHANGED = 'accessibleTableCaptionChanged';
      ACCESSIBLE_TABLE_SUMMARY_CHANGED = 'accessibleTableSummaryChanged';
      ACCESSIBLE_TABLE_MODEL_CHANGED = 'accessibleTableModelChanged';
      ACCESSIBLE_TABLE_ROW_HEADER_CHANGED = 'accessibleTableRowHeaderChanged';
      ACCESSIBLE_TABLE_ROW_DESCRIPTION_CHANGED = 'accessibleTableRowDescriptionChanged';
      ACCESSIBLE_TABLE_COLUMN_HEADER_CHANGED = 'accessibleTableColumnHeaderChanged';
      ACCESSIBLE_TABLE_COLUMN_DESCRIPTION_CHANGED = 'accessibleTableColumnDescriptionChanged';
      ACCESSIBLE_ACTION_PROPERTY = 'accessibleActionProperty';
      ACCESSIBLE_HYPERTEXT_OFFSET = 'AccessibleHypertextOffset';
      ACCESSIBLE_TEXT_PROPERTY = 'AccessibleText';
      ACCESSIBLE_INVALIDATE_CHILDREN = 'accessibleInvalidateChildren';
      ACCESSIBLE_TEXT_ATTRIBUTES_CHANGED = 'accessibleTextAttributesChanged';
      ACCESSIBLE_COMPONENT_BOUNDS_CHANGED = 'accessibleComponentBoundsChanged';
  strict protected
    var
      faccessibleParent: JAAccessible; external name 'accessibleParent';
      faccessibleName: JLString; external name 'accessibleName';
      faccessibleDescription: JLString; external name 'accessibleDescription';
  public
    constructor create(); overload;
    function getAccessibleName(): JLString; overload; virtual;
    procedure setAccessibleName(para1: JLString); overload; virtual;
    function getAccessibleDescription(): JLString; overload; virtual;
    procedure setAccessibleDescription(para1: JLString); overload; virtual;
    function getAccessibleRole(): JAAccessibleRole; overload; virtual; abstract;
    function getAccessibleStateSet(): JAAccessibleStateSet; overload; virtual; abstract;
    function getAccessibleParent(): JAAccessible; overload; virtual;
    procedure setAccessibleParent(para1: JAAccessible); overload; virtual;
    function getAccessibleIndexInParent(): jint; overload; virtual; abstract;
    function getAccessibleChildrenCount(): jint; overload; virtual; abstract;
    function getAccessibleChild(para1: jint): JAAccessible; overload; virtual; abstract;
    function getLocale(): JULocale; overload; virtual; abstract;  // throws java.awt.IllegalComponentStateException
    procedure addPropertyChangeListener(para1: JBPropertyChangeListener); overload; virtual;
    procedure removePropertyChangeListener(para1: JBPropertyChangeListener); overload; virtual;
    function getAccessibleAction(): JAAccessibleAction; overload; virtual;
    function getAccessibleComponent(): JAAccessibleComponent; overload; virtual;
    function getAccessibleSelection(): JAAccessibleSelection; overload; virtual;
    function getAccessibleText(): JAAccessibleText; overload; virtual;
    function getAccessibleEditableText(): JAAccessibleEditableText; overload; virtual;
    function getAccessibleValue(): JAAccessibleValue; overload; virtual;
    function getAccessibleIcon(): Arr1JAAccessibleIcon; overload; virtual;
    function getAccessibleRelationSet(): JAAccessibleRelationSet; overload; virtual;
    function getAccessibleTable(): JAAccessibleTable; overload; virtual;
    procedure firePropertyChange(para1: JLString; para2: JLObject; para3: JLObject); overload; virtual;
  end;

  JAAccessibleExtendedText = interface external 'javax.accessibility' name 'AccessibleExtendedText' 
    const
      LINE = 4;
      ATTRIBUTE_RUN = 5;
    function getTextRange(para1: jint; para2: jint): JLString; overload;
    function getTextSequenceAt(para1: jint; para2: jint): JAAccessibleTextSequence; overload;
    function getTextSequenceAfter(para1: jint; para2: jint): JAAccessibleTextSequence; overload;
    function getTextSequenceBefore(para1: jint; para2: jint): JAAccessibleTextSequence; overload;
    function getTextBounds(para1: jint; para2: jint): JARectangle; overload;
  end;

  JAAccessibleIcon = interface external 'javax.accessibility' name 'AccessibleIcon' 
    function getAccessibleIconDescription(): JLString; overload;
    procedure setAccessibleIconDescription(para1: JLString); overload;
    function getAccessibleIconWidth(): jint; overload;
    function getAccessibleIconHeight(): jint; overload;
  end;

  JAAccessibleKeyBinding = interface external 'javax.accessibility' name 'AccessibleKeyBinding' 
    function getAccessibleKeyBindingCount(): jint; overload;
    function getAccessibleKeyBinding(para1: jint): JLObject; overload;
  end;

  JAAccessibleRelationSet = class external 'javax.accessibility' name 'AccessibleRelationSet' (JLObject)
  strict protected
    var
      frelations: JUVector; external name 'relations';
  public
    constructor create(); overload;
    constructor create(para1: Arr1JAAccessibleRelation); overload;
    constructor create(const para1: array of JAAccessibleRelation); overload;
    function add(para1: JAAccessibleRelation): jboolean; overload; virtual;
    procedure addAll(para1: Arr1JAAccessibleRelation); overload; virtual;
    procedure addAll(var para1: array of JAAccessibleRelation); overload; virtual;
    function remove(para1: JAAccessibleRelation): jboolean; overload; virtual;
    procedure clear(); overload; virtual;
    function size(): jint; overload; virtual;
    function contains(para1: JLString): jboolean; overload; virtual;
    function get(para1: JLString): JAAccessibleRelation; overload; virtual;
    function toArray(): Arr1JAAccessibleRelation; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JAAccessibleSelection = interface external 'javax.accessibility' name 'AccessibleSelection' 
    function getAccessibleSelectionCount(): jint; overload;
    function getAccessibleSelection(para1: jint): JAAccessible; overload;
    function isAccessibleChildSelected(para1: jint): jboolean; overload;
    procedure addAccessibleSelection(para1: jint); overload;
    procedure removeAccessibleSelection(para1: jint); overload;
    procedure clearAccessibleSelection(); overload;
    procedure selectAllAccessibleSelection(); overload;
  end;

  JAAccessibleStateSet = class external 'javax.accessibility' name 'AccessibleStateSet' (JLObject)
  strict protected
    var
      fstates: JUVector; external name 'states';
  public
    constructor create(); overload;
    constructor create(para1: Arr1JAAccessibleState); overload;
    constructor create(const para1: array of JAAccessibleState); overload;
    function add(para1: JAAccessibleState): jboolean; overload; virtual;
    procedure addAll(para1: Arr1JAAccessibleState); overload; virtual;
    procedure addAll(var para1: array of JAAccessibleState); overload; virtual;
    function remove(para1: JAAccessibleState): jboolean; overload; virtual;
    procedure clear(); overload; virtual;
    function contains(para1: JAAccessibleState): jboolean; overload; virtual;
    function toArray(): Arr1JAAccessibleState; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JAAccessibleStreamable = interface external 'javax.accessibility' name 'AccessibleStreamable' 
    function getMimeTypes(): Arr1JADDataFlavor; overload;
    function getStream(para1: JADDataFlavor): JIInputStream; overload;
  end;

  JAAccessibleTable = interface external 'javax.accessibility' name 'AccessibleTable' 
    function getAccessibleCaption(): JAAccessible; overload;
    procedure setAccessibleCaption(para1: JAAccessible); overload;
    function getAccessibleSummary(): JAAccessible; overload;
    procedure setAccessibleSummary(para1: JAAccessible); overload;
    function getAccessibleRowCount(): jint; overload;
    function getAccessibleColumnCount(): jint; overload;
    function getAccessibleAt(para1: jint; para2: jint): JAAccessible; overload;
    function getAccessibleRowExtentAt(para1: jint; para2: jint): jint; overload;
    function getAccessibleColumnExtentAt(para1: jint; para2: jint): jint; overload;
    function getAccessibleRowHeader(): JAAccessibleTable; overload;
    procedure setAccessibleRowHeader(para1: JAAccessibleTable); overload;
    function getAccessibleColumnHeader(): JAAccessibleTable; overload;
    procedure setAccessibleColumnHeader(para1: JAAccessibleTable); overload;
    function getAccessibleRowDescription(para1: jint): JAAccessible; overload;
    procedure setAccessibleRowDescription(para1: jint; para2: JAAccessible); overload;
    function getAccessibleColumnDescription(para1: jint): JAAccessible; overload;
    procedure setAccessibleColumnDescription(para1: jint; para2: JAAccessible); overload;
    function isAccessibleSelected(para1: jint; para2: jint): jboolean; overload;
    function isAccessibleRowSelected(para1: jint): jboolean; overload;
    function isAccessibleColumnSelected(para1: jint): jboolean; overload;
    function getSelectedAccessibleRows(): Arr1jint; overload;
    function getSelectedAccessibleColumns(): Arr1jint; overload;
  end;

  JAAccessibleTableModelChange = interface external 'javax.accessibility' name 'AccessibleTableModelChange' 
    const
      INSERT = 1;
      UPDATE = 0;
      DELETE = -1;
    function getType(): jint; overload;
    function getFirstRow(): jint; overload;
    function getLastRow(): jint; overload;
    function getFirstColumn(): jint; overload;
    function getLastColumn(): jint; overload;
  end;

  JAAccessibleText = interface external 'javax.accessibility' name 'AccessibleText' 
    const
      CHARACTER = 1;
      WORD = 2;
      SENTENCE = 3;
    function getIndexAtPoint(para1: JAPoint): jint; overload;
    function getCharacterBounds(para1: jint): JARectangle; overload;
    function getCharCount(): jint; overload;
    function getCaretPosition(): jint; overload;
    function getAtIndex(para1: jint; para2: jint): JLString; overload;
    function getAfterIndex(para1: jint; para2: jint): JLString; overload;
    function getBeforeIndex(para1: jint; para2: jint): JLString; overload;
    function getCharacterAttribute(para1: jint): JSTAttributeSet; overload;
    function getSelectionStart(): jint; overload;
    function getSelectionEnd(): jint; overload;
    function getSelectedText(): JLString; overload;
  end;

  JAAccessibleTextSequence = class external 'javax.accessibility' name 'AccessibleTextSequence' (JLObject)
  public
    var
      fstartIndex: jint; external name 'startIndex';
      fendIndex: jint; external name 'endIndex';
      ftext: JLString; external name 'text';
  public
    constructor create(para1: jint; para2: jint; para3: JLString); overload;
  end;

  JAAccessibleValue = interface external 'javax.accessibility' name 'AccessibleValue' 
    function getCurrentAccessibleValue(): JLNumber; overload;
    function setCurrentAccessibleValue(para1: JLNumber): jboolean; overload;
    function getMinimumAccessibleValue(): JLNumber; overload;
    function getMaximumAccessibleValue(): JLNumber; overload;
  end;

  JACommandInfo = class external 'javax.activation' name 'CommandInfo' (JLObject)
  public
    constructor create(para1: JLString; para2: JLString); overload;
    function getCommandName(): JLString; overload; virtual;
    function getCommandClass(): JLString; overload; virtual;
    function getCommandObject(para1: JADataHandler; para2: JLClassLoader): JLObject; overload; virtual;  // throws java.io.IOException, java.lang.ClassNotFoundException
  end;

  JACommandMap = class abstract external 'javax.activation' name 'CommandMap' (JLObject)
  public
    constructor create(); overload;
    class function getDefaultCommandMap(): JACommandMap; static; overload;
    class procedure setDefaultCommandMap(para1: JACommandMap); static; overload;
    function getPreferredCommands(para1: JLString): Arr1JACommandInfo; overload; virtual; abstract;
    function getPreferredCommands(para1: JLString; para2: JADataSource): Arr1JACommandInfo; overload; virtual;
    function getAllCommands(para1: JLString): Arr1JACommandInfo; overload; virtual; abstract;
    function getAllCommands(para1: JLString; para2: JADataSource): Arr1JACommandInfo; overload; virtual;
    function getCommand(para1: JLString; para2: JLString): JACommandInfo; overload; virtual; abstract;
    function getCommand(para1: JLString; para2: JLString; para3: JADataSource): JACommandInfo; overload; virtual;
    function createDataContentHandler(para1: JLString): JADataContentHandler; overload; virtual; abstract;
    function createDataContentHandler(para1: JLString; para2: JADataSource): JADataContentHandler; overload; virtual;
    function getMimeTypes(): Arr1JLString; overload; virtual;
  end;

  JACommandObject = interface external 'javax.activation' name 'CommandObject' 
    procedure setCommandContext(para1: JLString; para2: JADataHandler); overload;  // throws java.io.IOException
  end;

  JADataContentHandler = interface external 'javax.activation' name 'DataContentHandler' 
    function getTransferDataFlavors(): Arr1JADDataFlavor; overload;
    function getTransferData(para1: JADDataFlavor; para2: JADataSource): JLObject; overload;  // throws java.awt.datatransfer.UnsupportedFlavorException, java.io.IOException
    function getContent(para1: JADataSource): JLObject; overload;  // throws java.io.IOException
    procedure writeTo(para1: JLObject; para2: JLString; para3: JIOutputStream); overload;  // throws java.io.IOException
  end;

  JADataContentHandlerFactory = interface external 'javax.activation' name 'DataContentHandlerFactory' 
    function createDataContentHandler(para1: JLString): JADataContentHandler; overload;
  end;

  JADataSource = interface external 'javax.activation' name 'DataSource' 
    function getInputStream(): JIInputStream; overload;  // throws java.io.IOException
    function getOutputStream(): JIOutputStream; overload;  // throws java.io.IOException
    function getContentType(): JLString; overload;
    function getName(): JLString; overload;
  end;

  JAFileTypeMap = class abstract external 'javax.activation' name 'FileTypeMap' (JLObject)
  public
    constructor create(); overload;
    function getContentType(para1: JIFile): JLString; overload; virtual; abstract;
    function getContentType(para1: JLString): JLString; overload; virtual; abstract;
    class procedure setDefaultFileTypeMap(para1: JAFileTypeMap); static; overload;
    class function getDefaultFileTypeMap(): JAFileTypeMap; static; overload;
  end;

  JAMimeTypeParameterList = class external 'javax.activation' name 'MimeTypeParameterList' (JLObject)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;  // throws javax.activation.MimeTypeParseException
  strict protected
    procedure parse(para1: JLString); overload; virtual;  // throws javax.activation.MimeTypeParseException
  public
    function size(): jint; overload; virtual;
    function isEmpty(): jboolean; overload; virtual;
    function get(para1: JLString): JLString; overload; virtual;
    procedure &set(para1: JLString; para2: JLString); overload; virtual;
    procedure remove(para1: JLString); overload; virtual;
    function getNames(): JUEnumeration; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JASecuritySupport = class external 'javax.activation' name 'SecuritySupport' (JLObject)
  public
    class function getContextClassLoader(): JLClassLoader; static; overload;
    class function getResourceAsStream(para1: JLClass; para2: JLString): JIInputStream; static; overload;  // throws java.io.IOException
    class function getResources(para1: JLClassLoader; para2: JLString): Arr1JNURL; static; overload;
    class function getSystemResources(para1: JLString): Arr1JNURL; static; overload;
    class function openStream(para1: JNURL): JIInputStream; static; overload;  // throws java.io.IOException
  end;

  JAPCompletion = interface external 'javax.annotation.processing' name 'Completion' 
    function getValue(): JLString; overload;
    function getMessage(): JLString; overload;
  end;

  JAPCompletions = class external 'javax.annotation.processing' name 'Completions' (JLObject)
  public
    type
      InnerSimpleCompletion = class;
      Arr1InnerSimpleCompletion = array of InnerSimpleCompletion;
      Arr2InnerSimpleCompletion = array of Arr1InnerSimpleCompletion;
      Arr3InnerSimpleCompletion = array of Arr2InnerSimpleCompletion;
      InnerSimpleCompletion = class external 'javax.annotation.processing' name 'SimpleCompletion' 
      end;

  public
    class function &of(para1: JLString; para2: JLString): JAPCompletion; static; overload;
    class function &of(para1: JLString): JAPCompletion; static; overload;
  end;

  JAPProcessingEnvironment = interface external 'javax.annotation.processing' name 'ProcessingEnvironment' 
    function getOptions(): JUMap; overload;
    function getMessager(): JAPMessager; overload;
    function getFiler(): JAPFiler; overload;
    function getElementUtils(): JLMUElements; overload;
    function getTypeUtils(): JLMUTypes; overload;
    function getSourceVersion(): JLMSourceVersion; overload;
    function getLocale(): JULocale; overload;
  end;

  JAPProcessor = interface external 'javax.annotation.processing' name 'Processor' 
    function getSupportedOptions(): JUSet; overload;
    function getSupportedAnnotationTypes(): JUSet; overload;
    function getSupportedSourceVersion(): JLMSourceVersion; overload;
    procedure init(para1: JAPProcessingEnvironment); overload;
    function process(para1: JUSet; para2: JAPRoundEnvironment): jboolean; overload;
    function getCompletions(para1: JLMEElement; para2: JLMEAnnotationMirror; para3: JLMEExecutableElement; para4: JLString): JLIterable; overload;
  end;

  JAPRoundEnvironment = interface external 'javax.annotation.processing' name 'RoundEnvironment' 
    function processingOver(): jboolean; overload;
    function errorRaised(): jboolean; overload;
    function getRootElements(): JUSet; overload;
    function getElementsAnnotatedWith(para1: JLMETypeElement): JUSet; overload;
    function getElementsAnnotatedWith(para1: JLClass): JUSet; overload;
  end;

  JCCipher = class external 'javax.crypto' name 'Cipher' (JLObject)
  public
    type
      Innerr = class;
      Arr1Innerr = array of Innerr;
      Arr2Innerr = array of Arr1Innerr;
      Arr3Innerr = array of Arr2Innerr;
      Innerr = class external 'javax.crypto' name 'r' 
      end;

  public
    const
      ENCRYPT_MODE = 1;
      DECRYPT_MODE = 2;
      WRAP_MODE = 3;
      UNWRAP_MODE = 4;
      PUBLIC_KEY = 1;
      PRIVATE_KEY = 2;
      SECRET_KEY = 3;
  strict protected
    constructor create(para1: JCCipherSpi; para2: JSProvider; para3: JLString); overload;
  public
    class function getInstance(para1: JLString): JCCipher; static; overload; final;  // throws java.security.NoSuchAlgorithmException, javax.crypto.NoSuchPaddingException
    class function getInstance(para1: JLString; para2: JLString): JCCipher; static; overload; final;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException, javax.crypto.NoSuchPaddingException
    class function getInstance(para1: JLString; para2: JSProvider): JCCipher; static; overload; final;  // throws java.security.NoSuchAlgorithmException, javax.crypto.NoSuchPaddingException
    function getProvider(): JSProvider; overload; virtual; final;
    function getAlgorithm(): JLString; overload; virtual; final;
    function getBlockSize(): jint; overload; virtual; final;
    function getOutputSize(para1: jint): jint; overload; virtual; final;
    function getIV(): Arr1jbyte; overload; virtual; final;
    function getParameters(): JSAlgorithmParameters; overload; virtual; final;
    function getExemptionMechanism(): JCExemptionMechanism; overload; virtual; final;
    procedure init(para1: jint; para2: JSKey); overload; virtual; final;  // throws java.security.InvalidKeyException
    procedure init(para1: jint; para2: JSKey; para3: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidKeyException
    procedure init(para1: jint; para2: JSKey; para3: JSSAlgorithmParameterSpec); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    procedure init(para1: jint; para2: JSKey; para3: JSSAlgorithmParameterSpec; para4: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    procedure init(para1: jint; para2: JSKey; para3: JSAlgorithmParameters); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    procedure init(para1: jint; para2: JSKey; para3: JSAlgorithmParameters; para4: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    procedure init(para1: jint; para2: JSCCertificate); overload; virtual; final;  // throws java.security.InvalidKeyException
    procedure init(para1: jint; para2: JSCCertificate; para3: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidKeyException
    function update(para1: Arr1jbyte): Arr1jbyte; overload; virtual; final;
    function update(var para1: array of jbyte): Arr1jbyte; overload; virtual; final;
    function update(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; final;
    function update(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; final;
    function update(para1: Arr1jbyte; para2: jint; para3: jint; para4: Arr1jbyte): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException
    function update(var para1: array of jbyte; para2: jint; para3: jint; var para4: array of jbyte): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException
    function update(para1: Arr1jbyte; para2: jint; para3: jint; para4: Arr1jbyte; para5: jint): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException
    function update(var para1: array of jbyte; para2: jint; para3: jint; var para4: array of jbyte; para5: jint): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException
    function update(para1: JNByteBuffer; para2: JNByteBuffer): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException
    function doFinal(): Arr1jbyte; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(para1: Arr1jbyte; para2: jint): jint; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.ShortBufferException, javax.crypto.BadPaddingException
    function doFinal(var para1: array of jbyte; para2: jint): jint; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.ShortBufferException, javax.crypto.BadPaddingException
    function doFinal(para1: Arr1jbyte): Arr1jbyte; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(var para1: array of jbyte): Arr1jbyte; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(para1: Arr1jbyte; para2: jint; para3: jint; para4: Arr1jbyte): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(var para1: array of jbyte; para2: jint; para3: jint; var para4: array of jbyte): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(para1: Arr1jbyte; para2: jint; para3: jint; para4: Arr1jbyte; para5: jint): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(var para1: array of jbyte; para2: jint; para3: jint; var para4: array of jbyte; para5: jint): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function doFinal(para1: JNByteBuffer; para2: JNByteBuffer): jint; overload; virtual; final;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function wrap(para1: JSKey): Arr1jbyte; overload; virtual; final;  // throws javax.crypto.IllegalBlockSizeException, java.security.InvalidKeyException
    function unwrap(para1: Arr1jbyte; para2: JLString; para3: jint): JSKey; overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.NoSuchAlgorithmException
    function unwrap(var para1: array of jbyte; para2: JLString; para3: jint): JSKey; overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.NoSuchAlgorithmException
    class function getMaxAllowedKeyLength(para1: JLString): jint; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    class function getMaxAllowedParameterSpec(para1: JLString): JSSAlgorithmParameterSpec; static; overload; final;  // throws java.security.NoSuchAlgorithmException
  end;

  JCCipherSpi = class abstract external 'javax.crypto' name 'CipherSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineSetMode(para1: JLString); overload; virtual; abstract;  // throws java.security.NoSuchAlgorithmException
    procedure engineSetPadding(para1: JLString); overload; virtual; abstract;  // throws javax.crypto.NoSuchPaddingException
    function engineGetBlockSize(): jint; overload; virtual; abstract;
    function engineGetOutputSize(para1: jint): jint; overload; virtual; abstract;
    function engineGetIV(): Arr1jbyte; overload; virtual; abstract;
    function engineGetParameters(): JSAlgorithmParameters; overload; virtual; abstract;
    procedure engineInit(para1: jint; para2: JSKey; para3: JSSecureRandom); overload; virtual; abstract;  // throws java.security.InvalidKeyException
    procedure engineInit(para1: jint; para2: JSKey; para3: JSSAlgorithmParameterSpec; para4: JSSecureRandom); overload; virtual; abstract;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    procedure engineInit(para1: jint; para2: JSKey; para3: JSAlgorithmParameters; para4: JSSecureRandom); overload; virtual; abstract;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    function engineUpdate(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; abstract;
    function engineUpdate(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; abstract;
    function engineUpdate(para1: Arr1jbyte; para2: jint; para3: jint; para4: Arr1jbyte; para5: jint): jint; overload; virtual; abstract;  // throws javax.crypto.ShortBufferException
    function engineUpdate(var para1: array of jbyte; para2: jint; para3: jint; var para4: array of jbyte; para5: jint): jint; overload; virtual; abstract;  // throws javax.crypto.ShortBufferException
    function engineUpdate(para1: JNByteBuffer; para2: JNByteBuffer): jint; overload; virtual;  // throws javax.crypto.ShortBufferException
    function engineDoFinal(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; abstract;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function engineDoFinal(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload; virtual; abstract;  // throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function engineDoFinal(para1: Arr1jbyte; para2: jint; para3: jint; para4: Arr1jbyte; para5: jint): jint; overload; virtual; abstract;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function engineDoFinal(var para1: array of jbyte; para2: jint; para3: jint; var para4: array of jbyte; para5: jint): jint; overload; virtual; abstract;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function engineDoFinal(para1: JNByteBuffer; para2: JNByteBuffer): jint; overload; virtual;  // throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException
    function engineWrap(para1: JSKey): Arr1jbyte; overload; virtual;  // throws javax.crypto.IllegalBlockSizeException, java.security.InvalidKeyException
    function engineUnwrap(para1: Arr1jbyte; para2: JLString; para3: jint): JSKey; overload; virtual;  // throws java.security.InvalidKeyException, java.security.NoSuchAlgorithmException
    function engineUnwrap(var para1: array of jbyte; para2: JLString; para3: jint): JSKey; overload; virtual;  // throws java.security.InvalidKeyException, java.security.NoSuchAlgorithmException
    function engineGetKeySize(para1: JSKey): jint; overload; virtual;  // throws java.security.InvalidKeyException
  end;

  JCEncryptedPrivateKeyInfo = class external 'javax.crypto' name 'EncryptedPrivateKeyInfo' (JLObject)
  public
    constructor create(para1: Arr1jbyte); overload;  // throws java.io.IOException
    constructor create(const para1: array of jbyte); overload;  // throws java.io.IOException
    constructor create(para1: JLString; para2: Arr1jbyte); overload;  // throws java.security.NoSuchAlgorithmException
    constructor create(para1: JLString; const para2: array of jbyte); overload;  // throws java.security.NoSuchAlgorithmException
    constructor create(para1: JSAlgorithmParameters; para2: Arr1jbyte); overload;  // throws java.security.NoSuchAlgorithmException
    constructor create(para1: JSAlgorithmParameters; const para2: array of jbyte); overload;  // throws java.security.NoSuchAlgorithmException
    function getAlgName(): JLString; overload; virtual;
    function getAlgParameters(): JSAlgorithmParameters; overload; virtual;
    function getEncryptedData(): Arr1jbyte; overload; virtual;
    function getKeySpec(para1: JCCipher): JSSPKCS8EncodedKeySpec; overload; virtual;  // throws java.security.spec.InvalidKeySpecException
    function getKeySpec(para1: JSKey): JSSPKCS8EncodedKeySpec; overload; virtual;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidKeyException
    function getKeySpec(para1: JSKey; para2: JLString): JSSPKCS8EncodedKeySpec; overload; virtual;  // throws java.security.NoSuchProviderException, java.security.NoSuchAlgorithmException, java.security.InvalidKeyException
    function getKeySpec(para1: JSKey; para2: JSProvider): JSSPKCS8EncodedKeySpec; overload; virtual;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidKeyException
    function getEncoded(): Arr1jbyte; overload; virtual;  // throws java.io.IOException
  end;

  JCExemptionMechanism = class external 'javax.crypto' name 'ExemptionMechanism' (JLObject)
  strict protected
    constructor create(para1: JCExemptionMechanismSpi; para2: JSProvider; para3: JLString); overload;
  public
    function getName(): JLString; overload; virtual; final;
    class function getInstance(para1: JLString): JCExemptionMechanism; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JCExemptionMechanism; static; overload; final;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JCExemptionMechanism; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    function isCryptoAllowed(para1: JSKey): jboolean; overload; virtual; final;  // throws javax.crypto.ExemptionMechanismException
    function getOutputSize(para1: jint): jint; overload; virtual; final;  // throws java.lang.IllegalStateException
    procedure init(para1: JSKey); overload; virtual; final;  // throws java.security.InvalidKeyException, javax.crypto.ExemptionMechanismException
    procedure init(para1: JSKey; para2: JSSAlgorithmParameterSpec); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException, javax.crypto.ExemptionMechanismException
    procedure init(para1: JSKey; para2: JSAlgorithmParameters); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException, javax.crypto.ExemptionMechanismException
    function genExemptionBlob(): Arr1jbyte; overload; virtual; final;  // throws java.lang.IllegalStateException, javax.crypto.ExemptionMechanismException
    function genExemptionBlob(para1: Arr1jbyte): jint; overload; virtual; final;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException, javax.crypto.ExemptionMechanismException
    function genExemptionBlob(var para1: array of jbyte): jint; overload; virtual; final;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException, javax.crypto.ExemptionMechanismException
    function genExemptionBlob(para1: Arr1jbyte; para2: jint): jint; overload; virtual; final;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException, javax.crypto.ExemptionMechanismException
    function genExemptionBlob(var para1: array of jbyte; para2: jint): jint; overload; virtual; final;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException, javax.crypto.ExemptionMechanismException
  strict protected
    procedure finalize(); overload; virtual;
  end;

  JCExemptionMechanismSpi = class abstract external 'javax.crypto' name 'ExemptionMechanismSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function engineGetOutputSize(para1: jint): jint; overload; virtual; abstract;
    procedure engineInit(para1: JSKey); overload; virtual; abstract;  // throws java.security.InvalidKeyException, javax.crypto.ExemptionMechanismException
    procedure engineInit(para1: JSKey; para2: JSSAlgorithmParameterSpec); overload; virtual; abstract;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException, javax.crypto.ExemptionMechanismException
    procedure engineInit(para1: JSKey; para2: JSAlgorithmParameters); overload; virtual; abstract;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException, javax.crypto.ExemptionMechanismException
    function engineGenExemptionBlob(): Arr1jbyte; overload; virtual; abstract;  // throws javax.crypto.ExemptionMechanismException
    function engineGenExemptionBlob(para1: Arr1jbyte; para2: jint): jint; overload; virtual; abstract;  // throws javax.crypto.ShortBufferException, javax.crypto.ExemptionMechanismException
    function engineGenExemptionBlob(var para1: array of jbyte; para2: jint): jint; overload; virtual; abstract;  // throws javax.crypto.ShortBufferException, javax.crypto.ExemptionMechanismException
  end;

  JCKeyAgreement = class external 'javax.crypto' name 'KeyAgreement' (JLObject)
  strict protected
    constructor create(para1: JCKeyAgreementSpi; para2: JSProvider; para3: JLString); overload;
  public
    function getAlgorithm(): JLString; overload; virtual; final;
    class function getInstance(para1: JLString): JCKeyAgreement; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JCKeyAgreement; static; overload; final;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JCKeyAgreement; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    procedure init(para1: JSKey); overload; virtual; final;  // throws java.security.InvalidKeyException
    procedure init(para1: JSKey; para2: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidKeyException
    procedure init(para1: JSKey; para2: JSSAlgorithmParameterSpec); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    procedure init(para1: JSKey; para2: JSSAlgorithmParameterSpec; para3: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    function doPhase(para1: JSKey; para2: jboolean): JSKey; overload; virtual; final;  // throws java.security.InvalidKeyException, java.lang.IllegalStateException
    function generateSecret(): Arr1jbyte; overload; virtual; final;  // throws java.lang.IllegalStateException
    function generateSecret(para1: Arr1jbyte; para2: jint): jint; overload; virtual; final;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException
    function generateSecret(var para1: array of jbyte; para2: jint): jint; overload; virtual; final;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException
    function generateSecret(para1: JLString): JCSecretKey; overload; virtual; final;  // throws java.lang.IllegalStateException, java.security.NoSuchAlgorithmException, java.security.InvalidKeyException
  end;

  JCKeyAgreementSpi = class abstract external 'javax.crypto' name 'KeyAgreementSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineInit(para1: JSKey; para2: JSSecureRandom); overload; virtual; abstract;  // throws java.security.InvalidKeyException
    procedure engineInit(para1: JSKey; para2: JSSAlgorithmParameterSpec; para3: JSSecureRandom); overload; virtual; abstract;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    function engineDoPhase(para1: JSKey; para2: jboolean): JSKey; overload; virtual; abstract;  // throws java.security.InvalidKeyException, java.lang.IllegalStateException
    function engineGenerateSecret(): Arr1jbyte; overload; virtual; abstract;  // throws java.lang.IllegalStateException
    function engineGenerateSecret(para1: Arr1jbyte; para2: jint): jint; overload; virtual; abstract;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException
    function engineGenerateSecret(var para1: array of jbyte; para2: jint): jint; overload; virtual; abstract;  // throws java.lang.IllegalStateException, javax.crypto.ShortBufferException
    function engineGenerateSecret(para1: JLString): JCSecretKey; overload; virtual; abstract;  // throws java.lang.IllegalStateException, java.security.NoSuchAlgorithmException, java.security.InvalidKeyException
  end;

  JCKeyGenerator = class external 'javax.crypto' name 'KeyGenerator' (JLObject)
  strict protected
    constructor create(para1: JCKeyGeneratorSpi; para2: JSProvider; para3: JLString); overload;
  public
    function getAlgorithm(): JLString; overload; virtual; final;
    class function getInstance(para1: JLString): JCKeyGenerator; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JCKeyGenerator; static; overload; final;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JCKeyGenerator; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    procedure init(para1: JSSecureRandom); overload; virtual; final;
    procedure init(para1: JSSAlgorithmParameterSpec); overload; virtual; final;  // throws java.security.InvalidAlgorithmParameterException
    procedure init(para1: JSSAlgorithmParameterSpec; para2: JSSecureRandom); overload; virtual; final;  // throws java.security.InvalidAlgorithmParameterException
    procedure init(para1: jint); overload; virtual; final;
    procedure init(para1: jint; para2: JSSecureRandom); overload; virtual; final;
    function generateKey(): JCSecretKey; overload; virtual; final;
  end;

  JCKeyGeneratorSpi = class abstract external 'javax.crypto' name 'KeyGeneratorSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineInit(para1: JSSecureRandom); overload; virtual; abstract;
    procedure engineInit(para1: JSSAlgorithmParameterSpec; para2: JSSecureRandom); overload; virtual; abstract;  // throws java.security.InvalidAlgorithmParameterException
    procedure engineInit(para1: jint; para2: JSSecureRandom); overload; virtual; abstract;
    function engineGenerateKey(): JCSecretKey; overload; virtual; abstract;
  end;

  JCMacSpi = class abstract external 'javax.crypto' name 'MacSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function engineGetMacLength(): jint; overload; virtual; abstract;
    procedure engineInit(para1: JSKey; para2: JSSAlgorithmParameterSpec); overload; virtual; abstract;  // throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException
    procedure engineUpdate(para1: jbyte); overload; virtual; abstract;
    procedure engineUpdate(para1: Arr1jbyte; para2: jint; para3: jint); overload; virtual; abstract;
    procedure engineUpdate(var para1: array of jbyte; para2: jint; para3: jint); overload; virtual; abstract;
    procedure engineUpdate(para1: JNByteBuffer); overload; virtual;
    function engineDoFinal(): Arr1jbyte; overload; virtual; abstract;
    procedure engineReset(); overload; virtual; abstract;
  public
    function clone(): JLObject; overload; virtual;  // throws java.lang.CloneNotSupportedException
  end;

  JCSecretKeyFactory = class external 'javax.crypto' name 'SecretKeyFactory' (JLObject)
  strict protected
    constructor create(para1: JCSecretKeyFactorySpi; para2: JSProvider; para3: JLString); overload;
  public
    class function getInstance(para1: JLString): JCSecretKeyFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JCSecretKeyFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JCSecretKeyFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    function getAlgorithm(): JLString; overload; virtual; final;
    function generateSecret(para1: JSSKeySpec): JCSecretKey; overload; virtual; final;  // throws java.security.spec.InvalidKeySpecException
    function getKeySpec(para1: JCSecretKey; para2: JLClass): JSSKeySpec; overload; virtual; final;  // throws java.security.spec.InvalidKeySpecException
    function translateKey(para1: JCSecretKey): JCSecretKey; overload; virtual; final;  // throws java.security.InvalidKeyException
  end;

  JCSecretKeyFactorySpi = class abstract external 'javax.crypto' name 'SecretKeyFactorySpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function engineGenerateSecret(para1: JSSKeySpec): JCSecretKey; overload; virtual; abstract;  // throws java.security.spec.InvalidKeySpecException
    function engineGetKeySpec(para1: JCSecretKey; para2: JLClass): JSSKeySpec; overload; virtual; abstract;  // throws java.security.spec.InvalidKeySpecException
    function engineTranslateKey(para1: JCSecretKey): JCSecretKey; overload; virtual; abstract;  // throws java.security.InvalidKeyException
  end;

  JCSunJCE_b = class sealed external 'javax.crypto' name 'SunJCE_b' (JLObject)
  end;

  JCSunJCE_c = class sealed external 'javax.crypto' name 'SunJCE_c' (JLObject)
  public
    type
      Inners = class;
      Arr1Inners = array of Inners;
      Arr2Inners = array of Arr1Inners;
      Arr3Inners = array of Arr2Inners;
      Inners = class external 'javax.crypto' name 's' 
      end;

  end;

  JCSunJCE_e = class sealed external 'javax.crypto' name 'SunJCE_e' (JLObject)
  public
    type
      Innerp = class;
      Arr1Innerp = array of Innerp;
      Arr2Innerp = array of Arr1Innerp;
      Arr3Innerp = array of Arr2Innerp;
      Innerq = class;
      Arr1Innerq = array of Innerq;
      Arr2Innerq = array of Arr1Innerq;
      Arr3Innerq = array of Arr2Innerq;
      Innero = class;
      Arr1Innero = array of Innero;
      Arr2Innero = array of Arr1Innero;
      Arr3Innero = array of Arr2Innero;
      Innerp = class sealed external 'javax.crypto' name 'p' 
      end;

      Innerq = class external 'javax.crypto' name 'q' 
      end;

      Innero = class external 'javax.crypto' name 'o' 
      end;

  end;

  JCIDHKey = interface external 'javax.crypto.interfaces' name 'DHKey' 
    function getParams(): JCSDHParameterSpec; overload;
  end;

  JCSPSource = class external 'javax.crypto.spec' name 'PSource' (JLObject)
  public
    type
      InnerPSpecified = class;
      Arr1InnerPSpecified = array of InnerPSpecified;
      Arr2InnerPSpecified = array of Arr1InnerPSpecified;
      Arr3InnerPSpecified = array of Arr2InnerPSpecified;
      InnerPSpecified = class sealed external 'javax.crypto.spec' name 'PSpecified' (JCSPSource)
      public
        final class var
          fDEFAULT: JCSPSource.InnerPSpecified; external name 'DEFAULT';
      public
        constructor create(para1: Arr1jbyte); overload;
        constructor create(const para1: array of jbyte); overload;
        function getValue(): Arr1jbyte; overload; virtual;
      end;

  strict protected
    constructor create(para1: JLString); overload;
  public
    function getAlgorithm(): JLString; overload; virtual;
  end;

  JIIIOImage = class external 'javax.imageio' name 'IIOImage' (JLObject)
  strict protected
    var
      fimage: JAIRenderedImage; external name 'image';
      fraster: JAIRaster; external name 'raster';
      fthumbnails: JUList; external name 'thumbnails';
      fmetadata: JIMIIOMetadata; external name 'metadata';
  public
    constructor create(para1: JAIRenderedImage; para2: JUList; para3: JIMIIOMetadata); overload;
    constructor create(para1: JAIRaster; para2: JUList; para3: JIMIIOMetadata); overload;
    function getRenderedImage(): JAIRenderedImage; overload; virtual;
    procedure setRenderedImage(para1: JAIRenderedImage); overload; virtual;
    function hasRaster(): jboolean; overload; virtual;
    function getRaster(): JAIRaster; overload; virtual;
    procedure setRaster(para1: JAIRaster); overload; virtual;
    function getNumThumbnails(): jint; overload; virtual;
    function getThumbnail(para1: jint): JAIBufferedImage; overload; virtual;
    function getThumbnails(): JUList; overload; virtual;
    procedure setThumbnails(para1: JUList); overload; virtual;
    function getMetadata(): JIMIIOMetadata; overload; virtual;
    procedure setMetadata(para1: JIMIIOMetadata); overload; virtual;
  end;

  JIIIOParam = class abstract external 'javax.imageio' name 'IIOParam' (JLObject)
  strict protected
    var
      fsourceRegion: JARectangle; external name 'sourceRegion';
      fsourceXSubsampling: jint; external name 'sourceXSubsampling';
      fsourceYSubsampling: jint; external name 'sourceYSubsampling';
      fsubsamplingXOffset: jint; external name 'subsamplingXOffset';
      fsubsamplingYOffset: jint; external name 'subsamplingYOffset';
      fsourceBands: Arr1jint; external name 'sourceBands';
      fdestinationType: JIImageTypeSpecifier; external name 'destinationType';
      fdestinationOffset: JAPoint; external name 'destinationOffset';
      fdefaultController: JIIIOParamController; external name 'defaultController';
      fcontroller: JIIIOParamController; external name 'controller';
  strict protected
    constructor create(); overload;
  public
    procedure setSourceRegion(para1: JARectangle); overload; virtual;
    function getSourceRegion(): JARectangle; overload; virtual;
    procedure setSourceSubsampling(para1: jint; para2: jint; para3: jint; para4: jint); overload; virtual;
    function getSourceXSubsampling(): jint; overload; virtual;
    function getSourceYSubsampling(): jint; overload; virtual;
    function getSubsamplingXOffset(): jint; overload; virtual;
    function getSubsamplingYOffset(): jint; overload; virtual;
    procedure setSourceBands(para1: Arr1jint); overload; virtual;
    procedure setSourceBands(var para1: array of jint); overload; virtual;
    function getSourceBands(): Arr1jint; overload; virtual;
    procedure setDestinationType(para1: JIImageTypeSpecifier); overload; virtual;
    function getDestinationType(): JIImageTypeSpecifier; overload; virtual;
    procedure setDestinationOffset(para1: JAPoint); overload; virtual;
    function getDestinationOffset(): JAPoint; overload; virtual;
    procedure setController(para1: JIIIOParamController); overload; virtual;
    function getController(): JIIIOParamController; overload; virtual;
    function getDefaultController(): JIIIOParamController; overload; virtual;
    function hasController(): jboolean; overload; virtual;
    function activateController(): jboolean; overload; virtual;
  end;

  JIIIOParamController = interface external 'javax.imageio' name 'IIOParamController' 
    function activate(para1: JIIIOParam): jboolean; overload;
  end;

  JIImageIO = class sealed external 'javax.imageio' name 'ImageIO' (JLObject)
  public
    type
      InnerCacheInfo = class;
      Arr1InnerCacheInfo = array of InnerCacheInfo;
      Arr2InnerCacheInfo = array of Arr1InnerCacheInfo;
      Arr3InnerCacheInfo = array of Arr2InnerCacheInfo;
      InnerCanDecodeInputFilter = class;
      Arr1InnerCanDecodeInputFilter = array of InnerCanDecodeInputFilter;
      Arr2InnerCanDecodeInputFilter = array of Arr1InnerCanDecodeInputFilter;
      Arr3InnerCanDecodeInputFilter = array of Arr2InnerCanDecodeInputFilter;
      InnerCanEncodeImageAndFormatFilter = class;
      Arr1InnerCanEncodeImageAndFormatFilter = array of InnerCanEncodeImageAndFormatFilter;
      Arr2InnerCanEncodeImageAndFormatFilter = array of Arr1InnerCanEncodeImageAndFormatFilter;
      Arr3InnerCanEncodeImageAndFormatFilter = array of Arr2InnerCanEncodeImageAndFormatFilter;
      InnerContainsFilter = class;
      Arr1InnerContainsFilter = array of InnerContainsFilter;
      Arr2InnerContainsFilter = array of Arr1InnerContainsFilter;
      Arr3InnerContainsFilter = array of Arr2InnerContainsFilter;
      InnerTranscoderFilter = class;
      Arr1InnerTranscoderFilter = array of InnerTranscoderFilter;
      Arr2InnerTranscoderFilter = array of Arr1InnerTranscoderFilter;
      Arr3InnerTranscoderFilter = array of Arr2InnerTranscoderFilter;
      InnerImageReaderIterator = class;
      Arr1InnerImageReaderIterator = array of InnerImageReaderIterator;
      Arr2InnerImageReaderIterator = array of Arr1InnerImageReaderIterator;
      Arr3InnerImageReaderIterator = array of Arr2InnerImageReaderIterator;
      InnerImageTranscoderIterator = class;
      Arr1InnerImageTranscoderIterator = array of InnerImageTranscoderIterator;
      Arr2InnerImageTranscoderIterator = array of Arr1InnerImageTranscoderIterator;
      Arr3InnerImageTranscoderIterator = array of Arr2InnerImageTranscoderIterator;
      InnerImageWriterIterator = class;
      Arr1InnerImageWriterIterator = array of InnerImageWriterIterator;
      Arr2InnerImageWriterIterator = array of Arr1InnerImageWriterIterator;
      Arr3InnerImageWriterIterator = array of Arr2InnerImageWriterIterator;
      InnerSpiInfo = class;
      Arr1InnerSpiInfo = array of InnerSpiInfo;
      Arr2InnerSpiInfo = array of Arr1InnerSpiInfo;
      Arr3InnerSpiInfo = array of Arr2InnerSpiInfo;
      InnerCacheInfo = class external 'javax.imageio' name 'CacheInfo' 
      end;

      InnerCanDecodeInputFilter = class external 'javax.imageio' name 'CanDecodeInputFilter' 
      end;

      InnerCanEncodeImageAndFormatFilter = class external 'javax.imageio' name 'CanEncodeImageAndFormatFilter' 
      end;

      InnerContainsFilter = class external 'javax.imageio' name 'ContainsFilter' 
      end;

      InnerTranscoderFilter = class external 'javax.imageio' name 'TranscoderFilter' 
      end;

      InnerImageReaderIterator = class external 'javax.imageio' name 'ImageReaderIterator' 
      end;

      InnerImageTranscoderIterator = class external 'javax.imageio' name 'ImageTranscoderIterator' 
      end;

      InnerImageWriterIterator = class external 'javax.imageio' name 'ImageWriterIterator' 
      end;

      InnerSpiInfo = class abstract external 'javax.imageio' name 'SpiInfo' 
      end;

  public
    class procedure scanForPlugins(); static; overload;
    class procedure setUseCache(para1: jboolean); static; overload;
    class function getUseCache(): jboolean; static; overload;
    class procedure setCacheDirectory(para1: JIFile); static; overload;
    class function getCacheDirectory(): JIFile; static; overload;
    class function createImageInputStream(para1: JLObject): JISImageInputStream; static; overload;  // throws java.io.IOException
    class function createImageOutputStream(para1: JLObject): JISImageOutputStream; static; overload;  // throws java.io.IOException
    class function getReaderFormatNames(): Arr1JLString; static; overload;
    class function getReaderMIMETypes(): Arr1JLString; static; overload;
    class function getReaderFileSuffixes(): Arr1JLString; static; overload;
    class function getImageReaders(para1: JLObject): JUIterator; static; overload;
    class function getImageReadersByFormatName(para1: JLString): JUIterator; static; overload;
    class function getImageReadersBySuffix(para1: JLString): JUIterator; static; overload;
    class function getImageReadersByMIMEType(para1: JLString): JUIterator; static; overload;
    class function getWriterFormatNames(): Arr1JLString; static; overload;
    class function getWriterMIMETypes(): Arr1JLString; static; overload;
    class function getWriterFileSuffixes(): Arr1JLString; static; overload;
    class function getImageWritersByFormatName(para1: JLString): JUIterator; static; overload;
    class function getImageWritersBySuffix(para1: JLString): JUIterator; static; overload;
    class function getImageWritersByMIMEType(para1: JLString): JUIterator; static; overload;
    class function getImageWriter(para1: JIImageReader): JIImageWriter; static; overload;
    class function getImageReader(para1: JIImageWriter): JIImageReader; static; overload;
    class function getImageWriters(para1: JIImageTypeSpecifier; para2: JLString): JUIterator; static; overload;
    class function getImageTranscoders(para1: JIImageReader; para2: JIImageWriter): JUIterator; static; overload;
    class function read(para1: JIFile): JAIBufferedImage; static; overload;  // throws java.io.IOException
    class function read(para1: JIInputStream): JAIBufferedImage; static; overload;  // throws java.io.IOException
    class function read(para1: JNURL): JAIBufferedImage; static; overload;  // throws java.io.IOException
    class function read(para1: JISImageInputStream): JAIBufferedImage; static; overload;  // throws java.io.IOException
    class function write(para1: JAIRenderedImage; para2: JLString; para3: JISImageOutputStream): jboolean; static; overload;  // throws java.io.IOException
    class function write(para1: JAIRenderedImage; para2: JLString; para3: JIFile): jboolean; static; overload;  // throws java.io.IOException
    class function write(para1: JAIRenderedImage; para2: JLString; para3: JIOutputStream): jboolean; static; overload;  // throws java.io.IOException
  end;

  JIImageReader = class abstract external 'javax.imageio' name 'ImageReader' (JLObject)
  strict protected
    var
      foriginatingProvider: JISImageReaderSpi; external name 'originatingProvider';
      finput: JLObject; external name 'input';
      fseekForwardOnly: jboolean; external name 'seekForwardOnly';
      fignoreMetadata: jboolean; external name 'ignoreMetadata';
      fminIndex: jint; external name 'minIndex';
      favailableLocales: Arr1JULocale; external name 'availableLocales';
      flocale: JULocale; external name 'locale';
      fwarningListeners: JUList; external name 'warningListeners';
      fwarningLocales: JUList; external name 'warningLocales';
      fprogressListeners: JUList; external name 'progressListeners';
      fupdateListeners: JUList; external name 'updateListeners';
  strict protected
    constructor create(para1: JISImageReaderSpi); overload;
  public
    function getFormatName(): JLString; overload; virtual;  // throws java.io.IOException
    function getOriginatingProvider(): JISImageReaderSpi; overload; virtual;
    procedure setInput(para1: JLObject; para2: jboolean; para3: jboolean); overload; virtual;
    procedure setInput(para1: JLObject; para2: jboolean); overload; virtual;
    procedure setInput(para1: JLObject); overload; virtual;
    function getInput(): JLObject; overload; virtual;
    function isSeekForwardOnly(): jboolean; overload; virtual;
    function isIgnoringMetadata(): jboolean; overload; virtual;
    function getMinIndex(): jint; overload; virtual;
    function getAvailableLocales(): Arr1JULocale; overload; virtual;
    procedure setLocale(para1: JULocale); overload; virtual;
    function getLocale(): JULocale; overload; virtual;
    function getNumImages(para1: jboolean): jint; overload; virtual; abstract;  // throws java.io.IOException
    function getWidth(para1: jint): jint; overload; virtual; abstract;  // throws java.io.IOException
    function getHeight(para1: jint): jint; overload; virtual; abstract;  // throws java.io.IOException
    function isRandomAccessEasy(para1: jint): jboolean; overload; virtual;  // throws java.io.IOException
    function getAspectRatio(para1: jint): jfloat; overload; virtual;  // throws java.io.IOException
    function getRawImageType(para1: jint): JIImageTypeSpecifier; overload; virtual;  // throws java.io.IOException
    function getImageTypes(para1: jint): JUIterator; overload; virtual; abstract;  // throws java.io.IOException
    function getDefaultReadParam(): JIImageReadParam; overload; virtual;
    function getStreamMetadata(): JIMIIOMetadata; overload; virtual; abstract;  // throws java.io.IOException
    function getStreamMetadata(para1: JLString; para2: JUSet): JIMIIOMetadata; overload; virtual;  // throws java.io.IOException
    function getImageMetadata(para1: jint): JIMIIOMetadata; overload; virtual; abstract;  // throws java.io.IOException
    function getImageMetadata(para1: jint; para2: JLString; para3: JUSet): JIMIIOMetadata; overload; virtual;  // throws java.io.IOException
    function read(para1: jint): JAIBufferedImage; overload; virtual;  // throws java.io.IOException
    function read(para1: jint; para2: JIImageReadParam): JAIBufferedImage; overload; virtual; abstract;  // throws java.io.IOException
    function readAll(para1: jint; para2: JIImageReadParam): JIIIOImage; overload; virtual;  // throws java.io.IOException
    function readAll(para1: JUIterator): JUIterator; overload; virtual;  // throws java.io.IOException
    function canReadRaster(): jboolean; overload; virtual;
    function readRaster(para1: jint; para2: JIImageReadParam): JAIRaster; overload; virtual;  // throws java.io.IOException
    function isImageTiled(para1: jint): jboolean; overload; virtual;  // throws java.io.IOException
    function getTileWidth(para1: jint): jint; overload; virtual;  // throws java.io.IOException
    function getTileHeight(para1: jint): jint; overload; virtual;  // throws java.io.IOException
    function getTileGridXOffset(para1: jint): jint; overload; virtual;  // throws java.io.IOException
    function getTileGridYOffset(para1: jint): jint; overload; virtual;  // throws java.io.IOException
    function readTile(para1: jint; para2: jint; para3: jint): JAIBufferedImage; overload; virtual;  // throws java.io.IOException
    function readTileRaster(para1: jint; para2: jint; para3: jint): JAIRaster; overload; virtual;  // throws java.io.IOException
    function readAsRenderedImage(para1: jint; para2: JIImageReadParam): JAIRenderedImage; overload; virtual;  // throws java.io.IOException
    function readerSupportsThumbnails(): jboolean; overload; virtual;
    function hasThumbnails(para1: jint): jboolean; overload; virtual;  // throws java.io.IOException
    function getNumThumbnails(para1: jint): jint; overload; virtual;  // throws java.io.IOException
    function getThumbnailWidth(para1: jint; para2: jint): jint; overload; virtual;  // throws java.io.IOException
    function getThumbnailHeight(para1: jint; para2: jint): jint; overload; virtual;  // throws java.io.IOException
    function readThumbnail(para1: jint; para2: jint): JAIBufferedImage; overload; virtual;  // throws java.io.IOException
    procedure abort(); overload; virtual;
  strict protected
    function abortRequested(): jboolean; overload; virtual;
    procedure clearAbortRequest(); overload; virtual;
  public
    procedure addIIOReadWarningListener(para1: JIEIIOReadWarningListener); overload; virtual;
    procedure removeIIOReadWarningListener(para1: JIEIIOReadWarningListener); overload; virtual;
    procedure removeAllIIOReadWarningListeners(); overload; virtual;
    procedure addIIOReadProgressListener(para1: JIEIIOReadProgressListener); overload; virtual;
    procedure removeIIOReadProgressListener(para1: JIEIIOReadProgressListener); overload; virtual;
    procedure removeAllIIOReadProgressListeners(); overload; virtual;
    procedure addIIOReadUpdateListener(para1: JIEIIOReadUpdateListener); overload; virtual;
    procedure removeIIOReadUpdateListener(para1: JIEIIOReadUpdateListener); overload; virtual;
    procedure removeAllIIOReadUpdateListeners(); overload; virtual;
  strict protected
    procedure processSequenceStarted(para1: jint); overload; virtual;
    procedure processSequenceComplete(); overload; virtual;
    procedure processImageStarted(para1: jint); overload; virtual;
    procedure processImageProgress(para1: jfloat); overload; virtual;
    procedure processImageComplete(); overload; virtual;
    procedure processThumbnailStarted(para1: jint; para2: jint); overload; virtual;
    procedure processThumbnailProgress(para1: jfloat); overload; virtual;
    procedure processThumbnailComplete(); overload; virtual;
    procedure processReadAborted(); overload; virtual;
    procedure processPassStarted(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint; para9: Arr1jint); overload; virtual;
    procedure processPassStarted(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint; var para9: array of jint); overload; virtual;
    procedure processImageUpdate(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: Arr1jint); overload; virtual;
    procedure processImageUpdate(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; var para8: array of jint); overload; virtual;
    procedure processPassComplete(para1: JAIBufferedImage); overload; virtual;
    procedure processThumbnailPassStarted(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint; para9: Arr1jint); overload; virtual;
    procedure processThumbnailPassStarted(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint; var para9: array of jint); overload; virtual;
    procedure processThumbnailUpdate(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: Arr1jint); overload; virtual;
    procedure processThumbnailUpdate(para1: JAIBufferedImage; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; var para8: array of jint); overload; virtual;
    procedure processThumbnailPassComplete(para1: JAIBufferedImage); overload; virtual;
    procedure processWarningOccurred(para1: JLString); overload; virtual;
    procedure processWarningOccurred(para1: JLString; para2: JLString); overload; virtual;
  public
    procedure reset(); overload; virtual;
    procedure dispose(); overload; virtual;
  strict protected
    class function getSourceRegion(para1: JIImageReadParam; para2: jint; para3: jint): JARectangle; static; overload;
    class procedure computeRegions(para1: JIImageReadParam; para2: jint; para3: jint; para4: JAIBufferedImage; para5: JARectangle; para6: JARectangle); static; overload;
    class procedure checkReadParamBandSettings(para1: JIImageReadParam; para2: jint; para3: jint); static; overload;
    class function getDestination(para1: JIImageReadParam; para2: JUIterator; para3: jint; para4: jint): JAIBufferedImage; static; overload;  // throws javax.imageio.IIOException
  end;

  JIImageTranscoder = interface external 'javax.imageio' name 'ImageTranscoder' 
    function convertStreamMetadata(para1: JIMIIOMetadata; para2: JIImageWriteParam): JIMIIOMetadata; overload;
    function convertImageMetadata(para1: JIMIIOMetadata; para2: JIImageTypeSpecifier; para3: JIImageWriteParam): JIMIIOMetadata; overload;
  end;

  JIImageTypeSpecifier = class external 'javax.imageio' name 'ImageTypeSpecifier' (JLObject)
  public
    type
      InnerBanded = class;
      Arr1InnerBanded = array of InnerBanded;
      Arr2InnerBanded = array of Arr1InnerBanded;
      Arr3InnerBanded = array of Arr2InnerBanded;
      InnerGrayscale = class;
      Arr1InnerGrayscale = array of InnerGrayscale;
      Arr2InnerGrayscale = array of Arr1InnerGrayscale;
      Arr3InnerGrayscale = array of Arr2InnerGrayscale;
      InnerIndexed = class;
      Arr1InnerIndexed = array of InnerIndexed;
      Arr2InnerIndexed = array of Arr1InnerIndexed;
      Arr3InnerIndexed = array of Arr2InnerIndexed;
      InnerInterleaved = class;
      Arr1InnerInterleaved = array of InnerInterleaved;
      Arr2InnerInterleaved = array of Arr1InnerInterleaved;
      Arr3InnerInterleaved = array of Arr2InnerInterleaved;
      InnerPacked = class;
      Arr1InnerPacked = array of InnerPacked;
      Arr2InnerPacked = array of Arr1InnerPacked;
      Arr3InnerPacked = array of Arr2InnerPacked;
      InnerBanded = class external 'javax.imageio' name 'Banded' 
      end;

      InnerGrayscale = class external 'javax.imageio' name 'Grayscale' 
      end;

      InnerIndexed = class external 'javax.imageio' name 'Indexed' 
      end;

      InnerInterleaved = class external 'javax.imageio' name 'Interleaved' 
      end;

      InnerPacked = class external 'javax.imageio' name 'Packed' 
      end;

  strict protected
    var
      fcolorModel: JAIColorModel; external name 'colorModel';
      fsampleModel: JAISampleModel; external name 'sampleModel';
  public
    constructor create(para1: JAIColorModel; para2: JAISampleModel); overload;
    constructor create(para1: JAIRenderedImage); overload;
    class function createPacked(para1: JACColorSpace; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jboolean): JIImageTypeSpecifier; static; overload;
    class function createInterleaved(para1: JACColorSpace; para2: Arr1jint; para3: jint; para4: jboolean; para5: jboolean): JIImageTypeSpecifier; static; overload;
    class function createInterleaved(para1: JACColorSpace; var para2: array of jint; para3: jint; para4: jboolean; para5: jboolean): JIImageTypeSpecifier; static; overload;
    class function createBanded(para1: JACColorSpace; para2: Arr1jint; para3: Arr1jint; para4: jint; para5: jboolean; para6: jboolean): JIImageTypeSpecifier; static; overload;
    class function createBanded(para1: JACColorSpace; var para2: array of jint; var para3: array of jint; para4: jint; para5: jboolean; para6: jboolean): JIImageTypeSpecifier; static; overload;
    class function createGrayscale(para1: jint; para2: jint; para3: jboolean): JIImageTypeSpecifier; static; overload;
    class function createGrayscale(para1: jint; para2: jint; para3: jboolean; para4: jboolean): JIImageTypeSpecifier; static; overload;
    class function createIndexed(para1: Arr1jbyte; para2: Arr1jbyte; para3: Arr1jbyte; para4: Arr1jbyte; para5: jint; para6: jint): JIImageTypeSpecifier; static; overload;
    class function createIndexed(var para1: array of jbyte; var para2: array of jbyte; var para3: array of jbyte; var para4: array of jbyte; para5: jint; para6: jint): JIImageTypeSpecifier; static; overload;
    class function createFromBufferedImageType(para1: jint): JIImageTypeSpecifier; static; overload;
    class function createFromRenderedImage(para1: JAIRenderedImage): JIImageTypeSpecifier; static; overload;
    function getBufferedImageType(): jint; overload; virtual;
    function getNumComponents(): jint; overload; virtual;
    function getNumBands(): jint; overload; virtual;
    function getBitsPerBand(para1: jint): jint; overload; virtual;
    function getSampleModel(): JAISampleModel; overload; virtual;
    function getSampleModel(para1: jint; para2: jint): JAISampleModel; overload; virtual;
    function getColorModel(): JAIColorModel; overload; virtual;
    function createBufferedImage(para1: jint; para2: jint): JAIBufferedImage; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  JIMIIOMetadata = class abstract external 'javax.imageio.metadata' name 'IIOMetadata' (JLObject)
  strict protected
    var
      fstandardFormatSupported: jboolean; external name 'standardFormatSupported';
      fnativeMetadataFormatName: JLString; external name 'nativeMetadataFormatName';
      fnativeMetadataFormatClassName: JLString; external name 'nativeMetadataFormatClassName';
      fextraMetadataFormatNames: Arr1JLString; external name 'extraMetadataFormatNames';
      fextraMetadataFormatClassNames: Arr1JLString; external name 'extraMetadataFormatClassNames';
      fdefaultController: JIMIIOMetadataController; external name 'defaultController';
      fcontroller: JIMIIOMetadataController; external name 'controller';
  strict protected
    constructor create(); overload;
    constructor create(para1: jboolean; para2: JLString; para3: JLString; para4: Arr1JLString; para5: Arr1JLString); overload;
    constructor create(para1: jboolean; para2: JLString; para3: JLString; const para4: array of JLString; const para5: array of JLString); overload;
  public
    function isStandardMetadataFormatSupported(): jboolean; overload; virtual;
    function isReadOnly(): jboolean; overload; virtual; abstract;
    function getNativeMetadataFormatName(): JLString; overload; virtual;
    function getExtraMetadataFormatNames(): Arr1JLString; overload; virtual;
    function getMetadataFormatNames(): Arr1JLString; overload; virtual;
    function getMetadataFormat(para1: JLString): JIMIIOMetadataFormat; overload; virtual;
    function getAsTree(para1: JLString): OWDNode; overload; virtual; abstract;
    procedure mergeTree(para1: JLString; para2: OWDNode); overload; virtual; abstract;  // throws javax.imageio.metadata.IIOInvalidTreeException
  strict protected
    function getStandardChromaNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardCompressionNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardDataNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardDimensionNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardDocumentNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardTextNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardTileNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardTransparencyNode(): JIMIIOMetadataNode; overload; virtual;
    function getStandardTree(): JIMIIOMetadataNode; overload; virtual; final;
  public
    procedure setFromTree(para1: JLString; para2: OWDNode); overload; virtual;  // throws javax.imageio.metadata.IIOInvalidTreeException
    procedure reset(); overload; virtual; abstract;
    procedure setController(para1: JIMIIOMetadataController); overload; virtual;
    function getController(): JIMIIOMetadataController; overload; virtual;
    function getDefaultController(): JIMIIOMetadataController; overload; virtual;
    function hasController(): jboolean; overload; virtual;
    function activateController(): jboolean; overload; virtual;
  end;

  JIMIIOMetadataController = interface external 'javax.imageio.metadata' name 'IIOMetadataController' 
    function activate(para1: JIMIIOMetadata): jboolean; overload;
  end;

  JIMIIOMetadataFormat = interface external 'javax.imageio.metadata' name 'IIOMetadataFormat' 
    const
      CHILD_POLICY_EMPTY = 0;
      CHILD_POLICY_ALL = 1;
      CHILD_POLICY_SOME = 2;
      CHILD_POLICY_CHOICE = 3;
      CHILD_POLICY_SEQUENCE = 4;
      CHILD_POLICY_REPEAT = 5;
      CHILD_POLICY_MAX = 5;
      VALUE_NONE = 0;
      VALUE_ARBITRARY = 1;
      VALUE_RANGE = 2;
      VALUE_RANGE_MIN_INCLUSIVE_MASK = 4;
      VALUE_RANGE_MAX_INCLUSIVE_MASK = 8;
      VALUE_RANGE_MIN_INCLUSIVE = 6;
      VALUE_RANGE_MAX_INCLUSIVE = 10;
      VALUE_RANGE_MIN_MAX_INCLUSIVE = 14;
      VALUE_ENUMERATION = 16;
      VALUE_LIST = 32;
      DATATYPE_STRING = 0;
      DATATYPE_BOOLEAN = 1;
      DATATYPE_INTEGER = 2;
      DATATYPE_FLOAT = 3;
      DATATYPE_DOUBLE = 4;
    function getRootName(): JLString; overload;
    function canNodeAppear(para1: JLString; para2: JIImageTypeSpecifier): jboolean; overload;
    function getElementMinChildren(para1: JLString): jint; overload;
    function getElementMaxChildren(para1: JLString): jint; overload;
    function getElementDescription(para1: JLString; para2: JULocale): JLString; overload;
    function getChildPolicy(para1: JLString): jint; overload;
    function getChildNames(para1: JLString): Arr1JLString; overload;
    function getAttributeNames(para1: JLString): Arr1JLString; overload;
    function getAttributeValueType(para1: JLString; para2: JLString): jint; overload;
    function getAttributeDataType(para1: JLString; para2: JLString): jint; overload;
    function isAttributeRequired(para1: JLString; para2: JLString): jboolean; overload;
    function getAttributeDefaultValue(para1: JLString; para2: JLString): JLString; overload;
    function getAttributeEnumerations(para1: JLString; para2: JLString): Arr1JLString; overload;
    function getAttributeMinValue(para1: JLString; para2: JLString): JLString; overload;
    function getAttributeMaxValue(para1: JLString; para2: JLString): JLString; overload;
    function getAttributeListMinLength(para1: JLString; para2: JLString): jint; overload;
    function getAttributeListMaxLength(para1: JLString; para2: JLString): jint; overload;
    function getAttributeDescription(para1: JLString; para2: JLString; para3: JULocale): JLString; overload;
    function getObjectValueType(para1: JLString): jint; overload;
    function getObjectClass(para1: JLString): JLClass; overload;
    function getObjectDefaultValue(para1: JLString): JLObject; overload;
    function getObjectEnumerations(para1: JLString): Arr1JLObject; overload;
    function getObjectMinValue(para1: JLString): JLComparable; overload;
    function getObjectMaxValue(para1: JLString): JLComparable; overload;
    function getObjectArrayMinLength(para1: JLString): jint; overload;
    function getObjectArrayMaxLength(para1: JLString): jint; overload;
  end;

  JIPJJPEGHuffmanTable = class external 'javax.imageio.plugins.jpeg' name 'JPEGHuffmanTable' (JLObject)
  public
    final class var
      fStdDCLuminance: JIPJJPEGHuffmanTable; external name 'StdDCLuminance';
      fStdDCChrominance: JIPJJPEGHuffmanTable; external name 'StdDCChrominance';
      fStdACLuminance: JIPJJPEGHuffmanTable; external name 'StdACLuminance';
      fStdACChrominance: JIPJJPEGHuffmanTable; external name 'StdACChrominance';
  public
    constructor create(para1: Arr1jshort; para2: Arr1jshort); overload;
    constructor create(const para1: array of jshort; const para2: array of jshort); overload;
    function getLengths(): Arr1jshort; overload; virtual;
    function getValues(): Arr1jshort; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JIPJJPEGQTable = class external 'javax.imageio.plugins.jpeg' name 'JPEGQTable' (JLObject)
  public
    final class var
      fK1Luminance: JIPJJPEGQTable; external name 'K1Luminance';
      fK1Div2Luminance: JIPJJPEGQTable; external name 'K1Div2Luminance';
      fK2Chrominance: JIPJJPEGQTable; external name 'K2Chrominance';
      fK2Div2Chrominance: JIPJJPEGQTable; external name 'K2Div2Chrominance';
  public
    constructor create(para1: Arr1jint); overload;
    constructor create(const para1: array of jint); overload;
    function getTable(): Arr1jint; overload; virtual;
    function getScaledInstance(para1: jfloat; para2: jboolean): JIPJJPEGQTable; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JISRegisterableService = interface external 'javax.imageio.spi' name 'RegisterableService' 
    procedure onRegistration(para1: JISServiceRegistry; para2: JLClass); overload;
    procedure onDeregistration(para1: JISServiceRegistry; para2: JLClass); overload;
  end;

  JISServiceRegistry = class external 'javax.imageio.spi' name 'ServiceRegistry' (JLObject)
  public
    type
      InnerFilter = interface;
      Arr1InnerFilter = array of InnerFilter;
      Arr2InnerFilter = array of Arr1InnerFilter;
      Arr3InnerFilter = array of Arr2InnerFilter;
      InnerFilter = interface external 'javax.imageio.spi' name 'Filter' 
        function filter(para1: JLObject): jboolean; overload;
      end;

  public
    constructor create(para1: JUIterator); overload;
    class function lookupProviders(para1: JLClass; para2: JLClassLoader): JUIterator; static; overload;
    class function lookupProviders(para1: JLClass): JUIterator; static; overload;
    function getCategories(): JUIterator; overload; virtual;
    function registerServiceProvider(para1: JLObject; para2: JLClass): jboolean; overload; virtual;
    procedure registerServiceProvider(para1: JLObject); overload; virtual;
    procedure registerServiceProviders(para1: JUIterator); overload; virtual;
    function deregisterServiceProvider(para1: JLObject; para2: JLClass): jboolean; overload; virtual;
    procedure deregisterServiceProvider(para1: JLObject); overload; virtual;
    function contains(para1: JLObject): jboolean; overload; virtual;
    function getServiceProviders(para1: JLClass; para2: jboolean): JUIterator; overload; virtual;
    function getServiceProviders(para1: JLClass; para2: JISServiceRegistry.InnerFilter; para3: jboolean): JUIterator; overload; virtual;
    function getServiceProviderByClass(para1: JLClass): JLObject; overload; virtual;
    function setOrdering(para1: JLClass; para2: JLObject; para3: JLObject): jboolean; overload; virtual;
    function unsetOrdering(para1: JLClass; para2: JLObject; para3: JLObject): jboolean; overload; virtual;
    procedure deregisterAll(para1: JLClass); overload; virtual;
    procedure deregisterAll(); overload; virtual;
    procedure finalize(); overload; virtual;  // throws java.lang.Throwable
  end;

  JISSubRegistry = class external 'javax.imageio.spi' name 'SubRegistry' (JLObject)
  public
    constructor create(para1: JISServiceRegistry; para2: JLClass); overload;
    function registerServiceProvider(para1: JLObject): jboolean; overload; virtual;
    function deregisterServiceProvider(para1: JLObject): jboolean; overload; virtual;
    function contains(para1: JLObject): jboolean; overload; virtual;
    function setOrdering(para1: JLObject; para2: JLObject): jboolean; overload; virtual;
    function unsetOrdering(para1: JLObject; para2: JLObject): jboolean; overload; virtual;
    function getServiceProviders(para1: jboolean): JUIterator; overload; virtual;
    function getServiceProviderByClass(para1: JLClass): JLObject; overload; virtual;
    procedure clear(); overload; virtual;
    procedure finalize(); overload; virtual;
  end;

  JISIIOByteBuffer = class external 'javax.imageio.stream' name 'IIOByteBuffer' (JLObject)
  public
    constructor create(para1: Arr1jbyte; para2: jint; para3: jint); overload;
    constructor create(const para1: array of jbyte; para2: jint; para3: jint); overload;
    function getData(): Arr1jbyte; overload; virtual;
    procedure setData(para1: Arr1jbyte); overload; virtual;
    procedure setData(var para1: array of jbyte); overload; virtual;
    function getOffset(): jint; overload; virtual;
    procedure setOffset(para1: jint); overload; virtual;
    function getLength(): jint; overload; virtual;
    procedure setLength(para1: jint); overload; virtual;
  end;

  JISMemoryCache = class external 'javax.imageio.stream' name 'MemoryCache' (JLObject)
  public
    function loadFromStream(para1: JIInputStream; para2: jlong): jlong; overload; virtual;  // throws java.io.IOException
    procedure writeToStream(para1: JIOutputStream; para2: jlong; para3: jlong); overload; virtual;  // throws java.io.IOException
    procedure write(para1: Arr1jbyte; para2: jint; para3: jint; para4: jlong); overload; virtual;  // throws java.io.IOException
    procedure write(var para1: array of jbyte; para2: jint; para3: jint; para4: jlong); overload; virtual;  // throws java.io.IOException
    procedure write(para1: jint; para2: jlong); overload; virtual;  // throws java.io.IOException
    function getLength(): jlong; overload; virtual;
    function read(para1: jlong): jint; overload; virtual;  // throws java.io.IOException
    procedure read(para1: Arr1jbyte; para2: jint; para3: jint; para4: jlong); overload; virtual;  // throws java.io.IOException
    procedure read(var para1: array of jbyte; para2: jint; para3: jint; para4: jlong); overload; virtual;  // throws java.io.IOException
    procedure disposeBefore(para1: jlong); overload; virtual;
    procedure reset(); overload; virtual;
  end;

  JLMEAnnotationMirror = interface external 'javax.lang.model.element' name 'AnnotationMirror' 
    function getAnnotationType(): JLMTDeclaredType; overload;
    function getElementValues(): JUMap; overload;
  end;

  JLMEAnnotationValue = interface external 'javax.lang.model.element' name 'AnnotationValue' 
    function getValue(): JLObject; overload;
    function toString(): JLString; overload;
    function accept(para1: JLMEAnnotationValueVisitor; para2: JLObject): JLObject; overload;
  end;

  JLMEAnnotationValueVisitor = interface external 'javax.lang.model.element' name 'AnnotationValueVisitor' 
    function visit(para1: JLMEAnnotationValue; para2: JLObject): JLObject; overload;
    function visit(para1: JLMEAnnotationValue): JLObject; overload;
    function visitBoolean(para1: jboolean; para2: JLObject): JLObject; overload;
    function visitByte(para1: jbyte; para2: JLObject): JLObject; overload;
    function visitChar(para1: jchar; para2: JLObject): JLObject; overload;
    function visitDouble(para1: jdouble; para2: JLObject): JLObject; overload;
    function visitFloat(para1: jfloat; para2: JLObject): JLObject; overload;
    function visitInt(para1: jint; para2: JLObject): JLObject; overload;
    function visitLong(para1: jlong; para2: JLObject): JLObject; overload;
    function visitShort(para1: jshort; para2: JLObject): JLObject; overload;
    function visitString(para1: JLString; para2: JLObject): JLObject; overload;
    function visitType(para1: JLMTTypeMirror; para2: JLObject): JLObject; overload;
    function visitEnumConstant(para1: JLMEVariableElement; para2: JLObject): JLObject; overload;
    function visitAnnotation(para1: JLMEAnnotationMirror; para2: JLObject): JLObject; overload;
    function visitArray(para1: JUList; para2: JLObject): JLObject; overload;
    function visitUnknown(para1: JLMEAnnotationValue; para2: JLObject): JLObject; overload;
  end;

  JLMEElement = interface external 'javax.lang.model.element' name 'Element' 
    function asType(): JLMTTypeMirror; overload;
    function getKind(): JLMEElementKind; overload;
    function getAnnotationMirrors(): JUList; overload;
    function getAnnotation(para1: JLClass): JLAAnnotation; overload;
    function getModifiers(): JUSet; overload;
    function getSimpleName(): JLMEName; overload;
    function getEnclosingElement(): JLMEElement; overload;
    function getEnclosedElements(): JUList; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function accept(para1: JLMEElementVisitor; para2: JLObject): JLObject; overload;
  end;

  JLMEElementVisitor = interface external 'javax.lang.model.element' name 'ElementVisitor' 
    function visit(para1: JLMEElement; para2: JLObject): JLObject; overload;
    function visit(para1: JLMEElement): JLObject; overload;
    function visitPackage(para1: JLMEPackageElement; para2: JLObject): JLObject; overload;
    function visitType(para1: JLMETypeElement; para2: JLObject): JLObject; overload;
    function visitVariable(para1: JLMEVariableElement; para2: JLObject): JLObject; overload;
    function visitExecutable(para1: JLMEExecutableElement; para2: JLObject): JLObject; overload;
    function visitTypeParameter(para1: JLMETypeParameterElement; para2: JLObject): JLObject; overload;
    function visitUnknown(para1: JLMEElement; para2: JLObject): JLObject; overload;
  end;

  JLMTTypeMirror = interface external 'javax.lang.model.type' name 'TypeMirror' 
    function getKind(): JLMTTypeKind; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
    function accept(para1: JLMTTypeVisitor; para2: JLObject): JLObject; overload;
  end;

  JLMTTypeVisitor = interface external 'javax.lang.model.type' name 'TypeVisitor' 
    function visit(para1: JLMTTypeMirror; para2: JLObject): JLObject; overload;
    function visit(para1: JLMTTypeMirror): JLObject; overload;
    function visitPrimitive(para1: JLMTPrimitiveType; para2: JLObject): JLObject; overload;
    function visitNull(para1: JLMTNullType; para2: JLObject): JLObject; overload;
    function visitArray(para1: JLMTArrayType; para2: JLObject): JLObject; overload;
    function visitDeclared(para1: JLMTDeclaredType; para2: JLObject): JLObject; overload;
    function visitError(para1: JLMTErrorType; para2: JLObject): JLObject; overload;
    function visitTypeVariable(para1: JLMTTypeVariable; para2: JLObject): JLObject; overload;
    function visitWildcard(para1: JLMTWildcardType; para2: JLObject): JLObject; overload;
    function visitExecutable(para1: JLMTExecutableType; para2: JLObject): JLObject; overload;
    function visitNoType(para1: JLMTNoType; para2: JLObject): JLObject; overload;
    function visitUnknown(para1: JLMTTypeMirror; para2: JLObject): JLObject; overload;
  end;

  JLMUElementFilter = class external 'javax.lang.model.util' name 'ElementFilter' (JLObject)
  public
    class function fieldsIn(para1: JLIterable): JUList; static; overload;
    class function fieldsIn(para1: JUSet): JUSet; static; overload;
    class function constructorsIn(para1: JLIterable): JUList; static; overload;
    class function constructorsIn(para1: JUSet): JUSet; static; overload;
    class function methodsIn(para1: JLIterable): JUList; static; overload;
    class function methodsIn(para1: JUSet): JUSet; static; overload;
    class function typesIn(para1: JLIterable): JUList; static; overload;
    class function typesIn(para1: JUSet): JUSet; static; overload;
    class function packagesIn(para1: JLIterable): JUList; static; overload;
    class function packagesIn(para1: JUSet): JUSet; static; overload;
  end;

  JLMUElements = interface external 'javax.lang.model.util' name 'Elements' 
    function getPackageElement(para1: JLCharSequence): JLMEPackageElement; overload;
    function getTypeElement(para1: JLCharSequence): JLMETypeElement; overload;
    function getElementValuesWithDefaults(para1: JLMEAnnotationMirror): JUMap; overload;
    function getDocComment(para1: JLMEElement): JLString; overload;
    function isDeprecated(para1: JLMEElement): jboolean; overload;
    function getBinaryName(para1: JLMETypeElement): JLMEName; overload;
    function getPackageOf(para1: JLMEElement): JLMEPackageElement; overload;
    function getAllMembers(para1: JLMETypeElement): JUList; overload;
    function getAllAnnotationMirrors(para1: JLMEElement): JUList; overload;
    function hides(para1: JLMEElement; para2: JLMEElement): jboolean; overload;
    function overrides(para1: JLMEExecutableElement; para2: JLMEExecutableElement; para3: JLMETypeElement): jboolean; overload;
    function getConstantExpression(para1: JLObject): JLString; overload;
    procedure printElements(para1: JIWriter; para2: Arr1JLMEElement); overload;
    procedure printElements(para1: JIWriter; const para2: array of JLMEElement); overload;
    function getName(para1: JLCharSequence): JLMEName; overload;
  end;

  JLMUTypes = interface external 'javax.lang.model.util' name 'Types' 
    function asElement(para1: JLMTTypeMirror): JLMEElement; overload;
    function isSameType(para1: JLMTTypeMirror; para2: JLMTTypeMirror): jboolean; overload;
    function isSubtype(para1: JLMTTypeMirror; para2: JLMTTypeMirror): jboolean; overload;
    function isAssignable(para1: JLMTTypeMirror; para2: JLMTTypeMirror): jboolean; overload;
    function contains(para1: JLMTTypeMirror; para2: JLMTTypeMirror): jboolean; overload;
    function isSubsignature(para1: JLMTExecutableType; para2: JLMTExecutableType): jboolean; overload;
    function directSupertypes(para1: JLMTTypeMirror): JUList; overload;
    function erasure(para1: JLMTTypeMirror): JLMTTypeMirror; overload;
    function boxedClass(para1: JLMTPrimitiveType): JLMETypeElement; overload;
    function unboxedType(para1: JLMTTypeMirror): JLMTPrimitiveType; overload;
    function capture(para1: JLMTTypeMirror): JLMTTypeMirror; overload;
    function getPrimitiveType(para1: JLMTTypeKind): JLMTPrimitiveType; overload;
    function getNullType(): JLMTNullType; overload;
    function getNoType(para1: JLMTTypeKind): JLMTNoType; overload;
    function getArrayType(para1: JLMTTypeMirror): JLMTArrayType; overload;
    function getWildcardType(para1: JLMTTypeMirror; para2: JLMTTypeMirror): JLMTWildcardType; overload;
    function getDeclaredType(para1: JLMETypeElement; para2: Arr1JLMTTypeMirror): JLMTDeclaredType; overload;
    function getDeclaredType(para1: JLMETypeElement; const para2: array of JLMTTypeMirror): JLMTDeclaredType; overload;
    function getDeclaredType(para1: JLMTDeclaredType; para2: JLMETypeElement; para3: Arr1JLMTTypeMirror): JLMTDeclaredType; overload;
    function getDeclaredType(para1: JLMTDeclaredType; para2: JLMETypeElement; const para3: array of JLMTTypeMirror): JLMTDeclaredType; overload;
    function asMemberOf(para1: JLMTDeclaredType; para2: JLMEElement): JLMTTypeMirror; overload;
  end;

  JMDefaultLoaderRepository = class external 'javax.management' name 'DefaultLoaderRepository' (JLObject)
  public
    constructor create(); overload;
    class function loadClass(para1: JLString): JLClass; static; overload;  // throws java.lang.ClassNotFoundException
    class function loadClassWithout(para1: JLClassLoader; para2: JLString): JLClass; static; overload;  // throws java.lang.ClassNotFoundException
  end;

  JMDescriptorRead = interface external 'javax.management' name 'DescriptorRead' 
    function getDescriptor(): JMDescriptor; overload;
  end;

  JMDynamicMBean = interface external 'javax.management' name 'DynamicMBean' 
    function getAttribute(para1: JLString): JLObject; overload;  // throws javax.management.AttributeNotFoundException, javax.management.MBeanException, javax.management.ReflectionException
    procedure setAttribute(para1: JMAttribute); overload;  // throws javax.management.AttributeNotFoundException, javax.management.InvalidAttributeValueException, javax.management.MBeanException, javax.management.ReflectionException
    function getAttributes(para1: Arr1JLString): JMAttributeList; overload;
    function getAttributes(var para1: array of JLString): JMAttributeList; overload;
    function setAttributes(para1: JMAttributeList): JMAttributeList; overload;
    function invoke(para1: JLString; para2: Arr1JLObject; para3: Arr1JLString): JLObject; overload;  // throws javax.management.MBeanException, javax.management.ReflectionException
    function invoke(para1: JLString; var para2: array of JLObject; var para3: array of JLString): JLObject; overload;  // throws javax.management.MBeanException, javax.management.ReflectionException
    function getMBeanInfo(): JMMBeanInfo; overload;
  end;

  JMJMX = class external 'javax.management' name 'JMX' (JLObject)
  public
    const
      DEFAULT_VALUE_FIELD = 'defaultValue';
      IMMUTABLE_INFO_FIELD = 'immutableInfo';
      INTERFACE_CLASS_NAME_FIELD = 'interfaceClassName';
      LEGAL_VALUES_FIELD = 'legalValues';
      MAX_VALUE_FIELD = 'maxValue';
      MIN_VALUE_FIELD = 'minValue';
      MXBEAN_FIELD = 'mxbean';
      OPEN_TYPE_FIELD = 'openType';
      ORIGINAL_TYPE_FIELD = 'originalType';
  public
    class function newMBeanProxy(para1: JMMBeanServerConnection; para2: JMObjectName; para3: JLClass): JLObject; static; overload;
    class function newMBeanProxy(para1: JMMBeanServerConnection; para2: JMObjectName; para3: JLClass; para4: jboolean): JLObject; static; overload;
    class function newMXBeanProxy(para1: JMMBeanServerConnection; para2: JMObjectName; para3: JLClass): JLObject; static; overload;
    class function newMXBeanProxy(para1: JMMBeanServerConnection; para2: JMObjectName; para3: JLClass; para4: jboolean): JLObject; static; overload;
    class function isMXBeanInterface(para1: JLClass): jboolean; static; overload;
  end;

  JMMBeanRegistration = interface external 'javax.management' name 'MBeanRegistration' 
    function preRegister(para1: JMMBeanServer; para2: JMObjectName): JMObjectName; overload;  // throws java.lang.Exception
    procedure postRegister(para1: JLBoolean); overload;
    procedure preDeregister(); overload;  // throws java.lang.Exception
    procedure postDeregister(); overload;
  end;

  JMMBeanServerBuilder = class external 'javax.management' name 'MBeanServerBuilder' (JLObject)
  public
    constructor create(); overload;
    function newMBeanServerDelegate(): JMMBeanServerDelegate; overload; virtual;
    function newMBeanServer(para1: JLString; para2: JMMBeanServer; para3: JMMBeanServerDelegate): JMMBeanServer; overload; virtual;
  end;

  JMMBeanServerConnection = interface external 'javax.management' name 'MBeanServerConnection' 
    function createMBean(para1: JLString; para2: JMObjectName): JMObjectInstance; overload;  // throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException, javax.management.MBeanRegistrationException, javax.management.MBeanException, javax.management.NotCompliantMBeanException, java.io.IOException
    function createMBean(para1: JLString; para2: JMObjectName; para3: JMObjectName): JMObjectInstance; overload;  // throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException, javax.management.MBeanRegistrationException, javax.management.MBeanException, javax.management.NotCompliantMBeanException, javax.management.InstanceNotFoundException, java.io.IOException
    function createMBean(para1: JLString; para2: JMObjectName; para3: Arr1JLObject; para4: Arr1JLString): JMObjectInstance; overload;  // throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException, javax.management.MBeanRegistrationException, javax.management.MBeanException, javax.management.NotCompliantMBeanException, java.io.IOException
    function createMBean(para1: JLString; para2: JMObjectName; var para3: array of JLObject; var para4: array of JLString): JMObjectInstance; overload;  // throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException, javax.management.MBeanRegistrationException, javax.management.MBeanException, javax.management.NotCompliantMBeanException, java.io.IOException
    function createMBean(para1: JLString; para2: JMObjectName; para3: JMObjectName; para4: Arr1JLObject; para5: Arr1JLString): JMObjectInstance; overload;  // throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException, javax.management.MBeanRegistrationException, javax.management.MBeanException, javax.management.NotCompliantMBeanException, javax.management.InstanceNotFoundException, java.io.IOException
    function createMBean(para1: JLString; para2: JMObjectName; para3: JMObjectName; var para4: array of JLObject; var para5: array of JLString): JMObjectInstance; overload;  // throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException, javax.management.MBeanRegistrationException, javax.management.MBeanException, javax.management.NotCompliantMBeanException, javax.management.InstanceNotFoundException, java.io.IOException
    procedure unregisterMBean(para1: JMObjectName); overload;  // throws javax.management.InstanceNotFoundException, javax.management.MBeanRegistrationException, java.io.IOException
    function getObjectInstance(para1: JMObjectName): JMObjectInstance; overload;  // throws javax.management.InstanceNotFoundException, java.io.IOException
    function queryMBeans(para1: JMObjectName; para2: JMQueryExp): JUSet; overload;  // throws java.io.IOException
    function queryNames(para1: JMObjectName; para2: JMQueryExp): JUSet; overload;  // throws java.io.IOException
    function isRegistered(para1: JMObjectName): jboolean; overload;  // throws java.io.IOException
    function getMBeanCount(): JLInteger; overload;  // throws java.io.IOException
    function getAttribute(para1: JMObjectName; para2: JLString): JLObject; overload;  // throws javax.management.MBeanException, javax.management.AttributeNotFoundException, javax.management.InstanceNotFoundException, javax.management.ReflectionException, java.io.IOException
    function getAttributes(para1: JMObjectName; para2: Arr1JLString): JMAttributeList; overload;  // throws javax.management.InstanceNotFoundException, javax.management.ReflectionException, java.io.IOException
    function getAttributes(para1: JMObjectName; var para2: array of JLString): JMAttributeList; overload;  // throws javax.management.InstanceNotFoundException, javax.management.ReflectionException, java.io.IOException
    procedure setAttribute(para1: JMObjectName; para2: JMAttribute); overload;  // throws javax.management.InstanceNotFoundException, javax.management.AttributeNotFoundException, javax.management.InvalidAttributeValueException, javax.management.MBeanException, javax.management.ReflectionException, java.io.IOException
    function setAttributes(para1: JMObjectName; para2: JMAttributeList): JMAttributeList; overload;  // throws javax.management.InstanceNotFoundException, javax.management.ReflectionException, java.io.IOException
    function invoke(para1: JMObjectName; para2: JLString; para3: Arr1JLObject; para4: Arr1JLString): JLObject; overload;  // throws javax.management.InstanceNotFoundException, javax.management.MBeanException, javax.management.ReflectionException, java.io.IOException
    function invoke(para1: JMObjectName; para2: JLString; var para3: array of JLObject; var para4: array of JLString): JLObject; overload;  // throws javax.management.InstanceNotFoundException, javax.management.MBeanException, javax.management.ReflectionException, java.io.IOException
    function getDefaultDomain(): JLString; overload;  // throws java.io.IOException
    function getDomains(): Arr1JLString; overload;  // throws java.io.IOException
    procedure addNotificationListener(para1: JMObjectName; para2: JMNotificationListener; para3: JMNotificationFilter; para4: JLObject); overload;  // throws javax.management.InstanceNotFoundException, java.io.IOException
    procedure addNotificationListener(para1: JMObjectName; para2: JMObjectName; para3: JMNotificationFilter; para4: JLObject); overload;  // throws javax.management.InstanceNotFoundException, java.io.IOException
    procedure removeNotificationListener(para1: JMObjectName; para2: JMObjectName); overload;  // throws javax.management.InstanceNotFoundException, javax.management.ListenerNotFoundException, java.io.IOException
    procedure removeNotificationListener(para1: JMObjectName; para2: JMObjectName; para3: JMNotificationFilter; para4: JLObject); overload;  // throws javax.management.InstanceNotFoundException, javax.management.ListenerNotFoundException, java.io.IOException
    procedure removeNotificationListener(para1: JMObjectName; para2: JMNotificationListener); overload;  // throws javax.management.InstanceNotFoundException, javax.management.ListenerNotFoundException, java.io.IOException
    procedure removeNotificationListener(para1: JMObjectName; para2: JMNotificationListener; para3: JMNotificationFilter; para4: JLObject); overload;  // throws javax.management.InstanceNotFoundException, javax.management.ListenerNotFoundException, java.io.IOException
    function getMBeanInfo(para1: JMObjectName): JMMBeanInfo; overload;  // throws javax.management.InstanceNotFoundException, javax.management.IntrospectionException, javax.management.ReflectionException, java.io.IOException
    function isInstanceOf(para1: JMObjectName; para2: JLString): jboolean; overload;  // throws javax.management.InstanceNotFoundException, java.io.IOException
  end;

  JMMBeanServerDelegateMBean = interface external 'javax.management' name 'MBeanServerDelegateMBean' 
    function getMBeanServerId(): JLString; overload;
    function getSpecificationName(): JLString; overload;
    function getSpecificationVersion(): JLString; overload;
    function getSpecificationVendor(): JLString; overload;
    function getImplementationName(): JLString; overload;
    function getImplementationVersion(): JLString; overload;
    function getImplementationVendor(): JLString; overload;
  end;

  JMMBeanServerFactory = class external 'javax.management' name 'MBeanServerFactory' (JLObject)
  public
    class procedure releaseMBeanServer(para1: JMMBeanServer); static; overload;
    class function createMBeanServer(): JMMBeanServer; static; overload;
    class function createMBeanServer(para1: JLString): JMMBeanServer; static; overload;
    class function newMBeanServer(): JMMBeanServer; static; overload;
    class function newMBeanServer(para1: JLString): JMMBeanServer; static; overload;
    class function findMBeanServer(para1: JLString): JUArrayList; static; overload;
    class function getClassLoaderRepository(para1: JMMBeanServer): JMLClassLoaderRepository; static; overload;
  end;

  JMNotificationBroadcaster = interface external 'javax.management' name 'NotificationBroadcaster' 
    procedure addNotificationListener(para1: JMNotificationListener; para2: JMNotificationFilter; para3: JLObject); overload;  // throws java.lang.IllegalArgumentException
    procedure removeNotificationListener(para1: JMNotificationListener); overload;  // throws javax.management.ListenerNotFoundException
    function getNotificationInfo(): Arr1JMMBeanNotificationInfo; overload;
  end;

  JMPersistentMBean = interface external 'javax.management' name 'PersistentMBean' 
    procedure load(); overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException, javax.management.InstanceNotFoundException
    procedure store(); overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException, javax.management.InstanceNotFoundException
  end;

  JMQuery = class external 'javax.management' name 'Query' (JLObject)
  public
    const
      GT = 0;
      LT = 1;
      GE = 2;
      LE = 3;
      EQ = 4;
      PLUS = 0;
      MINUS = 1;
      TIMES = 2;
      &DIV = 3;
  public
    constructor create(); overload;
    class function &and(para1: JMQueryExp; para2: JMQueryExp): JMQueryExp; static; overload;
    class function &or(para1: JMQueryExp; para2: JMQueryExp): JMQueryExp; static; overload;
    class function gt_(para1: JMValueExp; para2: JMValueExp): JMQueryExp; static; external name 'gt'; overload;
    class function geq(para1: JMValueExp; para2: JMValueExp): JMQueryExp; static; overload;
    class function leq(para1: JMValueExp; para2: JMValueExp): JMQueryExp; static; overload;
    class function lt_(para1: JMValueExp; para2: JMValueExp): JMQueryExp; static; external name 'lt'; overload;
    class function eq_(para1: JMValueExp; para2: JMValueExp): JMQueryExp; static; external name 'eq'; overload;
    class function between(para1: JMValueExp; para2: JMValueExp; para3: JMValueExp): JMQueryExp; static; overload;
    class function match(para1: JMAttributeValueExp; para2: JMStringValueExp): JMQueryExp; static; overload;
    class function attr(para1: JLString): JMAttributeValueExp; static; overload;
    class function attr(para1: JLString; para2: JLString): JMAttributeValueExp; static; overload;
    class function classattr(): JMAttributeValueExp; static; overload;
    class function &not(para1: JMQueryExp): JMQueryExp; static; overload;
    class function &in(para1: JMValueExp; para2: Arr1JMValueExp): JMQueryExp; static; overload;
    class function &in(para1: JMValueExp; var para2: array of JMValueExp): JMQueryExp; static; overload;
    class function value(para1: JLString): JMStringValueExp; static; overload;
    class function value(para1: JLNumber): JMValueExp; static; overload;
    class function value(para1: jint): JMValueExp; static; overload;
    class function value(para1: jlong): JMValueExp; static; overload;
    class function value(para1: jfloat): JMValueExp; static; overload;
    class function value(para1: jdouble): JMValueExp; static; overload;
    class function value(para1: jboolean): JMValueExp; static; overload;
    class function plus_(para1: JMValueExp; para2: JMValueExp): JMValueExp; static; external name 'plus'; overload;
    class function times_(para1: JMValueExp; para2: JMValueExp): JMValueExp; static; external name 'times'; overload;
    class function minus_(para1: JMValueExp; para2: JMValueExp): JMValueExp; static; external name 'minus'; overload;
    class function &div_(para1: JMValueExp; para2: JMValueExp): JMValueExp; static; external name 'div'; overload;
    class function initialSubString(para1: JMAttributeValueExp; para2: JMStringValueExp): JMQueryExp; static; overload;
    class function anySubString(para1: JMAttributeValueExp; para2: JMStringValueExp): JMQueryExp; static; overload;
    class function finalSubString(para1: JMAttributeValueExp; para2: JMStringValueExp): JMQueryExp; static; overload;
    class function isInstanceOf(para1: JMStringValueExp): JMQueryExp; static; overload;
  end;

  JMLClassLoaderRepository = interface external 'javax.management.loading' name 'ClassLoaderRepository' 
    function loadClass(para1: JLString): JLClass; overload;  // throws java.lang.ClassNotFoundException
    function loadClassWithout(para1: JLClassLoader; para2: JLString): JLClass; overload;  // throws java.lang.ClassNotFoundException
    function loadClassBefore(para1: JLClassLoader; para2: JLString): JLClass; overload;  // throws java.lang.ClassNotFoundException
  end;

  JMLDefaultLoaderRepository = class external 'javax.management.loading' name 'DefaultLoaderRepository' (JLObject)
  public
    constructor create(); overload;
    class function loadClass(para1: JLString): JLClass; static; overload;  // throws java.lang.ClassNotFoundException
    class function loadClassWithout(para1: JLClassLoader; para2: JLString): JLClass; static; overload;  // throws java.lang.ClassNotFoundException
  end;

  JMLMLetContent = class external 'javax.management.loading' name 'MLetContent' (JLObject)
  public
    constructor create(para1: JNURL; para2: JUMap; para3: JUList; para4: JUList); overload;
    function getAttributes(): JUMap; overload; virtual;
    function getDocumentBase(): JNURL; overload; virtual;
    function getCodeBase(): JNURL; overload; virtual;
    function getJarFiles(): JLString; overload; virtual;
    function getCode(): JLString; overload; virtual;
    function getSerializedObject(): JLString; overload; virtual;
    function getName(): JLString; overload; virtual;
    function getVersion(): JLString; overload; virtual;
    function getParameterTypes(): JUList; overload; virtual;
    function getParameterValues(): JUList; overload; virtual;
  end;

  JMLMLetMBean = interface external 'javax.management.loading' name 'MLetMBean' 
    function getMBeansFromURL(para1: JLString): JUSet; overload;  // throws javax.management.ServiceNotFoundException
    function getMBeansFromURL(para1: JNURL): JUSet; overload;  // throws javax.management.ServiceNotFoundException
    procedure addURL(para1: JNURL); overload;
    procedure addURL(para1: JLString); overload;  // throws javax.management.ServiceNotFoundException
    function getURLs(): Arr1JNURL; overload;
    function getResource(para1: JLString): JNURL; overload;
    function getResourceAsStream(para1: JLString): JIInputStream; overload;
    function getResources(para1: JLString): JUEnumeration; overload;  // throws java.io.IOException
    function getLibraryDirectory(): JLString; overload;
    procedure setLibraryDirectory(para1: JLString); overload;
  end;

  JMLMLetParser = class external 'javax.management.loading' name 'MLetParser' (JLObject)
  public
    constructor create(); overload;
    procedure skipSpace(para1: JIReader); overload; virtual;  // throws java.io.IOException
    function scanIdentifier(para1: JIReader): JLString; overload; virtual;  // throws java.io.IOException
    function scanTag(para1: JIReader): JUMap; overload; virtual;  // throws java.io.IOException
    function parse(para1: JNURL): JUList; overload; virtual;  // throws java.io.IOException
    function parseURL(para1: JLString): JUList; overload; virtual;  // throws java.io.IOException
  end;

  JMLPrivateClassLoader = interface external 'javax.management.loading' name 'PrivateClassLoader' 
  end;

  JMMModelMBeanInfo = interface external 'javax.management.modelmbean' name 'ModelMBeanInfo' 
    function getDescriptors(para1: JLString): Arr1JMDescriptor; overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    procedure setDescriptors(para1: Arr1JMDescriptor); overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    procedure setDescriptors(var para1: array of JMDescriptor); overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    function getDescriptor(para1: JLString; para2: JLString): JMDescriptor; overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    procedure setDescriptor(para1: JMDescriptor; para2: JLString); overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    function getMBeanDescriptor(): JMDescriptor; overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    procedure setMBeanDescriptor(para1: JMDescriptor); overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    function getAttribute(para1: JLString): JMMModelMBeanAttributeInfo; overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    function getOperation(para1: JLString): JMMModelMBeanOperationInfo; overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    function getNotification(para1: JLString): JMMModelMBeanNotificationInfo; overload;  // throws javax.management.MBeanException, javax.management.RuntimeOperationsException
    function clone(): JLObject; overload;
    function getAttributes(): Arr1JMMBeanAttributeInfo; overload;
    function getClassName(): JLString; overload;
    function getConstructors(): Arr1JMMBeanConstructorInfo; overload;
    function getDescription(): JLString; overload;
    function getNotifications(): Arr1JMMBeanNotificationInfo; overload;
    function getOperations(): Arr1JMMBeanOperationInfo; overload;
  end;

  JMMMonitorMBean = interface external 'javax.management.monitor' name 'MonitorMBean' 
    procedure start(); overload;
    procedure stop(); overload;
    procedure addObservedObject(para1: JMObjectName); overload;  // throws java.lang.IllegalArgumentException
    procedure removeObservedObject(para1: JMObjectName); overload;
    function containsObservedObject(para1: JMObjectName): jboolean; overload;
    function getObservedObjects(): Arr1JMObjectName; overload;
    function getObservedObject(): JMObjectName; overload;
    procedure setObservedObject(para1: JMObjectName); overload;
    function getObservedAttribute(): JLString; overload;
    procedure setObservedAttribute(para1: JLString); overload;
    function getGranularityPeriod(): jlong; overload;
    procedure setGranularityPeriod(para1: jlong); overload;  // throws java.lang.IllegalArgumentException
    function isActive(): jboolean; overload;
  end;

  JMOCompositeData = interface external 'javax.management.openmbean' name 'CompositeData' 
    function getCompositeType(): JMOCompositeType; overload;
    function get(para1: JLString): JLObject; overload;
    function getAll(para1: Arr1JLString): Arr1JLObject; overload;
    function getAll(var para1: array of JLString): Arr1JLObject; overload;
    function containsKey(para1: JLString): jboolean; overload;
    function containsValue(para1: JLObject): jboolean; overload;
    function values(): JUCollection; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
  end;

  JMOCompositeDataView = interface external 'javax.management.openmbean' name 'CompositeDataView' 
    function toCompositeData(para1: JMOCompositeType): JMOCompositeData; overload;
  end;

  JMOOpenMBeanConstructorInfo = interface external 'javax.management.openmbean' name 'OpenMBeanConstructorInfo' 
    function getDescription(): JLString; overload;
    function getName(): JLString; overload;
    function getSignature(): Arr1JMMBeanParameterInfo; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
  end;

  JMOOpenMBeanInfo = interface external 'javax.management.openmbean' name 'OpenMBeanInfo' 
    function getClassName(): JLString; overload;
    function getDescription(): JLString; overload;
    function getAttributes(): Arr1JMMBeanAttributeInfo; overload;
    function getOperations(): Arr1JMMBeanOperationInfo; overload;
    function getConstructors(): Arr1JMMBeanConstructorInfo; overload;
    function getNotifications(): Arr1JMMBeanNotificationInfo; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
  end;

  JMOOpenMBeanOperationInfo = interface external 'javax.management.openmbean' name 'OpenMBeanOperationInfo' 
    function getDescription(): JLString; overload;
    function getName(): JLString; overload;
    function getSignature(): Arr1JMMBeanParameterInfo; overload;
    function getImpact(): jint; overload;
    function getReturnType(): JLString; overload;
    function getReturnOpenType(): JMOOpenType; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
  end;

  JMOOpenMBeanParameterInfo = interface external 'javax.management.openmbean' name 'OpenMBeanParameterInfo' 
    function getDescription(): JLString; overload;
    function getName(): JLString; overload;
    function getOpenType(): JMOOpenType; overload;
    function getDefaultValue(): JLObject; overload;
    function getLegalValues(): JUSet; overload;
    function getMinValue(): JLComparable; overload;
    function getMaxValue(): JLComparable; overload;
    function hasDefaultValue(): jboolean; overload;
    function hasLegalValues(): jboolean; overload;
    function hasMinValue(): jboolean; overload;
    function hasMaxValue(): jboolean; overload;
    function isValue(para1: JLObject): jboolean; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
  end;

  JMOTabularData = interface external 'javax.management.openmbean' name 'TabularData' 
    function getTabularType(): JMOTabularType; overload;
    function calculateIndex(para1: JMOCompositeData): Arr1JLObject; overload;
    function size(): jint; overload;
    function isEmpty(): jboolean; overload;
    function containsKey(para1: Arr1JLObject): jboolean; overload;
    function containsKey(var para1: array of JLObject): jboolean; overload;
    function containsValue(para1: JMOCompositeData): jboolean; overload;
    function get(para1: Arr1JLObject): JMOCompositeData; overload;
    function get(var para1: array of JLObject): JMOCompositeData; overload;
    procedure put(para1: JMOCompositeData); overload;
    function remove(para1: Arr1JLObject): JMOCompositeData; overload;
    function remove(var para1: array of JLObject): JMOCompositeData; overload;
    procedure putAll(para1: Arr1JMOCompositeData); overload;
    procedure putAll(var para1: array of JMOCompositeData); overload;
    procedure clear(); overload;
    function keySet(): JUSet; overload;
    function values(): JUCollection; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function toString(): JLString; overload;
  end;

  JMRRelation = interface external 'javax.management.relation' name 'Relation' 
    function getRole(para1: JLString): JUList; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RoleNotFoundException, javax.management.relation.RelationServiceNotRegisteredException
    function getRoles(para1: Arr1JLString): JMRRoleResult; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationServiceNotRegisteredException
    function getRoles(var para1: array of JLString): JMRRoleResult; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationServiceNotRegisteredException
    function getRoleCardinality(para1: JLString): JLInteger; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RoleNotFoundException
    function getAllRoles(): JMRRoleResult; overload;  // throws javax.management.relation.RelationServiceNotRegisteredException
    function retrieveAllRoles(): JMRRoleList; overload;
    procedure setRole(para1: JMRRole); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RoleNotFoundException, javax.management.relation.RelationTypeNotFoundException, javax.management.relation.InvalidRoleValueException, javax.management.relation.RelationServiceNotRegisteredException, javax.management.relation.RelationNotFoundException
    function setRoles(para1: JMRRoleList): JMRRoleResult; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationServiceNotRegisteredException, javax.management.relation.RelationTypeNotFoundException, javax.management.relation.RelationNotFoundException
    procedure handleMBeanUnregistration(para1: JMObjectName; para2: JLString); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RoleNotFoundException, javax.management.relation.InvalidRoleValueException, javax.management.relation.RelationServiceNotRegisteredException, javax.management.relation.RelationTypeNotFoundException, javax.management.relation.RelationNotFoundException
    function getReferencedMBeans(): JUMap; overload;
    function getRelationTypeName(): JLString; overload;
    function getRelationServiceName(): JMObjectName; overload;
    function getRelationId(): JLString; overload;
  end;

  JMRRelationServiceMBean = interface external 'javax.management.relation' name 'RelationServiceMBean' 
    procedure isActive(); overload;  // throws javax.management.relation.RelationServiceNotRegisteredException
    function getPurgeFlag(): jboolean; overload;
    procedure setPurgeFlag(para1: jboolean); overload;
    procedure createRelationType(para1: JLString; para2: Arr1JMRRoleInfo); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.InvalidRelationTypeException
    procedure createRelationType(para1: JLString; var para2: array of JMRRoleInfo); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.InvalidRelationTypeException
    procedure addRelationType(para1: JMRRelationType); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.InvalidRelationTypeException
    function getAllRelationTypeNames(): JUList; overload;
    function getRoleInfos(para1: JLString): JUList; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationTypeNotFoundException
    function getRoleInfo(para1: JLString; para2: JLString): JMRRoleInfo; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationTypeNotFoundException, javax.management.relation.RoleInfoNotFoundException
    procedure removeRelationType(para1: JLString); overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RelationTypeNotFoundException
    procedure createRelation(para1: JLString; para2: JLString; para3: JMRRoleList); overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RoleNotFoundException, javax.management.relation.InvalidRelationIdException, javax.management.relation.RelationTypeNotFoundException, javax.management.relation.InvalidRoleValueException
    procedure addRelation(para1: JMObjectName); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationServiceNotRegisteredException, java.lang.NoSuchMethodException, javax.management.relation.InvalidRelationIdException, javax.management.InstanceNotFoundException, javax.management.relation.InvalidRelationServiceException, javax.management.relation.RelationTypeNotFoundException, javax.management.relation.RoleNotFoundException, javax.management.relation.InvalidRoleValueException
    function isRelationMBean(para1: JLString): JMObjectName; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    function isRelation(para1: JMObjectName): JLString; overload;  // throws java.lang.IllegalArgumentException
    function hasRelation(para1: JLString): JLBoolean; overload;  // throws java.lang.IllegalArgumentException
    function getAllRelationIds(): JUList; overload;
    function checkRoleReading(para1: JLString; para2: JLString): JLInteger; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationTypeNotFoundException
    function checkRoleWriting(para1: JMRRole; para2: JLString; para3: JLBoolean): JLInteger; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationTypeNotFoundException
    procedure sendRelationCreationNotification(para1: JLString); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    procedure sendRoleUpdateNotification(para1: JLString; para2: JMRRole; para3: JUList); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    procedure sendRelationRemovalNotification(para1: JLString; para2: JUList); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    procedure updateRoleMap(para1: JLString; para2: JMRRole; para3: JUList); overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationServiceNotRegisteredException, javax.management.relation.RelationNotFoundException
    procedure removeRelation(para1: JLString); overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    procedure purgeRelations(); overload;  // throws javax.management.relation.RelationServiceNotRegisteredException
    function findReferencingRelations(para1: JMObjectName; para2: JLString; para3: JLString): JUMap; overload;  // throws java.lang.IllegalArgumentException
    function findAssociatedMBeans(para1: JMObjectName; para2: JLString; para3: JLString): JUMap; overload;  // throws java.lang.IllegalArgumentException
    function findRelationsOfType(para1: JLString): JUList; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationTypeNotFoundException
    function getRole(para1: JLString; para2: JLString): JUList; overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException, javax.management.relation.RoleNotFoundException
    function getRoles(para1: JLString; para2: Arr1JLString): JMRRoleResult; overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    function getRoles(para1: JLString; var para2: array of JLString): JMRRoleResult; overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    function getAllRoles(para1: JLString): JMRRoleResult; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException, javax.management.relation.RelationServiceNotRegisteredException
    function getRoleCardinality(para1: JLString; para2: JLString): JLInteger; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException, javax.management.relation.RoleNotFoundException
    procedure setRole(para1: JLString; para2: JMRRole); overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException, javax.management.relation.RoleNotFoundException, javax.management.relation.InvalidRoleValueException, javax.management.relation.RelationTypeNotFoundException
    function setRoles(para1: JLString; para2: JMRRoleList): JMRRoleResult; overload;  // throws javax.management.relation.RelationServiceNotRegisteredException, java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    function getReferencedMBeans(para1: JLString): JUMap; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
    function getRelationTypeName(para1: JLString): JLString; overload;  // throws java.lang.IllegalArgumentException, javax.management.relation.RelationNotFoundException
  end;

  JMRRoleStatus = class external 'javax.management.relation' name 'RoleStatus' (JLObject)
  public
    const
      NO_ROLE_WITH_NAME = 1;
      ROLE_NOT_READABLE = 2;
      ROLE_NOT_WRITABLE = 3;
      LESS_THAN_MIN_ROLE_DEGREE = 4;
      MORE_THAN_MAX_ROLE_DEGREE = 5;
      REF_MBEAN_OF_INCORRECT_CLASS = 6;
      REF_MBEAN_NOT_REGISTERED = 7;
  public
    constructor create(); overload;
    class function isRoleStatus(para1: jint): jboolean; static; overload;
  end;

  JMRJMXAddressable = interface external 'javax.management.remote' name 'JMXAddressable' 
    function getAddress(): JMRJMXServiceURL; overload;
  end;

  JMRJMXAuthenticator = interface external 'javax.management.remote' name 'JMXAuthenticator' 
    function authenticate(para1: JLObject): JSASubject; overload;
  end;

  JMRJMXConnectorFactory = class external 'javax.management.remote' name 'JMXConnectorFactory' (JLObject)
  public
    const
      DEFAULT_CLASS_LOADER = 'jmx.remote.default.class.loader';
      PROTOCOL_PROVIDER_PACKAGES = 'jmx.remote.protocol.provider.pkgs';
      PROTOCOL_PROVIDER_CLASS_LOADER = 'jmx.remote.protocol.provider.class.loader';
  public
    class function connect(para1: JMRJMXServiceURL): JMRJMXConnector; static; overload;  // throws java.io.IOException
    class function connect(para1: JMRJMXServiceURL; para2: JUMap): JMRJMXConnector; static; overload;  // throws java.io.IOException
    class function newJMXConnector(para1: JMRJMXServiceURL; para2: JUMap): JMRJMXConnector; static; overload;  // throws java.io.IOException
  end;

  JMRJMXConnectorProvider = interface external 'javax.management.remote' name 'JMXConnectorProvider' 
    function newJMXConnector(para1: JMRJMXServiceURL; para2: JUMap): JMRJMXConnector; overload;  // throws java.io.IOException
  end;

  JMRJMXConnectorServerFactory = class external 'javax.management.remote' name 'JMXConnectorServerFactory' (JLObject)
  public
    const
      DEFAULT_CLASS_LOADER = 'jmx.remote.default.class.loader';
      DEFAULT_CLASS_LOADER_NAME = 'jmx.remote.default.class.loader.name';
      PROTOCOL_PROVIDER_PACKAGES = 'jmx.remote.protocol.provider.pkgs';
      PROTOCOL_PROVIDER_CLASS_LOADER = 'jmx.remote.protocol.provider.class.loader';
  public
    class function newJMXConnectorServer(para1: JMRJMXServiceURL; para2: JUMap; para3: JMMBeanServer): JMRJMXConnectorServer; static; overload;  // throws java.io.IOException
  end;

  JMRJMXConnectorServerMBean = interface external 'javax.management.remote' name 'JMXConnectorServerMBean' 
    procedure start(); overload;  // throws java.io.IOException
    procedure stop(); overload;  // throws java.io.IOException
    function isActive(): jboolean; overload;
    procedure setMBeanServerForwarder(para1: JMRMBeanServerForwarder); overload;
    function getConnectionIds(): Arr1JLString; overload;
    function getAddress(): JMRJMXServiceURL; overload;
    function getAttributes(): JUMap; overload;
    function toJMXConnector(para1: JUMap): JMRJMXConnector; overload;  // throws java.io.IOException
  end;

  JMRJMXConnectorServerProvider = interface external 'javax.management.remote' name 'JMXConnectorServerProvider' 
    function newJMXConnectorServer(para1: JMRJMXServiceURL; para2: JUMap; para3: JMMBeanServer): JMRJMXConnectorServer; overload;  // throws java.io.IOException
  end;

  JMTTimerMBean = interface external 'javax.management.timer' name 'TimerMBean' 
    procedure start(); overload;
    procedure stop(); overload;
    function addNotification(para1: JLString; para2: JLString; para3: JLObject; para4: JUDate; para5: jlong; para6: jlong; para7: jboolean): JLInteger; overload;  // throws java.lang.IllegalArgumentException
    function addNotification(para1: JLString; para2: JLString; para3: JLObject; para4: JUDate; para5: jlong; para6: jlong): JLInteger; overload;  // throws java.lang.IllegalArgumentException
    function addNotification(para1: JLString; para2: JLString; para3: JLObject; para4: JUDate; para5: jlong): JLInteger; overload;  // throws java.lang.IllegalArgumentException
    function addNotification(para1: JLString; para2: JLString; para3: JLObject; para4: JUDate): JLInteger; overload;  // throws java.lang.IllegalArgumentException
    procedure removeNotification(para1: JLInteger); overload;  // throws javax.management.InstanceNotFoundException
    procedure removeNotifications(para1: JLString); overload;  // throws javax.management.InstanceNotFoundException
    procedure removeAllNotifications(); overload;
    function getNbNotifications(): jint; overload;
    function getAllNotificationIDs(): JUVector; overload;
    function getNotificationIDs(para1: JLString): JUVector; overload;
    function getNotificationType(para1: JLInteger): JLString; overload;
    function getNotificationMessage(para1: JLInteger): JLString; overload;
    function getNotificationUserData(para1: JLInteger): JLObject; overload;
    function getDate(para1: JLInteger): JUDate; overload;
    function getPeriod(para1: JLInteger): JLLong; overload;
    function getNbOccurences(para1: JLInteger): JLLong; overload;
    function getFixedRate(para1: JLInteger): JLBoolean; overload;
    function getSendPastNotifications(): jboolean; overload;
    procedure setSendPastNotifications(para1: jboolean); overload;
    function isActive(): jboolean; overload;
    function isEmpty(): jboolean; overload;
  end;

  JNContext = interface external 'javax.naming' name 'Context' 
    const
      INITIAL_CONTEXT_FACTORY = 'java.naming.factory.initial';
      OBJECT_FACTORIES = 'java.naming.factory.object';
      STATE_FACTORIES = 'java.naming.factory.state';
      URL_PKG_PREFIXES = 'java.naming.factory.url.pkgs';
      PROVIDER_URL = 'java.naming.provider.url';
      DNS_URL = 'java.naming.dns.url';
      AUTHORITATIVE = 'java.naming.authoritative';
      BATCHSIZE = 'java.naming.batchsize';
      REFERRAL = 'java.naming.referral';
      SECURITY_PROTOCOL = 'java.naming.security.protocol';
      SECURITY_AUTHENTICATION = 'java.naming.security.authentication';
      SECURITY_PRINCIPAL = 'java.naming.security.principal';
      SECURITY_CREDENTIALS = 'java.naming.security.credentials';
      LANGUAGE = 'java.naming.language';
      APPLET = 'java.naming.applet';
    function lookup(para1: JNName): JLObject; overload;  // throws javax.naming.NamingException
    function lookup(para1: JLString): JLObject; overload;  // throws javax.naming.NamingException
    procedure bind(para1: JNName; para2: JLObject); overload;  // throws javax.naming.NamingException
    procedure bind(para1: JLString; para2: JLObject); overload;  // throws javax.naming.NamingException
    procedure rebind(para1: JNName; para2: JLObject); overload;  // throws javax.naming.NamingException
    procedure rebind(para1: JLString; para2: JLObject); overload;  // throws javax.naming.NamingException
    procedure unbind(para1: JNName); overload;  // throws javax.naming.NamingException
    procedure unbind(para1: JLString); overload;  // throws javax.naming.NamingException
    procedure rename(para1: JNName; para2: JNName); overload;  // throws javax.naming.NamingException
    procedure rename(para1: JLString; para2: JLString); overload;  // throws javax.naming.NamingException
    function list(para1: JNName): JNNamingEnumeration; overload;  // throws javax.naming.NamingException
    function list(para1: JLString): JNNamingEnumeration; overload;  // throws javax.naming.NamingException
    function listBindings(para1: JNName): JNNamingEnumeration; overload;  // throws javax.naming.NamingException
    function listBindings(para1: JLString): JNNamingEnumeration; overload;  // throws javax.naming.NamingException
    procedure destroySubcontext(para1: JNName); overload;  // throws javax.naming.NamingException
    procedure destroySubcontext(para1: JLString); overload;  // throws javax.naming.NamingException
    function createSubcontext(para1: JNName): JNContext; overload;  // throws javax.naming.NamingException
    function createSubcontext(para1: JLString): JNContext; overload;  // throws javax.naming.NamingException
    function lookupLink(para1: JNName): JLObject; overload;  // throws javax.naming.NamingException
    function lookupLink(para1: JLString): JLObject; overload;  // throws javax.naming.NamingException
    function getNameParser(para1: JNName): JNNameParser; overload;  // throws javax.naming.NamingException
    function getNameParser(para1: JLString): JNNameParser; overload;  // throws javax.naming.NamingException
    function composeName(para1: JNName; para2: JNName): JNName; overload;  // throws javax.naming.NamingException
    function composeName(para1: JLString; para2: JLString): JLString; overload;  // throws javax.naming.NamingException
    function addToEnvironment(para1: JLString; para2: JLObject): JLObject; overload;  // throws javax.naming.NamingException
    function removeFromEnvironment(para1: JLString): JLObject; overload;  // throws javax.naming.NamingException
    function getEnvironment(): JUHashtable; overload;  // throws javax.naming.NamingException
    procedure close(); overload;  // throws javax.naming.NamingException
    function getNameInNamespace(): JLString; overload;  // throws javax.naming.NamingException
  end;

  JNNameImpl = class external 'javax.naming' name 'NameImpl' (JLObject)
  public
    function toString(): JLString; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function compareTo(para1: JNNameImpl): jint; overload; virtual;
    function size(): jint; overload; virtual;
    function getAll(): JUEnumeration; overload; virtual;
    function get(para1: jint): JLString; overload; virtual;
    function getPrefix(para1: jint): JUEnumeration; overload; virtual;
    function getSuffix(para1: jint): JUEnumeration; overload; virtual;
    function isEmpty(): jboolean; overload; virtual;
    function startsWith(para1: jint; para2: JUEnumeration): jboolean; overload; virtual;
    function endsWith(para1: jint; para2: JUEnumeration): jboolean; overload; virtual;
    function addAll(para1: JUEnumeration): jboolean; overload; virtual;  // throws javax.naming.InvalidNameException
    function addAll(para1: jint; para2: JUEnumeration): jboolean; overload; virtual;  // throws javax.naming.InvalidNameException
    procedure add(para1: JLString); overload; virtual;  // throws javax.naming.InvalidNameException
    procedure add(para1: jint; para2: JLString); overload; virtual;  // throws javax.naming.InvalidNameException
    function remove(para1: jint): JLObject; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  JNNameParser = interface external 'javax.naming' name 'NameParser' 
    function parse(para1: JLString): JNName; overload;  // throws javax.naming.NamingException
  end;

  JNReferenceable = interface external 'javax.naming' name 'Referenceable' 
    function getReference(): JNReference; overload;  // throws javax.naming.NamingException
  end;

  JNLControlFactory = class abstract external 'javax.naming.ldap' name 'ControlFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function getControlInstance(para1: JNLControl): JNLControl; overload; virtual; abstract;  // throws javax.naming.NamingException
    class function getControlInstance(para1: JNLControl; para2: JNContext; para3: JUHashtable): JNLControl; static; overload;  // throws javax.naming.NamingException
  end;

  JNLHasControls = interface external 'javax.naming.ldap' name 'HasControls' 
    function getControls(): Arr1JNLControl; overload;  // throws javax.naming.NamingException
  end;

  JNLRfc2253Parser = class sealed external 'javax.naming.ldap' name 'Rfc2253Parser' (JLObject)
  end;

  JNLSortKey = class external 'javax.naming.ldap' name 'SortKey' (JLObject)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: jboolean; para3: JLString); overload;
    function getAttributeID(): JLString; overload; virtual;
    function isAscending(): jboolean; overload; virtual;
    function getMatchingRuleID(): JLString; overload; virtual;
  end;

  JNSDirContextNamePair = class external 'javax.naming.spi' name 'DirContextNamePair' (JLObject)
  end;

  JNSDirContextStringPair = class external 'javax.naming.spi' name 'DirContextStringPair' (JLObject)
  end;

  JNSInitialContextFactory = interface external 'javax.naming.spi' name 'InitialContextFactory' 
    function getInitialContext(para1: JUHashtable): JNContext; overload;  // throws javax.naming.NamingException
  end;

  JNSInitialContextFactoryBuilder = interface external 'javax.naming.spi' name 'InitialContextFactoryBuilder' 
    function createInitialContextFactory(para1: JUHashtable): JNSInitialContextFactory; overload;  // throws javax.naming.NamingException
  end;

  JNSNamingManager = class external 'javax.naming.spi' name 'NamingManager' (JLObject)
  public
    const
      CPE = 'java.naming.spi.CannotProceedException';
  public
    class procedure setObjectFactoryBuilder(para1: JNSObjectFactoryBuilder); static; overload;  // throws javax.naming.NamingException
    class function getObjectInstance(para1: JLObject; para2: JNName; para3: JNContext; para4: JUHashtable): JLObject; static; overload;  // throws java.lang.Exception
    class function getURLContext(para1: JLString; para2: JUHashtable): JNContext; static; overload;  // throws javax.naming.NamingException
    class function getInitialContext(para1: JUHashtable): JNContext; static; overload;  // throws javax.naming.NamingException
    class procedure setInitialContextFactoryBuilder(para1: JNSInitialContextFactoryBuilder); static; overload;  // throws javax.naming.NamingException
    class function hasInitialContextFactoryBuilder(): jboolean; static; overload;
    class function getContinuationContext(para1: JNCannotProceedException): JNContext; static; overload;  // throws javax.naming.NamingException
    class function getStateToBind(para1: JLObject; para2: JNName; para3: JNContext; para4: JUHashtable): JLObject; static; overload;  // throws javax.naming.NamingException
  end;

  JNSObjectFactory = interface external 'javax.naming.spi' name 'ObjectFactory' 
    function getObjectInstance(para1: JLObject; para2: JNName; para3: JNContext; para4: JUHashtable): JLObject; overload;  // throws java.lang.Exception
  end;

  JNSObjectFactoryBuilder = interface external 'javax.naming.spi' name 'ObjectFactoryBuilder' 
    function createObjectFactory(para1: JLObject; para2: JUHashtable): JNSObjectFactory; overload;  // throws javax.naming.NamingException
  end;

  JNSResolver = interface external 'javax.naming.spi' name 'Resolver' 
    function resolveToClass(para1: JNName; para2: JLClass): JNSResolveResult; overload;  // throws javax.naming.NamingException
    function resolveToClass(para1: JLString; para2: JLClass): JNSResolveResult; overload;  // throws javax.naming.NamingException
  end;

  JNSStateFactory = interface external 'javax.naming.spi' name 'StateFactory' 
    function getStateToBind(para1: JLObject; para2: JNName; para3: JNContext; para4: JUHashtable): JLObject; overload;  // throws javax.naming.NamingException
  end;

  JNServerSocketFactory = class abstract external 'javax.net' name 'ServerSocketFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function getDefault(): JNServerSocketFactory; static; overload;
    function createServerSocket(): JNServerSocket; overload; virtual;  // throws java.io.IOException
    function createServerSocket(para1: jint): JNServerSocket; overload; virtual; abstract;  // throws java.io.IOException
    function createServerSocket(para1: jint; para2: jint): JNServerSocket; overload; virtual; abstract;  // throws java.io.IOException
    function createServerSocket(para1: jint; para2: jint; para3: JNInetAddress): JNServerSocket; overload; virtual; abstract;  // throws java.io.IOException
  end;

  JNSocketFactory = class abstract external 'javax.net' name 'SocketFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function getDefault(): JNSocketFactory; static; overload;
    function createSocket(): JNSocket; overload; virtual;  // throws java.io.IOException
    function createSocket(para1: JLString; para2: jint): JNSocket; overload; virtual; abstract;  // throws java.io.IOException, java.net.UnknownHostException
    function createSocket(para1: JLString; para2: jint; para3: JNInetAddress; para4: jint): JNSocket; overload; virtual; abstract;  // throws java.io.IOException, java.net.UnknownHostException
    function createSocket(para1: JNInetAddress; para2: jint): JNSocket; overload; virtual; abstract;  // throws java.io.IOException
    function createSocket(para1: JNInetAddress; para2: jint; para3: JNInetAddress; para4: jint): JNSocket; overload; virtual; abstract;  // throws java.io.IOException
  end;

  JNSHostnameVerifier = interface external 'javax.net.ssl' name 'HostnameVerifier' 
    function verify(para1: JLString; para2: JNSSSLSession): jboolean; overload;
  end;

  JNSKeyManager = interface external 'javax.net.ssl' name 'KeyManager' 
  end;

  JNSKeyManagerFactory = class external 'javax.net.ssl' name 'KeyManagerFactory' (JLObject)
  public
    class function getDefaultAlgorithm(): JLString; static; overload; final;
  strict protected
    constructor create(para1: JNSKeyManagerFactorySpi; para2: JSProvider; para3: JLString); overload;
  public
    function getAlgorithm(): JLString; overload; virtual; final;
    class function getInstance(para1: JLString): JNSKeyManagerFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JNSKeyManagerFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JNSKeyManagerFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    procedure init(para1: JSKeyStore; para2: Arr1jchar); overload; virtual; final;  // throws java.security.KeyStoreException, java.security.NoSuchAlgorithmException, java.security.UnrecoverableKeyException
    procedure init(para1: JSKeyStore; var para2: array of jchar); overload; virtual; final;  // throws java.security.KeyStoreException, java.security.NoSuchAlgorithmException, java.security.UnrecoverableKeyException
    procedure init(para1: JNSManagerFactoryParameters); overload; virtual; final;  // throws java.security.InvalidAlgorithmParameterException
    function getKeyManagers(): Arr1JNSKeyManager; overload; virtual; final;
  end;

  JNSKeyManagerFactorySpi = class abstract external 'javax.net.ssl' name 'KeyManagerFactorySpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineInit(para1: JSKeyStore; para2: Arr1jchar); overload; virtual; abstract;  // throws java.security.KeyStoreException, java.security.NoSuchAlgorithmException, java.security.UnrecoverableKeyException
    procedure engineInit(para1: JSKeyStore; var para2: array of jchar); overload; virtual; abstract;  // throws java.security.KeyStoreException, java.security.NoSuchAlgorithmException, java.security.UnrecoverableKeyException
    procedure engineInit(para1: JNSManagerFactoryParameters); overload; virtual; abstract;  // throws java.security.InvalidAlgorithmParameterException
    function engineGetKeyManagers(): Arr1JNSKeyManager; overload; virtual; abstract;
  end;

  JNSManagerFactoryParameters = interface external 'javax.net.ssl' name 'ManagerFactoryParameters' 
  end;

  JNSSSLContext = class external 'javax.net.ssl' name 'SSLContext' (JLObject)
  strict protected
    constructor create(para1: JNSSSLContextSpi; para2: JSProvider; para3: JLString); overload;
  public
    class function getDefault(): JNSSSLContext; static; overload;  // throws java.security.NoSuchAlgorithmException
    class procedure setDefault(para1: JNSSSLContext); static; overload;
    class function getInstance(para1: JLString): JNSSSLContext; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JNSSSLContext; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JNSSSLContext; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProtocol(): JLString; overload; virtual; final;
    function getProvider(): JSProvider; overload; virtual; final;
    procedure init(para1: Arr1JNSKeyManager; para2: Arr1JNSTrustManager; para3: JSSecureRandom); overload; virtual; final;  // throws java.security.KeyManagementException
    procedure init(var para1: array of JNSKeyManager; var para2: array of JNSTrustManager; para3: JSSecureRandom); overload; virtual; final;  // throws java.security.KeyManagementException
    function getSocketFactory(): JNSSSLSocketFactory; overload; virtual; final;
    function getServerSocketFactory(): JNSSSLServerSocketFactory; overload; virtual; final;
    function createSSLEngine(): JNSSSLEngine; overload; virtual; final;
    function createSSLEngine(para1: JLString; para2: jint): JNSSSLEngine; overload; virtual; final;
    function getServerSessionContext(): JNSSSLSessionContext; overload; virtual; final;
    function getClientSessionContext(): JNSSSLSessionContext; overload; virtual; final;
    function getDefaultSSLParameters(): JNSSSLParameters; overload; virtual; final;
    function getSupportedSSLParameters(): JNSSSLParameters; overload; virtual; final;
  end;

  JNSSSLContextSpi = class abstract external 'javax.net.ssl' name 'SSLContextSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineInit(para1: Arr1JNSKeyManager; para2: Arr1JNSTrustManager; para3: JSSecureRandom); overload; virtual; abstract;  // throws java.security.KeyManagementException
    procedure engineInit(var para1: array of JNSKeyManager; var para2: array of JNSTrustManager; para3: JSSecureRandom); overload; virtual; abstract;  // throws java.security.KeyManagementException
    function engineGetSocketFactory(): JNSSSLSocketFactory; overload; virtual; abstract;
    function engineGetServerSocketFactory(): JNSSSLServerSocketFactory; overload; virtual; abstract;
    function engineCreateSSLEngine(): JNSSSLEngine; overload; virtual; abstract;
    function engineCreateSSLEngine(para1: JLString; para2: jint): JNSSSLEngine; overload; virtual; abstract;
    function engineGetServerSessionContext(): JNSSSLSessionContext; overload; virtual; abstract;
    function engineGetClientSessionContext(): JNSSSLSessionContext; overload; virtual; abstract;
    function engineGetDefaultSSLParameters(): JNSSSLParameters; overload; virtual;
    function engineGetSupportedSSLParameters(): JNSSSLParameters; overload; virtual;
  end;

  JNSSSLParameters = class external 'javax.net.ssl' name 'SSLParameters' (JLObject)
  public
    constructor create(); overload;
    constructor create(para1: Arr1JLString); overload;
    constructor create(const para1: array of JLString); overload;
    constructor create(para1: Arr1JLString; para2: Arr1JLString); overload;
    constructor create(const para1: array of JLString; const para2: array of JLString); overload;
    function getCipherSuites(): Arr1JLString; overload; virtual;
    procedure setCipherSuites(para1: Arr1JLString); overload; virtual;
    procedure setCipherSuites(var para1: array of JLString); overload; virtual;
    function getProtocols(): Arr1JLString; overload; virtual;
    procedure setProtocols(para1: Arr1JLString); overload; virtual;
    procedure setProtocols(var para1: array of JLString); overload; virtual;
    function getWantClientAuth(): jboolean; overload; virtual;
    procedure setWantClientAuth(para1: jboolean); overload; virtual;
    function getNeedClientAuth(): jboolean; overload; virtual;
    procedure setNeedClientAuth(para1: jboolean); overload; virtual;
  end;

  JNSSSLSession = interface external 'javax.net.ssl' name 'SSLSession' 
    function getId(): Arr1jbyte; overload;
    function getSessionContext(): JNSSSLSessionContext; overload;
    function getCreationTime(): jlong; overload;
    function getLastAccessedTime(): jlong; overload;
    procedure invalidate(); overload;
    function isValid(): jboolean; overload;
    procedure putValue(para1: JLString; para2: JLObject); overload;
    function getValue(para1: JLString): JLObject; overload;
    procedure removeValue(para1: JLString); overload;
    function getValueNames(): Arr1JLString; overload;
    function getPeerCertificates(): Arr1JSCCertificate; overload;  // throws javax.net.ssl.SSLPeerUnverifiedException
    function getLocalCertificates(): Arr1JSCCertificate; overload;
    function getPeerCertificateChain(): Arr1JxSCX509Certificate; overload;  // throws javax.net.ssl.SSLPeerUnverifiedException
    function getPeerPrincipal(): JSPrincipal; overload;  // throws javax.net.ssl.SSLPeerUnverifiedException
    function getLocalPrincipal(): JSPrincipal; overload;
    function getCipherSuite(): JLString; overload;
    function getProtocol(): JLString; overload;
    function getPeerHost(): JLString; overload;
    function getPeerPort(): jint; overload;
    function getPacketBufferSize(): jint; overload;
    function getApplicationBufferSize(): jint; overload;
  end;

  JNSSSLSessionContext = interface external 'javax.net.ssl' name 'SSLSessionContext' 
    function getSession(para1: Arr1jbyte): JNSSSLSession; overload;
    function getSession(var para1: array of jbyte): JNSSSLSession; overload;
    function getIds(): JUEnumeration; overload;
    procedure setSessionTimeout(para1: jint); overload;  // throws java.lang.IllegalArgumentException
    function getSessionTimeout(): jint; overload;
    procedure setSessionCacheSize(para1: jint); overload;  // throws java.lang.IllegalArgumentException
    function getSessionCacheSize(): jint; overload;
  end;

  JNSTrustManager = interface external 'javax.net.ssl' name 'TrustManager' 
  end;

  JNSTrustManagerFactory = class external 'javax.net.ssl' name 'TrustManagerFactory' (JLObject)
  public
    class function getDefaultAlgorithm(): JLString; static; overload; final;
  strict protected
    constructor create(para1: JNSTrustManagerFactorySpi; para2: JSProvider; para3: JLString); overload;
  public
    function getAlgorithm(): JLString; overload; virtual; final;
    class function getInstance(para1: JLString): JNSTrustManagerFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLString): JNSTrustManagerFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JSProvider): JNSTrustManagerFactory; static; overload; final;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual; final;
    procedure init(para1: JSKeyStore); overload; virtual; final;  // throws java.security.KeyStoreException
    procedure init(para1: JNSManagerFactoryParameters); overload; virtual; final;  // throws java.security.InvalidAlgorithmParameterException
    function getTrustManagers(): Arr1JNSTrustManager; overload; virtual; final;
  end;

  JNSTrustManagerFactorySpi = class abstract external 'javax.net.ssl' name 'TrustManagerFactorySpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    procedure engineInit(para1: JSKeyStore); overload; virtual; abstract;  // throws java.security.KeyStoreException
    procedure engineInit(para1: JNSManagerFactoryParameters); overload; virtual; abstract;  // throws java.security.InvalidAlgorithmParameterException
    function engineGetTrustManagers(): Arr1JNSTrustManager; overload; virtual; abstract;
  end;

  JPAttributeException = interface external 'javax.print' name 'AttributeException' 
    function getUnsupportedAttributes(): Arr1JLClass; overload;
    function getUnsupportedValues(): Arr1JPAAttribute; overload;
  end;

  JPDoc = interface external 'javax.print' name 'Doc' 
    function getDocFlavor(): JPDocFlavor; overload;
    function getPrintData(): JLObject; overload;  // throws java.io.IOException
    function getAttributes(): JPADocAttributeSet; overload;
    function getReaderForText(): JIReader; overload;  // throws java.io.IOException
    function getStreamForBytes(): JIInputStream; overload;  // throws java.io.IOException
  end;

  JPDocPrintJob = interface external 'javax.print' name 'DocPrintJob' 
    function getPrintService(): JPPrintService; overload;
    function getAttributes(): JPAPrintJobAttributeSet; overload;
    procedure addPrintJobListener(para1: JPEPrintJobListener); overload;
    procedure removePrintJobListener(para1: JPEPrintJobListener); overload;
    procedure addPrintJobAttributeListener(para1: JPEPrintJobAttributeListener; para2: JPAPrintJobAttributeSet); overload;
    procedure removePrintJobAttributeListener(para1: JPEPrintJobAttributeListener); overload;
    procedure print(para1: JPDoc; para2: JPAPrintRequestAttributeSet); overload;  // throws javax.print.PrintException
  end;

  JPFlavorException = interface external 'javax.print' name 'FlavorException' 
    function getUnsupportedFlavors(): Arr1JPDocFlavor; overload;
  end;

  JPMultiDoc = interface external 'javax.print' name 'MultiDoc' 
    function getDoc(): JPDoc; overload;  // throws java.io.IOException
    function next(): JPMultiDoc; overload;  // throws java.io.IOException
  end;

  JPPrintService = interface external 'javax.print' name 'PrintService' 
    function getName(): JLString; overload;
    function createPrintJob(): JPDocPrintJob; overload;
    procedure addPrintServiceAttributeListener(para1: JPEPrintServiceAttributeListener); overload;
    procedure removePrintServiceAttributeListener(para1: JPEPrintServiceAttributeListener); overload;
    function getAttributes(): JPAPrintServiceAttributeSet; overload;
    function getAttribute(para1: JLClass): JPAPrintServiceAttribute; overload;
    function getSupportedDocFlavors(): Arr1JPDocFlavor; overload;
    function isDocFlavorSupported(para1: JPDocFlavor): jboolean; overload;
    function getSupportedAttributeCategories(): Arr1JLClass; overload;
    function isAttributeCategorySupported(para1: JLClass): jboolean; overload;
    function getDefaultAttributeValue(para1: JLClass): JLObject; overload;
    function getSupportedAttributeValues(para1: JLClass; para2: JPDocFlavor; para3: JPAAttributeSet): JLObject; overload;
    function isAttributeValueSupported(para1: JPAAttribute; para2: JPDocFlavor; para3: JPAAttributeSet): jboolean; overload;
    function getUnsupportedAttributes(para1: JPDocFlavor; para2: JPAAttributeSet): JPAAttributeSet; overload;
    function getServiceUIFactory(): JPServiceUIFactory; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
  end;

  JPPrintServiceLookup = class abstract external 'javax.print' name 'PrintServiceLookup' (JLObject)
  public
    type
      InnerServices = class;
      Arr1InnerServices = array of InnerServices;
      Arr2InnerServices = array of Arr1InnerServices;
      Arr3InnerServices = array of Arr2InnerServices;
      InnerServices = class external 'javax.print' name 'Services' 
      end;

  public
    constructor create(); overload;
    class function lookupPrintServices(para1: JPDocFlavor; para2: JPAAttributeSet): Arr1JPPrintService; static; overload; final;
    class function lookupMultiDocPrintServices(para1: Arr1JPDocFlavor; para2: JPAAttributeSet): Arr1JPMultiDocPrintService; static; overload; final;
    class function lookupMultiDocPrintServices(var para1: array of JPDocFlavor; para2: JPAAttributeSet): Arr1JPMultiDocPrintService; static; overload; final;
    class function lookupDefaultPrintService(): JPPrintService; static; overload; final;
    class function registerServiceProvider(para1: JPPrintServiceLookup): jboolean; static; overload;
    class function registerService(para1: JPPrintService): jboolean; static; overload;
    function getPrintServices(para1: JPDocFlavor; para2: JPAAttributeSet): Arr1JPPrintService; overload; virtual; abstract;
    function getPrintServices(): Arr1JPPrintService; overload; virtual; abstract;
    function getMultiDocPrintServices(para1: Arr1JPDocFlavor; para2: JPAAttributeSet): Arr1JPMultiDocPrintService; overload; virtual; abstract;
    function getMultiDocPrintServices(var para1: array of JPDocFlavor; para2: JPAAttributeSet): Arr1JPMultiDocPrintService; overload; virtual; abstract;
    function getDefaultPrintService(): JPPrintService; overload; virtual; abstract;
  end;

  JPServiceUI = class external 'javax.print' name 'ServiceUI' (JLObject)
  public
    constructor create(); overload;
    class function printDialog(para1: JAGraphicsConfiguration; para2: jint; para3: jint; para4: Arr1JPPrintService; para5: JPPrintService; para6: JPDocFlavor; para7: JPAPrintRequestAttributeSet): JPPrintService; static; overload;  // throws java.awt.HeadlessException
    class function printDialog(para1: JAGraphicsConfiguration; para2: jint; para3: jint; var para4: array of JPPrintService; para5: JPPrintService; para6: JPDocFlavor; para7: JPAPrintRequestAttributeSet): JPPrintService; static; overload;  // throws java.awt.HeadlessException
  end;

  JPServiceUIFactory = class abstract external 'javax.print' name 'ServiceUIFactory' (JLObject)
  public
    const
      JCOMPONENT_UI = 'javax.swing.JComponent';
      PANEL_UI = 'java.awt.Panel';
      DIALOG_UI = 'java.awt.Dialog';
      JDIALOG_UI = 'javax.swing.JDialog';
      ABOUT_UIROLE = 1;
      ADMIN_UIROLE = 2;
      MAIN_UIROLE = 3;
      RESERVED_UIROLE = 99;
  public
    constructor create(); overload;
    function getUI(para1: jint; para2: JLString): JLObject; overload; virtual; abstract;
    function getUIClassNamesForRole(para1: jint): Arr1JLString; overload; virtual; abstract;
  end;

  JPStreamPrintServiceFactory = class abstract external 'javax.print' name 'StreamPrintServiceFactory' (JLObject)
  public
    type
      InnerServices = class;
      Arr1InnerServices = array of InnerServices;
      Arr2InnerServices = array of Arr1InnerServices;
      Arr3InnerServices = array of Arr2InnerServices;
      InnerServices = class external 'javax.print' name 'Services' 
      end;

  public
    constructor create(); overload;
    class function lookupStreamPrintServiceFactories(para1: JPDocFlavor; para2: JLString): Arr1JPStreamPrintServiceFactory; static; overload;
    function getOutputFormat(): JLString; overload; virtual; abstract;
    function getSupportedDocFlavors(): Arr1JPDocFlavor; overload; virtual; abstract;
    function getPrintService(para1: JIOutputStream): JPStreamPrintService; overload; virtual; abstract;
  end;

  JPURIException = interface external 'javax.print' name 'URIException' 
    const
      URIInaccessible = 1;
      URISchemeNotSupported = 2;
      URIOtherProblem = -1;
    function getUnsupportedURI(): JNURI; overload;
    function getReason(): jint; overload;
  end;

  JPAAttributeSet = interface external 'javax.print.attribute' name 'AttributeSet' 
    function get(para1: JLClass): JPAAttribute; overload;
    function add(para1: JPAAttribute): jboolean; overload;
    function remove(para1: JLClass): jboolean; overload;
    function remove(para1: JPAAttribute): jboolean; overload;
    function containsKey(para1: JLClass): jboolean; overload;
    function containsValue(para1: JPAAttribute): jboolean; overload;
    function addAll(para1: JPAAttributeSet): jboolean; overload;
    function size(): jint; overload;
    function toArray(): Arr1JPAAttribute; overload;
    procedure clear(); overload;
    function isEmpty(): jboolean; overload;
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
  end;

  JPAAttributeSetUtilities = class sealed external 'javax.print.attribute' name 'AttributeSetUtilities' (JLObject)
  public
    type
      InnerSynchronizedAttributeSet = class;
      Arr1InnerSynchronizedAttributeSet = array of InnerSynchronizedAttributeSet;
      Arr2InnerSynchronizedAttributeSet = array of Arr1InnerSynchronizedAttributeSet;
      Arr3InnerSynchronizedAttributeSet = array of Arr2InnerSynchronizedAttributeSet;
      InnerUnmodifiableAttributeSet = class;
      Arr1InnerUnmodifiableAttributeSet = array of InnerUnmodifiableAttributeSet;
      Arr2InnerUnmodifiableAttributeSet = array of Arr1InnerUnmodifiableAttributeSet;
      Arr3InnerUnmodifiableAttributeSet = array of Arr2InnerUnmodifiableAttributeSet;
      InnerSynchronizedDocAttributeSet = class;
      Arr1InnerSynchronizedDocAttributeSet = array of InnerSynchronizedDocAttributeSet;
      Arr2InnerSynchronizedDocAttributeSet = array of Arr1InnerSynchronizedDocAttributeSet;
      Arr3InnerSynchronizedDocAttributeSet = array of Arr2InnerSynchronizedDocAttributeSet;
      InnerUnmodifiableDocAttributeSet = class;
      Arr1InnerUnmodifiableDocAttributeSet = array of InnerUnmodifiableDocAttributeSet;
      Arr2InnerUnmodifiableDocAttributeSet = array of Arr1InnerUnmodifiableDocAttributeSet;
      Arr3InnerUnmodifiableDocAttributeSet = array of Arr2InnerUnmodifiableDocAttributeSet;
      InnerSynchronizedPrintJobAttributeSet = class;
      Arr1InnerSynchronizedPrintJobAttributeSet = array of InnerSynchronizedPrintJobAttributeSet;
      Arr2InnerSynchronizedPrintJobAttributeSet = array of Arr1InnerSynchronizedPrintJobAttributeSet;
      Arr3InnerSynchronizedPrintJobAttributeSet = array of Arr2InnerSynchronizedPrintJobAttributeSet;
      InnerUnmodifiablePrintJobAttributeSet = class;
      Arr1InnerUnmodifiablePrintJobAttributeSet = array of InnerUnmodifiablePrintJobAttributeSet;
      Arr2InnerUnmodifiablePrintJobAttributeSet = array of Arr1InnerUnmodifiablePrintJobAttributeSet;
      Arr3InnerUnmodifiablePrintJobAttributeSet = array of Arr2InnerUnmodifiablePrintJobAttributeSet;
      InnerSynchronizedPrintRequestAttributeSet = class;
      Arr1InnerSynchronizedPrintRequestAttributeSet = array of InnerSynchronizedPrintRequestAttributeSet;
      Arr2InnerSynchronizedPrintRequestAttributeSet = array of Arr1InnerSynchronizedPrintRequestAttributeSet;
      Arr3InnerSynchronizedPrintRequestAttributeSet = array of Arr2InnerSynchronizedPrintRequestAttributeSet;
      InnerUnmodifiablePrintRequestAttributeSet = class;
      Arr1InnerUnmodifiablePrintRequestAttributeSet = array of InnerUnmodifiablePrintRequestAttributeSet;
      Arr2InnerUnmodifiablePrintRequestAttributeSet = array of Arr1InnerUnmodifiablePrintRequestAttributeSet;
      Arr3InnerUnmodifiablePrintRequestAttributeSet = array of Arr2InnerUnmodifiablePrintRequestAttributeSet;
      InnerSynchronizedPrintServiceAttributeSet = class;
      Arr1InnerSynchronizedPrintServiceAttributeSet = array of InnerSynchronizedPrintServiceAttributeSet;
      Arr2InnerSynchronizedPrintServiceAttributeSet = array of Arr1InnerSynchronizedPrintServiceAttributeSet;
      Arr3InnerSynchronizedPrintServiceAttributeSet = array of Arr2InnerSynchronizedPrintServiceAttributeSet;
      InnerUnmodifiablePrintServiceAttributeSet = class;
      Arr1InnerUnmodifiablePrintServiceAttributeSet = array of InnerUnmodifiablePrintServiceAttributeSet;
      Arr2InnerUnmodifiablePrintServiceAttributeSet = array of Arr1InnerUnmodifiablePrintServiceAttributeSet;
      Arr3InnerUnmodifiablePrintServiceAttributeSet = array of Arr2InnerUnmodifiablePrintServiceAttributeSet;
      InnerSynchronizedAttributeSet = class external 'javax.print.attribute' name 'SynchronizedAttributeSet' 
      end;

      InnerUnmodifiableAttributeSet = class external 'javax.print.attribute' name 'UnmodifiableAttributeSet' 
      end;

      InnerSynchronizedDocAttributeSet = class external 'javax.print.attribute' name 'SynchronizedDocAttributeSet' 
      end;

      InnerUnmodifiableDocAttributeSet = class external 'javax.print.attribute' name 'UnmodifiableDocAttributeSet' 
      end;

      InnerSynchronizedPrintJobAttributeSet = class external 'javax.print.attribute' name 'SynchronizedPrintJobAttributeSet' 
      end;

      InnerUnmodifiablePrintJobAttributeSet = class external 'javax.print.attribute' name 'UnmodifiablePrintJobAttributeSet' 
      end;

      InnerSynchronizedPrintRequestAttributeSet = class external 'javax.print.attribute' name 'SynchronizedPrintRequestAttributeSet' 
      end;

      InnerUnmodifiablePrintRequestAttributeSet = class external 'javax.print.attribute' name 'UnmodifiablePrintRequestAttributeSet' 
      end;

      InnerSynchronizedPrintServiceAttributeSet = class external 'javax.print.attribute' name 'SynchronizedPrintServiceAttributeSet' 
      end;

      InnerUnmodifiablePrintServiceAttributeSet = class external 'javax.print.attribute' name 'UnmodifiablePrintServiceAttributeSet' 
      end;

  public
    class function unmodifiableView(para1: JPAAttributeSet): JPAAttributeSet; static; overload;
    class function unmodifiableView(para1: JPADocAttributeSet): JPADocAttributeSet; static; overload;
    class function unmodifiableView(para1: JPAPrintRequestAttributeSet): JPAPrintRequestAttributeSet; static; overload;
    class function unmodifiableView(para1: JPAPrintJobAttributeSet): JPAPrintJobAttributeSet; static; overload;
    class function unmodifiableView(para1: JPAPrintServiceAttributeSet): JPAPrintServiceAttributeSet; static; overload;
    class function synchronizedView(para1: JPAAttributeSet): JPAAttributeSet; static; overload;
    class function synchronizedView(para1: JPADocAttributeSet): JPADocAttributeSet; static; overload;
    class function synchronizedView(para1: JPAPrintRequestAttributeSet): JPAPrintRequestAttributeSet; static; overload;
    class function synchronizedView(para1: JPAPrintJobAttributeSet): JPAPrintJobAttributeSet; static; overload;
    class function synchronizedView(para1: JPAPrintServiceAttributeSet): JPAPrintServiceAttributeSet; static; overload;
    class function verifyAttributeCategory(para1: JLObject; para2: JLClass): JLClass; static; overload;
    class function verifyAttributeValue(para1: JLObject; para2: JLClass): JPAAttribute; static; overload;
    class procedure verifyCategoryForValue(para1: JLClass; para2: JPAAttribute); static; overload;
  end;

  JPEPrintJobAttributeListener = interface external 'javax.print.event' name 'PrintJobAttributeListener' 
    procedure attributeUpdate(para1: JPEPrintJobAttributeEvent); overload;
  end;

  JPEPrintJobListener = interface external 'javax.print.event' name 'PrintJobListener' 
    procedure printDataTransferCompleted(para1: JPEPrintJobEvent); overload;
    procedure printJobCompleted(para1: JPEPrintJobEvent); overload;
    procedure printJobFailed(para1: JPEPrintJobEvent); overload;
    procedure printJobCanceled(para1: JPEPrintJobEvent); overload;
    procedure printJobNoMoreEvents(para1: JPEPrintJobEvent); overload;
    procedure printJobRequiresAttention(para1: JPEPrintJobEvent); overload;
  end;

  JPEPrintServiceAttributeListener = interface external 'javax.print.event' name 'PrintServiceAttributeListener' 
    procedure attributeUpdate(para1: JPEPrintServiceAttributeEvent); overload;
  end;

  JRCPortableRemoteObjectDelegate = interface external 'javax.rmi.CORBA' name 'PortableRemoteObjectDelegate' 
    procedure exportObject(para1: JRRemote); overload;  // throws java.rmi.RemoteException
    function toStub(para1: JRRemote): JRRemote; overload;  // throws java.rmi.NoSuchObjectException
    procedure unexportObject(para1: JRRemote); overload;  // throws java.rmi.NoSuchObjectException
    function narrow(para1: JLObject; para2: JLClass): JLObject; overload;  // throws java.lang.ClassCastException
    procedure connect(para1: JRRemote; para2: JRRemote); overload;  // throws java.rmi.RemoteException
  end;

  JRCStubDelegate = interface external 'javax.rmi.CORBA' name 'StubDelegate' 
    function hashCode(para1: JRCStub): jint; overload;
    function equals(para1: JRCStub; para2: JLObject): jboolean; overload;
    function toString(para1: JRCStub): JLString; overload;
    procedure connect(para1: JRCStub; para2: OOCORB); overload;  // throws java.rmi.RemoteException
    procedure readObject(para1: JRCStub; para2: JIObjectInputStream); overload;  // throws java.io.IOException, java.lang.ClassNotFoundException
    procedure writeObject(para1: JRCStub; para2: JIObjectOutputStream); overload;  // throws java.io.IOException
  end;

  JRCUtil = class external 'javax.rmi.CORBA' name 'Util' (JLObject)
  public
    class function mapSystemException(para1: OOCSystemException): JRRemoteException; static; overload;
    class procedure writeAny(para1: OOCPOutputStream; para2: JLObject); static; overload;
    class function readAny(para1: OOCPInputStream): JLObject; static; overload;
    class procedure writeRemoteObject(para1: OOCPOutputStream; para2: JLObject); static; overload;
    class procedure writeAbstractObject(para1: OOCPOutputStream; para2: JLObject); static; overload;
    class procedure registerTarget(para1: JRCTie; para2: JRRemote); static; overload;
    class procedure unexportObject(para1: JRRemote); static; overload;  // throws java.rmi.NoSuchObjectException
    class function getTie(para1: JRRemote): JRCTie; static; overload;
    class function createValueHandler(): JRCValueHandler; static; overload;
    class function getCodebase(para1: JLClass): JLString; static; overload;
    class function loadClass(para1: JLString; para2: JLString; para3: JLClassLoader): JLClass; static; overload;  // throws java.lang.ClassNotFoundException
    class function isLocal(para1: JRCStub): jboolean; static; overload;  // throws java.rmi.RemoteException
    class function wrapException(para1: JLThrowable): JRRemoteException; static; overload;
    class function copyObjects(para1: Arr1JLObject; para2: OOCORB): Arr1JLObject; static; overload;  // throws java.rmi.RemoteException
    class function copyObjects(var para1: array of JLObject; para2: OOCORB): Arr1JLObject; static; overload;  // throws java.rmi.RemoteException
    class function copyObject(para1: JLObject; para2: OOCORB): JLObject; static; overload;  // throws java.rmi.RemoteException
  end;

  JRCUtilDelegate = interface external 'javax.rmi.CORBA' name 'UtilDelegate' 
    function mapSystemException(para1: OOCSystemException): JRRemoteException; overload;
    procedure writeAny(para1: OOCPOutputStream; para2: JLObject); overload;
    function readAny(para1: OOCPInputStream): JLObject; overload;
    procedure writeRemoteObject(para1: OOCPOutputStream; para2: JLObject); overload;
    procedure writeAbstractObject(para1: OOCPOutputStream; para2: JLObject); overload;
    procedure registerTarget(para1: JRCTie; para2: JRRemote); overload;
    procedure unexportObject(para1: JRRemote); overload;  // throws java.rmi.NoSuchObjectException
    function getTie(para1: JRRemote): JRCTie; overload;
    function createValueHandler(): JRCValueHandler; overload;
    function getCodebase(para1: JLClass): JLString; overload;
    function loadClass(para1: JLString; para2: JLString; para3: JLClassLoader): JLClass; overload;  // throws java.lang.ClassNotFoundException
    function isLocal(para1: JRCStub): jboolean; overload;  // throws java.rmi.RemoteException
    function wrapException(para1: JLThrowable): JRRemoteException; overload;
    function copyObject(para1: JLObject; para2: OOCORB): JLObject; overload;  // throws java.rmi.RemoteException
    function copyObjects(para1: Arr1JLObject; para2: OOCORB): Arr1JLObject; overload;  // throws java.rmi.RemoteException
    function copyObjects(var para1: array of JLObject; para2: OOCORB): Arr1JLObject; overload;  // throws java.rmi.RemoteException
  end;

  JRCValueHandler = interface external 'javax.rmi.CORBA' name 'ValueHandler' 
    procedure writeValue(para1: OOCPOutputStream; para2: JISerializable); overload;
    function readValue(para1: OOCPInputStream; para2: jint; para3: JLClass; para4: JLString; para5: OOSRunTime): JISerializable; overload;
    function getRMIRepositoryID(para1: JLClass): JLString; overload;
    function isCustomMarshaled(para1: JLClass): jboolean; overload;
    function getRunTimeCodeBase(): OOSRunTime; overload;
    function writeReplace(para1: JISerializable): JISerializable; overload;
  end;

  JRPortableRemoteObject = class external 'javax.rmi' name 'PortableRemoteObject' (JLObject)
  strict protected
    constructor create(); overload;  // throws java.rmi.RemoteException
  public
    class procedure exportObject(para1: JRRemote); static; overload;  // throws java.rmi.RemoteException
    class function toStub(para1: JRRemote): JRRemote; static; overload;  // throws java.rmi.NoSuchObjectException
    class procedure unexportObject(para1: JRRemote); static; overload;  // throws java.rmi.NoSuchObjectException
    class function narrow(para1: JLObject; para2: JLClass): JLObject; static; overload;  // throws java.lang.ClassCastException
    class procedure connect(para1: JRRemote; para2: JRRemote); static; overload;  // throws java.rmi.RemoteException
  end;

  JSCompilable = interface external 'javax.script' name 'Compilable' 
    function compile(para1: JLString): JSCompiledScript; overload;  // throws javax.script.ScriptException
    function compile(para1: JIReader): JSCompiledScript; overload;  // throws javax.script.ScriptException
  end;

  JSCompiledScript = class abstract external 'javax.script' name 'CompiledScript' (JLObject)
  public
    constructor create(); overload;
    function eval(para1: JSScriptContext): JLObject; overload; virtual; abstract;  // throws javax.script.ScriptException
    function eval(para1: JSBindings): JLObject; overload; virtual;  // throws javax.script.ScriptException
    function eval(): JLObject; overload; virtual;  // throws javax.script.ScriptException
    function getEngine(): JSScriptEngine; overload; virtual; abstract;
  end;

  JSInvocable = interface external 'javax.script' name 'Invocable' 
    function invokeMethod(para1: JLObject; para2: JLString; para3: Arr1JLObject): JLObject; overload;  // throws javax.script.ScriptException, java.lang.NoSuchMethodException
    function invokeMethod(para1: JLObject; para2: JLString; const para3: array of JLObject): JLObject; overload;  // throws javax.script.ScriptException, java.lang.NoSuchMethodException
    function invokeFunction(para1: JLString; para2: Arr1JLObject): JLObject; overload;  // throws javax.script.ScriptException, java.lang.NoSuchMethodException
    function invokeFunction(para1: JLString; const para2: array of JLObject): JLObject; overload;  // throws javax.script.ScriptException, java.lang.NoSuchMethodException
    function getInterface(para1: JLClass): JLObject; overload;
    function getInterface(para1: JLObject; para2: JLClass): JLObject; overload;
  end;

  JSScriptContext = interface external 'javax.script' name 'ScriptContext' 
    const
      ENGINE_SCOPE = 100;
      GLOBAL_SCOPE = 200;
    procedure setBindings(para1: JSBindings; para2: jint); overload;
    function getBindings(para1: jint): JSBindings; overload;
    procedure setAttribute(para1: JLString; para2: JLObject; para3: jint); overload;
    function getAttribute(para1: JLString; para2: jint): JLObject; overload;
    function removeAttribute(para1: JLString; para2: jint): JLObject; overload;
    function getAttribute(para1: JLString): JLObject; overload;
    function getAttributesScope(para1: JLString): jint; overload;
    function getWriter(): JIWriter; overload;
    function getErrorWriter(): JIWriter; overload;
    procedure setWriter(para1: JIWriter); overload;
    procedure setErrorWriter(para1: JIWriter); overload;
    function getReader(): JIReader; overload;
    procedure setReader(para1: JIReader); overload;
    function getScopes(): JUList; overload;
  end;

  JSScriptEngine = interface external 'javax.script' name 'ScriptEngine' 
    const
      ARGV = 'javax.script.argv';
      FILENAME = 'javax.script.filename';
      ENGINE = 'javax.script.engine';
      ENGINE_VERSION = 'javax.script.engine_version';
      NAME = 'javax.script.name';
      LANGUAGE = 'javax.script.language';
      LANGUAGE_VERSION = 'javax.script.language_version';
    function eval(para1: JLString; para2: JSScriptContext): JLObject; overload;  // throws javax.script.ScriptException
    function eval(para1: JIReader; para2: JSScriptContext): JLObject; overload;  // throws javax.script.ScriptException
    function eval(para1: JLString): JLObject; overload;  // throws javax.script.ScriptException
    function eval(para1: JIReader): JLObject; overload;  // throws javax.script.ScriptException
    function eval(para1: JLString; para2: JSBindings): JLObject; overload;  // throws javax.script.ScriptException
    function eval(para1: JIReader; para2: JSBindings): JLObject; overload;  // throws javax.script.ScriptException
    procedure put(para1: JLString; para2: JLObject); overload;
    function get(para1: JLString): JLObject; overload;
    function getBindings(para1: jint): JSBindings; overload;
    procedure setBindings(para1: JSBindings; para2: jint); overload;
    function createBindings(): JSBindings; overload;
    function getContext(): JSScriptContext; overload;
    procedure setContext(para1: JSScriptContext); overload;
    function getFactory(): JSScriptEngineFactory; overload;
  end;

  JSScriptEngineFactory = interface external 'javax.script' name 'ScriptEngineFactory' 
    function getEngineName(): JLString; overload;
    function getEngineVersion(): JLString; overload;
    function getExtensions(): JUList; overload;
    function getMimeTypes(): JUList; overload;
    function getNames(): JUList; overload;
    function getLanguageName(): JLString; overload;
    function getLanguageVersion(): JLString; overload;
    function getParameter(para1: JLString): JLObject; overload;
    function getMethodCallSyntax(para1: JLString; para2: JLString; para3: Arr1JLString): JLString; overload;
    function getMethodCallSyntax(para1: JLString; para2: JLString; const para3: array of JLString): JLString; overload;
    function getOutputStatement(para1: JLString): JLString; overload;
    function getProgram(para1: Arr1JLString): JLString; overload;
    function getProgram(const para1: array of JLString): JLString; overload;
    function getScriptEngine(): JSScriptEngine; overload;
  end;

  JSScriptEngineManager = class external 'javax.script' name 'ScriptEngineManager' (JLObject)
  public
    constructor create(); overload;
    constructor create(para1: JLClassLoader); overload;
    procedure setBindings(para1: JSBindings); overload; virtual;
    function getBindings(): JSBindings; overload; virtual;
    procedure put(para1: JLString; para2: JLObject); overload; virtual;
    function get(para1: JLString): JLObject; overload; virtual;
    function getEngineByName(para1: JLString): JSScriptEngine; overload; virtual;
    function getEngineByExtension(para1: JLString): JSScriptEngine; overload; virtual;
    function getEngineByMimeType(para1: JLString): JSScriptEngine; overload; virtual;
    function getEngineFactories(): JUList; overload; virtual;
    procedure registerEngineName(para1: JLString; para2: JSScriptEngineFactory); overload; virtual;
    procedure registerEngineMimeType(para1: JLString; para2: JSScriptEngineFactory); overload; virtual;
    procedure registerEngineExtension(para1: JLString; para2: JSScriptEngineFactory); overload; virtual;
  end;

  JSADestroyable = interface external 'javax.security.auth' name 'Destroyable' 
    procedure destroy(); overload;  // throws javax.security.auth.DestroyFailedException
    function isDestroyed(): jboolean; overload;
  end;

  JSAPolicy = class abstract external 'javax.security.auth' name 'Policy' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function getPolicy(): JSAPolicy; static; overload;
    class procedure setPolicy(para1: JSAPolicy); static; overload;
    function getPermissions(para1: JSASubject; para2: JSCodeSource): JSPermissionCollection; overload; virtual; abstract;
    procedure refresh(); overload; virtual; abstract;
  end;

  JSARefreshable = interface external 'javax.security.auth' name 'Refreshable' 
    function isCurrent(): jboolean; overload;
    procedure refresh(); overload;  // throws javax.security.auth.RefreshFailedException
  end;

  JSACCallback = interface external 'javax.security.auth.callback' name 'Callback' 
  end;

  JSACCallbackHandler = interface external 'javax.security.auth.callback' name 'CallbackHandler' 
    procedure handle(para1: Arr1JSACCallback); overload;  // throws java.io.IOException, javax.security.auth.callback.UnsupportedCallbackException
    procedure handle(var para1: array of JSACCallback); overload;  // throws java.io.IOException, javax.security.auth.callback.UnsupportedCallbackException
  end;

  JSALAppConfigurationEntry = class external 'javax.security.auth.login' name 'AppConfigurationEntry' (JLObject)
  public
    type
      InnerLoginModuleControlFlag = class;
      Arr1InnerLoginModuleControlFlag = array of InnerLoginModuleControlFlag;
      Arr2InnerLoginModuleControlFlag = array of Arr1InnerLoginModuleControlFlag;
      Arr3InnerLoginModuleControlFlag = array of Arr2InnerLoginModuleControlFlag;
      InnerLoginModuleControlFlag = class external 'javax.security.auth.login' name 'LoginModuleControlFlag' (JLObject)
      public
        final class var
          fREQUIRED: JSALAppConfigurationEntry.InnerLoginModuleControlFlag; external name 'REQUIRED';
          fREQUISITE: JSALAppConfigurationEntry.InnerLoginModuleControlFlag; external name 'REQUISITE';
          fSUFFICIENT: JSALAppConfigurationEntry.InnerLoginModuleControlFlag; external name 'SUFFICIENT';
          fOPTIONAL: JSALAppConfigurationEntry.InnerLoginModuleControlFlag; external name 'OPTIONAL';
      public
        function toString(): JLString; overload; virtual;
      end;

  public
    constructor create(para1: JLString; para2: JSALAppConfigurationEntry.InnerLoginModuleControlFlag; para3: JUMap); overload;
    function getLoginModuleName(): JLString; overload; virtual;
    function getControlFlag(): JSALAppConfigurationEntry.InnerLoginModuleControlFlag; overload; virtual;
    function getOptions(): JUMap; overload; virtual;
  end;

  JSALConfiguration = class abstract external 'javax.security.auth.login' name 'Configuration' (JLObject)
  public
    type
      InnerConfigDelegate = class;
      Arr1InnerConfigDelegate = array of InnerConfigDelegate;
      Arr2InnerConfigDelegate = array of Arr1InnerConfigDelegate;
      Arr3InnerConfigDelegate = array of Arr2InnerConfigDelegate;
      InnerConfigDelegate = class external 'javax.security.auth.login' name 'ConfigDelegate' 
      end;

  public
    type
      InnerParameters = interface;
      Arr1InnerParameters = array of InnerParameters;
      Arr2InnerParameters = array of Arr1InnerParameters;
      Arr3InnerParameters = array of Arr2InnerParameters;
      InnerParameters = interface external 'javax.security.auth.login' name 'Parameters' 
      end;

  strict protected
    constructor create(); overload;
  public
    class function getConfiguration(): JSALConfiguration; static; overload;
    class procedure setConfiguration(para1: JSALConfiguration); static; overload;
    class function getInstance(para1: JLString; para2: JSALConfiguration.InnerParameters): JSALConfiguration; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JSALConfiguration.InnerParameters; para3: JLString): JSALConfiguration; static; overload;  // throws java.security.NoSuchProviderException, java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JSALConfiguration.InnerParameters; para3: JSProvider): JSALConfiguration; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual;
    function getType(): JLString; overload; virtual;
    function getParameters(): JSALConfiguration.InnerParameters; overload; virtual;
    function getAppConfigurationEntry(para1: JLString): Arr1JSALAppConfigurationEntry; overload; virtual; abstract;
    procedure refresh(); overload; virtual;
  end;

  JSALConfigurationSpi = class abstract external 'javax.security.auth.login' name 'ConfigurationSpi' (JLObject)
  public
    constructor create(); overload;
  strict protected
    function engineGetAppConfigurationEntry(para1: JLString): Arr1JSALAppConfigurationEntry; overload; virtual; abstract;
    procedure engineRefresh(); overload; virtual;
  end;

  JSALLoginContext = class external 'javax.security.auth.login' name 'LoginContext' (JLObject)
  public
    type
      InnerModuleInfo = class;
      Arr1InnerModuleInfo = array of InnerModuleInfo;
      Arr2InnerModuleInfo = array of Arr1InnerModuleInfo;
      Arr3InnerModuleInfo = array of Arr2InnerModuleInfo;
      InnerSecureCallbackHandler = class;
      Arr1InnerSecureCallbackHandler = array of InnerSecureCallbackHandler;
      Arr2InnerSecureCallbackHandler = array of Arr1InnerSecureCallbackHandler;
      Arr3InnerSecureCallbackHandler = array of Arr2InnerSecureCallbackHandler;
      InnerModuleInfo = class external 'javax.security.auth.login' name 'ModuleInfo' 
      end;

      InnerSecureCallbackHandler = class external 'javax.security.auth.login' name 'SecureCallbackHandler' 
      end;

  public
    constructor create(para1: JLString); overload;  // throws javax.security.auth.login.LoginException
    constructor create(para1: JLString; para2: JSASubject); overload;  // throws javax.security.auth.login.LoginException
    constructor create(para1: JLString; para2: JSACCallbackHandler); overload;  // throws javax.security.auth.login.LoginException
    constructor create(para1: JLString; para2: JSASubject; para3: JSACCallbackHandler); overload;  // throws javax.security.auth.login.LoginException
    constructor create(para1: JLString; para2: JSASubject; para3: JSACCallbackHandler; para4: JSALConfiguration); overload;  // throws javax.security.auth.login.LoginException
    procedure login(); overload; virtual;  // throws javax.security.auth.login.LoginException
    procedure logout(); overload; virtual;  // throws javax.security.auth.login.LoginException
    function getSubject(): JSASubject; overload; virtual;
  end;

  JSASLoginModule = interface external 'javax.security.auth.spi' name 'LoginModule' 
    procedure initialize(para1: JSASubject; para2: JSACCallbackHandler; para3: JUMap; para4: JUMap); overload;
    function login(): jboolean; overload;  // throws javax.security.auth.login.LoginException
    function commit(): jboolean; overload;  // throws javax.security.auth.login.LoginException
    function abort(): jboolean; overload;  // throws javax.security.auth.login.LoginException
    function logout(): jboolean; overload;  // throws javax.security.auth.login.LoginException
  end;

  JxSCCertificate = class abstract external 'javax.security.cert' name 'Certificate' (JLObject)
  public
    constructor create(); overload;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
    function getEncoded(): Arr1jbyte; overload; virtual; abstract;  // throws javax.security.cert.CertificateEncodingException
    procedure verify(para1: JSPublicKey); overload; virtual; abstract;  // throws javax.security.cert.CertificateException, java.security.NoSuchAlgorithmException, java.security.InvalidKeyException, java.security.NoSuchProviderException, java.security.SignatureException
    procedure verify(para1: JSPublicKey; para2: JLString); overload; virtual; abstract;  // throws javax.security.cert.CertificateException, java.security.NoSuchAlgorithmException, java.security.InvalidKeyException, java.security.NoSuchProviderException, java.security.SignatureException
    function toString(): JLString; overload; virtual; abstract;
    function getPublicKey(): JSPublicKey; overload; virtual; abstract;
  end;

  JSSSasl = class external 'javax.security.sasl' name 'Sasl' (JLObject)
  public
    const
      QOP = 'javax.security.sasl.qop';
      STRENGTH = 'javax.security.sasl.strength';
      SERVER_AUTH = 'javax.security.sasl.server.authentication';
      MAX_BUFFER = 'javax.security.sasl.maxbuffer';
      RAW_SEND_SIZE = 'javax.security.sasl.rawsendsize';
      REUSE = 'javax.security.sasl.reuse';
      POLICY_NOPLAINTEXT = 'javax.security.sasl.policy.noplaintext';
      POLICY_NOACTIVE = 'javax.security.sasl.policy.noactive';
      POLICY_NODICTIONARY = 'javax.security.sasl.policy.nodictionary';
      POLICY_NOANONYMOUS = 'javax.security.sasl.policy.noanonymous';
      POLICY_FORWARD_SECRECY = 'javax.security.sasl.policy.forward';
      POLICY_PASS_CREDENTIALS = 'javax.security.sasl.policy.credentials';
      CREDENTIALS = 'javax.security.sasl.credentials';
  public
    class function createSaslClient(para1: Arr1JLString; para2: JLString; para3: JLString; para4: JLString; para5: JUMap; para6: JSACCallbackHandler): JSSSaslClient; static; overload;  // throws javax.security.sasl.SaslException
    class function createSaslClient(var para1: array of JLString; para2: JLString; para3: JLString; para4: JLString; para5: JUMap; para6: JSACCallbackHandler): JSSSaslClient; static; overload;  // throws javax.security.sasl.SaslException
    class function createSaslServer(para1: JLString; para2: JLString; para3: JLString; para4: JUMap; para5: JSACCallbackHandler): JSSSaslServer; static; overload;  // throws javax.security.sasl.SaslException
    class function getSaslClientFactories(): JUEnumeration; static; overload;
    class function getSaslServerFactories(): JUEnumeration; static; overload;
  end;

  JSSSaslClient = interface external 'javax.security.sasl' name 'SaslClient' 
    function getMechanismName(): JLString; overload;
    function hasInitialResponse(): jboolean; overload;
    function evaluateChallenge(para1: Arr1jbyte): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function evaluateChallenge(var para1: array of jbyte): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function isComplete(): jboolean; overload;
    function unwrap(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function unwrap(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function wrap(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function wrap(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function getNegotiatedProperty(para1: JLString): JLObject; overload;
    procedure dispose(); overload;  // throws javax.security.sasl.SaslException
  end;

  JSSSaslClientFactory = interface external 'javax.security.sasl' name 'SaslClientFactory' 
    function createSaslClient(para1: Arr1JLString; para2: JLString; para3: JLString; para4: JLString; para5: JUMap; para6: JSACCallbackHandler): JSSSaslClient; overload;  // throws javax.security.sasl.SaslException
    function createSaslClient(var para1: array of JLString; para2: JLString; para3: JLString; para4: JLString; para5: JUMap; para6: JSACCallbackHandler): JSSSaslClient; overload;  // throws javax.security.sasl.SaslException
    function getMechanismNames(para1: JUMap): Arr1JLString; overload;
  end;

  JSSSaslServer = interface external 'javax.security.sasl' name 'SaslServer' 
    function getMechanismName(): JLString; overload;
    function evaluateResponse(para1: Arr1jbyte): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function evaluateResponse(var para1: array of jbyte): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function isComplete(): jboolean; overload;
    function getAuthorizationID(): JLString; overload;
    function unwrap(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function unwrap(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function wrap(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function wrap(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws javax.security.sasl.SaslException
    function getNegotiatedProperty(para1: JLString): JLObject; overload;
    procedure dispose(); overload;  // throws javax.security.sasl.SaslException
  end;

  JSSSaslServerFactory = interface external 'javax.security.sasl' name 'SaslServerFactory' 
    function createSaslServer(para1: JLString; para2: JLString; para3: JLString; para4: JUMap; para5: JSACCallbackHandler): JSSSaslServer; overload;  // throws javax.security.sasl.SaslException
    function getMechanismNames(para1: JUMap): Arr1JLString; overload;
  end;

  JSCard = class abstract external 'javax.smartcardio' name 'Card' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function getATR(): JSATR; overload; virtual; abstract;
    function getProtocol(): JLString; overload; virtual; abstract;
    function getBasicChannel(): JSCardChannel; overload; virtual; abstract;
    function openLogicalChannel(): JSCardChannel; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    procedure beginExclusive(); overload; virtual; abstract;  // throws javax.smartcardio.CardException
    procedure endExclusive(); overload; virtual; abstract;  // throws javax.smartcardio.CardException
    function transmitControlCommand(para1: jint; para2: Arr1jbyte): Arr1jbyte; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    function transmitControlCommand(para1: jint; var para2: array of jbyte): Arr1jbyte; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    procedure disconnect(para1: jboolean); overload; virtual; abstract;  // throws javax.smartcardio.CardException
  end;

  JSCardChannel = class abstract external 'javax.smartcardio' name 'CardChannel' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function getCard(): JSCard; overload; virtual; abstract;
    function getChannelNumber(): jint; overload; virtual; abstract;
    function transmit(para1: JSCommandAPDU): JSResponseAPDU; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    function transmit(para1: JNByteBuffer; para2: JNByteBuffer): jint; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    procedure close(); overload; virtual; abstract;  // throws javax.smartcardio.CardException
  end;

  JSCardTerminal = class abstract external 'javax.smartcardio' name 'CardTerminal' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function getName(): JLString; overload; virtual; abstract;
    function connect(para1: JLString): JSCard; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    function isCardPresent(): jboolean; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    function waitForCardPresent(para1: jlong): jboolean; overload; virtual; abstract;  // throws javax.smartcardio.CardException
    function waitForCardAbsent(para1: jlong): jboolean; overload; virtual; abstract;  // throws javax.smartcardio.CardException
  end;

  JSTerminalFactory = class sealed external 'javax.smartcardio' name 'TerminalFactory' (JLObject)
  public
    type
      InnerNoneCardTerminals = class;
      Arr1InnerNoneCardTerminals = array of InnerNoneCardTerminals;
      Arr2InnerNoneCardTerminals = array of Arr1InnerNoneCardTerminals;
      Arr3InnerNoneCardTerminals = array of Arr2InnerNoneCardTerminals;
      InnerNoneFactorySpi = class;
      Arr1InnerNoneFactorySpi = array of InnerNoneFactorySpi;
      Arr2InnerNoneFactorySpi = array of Arr1InnerNoneFactorySpi;
      Arr3InnerNoneFactorySpi = array of Arr2InnerNoneFactorySpi;
      InnerNoneProvider = class;
      Arr1InnerNoneProvider = array of InnerNoneProvider;
      Arr2InnerNoneProvider = array of Arr1InnerNoneProvider;
      Arr3InnerNoneProvider = array of Arr2InnerNoneProvider;
      InnerNoneCardTerminals = class sealed external 'javax.smartcardio' name 'NoneCardTerminals' 
      end;

      InnerNoneFactorySpi = class sealed external 'javax.smartcardio' name 'NoneFactorySpi' 
      end;

      InnerNoneProvider = class sealed external 'javax.smartcardio' name 'NoneProvider' 
      end;

  public
    class function getDefaultType(): JLString; static; overload;
    class function getDefault(): JSTerminalFactory; static; overload;
    class function getInstance(para1: JLString; para2: JLObject): JSTerminalFactory; static; overload;  // throws java.security.NoSuchAlgorithmException
    class function getInstance(para1: JLString; para2: JLObject; para3: JLString): JSTerminalFactory; static; overload;  // throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException
    class function getInstance(para1: JLString; para2: JLObject; para3: JSProvider): JSTerminalFactory; static; overload;  // throws java.security.NoSuchAlgorithmException
    function getProvider(): JSProvider; overload; virtual;
    function getType(): JLString; overload; virtual;
    function terminals(): JSCardTerminals; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JSTerminalFactorySpi = class abstract external 'javax.smartcardio' name 'TerminalFactorySpi' (JLObject)
  strict protected
    constructor create(); overload;
    function engineTerminals(): JSCardTerminals; overload; virtual; abstract;
  end;

  JSMMidiChannel = interface external 'javax.sound.midi' name 'MidiChannel' 
    procedure noteOn(para1: jint; para2: jint); overload;
    procedure noteOff(para1: jint; para2: jint); overload;
    procedure noteOff(para1: jint); overload;
    procedure setPolyPressure(para1: jint; para2: jint); overload;
    function getPolyPressure(para1: jint): jint; overload;
    procedure setChannelPressure(para1: jint); overload;
    function getChannelPressure(): jint; overload;
    procedure controlChange(para1: jint; para2: jint); overload;
    function getController(para1: jint): jint; overload;
    procedure programChange(para1: jint); overload;
    procedure programChange(para1: jint; para2: jint); overload;
    function getProgram(): jint; overload;
    procedure setPitchBend(para1: jint); overload;
    function getPitchBend(): jint; overload;
    procedure resetAllControllers(); overload;
    procedure allNotesOff(); overload;
    procedure allSoundOff(); overload;
    function localControl(para1: jboolean): jboolean; overload;
    procedure setMono(para1: jboolean); overload;
    function getMono(): jboolean; overload;
    procedure setOmni(para1: jboolean); overload;
    function getOmni(): jboolean; overload;
    procedure setMute(para1: jboolean); overload;
    function getMute(): jboolean; overload;
    procedure setSolo(para1: jboolean); overload;
    function getSolo(): jboolean; overload;
  end;

  JSMMidiDevice = interface external 'javax.sound.midi' name 'MidiDevice' 
    type
      InnerInfo = class;
      Arr1InnerInfo = array of InnerInfo;
      Arr2InnerInfo = array of Arr1InnerInfo;
      Arr3InnerInfo = array of Arr2InnerInfo;
      InnerInfo = class external 'javax.sound.midi' name 'Info' (JLObject)
      strict protected
        constructor create(para1: JLString; para2: JLString; para3: JLString; para4: JLString); overload;
      public
        function equals(para1: JLObject): jboolean; overload; virtual; final;
        function hashCode(): jint; overload; virtual; final;
        function getName(): JLString; overload; virtual; final;
        function getVendor(): JLString; overload; virtual; final;
        function getDescription(): JLString; overload; virtual; final;
        function getVersion(): JLString; overload; virtual; final;
        function toString(): JLString; overload; virtual; final;
      end;

    function getDeviceInfo(): JSMMidiDevice.InnerInfo; overload;
    procedure open(); overload;  // throws javax.sound.midi.MidiUnavailableException
    procedure close(); overload;
    function isOpen(): jboolean; overload;
    function getMicrosecondPosition(): jlong; overload;
    function getMaxReceivers(): jint; overload;
    function getMaxTransmitters(): jint; overload;
    function getReceiver(): JSMReceiver; overload;  // throws javax.sound.midi.MidiUnavailableException
    function getReceivers(): JUList; overload;
    function getTransmitter(): JSMTransmitter; overload;  // throws javax.sound.midi.MidiUnavailableException
    function getTransmitters(): JUList; overload;
  end;

  JSMMidiEvent = class external 'javax.sound.midi' name 'MidiEvent' (JLObject)
  public
    constructor create(para1: JSMMidiMessage; para2: jlong); overload;
    function getMessage(): JSMMidiMessage; overload; virtual;
    procedure setTick(para1: jlong); overload; virtual;
    function getTick(): jlong; overload; virtual;
  end;

  JSMMidiFileFormat = class external 'javax.sound.midi' name 'MidiFileFormat' (JLObject)
  public
    const
      UNKNOWN_LENGTH = -1;
  strict protected
    var
      ftype: jint; external name 'type';
      fdivisionType: jfloat; external name 'divisionType';
      fresolution: jint; external name 'resolution';
      fbyteLength: jint; external name 'byteLength';
      fmicrosecondLength: jlong; external name 'microsecondLength';
  public
    constructor create(para1: jint; para2: jfloat; para3: jint; para4: jint; para5: jlong); overload;
    constructor create(para1: jint; para2: jfloat; para3: jint; para4: jint; para5: jlong; para6: JUMap); overload;
    function getType(): jint; overload; virtual;
    function getDivisionType(): jfloat; overload; virtual;
    function getResolution(): jint; overload; virtual;
    function getByteLength(): jint; overload; virtual;
    function getMicrosecondLength(): jlong; overload; virtual;
    function properties(): JUMap; overload; virtual;
    function getProperty(para1: JLString): JLObject; overload; virtual;
  end;

  JSMPatch = class external 'javax.sound.midi' name 'Patch' (JLObject)
  public
    constructor create(para1: jint; para2: jint); overload;
    function getBank(): jint; overload; virtual;
    function getProgram(): jint; overload; virtual;
  end;

  JSMReceiver = interface external 'javax.sound.midi' name 'Receiver' 
    procedure send(para1: JSMMidiMessage; para2: jlong); overload;
    procedure close(); overload;
  end;

  JSMSequence = class external 'javax.sound.midi' name 'Sequence' (JLObject)
  public
    const
      PPQ = jfloat(0.0);
      SMPTE_24 = jfloat(24.0);
      SMPTE_25 = jfloat(25.0);
      SMPTE_30DROP = jfloat(29.97);
      SMPTE_30 = jfloat(30.0);
  strict protected
    var
      fdivisionType: jfloat; external name 'divisionType';
      fresolution: jint; external name 'resolution';
      ftracks: JUVector; external name 'tracks';
  public
    constructor create(para1: jfloat; para2: jint); overload;  // throws javax.sound.midi.InvalidMidiDataException
    constructor create(para1: jfloat; para2: jint; para3: jint); overload;  // throws javax.sound.midi.InvalidMidiDataException
    function getDivisionType(): jfloat; overload; virtual;
    function getResolution(): jint; overload; virtual;
    function createTrack(): JSMTrack; overload; virtual;
    function deleteTrack(para1: JSMTrack): jboolean; overload; virtual;
    function getTracks(): Arr1JSMTrack; overload; virtual;
    function getMicrosecondLength(): jlong; overload; virtual;
    function getTickLength(): jlong; overload; virtual;
    function getPatchList(): Arr1JSMPatch; overload; virtual;
  end;

  JSMSoundbank = interface external 'javax.sound.midi' name 'Soundbank' 
    function getName(): JLString; overload;
    function getVersion(): JLString; overload;
    function getVendor(): JLString; overload;
    function getDescription(): JLString; overload;
    function getResources(): Arr1JSMSoundbankResource; overload;
    function getInstruments(): Arr1JSMInstrument; overload;
    function getInstrument(para1: JSMPatch): JSMInstrument; overload;
  end;

  JSMSoundbankResource = class abstract external 'javax.sound.midi' name 'SoundbankResource' (JLObject)
  strict protected
    constructor create(para1: JSMSoundbank; para2: JLString; para3: JLClass); overload;
  public
    function getSoundbank(): JSMSoundbank; overload; virtual;
    function getName(): JLString; overload; virtual;
    function getDataClass(): JLClass; overload; virtual;
    function getData(): JLObject; overload; virtual; abstract;
  end;

  JSMTrack = class external 'javax.sound.midi' name 'Track' (JLObject)
  public
    type
      InnerImmutableEndOfTrack = class;
      Arr1InnerImmutableEndOfTrack = array of InnerImmutableEndOfTrack;
      Arr2InnerImmutableEndOfTrack = array of Arr1InnerImmutableEndOfTrack;
      Arr3InnerImmutableEndOfTrack = array of Arr2InnerImmutableEndOfTrack;
      InnerImmutableEndOfTrack = class external 'javax.sound.midi' name 'ImmutableEndOfTrack' 
      end;

  public
    function add(para1: JSMMidiEvent): jboolean; overload; virtual;
    function remove(para1: JSMMidiEvent): jboolean; overload; virtual;
    function get(para1: jint): JSMMidiEvent; overload; virtual;  // throws java.lang.ArrayIndexOutOfBoundsException
    function size(): jint; overload; virtual;
    function ticks(): jlong; overload; virtual;
  end;

  JSMTransmitter = interface external 'javax.sound.midi' name 'Transmitter' 
    procedure setReceiver(para1: JSMReceiver); overload;
    function getReceiver(): JSMReceiver; overload;
    procedure close(); overload;
  end;

  JSMVoiceStatus = class external 'javax.sound.midi' name 'VoiceStatus' (JLObject)
  public
    var
      factive: jboolean; external name 'active';
      fchannel: jint; external name 'channel';
      fbank: jint; external name 'bank';
      fprogram: jint; external name 'program';
      fnote: jint; external name 'note';
      fvolume: jint; external name 'volume';
  public
    constructor create(); overload;
  end;

  JSMSMidiFileReader = class abstract external 'javax.sound.midi.spi' name 'MidiFileReader' (JLObject)
  public
    constructor create(); overload;
    function getMidiFileFormat(para1: JIInputStream): JSMMidiFileFormat; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
    function getMidiFileFormat(para1: JNURL): JSMMidiFileFormat; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
    function getMidiFileFormat(para1: JIFile): JSMMidiFileFormat; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
    function getSequence(para1: JIInputStream): JSMSequence; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
    function getSequence(para1: JNURL): JSMSequence; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
    function getSequence(para1: JIFile): JSMSequence; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
  end;

  JSMSMidiFileWriter = class abstract external 'javax.sound.midi.spi' name 'MidiFileWriter' (JLObject)
  public
    constructor create(); overload;
    function getMidiFileTypes(): Arr1jint; overload; virtual; abstract;
    function getMidiFileTypes(para1: JSMSequence): Arr1jint; overload; virtual; abstract;
    function isFileTypeSupported(para1: jint): jboolean; overload; virtual;
    function isFileTypeSupported(para1: jint; para2: JSMSequence): jboolean; overload; virtual;
    function write(para1: JSMSequence; para2: jint; para3: JIOutputStream): jint; overload; virtual; abstract;  // throws java.io.IOException
    function write(para1: JSMSequence; para2: jint; para3: JIFile): jint; overload; virtual; abstract;  // throws java.io.IOException
  end;

  JSMSSoundbankReader = class abstract external 'javax.sound.midi.spi' name 'SoundbankReader' (JLObject)
  public
    constructor create(); overload;
    function getSoundbank(para1: JNURL): JSMSoundbank; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
    function getSoundbank(para1: JIInputStream): JSMSoundbank; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
    function getSoundbank(para1: JIFile): JSMSoundbank; overload; virtual; abstract;  // throws javax.sound.midi.InvalidMidiDataException, java.io.IOException
  end;

  JSSAudioFileFormat = class external 'javax.sound.sampled' name 'AudioFileFormat' (JLObject)
  public
    type
      InnerType = class;
      Arr1InnerType = array of InnerType;
      Arr2InnerType = array of Arr1InnerType;
      Arr3InnerType = array of Arr2InnerType;
      InnerType = class external 'javax.sound.sampled' name 'Type' (JLObject)
      public
        final class var
          fWAVE: JSSAudioFileFormat.InnerType; external name 'WAVE';
          fAU: JSSAudioFileFormat.InnerType; external name 'AU';
          fAIFF: JSSAudioFileFormat.InnerType; external name 'AIFF';
          fAIFC: JSSAudioFileFormat.InnerType; external name 'AIFC';
          fSND: JSSAudioFileFormat.InnerType; external name 'SND';
      public
        constructor create(para1: JLString; para2: JLString); overload;
        function equals(para1: JLObject): jboolean; overload; virtual; final;
        function hashCode(): jint; overload; virtual; final;
        function toString(): JLString; overload; virtual; final;
        function getExtension(): JLString; overload; virtual;
      end;

  strict protected
    constructor create(para1: JSSAudioFileFormat.InnerType; para2: jint; para3: JSSAudioFormat; para4: jint); overload;
  public
    constructor create(para1: JSSAudioFileFormat.InnerType; para2: JSSAudioFormat; para3: jint); overload;
    constructor create(para1: JSSAudioFileFormat.InnerType; para2: JSSAudioFormat; para3: jint; para4: JUMap); overload;
    function getType(): JSSAudioFileFormat.InnerType; overload; virtual;
    function getByteLength(): jint; overload; virtual;
    function getFormat(): JSSAudioFormat; overload; virtual;
    function getFrameLength(): jint; overload; virtual;
    function properties(): JUMap; overload; virtual;
    function getProperty(para1: JLString): JLObject; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JSSAudioFormat = class external 'javax.sound.sampled' name 'AudioFormat' (JLObject)
  public
    type
      InnerEncoding = class;
      Arr1InnerEncoding = array of InnerEncoding;
      Arr2InnerEncoding = array of Arr1InnerEncoding;
      Arr3InnerEncoding = array of Arr2InnerEncoding;
      InnerEncoding = class external 'javax.sound.sampled' name 'Encoding' (JLObject)
      public
        final class var
          fPCM_SIGNED: JSSAudioFormat.InnerEncoding; external name 'PCM_SIGNED';
          fPCM_UNSIGNED: JSSAudioFormat.InnerEncoding; external name 'PCM_UNSIGNED';
          fULAW: JSSAudioFormat.InnerEncoding; external name 'ULAW';
          fALAW: JSSAudioFormat.InnerEncoding; external name 'ALAW';
      public
        constructor create(para1: JLString); overload;
        function equals(para1: JLObject): jboolean; overload; virtual; final;
        function hashCode(): jint; overload; virtual; final;
        function toString(): JLString; overload; virtual; final;
      end;

  strict protected
    var
      fencoding: JSSAudioFormat.InnerEncoding; external name 'encoding';
      fsampleRate: jfloat; external name 'sampleRate';
      fsampleSizeInBits: jint; external name 'sampleSizeInBits';
      fchannels: jint; external name 'channels';
      fframeSize: jint; external name 'frameSize';
      fframeRate: jfloat; external name 'frameRate';
      fbigEndian: jboolean; external name 'bigEndian';
  public
    constructor create(para1: JSSAudioFormat.InnerEncoding; para2: jfloat; para3: jint; para4: jint; para5: jint; para6: jfloat; para7: jboolean); overload;
    constructor create(para1: JSSAudioFormat.InnerEncoding; para2: jfloat; para3: jint; para4: jint; para5: jint; para6: jfloat; para7: jboolean; para8: JUMap); overload;
    constructor create(para1: jfloat; para2: jint; para3: jint; para4: jboolean; para5: jboolean); overload;
    function getEncoding(): JSSAudioFormat.InnerEncoding; overload; virtual;
    function getSampleRate(): jfloat; overload; virtual;
    function getSampleSizeInBits(): jint; overload; virtual;
    function getChannels(): jint; overload; virtual;
    function getFrameSize(): jint; overload; virtual;
    function getFrameRate(): jfloat; overload; virtual;
    function isBigEndian(): jboolean; overload; virtual;
    function properties(): JUMap; overload; virtual;
    function getProperty(para1: JLString): JLObject; overload; virtual;
    function matches(para1: JSSAudioFormat): jboolean; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JSSControl = class abstract external 'javax.sound.sampled' name 'Control' (JLObject)
  public
    type
      InnerType = class;
      Arr1InnerType = array of InnerType;
      Arr2InnerType = array of Arr1InnerType;
      Arr3InnerType = array of Arr2InnerType;
      InnerType = class external 'javax.sound.sampled' name 'Type' (JLObject)
      strict protected
        constructor create(para1: JLString); overload;
      public
        function equals(para1: JLObject): jboolean; overload; virtual; final;
        function hashCode(): jint; overload; virtual; final;
        function toString(): JLString; overload; virtual; final;
      end;

  strict protected
    constructor create(para1: JSSControl.InnerType); overload;
  public
    function getType(): JSSControl.InnerType; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JSSReverbType = class external 'javax.sound.sampled' name 'ReverbType' (JLObject)
  strict protected
    constructor create(para1: JLString; para2: jint; para3: jfloat; para4: jint; para5: jfloat; para6: jint); overload;
  public
    function getName(): JLString; overload; virtual;
    function getEarlyReflectionDelay(): jint; overload; virtual; final;
    function getEarlyReflectionIntensity(): jfloat; overload; virtual; final;
    function getLateReflectionDelay(): jint; overload; virtual; final;
    function getLateReflectionIntensity(): jfloat; overload; virtual; final;
    function getDecayTime(): jint; overload; virtual; final;
    function equals(para1: JLObject): jboolean; overload; virtual; final;
    function hashCode(): jint; overload; virtual; final;
    function toString(): JLString; overload; virtual; final;
  end;

  JSSSAudioFileReader = class abstract external 'javax.sound.sampled.spi' name 'AudioFileReader' (JLObject)
  public
    constructor create(); overload;
    function getAudioFileFormat(para1: JIInputStream): JSSAudioFileFormat; overload; virtual; abstract;  // throws javax.sound.sampled.UnsupportedAudioFileException, java.io.IOException
    function getAudioFileFormat(para1: JNURL): JSSAudioFileFormat; overload; virtual; abstract;  // throws javax.sound.sampled.UnsupportedAudioFileException, java.io.IOException
    function getAudioFileFormat(para1: JIFile): JSSAudioFileFormat; overload; virtual; abstract;  // throws javax.sound.sampled.UnsupportedAudioFileException, java.io.IOException
    function getAudioInputStream(para1: JIInputStream): JSSAudioInputStream; overload; virtual; abstract;  // throws javax.sound.sampled.UnsupportedAudioFileException, java.io.IOException
    function getAudioInputStream(para1: JNURL): JSSAudioInputStream; overload; virtual; abstract;  // throws javax.sound.sampled.UnsupportedAudioFileException, java.io.IOException
    function getAudioInputStream(para1: JIFile): JSSAudioInputStream; overload; virtual; abstract;  // throws javax.sound.sampled.UnsupportedAudioFileException, java.io.IOException
  end;

  JSCommonDataSource = interface external 'javax.sql' name 'CommonDataSource' 
    function getLogWriter(): JIPrintWriter; overload;  // throws java.sql.SQLException
    procedure setLogWriter(para1: JIPrintWriter); overload;  // throws java.sql.SQLException
    procedure setLoginTimeout(para1: jint); overload;  // throws java.sql.SQLException
    function getLoginTimeout(): jint; overload;  // throws java.sql.SQLException
  end;

  JSPooledConnection = interface external 'javax.sql' name 'PooledConnection' 
    function getConnection(): JSConnection; overload;  // throws java.sql.SQLException
    procedure close(); overload;  // throws java.sql.SQLException
    procedure addConnectionEventListener(para1: JSConnectionEventListener); overload;
    procedure removeConnectionEventListener(para1: JSConnectionEventListener); overload;
    procedure addStatementEventListener(para1: JSStatementEventListener); overload;
    procedure removeStatementEventListener(para1: JSStatementEventListener); overload;
  end;

  JSRowSetInternal = interface external 'javax.sql' name 'RowSetInternal' 
    function getParams(): Arr1JLObject; overload;  // throws java.sql.SQLException
    function getConnection(): JSConnection; overload;  // throws java.sql.SQLException
    procedure setMetaData(para1: JSRowSetMetaData); overload;  // throws java.sql.SQLException
    function getOriginal(): JSResultSet; overload;  // throws java.sql.SQLException
    function getOriginalRow(): JSResultSet; overload;  // throws java.sql.SQLException
  end;

  JSRowSetReader = interface external 'javax.sql' name 'RowSetReader' 
    procedure readData(para1: JSRowSetInternal); overload;  // throws java.sql.SQLException
  end;

  JSRowSetWriter = interface external 'javax.sql' name 'RowSetWriter' 
    function writeData(para1: JSRowSetInternal): jboolean; overload;  // throws java.sql.SQLException
  end;

  JSRJoinable = interface external 'javax.sql.rowset' name 'Joinable' 
    procedure setMatchColumn(para1: jint); overload;  // throws java.sql.SQLException
    procedure setMatchColumn(para1: Arr1jint); overload;  // throws java.sql.SQLException
    procedure setMatchColumn(var para1: array of jint); overload;  // throws java.sql.SQLException
    procedure setMatchColumn(para1: JLString); overload;  // throws java.sql.SQLException
    procedure setMatchColumn(para1: Arr1JLString); overload;  // throws java.sql.SQLException
    procedure setMatchColumn(var para1: array of JLString); overload;  // throws java.sql.SQLException
    function getMatchColumnIndexes(): Arr1jint; overload;  // throws java.sql.SQLException
    function getMatchColumnNames(): Arr1JLString; overload;  // throws java.sql.SQLException
    procedure unsetMatchColumn(para1: jint); overload;  // throws java.sql.SQLException
    procedure unsetMatchColumn(para1: Arr1jint); overload;  // throws java.sql.SQLException
    procedure unsetMatchColumn(var para1: array of jint); overload;  // throws java.sql.SQLException
    procedure unsetMatchColumn(para1: JLString); overload;  // throws java.sql.SQLException
    procedure unsetMatchColumn(para1: Arr1JLString); overload;  // throws java.sql.SQLException
    procedure unsetMatchColumn(var para1: array of JLString); overload;  // throws java.sql.SQLException
  end;

  JSRPredicate = interface external 'javax.sql.rowset' name 'Predicate' 
    function evaluate(para1: JSRowSet): jboolean; overload;
    function evaluate(para1: JLObject; para2: jint): jboolean; overload;  // throws java.sql.SQLException
    function evaluate(para1: JLObject; para2: JLString): jboolean; overload;  // throws java.sql.SQLException
  end;

  JSRSSyncFactory = class external 'javax.sql.rowset.spi' name 'SyncFactory' (JLObject)
  public
    class var
      fROWSET_SYNC_PROVIDER: JLString; external name 'ROWSET_SYNC_PROVIDER';
      fROWSET_SYNC_VENDOR: JLString; external name 'ROWSET_SYNC_VENDOR';
      fROWSET_SYNC_PROVIDER_VERSION: JLString; external name 'ROWSET_SYNC_PROVIDER_VERSION';
  public
    class procedure registerProvider(para1: JLString); static; overload;  // throws javax.sql.rowset.spi.SyncFactoryException
    class function getSyncFactory(): JSRSSyncFactory; static; overload;
    class procedure unregisterProvider(para1: JLString); static; overload;  // throws javax.sql.rowset.spi.SyncFactoryException
    class function getInstance(para1: JLString): JSRSSyncProvider; static; overload;  // throws javax.sql.rowset.spi.SyncFactoryException
    class function getRegisteredProviders(): JUEnumeration; static; overload;  // throws javax.sql.rowset.spi.SyncFactoryException
    class procedure setLogger(para1: JULLogger); static; overload;
    class procedure setLogger(para1: JULLogger; para2: JULLevel); static; overload;
    class function getLogger(): JULLogger; static; overload;  // throws javax.sql.rowset.spi.SyncFactoryException
    class procedure setJNDIContext(para1: JNContext); static; overload;  // throws javax.sql.rowset.spi.SyncFactoryException
  end;

  JSRSSyncProvider = class abstract external 'javax.sql.rowset.spi' name 'SyncProvider' (JLObject)
  public
    class var
      fGRADE_NONE: jint; external name 'GRADE_NONE';
      fGRADE_CHECK_MODIFIED_AT_COMMIT: jint; external name 'GRADE_CHECK_MODIFIED_AT_COMMIT';
      fGRADE_CHECK_ALL_AT_COMMIT: jint; external name 'GRADE_CHECK_ALL_AT_COMMIT';
      fGRADE_LOCK_WHEN_MODIFIED: jint; external name 'GRADE_LOCK_WHEN_MODIFIED';
      fGRADE_LOCK_WHEN_LOADED: jint; external name 'GRADE_LOCK_WHEN_LOADED';
      fDATASOURCE_NO_LOCK: jint; external name 'DATASOURCE_NO_LOCK';
      fDATASOURCE_ROW_LOCK: jint; external name 'DATASOURCE_ROW_LOCK';
      fDATASOURCE_TABLE_LOCK: jint; external name 'DATASOURCE_TABLE_LOCK';
      fDATASOURCE_DB_LOCK: jint; external name 'DATASOURCE_DB_LOCK';
      fUPDATABLE_VIEW_SYNC: jint; external name 'UPDATABLE_VIEW_SYNC';
      fNONUPDATABLE_VIEW_SYNC: jint; external name 'NONUPDATABLE_VIEW_SYNC';
  public
    constructor create(); overload;
    function getProviderID(): JLString; overload; virtual; abstract;
    function getRowSetReader(): JSRowSetReader; overload; virtual; abstract;
    function getRowSetWriter(): JSRowSetWriter; overload; virtual; abstract;
    function getProviderGrade(): jint; overload; virtual; abstract;
    procedure setDataSourceLock(para1: jint); overload; virtual; abstract;  // throws javax.sql.rowset.spi.SyncProviderException
    function getDataSourceLock(): jint; overload; virtual; abstract;  // throws javax.sql.rowset.spi.SyncProviderException
    function supportsUpdatableView(): jint; overload; virtual; abstract;
    function getVersion(): JLString; overload; virtual; abstract;
    function getVendor(): JLString; overload; virtual; abstract;
  end;

  JSBorderFactory = class external 'javax.swing' name 'BorderFactory' (JLObject)
  public
    class function createLineBorder(para1: JAColor): JSBBorder; static; overload;
    class function createLineBorder(para1: JAColor; para2: jint): JSBBorder; static; overload;
    class function createRaisedBevelBorder(): JSBBorder; static; overload;
    class function createLoweredBevelBorder(): JSBBorder; static; overload;
    class function createBevelBorder(para1: jint): JSBBorder; static; overload;
    class function createBevelBorder(para1: jint; para2: JAColor; para3: JAColor): JSBBorder; static; overload;
    class function createBevelBorder(para1: jint; para2: JAColor; para3: JAColor; para4: JAColor; para5: JAColor): JSBBorder; static; overload;
    class function createEtchedBorder(): JSBBorder; static; overload;
    class function createEtchedBorder(para1: JAColor; para2: JAColor): JSBBorder; static; overload;
    class function createEtchedBorder(para1: jint): JSBBorder; static; overload;
    class function createEtchedBorder(para1: jint; para2: JAColor; para3: JAColor): JSBBorder; static; overload;
    class function createTitledBorder(para1: JLString): JSBTitledBorder; static; overload;
    class function createTitledBorder(para1: JSBBorder): JSBTitledBorder; static; overload;
    class function createTitledBorder(para1: JSBBorder; para2: JLString): JSBTitledBorder; static; overload;
    class function createTitledBorder(para1: JSBBorder; para2: JLString; para3: jint; para4: jint): JSBTitledBorder; static; overload;
    class function createTitledBorder(para1: JSBBorder; para2: JLString; para3: jint; para4: jint; para5: JAFont): JSBTitledBorder; static; overload;
    class function createTitledBorder(para1: JSBBorder; para2: JLString; para3: jint; para4: jint; para5: JAFont; para6: JAColor): JSBTitledBorder; static; overload;
    class function createEmptyBorder(): JSBBorder; static; overload;
    class function createEmptyBorder(para1: jint; para2: jint; para3: jint; para4: jint): JSBBorder; static; overload;
    class function createCompoundBorder(): JSBCompoundBorder; static; overload;
    class function createCompoundBorder(para1: JSBBorder; para2: JSBBorder): JSBCompoundBorder; static; overload;
    class function createMatteBorder(para1: jint; para2: jint; para3: jint; para4: jint; para5: JAColor): JSBMatteBorder; static; overload;
    class function createMatteBorder(para1: jint; para2: jint; para3: jint; para4: jint; para5: JSIcon): JSBMatteBorder; static; overload;
  end;

  JSBoundedRangeModel = interface external 'javax.swing' name 'BoundedRangeModel' 
    function getMinimum(): jint; overload;
    procedure setMinimum(para1: jint); overload;
    function getMaximum(): jint; overload;
    procedure setMaximum(para1: jint); overload;
    function getValue(): jint; overload;
    procedure setValue(para1: jint); overload;
    procedure setValueIsAdjusting(para1: jboolean); overload;
    function getValueIsAdjusting(): jboolean; overload;
    function getExtent(): jint; overload;
    procedure setExtent(para1: jint); overload;
    procedure setRangeProperties(para1: jint; para2: jint; para3: jint; para4: jint; para5: jboolean); overload;
    procedure addChangeListener(para1: JSEChangeListener); overload;
    procedure removeChangeListener(para1: JSEChangeListener); overload;
  end;

  JSCellEditor = interface external 'javax.swing' name 'CellEditor' 
    function getCellEditorValue(): JLObject; overload;
    function isCellEditable(para1: JUEventObject): jboolean; overload;
    function shouldSelectCell(para1: JUEventObject): jboolean; overload;
    function stopCellEditing(): jboolean; overload;
    procedure cancelCellEditing(); overload;
    procedure addCellEditorListener(para1: JSECellEditorListener); overload;
    procedure removeCellEditorListener(para1: JSECellEditorListener); overload;
  end;

  JSComboBoxEditor = interface external 'javax.swing' name 'ComboBoxEditor' 
    function getEditorComponent(): JAComponent; overload;
    procedure setItem(para1: JLObject); overload;
    function getItem(): JLObject; overload;
    procedure selectAll(); overload;
    procedure addActionListener(para1: JAEActionListener); overload;
    procedure removeActionListener(para1: JAEActionListener); overload;
  end;

  JSDebugGraphicsInfo = class external 'javax.swing' name 'DebugGraphicsInfo' (JLObject)
  end;

  JSDesktopManager = interface external 'javax.swing' name 'DesktopManager' 
    procedure openFrame(para1: JSJInternalFrame); overload;
    procedure closeFrame(para1: JSJInternalFrame); overload;
    procedure maximizeFrame(para1: JSJInternalFrame); overload;
    procedure minimizeFrame(para1: JSJInternalFrame); overload;
    procedure iconifyFrame(para1: JSJInternalFrame); overload;
    procedure deiconifyFrame(para1: JSJInternalFrame); overload;
    procedure activateFrame(para1: JSJInternalFrame); overload;
    procedure deactivateFrame(para1: JSJInternalFrame); overload;
    procedure beginDraggingFrame(para1: JSJComponent); overload;
    procedure dragFrame(para1: JSJComponent; para2: jint; para3: jint); overload;
    procedure endDraggingFrame(para1: JSJComponent); overload;
    procedure beginResizingFrame(para1: JSJComponent; para2: jint); overload;
    procedure resizeFrame(para1: JSJComponent; para2: jint; para3: jint; para4: jint; para5: jint); overload;
    procedure endResizingFrame(para1: JSJComponent); overload;
    procedure setBoundsForFrame(para1: JSJComponent; para2: jint; para3: jint; para4: jint; para5: jint); overload;
  end;

  JSGraphicsWrapper = interface external 'javax.swing' name 'GraphicsWrapper' 
    function subGraphics(): JAGraphics; overload;
    function isClipIntersecting(para1: JARectangle): jboolean; overload;
    function getClipX(): jint; overload;
    function getClipY(): jint; overload;
    function getClipWidth(): jint; overload;
    function getClipHeight(): jint; overload;
  end;

  JSIcon = interface external 'javax.swing' name 'Icon' 
    procedure paintIcon(para1: JAComponent; para2: JAGraphics; para3: jint; para4: jint); overload;
    function getIconWidth(): jint; overload;
    function getIconHeight(): jint; overload;
  end;

  JSInputVerifier = class abstract external 'javax.swing' name 'InputVerifier' (JLObject)
  public
    constructor create(); overload;
    function verify(para1: JSJComponent): jboolean; overload; virtual; abstract;
    function shouldYieldFocus(para1: JSJComponent): jboolean; overload; virtual;
  end;

  JSKeyboardManager = class external 'javax.swing' name 'KeyboardManager' (JLObject)
  public
    type
      InnerComponentKeyStrokePair = class;
      Arr1InnerComponentKeyStrokePair = array of InnerComponentKeyStrokePair;
      Arr2InnerComponentKeyStrokePair = array of Arr1InnerComponentKeyStrokePair;
      Arr3InnerComponentKeyStrokePair = array of Arr2InnerComponentKeyStrokePair;
      InnerComponentKeyStrokePair = class external 'javax.swing' name 'ComponentKeyStrokePair' 
      end;

  public
    class function getCurrentManager(): JSKeyboardManager; static; overload;
    class procedure setCurrentManager(para1: JSKeyboardManager); static; overload;
    procedure registerKeyStroke(para1: JSKeyStroke; para2: JSJComponent); overload; virtual;
    procedure unregisterKeyStroke(para1: JSKeyStroke; para2: JSJComponent); overload; virtual;
    function fireKeyboardAction(para1: JAEKeyEvent; para2: jboolean; para3: JAContainer): jboolean; overload; virtual;
    procedure registerMenuBar(para1: JSJMenuBar); overload; virtual;
    procedure unregisterMenuBar(para1: JSJMenuBar); overload; virtual;
  strict protected
    function registerNewTopContainer(para1: JAContainer): JUHashtable; overload; virtual;
  end;

  JSListCellRenderer = interface external 'javax.swing' name 'ListCellRenderer' 
    function getListCellRendererComponent(para1: JSJList; para2: JLObject; para3: jint; para4: jboolean; para5: jboolean): JAComponent; overload;
  end;

  JSListModel = interface external 'javax.swing' name 'ListModel' 
    function getSize(): jint; overload;
    function getElementAt(para1: jint): JLObject; overload;
    procedure addListDataListener(para1: JSEListDataListener); overload;
    procedure removeListDataListener(para1: JSEListDataListener); overload;
  end;

  JSListSelectionModel = interface external 'javax.swing' name 'ListSelectionModel' 
    const
      SINGLE_SELECTION = 0;
      SINGLE_INTERVAL_SELECTION = 1;
      MULTIPLE_INTERVAL_SELECTION = 2;
    procedure setSelectionInterval(para1: jint; para2: jint); overload;
    procedure addSelectionInterval(para1: jint; para2: jint); overload;
    procedure removeSelectionInterval(para1: jint; para2: jint); overload;
    function getMinSelectionIndex(): jint; overload;
    function getMaxSelectionIndex(): jint; overload;
    function isSelectedIndex(para1: jint): jboolean; overload;
    function getAnchorSelectionIndex(): jint; overload;
    procedure setAnchorSelectionIndex(para1: jint); overload;
    function getLeadSelectionIndex(): jint; overload;
    procedure setLeadSelectionIndex(para1: jint); overload;
    procedure clearSelection(); overload;
    function isSelectionEmpty(): jboolean; overload;
    procedure insertIndexInterval(para1: jint; para2: jint; para3: jboolean); overload;
    procedure removeIndexInterval(para1: jint; para2: jint); overload;
    procedure setValueIsAdjusting(para1: jboolean); overload;
    function getValueIsAdjusting(): jboolean; overload;
    procedure setSelectionMode(para1: jint); overload;
    function getSelectionMode(): jint; overload;
    procedure addListSelectionListener(para1: JSEListSelectionListener); overload;
    procedure removeListSelectionListener(para1: JSEListSelectionListener); overload;
  end;

  JSMenuElement = interface external 'javax.swing' name 'MenuElement' 
    procedure processMouseEvent(para1: JAEMouseEvent; para2: Arr1JSMenuElement; para3: JSMenuSelectionManager); overload;
    procedure processMouseEvent(para1: JAEMouseEvent; var para2: array of JSMenuElement; para3: JSMenuSelectionManager); overload;
    procedure processKeyEvent(para1: JAEKeyEvent; para2: Arr1JSMenuElement; para3: JSMenuSelectionManager); overload;
    procedure processKeyEvent(para1: JAEKeyEvent; var para2: array of JSMenuElement; para3: JSMenuSelectionManager); overload;
    procedure menuSelectionChanged(para1: jboolean); overload;
    function getSubElements(): Arr1JSMenuElement; overload;
    function getComponent(): JAComponent; overload;
  end;

  JSMenuSelectionManager = class external 'javax.swing' name 'MenuSelectionManager' (JLObject)
  strict protected
    var
      fchangeEvent: JSEChangeEvent; external name 'changeEvent';
      flistenerList: JSEEventListenerList; external name 'listenerList';
  public
    constructor create(); overload;
    class function defaultManager(): JSMenuSelectionManager; static; overload;
    procedure setSelectedPath(para1: Arr1JSMenuElement); overload; virtual;
    procedure setSelectedPath(var para1: array of JSMenuElement); overload; virtual;
    function getSelectedPath(): Arr1JSMenuElement; overload; virtual;
    procedure clearSelectedPath(); overload; virtual;
    procedure addChangeListener(para1: JSEChangeListener); overload; virtual;
    procedure removeChangeListener(para1: JSEChangeListener); overload; virtual;
    function getChangeListeners(): Arr1JSEChangeListener; overload; virtual;
  strict protected
    procedure fireStateChanged(); overload; virtual;
  public
    procedure processMouseEvent(para1: JAEMouseEvent); overload; virtual;
    function componentForPoint(para1: JAComponent; para2: JAPoint): JAComponent; overload; virtual;
    procedure processKeyEvent(para1: JAEKeyEvent); overload; virtual;
    function isComponentPartOfCurrentMenu(para1: JAComponent): jboolean; overload; virtual;
  end;

  JSPopup = class external 'javax.swing' name 'Popup' (JLObject)
  public
    type
      InnerDefaultFrame = class;
      Arr1InnerDefaultFrame = array of InnerDefaultFrame;
      Arr2InnerDefaultFrame = array of Arr1InnerDefaultFrame;
      Arr3InnerDefaultFrame = array of Arr2InnerDefaultFrame;
      InnerHeavyWeightWindow = class;
      Arr1InnerHeavyWeightWindow = array of InnerHeavyWeightWindow;
      Arr2InnerHeavyWeightWindow = array of Arr1InnerHeavyWeightWindow;
      Arr3InnerHeavyWeightWindow = array of Arr2InnerHeavyWeightWindow;
      InnerDefaultFrame = class external 'javax.swing' name 'DefaultFrame' 
      end;

      InnerHeavyWeightWindow = class external 'javax.swing' name 'HeavyWeightWindow' 
      end;

  strict protected
    constructor create(para1: JAComponent; para2: JAComponent; para3: jint; para4: jint); overload;
    constructor create(); overload;
  public
    procedure show(); overload; virtual;
    procedure hide(); overload; virtual;
  end;

  JSPopupFactory = class external 'javax.swing' name 'PopupFactory' (JLObject)
  public
    type
      InnerContainerPopup = class;
      Arr1InnerContainerPopup = array of InnerContainerPopup;
      Arr2InnerContainerPopup = array of Arr1InnerContainerPopup;
      Arr3InnerContainerPopup = array of Arr2InnerContainerPopup;
      InnerHeavyWeightPopup = class;
      Arr1InnerHeavyWeightPopup = array of InnerHeavyWeightPopup;
      Arr2InnerHeavyWeightPopup = array of Arr1InnerHeavyWeightPopup;
      Arr3InnerHeavyWeightPopup = array of Arr2InnerHeavyWeightPopup;
      InnerHeadlessPopup = class;
      Arr1InnerHeadlessPopup = array of InnerHeadlessPopup;
      Arr2InnerHeadlessPopup = array of Arr1InnerHeadlessPopup;
      Arr3InnerHeadlessPopup = array of Arr2InnerHeadlessPopup;
      InnerLightWeightPopup = class;
      Arr1InnerLightWeightPopup = array of InnerLightWeightPopup;
      Arr2InnerLightWeightPopup = array of Arr1InnerLightWeightPopup;
      Arr3InnerLightWeightPopup = array of Arr2InnerLightWeightPopup;
      InnerMediumWeightPopup = class;
      Arr1InnerMediumWeightPopup = array of InnerMediumWeightPopup;
      Arr2InnerMediumWeightPopup = array of Arr1InnerMediumWeightPopup;
      Arr3InnerMediumWeightPopup = array of Arr2InnerMediumWeightPopup;
      InnerContainerPopup = class external 'javax.swing' name 'ContainerPopup' 
      end;

      InnerHeavyWeightPopup = class external 'javax.swing' name 'HeavyWeightPopup' 
      end;

      InnerHeadlessPopup = class external 'javax.swing' name 'HeadlessPopup' 
      end;

      InnerLightWeightPopup = class external 'javax.swing' name 'LightWeightPopup' 
      end;

      InnerMediumWeightPopup = class external 'javax.swing' name 'MediumWeightPopup' 
      public
        type
          InnerMediumWeightComponent = class;
          Arr1InnerMediumWeightComponent = array of InnerMediumWeightComponent;
          Arr2InnerMediumWeightComponent = array of Arr1InnerMediumWeightComponent;
          Arr3InnerMediumWeightComponent = array of Arr2InnerMediumWeightComponent;
          InnerMediumWeightComponent = class external 'javax.swing' name 'MediumWeightComponent' 
          end;

      end;

  public
    constructor create(); overload;
    class procedure setSharedInstance(para1: JSPopupFactory); static; overload;
    class function getSharedInstance(): JSPopupFactory; static; overload;
    function getPopup(para1: JAComponent; para2: JAComponent; para3: jint; para4: jint): JSPopup; overload; virtual;  // throws java.lang.IllegalArgumentException
  end;

  JSRenderer = interface external 'javax.swing' name 'Renderer' 
    procedure setValue(para1: JLObject; para2: jboolean); overload;
    function getComponent(): JAComponent; overload;
  end;

  JSRepaintManager = class external 'javax.swing' name 'RepaintManager' (JLObject)
  public
    type
      InnerDoubleBufferInfo = class;
      Arr1InnerDoubleBufferInfo = array of InnerDoubleBufferInfo;
      Arr2InnerDoubleBufferInfo = array of Arr1InnerDoubleBufferInfo;
      Arr3InnerDoubleBufferInfo = array of Arr2InnerDoubleBufferInfo;
      InnerPaintManager = class;
      Arr1InnerPaintManager = array of InnerPaintManager;
      Arr2InnerPaintManager = array of Arr1InnerPaintManager;
      Arr3InnerPaintManager = array of Arr2InnerPaintManager;
      InnerDisplayChangedHandler = class;
      Arr1InnerDisplayChangedHandler = array of InnerDisplayChangedHandler;
      Arr2InnerDisplayChangedHandler = array of Arr1InnerDisplayChangedHandler;
      Arr3InnerDisplayChangedHandler = array of Arr2InnerDisplayChangedHandler;
      InnerDisplayChangedRunnable = class;
      Arr1InnerDisplayChangedRunnable = array of InnerDisplayChangedRunnable;
      Arr2InnerDisplayChangedRunnable = array of Arr1InnerDisplayChangedRunnable;
      Arr3InnerDisplayChangedRunnable = array of Arr2InnerDisplayChangedRunnable;
      InnerProcessingRunnable = class;
      Arr1InnerProcessingRunnable = array of InnerProcessingRunnable;
      Arr2InnerProcessingRunnable = array of Arr1InnerProcessingRunnable;
      Arr3InnerProcessingRunnable = array of Arr2InnerProcessingRunnable;
      InnerDoubleBufferInfo = class external 'javax.swing' name 'DoubleBufferInfo' 
      end;

      InnerPaintManager = class external 'javax.swing' name 'PaintManager' 
      end;

      InnerDisplayChangedHandler = class sealed external 'javax.swing' name 'DisplayChangedHandler' 
      end;

      InnerDisplayChangedRunnable = class sealed external 'javax.swing' name 'DisplayChangedRunnable' 
      end;

      InnerProcessingRunnable = class sealed external 'javax.swing' name 'ProcessingRunnable' 
      end;

  public
    class function currentManager(para1: JAComponent): JSRepaintManager; static; overload;
    class function currentManager(para1: JSJComponent): JSRepaintManager; static; overload;
    class procedure setCurrentManager(para1: JSRepaintManager); static; overload;
    constructor create(); overload;
    procedure addInvalidComponent(para1: JSJComponent); overload; virtual;
    procedure removeInvalidComponent(para1: JSJComponent); overload; virtual;
    procedure addDirtyRegion(para1: JSJComponent; para2: jint; para3: jint; para4: jint; para5: jint); overload; virtual;
    procedure addDirtyRegion(para1: JAWindow; para2: jint; para3: jint; para4: jint; para5: jint); overload; virtual;
    procedure addDirtyRegion(para1: JAApplet; para2: jint; para3: jint; para4: jint; para5: jint); overload; virtual;
    function getDirtyRegion(para1: JSJComponent): JARectangle; overload; virtual;
    procedure markCompletelyDirty(para1: JSJComponent); overload; virtual;
    procedure markCompletelyClean(para1: JSJComponent); overload; virtual;
    function isCompletelyDirty(para1: JSJComponent): jboolean; overload; virtual;
    procedure validateInvalidComponents(); overload; virtual;
    procedure paintDirtyRegions(); overload; virtual;
    function toString(): JLString; overload; virtual;
    function getOffscreenBuffer(para1: JAComponent; para2: jint; para3: jint): JAImage; overload; virtual;
    function getVolatileOffscreenBuffer(para1: JAComponent; para2: jint; para3: jint): JAImage; overload; virtual;
    procedure setDoubleBufferMaximumSize(para1: JADimension); overload; virtual;
    function getDoubleBufferMaximumSize(): JADimension; overload; virtual;
    procedure setDoubleBufferingEnabled(para1: jboolean); overload; virtual;
    function isDoubleBufferingEnabled(): jboolean; overload; virtual;
  end;

  JSRootPaneContainer = interface external 'javax.swing' name 'RootPaneContainer' 
    function getRootPane(): JSJRootPane; overload;
    procedure setContentPane(para1: JAContainer); overload;
    function getContentPane(): JAContainer; overload;
    procedure setLayeredPane(para1: JSJLayeredPane); overload;
    function getLayeredPane(): JSJLayeredPane; overload;
    procedure setGlassPane(para1: JAComponent); overload;
    function getGlassPane(): JAComponent; overload;
  end;

  JSRowSorter = class abstract external 'javax.swing' name 'RowSorter' (JLObject)
  public
    type
      InnerSortKey = class;
      Arr1InnerSortKey = array of InnerSortKey;
      Arr2InnerSortKey = array of Arr1InnerSortKey;
      Arr3InnerSortKey = array of Arr2InnerSortKey;
      InnerSortKey = class external 'javax.swing' name 'SortKey' (JLObject)
      public
        constructor create(para1: jint; para2: JSSortOrder); overload;
        function getColumn(): jint; overload; virtual; final;
        function getSortOrder(): JSSortOrder; overload; virtual; final;
        function hashCode(): jint; overload; virtual;
        function equals(para1: JLObject): jboolean; overload; virtual;
      end;

  public
    constructor create(); overload;
    function getModel(): JLObject; overload; virtual; abstract;
    procedure toggleSortOrder(para1: jint); overload; virtual; abstract;
    function convertRowIndexToModel(para1: jint): jint; overload; virtual; abstract;
    function convertRowIndexToView(para1: jint): jint; overload; virtual; abstract;
    procedure setSortKeys(para1: JUList); overload; virtual; abstract;
    function getSortKeys(): JUList; overload; virtual; abstract;
    function getViewRowCount(): jint; overload; virtual; abstract;
    function getModelRowCount(): jint; overload; virtual; abstract;
    procedure modelStructureChanged(); overload; virtual; abstract;
    procedure allRowsChanged(); overload; virtual; abstract;
    procedure rowsInserted(para1: jint; para2: jint); overload; virtual; abstract;
    procedure rowsDeleted(para1: jint; para2: jint); overload; virtual; abstract;
    procedure rowsUpdated(para1: jint; para2: jint); overload; virtual; abstract;
    procedure rowsUpdated(para1: jint; para2: jint; para3: jint); overload; virtual; abstract;
    procedure addRowSorterListener(para1: JSERowSorterListener); overload; virtual;
    procedure removeRowSorterListener(para1: JSERowSorterListener); overload; virtual;
  strict protected
    procedure fireSortOrderChanged(); overload; virtual;
    procedure fireRowSorterChanged(para1: Arr1jint); overload; virtual;
    procedure fireRowSorterChanged(var para1: array of jint); overload; virtual;
  end;

  JSScrollPaneConstants = interface external 'javax.swing' name 'ScrollPaneConstants' 
    const
      VIEWPORT = 'VIEWPORT';
      VERTICAL_SCROLLBAR = 'VERTICAL_SCROLLBAR';
      HORIZONTAL_SCROLLBAR = 'HORIZONTAL_SCROLLBAR';
      ROW_HEADER = 'ROW_HEADER';
      COLUMN_HEADER = 'COLUMN_HEADER';
      LOWER_LEFT_CORNER = 'LOWER_LEFT_CORNER';
      LOWER_RIGHT_CORNER = 'LOWER_RIGHT_CORNER';
      UPPER_LEFT_CORNER = 'UPPER_LEFT_CORNER';
      UPPER_RIGHT_CORNER = 'UPPER_RIGHT_CORNER';
      LOWER_LEADING_CORNER = 'LOWER_LEADING_CORNER';
      LOWER_TRAILING_CORNER = 'LOWER_TRAILING_CORNER';
      UPPER_LEADING_CORNER = 'UPPER_LEADING_CORNER';
      UPPER_TRAILING_CORNER = 'UPPER_TRAILING_CORNER';
      VERTICAL_SCROLLBAR_POLICY = 'VERTICAL_SCROLLBAR_POLICY';
      HORIZONTAL_SCROLLBAR_POLICY = 'HORIZONTAL_SCROLLBAR_POLICY';
      VERTICAL_SCROLLBAR_AS_NEEDED = 20;
      VERTICAL_SCROLLBAR_NEVER = 21;
      VERTICAL_SCROLLBAR_ALWAYS = 22;
      HORIZONTAL_SCROLLBAR_AS_NEEDED = 30;
      HORIZONTAL_SCROLLBAR_NEVER = 31;
      HORIZONTAL_SCROLLBAR_ALWAYS = 32;
  end;

  JSScrollable = interface external 'javax.swing' name 'Scrollable' 
    function getPreferredScrollableViewportSize(): JADimension; overload;
    function getScrollableUnitIncrement(para1: JARectangle; para2: jint; para3: jint): jint; overload;
    function getScrollableBlockIncrement(para1: JARectangle; para2: jint; para3: jint): jint; overload;
    function getScrollableTracksViewportWidth(): jboolean; overload;
    function getScrollableTracksViewportHeight(): jboolean; overload;
  end;

  JSSingleSelectionModel = interface external 'javax.swing' name 'SingleSelectionModel' 
    function getSelectedIndex(): jint; overload;
    procedure setSelectedIndex(para1: jint); overload;
    procedure clearSelection(); overload;
    function isSelected(): jboolean; overload;
    procedure addChangeListener(para1: JSEChangeListener); overload;
    procedure removeChangeListener(para1: JSEChangeListener); overload;
  end;

  JSSizeSequence = class external 'javax.swing' name 'SizeSequence' (JLObject)
  public
    constructor create(); overload;
    constructor create(para1: jint); overload;
    constructor create(para1: jint; para2: jint); overload;
    constructor create(para1: Arr1jint); overload;
    constructor create(const para1: array of jint); overload;
    procedure setSizes(para1: Arr1jint); overload; virtual;
    procedure setSizes(var para1: array of jint); overload; virtual;
    function getSizes(): Arr1jint; overload; virtual;
    function getPosition(para1: jint): jint; overload; virtual;
    function getIndex(para1: jint): jint; overload; virtual;
    function getSize(para1: jint): jint; overload; virtual;
    procedure setSize(para1: jint; para2: jint); overload; virtual;
    procedure insertEntries(para1: jint; para2: jint; para3: jint); overload; virtual;
    procedure removeEntries(para1: jint; para2: jint); overload; virtual;
  end;

  JSSpinnerModel = interface external 'javax.swing' name 'SpinnerModel' 
    function getValue(): JLObject; overload;
    procedure setValue(para1: JLObject); overload;
    function getNextValue(): JLObject; overload;
    function getPreviousValue(): JLObject; overload;
    procedure addChangeListener(para1: JSEChangeListener); overload;
    procedure removeChangeListener(para1: JSEChangeListener); overload;
  end;

  JSSpring = class abstract external 'javax.swing' name 'Spring' (JLObject)
  public
    type
      InnerAbstractSpring = class;
      Arr1InnerAbstractSpring = array of InnerAbstractSpring;
      Arr2InnerAbstractSpring = array of Arr1InnerAbstractSpring;
      Arr3InnerAbstractSpring = array of Arr2InnerAbstractSpring;
      InnerCompoundSpring = class;
      Arr1InnerCompoundSpring = array of InnerCompoundSpring;
      Arr2InnerCompoundSpring = array of Arr1InnerCompoundSpring;
      Arr3InnerCompoundSpring = array of Arr2InnerCompoundSpring;
      InnerHeightSpring = class;
      Arr1InnerHeightSpring = array of InnerHeightSpring;
      Arr2InnerHeightSpring = array of Arr1InnerHeightSpring;
      Arr3InnerHeightSpring = array of Arr2InnerHeightSpring;
      InnerMaxSpring = class;
      Arr1InnerMaxSpring = array of InnerMaxSpring;
      Arr2InnerMaxSpring = array of Arr1InnerMaxSpring;
      Arr3InnerMaxSpring = array of Arr2InnerMaxSpring;
      InnerNegativeSpring = class;
      Arr1InnerNegativeSpring = array of InnerNegativeSpring;
      Arr2InnerNegativeSpring = array of Arr1InnerNegativeSpring;
      Arr3InnerNegativeSpring = array of Arr2InnerNegativeSpring;
      InnerScaleSpring = class;
      Arr1InnerScaleSpring = array of InnerScaleSpring;
      Arr2InnerScaleSpring = array of Arr1InnerScaleSpring;
      Arr3InnerScaleSpring = array of Arr2InnerScaleSpring;
      InnerSpringMap = class;
      Arr1InnerSpringMap = array of InnerSpringMap;
      Arr2InnerSpringMap = array of Arr1InnerSpringMap;
      Arr3InnerSpringMap = array of Arr2InnerSpringMap;
      InnerStaticSpring = class;
      Arr1InnerStaticSpring = array of InnerStaticSpring;
      Arr2InnerStaticSpring = array of Arr1InnerStaticSpring;
      Arr3InnerStaticSpring = array of Arr2InnerStaticSpring;
      InnerSumSpring = class;
      Arr1InnerSumSpring = array of InnerSumSpring;
      Arr2InnerSumSpring = array of Arr1InnerSumSpring;
      Arr3InnerSumSpring = array of Arr2InnerSumSpring;
      InnerWidthSpring = class;
      Arr1InnerWidthSpring = array of InnerWidthSpring;
      Arr2InnerWidthSpring = array of Arr1InnerWidthSpring;
      Arr3InnerWidthSpring = array of Arr2InnerWidthSpring;
      InnerAbstractSpring = class abstract external 'javax.swing' name 'AbstractSpring' 
      end;

      InnerCompoundSpring = class abstract external 'javax.swing' name 'CompoundSpring' 
      end;

      InnerHeightSpring = class external 'javax.swing' name 'HeightSpring' 
      end;

      InnerMaxSpring = class external 'javax.swing' name 'MaxSpring' 
      end;

      InnerNegativeSpring = class external 'javax.swing' name 'NegativeSpring' 
      end;

      InnerScaleSpring = class external 'javax.swing' name 'ScaleSpring' 
      end;

      InnerSpringMap = class abstract external 'javax.swing' name 'SpringMap' 
      end;

      InnerStaticSpring = class external 'javax.swing' name 'StaticSpring' 
      end;

      InnerSumSpring = class external 'javax.swing' name 'SumSpring' 
      end;

      InnerWidthSpring = class external 'javax.swing' name 'WidthSpring' 
      end;

  public
    const
      UNSET = -2147483648;
  strict protected
    constructor create(); overload;
  public
    function getMinimumValue(): jint; overload; virtual; abstract;
    function getPreferredValue(): jint; overload; virtual; abstract;
    function getMaximumValue(): jint; overload; virtual; abstract;
    function getValue(): jint; overload; virtual; abstract;
    procedure setValue(para1: jint); overload; virtual; abstract;
    class function constant(para1: jint): JSSpring; static; overload;
    class function constant(para1: jint; para2: jint; para3: jint): JSSpring; static; overload;
    class function minus(para1: JSSpring): JSSpring; static; overload;
    class function sum(para1: JSSpring; para2: JSSpring): JSSpring; static; overload;
    class function max(para1: JSSpring; para2: JSSpring): JSSpring; static; overload;
    class function scale(para1: JSSpring; para2: jfloat): JSSpring; static; overload;
    class function width(para1: JAComponent): JSSpring; static; overload;
    class function height(para1: JAComponent): JSSpring; static; overload;
  end;

  JSSwingConstants = interface external 'javax.swing' name 'SwingConstants' 
    const
      CENTER = 0;
      TOP = 1;
      LEFT = 2;
      BOTTOM = 3;
      RIGHT = 4;
      NORTH = 1;
      NORTH_EAST = 2;
      EAST = 3;
      SOUTH_EAST = 4;
      SOUTH = 5;
      SOUTH_WEST = 6;
      WEST = 7;
      NORTH_WEST = 8;
      HORIZONTAL = 0;
      VERTICAL = 1;
      LEADING = 10;
      TRAILING = 11;
      NEXT = 12;
      PREVIOUS = 13;
  end;

  JSSwingHeavyWeight = interface external 'javax.swing' name 'SwingHeavyWeight' 
  end;

  JSWindowConstants = interface external 'javax.swing' name 'WindowConstants' 
    const
      DO_NOTHING_ON_CLOSE = 0;
      HIDE_ON_CLOSE = 1;
      DISPOSE_ON_CLOSE = 2;
      EXIT_ON_CLOSE = 3;
  end;

  JSBBorder = interface external 'javax.swing.border' name 'Border' 
    procedure paintBorder(para1: JAComponent; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload;
    function getBorderInsets(para1: JAComponent): JAInsets; overload;
    function isBorderOpaque(): jboolean; overload;
  end;

  JSCColorChooserComponentFactory = class external 'javax.swing.colorchooser' name 'ColorChooserComponentFactory' (JLObject)
  public
    class function getDefaultChooserPanels(): Arr1JSCAbstractColorChooserPanel; static; overload;
    class function getPreviewPanel(): JSJComponent; static; overload;
  end;

  JSCColorSelectionModel = interface external 'javax.swing.colorchooser' name 'ColorSelectionModel' 
    function getSelectedColor(): JAColor; overload;
    procedure setSelectedColor(para1: JAColor); overload;
    procedure addChangeListener(para1: JSEChangeListener); overload;
    procedure removeChangeListener(para1: JSEChangeListener); overload;
  end;

  JSEDocumentEvent = interface external 'javax.swing.event' name 'DocumentEvent' 
    type
      InnerElementChange = interface;
      Arr1InnerElementChange = array of InnerElementChange;
      Arr2InnerElementChange = array of Arr1InnerElementChange;
      Arr3InnerElementChange = array of Arr2InnerElementChange;
      InnerEventType = class;
      Arr1InnerEventType = array of InnerEventType;
      Arr2InnerEventType = array of Arr1InnerEventType;
      Arr3InnerEventType = array of Arr2InnerEventType;
      InnerElementChange = interface external 'javax.swing.event' name 'ElementChange' 
        function getElement(): JSTElement; overload;
        function getIndex(): jint; overload;
        function getChildrenRemoved(): Arr1JSTElement; overload;
        function getChildrenAdded(): Arr1JSTElement; overload;
      end;

      InnerEventType = class sealed external 'javax.swing.event' name 'EventType' (JLObject)
      public
        final class var
          fINSERT: JSEDocumentEvent.InnerEventType; external name 'INSERT';
          fREMOVE: JSEDocumentEvent.InnerEventType; external name 'REMOVE';
          fCHANGE: JSEDocumentEvent.InnerEventType; external name 'CHANGE';
      public
        function toString(): JLString; overload; virtual;
      end;

    function getOffset(): jint; overload;
    function getLength(): jint; overload;
    function getDocument(): JSTDocument; overload;
    function getType(): JSEDocumentEvent.InnerEventType; overload;
    function getChange(para1: JSTElement): JSEDocumentEvent.InnerElementChange; overload;
  end;

  JSFFileFilter = class abstract external 'javax.swing.filechooser' name 'FileFilter' (JLObject)
  public
    constructor create(); overload;
    function accept(para1: JIFile): jboolean; overload; virtual; abstract;
    function getDescription(): JLString; overload; virtual; abstract;
  end;

  JSFFileSystemView = class abstract external 'javax.swing.filechooser' name 'FileSystemView' (JLObject)
  public
    type
      InnerFileSystemRoot = class;
      Arr1InnerFileSystemRoot = array of InnerFileSystemRoot;
      Arr2InnerFileSystemRoot = array of Arr1InnerFileSystemRoot;
      Arr3InnerFileSystemRoot = array of Arr2InnerFileSystemRoot;
      InnerFileSystemRoot = class external 'javax.swing.filechooser' name 'FileSystemRoot' 
      end;

  public
    constructor create(); overload;
    class function getFileSystemView(): JSFFileSystemView; static; overload;
    function isRoot(para1: JIFile): jboolean; overload; virtual;
    function isTraversable(para1: JIFile): JLBoolean; overload; virtual;
    function getSystemDisplayName(para1: JIFile): JLString; overload; virtual;
    function getSystemTypeDescription(para1: JIFile): JLString; overload; virtual;
    function getSystemIcon(para1: JIFile): JSIcon; overload; virtual;
    function isParent(para1: JIFile; para2: JIFile): jboolean; overload; virtual;
    function getChild(para1: JIFile; para2: JLString): JIFile; overload; virtual;
    function isFileSystem(para1: JIFile): jboolean; overload; virtual;
    function createNewFolder(para1: JIFile): JIFile; overload; virtual; abstract;  // throws java.io.IOException
    function isHiddenFile(para1: JIFile): jboolean; overload; virtual;
    function isFileSystemRoot(para1: JIFile): jboolean; overload; virtual;
    function isDrive(para1: JIFile): jboolean; overload; virtual;
    function isFloppyDrive(para1: JIFile): jboolean; overload; virtual;
    function isComputerNode(para1: JIFile): jboolean; overload; virtual;
    function getRoots(): Arr1JIFile; overload; virtual;
    function getHomeDirectory(): JIFile; overload; virtual;
    function getDefaultDirectory(): JIFile; overload; virtual;
    function createFileObject(para1: JIFile; para2: JLString): JIFile; overload; virtual;
    function createFileObject(para1: JLString): JIFile; overload; virtual;
    function getFiles(para1: JIFile; para2: jboolean): Arr1JIFile; overload; virtual;
    function getParentDirectory(para1: JIFile): JIFile; overload; virtual;
  strict protected
    function createFileSystemRoot(para1: JIFile): JIFile; overload; virtual;
  end;

  JSFFileView = class abstract external 'javax.swing.filechooser' name 'FileView' (JLObject)
  public
    constructor create(); overload;
    function getName(para1: JIFile): JLString; overload; virtual;
    function getDescription(para1: JIFile): JLString; overload; virtual;
    function getTypeDescription(para1: JIFile): JLString; overload; virtual;
    function getIcon(para1: JIFile): JSIcon; overload; virtual;
    function isTraversable(para1: JIFile): JLBoolean; overload; virtual;
  end;

  JSPUIResource = interface external 'javax.swing.plaf' name 'UIResource' 
  end;

  JSPBBasicGraphicsUtils = class external 'javax.swing.plaf.basic' name 'BasicGraphicsUtils' (JLObject)
  public
    constructor create(); overload;
    class procedure drawEtchedRect(para1: JAGraphics; para2: jint; para3: jint; para4: jint; para5: jint; para6: JAColor; para7: JAColor; para8: JAColor; para9: JAColor); static; overload;
    class function getEtchedInsets(): JAInsets; static; overload;
    class procedure drawGroove(para1: JAGraphics; para2: jint; para3: jint; para4: jint; para5: jint; para6: JAColor; para7: JAColor); static; overload;
    class function getGrooveInsets(): JAInsets; static; overload;
    class procedure drawBezel(para1: JAGraphics; para2: jint; para3: jint; para4: jint; para5: jint; para6: jboolean; para7: jboolean; para8: JAColor; para9: JAColor; para10: JAColor; para11: JAColor); static; overload;
    class procedure drawLoweredBezel(para1: JAGraphics; para2: jint; para3: jint; para4: jint; para5: jint; para6: JAColor; para7: JAColor; para8: JAColor; para9: JAColor); static; overload;
    class procedure drawString(para1: JAGraphics; para2: JLString; para3: jint; para4: jint; para5: jint); static; overload;
    class procedure drawStringUnderlineCharAt(para1: JAGraphics; para2: JLString; para3: jint; para4: jint; para5: jint); static; overload;
    class procedure drawDashedRect(para1: JAGraphics; para2: jint; para3: jint; para4: jint; para5: jint); static; overload;
    class function getPreferredButtonSize(para1: JSAbstractButton; para2: jint): JADimension; static; overload;
  end;

  JSPBBasicHTML = class external 'javax.swing.plaf.basic' name 'BasicHTML' (JLObject)
  public
    type
      InnerBasicDocument = class;
      Arr1InnerBasicDocument = array of InnerBasicDocument;
      Arr2InnerBasicDocument = array of Arr1InnerBasicDocument;
      Arr3InnerBasicDocument = array of Arr2InnerBasicDocument;
      InnerBasicEditorKit = class;
      Arr1InnerBasicEditorKit = array of InnerBasicEditorKit;
      Arr2InnerBasicEditorKit = array of Arr1InnerBasicEditorKit;
      Arr3InnerBasicEditorKit = array of Arr2InnerBasicEditorKit;
      InnerBasicHTMLViewFactory = class;
      Arr1InnerBasicHTMLViewFactory = array of InnerBasicHTMLViewFactory;
      Arr2InnerBasicHTMLViewFactory = array of Arr1InnerBasicHTMLViewFactory;
      Arr3InnerBasicHTMLViewFactory = array of Arr2InnerBasicHTMLViewFactory;
      InnerRenderer = class;
      Arr1InnerRenderer = array of InnerRenderer;
      Arr2InnerRenderer = array of Arr1InnerRenderer;
      Arr3InnerRenderer = array of Arr2InnerRenderer;
      InnerBasicDocument = class external 'javax.swing.plaf.basic' name 'BasicDocument' 
      end;

      InnerBasicEditorKit = class external 'javax.swing.plaf.basic' name 'BasicEditorKit' 
      end;

      InnerBasicHTMLViewFactory = class external 'javax.swing.plaf.basic' name 'BasicHTMLViewFactory' 
      end;

      InnerRenderer = class external 'javax.swing.plaf.basic' name 'Renderer' 
      end;

  public
    const
      propertyKey = 'html';
      documentBaseKey = 'html.base';
  public
    constructor create(); overload;
    class function createHTMLView(para1: JSJComponent; para2: JLString): JSTView; static; overload;
    class function getHTMLBaseline(para1: JSTView; para2: jint; para3: jint): jint; static; overload;
    class function isHTMLString(para1: JLString): jboolean; static; overload;
    class procedure updateRenderer(para1: JSJComponent; para2: JLString); static; overload;
  end;

  JSPBComboPopup = interface external 'javax.swing.plaf.basic' name 'ComboPopup' 
    procedure show(); overload;
    procedure hide(); overload;
    function isVisible(): jboolean; overload;
    function getList(): JSJList; overload;
    function getMouseListener(): JAEMouseListener; overload;
    function getMouseMotionListener(): JAEMouseMotionListener; overload;
    function getKeyListener(): JAEKeyListener; overload;
    procedure uninstallingUI(); overload;
  end;

  JSPBDragRecognitionSupport = class external 'javax.swing.plaf.basic' name 'DragRecognitionSupport' (JLObject)
  public
    type
      InnerBeforeDrag = interface;
      Arr1InnerBeforeDrag = array of InnerBeforeDrag;
      Arr2InnerBeforeDrag = array of Arr1InnerBeforeDrag;
      Arr3InnerBeforeDrag = array of Arr2InnerBeforeDrag;
      InnerBeforeDrag = interface external 'javax.swing.plaf.basic' name 'BeforeDrag' 
        procedure dragStarting(para1: JAEMouseEvent); overload;
      end;

  public
    class function mousePressed(para1: JAEMouseEvent): jboolean; static; overload;
    class function mouseReleased(para1: JAEMouseEvent): JAEMouseEvent; static; overload;
    class function mouseDragged(para1: JAEMouseEvent; para2: JSPBDragRecognitionSupport.InnerBeforeDrag): jboolean; static; overload;
  end;

  JSPMBumpBuffer = class external 'javax.swing.plaf.metal' name 'BumpBuffer' (JLObject)
  public
    constructor create(para1: JAGraphicsConfiguration; para2: JAColor; para3: JAColor; para4: JAColor); overload;
    function hasSameConfiguration(para1: JAGraphicsConfiguration; para2: JAColor; para3: JAColor; para4: JAColor): jboolean; overload; virtual;
    function getImage(): JAImage; overload; virtual;
  end;

  JSPMMetalTheme = class abstract external 'javax.swing.plaf.metal' name 'MetalTheme' (JLObject)
  public
    constructor create(); overload;
    function getName(): JLString; overload; virtual; abstract;
  strict protected
    function getPrimary1(): JSPColorUIResource; overload; virtual; abstract;
    function getPrimary2(): JSPColorUIResource; overload; virtual; abstract;
    function getPrimary3(): JSPColorUIResource; overload; virtual; abstract;
    function getSecondary1(): JSPColorUIResource; overload; virtual; abstract;
    function getSecondary2(): JSPColorUIResource; overload; virtual; abstract;
    function getSecondary3(): JSPColorUIResource; overload; virtual; abstract;
  public
    function getControlTextFont(): JSPFontUIResource; overload; virtual; abstract;
    function getSystemTextFont(): JSPFontUIResource; overload; virtual; abstract;
    function getUserTextFont(): JSPFontUIResource; overload; virtual; abstract;
    function getMenuTextFont(): JSPFontUIResource; overload; virtual; abstract;
    function getWindowTitleFont(): JSPFontUIResource; overload; virtual; abstract;
    function getSubTextFont(): JSPFontUIResource; overload; virtual; abstract;
  strict protected
    function getWhite(): JSPColorUIResource; overload; virtual;
    function getBlack(): JSPColorUIResource; overload; virtual;
  public
    function getFocusColor(): JSPColorUIResource; overload; virtual;
    function getDesktopColor(): JSPColorUIResource; overload; virtual;
    function getControl(): JSPColorUIResource; overload; virtual;
    function getControlShadow(): JSPColorUIResource; overload; virtual;
    function getControlDarkShadow(): JSPColorUIResource; overload; virtual;
    function getControlInfo(): JSPColorUIResource; overload; virtual;
    function getControlHighlight(): JSPColorUIResource; overload; virtual;
    function getControlDisabled(): JSPColorUIResource; overload; virtual;
    function getPrimaryControl(): JSPColorUIResource; overload; virtual;
    function getPrimaryControlShadow(): JSPColorUIResource; overload; virtual;
    function getPrimaryControlDarkShadow(): JSPColorUIResource; overload; virtual;
    function getPrimaryControlInfo(): JSPColorUIResource; overload; virtual;
    function getPrimaryControlHighlight(): JSPColorUIResource; overload; virtual;
    function getSystemTextColor(): JSPColorUIResource; overload; virtual;
    function getControlTextColor(): JSPColorUIResource; overload; virtual;
    function getInactiveControlTextColor(): JSPColorUIResource; overload; virtual;
    function getInactiveSystemTextColor(): JSPColorUIResource; overload; virtual;
    function getUserTextColor(): JSPColorUIResource; overload; virtual;
    function getTextHighlightColor(): JSPColorUIResource; overload; virtual;
    function getHighlightedTextColor(): JSPColorUIResource; overload; virtual;
    function getWindowBackground(): JSPColorUIResource; overload; virtual;
    function getWindowTitleBackground(): JSPColorUIResource; overload; virtual;
    function getWindowTitleForeground(): JSPColorUIResource; overload; virtual;
    function getWindowTitleInactiveBackground(): JSPColorUIResource; overload; virtual;
    function getWindowTitleInactiveForeground(): JSPColorUIResource; overload; virtual;
    function getMenuBackground(): JSPColorUIResource; overload; virtual;
    function getMenuForeground(): JSPColorUIResource; overload; virtual;
    function getMenuSelectedBackground(): JSPColorUIResource; overload; virtual;
    function getMenuSelectedForeground(): JSPColorUIResource; overload; virtual;
    function getMenuDisabledForeground(): JSPColorUIResource; overload; virtual;
    function getSeparatorBackground(): JSPColorUIResource; overload; virtual;
    function getSeparatorForeground(): JSPColorUIResource; overload; virtual;
    function getAcceleratorForeground(): JSPColorUIResource; overload; virtual;
    function getAcceleratorSelectedForeground(): JSPColorUIResource; overload; virtual;
    procedure addCustomEntriesToTable(para1: JSUIDefaults); overload; virtual;
  end;

  JSPMMetalUtils = class external 'javax.swing.plaf.metal' name 'MetalUtils' (JLObject)
  public
    type
      InnerGradientPainter = class;
      Arr1InnerGradientPainter = array of InnerGradientPainter;
      Arr2InnerGradientPainter = array of Arr1InnerGradientPainter;
      Arr3InnerGradientPainter = array of Arr2InnerGradientPainter;
      InnerOceanDisabledButtonImageFilter = class;
      Arr1InnerOceanDisabledButtonImageFilter = array of InnerOceanDisabledButtonImageFilter;
      Arr2InnerOceanDisabledButtonImageFilter = array of Arr1InnerOceanDisabledButtonImageFilter;
      Arr3InnerOceanDisabledButtonImageFilter = array of Arr2InnerOceanDisabledButtonImageFilter;
      InnerOceanToolBarImageFilter = class;
      Arr1InnerOceanToolBarImageFilter = array of InnerOceanToolBarImageFilter;
      Arr2InnerOceanToolBarImageFilter = array of Arr1InnerOceanToolBarImageFilter;
      Arr3InnerOceanToolBarImageFilter = array of Arr2InnerOceanToolBarImageFilter;
      InnerGradientPainter = class external 'javax.swing.plaf.metal' name 'GradientPainter' 
      end;

      InnerOceanDisabledButtonImageFilter = class external 'javax.swing.plaf.metal' name 'OceanDisabledButtonImageFilter' 
      end;

      InnerOceanToolBarImageFilter = class external 'javax.swing.plaf.metal' name 'OceanToolBarImageFilter' 
      end;

  end;

  JSPSColorType = class external 'javax.swing.plaf.synth' name 'ColorType' (JLObject)
  public
    final class var
      fFOREGROUND: JSPSColorType; external name 'FOREGROUND';
      fBACKGROUND: JSPSColorType; external name 'BACKGROUND';
      fTEXT_FOREGROUND: JSPSColorType; external name 'TEXT_FOREGROUND';
      fTEXT_BACKGROUND: JSPSColorType; external name 'TEXT_BACKGROUND';
      fFOCUS: JSPSColorType; external name 'FOCUS';
      fMAX_COUNT: jint; external name 'MAX_COUNT';
  strict protected
    constructor create(para1: JLString); overload;
  public
    function getID(): jint; overload; virtual; final;
    function toString(): JLString; overload; virtual;
  end;

  JSPSRegion = class external 'javax.swing.plaf.synth' name 'Region' (JLObject)
  public
    final class var
      fARROW_BUTTON: JSPSRegion; external name 'ARROW_BUTTON';
      fBUTTON: JSPSRegion; external name 'BUTTON';
      fCHECK_BOX: JSPSRegion; external name 'CHECK_BOX';
      fCHECK_BOX_MENU_ITEM: JSPSRegion; external name 'CHECK_BOX_MENU_ITEM';
      fCOLOR_CHOOSER: JSPSRegion; external name 'COLOR_CHOOSER';
      fCOMBO_BOX: JSPSRegion; external name 'COMBO_BOX';
      fDESKTOP_PANE: JSPSRegion; external name 'DESKTOP_PANE';
      fDESKTOP_ICON: JSPSRegion; external name 'DESKTOP_ICON';
      fEDITOR_PANE: JSPSRegion; external name 'EDITOR_PANE';
      fFILE_CHOOSER: JSPSRegion; external name 'FILE_CHOOSER';
      fFORMATTED_TEXT_FIELD: JSPSRegion; external name 'FORMATTED_TEXT_FIELD';
      fINTERNAL_FRAME: JSPSRegion; external name 'INTERNAL_FRAME';
      fINTERNAL_FRAME_TITLE_PANE: JSPSRegion; external name 'INTERNAL_FRAME_TITLE_PANE';
      fLABEL: JSPSRegion; external name 'LABEL';
      fLIST: JSPSRegion; external name 'LIST';
      fMENU: JSPSRegion; external name 'MENU';
      fMENU_BAR: JSPSRegion; external name 'MENU_BAR';
      fMENU_ITEM: JSPSRegion; external name 'MENU_ITEM';
      fMENU_ITEM_ACCELERATOR: JSPSRegion; external name 'MENU_ITEM_ACCELERATOR';
      fOPTION_PANE: JSPSRegion; external name 'OPTION_PANE';
      fPANEL: JSPSRegion; external name 'PANEL';
      fPASSWORD_FIELD: JSPSRegion; external name 'PASSWORD_FIELD';
      fPOPUP_MENU: JSPSRegion; external name 'POPUP_MENU';
      fPOPUP_MENU_SEPARATOR: JSPSRegion; external name 'POPUP_MENU_SEPARATOR';
      fPROGRESS_BAR: JSPSRegion; external name 'PROGRESS_BAR';
      fRADIO_BUTTON: JSPSRegion; external name 'RADIO_BUTTON';
      fRADIO_BUTTON_MENU_ITEM: JSPSRegion; external name 'RADIO_BUTTON_MENU_ITEM';
      fROOT_PANE: JSPSRegion; external name 'ROOT_PANE';
      fSCROLL_BAR: JSPSRegion; external name 'SCROLL_BAR';
      fSCROLL_BAR_TRACK: JSPSRegion; external name 'SCROLL_BAR_TRACK';
      fSCROLL_BAR_THUMB: JSPSRegion; external name 'SCROLL_BAR_THUMB';
      fSCROLL_PANE: JSPSRegion; external name 'SCROLL_PANE';
      fSEPARATOR: JSPSRegion; external name 'SEPARATOR';
      fSLIDER: JSPSRegion; external name 'SLIDER';
      fSLIDER_TRACK: JSPSRegion; external name 'SLIDER_TRACK';
      fSLIDER_THUMB: JSPSRegion; external name 'SLIDER_THUMB';
      fSPINNER: JSPSRegion; external name 'SPINNER';
      fSPLIT_PANE: JSPSRegion; external name 'SPLIT_PANE';
      fSPLIT_PANE_DIVIDER: JSPSRegion; external name 'SPLIT_PANE_DIVIDER';
      fTABBED_PANE: JSPSRegion; external name 'TABBED_PANE';
      fTABBED_PANE_TAB: JSPSRegion; external name 'TABBED_PANE_TAB';
      fTABBED_PANE_TAB_AREA: JSPSRegion; external name 'TABBED_PANE_TAB_AREA';
      fTABBED_PANE_CONTENT: JSPSRegion; external name 'TABBED_PANE_CONTENT';
      fTABLE: JSPSRegion; external name 'TABLE';
      fTABLE_HEADER: JSPSRegion; external name 'TABLE_HEADER';
      fTEXT_AREA: JSPSRegion; external name 'TEXT_AREA';
      fTEXT_FIELD: JSPSRegion; external name 'TEXT_FIELD';
      fTEXT_PANE: JSPSRegion; external name 'TEXT_PANE';
      fTOGGLE_BUTTON: JSPSRegion; external name 'TOGGLE_BUTTON';
      fTOOL_BAR: JSPSRegion; external name 'TOOL_BAR';
      fTOOL_BAR_CONTENT: JSPSRegion; external name 'TOOL_BAR_CONTENT';
      fTOOL_BAR_DRAG_WINDOW: JSPSRegion; external name 'TOOL_BAR_DRAG_WINDOW';
      fTOOL_TIP: JSPSRegion; external name 'TOOL_TIP';
      fTOOL_BAR_SEPARATOR: JSPSRegion; external name 'TOOL_BAR_SEPARATOR';
      fTREE: JSPSRegion; external name 'TREE';
      fTREE_CELL: JSPSRegion; external name 'TREE_CELL';
      fVIEWPORT: JSPSRegion; external name 'VIEWPORT';
  strict protected
    constructor create(para1: JLString; para2: JLString; para3: jboolean); overload;
  public
    function isSubregion(): jboolean; overload; virtual;
    function getName(): JLString; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JSPSSynthConstants = interface external 'javax.swing.plaf.synth' name 'SynthConstants' 
    const
      ENABLED = 1;
      MOUSE_OVER = 2;
      PRESSED = 4;
      DISABLED = 8;
      FOCUSED = 256;
      SELECTED = 512;
      DEFAULT = 1024;
  end;

  JSPSSynthContext = class external 'javax.swing.plaf.synth' name 'SynthContext' (JLObject)
  public
    constructor create(para1: JSJComponent; para2: JSPSRegion; para3: JSPSSynthStyle; para4: jint); overload;
    function getComponent(): JSJComponent; overload; virtual;
    function getRegion(): JSPSRegion; overload; virtual;
    function getStyle(): JSPSSynthStyle; overload; virtual;
    function getComponentState(): jint; overload; virtual;
  end;

  JSPSSynthGraphicsUtils = class external 'javax.swing.plaf.synth' name 'SynthGraphicsUtils' (JLObject)
  public
    type
      InnerSynthIconWrapper = class;
      Arr1InnerSynthIconWrapper = array of InnerSynthIconWrapper;
      Arr2InnerSynthIconWrapper = array of Arr1InnerSynthIconWrapper;
      Arr3InnerSynthIconWrapper = array of Arr2InnerSynthIconWrapper;
      InnerSynthIconWrapper = class external 'javax.swing.plaf.synth' name 'SynthIconWrapper' 
      end;

  public
    constructor create(); overload;
    procedure drawLine(para1: JSPSSynthContext; para2: JLObject; para3: JAGraphics; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure drawLine(para1: JSPSSynthContext; para2: JLObject; para3: JAGraphics; para4: jint; para5: jint; para6: jint; para7: jint; para8: JLObject); overload; virtual;
    function layoutText(para1: JSPSSynthContext; para2: JAFontMetrics; para3: JLString; para4: JSIcon; para5: jint; para6: jint; para7: jint; para8: jint; para9: JARectangle; para10: JARectangle; para11: JARectangle; para12: jint): JLString; overload; virtual;
    function computeStringWidth(para1: JSPSSynthContext; para2: JAFont; para3: JAFontMetrics; para4: JLString): jint; overload; virtual;
    function getMinimumSize(para1: JSPSSynthContext; para2: JAFont; para3: JLString; para4: JSIcon; para5: jint; para6: jint; para7: jint; para8: jint; para9: jint; para10: jint): JADimension; overload; virtual;
    function getMaximumSize(para1: JSPSSynthContext; para2: JAFont; para3: JLString; para4: JSIcon; para5: jint; para6: jint; para7: jint; para8: jint; para9: jint; para10: jint): JADimension; overload; virtual;
    function getMaximumCharHeight(para1: JSPSSynthContext): jint; overload; virtual;
    function getPreferredSize(para1: JSPSSynthContext; para2: JAFont; para3: JLString; para4: JSIcon; para5: jint; para6: jint; para7: jint; para8: jint; para9: jint; para10: jint): JADimension; overload; virtual;
    procedure paintText(para1: JSPSSynthContext; para2: JAGraphics; para3: JLString; para4: JARectangle; para5: jint); overload; virtual;
    procedure paintText(para1: JSPSSynthContext; para2: JAGraphics; para3: JLString; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintText(para1: JSPSSynthContext; para2: JAGraphics; para3: JLString; para4: JSIcon; para5: jint; para6: jint; para7: jint; para8: jint; para9: jint; para10: jint; para11: jint); overload; virtual;
  end;

  JSPSSynthPainter = class abstract external 'javax.swing.plaf.synth' name 'SynthPainter' (JLObject)
  public
    constructor create(); overload;
    procedure paintArrowButtonBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintArrowButtonBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintArrowButtonForeground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintButtonBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintButtonBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintCheckBoxMenuItemBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintCheckBoxMenuItemBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintCheckBoxBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintCheckBoxBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintColorChooserBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintColorChooserBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintComboBoxBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintComboBoxBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintDesktopIconBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintDesktopIconBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintDesktopPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintDesktopPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintEditorPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintEditorPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintFileChooserBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintFileChooserBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintFormattedTextFieldBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintFormattedTextFieldBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintInternalFrameTitlePaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintInternalFrameTitlePaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintInternalFrameBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintInternalFrameBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintLabelBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintLabelBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintListBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintListBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintMenuBarBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintMenuBarBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintMenuItemBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintMenuItemBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintMenuBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintMenuBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintOptionPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintOptionPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintPanelBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintPanelBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintPasswordFieldBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintPasswordFieldBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintPopupMenuBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintPopupMenuBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintProgressBarBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintProgressBarBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintProgressBarBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintProgressBarBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintProgressBarForeground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintRadioButtonMenuItemBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintRadioButtonMenuItemBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintRadioButtonBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintRadioButtonBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintRootPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintRootPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintScrollBarBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintScrollBarBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintScrollBarBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintScrollBarBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintScrollBarThumbBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintScrollBarThumbBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintScrollBarTrackBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintScrollBarTrackBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintScrollBarTrackBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintScrollBarTrackBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintScrollPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintScrollPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSeparatorBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSeparatorBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSeparatorBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSeparatorBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSeparatorForeground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSliderBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSliderBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSliderBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSliderBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSliderThumbBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSliderThumbBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSliderTrackBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSliderTrackBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSliderTrackBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSliderTrackBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSpinnerBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSpinnerBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSplitPaneDividerBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSplitPaneDividerBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSplitPaneDividerForeground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSplitPaneDragDivider(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintSplitPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintSplitPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTabbedPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTabbedPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTabbedPaneTabAreaBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTabbedPaneTabAreaBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintTabbedPaneTabAreaBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTabbedPaneTabAreaBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintTabbedPaneTabBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintTabbedPaneTabBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint); overload; virtual;
    procedure paintTabbedPaneTabBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintTabbedPaneTabBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint); overload; virtual;
    procedure paintTabbedPaneContentBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTabbedPaneContentBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTableHeaderBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTableHeaderBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTableBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTableBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTextAreaBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTextAreaBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTextPaneBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTextPaneBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTextFieldBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTextFieldBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToggleButtonBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToggleButtonBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolBarBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolBarBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintToolBarBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolBarBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintToolBarContentBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolBarContentBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintToolBarContentBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolBarContentBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintToolBarDragWindowBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolBarDragWindowBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintToolBarDragWindowBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolBarDragWindowBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint); overload; virtual;
    procedure paintToolTipBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintToolTipBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTreeBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTreeBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTreeCellBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTreeCellBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintTreeCellFocus(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintViewportBackground(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
    procedure paintViewportBorder(para1: JSPSSynthContext; para2: JAGraphics; para3: jint; para4: jint; para5: jint; para6: jint); overload; virtual;
  end;

  JSPSSynthStyle = class abstract external 'javax.swing.plaf.synth' name 'SynthStyle' (JLObject)
  public
    constructor create(); overload;
    function getGraphicsUtils(para1: JSPSSynthContext): JSPSSynthGraphicsUtils; overload; virtual;
    function getColor(para1: JSPSSynthContext; para2: JSPSColorType): JAColor; overload; virtual;
  strict protected
    function getColorForState(para1: JSPSSynthContext; para2: JSPSColorType): JAColor; overload; virtual; abstract;
  public
    function getFont(para1: JSPSSynthContext): JAFont; overload; virtual;
  strict protected
    function getFontForState(para1: JSPSSynthContext): JAFont; overload; virtual; abstract;
  public
    function getInsets(para1: JSPSSynthContext; para2: JAInsets): JAInsets; overload; virtual;
    function getPainter(para1: JSPSSynthContext): JSPSSynthPainter; overload; virtual;
    function isOpaque(para1: JSPSSynthContext): jboolean; overload; virtual;
    function get(para1: JSPSSynthContext; para2: JLObject): JLObject; overload; virtual;
    procedure installDefaults(para1: JSPSSynthContext); overload; virtual;
    procedure uninstallDefaults(para1: JSPSSynthContext); overload; virtual;
    function getInt(para1: JSPSSynthContext; para2: JLObject; para3: jint): jint; overload; virtual;
    function getBoolean(para1: JSPSSynthContext; para2: JLObject; para3: jboolean): jboolean; overload; virtual;
    function getIcon(para1: JSPSSynthContext; para2: JLObject): JSIcon; overload; virtual;
    function getString(para1: JSPSSynthContext; para2: JLObject; para3: JLString): JLString; overload; virtual;
  end;

  JSPSSynthStyleFactory = class abstract external 'javax.swing.plaf.synth' name 'SynthStyleFactory' (JLObject)
  public
    constructor create(); overload;
    function getStyle(para1: JSJComponent; para2: JSPSRegion): JSPSSynthStyle; overload; virtual; abstract;
  end;

  JSTTableCellRenderer = interface external 'javax.swing.table' name 'TableCellRenderer' 
    function getTableCellRendererComponent(para1: JSJTable; para2: JLObject; para3: jboolean; para4: jboolean; para5: jint; para6: jint): JAComponent; overload;
  end;

  JSTTableColumnModel = interface external 'javax.swing.table' name 'TableColumnModel' 
    procedure addColumn(para1: JSTTableColumn); overload;
    procedure removeColumn(para1: JSTTableColumn); overload;
    procedure moveColumn(para1: jint; para2: jint); overload;
    procedure setColumnMargin(para1: jint); overload;
    function getColumnCount(): jint; overload;
    function getColumns(): JUEnumeration; overload;
    function getColumnIndex(para1: JLObject): jint; overload;
    function getColumn(para1: jint): JSTTableColumn; overload;
    function getColumnMargin(): jint; overload;
    function getColumnIndexAtX(para1: jint): jint; overload;
    function getTotalColumnWidth(): jint; overload;
    procedure setColumnSelectionAllowed(para1: jboolean); overload;
    function getColumnSelectionAllowed(): jboolean; overload;
    function getSelectedColumns(): Arr1jint; overload;
    function getSelectedColumnCount(): jint; overload;
    procedure setSelectionModel(para1: JSListSelectionModel); overload;
    function getSelectionModel(): JSListSelectionModel; overload;
    procedure addColumnModelListener(para1: JSETableColumnModelListener); overload;
    procedure removeColumnModelListener(para1: JSETableColumnModelListener); overload;
  end;

  JSTTableModel = interface external 'javax.swing.table' name 'TableModel' 
    function getRowCount(): jint; overload;
    function getColumnCount(): jint; overload;
    function getColumnName(para1: jint): JLString; overload;
    function getColumnClass(para1: jint): JLClass; overload;
    function isCellEditable(para1: jint; para2: jint): jboolean; overload;
    function getValueAt(para1: jint; para2: jint): JLObject; overload;
    procedure setValueAt(para1: JLObject; para2: jint; para3: jint); overload;
    procedure addTableModelListener(para1: JSETableModelListener); overload;
    procedure removeTableModelListener(para1: JSETableModelListener); overload;
  end;

  JSTTableStringConverter = class abstract external 'javax.swing.table' name 'TableStringConverter' (JLObject)
  public
    constructor create(); overload;
    function toString(para1: JSTTableModel; para2: jint; para3: jint): JLString; overload; virtual; abstract;
  end;

  JSTAbstractWriter = class abstract external 'javax.swing.text' name 'AbstractWriter' (JLObject)
  strict protected
    const
      NEWLINE = 10;
  strict protected
    constructor create(para1: JIWriter; para2: JSTDocument); overload;
    constructor create(para1: JIWriter; para2: JSTDocument; para3: jint; para4: jint); overload;
    constructor create(para1: JIWriter; para2: JSTElement); overload;
    constructor create(para1: JIWriter; para2: JSTElement; para3: jint; para4: jint); overload;
  public
    function getStartOffset(): jint; overload; virtual;
    function getEndOffset(): jint; overload; virtual;
  strict protected
    function getElementIterator(): JSTElementIterator; overload; virtual;
    function getWriter(): JIWriter; overload; virtual;
    function getDocument(): JSTDocument; overload; virtual;
    function inRange(para1: JSTElement): jboolean; overload; virtual;
    procedure write(); overload; virtual; abstract;  // throws java.io.IOException, javax.swing.text.BadLocationException
    function getText(para1: JSTElement): JLString; overload; virtual;  // throws javax.swing.text.BadLocationException
    procedure text(para1: JSTElement); overload; virtual;  // throws javax.swing.text.BadLocationException, java.io.IOException
    procedure setLineLength(para1: jint); overload; virtual;
    function getLineLength(): jint; overload; virtual;
    procedure setCurrentLineLength(para1: jint); overload; virtual;
    function getCurrentLineLength(): jint; overload; virtual;
    function isLineEmpty(): jboolean; overload; virtual;
    procedure setCanWrapLines(para1: jboolean); overload; virtual;
    function getCanWrapLines(): jboolean; overload; virtual;
    procedure setIndentSpace(para1: jint); overload; virtual;
    function getIndentSpace(): jint; overload; virtual;
  public
    procedure setLineSeparator(para1: JLString); overload; virtual;
    function getLineSeparator(): JLString; overload; virtual;
  strict protected
    procedure incrIndent(); overload; virtual;
    procedure decrIndent(); overload; virtual;
    function getIndentLevel(): jint; overload; virtual;
    procedure indent(); overload; virtual;  // throws java.io.IOException
    procedure write(para1: jchar); overload; virtual;  // throws java.io.IOException
    procedure write(para1: JLString); overload; virtual;  // throws java.io.IOException
    procedure writeLineSeparator(); overload; virtual;  // throws java.io.IOException
    procedure write(para1: Arr1jchar; para2: jint; para3: jint); overload; virtual;  // throws java.io.IOException
    procedure write(var para1: array of jchar; para2: jint; para3: jint); overload; virtual;  // throws java.io.IOException
    procedure writeAttributes(para1: JSTAttributeSet); overload; virtual;  // throws java.io.IOException
    procedure output(para1: Arr1jchar; para2: jint; para3: jint); overload; virtual;  // throws java.io.IOException
    procedure output(var para1: array of jchar; para2: jint; para3: jint); overload; virtual;  // throws java.io.IOException
  end;

  JSTAttributeSet = interface external 'javax.swing.text' name 'AttributeSet' 
    type
      InnerCharacterAttribute = interface;
      Arr1InnerCharacterAttribute = array of InnerCharacterAttribute;
      Arr2InnerCharacterAttribute = array of Arr1InnerCharacterAttribute;
      Arr3InnerCharacterAttribute = array of Arr2InnerCharacterAttribute;
      InnerColorAttribute = interface;
      Arr1InnerColorAttribute = array of InnerColorAttribute;
      Arr2InnerColorAttribute = array of Arr1InnerColorAttribute;
      Arr3InnerColorAttribute = array of Arr2InnerColorAttribute;
      InnerFontAttribute = interface;
      Arr1InnerFontAttribute = array of InnerFontAttribute;
      Arr2InnerFontAttribute = array of Arr1InnerFontAttribute;
      Arr3InnerFontAttribute = array of Arr2InnerFontAttribute;
      InnerParagraphAttribute = interface;
      Arr1InnerParagraphAttribute = array of InnerParagraphAttribute;
      Arr2InnerParagraphAttribute = array of Arr1InnerParagraphAttribute;
      Arr3InnerParagraphAttribute = array of Arr2InnerParagraphAttribute;
      InnerCharacterAttribute = interface external 'javax.swing.text' name 'CharacterAttribute' 
      end;

      InnerColorAttribute = interface external 'javax.swing.text' name 'ColorAttribute' 
      end;

      InnerFontAttribute = interface external 'javax.swing.text' name 'FontAttribute' 
      end;

      InnerParagraphAttribute = interface external 'javax.swing.text' name 'ParagraphAttribute' 
      end;

    final class var
      fNameAttribute: JLObject; external name 'NameAttribute';
      fResolveAttribute: JLObject; external name 'ResolveAttribute';
    function getAttributeCount(): jint; overload;
    function isDefined(para1: JLObject): jboolean; overload;
    function isEqual(para1: JSTAttributeSet): jboolean; overload;
    function copyAttributes(): JSTAttributeSet; overload;
    function getAttribute(para1: JLObject): JLObject; overload;
    function getAttributeNames(): JUEnumeration; overload;
    function containsAttribute(para1: JLObject; para2: JLObject): jboolean; overload;
    function containsAttributes(para1: JSTAttributeSet): jboolean; overload;
    function getResolveParent(): JSTAttributeSet; overload;
  end;

  JSTCaret = interface external 'javax.swing.text' name 'Caret' 
    procedure install(para1: JSTJTextComponent); overload;
    procedure deinstall(para1: JSTJTextComponent); overload;
    procedure paint(para1: JAGraphics); overload;
    procedure addChangeListener(para1: JSEChangeListener); overload;
    procedure removeChangeListener(para1: JSEChangeListener); overload;
    function isVisible(): jboolean; overload;
    procedure setVisible(para1: jboolean); overload;
    function isSelectionVisible(): jboolean; overload;
    procedure setSelectionVisible(para1: jboolean); overload;
    procedure setMagicCaretPosition(para1: JAPoint); overload;
    function getMagicCaretPosition(): JAPoint; overload;
    procedure setBlinkRate(para1: jint); overload;
    function getBlinkRate(): jint; overload;
    function getDot(): jint; overload;
    function getMark(): jint; overload;
    procedure setDot(para1: jint); overload;
    procedure moveDot(para1: jint); overload;
  end;

  JSTDocument = interface external 'javax.swing.text' name 'Document' 
    const
      StreamDescriptionProperty = 'stream';
      TitleProperty = 'title';
    function getLength(): jint; overload;
    procedure addDocumentListener(para1: JSEDocumentListener); overload;
    procedure removeDocumentListener(para1: JSEDocumentListener); overload;
    procedure addUndoableEditListener(para1: JSEUndoableEditListener); overload;
    procedure removeUndoableEditListener(para1: JSEUndoableEditListener); overload;
    function getProperty(para1: JLObject): JLObject; overload;
    procedure putProperty(para1: JLObject; para2: JLObject); overload;
    procedure remove(para1: jint; para2: jint); overload;  // throws javax.swing.text.BadLocationException
    procedure insertString(para1: jint; para2: JLString; para3: JSTAttributeSet); overload;  // throws javax.swing.text.BadLocationException
    function getText(para1: jint; para2: jint): JLString; overload;  // throws javax.swing.text.BadLocationException
    procedure getText(para1: jint; para2: jint; para3: JSTSegment); overload;  // throws javax.swing.text.BadLocationException
    function getStartPosition(): JSTPosition; overload;
    function getEndPosition(): JSTPosition; overload;
    function createPosition(para1: jint): JSTPosition; overload;  // throws javax.swing.text.BadLocationException
    function getRootElements(): Arr1JSTElement; overload;
    function getDefaultRootElement(): JSTElement; overload;
    procedure render(para1: JLRunnable); overload;
  end;

  JSTDocumentFilter = class external 'javax.swing.text' name 'DocumentFilter' (JLObject)
  public
    type
      InnerFilterBypass = class;
      Arr1InnerFilterBypass = array of InnerFilterBypass;
      Arr2InnerFilterBypass = array of Arr1InnerFilterBypass;
      Arr3InnerFilterBypass = array of Arr2InnerFilterBypass;
      InnerFilterBypass = class abstract external 'javax.swing.text' name 'FilterBypass' (JLObject)
      public
        constructor create(); overload;
        function getDocument(): JSTDocument; overload; virtual; abstract;
        procedure remove(para1: jint; para2: jint); overload; virtual; abstract;  // throws javax.swing.text.BadLocationException
        procedure insertString(para1: jint; para2: JLString; para3: JSTAttributeSet); overload; virtual; abstract;  // throws javax.swing.text.BadLocationException
        procedure replace(para1: jint; para2: jint; para3: JLString; para4: JSTAttributeSet); overload; virtual; abstract;  // throws javax.swing.text.BadLocationException
      end;

  public
    constructor create(); overload;
    procedure remove(para1: JSTDocumentFilter.InnerFilterBypass; para2: jint; para3: jint); overload; virtual;  // throws javax.swing.text.BadLocationException
    procedure insertString(para1: JSTDocumentFilter.InnerFilterBypass; para2: jint; para3: JLString; para4: JSTAttributeSet); overload; virtual;  // throws javax.swing.text.BadLocationException
    procedure replace(para1: JSTDocumentFilter.InnerFilterBypass; para2: jint; para3: jint; para4: JLString; para5: JSTAttributeSet); overload; virtual;  // throws javax.swing.text.BadLocationException
  end;

  JSTElement = interface external 'javax.swing.text' name 'Element' 
    function getDocument(): JSTDocument; overload;
    function getParentElement(): JSTElement; overload;
    function getName(): JLString; overload;
    function getAttributes(): JSTAttributeSet; overload;
    function getStartOffset(): jint; overload;
    function getEndOffset(): jint; overload;
    function getElementIndex(para1: jint): jint; overload;
    function getElementCount(): jint; overload;
    function getElement(para1: jint): JSTElement; overload;
    function isLeaf(): jboolean; overload;
  end;

  JSTHighlighter = interface external 'javax.swing.text' name 'Highlighter' 
    type
      InnerHighlightPainter = interface;
      Arr1InnerHighlightPainter = array of InnerHighlightPainter;
      Arr2InnerHighlightPainter = array of Arr1InnerHighlightPainter;
      Arr3InnerHighlightPainter = array of Arr2InnerHighlightPainter;
      InnerHighlight = interface;
      Arr1InnerHighlight = array of InnerHighlight;
      Arr2InnerHighlight = array of Arr1InnerHighlight;
      Arr3InnerHighlight = array of Arr2InnerHighlight;
      InnerHighlightPainter = interface external 'javax.swing.text' name 'HighlightPainter' 
        procedure paint(para1: JAGraphics; para2: jint; para3: jint; para4: JAShape; para5: JSTJTextComponent); overload;
      end;

      InnerHighlight = interface external 'javax.swing.text' name 'Highlight' 
        function getStartOffset(): jint; overload;
        function getEndOffset(): jint; overload;
        function getPainter(): JSTHighlighter.InnerHighlightPainter; overload;
      end;

    procedure install(para1: JSTJTextComponent); overload;
    procedure deinstall(para1: JSTJTextComponent); overload;
    procedure paint(para1: JAGraphics); overload;
    function addHighlight(para1: jint; para2: jint; para3: JSTHighlighter.InnerHighlightPainter): JLObject; overload;  // throws javax.swing.text.BadLocationException
    procedure removeHighlight(para1: JLObject); overload;
    procedure removeAllHighlights(); overload;
    procedure changeHighlight(para1: JLObject; para2: jint; para3: jint); overload;  // throws javax.swing.text.BadLocationException
    function getHighlights(): JSTHighlighter.Arr1InnerHighlight; overload;
  end;

  JSTKeymap = interface external 'javax.swing.text' name 'Keymap' 
    function getName(): JLString; overload;
    function getDefaultAction(): JSAction; overload;
    procedure setDefaultAction(para1: JSAction); overload;
    function getAction(para1: JSKeyStroke): JSAction; overload;
    function getBoundKeyStrokes(): Arr1JSKeyStroke; overload;
    function getBoundActions(): Arr1JSAction; overload;
    function getKeyStrokesForAction(para1: JSAction): Arr1JSKeyStroke; overload;
    function isLocallyDefined(para1: JSKeyStroke): jboolean; overload;
    procedure addActionForKeyStroke(para1: JSKeyStroke; para2: JSAction); overload;
    procedure removeKeyStrokeBinding(para1: JSKeyStroke); overload;
    procedure removeBindings(); overload;
    function getResolveParent(): JSTKeymap; overload;
    procedure setResolveParent(para1: JSTKeymap); overload;
  end;

  JSTLayoutQueue = class external 'javax.swing.text' name 'LayoutQueue' (JLObject)
  public
    type
      InnerLayoutThread = class;
      Arr1InnerLayoutThread = array of InnerLayoutThread;
      Arr2InnerLayoutThread = array of Arr1InnerLayoutThread;
      Arr3InnerLayoutThread = array of Arr2InnerLayoutThread;
      InnerLayoutThread = class external 'javax.swing.text' name 'LayoutThread' 
      end;

  public
    constructor create(); overload;
    class function getDefaultQueue(): JSTLayoutQueue; static; overload;
    class procedure setDefaultQueue(para1: JSTLayoutQueue); static; overload;
    procedure addTask(para1: JLRunnable); overload; virtual;
  strict protected
    function waitForWork(): JLRunnable; overload; virtual;
  end;

  JSTPosition = interface external 'javax.swing.text' name 'Position' 
    type
      InnerBias = class;
      Arr1InnerBias = array of InnerBias;
      Arr2InnerBias = array of Arr1InnerBias;
      Arr3InnerBias = array of Arr2InnerBias;
      InnerBias = class sealed external 'javax.swing.text' name 'Bias' (JLObject)
      public
        final class var
          fForward: JSTPosition.InnerBias; external name 'Forward';
          fBackward: JSTPosition.InnerBias; external name 'Backward';
      public
        function toString(): JLString; overload; virtual;
      end;

    function getOffset(): jint; overload;
  end;

  JSTSegmentCache = class external 'javax.swing.text' name 'SegmentCache' (JLObject)
  public
    type
      InnerCachedSegment = class;
      Arr1InnerCachedSegment = array of InnerCachedSegment;
      Arr2InnerCachedSegment = array of Arr1InnerCachedSegment;
      Arr3InnerCachedSegment = array of Arr2InnerCachedSegment;
      InnerCachedSegment = class external 'javax.swing.text' name 'CachedSegment' 
      end;

  public
    class function getSharedInstance(): JSTSegmentCache; static; overload;
    class function getSharedSegment(): JSTSegment; static; overload;
    class procedure releaseSharedSegment(para1: JSTSegment); static; overload;
    constructor create(); overload;
    function getSegment(): JSTSegment; overload; virtual;
    procedure releaseSegment(para1: JSTSegment); overload; virtual;
  end;

  JSTTabExpander = interface external 'javax.swing.text' name 'TabExpander' 
    function nextTabStop(para1: jfloat; para2: jint): jfloat; overload;
  end;

  JSTTabableView = interface external 'javax.swing.text' name 'TabableView' 
    function getTabbedSpan(para1: jfloat; para2: JSTTabExpander): jfloat; overload;
    function getPartialSpan(para1: jint; para2: jint): jfloat; overload;
  end;

  JSTUtilities = class external 'javax.swing.text' name 'Utilities' (JLObject)
  public
    constructor create(); overload;
    class function drawTabbedText(para1: JSTSegment; para2: jint; para3: jint; para4: JAGraphics; para5: JSTTabExpander; para6: jint): jint; static; overload; final;
    class function getTabbedTextWidth(para1: JSTSegment; para2: JAFontMetrics; para3: jint; para4: JSTTabExpander; para5: jint): jint; static; overload; final;
    class function getTabbedTextOffset(para1: JSTSegment; para2: JAFontMetrics; para3: jint; para4: jint; para5: JSTTabExpander; para6: jint): jint; static; overload; final;
    class function getTabbedTextOffset(para1: JSTSegment; para2: JAFontMetrics; para3: jint; para4: jint; para5: JSTTabExpander; para6: jint; para7: jboolean): jint; static; overload; final;
    class function getBreakLocation(para1: JSTSegment; para2: JAFontMetrics; para3: jint; para4: jint; para5: JSTTabExpander; para6: jint): jint; static; overload; final;
    class function getRowStart(para1: JSTJTextComponent; para2: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getRowEnd(para1: JSTJTextComponent; para2: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getPositionAbove(para1: JSTJTextComponent; para2: jint; para3: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getPositionBelow(para1: JSTJTextComponent; para2: jint; para3: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getWordStart(para1: JSTJTextComponent; para2: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getWordEnd(para1: JSTJTextComponent; para2: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getNextWord(para1: JSTJTextComponent; para2: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getPreviousWord(para1: JSTJTextComponent; para2: jint): jint; static; overload; final;  // throws javax.swing.text.BadLocationException
    class function getParagraphElement(para1: JSTJTextComponent; para2: jint): JSTElement; static; overload; final;
  end;

  JSTViewFactory = interface external 'javax.swing.text' name 'ViewFactory' 
    function create_(para1: JSTElement): JSTView; external name 'create'; overload;
  end;

  JSTHCSSParser = class external 'javax.swing.text.html' name 'CSSParser' (JLObject)
  public
    type
      InnerCSSParserCallback = interface;
      Arr1InnerCSSParserCallback = array of InnerCSSParserCallback;
      Arr2InnerCSSParserCallback = array of Arr1InnerCSSParserCallback;
      Arr3InnerCSSParserCallback = array of Arr2InnerCSSParserCallback;
      InnerCSSParserCallback = interface external 'javax.swing.text.html' name 'CSSParserCallback' 
      end;

  end;

  JSTHPContentModelState = class external 'javax.swing.text.html.parser' name 'ContentModelState' (JLObject)
  public
    constructor create(para1: JSTHPContentModel); overload;
    function getModel(): JSTHPContentModel; overload; virtual;
    function terminate(): jboolean; overload; virtual;
    function first(): JSTHPElement; overload; virtual;
    function advance(para1: JLObject): JSTHPContentModelState; overload; virtual;
  end;

  JSTHPDTDConstants = interface external 'javax.swing.text.html.parser' name 'DTDConstants' 
    const
      CDATA = 1;
      ENTITY = 2;
      ENTITIES = 3;
      ID = 4;
      IDREF = 5;
      IDREFS = 6;
      NAME = 7;
      NAMES = 8;
      NMTOKEN = 9;
      NMTOKENS = 10;
      NOTATION = 11;
      NUMBER = 12;
      NUMBERS = 13;
      NUTOKEN = 14;
      NUTOKENS = 15;
      RCDATA = 16;
      EMPTY = 17;
      MODEL = 18;
      ANY = 19;
      FIXED = 1;
      REQUIRED = 2;
      CURRENT = 3;
      CONREF = 4;
      IMPLIED = 5;
      &PUBLIC = 10;
      SDATA = 11;
      PI = 12;
      STARTTAG = 13;
      ENDTAG = 14;
      MS = 15;
      MD = 16;
      SYSTEM = 17;
      GENERAL = 65536;
      DEFAULT = 131072;
      PARAMETER = 262144;
  end;

  JSTRConstants = class external 'javax.swing.text.rtf' name 'Constants' (JLObject)
  end;

  JSTRRTFAttribute = interface external 'javax.swing.text.rtf' name 'RTFAttribute' 
    const
      D_CHARACTER = 0;
      D_PARAGRAPH = 1;
      D_SECTION = 2;
      D_DOCUMENT = 3;
      D_META = 4;
    function domain(): jint; overload;
    function swingName(): JLObject; overload;
    function rtfName(): JLString; overload;
    function &set(para1: JSTMutableAttributeSet): jboolean; overload;
    function &set(para1: JSTMutableAttributeSet; para2: jint): jboolean; overload;
    function setDefault(para1: JSTMutableAttributeSet): jboolean; overload;
    function write(para1: JSTAttributeSet; para2: JSTRRTFGenerator; para3: jboolean): jboolean; overload;  // throws java.io.IOException
    function writeValue(para1: JLObject; para2: JSTRRTFGenerator; para3: jboolean): jboolean; overload;  // throws java.io.IOException
  end;

  JSTRRTFAttributes = class external 'javax.swing.text.rtf' name 'RTFAttributes' (JLObject)
  public
    type
      InnerAssertiveAttribute = class;
      Arr1InnerAssertiveAttribute = array of InnerAssertiveAttribute;
      Arr2InnerAssertiveAttribute = array of Arr1InnerAssertiveAttribute;
      Arr3InnerAssertiveAttribute = array of Arr2InnerAssertiveAttribute;
      InnerBooleanAttribute = class;
      Arr1InnerBooleanAttribute = array of InnerBooleanAttribute;
      Arr2InnerBooleanAttribute = array of Arr1InnerBooleanAttribute;
      Arr3InnerBooleanAttribute = array of Arr2InnerBooleanAttribute;
      InnerNumericAttribute = class;
      Arr1InnerNumericAttribute = array of InnerNumericAttribute;
      Arr2InnerNumericAttribute = array of Arr1InnerNumericAttribute;
      Arr3InnerNumericAttribute = array of Arr2InnerNumericAttribute;
      InnerGenericAttribute = class;
      Arr1InnerGenericAttribute = array of InnerGenericAttribute;
      Arr2InnerGenericAttribute = array of Arr1InnerGenericAttribute;
      Arr3InnerGenericAttribute = array of Arr2InnerGenericAttribute;
      InnerAssertiveAttribute = class external 'javax.swing.text.rtf' name 'AssertiveAttribute' 
      end;

      InnerBooleanAttribute = class external 'javax.swing.text.rtf' name 'BooleanAttribute' 
      end;

      InnerNumericAttribute = class external 'javax.swing.text.rtf' name 'NumericAttribute' 
      end;

      InnerGenericAttribute = class abstract external 'javax.swing.text.rtf' name 'GenericAttribute' 
      end;

  end;

  JSTRRTFGenerator = class external 'javax.swing.text.rtf' name 'RTFGenerator' (JLObject)
  public
    type
      InnerCharacterKeywordPair = class;
      Arr1InnerCharacterKeywordPair = array of InnerCharacterKeywordPair;
      Arr2InnerCharacterKeywordPair = array of Arr1InnerCharacterKeywordPair;
      Arr3InnerCharacterKeywordPair = array of Arr2InnerCharacterKeywordPair;
      InnerCharacterKeywordPair = class external 'javax.swing.text.rtf' name 'CharacterKeywordPair' 
      end;

  public
    final class var
      fdefaultRTFColor: JAColor; external name 'defaultRTFColor';
  public
    const
      defaultFontSize = jfloat(12.0);
      defaultFontFamily = 'Helvetica';
  strict protected
    class var
      fOne: JLInteger; external name 'One';
      fZero: JLInteger; external name 'Zero';
      fFalse: JLBoolean; external name 'False';
      fZeroPointZero: JLFloat; external name 'ZeroPointZero';
      ftextKeywords: JSTRRTFGenerator.Arr1InnerCharacterKeywordPair; external name 'textKeywords';
  public
    class procedure writeDocument(para1: JSTDocument; para2: JIOutputStream); static; overload;  // throws java.io.IOException
    constructor create(para1: JIOutputStream); overload;
    procedure examineElement(para1: JSTElement); overload; virtual;
    procedure writeLineBreak(); overload; virtual;  // throws java.io.IOException
    procedure writeRTFHeader(); overload; virtual;  // throws java.io.IOException
    procedure writeRTFTrailer(); overload; virtual;  // throws java.io.IOException
  strict protected
    procedure checkNumericControlWord(para1: JSTMutableAttributeSet; para2: JSTAttributeSet; para3: JLObject; para4: JLString; para5: jfloat; para6: jfloat); overload; virtual;  // throws java.io.IOException
    procedure checkControlWord(para1: JSTMutableAttributeSet; para2: JSTAttributeSet; para3: JSTRRTFAttribute); overload; virtual;  // throws java.io.IOException
    procedure checkControlWords(para1: JSTMutableAttributeSet; para2: JSTAttributeSet; para3: Arr1JSTRRTFAttribute; para4: jint); overload; virtual;  // throws java.io.IOException
    procedure checkControlWords(para1: JSTMutableAttributeSet; para2: JSTAttributeSet; var para3: array of JSTRRTFAttribute; para4: jint); overload; virtual;  // throws java.io.IOException
    procedure resetSectionAttributes(para1: JSTMutableAttributeSet); overload; virtual;  // throws java.io.IOException
  public
    procedure writeParagraphElement(para1: JSTElement); overload; virtual;  // throws java.io.IOException
  strict protected
    procedure resetParagraphAttributes(para1: JSTMutableAttributeSet); overload; virtual;  // throws java.io.IOException
    procedure resetCharacterAttributes(para1: JSTMutableAttributeSet); overload; virtual;  // throws java.io.IOException
  public
    procedure writeTextElement(para1: JSTElement); overload; virtual;  // throws java.io.IOException
    procedure writeText(para1: JSTSegment); overload; virtual;  // throws java.io.IOException
    procedure writeText(para1: JLString); overload; virtual;  // throws java.io.IOException
    procedure writeRawString(para1: JLString); overload; virtual;  // throws java.io.IOException
    procedure writeControlWord(para1: JLString); overload; virtual;  // throws java.io.IOException
    procedure writeControlWord(para1: JLString; para2: jint); overload; virtual;  // throws java.io.IOException
    procedure writeBegingroup(); overload; virtual;  // throws java.io.IOException
    procedure writeEndgroup(); overload; virtual;  // throws java.io.IOException
    procedure writeCharacter(para1: jchar); overload; virtual;  // throws java.io.IOException
  strict protected
    class function convertCharacter(para1: Arr1jint; para2: jchar): jint; static; overload;
    class function convertCharacter(var para1: array of jint; para2: jchar): jint; static; overload;
  end;

  JSTPathPlaceHolder = class external 'javax.swing.tree' name 'PathPlaceHolder' (JLObject)
  strict protected
    var
      fisNew: jboolean; external name 'isNew';
      fpath: JSTTreePath; external name 'path';
  end;

  JSTRowMapper = interface external 'javax.swing.tree' name 'RowMapper' 
    function getRowsForPaths(para1: Arr1JSTTreePath): Arr1jint; overload;
    function getRowsForPaths(var para1: array of JSTTreePath): Arr1jint; overload;
  end;

  JSTTreeCellRenderer = interface external 'javax.swing.tree' name 'TreeCellRenderer' 
    function getTreeCellRendererComponent(para1: JSJTree; para2: JLObject; para3: jboolean; para4: jboolean; para5: jboolean; para6: jint; para7: jboolean): JAComponent; overload;
  end;

  JSTTreeModel = interface external 'javax.swing.tree' name 'TreeModel' 
    function getRoot(): JLObject; overload;
    function getChild(para1: JLObject; para2: jint): JLObject; overload;
    function getChildCount(para1: JLObject): jint; overload;
    function isLeaf(para1: JLObject): jboolean; overload;
    procedure valueForPathChanged(para1: JSTTreePath; para2: JLObject); overload;
    function getIndexOfChild(para1: JLObject; para2: JLObject): jint; overload;
    procedure addTreeModelListener(para1: JSETreeModelListener); overload;
    procedure removeTreeModelListener(para1: JSETreeModelListener); overload;
  end;

  JSTTreeNode = interface external 'javax.swing.tree' name 'TreeNode' 
    function getChildAt(para1: jint): JSTTreeNode; overload;
    function getChildCount(): jint; overload;
    function getParent(): JSTTreeNode; overload;
    function getIndex(para1: JSTTreeNode): jint; overload;
    function getAllowsChildren(): jboolean; overload;
    function isLeaf(): jboolean; overload;
    function children(): JUEnumeration; overload;
  end;

  JSTTreeSelectionModel = interface external 'javax.swing.tree' name 'TreeSelectionModel' 
    const
      SINGLE_TREE_SELECTION = 1;
      CONTIGUOUS_TREE_SELECTION = 2;
      DISCONTIGUOUS_TREE_SELECTION = 4;
    procedure setSelectionMode(para1: jint); overload;
    function getSelectionMode(): jint; overload;
    procedure setSelectionPath(para1: JSTTreePath); overload;
    procedure setSelectionPaths(para1: Arr1JSTTreePath); overload;
    procedure setSelectionPaths(var para1: array of JSTTreePath); overload;
    procedure addSelectionPath(para1: JSTTreePath); overload;
    procedure addSelectionPaths(para1: Arr1JSTTreePath); overload;
    procedure addSelectionPaths(var para1: array of JSTTreePath); overload;
    procedure removeSelectionPath(para1: JSTTreePath); overload;
    procedure removeSelectionPaths(para1: Arr1JSTTreePath); overload;
    procedure removeSelectionPaths(var para1: array of JSTTreePath); overload;
    function getSelectionPath(): JSTTreePath; overload;
    function getSelectionPaths(): Arr1JSTTreePath; overload;
    function getSelectionCount(): jint; overload;
    function isPathSelected(para1: JSTTreePath): jboolean; overload;
    function isSelectionEmpty(): jboolean; overload;
    procedure clearSelection(); overload;
    procedure setRowMapper(para1: JSTRowMapper); overload;
    function getRowMapper(): JSTRowMapper; overload;
    function getSelectionRows(): Arr1jint; overload;
    function getMinSelectionRow(): jint; overload;
    function getMaxSelectionRow(): jint; overload;
    function isRowSelected(para1: jint): jboolean; overload;
    procedure resetRowSelection(); overload;
    function getLeadSelectionRow(): jint; overload;
    function getLeadSelectionPath(): JSTTreePath; overload;
    procedure addPropertyChangeListener(para1: JBPropertyChangeListener); overload;
    procedure removePropertyChangeListener(para1: JBPropertyChangeListener); overload;
    procedure addTreeSelectionListener(para1: JSETreeSelectionListener); overload;
    procedure removeTreeSelectionListener(para1: JSETreeSelectionListener); overload;
  end;

  JSUStateEditable = interface external 'javax.swing.undo' name 'StateEditable' 
    const
      RCSID = '$Id: StateEditable.java,v 1.2 1997/09/08 19:39:08 marklin Exp $';
    procedure storeState(para1: JUHashtable); overload;
    procedure restoreState(para1: JUHashtable); overload;
  end;

  JSUUndoableEdit = interface external 'javax.swing.undo' name 'UndoableEdit' 
    procedure undo(); overload;  // throws javax.swing.undo.CannotUndoException
    function canUndo(): jboolean; overload;
    procedure redo(); overload;  // throws javax.swing.undo.CannotRedoException
    function canRedo(): jboolean; overload;
    procedure die(); overload;
    function addEdit(para1: JSUUndoableEdit): jboolean; overload;
    function replaceEdit(para1: JSUUndoableEdit): jboolean; overload;
    function isSignificant(): jboolean; overload;
    function getPresentationName(): JLString; overload;
    function getUndoPresentationName(): JLString; overload;
    function getRedoPresentationName(): JLString; overload;
  end;

  JSUUndoableEditSupport = class external 'javax.swing.undo' name 'UndoableEditSupport' (JLObject)
  strict protected
    var
      fupdateLevel: jint; external name 'updateLevel';
      fcompoundEdit: JSUCompoundEdit; external name 'compoundEdit';
      flisteners: JUVector; external name 'listeners';
      frealSource: JLObject; external name 'realSource';
  public
    constructor create(); overload;
    constructor create(para1: JLObject); overload;
    procedure addUndoableEditListener(para1: JSEUndoableEditListener); overload; virtual;
    procedure removeUndoableEditListener(para1: JSEUndoableEditListener); overload; virtual;
    function getUndoableEditListeners(): Arr1JSEUndoableEditListener; overload; virtual;
  strict protected
    procedure _postEdit(para1: JSUUndoableEdit); overload; virtual;
  public
    procedure postEdit(para1: JSUUndoableEdit); overload; virtual;
    function getUpdateLevel(): jint; overload; virtual;
    procedure beginUpdate(); overload; virtual;
  strict protected
    function createCompoundEdit(): JSUCompoundEdit; overload; virtual;
  public
    procedure endUpdate(); overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JTDiagnosticListener = interface external 'javax.tools' name 'DiagnosticListener' 
    procedure report(para1: JTDiagnostic); overload;
  end;

  JTFileObject = interface external 'javax.tools' name 'FileObject' 
    function toUri(): JNURI; overload;
    function getName(): JLString; overload;
    function openInputStream(): JIInputStream; overload;  // throws java.io.IOException
    function openOutputStream(): JIOutputStream; overload;  // throws java.io.IOException
    function openReader(para1: jboolean): JIReader; overload;  // throws java.io.IOException
    function getCharContent(para1: jboolean): JLCharSequence; overload;  // throws java.io.IOException
    function openWriter(): JIWriter; overload;  // throws java.io.IOException
    function getLastModified(): jlong; overload;
    function delete(): jboolean; overload;
  end;

  JTOptionChecker = interface external 'javax.tools' name 'OptionChecker' 
    function isSupportedOption(para1: JLString): jint; overload;
  end;

  JTTool = interface external 'javax.tools' name 'Tool' 
    function run(para1: JIInputStream; para2: JIOutputStream; para3: JIOutputStream; para4: Arr1JLString): jint; overload;
    function run(para1: JIInputStream; para2: JIOutputStream; para3: JIOutputStream; const para4: array of JLString): jint; overload;
    function getSourceVersions(): JUSet; overload;
  end;

  JTToolProvider = class external 'javax.tools' name 'ToolProvider' (JLObject)
  public
    type
      InnerLazy = class;
      Arr1InnerLazy = array of InnerLazy;
      Arr2InnerLazy = array of Arr1InnerLazy;
      Arr3InnerLazy = array of Arr2InnerLazy;
      InnerLazy = class external 'javax.tools' name 'Lazy' 
      end;

  public
    class function getSystemJavaCompiler(): JTJavaCompiler; static; overload;
    class function getSystemToolClassLoader(): JLClassLoader; static; overload;
  end;

  JTXXAResource = interface external 'javax.transaction.xa' name 'XAResource' 
    const
      TMENDRSCAN = 8388608;
      TMFAIL = 536870912;
      TMJOIN = 2097152;
      TMNOFLAGS = 0;
      TMONEPHASE = 1073741824;
      TMRESUME = 134217728;
      TMSTARTRSCAN = 16777216;
      TMSUCCESS = 67108864;
      TMSUSPEND = 33554432;
      XA_RDONLY = 3;
      XA_OK = 0;
    procedure commit(para1: JTXXid; para2: jboolean); overload;  // throws javax.transaction.xa.XAException
    procedure &end(para1: JTXXid; para2: jint); overload;  // throws javax.transaction.xa.XAException
    procedure forget(para1: JTXXid); overload;  // throws javax.transaction.xa.XAException
    function getTransactionTimeout(): jint; overload;  // throws javax.transaction.xa.XAException
    function isSameRM(para1: JTXXAResource): jboolean; overload;  // throws javax.transaction.xa.XAException
    function prepare(para1: JTXXid): jint; overload;  // throws javax.transaction.xa.XAException
    function recover(para1: jint): Arr1JTXXid; overload;  // throws javax.transaction.xa.XAException
    procedure rollback(para1: JTXXid); overload;  // throws javax.transaction.xa.XAException
    function setTransactionTimeout(para1: jint): jboolean; overload;  // throws javax.transaction.xa.XAException
    procedure start(para1: JTXXid; para2: jint); overload;  // throws javax.transaction.xa.XAException
  end;

  JTXXid = interface external 'javax.transaction.xa' name 'Xid' 
    const
      MAXGTRIDSIZE = 64;
      MAXBQUALSIZE = 64;
    function getFormatId(): jint; overload;
    function getGlobalTransactionId(): Arr1jbyte; overload;
    function getBranchQualifier(): Arr1jbyte; overload;
  end;

  JXXMLConstants = class sealed external 'javax.xml' name 'XMLConstants' (JLObject)
  public
    const
      NULL_NS_URI = '';
      DEFAULT_NS_PREFIX = '';
      XML_NS_URI = 'http://www.w3.org/XML/1998/namespace';
      XML_NS_PREFIX = 'xml';
      XMLNS_ATTRIBUTE_NS_URI = 'http://www.w3.org/2000/xmlns/';
      XMLNS_ATTRIBUTE = 'xmlns';
      W3C_XML_SCHEMA_NS_URI = 'http://www.w3.org/2001/XMLSchema';
      W3C_XML_SCHEMA_INSTANCE_NS_URI = 'http://www.w3.org/2001/XMLSchema-instance';
      W3C_XPATH_DATATYPE_NS_URI = 'http://www.w3.org/2003/11/xpath-datatypes';
      XML_DTD_NS_URI = 'http://www.w3.org/TR/REC-xml';
      RELAXNG_NS_URI = 'http://relaxng.org/ns/structure/1.0';
      FEATURE_SECURE_PROCESSING = 'http://javax.xml.XMLConstants/feature/secure-processing';
  end;

  JXBBinder = class abstract external 'javax.xml.bind' name 'Binder' (JLObject)
  public
    constructor create(); overload;
    function unmarshal(para1: JLObject): JLObject; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JLObject; para2: JLClass): JXBJAXBElement; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: JLObject); overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function getXMLNode(para1: JLObject): JLObject; overload; virtual; abstract;
    function getJAXBNode(para1: JLObject): JLObject; overload; virtual; abstract;
    function updateXML(para1: JLObject): JLObject; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function updateXML(para1: JLObject; para2: JLObject): JLObject; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function updateJAXB(para1: JLObject): JLObject; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    procedure setSchema(para1: JXVSchema); overload; virtual; abstract;
    function getSchema(): JXVSchema; overload; virtual; abstract;
    procedure setEventHandler(para1: JXBValidationEventHandler); overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function getEventHandler(): JXBValidationEventHandler; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    procedure setProperty(para1: JLString; para2: JLObject); overload; virtual; abstract;  // throws javax.xml.bind.PropertyException
    function getProperty(para1: JLString): JLObject; overload; virtual; abstract;  // throws javax.xml.bind.PropertyException
  end;

  JXBContextFinder = class external 'javax.xml.bind' name 'ContextFinder' (JLObject)
  end;

  JXBDatatypeConverter = class sealed external 'javax.xml.bind' name 'DatatypeConverter' (JLObject)
  public
    class procedure setDatatypeConverter(para1: JXBDatatypeConverterInterface); static; overload;
    class function parseString(para1: JLString): JLString; static; overload;
    class function parseInteger(para1: JLString): JMBigInteger; static; overload;
    class function parseInt(para1: JLString): jint; static; overload;
    class function parseLong(para1: JLString): jlong; static; overload;
    class function parseShort(para1: JLString): jshort; static; overload;
    class function parseDecimal(para1: JLString): JMBigDecimal; static; overload;
    class function parseFloat(para1: JLString): jfloat; static; overload;
    class function parseDouble(para1: JLString): jdouble; static; overload;
    class function parseBoolean(para1: JLString): jboolean; static; overload;
    class function parseByte(para1: JLString): jbyte; static; overload;
    class function parseQName(para1: JLString; para2: JXNNamespaceContext): JXNQName; static; overload;
    class function parseDateTime(para1: JLString): JUCalendar; static; overload;
    class function parseBase64Binary(para1: JLString): Arr1jbyte; static; overload;
    class function parseHexBinary(para1: JLString): Arr1jbyte; static; overload;
    class function parseUnsignedInt(para1: JLString): jlong; static; overload;
    class function parseUnsignedShort(para1: JLString): jint; static; overload;
    class function parseTime(para1: JLString): JUCalendar; static; overload;
    class function parseDate(para1: JLString): JUCalendar; static; overload;
    class function parseAnySimpleType(para1: JLString): JLString; static; overload;
    class function printString(para1: JLString): JLString; static; overload;
    class function printInteger(para1: JMBigInteger): JLString; static; overload;
    class function printInt(para1: jint): JLString; static; overload;
    class function printLong(para1: jlong): JLString; static; overload;
    class function printShort(para1: jshort): JLString; static; overload;
    class function printDecimal(para1: JMBigDecimal): JLString; static; overload;
    class function printFloat(para1: jfloat): JLString; static; overload;
    class function printDouble(para1: jdouble): JLString; static; overload;
    class function printBoolean(para1: jboolean): JLString; static; overload;
    class function printByte(para1: jbyte): JLString; static; overload;
    class function printQName(para1: JXNQName; para2: JXNNamespaceContext): JLString; static; overload;
    class function printDateTime(para1: JUCalendar): JLString; static; overload;
    class function printBase64Binary(para1: Arr1jbyte): JLString; static; overload;
    class function printBase64Binary(var para1: array of jbyte): JLString; static; overload;
    class function printHexBinary(para1: Arr1jbyte): JLString; static; overload;
    class function printHexBinary(var para1: array of jbyte): JLString; static; overload;
    class function printUnsignedInt(para1: jlong): JLString; static; overload;
    class function printUnsignedShort(para1: jint): JLString; static; overload;
    class function printTime(para1: JUCalendar): JLString; static; overload;
    class function printDate(para1: JUCalendar): JLString; static; overload;
    class function printAnySimpleType(para1: JLString): JLString; static; overload;
  end;

  JXBDatatypeConverterInterface = interface external 'javax.xml.bind' name 'DatatypeConverterInterface' 
    function parseString(para1: JLString): JLString; overload;
    function parseInteger(para1: JLString): JMBigInteger; overload;
    function parseInt(para1: JLString): jint; overload;
    function parseLong(para1: JLString): jlong; overload;
    function parseShort(para1: JLString): jshort; overload;
    function parseDecimal(para1: JLString): JMBigDecimal; overload;
    function parseFloat(para1: JLString): jfloat; overload;
    function parseDouble(para1: JLString): jdouble; overload;
    function parseBoolean(para1: JLString): jboolean; overload;
    function parseByte(para1: JLString): jbyte; overload;
    function parseQName(para1: JLString; para2: JXNNamespaceContext): JXNQName; overload;
    function parseDateTime(para1: JLString): JUCalendar; overload;
    function parseBase64Binary(para1: JLString): Arr1jbyte; overload;
    function parseHexBinary(para1: JLString): Arr1jbyte; overload;
    function parseUnsignedInt(para1: JLString): jlong; overload;
    function parseUnsignedShort(para1: JLString): jint; overload;
    function parseTime(para1: JLString): JUCalendar; overload;
    function parseDate(para1: JLString): JUCalendar; overload;
    function parseAnySimpleType(para1: JLString): JLString; overload;
    function printString(para1: JLString): JLString; overload;
    function printInteger(para1: JMBigInteger): JLString; overload;
    function printInt(para1: jint): JLString; overload;
    function printLong(para1: jlong): JLString; overload;
    function printShort(para1: jshort): JLString; overload;
    function printDecimal(para1: JMBigDecimal): JLString; overload;
    function printFloat(para1: jfloat): JLString; overload;
    function printDouble(para1: jdouble): JLString; overload;
    function printBoolean(para1: jboolean): JLString; overload;
    function printByte(para1: jbyte): JLString; overload;
    function printQName(para1: JXNQName; para2: JXNNamespaceContext): JLString; overload;
    function printDateTime(para1: JUCalendar): JLString; overload;
    function printBase64Binary(para1: Arr1jbyte): JLString; overload;
    function printBase64Binary(var para1: array of jbyte): JLString; overload;
    function printHexBinary(para1: Arr1jbyte): JLString; overload;
    function printHexBinary(var para1: array of jbyte): JLString; overload;
    function printUnsignedInt(para1: jlong): JLString; overload;
    function printUnsignedShort(para1: jint): JLString; overload;
    function printTime(para1: JUCalendar): JLString; overload;
    function printDate(para1: JUCalendar): JLString; overload;
    function printAnySimpleType(para1: JLString): JLString; overload;
  end;

  JXBElement = interface external 'javax.xml.bind' name 'Element' 
  end;

  JXBJAXB = class sealed external 'javax.xml.bind' name 'JAXB' (JLObject)
  public
    type
      InnerCache = class;
      Arr1InnerCache = array of InnerCache;
      Arr2InnerCache = array of Arr1InnerCache;
      Arr3InnerCache = array of Arr2InnerCache;
      InnerCache = class sealed external 'javax.xml.bind' name 'Cache' 
      end;

  public
    class function unmarshal(para1: JIFile; para2: JLClass): JLObject; static; overload;
    class function unmarshal(para1: JNURL; para2: JLClass): JLObject; static; overload;
    class function unmarshal(para1: JNURI; para2: JLClass): JLObject; static; overload;
    class function unmarshal(para1: JLString; para2: JLClass): JLObject; static; overload;
    class function unmarshal(para1: JIInputStream; para2: JLClass): JLObject; static; overload;
    class function unmarshal(para1: JIReader; para2: JLClass): JLObject; static; overload;
    class function unmarshal(para1: JXTSource; para2: JLClass): JLObject; static; overload;
    class procedure marshal(para1: JLObject; para2: JIFile); static; overload;
    class procedure marshal(para1: JLObject; para2: JNURL); static; overload;
    class procedure marshal(para1: JLObject; para2: JNURI); static; overload;
    class procedure marshal(para1: JLObject; para2: JLString); static; overload;
    class procedure marshal(para1: JLObject; para2: JIOutputStream); static; overload;
    class procedure marshal(para1: JLObject; para2: JIWriter); static; overload;
    class procedure marshal(para1: JLObject; para2: JXTResult); static; overload;
  end;

  JXBJAXBContext = class abstract external 'javax.xml.bind' name 'JAXBContext' (JLObject)
  public
    const
      JAXB_CONTEXT_FACTORY = 'javax.xml.bind.context.factory';
  strict protected
    constructor create(); overload;
  public
    class function newInstance(para1: JLString): JXBJAXBContext; static; overload;  // throws javax.xml.bind.JAXBException
    class function newInstance(para1: JLString; para2: JLClassLoader): JXBJAXBContext; static; overload;  // throws javax.xml.bind.JAXBException
    class function newInstance(para1: JLString; para2: JLClassLoader; para3: JUMap): JXBJAXBContext; static; overload;  // throws javax.xml.bind.JAXBException
    class function newInstance(para1: Arr1JLClass): JXBJAXBContext; static; overload;  // throws javax.xml.bind.JAXBException
    class function newInstance(const para1: array of JLClass): JXBJAXBContext; static; overload;  // throws javax.xml.bind.JAXBException
    class function newInstance(para1: Arr1JLClass; para2: JUMap): JXBJAXBContext; static; overload;  // throws javax.xml.bind.JAXBException
    class function newInstance(var para1: array of JLClass; para2: JUMap): JXBJAXBContext; static; overload;  // throws javax.xml.bind.JAXBException
    function createUnmarshaller(): JXBUnmarshaller; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function createMarshaller(): JXBMarshaller; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function createValidator(): JXBValidator; overload; virtual; abstract;  // throws javax.xml.bind.JAXBException
    function createBinder(para1: JLClass): JXBBinder; overload; virtual;
    function createBinder(): JXBBinder; overload; virtual;
    function createJAXBIntrospector(): JXBJAXBIntrospector; overload; virtual;
    procedure generateSchema(para1: JXBSchemaOutputResolver); overload; virtual;  // throws java.io.IOException
  end;

  JXBJAXBIntrospector = class abstract external 'javax.xml.bind' name 'JAXBIntrospector' (JLObject)
  public
    constructor create(); overload;
    function isElement(para1: JLObject): jboolean; overload; virtual; abstract;
    function getElementName(para1: JLObject): JXNQName; overload; virtual; abstract;
    class function getValue(para1: JLObject): JLObject; static; overload;
  end;

  JXBMarshaller = interface external 'javax.xml.bind' name 'Marshaller' 
    type
      InnerListener = class;
      Arr1InnerListener = array of InnerListener;
      Arr2InnerListener = array of Arr1InnerListener;
      Arr3InnerListener = array of Arr2InnerListener;
      InnerListener = class abstract external 'javax.xml.bind' name 'Listener' (JLObject)
      public
        constructor create(); overload;
        procedure beforeMarshal(para1: JLObject); overload; virtual;
        procedure afterMarshal(para1: JLObject); overload; virtual;
      end;

    const
      JAXB_ENCODING = 'jaxb.encoding';
      JAXB_FORMATTED_OUTPUT = 'jaxb.formatted.output';
      JAXB_SCHEMA_LOCATION = 'jaxb.schemaLocation';
      JAXB_NO_NAMESPACE_SCHEMA_LOCATION = 'jaxb.noNamespaceSchemaLocation';
      JAXB_FRAGMENT = 'jaxb.fragment';
    procedure marshal(para1: JLObject; para2: JXTResult); overload;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: JIOutputStream); overload;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: JIFile); overload;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: JIWriter); overload;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: OXSContentHandler); overload;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: OWDNode); overload;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: JXSXMLStreamWriter); overload;  // throws javax.xml.bind.JAXBException
    procedure marshal(para1: JLObject; para2: JXSXMLEventWriter); overload;  // throws javax.xml.bind.JAXBException
    function getNode(para1: JLObject): OWDNode; overload;  // throws javax.xml.bind.JAXBException
    procedure setProperty(para1: JLString; para2: JLObject); overload;  // throws javax.xml.bind.PropertyException
    function getProperty(para1: JLString): JLObject; overload;  // throws javax.xml.bind.PropertyException
    procedure setEventHandler(para1: JXBValidationEventHandler); overload;  // throws javax.xml.bind.JAXBException
    function getEventHandler(): JXBValidationEventHandler; overload;  // throws javax.xml.bind.JAXBException
    procedure setAdapter(para1: JXBAAXmlAdapter); overload;
    procedure setAdapter(para1: JLClass; para2: JXBAAXmlAdapter); overload;
    function getAdapter(para1: JLClass): JXBAAXmlAdapter; overload;
    procedure setAttachmentMarshaller(para1: JXBAAttachmentMarshaller); overload;
    function getAttachmentMarshaller(): JXBAAttachmentMarshaller; overload;
    procedure setSchema(para1: JXVSchema); overload;
    function getSchema(): JXVSchema; overload;
    procedure setListener(para1: JXBMarshaller.InnerListener); overload;
    function getListener(): JXBMarshaller.InnerListener; overload;
  end;

  JXBMessages = class external 'javax.xml.bind' name 'Messages' (JLObject)
  end;

  JXBSchemaOutputResolver = class abstract external 'javax.xml.bind' name 'SchemaOutputResolver' (JLObject)
  public
    constructor create(); overload;
    function createOutput(para1: JLString; para2: JLString): JXTResult; overload; virtual; abstract;  // throws java.io.IOException
  end;

  JXBUnmarshaller = interface external 'javax.xml.bind' name 'Unmarshaller' 
    type
      InnerListener = class;
      Arr1InnerListener = array of InnerListener;
      Arr2InnerListener = array of Arr1InnerListener;
      Arr3InnerListener = array of Arr2InnerListener;
      InnerListener = class abstract external 'javax.xml.bind' name 'Listener' (JLObject)
      public
        constructor create(); overload;
        procedure beforeUnmarshal(para1: JLObject; para2: JLObject); overload; virtual;
        procedure afterUnmarshal(para1: JLObject; para2: JLObject); overload; virtual;
      end;

    function unmarshal(para1: JIFile): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JIInputStream): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JIReader): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JNURL): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: OXSInputSource): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: OWDNode): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: OWDNode; para2: JLClass): JXBJAXBElement; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JXTSource): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JXTSource; para2: JLClass): JXBJAXBElement; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JXSXMLStreamReader): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JXSXMLStreamReader; para2: JLClass): JXBJAXBElement; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JXSXMLEventReader): JLObject; overload;  // throws javax.xml.bind.JAXBException
    function unmarshal(para1: JXSXMLEventReader; para2: JLClass): JXBJAXBElement; overload;  // throws javax.xml.bind.JAXBException
    function getUnmarshallerHandler(): JXBUnmarshallerHandler; overload;
    procedure setValidating(para1: jboolean); overload;  // throws javax.xml.bind.JAXBException
    function isValidating(): jboolean; overload;  // throws javax.xml.bind.JAXBException
    procedure setEventHandler(para1: JXBValidationEventHandler); overload;  // throws javax.xml.bind.JAXBException
    function getEventHandler(): JXBValidationEventHandler; overload;  // throws javax.xml.bind.JAXBException
    procedure setProperty(para1: JLString; para2: JLObject); overload;  // throws javax.xml.bind.PropertyException
    function getProperty(para1: JLString): JLObject; overload;  // throws javax.xml.bind.PropertyException
    procedure setSchema(para1: JXVSchema); overload;
    function getSchema(): JXVSchema; overload;
    procedure setAdapter(para1: JXBAAXmlAdapter); overload;
    procedure setAdapter(para1: JLClass; para2: JXBAAXmlAdapter); overload;
    function getAdapter(para1: JLClass): JXBAAXmlAdapter; overload;
    procedure setAttachmentUnmarshaller(para1: JXBAAttachmentUnmarshaller); overload;
    function getAttachmentUnmarshaller(): JXBAAttachmentUnmarshaller; overload;
    procedure setListener(para1: JXBUnmarshaller.InnerListener); overload;
    function getListener(): JXBUnmarshaller.InnerListener; overload;
  end;

  JXBValidationEvent = interface external 'javax.xml.bind' name 'ValidationEvent' 
    const
      WARNING = 0;
      ERROR = 1;
      FATAL_ERROR = 2;
    function getSeverity(): jint; overload;
    function getMessage(): JLString; overload;
    function getLinkedException(): JLThrowable; overload;
    function getLocator(): JXBValidationEventLocator; overload;
  end;

  JXBValidationEventHandler = interface external 'javax.xml.bind' name 'ValidationEventHandler' 
    function handleEvent(para1: JXBValidationEvent): jboolean; overload;
  end;

  JXBValidationEventLocator = interface external 'javax.xml.bind' name 'ValidationEventLocator' 
    function getURL(): JNURL; overload;
    function getOffset(): jint; overload;
    function getLineNumber(): jint; overload;
    function getColumnNumber(): jint; overload;
    function getObject(): JLObject; overload;
    function getNode(): OWDNode; overload;
  end;

  JXBValidator = interface external 'javax.xml.bind' name 'Validator' 
    procedure setEventHandler(para1: JXBValidationEventHandler); overload;  // throws javax.xml.bind.JAXBException
    function getEventHandler(): JXBValidationEventHandler; overload;  // throws javax.xml.bind.JAXBException
    function validate(para1: JLObject): jboolean; overload;  // throws javax.xml.bind.JAXBException
    function validateRoot(para1: JLObject): jboolean; overload;  // throws javax.xml.bind.JAXBException
    procedure setProperty(para1: JLString; para2: JLObject); overload;  // throws javax.xml.bind.PropertyException
    function getProperty(para1: JLString): JLObject; overload;  // throws javax.xml.bind.PropertyException
  end;

  JXBWhiteSpaceProcessor = class abstract external 'javax.xml.bind' name 'WhiteSpaceProcessor' (JLObject)
  public
    class function replace(para1: JLString): JLString; static; overload;
    class function replace(para1: JLCharSequence): JLCharSequence; static; overload;
    class function trim(para1: JLCharSequence): JLCharSequence; static; overload;
    class function collapse(para1: JLString): JLString; static; overload;
    class function collapse(para1: JLCharSequence): JLCharSequence; static; overload;
    class function isWhiteSpace(para1: JLCharSequence): jboolean; static; overload; final;
    class function isWhiteSpace(para1: jchar): jboolean; static; overload; final;
  strict protected
    class function isWhiteSpaceExceptSpace(para1: jchar): jboolean; static; overload; final;
  end;

  JXBADomHandler = interface external 'javax.xml.bind.annotation' name 'DomHandler' 
    function createUnmarshaller(para1: JXBValidationEventHandler): JXTResult; overload;
    function getElement(para1: JXTResult): JLObject; overload;
    function marshal(para1: JLObject; para2: JXBValidationEventHandler): JXTSource; overload;
  end;

  JXBAAXmlAdapter = class abstract external 'javax.xml.bind.annotation.adapters' name 'XmlAdapter' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function unmarshal(para1: JLObject): JLObject; overload; virtual; abstract;  // throws java.lang.Exception
    function marshal(para1: JLObject): JLObject; overload; virtual; abstract;  // throws java.lang.Exception
  end;

  JXBAAttachmentMarshaller = class abstract external 'javax.xml.bind.attachment' name 'AttachmentMarshaller' (JLObject)
  public
    constructor create(); overload;
    function addMtomAttachment(para1: JADataHandler; para2: JLString; para3: JLString): JLString; overload; virtual; abstract;
    function addMtomAttachment(para1: Arr1jbyte; para2: jint; para3: jint; para4: JLString; para5: JLString; para6: JLString): JLString; overload; virtual; abstract;
    function addMtomAttachment(var para1: array of jbyte; para2: jint; para3: jint; para4: JLString; para5: JLString; para6: JLString): JLString; overload; virtual; abstract;
    function isXOPPackage(): jboolean; overload; virtual;
    function addSwaRefAttachment(para1: JADataHandler): JLString; overload; virtual; abstract;
  end;

  JXBAAttachmentUnmarshaller = class abstract external 'javax.xml.bind.attachment' name 'AttachmentUnmarshaller' (JLObject)
  public
    constructor create(); overload;
    function getAttachmentAsDataHandler(para1: JLString): JADataHandler; overload; virtual; abstract;
    function getAttachmentAsByteArray(para1: JLString): Arr1jbyte; overload; virtual; abstract;
    function isXOPPackage(): jboolean; overload; virtual;
  end;

  JXBHMessages = class external 'javax.xml.bind.helpers' name 'Messages' (JLObject)
  end;

  JXBUMessages = class external 'javax.xml.bind.util' name 'Messages' (JLObject)
  end;

  JXCAlgorithmMethod = interface external 'javax.xml.crypto' name 'AlgorithmMethod' 
    function getAlgorithm(): JLString; overload;
    function getParameterSpec(): JSSAlgorithmParameterSpec; overload;
  end;

  JXCData = interface external 'javax.xml.crypto' name 'Data' 
  end;

  JXCKeySelector = class abstract external 'javax.xml.crypto' name 'KeySelector' (JLObject)
  public
    type
      InnerSingletonKeySelector = class;
      Arr1InnerSingletonKeySelector = array of InnerSingletonKeySelector;
      Arr2InnerSingletonKeySelector = array of Arr1InnerSingletonKeySelector;
      Arr3InnerSingletonKeySelector = array of Arr2InnerSingletonKeySelector;
      InnerSingletonKeySelector = class external 'javax.xml.crypto' name 'SingletonKeySelector' 
      end;

  public
    type
      InnerPurpose = class;
      Arr1InnerPurpose = array of InnerPurpose;
      Arr2InnerPurpose = array of Arr1InnerPurpose;
      Arr3InnerPurpose = array of Arr2InnerPurpose;
      InnerPurpose = class external 'javax.xml.crypto' name 'Purpose' (JLObject)
      public
        final class var
          fSIGN: JXCKeySelector.InnerPurpose; external name 'SIGN';
          fVERIFY: JXCKeySelector.InnerPurpose; external name 'VERIFY';
          fENCRYPT: JXCKeySelector.InnerPurpose; external name 'ENCRYPT';
          fDECRYPT: JXCKeySelector.InnerPurpose; external name 'DECRYPT';
      public
        function toString(): JLString; overload; virtual;
      end;

  strict protected
    constructor create(); overload;
  public
    function select(para1: JXCDKKeyInfo; para2: JXCKeySelector.InnerPurpose; para3: JXCAlgorithmMethod; para4: JXCXMLCryptoContext): JXCKeySelectorResult; overload; virtual; abstract;  // throws javax.xml.crypto.KeySelectorException
    class function singletonKeySelector(para1: JSKey): JXCKeySelector; static; overload;
  end;

  JXCKeySelectorResult = interface external 'javax.xml.crypto' name 'KeySelectorResult' 
    function getKey(): JSKey; overload;
  end;

  JXCURIDereferencer = interface external 'javax.xml.crypto' name 'URIDereferencer' 
    function dereference(para1: JXCURIReference; para2: JXCXMLCryptoContext): JXCData; overload;  // throws javax.xml.crypto.URIReferenceException
  end;

  JXCURIReference = interface external 'javax.xml.crypto' name 'URIReference' 
    function getURI(): JLString; overload;
    function getType(): JLString; overload;
  end;

  JXCXMLCryptoContext = interface external 'javax.xml.crypto' name 'XMLCryptoContext' 
    function getBaseURI(): JLString; overload;
    procedure setBaseURI(para1: JLString); overload;
    function getKeySelector(): JXCKeySelector; overload;
    procedure setKeySelector(para1: JXCKeySelector); overload;
    function getURIDereferencer(): JXCURIDereferencer; overload;
    procedure setURIDereferencer(para1: JXCURIDereferencer); overload;
    function getNamespacePrefix(para1: JLString; para2: JLString): JLString; overload;
    function putNamespacePrefix(para1: JLString; para2: JLString): JLString; overload;
    function getDefaultNamespacePrefix(): JLString; overload;
    procedure setDefaultNamespacePrefix(para1: JLString); overload;
    function setProperty(para1: JLString; para2: JLObject): JLObject; overload;
    function getProperty(para1: JLString): JLObject; overload;
    function get(para1: JLObject): JLObject; overload;
    function put(para1: JLObject; para2: JLObject): JLObject; overload;
  end;

  JXCXMLStructure = interface external 'javax.xml.crypto' name 'XMLStructure' 
    function isFeatureSupported(para1: JLString): jboolean; overload;
  end;

  JXCDXMLSignatureFactory = class abstract external 'javax.xml.crypto.dsig' name 'XMLSignatureFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function getInstance(para1: JLString): JXCDXMLSignatureFactory; static; overload;
    class function getInstance(para1: JLString; para2: JSProvider): JXCDXMLSignatureFactory; static; overload;
    class function getInstance(para1: JLString; para2: JLString): JXCDXMLSignatureFactory; static; overload;  // throws java.security.NoSuchProviderException
    class function getInstance(): JXCDXMLSignatureFactory; static; overload;
    function getMechanismType(): JLString; overload; virtual; final;
    function getProvider(): JSProvider; overload; virtual; final;
    function newXMLSignature(para1: JXCDSignedInfo; para2: JXCDKKeyInfo): JXCDXMLSignature; overload; virtual; abstract;
    function newXMLSignature(para1: JXCDSignedInfo; para2: JXCDKKeyInfo; para3: JUList; para4: JLString; para5: JLString): JXCDXMLSignature; overload; virtual; abstract;
    function newReference(para1: JLString; para2: JXCDDigestMethod): JXCDReference; overload; virtual; abstract;
    function newReference(para1: JLString; para2: JXCDDigestMethod; para3: JUList; para4: JLString; para5: JLString): JXCDReference; overload; virtual; abstract;
    function newReference(para1: JLString; para2: JXCDDigestMethod; para3: JUList; para4: JLString; para5: JLString; para6: Arr1jbyte): JXCDReference; overload; virtual; abstract;
    function newReference(para1: JLString; para2: JXCDDigestMethod; para3: JUList; para4: JLString; para5: JLString; var para6: array of jbyte): JXCDReference; overload; virtual; abstract;
    function newReference(para1: JLString; para2: JXCDDigestMethod; para3: JUList; para4: JXCData; para5: JUList; para6: JLString; para7: JLString): JXCDReference; overload; virtual; abstract;
    function newSignedInfo(para1: JXCDCanonicalizationMethod; para2: JXCDSignatureMethod; para3: JUList): JXCDSignedInfo; overload; virtual; abstract;
    function newSignedInfo(para1: JXCDCanonicalizationMethod; para2: JXCDSignatureMethod; para3: JUList; para4: JLString): JXCDSignedInfo; overload; virtual; abstract;
    function newXMLObject(para1: JUList; para2: JLString; para3: JLString; para4: JLString): JXCDXMLObject; overload; virtual; abstract;
    function newManifest(para1: JUList): JXCDManifest; overload; virtual; abstract;
    function newManifest(para1: JUList; para2: JLString): JXCDManifest; overload; virtual; abstract;
    function newSignatureProperty(para1: JUList; para2: JLString; para3: JLString): JXCDSignatureProperty; overload; virtual; abstract;
    function newSignatureProperties(para1: JUList; para2: JLString): JXCDSignatureProperties; overload; virtual; abstract;
    function newDigestMethod(para1: JLString; para2: JXCDSDigestMethodParameterSpec): JXCDDigestMethod; overload; virtual; abstract;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidAlgorithmParameterException
    function newSignatureMethod(para1: JLString; para2: JXCDSSignatureMethodParameterSpec): JXCDSignatureMethod; overload; virtual; abstract;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidAlgorithmParameterException
    function newTransform(para1: JLString; para2: JXCDSTransformParameterSpec): JXCDTransform; overload; virtual; abstract;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidAlgorithmParameterException
    function newTransform(para1: JLString; para2: JXCXMLStructure): JXCDTransform; overload; virtual; abstract;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidAlgorithmParameterException
    function newCanonicalizationMethod(para1: JLString; para2: JXCDSC14NMethodParameterSpec): JXCDCanonicalizationMethod; overload; virtual; abstract;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidAlgorithmParameterException
    function newCanonicalizationMethod(para1: JLString; para2: JXCXMLStructure): JXCDCanonicalizationMethod; overload; virtual; abstract;  // throws java.security.NoSuchAlgorithmException, java.security.InvalidAlgorithmParameterException
    function getKeyInfoFactory(): JXCDKKeyInfoFactory; overload; virtual; final;
    function unmarshalXMLSignature(para1: JXCDXMLValidateContext): JXCDXMLSignature; overload; virtual; abstract;  // throws javax.xml.crypto.MarshalException
    function unmarshalXMLSignature(para1: JXCXMLStructure): JXCDXMLSignature; overload; virtual; abstract;  // throws javax.xml.crypto.MarshalException
    function isFeatureSupported(para1: JLString): jboolean; overload; virtual; abstract;
    function getURIDereferencer(): JXCURIDereferencer; overload; virtual; abstract;
  end;

  JXCDKKeyInfoFactory = class abstract external 'javax.xml.crypto.dsig.keyinfo' name 'KeyInfoFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function getInstance(para1: JLString): JXCDKKeyInfoFactory; static; overload;
    class function getInstance(para1: JLString; para2: JSProvider): JXCDKKeyInfoFactory; static; overload;
    class function getInstance(para1: JLString; para2: JLString): JXCDKKeyInfoFactory; static; overload;  // throws java.security.NoSuchProviderException
    class function getInstance(): JXCDKKeyInfoFactory; static; overload;
    function getMechanismType(): JLString; overload; virtual; final;
    function getProvider(): JSProvider; overload; virtual; final;
    function newKeyInfo(para1: JUList): JXCDKKeyInfo; overload; virtual; abstract;
    function newKeyInfo(para1: JUList; para2: JLString): JXCDKKeyInfo; overload; virtual; abstract;
    function newKeyName(para1: JLString): JXCDKKeyName; overload; virtual; abstract;
    function newKeyValue(para1: JSPublicKey): JXCDKKeyValue; overload; virtual; abstract;  // throws java.security.KeyException
    function newPGPData(para1: Arr1jbyte): JXCDKPGPData; overload; virtual; abstract;
    function newPGPData(var para1: array of jbyte): JXCDKPGPData; overload; virtual; abstract;
    function newPGPData(para1: Arr1jbyte; para2: Arr1jbyte; para3: JUList): JXCDKPGPData; overload; virtual; abstract;
    function newPGPData(var para1: array of jbyte; var para2: array of jbyte; para3: JUList): JXCDKPGPData; overload; virtual; abstract;
    function newPGPData(para1: Arr1jbyte; para2: JUList): JXCDKPGPData; overload; virtual; abstract;
    function newPGPData(var para1: array of jbyte; para2: JUList): JXCDKPGPData; overload; virtual; abstract;
    function newRetrievalMethod(para1: JLString): JXCDKRetrievalMethod; overload; virtual; abstract;
    function newRetrievalMethod(para1: JLString; para2: JLString; para3: JUList): JXCDKRetrievalMethod; overload; virtual; abstract;
    function newX509Data(para1: JUList): JXCDKX509Data; overload; virtual; abstract;
    function newX509IssuerSerial(para1: JLString; para2: JMBigInteger): JXCDKX509IssuerSerial; overload; virtual; abstract;
    function isFeatureSupported(para1: JLString): jboolean; overload; virtual; abstract;
    function getURIDereferencer(): JXCURIDereferencer; overload; virtual; abstract;
    function unmarshalKeyInfo(para1: JXCXMLStructure): JXCDKKeyInfo; overload; virtual; abstract;  // throws javax.xml.crypto.MarshalException
  end;

  JXCDSXPathType = class external 'javax.xml.crypto.dsig.spec' name 'XPathType' (JLObject)
  public
    type
      InnerFilter = class;
      Arr1InnerFilter = array of InnerFilter;
      Arr2InnerFilter = array of Arr1InnerFilter;
      Arr3InnerFilter = array of Arr2InnerFilter;
      InnerFilter = class external 'javax.xml.crypto.dsig.spec' name 'Filter' (JLObject)
      public
        final class var
          fINTERSECT: JXCDSXPathType.InnerFilter; external name 'INTERSECT';
          fSUBTRACT: JXCDSXPathType.InnerFilter; external name 'SUBTRACT';
          fUNION: JXCDSXPathType.InnerFilter; external name 'UNION';
      public
        function toString(): JLString; overload; virtual;
      end;

  public
    constructor create(para1: JLString; para2: JXCDSXPathType.InnerFilter); overload;
    constructor create(para1: JLString; para2: JXCDSXPathType.InnerFilter; para3: JUMap); overload;
    function getExpression(): JLString; overload; virtual;
    function getFilter(): JXCDSXPathType.InnerFilter; overload; virtual;
    function getNamespaceMap(): JUMap; overload; virtual;
  end;

  JXDDatatypeConstants = class sealed external 'javax.xml.datatype' name 'DatatypeConstants' (JLObject)
  public
    type
      InnerField = class;
      Arr1InnerField = array of InnerField;
      Arr2InnerField = array of Arr1InnerField;
      Arr3InnerField = array of Arr2InnerField;
      InnerField = class sealed external 'javax.xml.datatype' name 'Field' (JLObject)
      public
        function toString(): JLString; overload; virtual;
        function getId(): jint; overload; virtual;
      end;

  public
    const
      JANUARY = 1;
      FEBRUARY = 2;
      MARCH = 3;
      APRIL = 4;
      MAY = 5;
      JUNE = 6;
      JULY = 7;
      AUGUST = 8;
      SEPTEMBER = 9;
      OCTOBER = 10;
      NOVEMBER = 11;
      DECEMBER = 12;
      LESSER = -1;
      EQUAL = 0;
      GREATER = 1;
      INDETERMINATE = 2;
      FIELD_UNDEFINED = -2147483648;
  public
    final class var
      fYEARS: JXDDatatypeConstants.InnerField; external name 'YEARS';
      fMONTHS: JXDDatatypeConstants.InnerField; external name 'MONTHS';
      fDAYS: JXDDatatypeConstants.InnerField; external name 'DAYS';
      fHOURS: JXDDatatypeConstants.InnerField; external name 'HOURS';
      fMINUTES: JXDDatatypeConstants.InnerField; external name 'MINUTES';
      fSECONDS: JXDDatatypeConstants.InnerField; external name 'SECONDS';
      fDATETIME: JXNQName; external name 'DATETIME';
      fTIME: JXNQName; external name 'TIME';
      fDATE: JXNQName; external name 'DATE';
      fGYEARMONTH: JXNQName; external name 'GYEARMONTH';
      fGMONTHDAY: JXNQName; external name 'GMONTHDAY';
      fGYEAR: JXNQName; external name 'GYEAR';
      fGMONTH: JXNQName; external name 'GMONTH';
      fGDAY: JXNQName; external name 'GDAY';
      fDURATION: JXNQName; external name 'DURATION';
      fDURATION_DAYTIME: JXNQName; external name 'DURATION_DAYTIME';
      fDURATION_YEARMONTH: JXNQName; external name 'DURATION_YEARMONTH';
  public
    const
      MAX_TIMEZONE_OFFSET = -840;
      MIN_TIMEZONE_OFFSET = 840;
  end;

  JXDDatatypeFactory = class abstract external 'javax.xml.datatype' name 'DatatypeFactory' (JLObject)
  public
    const
      DATATYPEFACTORY_PROPERTY = 'javax.xml.datatype.DatatypeFactory';
  public
    final class var
      fDATATYPEFACTORY_IMPLEMENTATION_CLASS: JLString; external name 'DATATYPEFACTORY_IMPLEMENTATION_CLASS';
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXDDatatypeFactory; static; overload;  // throws javax.xml.datatype.DatatypeConfigurationException
    class function newInstance(para1: JLString; para2: JLClassLoader): JXDDatatypeFactory; static; overload;  // throws javax.xml.datatype.DatatypeConfigurationException
    function newDuration(para1: JLString): JXDDuration; overload; virtual; abstract;
    function newDuration(para1: jlong): JXDDuration; overload; virtual; abstract;
    function newDuration(para1: jboolean; para2: JMBigInteger; para3: JMBigInteger; para4: JMBigInteger; para5: JMBigInteger; para6: JMBigInteger; para7: JMBigDecimal): JXDDuration; overload; virtual; abstract;
    function newDuration(para1: jboolean; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint): JXDDuration; overload; virtual;
    function newDurationDayTime(para1: JLString): JXDDuration; overload; virtual;
    function newDurationDayTime(para1: jlong): JXDDuration; overload; virtual;
    function newDurationDayTime(para1: jboolean; para2: JMBigInteger; para3: JMBigInteger; para4: JMBigInteger; para5: JMBigInteger): JXDDuration; overload; virtual;
    function newDurationDayTime(para1: jboolean; para2: jint; para3: jint; para4: jint; para5: jint): JXDDuration; overload; virtual;
    function newDurationYearMonth(para1: JLString): JXDDuration; overload; virtual;
    function newDurationYearMonth(para1: jlong): JXDDuration; overload; virtual;
    function newDurationYearMonth(para1: jboolean; para2: JMBigInteger; para3: JMBigInteger): JXDDuration; overload; virtual;
    function newDurationYearMonth(para1: jboolean; para2: jint; para3: jint): JXDDuration; overload; virtual;
    function newXMLGregorianCalendar(): JXDXMLGregorianCalendar; overload; virtual; abstract;
    function newXMLGregorianCalendar(para1: JLString): JXDXMLGregorianCalendar; overload; virtual; abstract;
    function newXMLGregorianCalendar(para1: JUGregorianCalendar): JXDXMLGregorianCalendar; overload; virtual; abstract;
    function newXMLGregorianCalendar(para1: JMBigInteger; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: JMBigDecimal; para8: jint): JXDXMLGregorianCalendar; overload; virtual; abstract;
    function newXMLGregorianCalendar(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint; para6: jint; para7: jint; para8: jint): JXDXMLGregorianCalendar; overload; virtual;
    function newXMLGregorianCalendarDate(para1: jint; para2: jint; para3: jint; para4: jint): JXDXMLGregorianCalendar; overload; virtual;
    function newXMLGregorianCalendarTime(para1: jint; para2: jint; para3: jint; para4: jint): JXDXMLGregorianCalendar; overload; virtual;
    function newXMLGregorianCalendarTime(para1: jint; para2: jint; para3: jint; para4: JMBigDecimal; para5: jint): JXDXMLGregorianCalendar; overload; virtual;
    function newXMLGregorianCalendarTime(para1: jint; para2: jint; para3: jint; para4: jint; para5: jint): JXDXMLGregorianCalendar; overload; virtual;
  end;

  JXDFactoryFinder = class external 'javax.xml.datatype' name 'FactoryFinder' (JLObject)
  public
    type
      InnerConfigurationError = class;
      Arr1InnerConfigurationError = array of InnerConfigurationError;
      Arr2InnerConfigurationError = array of Arr1InnerConfigurationError;
      Arr3InnerConfigurationError = array of Arr2InnerConfigurationError;
      InnerConfigurationError = class external 'javax.xml.datatype' name 'ConfigurationError' 
      end;

  end;

  JXDSecuritySupport = class external 'javax.xml.datatype' name 'SecuritySupport' (JLObject)
  end;

  JXNNamespaceContext = interface external 'javax.xml.namespace' name 'NamespaceContext' 
    function getNamespaceURI(para1: JLString): JLString; overload;
    function getPrefix(para1: JLString): JLString; overload;
    function getPrefixes(para1: JLString): JUIterator; overload;
  end;

  JXPDocumentBuilder = class abstract external 'javax.xml.parsers' name 'DocumentBuilder' (JLObject)
  strict protected
    constructor create(); overload;
  public
    procedure reset(); overload; virtual;
    function parse(para1: JIInputStream): OWDDocument; overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    function parse(para1: JIInputStream; para2: JLString): OWDDocument; overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    function parse(para1: JLString): OWDDocument; overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    function parse(para1: JIFile): OWDDocument; overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    function parse(para1: OXSInputSource): OWDDocument; overload; virtual; abstract;  // throws org.xml.sax.SAXException, java.io.IOException
    function isNamespaceAware(): jboolean; overload; virtual; abstract;
    function isValidating(): jboolean; overload; virtual; abstract;
    procedure setEntityResolver(para1: OXSEntityResolver); overload; virtual; abstract;
    procedure setErrorHandler(para1: OXSErrorHandler); overload; virtual; abstract;
    function newDocument(): OWDDocument; overload; virtual; abstract;
    function getDOMImplementation(): OWDDOMImplementation; overload; virtual; abstract;
    function getSchema(): JXVSchema; overload; virtual;
    function isXIncludeAware(): jboolean; overload; virtual;
  end;

  JXPDocumentBuilderFactory = class abstract external 'javax.xml.parsers' name 'DocumentBuilderFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXPDocumentBuilderFactory; static; overload;
    class function newInstance(para1: JLString; para2: JLClassLoader): JXPDocumentBuilderFactory; static; overload;
    function newDocumentBuilder(): JXPDocumentBuilder; overload; virtual; abstract;  // throws javax.xml.parsers.ParserConfigurationException
    procedure setNamespaceAware(para1: jboolean); overload; virtual;
    procedure setValidating(para1: jboolean); overload; virtual;
    procedure setIgnoringElementContentWhitespace(para1: jboolean); overload; virtual;
    procedure setExpandEntityReferences(para1: jboolean); overload; virtual;
    procedure setIgnoringComments(para1: jboolean); overload; virtual;
    procedure setCoalescing(para1: jboolean); overload; virtual;
    function isNamespaceAware(): jboolean; overload; virtual;
    function isValidating(): jboolean; overload; virtual;
    function isIgnoringElementContentWhitespace(): jboolean; overload; virtual;
    function isExpandEntityReferences(): jboolean; overload; virtual;
    function isIgnoringComments(): jboolean; overload; virtual;
    function isCoalescing(): jboolean; overload; virtual;
    procedure setAttribute(para1: JLString; para2: JLObject); overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    function getAttribute(para1: JLString): JLObject; overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    procedure setFeature(para1: JLString; para2: jboolean); overload; virtual; abstract;  // throws javax.xml.parsers.ParserConfigurationException
    function getFeature(para1: JLString): jboolean; overload; virtual; abstract;  // throws javax.xml.parsers.ParserConfigurationException
    function getSchema(): JXVSchema; overload; virtual;
    procedure setSchema(para1: JXVSchema); overload; virtual;
    procedure setXIncludeAware(para1: jboolean); overload; virtual;
    function isXIncludeAware(): jboolean; overload; virtual;
  end;

  JXPFactoryFinder = class external 'javax.xml.parsers' name 'FactoryFinder' (JLObject)
  public
    type
      InnerConfigurationError = class;
      Arr1InnerConfigurationError = array of InnerConfigurationError;
      Arr2InnerConfigurationError = array of Arr1InnerConfigurationError;
      Arr3InnerConfigurationError = array of Arr2InnerConfigurationError;
      InnerConfigurationError = class external 'javax.xml.parsers' name 'ConfigurationError' 
      end;

  end;

  JXPSAXParser = class abstract external 'javax.xml.parsers' name 'SAXParser' (JLObject)
  strict protected
    constructor create(); overload;
  public
    procedure reset(); overload; virtual;
    procedure parse(para1: JIInputStream; para2: OXSHandlerBase); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JIInputStream; para2: OXSHandlerBase; para3: JLString); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JIInputStream; para2: OXSHDefaultHandler); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JIInputStream; para2: OXSHDefaultHandler; para3: JLString); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JLString; para2: OXSHandlerBase); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JLString; para2: OXSHDefaultHandler); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JIFile; para2: OXSHandlerBase); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JIFile; para2: OXSHDefaultHandler); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: OXSInputSource; para2: OXSHandlerBase); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: OXSInputSource; para2: OXSHDefaultHandler); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    function getParser(): OXSParser; overload; virtual; abstract;  // throws org.xml.sax.SAXException
    function getXMLReader(): OXSXMLReader; overload; virtual; abstract;  // throws org.xml.sax.SAXException
    function isNamespaceAware(): jboolean; overload; virtual; abstract;
    function isValidating(): jboolean; overload; virtual; abstract;
    procedure setProperty(para1: JLString; para2: JLObject); overload; virtual; abstract;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    function getProperty(para1: JLString): JLObject; overload; virtual; abstract;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    function getSchema(): JXVSchema; overload; virtual;
    function isXIncludeAware(): jboolean; overload; virtual;
  end;

  JXPSAXParserFactory = class abstract external 'javax.xml.parsers' name 'SAXParserFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXPSAXParserFactory; static; overload;
    class function newInstance(para1: JLString; para2: JLClassLoader): JXPSAXParserFactory; static; overload;
    function newSAXParser(): JXPSAXParser; overload; virtual; abstract;  // throws javax.xml.parsers.ParserConfigurationException, org.xml.sax.SAXException
    procedure setNamespaceAware(para1: jboolean); overload; virtual;
    procedure setValidating(para1: jboolean); overload; virtual;
    function isNamespaceAware(): jboolean; overload; virtual;
    function isValidating(): jboolean; overload; virtual;
    procedure setFeature(para1: JLString; para2: jboolean); overload; virtual; abstract;  // throws javax.xml.parsers.ParserConfigurationException, org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    function getFeature(para1: JLString): jboolean; overload; virtual; abstract;  // throws javax.xml.parsers.ParserConfigurationException, org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    function getSchema(): JXVSchema; overload; virtual;
    procedure setSchema(para1: JXVSchema); overload; virtual;
    procedure setXIncludeAware(para1: jboolean); overload; virtual;
    function isXIncludeAware(): jboolean; overload; virtual;
  end;

  JXPSecuritySupport = class external 'javax.xml.parsers' name 'SecuritySupport' (JLObject)
  end;

  JXSAttachmentPart = class abstract external 'javax.xml.soap' name 'AttachmentPart' (JLObject)
  public
    constructor create(); overload;
    function getSize(): jint; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    procedure clearContent(); overload; virtual; abstract;
    function getContent(): JLObject; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function getRawContent(): JIInputStream; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function getRawContentBytes(): Arr1jbyte; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function getBase64Content(): JIInputStream; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    procedure setContent(para1: JLObject; para2: JLString); overload; virtual; abstract;
    procedure setRawContent(para1: JIInputStream; para2: JLString); overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    procedure setRawContentBytes(para1: Arr1jbyte; para2: jint; para3: jint; para4: JLString); overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    procedure setRawContentBytes(var para1: array of jbyte; para2: jint; para3: jint; para4: JLString); overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    procedure setBase64Content(para1: JIInputStream; para2: JLString); overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function getDataHandler(): JADataHandler; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    procedure setDataHandler(para1: JADataHandler); overload; virtual; abstract;
    function getContentId(): JLString; overload; virtual;
    function getContentLocation(): JLString; overload; virtual;
    function getContentType(): JLString; overload; virtual;
    procedure setContentId(para1: JLString); overload; virtual;
    procedure setContentLocation(para1: JLString); overload; virtual;
    procedure setContentType(para1: JLString); overload; virtual;
    procedure removeMimeHeader(para1: JLString); overload; virtual; abstract;
    procedure removeAllMimeHeaders(); overload; virtual; abstract;
    function getMimeHeader(para1: JLString): Arr1JLString; overload; virtual; abstract;
    procedure setMimeHeader(para1: JLString; para2: JLString); overload; virtual; abstract;
    procedure addMimeHeader(para1: JLString; para2: JLString); overload; virtual; abstract;
    function getAllMimeHeaders(): JUIterator; overload; virtual; abstract;
    function getMatchingMimeHeaders(para1: Arr1JLString): JUIterator; overload; virtual; abstract;
    function getMatchingMimeHeaders(var para1: array of JLString): JUIterator; overload; virtual; abstract;
    function getNonMatchingMimeHeaders(para1: Arr1JLString): JUIterator; overload; virtual; abstract;
    function getNonMatchingMimeHeaders(var para1: array of JLString): JUIterator; overload; virtual; abstract;
  end;

  JXSoapFactoryFinder = class external 'javax.xml.soap' name 'FactoryFinder' (JLObject)
  end;

  JXSMessageFactory = class abstract external 'javax.xml.soap' name 'MessageFactory' (JLObject)
  public
    constructor create(); overload;
    class function newInstance(): JXSMessageFactory; static; overload;  // throws javax.xml.soap.SOAPException
    class function newInstance(para1: JLString): JXSMessageFactory; static; overload;  // throws javax.xml.soap.SOAPException
    function createMessage(): JXSSOAPMessage; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createMessage(para1: JXSMimeHeaders; para2: JIInputStream): JXSSOAPMessage; overload; virtual; abstract;  // throws java.io.IOException, javax.xml.soap.SOAPException
  end;

  JXSMimeHeader = class external 'javax.xml.soap' name 'MimeHeader' (JLObject)
  public
    constructor create(para1: JLString; para2: JLString); overload;
    function getName(): JLString; overload; virtual;
    function getValue(): JLString; overload; virtual;
  end;

  JXSMimeHeaders = class external 'javax.xml.soap' name 'MimeHeaders' (JLObject)
  public
    type
      InnerMatchingIterator = class;
      Arr1InnerMatchingIterator = array of InnerMatchingIterator;
      Arr2InnerMatchingIterator = array of Arr1InnerMatchingIterator;
      Arr3InnerMatchingIterator = array of Arr2InnerMatchingIterator;
      InnerMatchingIterator = class external 'javax.xml.soap' name 'MatchingIterator' 
      end;

  public
    constructor create(); overload;
    function getHeader(para1: JLString): Arr1JLString; overload; virtual;
    procedure setHeader(para1: JLString; para2: JLString); overload; virtual;
    procedure addHeader(para1: JLString; para2: JLString); overload; virtual;
    procedure removeHeader(para1: JLString); overload; virtual;
    procedure removeAllHeaders(); overload; virtual;
    function getAllHeaders(): JUIterator; overload; virtual;
    function getMatchingHeaders(para1: Arr1JLString): JUIterator; overload; virtual;
    function getMatchingHeaders(var para1: array of JLString): JUIterator; overload; virtual;
    function getNonMatchingHeaders(para1: Arr1JLString): JUIterator; overload; virtual;
    function getNonMatchingHeaders(var para1: array of JLString): JUIterator; overload; virtual;
  end;

  JXSName = interface external 'javax.xml.soap' name 'Name' 
    function getLocalName(): JLString; overload;
    function getQualifiedName(): JLString; overload;
    function getPrefix(): JLString; overload;
    function getURI(): JLString; overload;
  end;

  JXSSAAJMetaFactory = class abstract external 'javax.xml.soap' name 'SAAJMetaFactory' (JLObject)
  strict protected
    constructor create(); overload;
    function newMessageFactory(para1: JLString): JXSMessageFactory; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function newSOAPFactory(para1: JLString): JXSSOAPFactory; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
  end;

  JXSSOAPConnection = class abstract external 'javax.xml.soap' name 'SOAPConnection' (JLObject)
  public
    constructor create(); overload;
    function call(para1: JXSSOAPMessage; para2: JLObject): JXSSOAPMessage; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function get(para1: JLObject): JXSSOAPMessage; overload; virtual;  // throws javax.xml.soap.SOAPException
    procedure close(); overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
  end;

  JXSSOAPConnectionFactory = class abstract external 'javax.xml.soap' name 'SOAPConnectionFactory' (JLObject)
  public
    constructor create(); overload;
    class function newInstance(): JXSSOAPConnectionFactory; static; overload;  // throws javax.xml.soap.SOAPException, java.lang.UnsupportedOperationException
    function createConnection(): JXSSOAPConnection; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
  end;

  JXSSOAPConstants = interface external 'javax.xml.soap' name 'SOAPConstants' 
    const
      DYNAMIC_SOAP_PROTOCOL = 'Dynamic Protocol';
      SOAP_1_1_PROTOCOL = 'SOAP 1.1 Protocol';
      SOAP_1_2_PROTOCOL = 'SOAP 1.2 Protocol';
      DEFAULT_SOAP_PROTOCOL = 'SOAP 1.1 Protocol';
      URI_NS_SOAP_1_1_ENVELOPE = 'http://schemas.xmlsoap.org/soap/envelope/';
      URI_NS_SOAP_1_2_ENVELOPE = 'http://www.w3.org/2003/05/soap-envelope';
      URI_NS_SOAP_ENVELOPE = 'http://schemas.xmlsoap.org/soap/envelope/';
      URI_NS_SOAP_ENCODING = 'http://schemas.xmlsoap.org/soap/encoding/';
      URI_NS_SOAP_1_2_ENCODING = 'http://www.w3.org/2003/05/soap-encoding';
      SOAP_1_1_CONTENT_TYPE = 'text/xml';
      SOAP_1_2_CONTENT_TYPE = 'application/soap+xml';
      URI_SOAP_ACTOR_NEXT = 'http://schemas.xmlsoap.org/soap/actor/next';
      URI_SOAP_1_2_ROLE_NEXT = 'http://www.w3.org/2003/05/soap-envelope/role/next';
      URI_SOAP_1_2_ROLE_NONE = 'http://www.w3.org/2003/05/soap-envelope/role/none';
      URI_SOAP_1_2_ROLE_ULTIMATE_RECEIVER = 'http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver';
      SOAP_ENV_PREFIX = 'env';
    final class var
      fSOAP_VERSIONMISMATCH_FAULT: JXNQName; external name 'SOAP_VERSIONMISMATCH_FAULT';
      fSOAP_MUSTUNDERSTAND_FAULT: JXNQName; external name 'SOAP_MUSTUNDERSTAND_FAULT';
      fSOAP_DATAENCODINGUNKNOWN_FAULT: JXNQName; external name 'SOAP_DATAENCODINGUNKNOWN_FAULT';
      fSOAP_SENDER_FAULT: JXNQName; external name 'SOAP_SENDER_FAULT';
      fSOAP_RECEIVER_FAULT: JXNQName; external name 'SOAP_RECEIVER_FAULT';
  end;

  JXSSOAPElementFactory = class external 'javax.xml.soap' name 'SOAPElementFactory' (JLObject)
  public
    function create_(para1: JXSName): JXSSOAPElement; external name 'create'; overload; virtual;  // throws javax.xml.soap.SOAPException
    function create_(para1: JLString): JXSSOAPElement; external name 'create'; overload; virtual;  // throws javax.xml.soap.SOAPException
    function create_(para1: JLString; para2: JLString; para3: JLString): JXSSOAPElement; external name 'create'; overload; virtual;  // throws javax.xml.soap.SOAPException
    class function newInstance(): JXSSOAPElementFactory; static; overload;  // throws javax.xml.soap.SOAPException
  end;

  JXSSOAPFactory = class abstract external 'javax.xml.soap' name 'SOAPFactory' (JLObject)
  public
    constructor create(); overload;
    function createElement(para1: OWDElement): JXSSOAPElement; overload; virtual;  // throws javax.xml.soap.SOAPException
    function createElement(para1: JXSName): JXSSOAPElement; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createElement(para1: JXNQName): JXSSOAPElement; overload; virtual;  // throws javax.xml.soap.SOAPException
    function createElement(para1: JLString): JXSSOAPElement; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createElement(para1: JLString; para2: JLString; para3: JLString): JXSSOAPElement; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createDetail(): JXSDetail; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createFault(para1: JLString; para2: JXNQName): JXSSOAPFault; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createFault(): JXSSOAPFault; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createName(para1: JLString; para2: JLString; para3: JLString): JXSName; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function createName(para1: JLString): JXSName; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    class function newInstance(): JXSSOAPFactory; static; overload;  // throws javax.xml.soap.SOAPException
    class function newInstance(para1: JLString): JXSSOAPFactory; static; overload;  // throws javax.xml.soap.SOAPException
  end;

  JXSSOAPMessage = class abstract external 'javax.xml.soap' name 'SOAPMessage' (JLObject)
  public
    const
      CHARACTER_SET_ENCODING = 'javax.xml.soap.character-set-encoding';
      WRITE_XML_DECLARATION = 'javax.xml.soap.write-xml-declaration';
  public
    constructor create(); overload;
    procedure setContentDescription(para1: JLString); overload; virtual; abstract;
    function getContentDescription(): JLString; overload; virtual; abstract;
    function getSOAPPart(): JXSSOAPPart; overload; virtual; abstract;
    function getSOAPBody(): JXSSOAPBody; overload; virtual;  // throws javax.xml.soap.SOAPException
    function getSOAPHeader(): JXSSOAPHeader; overload; virtual;  // throws javax.xml.soap.SOAPException
    procedure removeAllAttachments(); overload; virtual; abstract;
    function countAttachments(): jint; overload; virtual; abstract;
    function getAttachments(): JUIterator; overload; virtual; abstract;
    function getAttachments(para1: JXSMimeHeaders): JUIterator; overload; virtual; abstract;
    procedure removeAttachments(para1: JXSMimeHeaders); overload; virtual; abstract;
    function getAttachment(para1: JXSSOAPElement): JXSAttachmentPart; overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    procedure addAttachmentPart(para1: JXSAttachmentPart); overload; virtual; abstract;
    function createAttachmentPart(): JXSAttachmentPart; overload; virtual; abstract;
    function createAttachmentPart(para1: JADataHandler): JXSAttachmentPart; overload; virtual;
    function getMimeHeaders(): JXSMimeHeaders; overload; virtual; abstract;
    function createAttachmentPart(para1: JLObject; para2: JLString): JXSAttachmentPart; overload; virtual;
    procedure saveChanges(); overload; virtual; abstract;  // throws javax.xml.soap.SOAPException
    function saveRequired(): jboolean; overload; virtual; abstract;
    procedure writeTo(para1: JIOutputStream); overload; virtual; abstract;  // throws javax.xml.soap.SOAPException, java.io.IOException
    procedure setProperty(para1: JLString; para2: JLObject); overload; virtual;  // throws javax.xml.soap.SOAPException
    function getProperty(para1: JLString): JLObject; overload; virtual;  // throws javax.xml.soap.SOAPException
  end;

  JXSEventFilter = interface external 'javax.xml.stream' name 'EventFilter' 
    function accept(para1: JXSEXMLEvent): jboolean; overload;
  end;

  JXStreamFactoryFinder = class external 'javax.xml.stream' name 'FactoryFinder' (JLObject)
  public
    type
      InnerConfigurationError = class;
      Arr1InnerConfigurationError = array of InnerConfigurationError;
      Arr2InnerConfigurationError = array of Arr1InnerConfigurationError;
      Arr3InnerConfigurationError = array of Arr2InnerConfigurationError;
      InnerConfigurationError = class external 'javax.xml.stream' name 'ConfigurationError' 
      end;

  end;

  JXSLocation = interface external 'javax.xml.stream' name 'Location' 
    function getLineNumber(): jint; overload;
    function getColumnNumber(): jint; overload;
    function getCharacterOffset(): jint; overload;
    function getPublicId(): JLString; overload;
    function getSystemId(): JLString; overload;
  end;

  JXSSecuritySupport = class external 'javax.xml.stream' name 'SecuritySupport' (JLObject)
  end;

  JXSStreamFilter = interface external 'javax.xml.stream' name 'StreamFilter' 
    function accept(para1: JXSXMLStreamReader): jboolean; overload;
  end;

  JXSXMLEventFactory = class abstract external 'javax.xml.stream' name 'XMLEventFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXSXMLEventFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newFactory(): JXSXMLEventFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newInstance(para1: JLString; para2: JLClassLoader): JXSXMLEventFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newFactory(para1: JLString; para2: JLClassLoader): JXSXMLEventFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    procedure setLocation(para1: JXSLocation); overload; virtual; abstract;
    function createAttribute(para1: JLString; para2: JLString; para3: JLString; para4: JLString): JXSEAttribute; overload; virtual; abstract;
    function createAttribute(para1: JLString; para2: JLString): JXSEAttribute; overload; virtual; abstract;
    function createAttribute(para1: JXNQName; para2: JLString): JXSEAttribute; overload; virtual; abstract;
    function createNamespace(para1: JLString): JXSENamespace; overload; virtual; abstract;
    function createNamespace(para1: JLString; para2: JLString): JXSENamespace; overload; virtual; abstract;
    function createStartElement(para1: JXNQName; para2: JUIterator; para3: JUIterator): JXSEStartElement; overload; virtual; abstract;
    function createStartElement(para1: JLString; para2: JLString; para3: JLString): JXSEStartElement; overload; virtual; abstract;
    function createStartElement(para1: JLString; para2: JLString; para3: JLString; para4: JUIterator; para5: JUIterator): JXSEStartElement; overload; virtual; abstract;
    function createStartElement(para1: JLString; para2: JLString; para3: JLString; para4: JUIterator; para5: JUIterator; para6: JXNNamespaceContext): JXSEStartElement; overload; virtual; abstract;
    function createEndElement(para1: JXNQName; para2: JUIterator): JXSEEndElement; overload; virtual; abstract;
    function createEndElement(para1: JLString; para2: JLString; para3: JLString): JXSEEndElement; overload; virtual; abstract;
    function createEndElement(para1: JLString; para2: JLString; para3: JLString; para4: JUIterator): JXSEEndElement; overload; virtual; abstract;
    function createCharacters(para1: JLString): JXSECharacters; overload; virtual; abstract;
    function createCData(para1: JLString): JXSECharacters; overload; virtual; abstract;
    function createSpace(para1: JLString): JXSECharacters; overload; virtual; abstract;
    function createIgnorableSpace(para1: JLString): JXSECharacters; overload; virtual; abstract;
    function createStartDocument(): JXSEStartDocument; overload; virtual; abstract;
    function createStartDocument(para1: JLString; para2: JLString; para3: jboolean): JXSEStartDocument; overload; virtual; abstract;
    function createStartDocument(para1: JLString; para2: JLString): JXSEStartDocument; overload; virtual; abstract;
    function createStartDocument(para1: JLString): JXSEStartDocument; overload; virtual; abstract;
    function createEndDocument(): JXSEEndDocument; overload; virtual; abstract;
    function createEntityReference(para1: JLString; para2: JXSEEntityDeclaration): JXSEEntityReference; overload; virtual; abstract;
    function createComment(para1: JLString): JXSEComment; overload; virtual; abstract;
    function createProcessingInstruction(para1: JLString; para2: JLString): JXSEProcessingInstruction; overload; virtual; abstract;
    function createDTD(para1: JLString): JXSEDTD; overload; virtual; abstract;
  end;

  JXSXMLInputFactory = class abstract external 'javax.xml.stream' name 'XMLInputFactory' (JLObject)
  public
    const
      IS_NAMESPACE_AWARE = 'javax.xml.stream.isNamespaceAware';
      IS_VALIDATING = 'javax.xml.stream.isValidating';
      IS_COALESCING = 'javax.xml.stream.isCoalescing';
      IS_REPLACING_ENTITY_REFERENCES = 'javax.xml.stream.isReplacingEntityReferences';
      IS_SUPPORTING_EXTERNAL_ENTITIES = 'javax.xml.stream.isSupportingExternalEntities';
      SUPPORT_DTD = 'javax.xml.stream.supportDTD';
      REPORTER = 'javax.xml.stream.reporter';
      RESOLVER = 'javax.xml.stream.resolver';
      ALLOCATOR = 'javax.xml.stream.allocator';
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXSXMLInputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newFactory(): JXSXMLInputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newInstance(para1: JLString; para2: JLClassLoader): JXSXMLInputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newFactory(para1: JLString; para2: JLClassLoader): JXSXMLInputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    function createXMLStreamReader(para1: JIReader): JXSXMLStreamReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamReader(para1: JXTSource): JXSXMLStreamReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamReader(para1: JIInputStream): JXSXMLStreamReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamReader(para1: JIInputStream; para2: JLString): JXSXMLStreamReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamReader(para1: JLString; para2: JIInputStream): JXSXMLStreamReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamReader(para1: JLString; para2: JIReader): JXSXMLStreamReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventReader(para1: JIReader): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventReader(para1: JLString; para2: JIReader): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventReader(para1: JXSXMLStreamReader): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventReader(para1: JXTSource): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventReader(para1: JIInputStream): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventReader(para1: JIInputStream; para2: JLString): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventReader(para1: JLString; para2: JIInputStream): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createFilteredReader(para1: JXSXMLStreamReader; para2: JXSStreamFilter): JXSXMLStreamReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createFilteredReader(para1: JXSXMLEventReader; para2: JXSEventFilter): JXSXMLEventReader; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function getXMLResolver(): JXSXMLResolver; overload; virtual; abstract;
    procedure setXMLResolver(para1: JXSXMLResolver); overload; virtual; abstract;
    function getXMLReporter(): JXSXMLReporter; overload; virtual; abstract;
    procedure setXMLReporter(para1: JXSXMLReporter); overload; virtual; abstract;
    procedure setProperty(para1: JLString; para2: JLObject); overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    function getProperty(para1: JLString): JLObject; overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    function isPropertySupported(para1: JLString): jboolean; overload; virtual; abstract;
    procedure setEventAllocator(para1: JXSUXMLEventAllocator); overload; virtual; abstract;
    function getEventAllocator(): JXSUXMLEventAllocator; overload; virtual; abstract;
  end;

  JXSXMLOutputFactory = class abstract external 'javax.xml.stream' name 'XMLOutputFactory' (JLObject)
  public
    const
      IS_REPAIRING_NAMESPACES = 'javax.xml.stream.isRepairingNamespaces';
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXSXMLOutputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newFactory(): JXSXMLOutputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newInstance(para1: JLString; para2: JLClassLoader): JXSXMLInputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    class function newFactory(para1: JLString; para2: JLClassLoader): JXSXMLOutputFactory; static; overload;  // throws javax.xml.stream.FactoryConfigurationError
    function createXMLStreamWriter(para1: JIWriter): JXSXMLStreamWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamWriter(para1: JIOutputStream): JXSXMLStreamWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamWriter(para1: JIOutputStream; para2: JLString): JXSXMLStreamWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLStreamWriter(para1: JXTResult): JXSXMLStreamWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventWriter(para1: JXTResult): JXSXMLEventWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventWriter(para1: JIOutputStream): JXSXMLEventWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventWriter(para1: JIOutputStream; para2: JLString): JXSXMLEventWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    function createXMLEventWriter(para1: JIWriter): JXSXMLEventWriter; overload; virtual; abstract;  // throws javax.xml.stream.XMLStreamException
    procedure setProperty(para1: JLString; para2: JLObject); overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    function getProperty(para1: JLString): JLObject; overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    function isPropertySupported(para1: JLString): jboolean; overload; virtual; abstract;
  end;

  JXSXMLReporter = interface external 'javax.xml.stream' name 'XMLReporter' 
    procedure report(para1: JLString; para2: JLString; para3: JLObject; para4: JXSLocation); overload;  // throws javax.xml.stream.XMLStreamException
  end;

  JXSXMLResolver = interface external 'javax.xml.stream' name 'XMLResolver' 
    function resolveEntity(para1: JLString; para2: JLString; para3: JLString; para4: JLString): JLObject; overload;  // throws javax.xml.stream.XMLStreamException
  end;

  JXSXMLStreamConstants = interface external 'javax.xml.stream' name 'XMLStreamConstants' 
    const
      START_ELEMENT = 1;
      END_ELEMENT = 2;
      PROCESSING_INSTRUCTION = 3;
      CHARACTERS = 4;
      COMMENT = 5;
      SPACE = 6;
      START_DOCUMENT = 7;
      END_DOCUMENT = 8;
      ENTITY_REFERENCE = 9;
      ATTRIBUTE = 10;
      DTD = 11;
      CDATA = 12;
      NAMESPACE = 13;
      NOTATION_DECLARATION = 14;
      ENTITY_DECLARATION = 15;
  end;

  JXSXMLStreamWriter = interface external 'javax.xml.stream' name 'XMLStreamWriter' 
    procedure writeStartElement(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeStartElement(para1: JLString; para2: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeStartElement(para1: JLString; para2: JLString; para3: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeEmptyElement(para1: JLString; para2: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeEmptyElement(para1: JLString; para2: JLString; para3: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeEmptyElement(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeEndElement(); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeEndDocument(); overload;  // throws javax.xml.stream.XMLStreamException
    procedure close(); overload;  // throws javax.xml.stream.XMLStreamException
    procedure flush(); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeAttribute(para1: JLString; para2: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeAttribute(para1: JLString; para2: JLString; para3: JLString; para4: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeAttribute(para1: JLString; para2: JLString; para3: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeNamespace(para1: JLString; para2: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeDefaultNamespace(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeComment(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeProcessingInstruction(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeProcessingInstruction(para1: JLString; para2: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeCData(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeDTD(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeEntityRef(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeStartDocument(); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeStartDocument(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeStartDocument(para1: JLString; para2: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeCharacters(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeCharacters(para1: Arr1jchar; para2: jint; para3: jint); overload;  // throws javax.xml.stream.XMLStreamException
    procedure writeCharacters(var para1: array of jchar; para2: jint; para3: jint); overload;  // throws javax.xml.stream.XMLStreamException
    function getPrefix(para1: JLString): JLString; overload;  // throws javax.xml.stream.XMLStreamException
    procedure setPrefix(para1: JLString; para2: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure setDefaultNamespace(para1: JLString); overload;  // throws javax.xml.stream.XMLStreamException
    procedure setNamespaceContext(para1: JXNNamespaceContext); overload;  // throws javax.xml.stream.XMLStreamException
    function getNamespaceContext(): JXNNamespaceContext; overload;
    function getProperty(para1: JLString): JLObject; overload;  // throws java.lang.IllegalArgumentException
  end;

  JXSUXMLEventAllocator = interface external 'javax.xml.stream.util' name 'XMLEventAllocator' 
    function newInstance(): JXSUXMLEventAllocator; overload;
    function allocate(para1: JXSXMLStreamReader): JXSEXMLEvent; overload;  // throws javax.xml.stream.XMLStreamException
    procedure allocate(para1: JXSXMLStreamReader; para2: JXSUXMLEventConsumer); overload;  // throws javax.xml.stream.XMLStreamException
  end;

  JXSUXMLEventConsumer = interface external 'javax.xml.stream.util' name 'XMLEventConsumer' 
    procedure add(para1: JXSEXMLEvent); overload;  // throws javax.xml.stream.XMLStreamException
  end;

  JXTErrorListener = interface external 'javax.xml.transform' name 'ErrorListener' 
    procedure warning(para1: JXTTransformerException); overload;  // throws javax.xml.transform.TransformerException
    procedure error(para1: JXTTransformerException); overload;  // throws javax.xml.transform.TransformerException
    procedure fatalError(para1: JXTTransformerException); overload;  // throws javax.xml.transform.TransformerException
  end;

  JXTFactoryFinder = class external 'javax.xml.transform' name 'FactoryFinder' (JLObject)
  public
    type
      InnerConfigurationError = class;
      Arr1InnerConfigurationError = array of InnerConfigurationError;
      Arr2InnerConfigurationError = array of Arr1InnerConfigurationError;
      Arr3InnerConfigurationError = array of Arr2InnerConfigurationError;
      InnerConfigurationError = class external 'javax.xml.transform' name 'ConfigurationError' 
      end;

  end;

  JXTOutputKeys = class external 'javax.xml.transform' name 'OutputKeys' (JLObject)
  public
    const
      METHOD = 'method';
      VERSION = 'version';
      ENCODING = 'encoding';
      OMIT_XML_DECLARATION = 'omit-xml-declaration';
      STANDALONE = 'standalone';
      DOCTYPE_PUBLIC = 'doctype-public';
      DOCTYPE_SYSTEM = 'doctype-system';
      CDATA_SECTION_ELEMENTS = 'cdata-section-elements';
      INDENT = 'indent';
      MEDIA_TYPE = 'media-type';
  end;

  JXTResult = interface external 'javax.xml.transform' name 'Result' 
    const
      PI_DISABLE_OUTPUT_ESCAPING = 'javax.xml.transform.disable-output-escaping';
      PI_ENABLE_OUTPUT_ESCAPING = 'javax.xml.transform.enable-output-escaping';
    procedure setSystemId(para1: JLString); overload;
    function getSystemId(): JLString; overload;
  end;

  JXTSecuritySupport = class external 'javax.xml.transform' name 'SecuritySupport' (JLObject)
  end;

  JXTSource = interface external 'javax.xml.transform' name 'Source' 
    procedure setSystemId(para1: JLString); overload;
    function getSystemId(): JLString; overload;
  end;

  JXTSourceLocator = interface external 'javax.xml.transform' name 'SourceLocator' 
    function getPublicId(): JLString; overload;
    function getSystemId(): JLString; overload;
    function getLineNumber(): jint; overload;
    function getColumnNumber(): jint; overload;
  end;

  JXTTemplates = interface external 'javax.xml.transform' name 'Templates' 
    function newTransformer(): JXTTransformer; overload;  // throws javax.xml.transform.TransformerConfigurationException
    function getOutputProperties(): JUProperties; overload;
  end;

  JXTTransformer = class abstract external 'javax.xml.transform' name 'Transformer' (JLObject)
  strict protected
    constructor create(); overload;
  public
    procedure reset(); overload; virtual;
    procedure transform(para1: JXTSource; para2: JXTResult); overload; virtual; abstract;  // throws javax.xml.transform.TransformerException
    procedure setParameter(para1: JLString; para2: JLObject); overload; virtual; abstract;
    function getParameter(para1: JLString): JLObject; overload; virtual; abstract;
    procedure clearParameters(); overload; virtual; abstract;
    procedure setURIResolver(para1: JXTURIResolver); overload; virtual; abstract;
    function getURIResolver(): JXTURIResolver; overload; virtual; abstract;
    procedure setOutputProperties(para1: JUProperties); overload; virtual; abstract;
    function getOutputProperties(): JUProperties; overload; virtual; abstract;
    procedure setOutputProperty(para1: JLString; para2: JLString); overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    function getOutputProperty(para1: JLString): JLString; overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    procedure setErrorListener(para1: JXTErrorListener); overload; virtual; abstract;  // throws java.lang.IllegalArgumentException
    function getErrorListener(): JXTErrorListener; overload; virtual; abstract;
  end;

  JXTTransformerFactory = class abstract external 'javax.xml.transform' name 'TransformerFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXTTransformerFactory; static; overload;  // throws javax.xml.transform.TransformerFactoryConfigurationError
    class function newInstance(para1: JLString; para2: JLClassLoader): JXTTransformerFactory; static; overload;  // throws javax.xml.transform.TransformerFactoryConfigurationError
    function newTransformer(para1: JXTSource): JXTTransformer; overload; virtual; abstract;  // throws javax.xml.transform.TransformerConfigurationException
    function newTransformer(): JXTTransformer; overload; virtual; abstract;  // throws javax.xml.transform.TransformerConfigurationException
    function newTemplates(para1: JXTSource): JXTTemplates; overload; virtual; abstract;  // throws javax.xml.transform.TransformerConfigurationException
    function getAssociatedStylesheet(para1: JXTSource; para2: JLString; para3: JLString; para4: JLString): JXTSource; overload; virtual; abstract;  // throws javax.xml.transform.TransformerConfigurationException
    procedure setURIResolver(para1: JXTURIResolver); overload; virtual; abstract;
    function getURIResolver(): JXTURIResolver; overload; virtual; abstract;
    procedure setFeature(para1: JLString; para2: jboolean); overload; virtual; abstract;  // throws javax.xml.transform.TransformerConfigurationException
    function getFeature(para1: JLString): jboolean; overload; virtual; abstract;
    procedure setAttribute(para1: JLString; para2: JLObject); overload; virtual; abstract;
    function getAttribute(para1: JLString): JLObject; overload; virtual; abstract;
    procedure setErrorListener(para1: JXTErrorListener); overload; virtual; abstract;
    function getErrorListener(): JXTErrorListener; overload; virtual; abstract;
  end;

  JXTURIResolver = interface external 'javax.xml.transform' name 'URIResolver' 
    function resolve(para1: JLString; para2: JLString): JXTSource; overload;  // throws javax.xml.transform.TransformerException
  end;

  JXVSchema = class abstract external 'javax.xml.validation' name 'Schema' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function newValidator(): JXVValidator; overload; virtual; abstract;
    function newValidatorHandler(): JXVValidatorHandler; overload; virtual; abstract;
  end;

  JXVSchemaFactory = class abstract external 'javax.xml.validation' name 'SchemaFactory' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function newInstance(para1: JLString): JXVSchemaFactory; static; overload; final;
    class function newInstance(para1: JLString; para2: JLString; para3: JLClassLoader): JXVSchemaFactory; static; overload;
    function isSchemaLanguageSupported(para1: JLString): jboolean; overload; virtual; abstract;
    function getFeature(para1: JLString): jboolean; overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setFeature(para1: JLString; para2: jboolean); overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setProperty(para1: JLString; para2: JLObject); overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    function getProperty(para1: JLString): JLObject; overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setErrorHandler(para1: OXSErrorHandler); overload; virtual; abstract;
    function getErrorHandler(): OXSErrorHandler; overload; virtual; abstract;
    procedure setResourceResolver(para1: OWDLLSResourceResolver); overload; virtual; abstract;
    function getResourceResolver(): OWDLLSResourceResolver; overload; virtual; abstract;
    function newSchema(para1: JXTSource): JXVSchema; overload; virtual;  // throws org.xml.sax.SAXException
    function newSchema(para1: JIFile): JXVSchema; overload; virtual;  // throws org.xml.sax.SAXException
    function newSchema(para1: JNURL): JXVSchema; overload; virtual;  // throws org.xml.sax.SAXException
    function newSchema(para1: Arr1JXTSource): JXVSchema; overload; virtual; abstract;  // throws org.xml.sax.SAXException
    function newSchema(var para1: array of JXTSource): JXVSchema; overload; virtual; abstract;  // throws org.xml.sax.SAXException
    function newSchema(): JXVSchema; overload; virtual; abstract;  // throws org.xml.sax.SAXException
  end;

  JXVSchemaFactoryFinder = class external 'javax.xml.validation' name 'SchemaFactoryFinder' (JLObject)
  public
    type
      InnerSingleIterator = class;
      Arr1InnerSingleIterator = array of InnerSingleIterator;
      Arr2InnerSingleIterator = array of Arr1InnerSingleIterator;
      Arr3InnerSingleIterator = array of Arr2InnerSingleIterator;
      InnerSingleIterator = class abstract external 'javax.xml.validation' name 'SingleIterator' 
      end;

  public
    constructor create(para1: JLClassLoader); overload;
    function newFactory(para1: JLString): JXVSchemaFactory; overload; virtual;
  end;

  JXVSchemaFactoryLoader = class abstract external 'javax.xml.validation' name 'SchemaFactoryLoader' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function newFactory(para1: JLString): JXVSchemaFactory; overload; virtual; abstract;
  end;

  JXVSecuritySupport = class external 'javax.xml.validation' name 'SecuritySupport' (JLObject)
  end;

  JXVTypeInfoProvider = class abstract external 'javax.xml.validation' name 'TypeInfoProvider' (JLObject)
  strict protected
    constructor create(); overload;
  public
    function getElementTypeInfo(): OWDTypeInfo; overload; virtual; abstract;
    function getAttributeTypeInfo(para1: jint): OWDTypeInfo; overload; virtual; abstract;
    function isIdAttribute(para1: jint): jboolean; overload; virtual; abstract;
    function isSpecified(para1: jint): jboolean; overload; virtual; abstract;
  end;

  JXVValidator = class abstract external 'javax.xml.validation' name 'Validator' (JLObject)
  strict protected
    constructor create(); overload;
  public
    procedure reset(); overload; virtual; abstract;
    procedure validate(para1: JXTSource); overload; virtual;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure validate(para1: JXTSource; para2: JXTResult); overload; virtual; abstract;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure setErrorHandler(para1: OXSErrorHandler); overload; virtual; abstract;
    function getErrorHandler(): OXSErrorHandler; overload; virtual; abstract;
    procedure setResourceResolver(para1: OWDLLSResourceResolver); overload; virtual; abstract;
    function getResourceResolver(): OWDLLSResourceResolver; overload; virtual; abstract;
    function getFeature(para1: JLString): jboolean; overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setFeature(para1: JLString; para2: jboolean); overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setProperty(para1: JLString; para2: JLObject); overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    function getProperty(para1: JLString): JLObject; overload; virtual;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
  end;

  JXWAsyncHandler = interface external 'javax.xml.ws' name 'AsyncHandler' 
    procedure handleResponse(para1: JXWResponse); overload;
  end;

  JXWBinding = interface external 'javax.xml.ws' name 'Binding' 
    function getHandlerChain(): JUList; overload;
    procedure setHandlerChain(para1: JUList); overload;
    function getBindingID(): JLString; overload;
  end;

  JXWBindingProvider = interface external 'javax.xml.ws' name 'BindingProvider' 
    const
      USERNAME_PROPERTY = 'javax.xml.ws.security.auth.username';
      PASSWORD_PROPERTY = 'javax.xml.ws.security.auth.password';
      ENDPOINT_ADDRESS_PROPERTY = 'javax.xml.ws.service.endpoint.address';
      SESSION_MAINTAIN_PROPERTY = 'javax.xml.ws.session.maintain';
      SOAPACTION_USE_PROPERTY = 'javax.xml.ws.soap.http.soapaction.use';
      SOAPACTION_URI_PROPERTY = 'javax.xml.ws.soap.http.soapaction.uri';
    function getRequestContext(): JUMap; overload;
    function getResponseContext(): JUMap; overload;
    function getBinding(): JXWBinding; overload;
    function getEndpointReference(): JXWEndpointReference; overload;
    function getEndpointReference(para1: JLClass): JXWEndpointReference; overload;
  end;

  JXWEndpoint = class abstract external 'javax.xml.ws' name 'Endpoint' (JLObject)
  public
    const
      WSDL_SERVICE = 'javax.xml.ws.wsdl.service';
      WSDL_PORT = 'javax.xml.ws.wsdl.port';
  public
    constructor create(); overload;
    class function create_(para1: JLObject): JXWEndpoint; static; external name 'create'; overload;
    class function create_(para1: JLString; para2: JLObject): JXWEndpoint; static; external name 'create'; overload;
    function getBinding(): JXWBinding; overload; virtual; abstract;
    function getImplementor(): JLObject; overload; virtual; abstract;
    procedure publish(para1: JLString); overload; virtual; abstract;
    class function publish(para1: JLString; para2: JLObject): JXWEndpoint; static; overload;
    procedure publish(para1: JLObject); overload; virtual; abstract;
    procedure stop(); overload; virtual; abstract;
    function isPublished(): jboolean; overload; virtual; abstract;
    function getMetadata(): JUList; overload; virtual; abstract;
    procedure setMetadata(para1: JUList); overload; virtual; abstract;
    function getExecutor(): JUCExecutor; overload; virtual; abstract;
    procedure setExecutor(para1: JUCExecutor); overload; virtual; abstract;
    function getProperties(): JUMap; overload; virtual; abstract;
    procedure setProperties(para1: JUMap); overload; virtual; abstract;
    function getEndpointReference(para1: Arr1OWDElement): JXWEndpointReference; overload; virtual; abstract;
    function getEndpointReference(const para1: array of OWDElement): JXWEndpointReference; overload; virtual; abstract;
    function getEndpointReference(para1: JLClass; para2: Arr1OWDElement): JXWEndpointReference; overload; virtual; abstract;
    function getEndpointReference(para1: JLClass; const para2: array of OWDElement): JXWEndpointReference; overload; virtual; abstract;
  end;

  JXWEndpointReference = class abstract external 'javax.xml.ws' name 'EndpointReference' (JLObject)
  strict protected
    constructor create(); overload;
  public
    class function readFrom(para1: JXTSource): JXWEndpointReference; static; overload;
    procedure writeTo(para1: JXTResult); overload; virtual; abstract;
    function getPort(para1: JLClass; para2: Arr1JXWWebServiceFeature): JLObject; overload; virtual;
    function getPort(para1: JLClass; const para2: array of JXWWebServiceFeature): JLObject; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JXWHolder = class sealed external 'javax.xml.ws' name 'Holder' (JLObject)
  public
    var
      fvalue: JLObject; external name 'value';
  public
    constructor create(); overload;
    constructor create(para1: JLObject); overload;
  end;

  JXWLogicalMessage = interface external 'javax.xml.ws' name 'LogicalMessage' 
    function getPayload(): JXTSource; overload;
    procedure setPayload(para1: JXTSource); overload;
    function getPayload(para1: JXBJAXBContext): JLObject; overload;
    procedure setPayload(para1: JLObject; para2: JXBJAXBContext); overload;
  end;

  JXWProvider = interface external 'javax.xml.ws' name 'Provider' 
    function invoke(para1: JLObject): JLObject; overload;
  end;

  JXWWebServiceContext = interface external 'javax.xml.ws' name 'WebServiceContext' 
    function getMessageContext(): JXWHMessageContext; overload;
    function getUserPrincipal(): JSPrincipal; overload;
    function isUserInRole(para1: JLString): jboolean; overload;
    function getEndpointReference(para1: Arr1OWDElement): JXWEndpointReference; overload;
    function getEndpointReference(const para1: array of OWDElement): JXWEndpointReference; overload;
    function getEndpointReference(para1: JLClass; para2: Arr1OWDElement): JXWEndpointReference; overload;
    function getEndpointReference(para1: JLClass; const para2: array of OWDElement): JXWEndpointReference; overload;
  end;

  JXWWebServiceFeature = class abstract external 'javax.xml.ws' name 'WebServiceFeature' (JLObject)
  strict protected
    var
      fenabled: jboolean; external name 'enabled';
  public
    function getID(): JLString; overload; virtual; abstract;
  strict protected
    constructor create(); overload;
  public
    function isEnabled(): jboolean; overload; virtual;
  end;

  JXWHHandler = interface external 'javax.xml.ws.handler' name 'Handler' 
    function handleMessage(para1: JXWHMessageContext): jboolean; overload;
    function handleFault(para1: JXWHMessageContext): jboolean; overload;
    procedure close(para1: JXWHMessageContext); overload;
  end;

  JXWHHandlerResolver = interface external 'javax.xml.ws.handler' name 'HandlerResolver' 
    function getHandlerChain(para1: JXWHPortInfo): JUList; overload;
  end;

  JXWHPortInfo = interface external 'javax.xml.ws.handler' name 'PortInfo' 
    function getServiceName(): JXNQName; overload;
    function getPortName(): JXNQName; overload;
    function getBindingID(): JLString; overload;
  end;

  JXWSFactoryFinder = class external 'javax.xml.ws.spi' name 'FactoryFinder' (JLObject)
  end;

  JXWSProvider = class abstract external 'javax.xml.ws.spi' name 'Provider' (JLObject)
  public
    const
      JAXWSPROVIDER_PROPERTY = 'javax.xml.ws.spi.Provider';
  strict protected
    constructor create(); overload;
  public
    class function provider(): JXWSProvider; static; overload;
    function createServiceDelegate(para1: JNURL; para2: JXNQName; para3: JLClass): JXWSServiceDelegate; overload; virtual; abstract;
    function createEndpoint(para1: JLString; para2: JLObject): JXWEndpoint; overload; virtual; abstract;
    function createAndPublishEndpoint(para1: JLString; para2: JLObject): JXWEndpoint; overload; virtual; abstract;
    function readEndpointReference(para1: JXTSource): JXWEndpointReference; overload; virtual; abstract;
    function getPort(para1: JXWEndpointReference; para2: JLClass; para3: Arr1JXWWebServiceFeature): JLObject; overload; virtual; abstract;
    function getPort(para1: JXWEndpointReference; para2: JLClass; const para3: array of JXWWebServiceFeature): JLObject; overload; virtual; abstract;
    function createW3CEndpointReference(para1: JLString; para2: JXNQName; para3: JXNQName; para4: JUList; para5: JLString; para6: JUList): JXWWW3CEndpointReference; overload; virtual; abstract;
  end;

  JXWWW3CEndpointReferenceBuilder = class sealed external 'javax.xml.ws.wsaddressing' name 'W3CEndpointReferenceBuilder' (JLObject)
  public
    constructor create(); overload;
    function address(para1: JLString): JXWWW3CEndpointReferenceBuilder; overload; virtual;
    function serviceName(para1: JXNQName): JXWWW3CEndpointReferenceBuilder; overload; virtual;
    function endpointName(para1: JXNQName): JXWWW3CEndpointReferenceBuilder; overload; virtual;
    function wsdlDocumentLocation(para1: JLString): JXWWW3CEndpointReferenceBuilder; overload; virtual;
    function referenceParameter(para1: OWDElement): JXWWW3CEndpointReferenceBuilder; overload; virtual;
    function metadata(para1: OWDElement): JXWWW3CEndpointReferenceBuilder; overload; virtual;
    function build(): JXWWW3CEndpointReference; overload; virtual;
  end;

  JXWWpackage_info = interface external 'javax.xml.ws.wsaddressing' name 'package-info' 
  end;

  JXXSecuritySupport = class external 'javax.xml.xpath' name 'SecuritySupport' (JLObject)
  end;

  JXXXPath = interface external 'javax.xml.xpath' name 'XPath' 
    procedure reset(); overload;
    procedure setXPathVariableResolver(para1: JXXXPathVariableResolver); overload;
    function getXPathVariableResolver(): JXXXPathVariableResolver; overload;
    procedure setXPathFunctionResolver(para1: JXXXPathFunctionResolver); overload;
    function getXPathFunctionResolver(): JXXXPathFunctionResolver; overload;
    procedure setNamespaceContext(para1: JXNNamespaceContext); overload;
    function getNamespaceContext(): JXNNamespaceContext; overload;
    function compile(para1: JLString): JXXXPathExpression; overload;  // throws javax.xml.xpath.XPathExpressionException
    function evaluate(para1: JLString; para2: JLObject; para3: JXNQName): JLObject; overload;  // throws javax.xml.xpath.XPathExpressionException
    function evaluate(para1: JLString; para2: JLObject): JLString; overload;  // throws javax.xml.xpath.XPathExpressionException
    function evaluate(para1: JLString; para2: OXSInputSource; para3: JXNQName): JLObject; overload;  // throws javax.xml.xpath.XPathExpressionException
    function evaluate(para1: JLString; para2: OXSInputSource): JLString; overload;  // throws javax.xml.xpath.XPathExpressionException
  end;

  JXXXPathConstants = class external 'javax.xml.xpath' name 'XPathConstants' (JLObject)
  public
    final class var
      fNUMBER: JXNQName; external name 'NUMBER';
      fSTRING: JXNQName; external name 'STRING';
      fBOOLEAN: JXNQName; external name 'BOOLEAN';
      fNODESET: JXNQName; external name 'NODESET';
      fNODE: JXNQName; external name 'NODE';
  public
    const
      DOM_OBJECT_MODEL = 'http://java.sun.com/jaxp/xpath/dom';
  end;

  JXXXPathExpression = interface external 'javax.xml.xpath' name 'XPathExpression' 
    function evaluate(para1: JLObject; para2: JXNQName): JLObject; overload;  // throws javax.xml.xpath.XPathExpressionException
    function evaluate(para1: JLObject): JLString; overload;  // throws javax.xml.xpath.XPathExpressionException
    function evaluate(para1: OXSInputSource; para2: JXNQName): JLObject; overload;  // throws javax.xml.xpath.XPathExpressionException
    function evaluate(para1: OXSInputSource): JLString; overload;  // throws javax.xml.xpath.XPathExpressionException
  end;

  JXXXPathFactory = class abstract external 'javax.xml.xpath' name 'XPathFactory' (JLObject)
  public
    const
      DEFAULT_PROPERTY_NAME = 'javax.xml.xpath.XPathFactory';
      DEFAULT_OBJECT_MODEL_URI = 'http://java.sun.com/jaxp/xpath/dom';
  strict protected
    constructor create(); overload;
  public
    class function newInstance(): JXXXPathFactory; static; overload; final;
    class function newInstance(para1: JLString): JXXXPathFactory; static; overload; final;  // throws javax.xml.xpath.XPathFactoryConfigurationException
    class function newInstance(para1: JLString; para2: JLString; para3: JLClassLoader): JXXXPathFactory; static; overload;  // throws javax.xml.xpath.XPathFactoryConfigurationException
    function isObjectModelSupported(para1: JLString): jboolean; overload; virtual; abstract;
    procedure setFeature(para1: JLString; para2: jboolean); overload; virtual; abstract;  // throws javax.xml.xpath.XPathFactoryConfigurationException
    function getFeature(para1: JLString): jboolean; overload; virtual; abstract;  // throws javax.xml.xpath.XPathFactoryConfigurationException
    procedure setXPathVariableResolver(para1: JXXXPathVariableResolver); overload; virtual; abstract;
    procedure setXPathFunctionResolver(para1: JXXXPathFunctionResolver); overload; virtual; abstract;
    function newXPath(): JXXXPath; overload; virtual; abstract;
  end;

  JXXXPathFactoryFinder = class external 'javax.xml.xpath' name 'XPathFactoryFinder' (JLObject)
  public
    type
      InnerSingleIterator = class;
      Arr1InnerSingleIterator = array of InnerSingleIterator;
      Arr2InnerSingleIterator = array of Arr1InnerSingleIterator;
      Arr3InnerSingleIterator = array of Arr2InnerSingleIterator;
      InnerSingleIterator = class abstract external 'javax.xml.xpath' name 'SingleIterator' 
      end;

  public
    constructor create(para1: JLClassLoader); overload;
    function newFactory(para1: JLString): JXXXPathFactory; overload; virtual;
  end;

  JXXXPathFunction = interface external 'javax.xml.xpath' name 'XPathFunction' 
    function evaluate(para1: JUList): JLObject; overload;  // throws javax.xml.xpath.XPathFunctionException
  end;

  JXXXPathFunctionResolver = interface external 'javax.xml.xpath' name 'XPathFunctionResolver' 
    function resolveFunction(para1: JXNQName; para2: jint): JXXXPathFunction; overload;
  end;

  JXXXPathVariableResolver = interface external 'javax.xml.xpath' name 'XPathVariableResolver' 
    function resolveVariable(para1: JXNQName): JLObject; overload;
  end;

  OIJChannelBinding = class external 'org.ietf.jgss' name 'ChannelBinding' (JLObject)
  public
    constructor create(para1: JNInetAddress; para2: JNInetAddress; para3: Arr1jbyte); overload;
    constructor create(para1: JNInetAddress; para2: JNInetAddress; const para3: array of jbyte); overload;
    constructor create(para1: Arr1jbyte); overload;
    constructor create(const para1: array of jbyte); overload;
    function getInitiatorAddress(): JNInetAddress; overload; virtual;
    function getAcceptorAddress(): JNInetAddress; overload; virtual;
    function getApplicationData(): Arr1jbyte; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  OIJGSSContext = interface external 'org.ietf.jgss' name 'GSSContext' 
    const
      DEFAULT_LIFETIME = 0;
      INDEFINITE_LIFETIME = 2147483647;
    function initSecContext(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    function initSecContext(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    function initSecContext(para1: JIInputStream; para2: JIOutputStream): jint; overload;  // throws org.ietf.jgss.GSSException
    function acceptSecContext(para1: Arr1jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    function acceptSecContext(var para1: array of jbyte; para2: jint; para3: jint): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    procedure acceptSecContext(para1: JIInputStream; para2: JIOutputStream); overload;  // throws org.ietf.jgss.GSSException
    function isEstablished(): jboolean; overload;
    procedure dispose(); overload;  // throws org.ietf.jgss.GSSException
    function getWrapSizeLimit(para1: jint; para2: jboolean; para3: jint): jint; overload;  // throws org.ietf.jgss.GSSException
    function wrap(para1: Arr1jbyte; para2: jint; para3: jint; para4: OIJMessageProp): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    function wrap(var para1: array of jbyte; para2: jint; para3: jint; para4: OIJMessageProp): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    procedure wrap(para1: JIInputStream; para2: JIOutputStream; para3: OIJMessageProp); overload;  // throws org.ietf.jgss.GSSException
    function unwrap(para1: Arr1jbyte; para2: jint; para3: jint; para4: OIJMessageProp): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    function unwrap(var para1: array of jbyte; para2: jint; para3: jint; para4: OIJMessageProp): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    procedure unwrap(para1: JIInputStream; para2: JIOutputStream; para3: OIJMessageProp); overload;  // throws org.ietf.jgss.GSSException
    function getMIC(para1: Arr1jbyte; para2: jint; para3: jint; para4: OIJMessageProp): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    function getMIC(var para1: array of jbyte; para2: jint; para3: jint; para4: OIJMessageProp): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    procedure getMIC(para1: JIInputStream; para2: JIOutputStream; para3: OIJMessageProp); overload;  // throws org.ietf.jgss.GSSException
    procedure verifyMIC(para1: Arr1jbyte; para2: jint; para3: jint; para4: Arr1jbyte; para5: jint; para6: jint; para7: OIJMessageProp); overload;  // throws org.ietf.jgss.GSSException
    procedure verifyMIC(var para1: array of jbyte; para2: jint; para3: jint; var para4: array of jbyte; para5: jint; para6: jint; para7: OIJMessageProp); overload;  // throws org.ietf.jgss.GSSException
    procedure verifyMIC(para1: JIInputStream; para2: JIInputStream; para3: OIJMessageProp); overload;  // throws org.ietf.jgss.GSSException
    function export(): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    procedure requestMutualAuth(para1: jboolean); overload;  // throws org.ietf.jgss.GSSException
    procedure requestReplayDet(para1: jboolean); overload;  // throws org.ietf.jgss.GSSException
    procedure requestSequenceDet(para1: jboolean); overload;  // throws org.ietf.jgss.GSSException
    procedure requestCredDeleg(para1: jboolean); overload;  // throws org.ietf.jgss.GSSException
    procedure requestAnonymity(para1: jboolean); overload;  // throws org.ietf.jgss.GSSException
    procedure requestConf(para1: jboolean); overload;  // throws org.ietf.jgss.GSSException
    procedure requestInteg(para1: jboolean); overload;  // throws org.ietf.jgss.GSSException
    procedure requestLifetime(para1: jint); overload;  // throws org.ietf.jgss.GSSException
    procedure setChannelBinding(para1: OIJChannelBinding); overload;  // throws org.ietf.jgss.GSSException
    function getCredDelegState(): jboolean; overload;
    function getMutualAuthState(): jboolean; overload;
    function getReplayDetState(): jboolean; overload;
    function getSequenceDetState(): jboolean; overload;
    function getAnonymityState(): jboolean; overload;
    function isTransferable(): jboolean; overload;  // throws org.ietf.jgss.GSSException
    function isProtReady(): jboolean; overload;
    function getConfState(): jboolean; overload;
    function getIntegState(): jboolean; overload;
    function getLifetime(): jint; overload;
    function getSrcName(): OIJGSSName; overload;  // throws org.ietf.jgss.GSSException
    function getTargName(): OIJGSSName; overload;  // throws org.ietf.jgss.GSSException
    function getMech(): OIJOid; overload;  // throws org.ietf.jgss.GSSException
    function getDelegCred(): OIJGSSCredential; overload;  // throws org.ietf.jgss.GSSException
    function isInitiator(): jboolean; overload;  // throws org.ietf.jgss.GSSException
  end;

  OIJGSSManager = class abstract external 'org.ietf.jgss' name 'GSSManager' (JLObject)
  public
    constructor create(); overload;
    class function getInstance(): OIJGSSManager; static; overload;
    function getMechs(): Arr1OIJOid; overload; virtual; abstract;
    function getNamesForMech(para1: OIJOid): Arr1OIJOid; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function getMechsForName(para1: OIJOid): Arr1OIJOid; overload; virtual; abstract;
    function createName(para1: JLString; para2: OIJOid): OIJGSSName; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createName(para1: Arr1jbyte; para2: OIJOid): OIJGSSName; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createName(var para1: array of jbyte; para2: OIJOid): OIJGSSName; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createName(para1: JLString; para2: OIJOid; para3: OIJOid): OIJGSSName; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createName(para1: Arr1jbyte; para2: OIJOid; para3: OIJOid): OIJGSSName; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createName(var para1: array of jbyte; para2: OIJOid; para3: OIJOid): OIJGSSName; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createCredential(para1: jint): OIJGSSCredential; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createCredential(para1: OIJGSSName; para2: jint; para3: OIJOid; para4: jint): OIJGSSCredential; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createCredential(para1: OIJGSSName; para2: jint; para3: Arr1OIJOid; para4: jint): OIJGSSCredential; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createCredential(para1: OIJGSSName; para2: jint; var para3: array of OIJOid; para4: jint): OIJGSSCredential; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createContext(para1: OIJGSSName; para2: OIJOid; para3: OIJGSSCredential; para4: jint): OIJGSSContext; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createContext(para1: OIJGSSCredential): OIJGSSContext; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createContext(para1: Arr1jbyte): OIJGSSContext; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    function createContext(var para1: array of jbyte): OIJGSSContext; overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    procedure addProviderAtFront(para1: JSProvider; para2: OIJOid); overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
    procedure addProviderAtEnd(para1: JSProvider; para2: OIJOid); overload; virtual; abstract;  // throws org.ietf.jgss.GSSException
  end;

  OIJGSSName = interface external 'org.ietf.jgss' name 'GSSName' 
    final class var
      fNT_HOSTBASED_SERVICE: OIJOid; external name 'NT_HOSTBASED_SERVICE';
      fNT_USER_NAME: OIJOid; external name 'NT_USER_NAME';
      fNT_MACHINE_UID_NAME: OIJOid; external name 'NT_MACHINE_UID_NAME';
      fNT_STRING_UID_NAME: OIJOid; external name 'NT_STRING_UID_NAME';
      fNT_ANONYMOUS: OIJOid; external name 'NT_ANONYMOUS';
      fNT_EXPORT_NAME: OIJOid; external name 'NT_EXPORT_NAME';
    function equals(para1: OIJGSSName): jboolean; overload;  // throws org.ietf.jgss.GSSException
    function equals(para1: JLObject): jboolean; overload;
    function hashCode(): jint; overload;
    function canonicalize(para1: OIJOid): OIJGSSName; overload;  // throws org.ietf.jgss.GSSException
    function export(): Arr1jbyte; overload;  // throws org.ietf.jgss.GSSException
    function toString(): JLString; overload;
    function getStringNameType(): OIJOid; overload;  // throws org.ietf.jgss.GSSException
    function isAnonymous(): jboolean; overload;
    function isMN(): jboolean; overload;
  end;

  OIJMessageProp = class external 'org.ietf.jgss' name 'MessageProp' (JLObject)
  public
    constructor create(para1: jboolean); overload;
    constructor create(para1: jint; para2: jboolean); overload;
    function getQOP(): jint; overload; virtual;
    function getPrivacy(): jboolean; overload; virtual;
    procedure setQOP(para1: jint); overload; virtual;
    procedure setPrivacy(para1: jboolean); overload; virtual;
    function isDuplicateToken(): jboolean; overload; virtual;
    function isOldToken(): jboolean; overload; virtual;
    function isUnseqToken(): jboolean; overload; virtual;
    function isGapToken(): jboolean; overload; virtual;
    function getMinorStatus(): jint; overload; virtual;
    function getMinorString(): JLString; overload; virtual;
    procedure setSupplementaryStates(para1: jboolean; para2: jboolean; para3: jboolean; para4: jboolean; para5: jint; para6: JLString); overload; virtual;
  end;

  OIJOid = class external 'org.ietf.jgss' name 'Oid' (JLObject)
  public
    constructor create(para1: JLString); overload;  // throws org.ietf.jgss.GSSException
    constructor create(para1: JIInputStream); overload;  // throws org.ietf.jgss.GSSException
    constructor create(para1: Arr1jbyte); overload;  // throws org.ietf.jgss.GSSException
    constructor create(const para1: array of jbyte); overload;  // throws org.ietf.jgss.GSSException
    function toString(): JLString; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual;
    function getDER(): Arr1jbyte; overload; virtual;  // throws org.ietf.jgss.GSSException
    function containedIn(para1: Arr1OIJOid): jboolean; overload; virtual;
    function containedIn(var para1: array of OIJOid): jboolean; overload; virtual;
    function hashCode(): jint; overload; virtual;
  end;

  OJXDIDDOMUtils = class external 'org.jcp.xml.dsig.internal.dom' name 'DOMUtils' (JLObject)
  public
    type
      InnerNodeSet = class;
      Arr1InnerNodeSet = array of InnerNodeSet;
      Arr2InnerNodeSet = array of Arr1InnerNodeSet;
      Arr3InnerNodeSet = array of Arr2InnerNodeSet;
      InnerNodeSet = class external 'org.jcp.xml.dsig.internal.dom' name 'NodeSet' 
      end;

  public
    class function getOwnerDocument(para1: OWDNode): OWDDocument; static; overload;
    class function createElement(para1: OWDDocument; para2: JLString; para3: JLString; para4: JLString): OWDElement; static; overload;
    class procedure setAttribute(para1: OWDElement; para2: JLString; para3: JLString); static; overload;
    class procedure setAttributeID(para1: OWDElement; para2: JLString; para3: JLString); static; overload;
    class function getFirstChildElement(para1: OWDNode): OWDElement; static; overload;
    class function getLastChildElement(para1: OWDNode): OWDElement; static; overload;
    class function getNextSiblingElement(para1: OWDNode): OWDElement; static; overload;
    class function getAttributeValue(para1: OWDElement; para2: JLString): JLString; static; overload;
    class function nodeSet(para1: OWDNodeList): JUSet; static; overload;
    class function getNSPrefix(para1: JXCXMLCryptoContext; para2: JLString): JLString; static; overload;
    class function getSignaturePrefix(para1: JXCXMLCryptoContext): JLString; static; overload;
    class procedure removeAllChildren(para1: OWDNode); static; overload;
    class function nodesEqual(para1: OWDNode; para2: OWDNode): jboolean; static; overload;
    class procedure appendChild(para1: OWDNode; para2: OWDNode); static; overload;
    class function paramsEqual(para1: JSSAlgorithmParameterSpec; para2: JSSAlgorithmParameterSpec): jboolean; static; overload;
  end;

  OJXDIDUtils = class sealed external 'org.jcp.xml.dsig.internal.dom' name 'Utils' (JLObject)
  public
    class function readBytesFromStream(para1: JIInputStream): Arr1jbyte; static; overload;  // throws java.io.IOException
    class function parseIdFromSameDocumentURI(para1: JLString): JLString; static; overload;
    class function sameDocumentURI(para1: JLString): jboolean; static; overload;
  end;

  OOCARG_IN = interface external 'org.omg.CORBA' name 'ARG_IN' 
    const
      value = 1;
  end;

  OOCARG_INOUT = interface external 'org.omg.CORBA' name 'ARG_INOUT' 
    const
      value = 3;
  end;

  OOCARG_OUT = interface external 'org.omg.CORBA' name 'ARG_OUT' 
    const
      value = 2;
  end;

  OOCAnySeqHelper = class abstract external 'org.omg.CORBA' name 'AnySeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOCAny); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOCAny); static; overload;
    class function extract(para1: OOCAny): Arr1OOCAny; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOCAny; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOCAny); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOCAny); static; overload;
  end;

  OOCBAD_POLICY = interface external 'org.omg.CORBA' name 'BAD_POLICY' 
    const
      value = 0;
  end;

  OOCBAD_POLICY_TYPE = interface external 'org.omg.CORBA' name 'BAD_POLICY_TYPE' 
    const
      value = 2;
  end;

  OOCBAD_POLICY_VALUE = interface external 'org.omg.CORBA' name 'BAD_POLICY_VALUE' 
    const
      value = 3;
  end;

  OOCBooleanSeqHelper = class abstract external 'org.omg.CORBA' name 'BooleanSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jboolean); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jboolean); static; overload;
    class function extract(para1: OOCAny): Arr1jboolean; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jboolean; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jboolean); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jboolean); static; overload;
  end;

  OOCCTX_RESTRICT_SCOPE = interface external 'org.omg.CORBA' name 'CTX_RESTRICT_SCOPE' 
    const
      value = 15;
  end;

  OOCCharSeqHelper = class abstract external 'org.omg.CORBA' name 'CharSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jchar); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jchar); static; overload;
    class function extract(para1: OOCAny): Arr1jchar; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jchar; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jchar); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jchar); static; overload;
  end;

  OOCCompletionStatusHelper = class abstract external 'org.omg.CORBA' name 'CompletionStatusHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCCompletionStatus); static; overload;
    class function extract(para1: OOCAny): OOCCompletionStatus; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCCompletionStatus; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCCompletionStatus); static; overload;
  end;

  OOCContext = class abstract external 'org.omg.CORBA' name 'Context' (JLObject)
  public
    constructor create(); overload;
    function context_name(): JLString; overload; virtual; abstract;
    function parent(): OOCContext; overload; virtual; abstract;
    function create_child(para1: JLString): OOCContext; overload; virtual; abstract;
    procedure set_one_value(para1: JLString; para2: OOCAny); overload; virtual; abstract;
    procedure set_values(para1: OOCNVList); overload; virtual; abstract;
    procedure delete_values(para1: JLString); overload; virtual; abstract;
    function get_values(para1: JLString; para2: jint; para3: JLString): OOCNVList; overload; virtual; abstract;
  end;

  OOCContextList = class abstract external 'org.omg.CORBA' name 'ContextList' (JLObject)
  public
    constructor create(); overload;
    function count(): jint; overload; virtual; abstract;
    procedure add(para1: JLString); overload; virtual; abstract;
    function item(para1: jint): JLString; overload; virtual; abstract;  // throws org.omg.CORBA.Bounds
    procedure remove(para1: jint); overload; virtual; abstract;  // throws org.omg.CORBA.Bounds
  end;

  OOCCurrentHelper = class abstract external 'org.omg.CORBA' name 'CurrentHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCCurrent); static; overload;
    class function extract(para1: OOCAny): OOCCurrent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCCurrent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCCurrent); static; overload;
    class function narrow(para1: OOCObject): OOCCurrent; static; overload;
  end;

  OOCCurrentOperations = interface external 'org.omg.CORBA' name 'CurrentOperations' 
  end;

  OOCCustomMarshal = interface external 'org.omg.CORBA' name 'CustomMarshal' 
    procedure marshal(para1: OOCDataOutputStream); overload;
    procedure unmarshal(para1: OOCDataInputStream); overload;
  end;

  OOCDefinitionKindHelper = class abstract external 'org.omg.CORBA' name 'DefinitionKindHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCDefinitionKind); static; overload;
    class function extract(para1: OOCAny): OOCDefinitionKind; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCDefinitionKind; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCDefinitionKind); static; overload;
  end;

  OOCDomainManagerOperations = interface external 'org.omg.CORBA' name 'DomainManagerOperations' 
    function get_domain_policy(para1: jint): OOCPolicy; overload;
  end;

  OOCDoubleSeqHelper = class abstract external 'org.omg.CORBA' name 'DoubleSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jdouble); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jdouble); static; overload;
    class function extract(para1: OOCAny): Arr1jdouble; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jdouble; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jdouble); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jdouble); static; overload;
  end;

  OOCEnvironment = class abstract external 'org.omg.CORBA' name 'Environment' (JLObject)
  public
    constructor create(); overload;
    function exception(): JLException; overload; virtual; abstract;
    procedure exception(para1: JLException); overload; virtual; abstract;
    procedure clear(); overload; virtual; abstract;
  end;

  OOCExceptionList = class abstract external 'org.omg.CORBA' name 'ExceptionList' (JLObject)
  public
    constructor create(); overload;
    function count(): jint; overload; virtual; abstract;
    procedure add(para1: OOCTypeCode); overload; virtual; abstract;
    function item(para1: jint): OOCTypeCode; overload; virtual; abstract;  // throws org.omg.CORBA.Bounds
    procedure remove(para1: jint); overload; virtual; abstract;  // throws org.omg.CORBA.Bounds
  end;

  OOCFieldNameHelper = class abstract external 'org.omg.CORBA' name 'FieldNameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCFloatSeqHelper = class abstract external 'org.omg.CORBA' name 'FloatSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jfloat); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jfloat); static; overload;
    class function extract(para1: OOCAny): Arr1jfloat; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jfloat; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jfloat); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jfloat); static; overload;
  end;

  OOCIDLTypeHelper = class abstract external 'org.omg.CORBA' name 'IDLTypeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCIDLType); static; overload;
    class function extract(para1: OOCAny): OOCIDLType; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCIDLType; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCIDLType); static; overload;
    class function narrow(para1: OOCObject): OOCIDLType; static; overload;
  end;

  OOCIRObjectOperations = interface external 'org.omg.CORBA' name 'IRObjectOperations' 
    function def_kind(): OOCDefinitionKind; overload;
    procedure destroy(); overload;
  end;

  OOCIdentifierHelper = class abstract external 'org.omg.CORBA' name 'IdentifierHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCLongLongSeqHelper = class abstract external 'org.omg.CORBA' name 'LongLongSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jlong); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jlong); static; overload;
    class function extract(para1: OOCAny): Arr1jlong; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jlong; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jlong); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jlong); static; overload;
  end;

  OOCLongSeqHelper = class abstract external 'org.omg.CORBA' name 'LongSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jint); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jint); static; overload;
    class function extract(para1: OOCAny): Arr1jint; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jint; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jint); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jint); static; overload;
  end;

  OOCNVList = class abstract external 'org.omg.CORBA' name 'NVList' (JLObject)
  public
    constructor create(); overload;
    function count(): jint; overload; virtual; abstract;
    function add(para1: jint): OOCNamedValue; overload; virtual; abstract;
    function add_item(para1: JLString; para2: jint): OOCNamedValue; overload; virtual; abstract;
    function add_value(para1: JLString; para2: OOCAny; para3: jint): OOCNamedValue; overload; virtual; abstract;
    function item(para1: jint): OOCNamedValue; overload; virtual; abstract;  // throws org.omg.CORBA.Bounds
    procedure remove(para1: jint); overload; virtual; abstract;  // throws org.omg.CORBA.Bounds
  end;

  OOCNameValuePairHelper = class abstract external 'org.omg.CORBA' name 'NameValuePairHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNameValuePair); static; overload;
    class function extract(para1: OOCAny): OOCNameValuePair; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNameValuePair; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNameValuePair); static; overload;
  end;

  OOCNamedValue = class abstract external 'org.omg.CORBA' name 'NamedValue' (JLObject)
  public
    constructor create(); overload;
    function name(): JLString; overload; virtual; abstract;
    function value(): OOCAny; overload; virtual; abstract;
    function flags(): jint; overload; virtual; abstract;
  end;

  OOCOMGVMCID = interface external 'org.omg.CORBA' name 'OMGVMCID' 
    const
      value = 1330446336;
  end;

  OOCORB = class abstract external 'org.omg.CORBA' name 'ORB' (JLObject)
  public
    constructor create(); overload;
    class function init(): OOCORB; static; overload;
    class function init(para1: Arr1JLString; para2: JUProperties): OOCORB; static; overload;
    class function init(var para1: array of JLString; para2: JUProperties): OOCORB; static; overload;
    class function init(para1: JAApplet; para2: JUProperties): OOCORB; static; overload;
  strict protected
    procedure set_parameters(para1: Arr1JLString; para2: JUProperties); overload; virtual; abstract;
    procedure set_parameters(var para1: array of JLString; para2: JUProperties); overload; virtual; abstract;
    procedure set_parameters(para1: JAApplet; para2: JUProperties); overload; virtual; abstract;
  public
    procedure connect(para1: OOCObject); overload; virtual;
    procedure destroy(); overload; virtual;
    procedure disconnect(para1: OOCObject); overload; virtual;
    function list_initial_services(): Arr1JLString; overload; virtual; abstract;
    function resolve_initial_references(para1: JLString): OOCObject; overload; virtual; abstract;  // throws org.omg.CORBA.ORBPackage.InvalidName
    function object_to_string(para1: OOCObject): JLString; overload; virtual; abstract;
    function string_to_object(para1: JLString): OOCObject; overload; virtual; abstract;
    function create_list(para1: jint): OOCNVList; overload; virtual; abstract;
    function create_operation_list(para1: OOCObject): OOCNVList; overload; virtual;
    function create_named_value(para1: JLString; para2: OOCAny; para3: jint): OOCNamedValue; overload; virtual; abstract;
    function create_exception_list(): OOCExceptionList; overload; virtual; abstract;
    function create_context_list(): OOCContextList; overload; virtual; abstract;
    function get_default_context(): OOCContext; overload; virtual; abstract;
    function create_environment(): OOCEnvironment; overload; virtual; abstract;
    function create_output_stream(): OOCPOutputStream; overload; virtual; abstract;
    procedure send_multiple_requests_oneway(para1: Arr1OOCRequest); overload; virtual; abstract;
    procedure send_multiple_requests_oneway(var para1: array of OOCRequest); overload; virtual; abstract;
    procedure send_multiple_requests_deferred(para1: Arr1OOCRequest); overload; virtual; abstract;
    procedure send_multiple_requests_deferred(var para1: array of OOCRequest); overload; virtual; abstract;
    function poll_next_response(): jboolean; overload; virtual; abstract;
    function get_next_response(): OOCRequest; overload; virtual; abstract;  // throws org.omg.CORBA.WrongTransaction
    function get_primitive_tc(para1: OOCTCKind): OOCTypeCode; overload; virtual; abstract;
    function create_struct_tc(para1: JLString; para2: JLString; para3: Arr1OOCStructMember): OOCTypeCode; overload; virtual; abstract;
    function create_struct_tc(para1: JLString; para2: JLString; var para3: array of OOCStructMember): OOCTypeCode; overload; virtual; abstract;
    function create_union_tc(para1: JLString; para2: JLString; para3: OOCTypeCode; para4: Arr1OOCUnionMember): OOCTypeCode; overload; virtual; abstract;
    function create_union_tc(para1: JLString; para2: JLString; para3: OOCTypeCode; var para4: array of OOCUnionMember): OOCTypeCode; overload; virtual; abstract;
    function create_enum_tc(para1: JLString; para2: JLString; para3: Arr1JLString): OOCTypeCode; overload; virtual; abstract;
    function create_enum_tc(para1: JLString; para2: JLString; var para3: array of JLString): OOCTypeCode; overload; virtual; abstract;
    function create_alias_tc(para1: JLString; para2: JLString; para3: OOCTypeCode): OOCTypeCode; overload; virtual; abstract;
    function create_exception_tc(para1: JLString; para2: JLString; para3: Arr1OOCStructMember): OOCTypeCode; overload; virtual; abstract;
    function create_exception_tc(para1: JLString; para2: JLString; var para3: array of OOCStructMember): OOCTypeCode; overload; virtual; abstract;
    function create_interface_tc(para1: JLString; para2: JLString): OOCTypeCode; overload; virtual; abstract;
    function create_string_tc(para1: jint): OOCTypeCode; overload; virtual; abstract;
    function create_wstring_tc(para1: jint): OOCTypeCode; overload; virtual; abstract;
    function create_sequence_tc(para1: jint; para2: OOCTypeCode): OOCTypeCode; overload; virtual; abstract;
    function create_recursive_sequence_tc(para1: jint; para2: jint): OOCTypeCode; overload; virtual; abstract;
    function create_array_tc(para1: jint; para2: OOCTypeCode): OOCTypeCode; overload; virtual; abstract;
    function create_native_tc(para1: JLString; para2: JLString): OOCTypeCode; overload; virtual;
    function create_abstract_interface_tc(para1: JLString; para2: JLString): OOCTypeCode; overload; virtual;
    function create_fixed_tc(para1: jshort; para2: jshort): OOCTypeCode; overload; virtual;
    function create_value_tc(para1: JLString; para2: JLString; para3: jshort; para4: OOCTypeCode; para5: Arr1OOCValueMember): OOCTypeCode; overload; virtual;
    function create_value_tc(para1: JLString; para2: JLString; para3: jshort; para4: OOCTypeCode; var para5: array of OOCValueMember): OOCTypeCode; overload; virtual;
    function create_recursive_tc(para1: JLString): OOCTypeCode; overload; virtual;
    function create_value_box_tc(para1: JLString; para2: JLString; para3: OOCTypeCode): OOCTypeCode; overload; virtual;
    function create_any(): OOCAny; overload; virtual; abstract;
    function get_current(): OOCCurrent; overload; virtual;
    procedure run(); overload; virtual;
    procedure shutdown(para1: jboolean); overload; virtual;
    function work_pending(): jboolean; overload; virtual;
    procedure perform_work(); overload; virtual;
    function get_service_information(para1: jshort; para2: OOCServiceInformationHolder): jboolean; overload; virtual;
    function create_dyn_any(para1: OOCAny): OOCDynAny; overload; virtual;
    function create_basic_dyn_any(para1: OOCTypeCode): OOCDynAny; overload; virtual;  // throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    function create_dyn_struct(para1: OOCTypeCode): OOCDynStruct; overload; virtual;  // throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    function create_dyn_sequence(para1: OOCTypeCode): OOCDynSequence; overload; virtual;  // throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    function create_dyn_array(para1: OOCTypeCode): OOCDynArray; overload; virtual;  // throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    function create_dyn_union(para1: OOCTypeCode): OOCDynUnion; overload; virtual;  // throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    function create_dyn_enum(para1: OOCTypeCode): OOCDynEnum; overload; virtual;  // throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    function create_policy(para1: jint; para2: OOCAny): OOCPolicy; overload; virtual;  // throws org.omg.CORBA.PolicyError
  end;

  OOCObject = interface external 'org.omg.CORBA' name 'Object' 
    function _is_a(para1: JLString): jboolean; overload;
    function _is_equivalent(para1: OOCObject): jboolean; overload;
    function _non_existent(): jboolean; overload;
    function _hash(para1: jint): jint; overload;
    function _duplicate(): OOCObject; overload;
    procedure _release(); overload;
    function _get_interface_def(): OOCObject; overload;
    function _request(para1: JLString): OOCRequest; overload;
    function _create_request(para1: OOCContext; para2: JLString; para3: OOCNVList; para4: OOCNamedValue): OOCRequest; overload;
    function _create_request(para1: OOCContext; para2: JLString; para3: OOCNVList; para4: OOCNamedValue; para5: OOCExceptionList; para6: OOCContextList): OOCRequest; overload;
    function _get_policy(para1: jint): OOCPolicy; overload;
    function _get_domain_managers(): Arr1OOCDomainManager; overload;
    function _set_policy_override(para1: Arr1OOCPolicy; para2: OOCSetOverrideType): OOCObject; overload;
    function _set_policy_override(var para1: array of OOCPolicy; para2: OOCSetOverrideType): OOCObject; overload;
  end;

  OOCObjectHelper = class abstract external 'org.omg.CORBA' name 'ObjectHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCObject); static; overload;
    class function extract(para1: OOCAny): OOCObject; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCObject; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCObject); static; overload;
  end;

  OOCOctetSeqHelper = class abstract external 'org.omg.CORBA' name 'OctetSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jbyte); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jbyte); static; overload;
    class function extract(para1: OOCAny): Arr1jbyte; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jbyte; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jbyte); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jbyte); static; overload;
  end;

  OOCPRIVATE_MEMBER = interface external 'org.omg.CORBA' name 'PRIVATE_MEMBER' 
    const
      value = 0;
  end;

  OOCPUBLIC_MEMBER = interface external 'org.omg.CORBA' name 'PUBLIC_MEMBER' 
    const
      value = 1;
  end;

  OOCParameterModeHelper = class abstract external 'org.omg.CORBA' name 'ParameterModeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCParameterMode); static; overload;
    class function extract(para1: OOCAny): OOCParameterMode; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCParameterMode; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCParameterMode); static; overload;
  end;

  OOCPolicyErrorCodeHelper = class abstract external 'org.omg.CORBA' name 'PolicyErrorCodeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jshort); static; overload;
    class function extract(para1: OOCAny): jshort; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jshort; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jshort); static; overload;
  end;

  OOCPolicyErrorHelper = class abstract external 'org.omg.CORBA' name 'PolicyErrorHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCPolicyError); static; overload;
    class function extract(para1: OOCAny): OOCPolicyError; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCPolicyError; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCPolicyError); static; overload;
  end;

  OOCPolicyHelper = class abstract external 'org.omg.CORBA' name 'PolicyHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCPolicy); static; overload;
    class function extract(para1: OOCAny): OOCPolicy; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCPolicy; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCPolicy); static; overload;
    class function narrow(para1: OOCObject): OOCPolicy; static; overload;
  end;

  OOCPolicyListHelper = class abstract external 'org.omg.CORBA' name 'PolicyListHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOCPolicy); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOCPolicy); static; overload;
    class function extract(para1: OOCAny): Arr1OOCPolicy; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOCPolicy; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOCPolicy); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOCPolicy); static; overload;
  end;

  OOCPolicyOperations = interface external 'org.omg.CORBA' name 'PolicyOperations' 
    function policy_type(): jint; overload;
    function copy(): OOCPolicy; overload;
    procedure destroy(); overload;
  end;

  OOCPolicyTypeHelper = class abstract external 'org.omg.CORBA' name 'PolicyTypeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jint); static; overload;
    class function extract(para1: OOCAny): jint; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jint; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jint); static; overload;
  end;

  OOCPrincipal = class external 'org.omg.CORBA' name 'Principal' (JLObject)
  public
    constructor create(); overload;
    procedure name(para1: Arr1jbyte); overload; virtual;
    procedure name(var para1: array of jbyte); overload; virtual;
    function name(): Arr1jbyte; overload; virtual;
  end;

  OOCRepositoryIdHelper = class abstract external 'org.omg.CORBA' name 'RepositoryIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCRequest = class abstract external 'org.omg.CORBA' name 'Request' (JLObject)
  public
    constructor create(); overload;
    function target(): OOCObject; overload; virtual; abstract;
    function operation(): JLString; overload; virtual; abstract;
    function arguments(): OOCNVList; overload; virtual; abstract;
    function result(): OOCNamedValue; overload; virtual; abstract;
    function env(): OOCEnvironment; overload; virtual; abstract;
    function exceptions(): OOCExceptionList; overload; virtual; abstract;
    function contexts(): OOCContextList; overload; virtual; abstract;
    function ctx(): OOCContext; overload; virtual; abstract;
    procedure ctx(para1: OOCContext); overload; virtual; abstract;
    function add_in_arg(): OOCAny; overload; virtual; abstract;
    function add_named_in_arg(para1: JLString): OOCAny; overload; virtual; abstract;
    function add_inout_arg(): OOCAny; overload; virtual; abstract;
    function add_named_inout_arg(para1: JLString): OOCAny; overload; virtual; abstract;
    function add_out_arg(): OOCAny; overload; virtual; abstract;
    function add_named_out_arg(para1: JLString): OOCAny; overload; virtual; abstract;
    procedure set_return_type(para1: OOCTypeCode); overload; virtual; abstract;
    function return_value(): OOCAny; overload; virtual; abstract;
    procedure invoke(); overload; virtual; abstract;
    procedure send_oneway(); overload; virtual; abstract;
    procedure send_deferred(); overload; virtual; abstract;
    function poll_response(): jboolean; overload; virtual; abstract;
    procedure get_response(); overload; virtual; abstract;  // throws org.omg.CORBA.WrongTransaction
  end;

  OOCServerRequest = class abstract external 'org.omg.CORBA' name 'ServerRequest' (JLObject)
  public
    constructor create(); overload;
    function op_name(): JLString; overload; virtual;
    function operation(): JLString; overload; virtual;
    procedure params(para1: OOCNVList); overload; virtual;
    procedure arguments(para1: OOCNVList); overload; virtual;
    procedure result(para1: OOCAny); overload; virtual;
    procedure set_result(para1: OOCAny); overload; virtual;
    procedure &except(para1: OOCAny); overload; virtual;
    procedure set_exception(para1: OOCAny); overload; virtual;
    function ctx(): OOCContext; overload; virtual; abstract;
  end;

  OOCServiceDetailHelper = class abstract external 'org.omg.CORBA' name 'ServiceDetailHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCServiceDetail); static; overload;
    class function read(para1: OOCPInputStream): OOCServiceDetail; static; overload;
    class function extract(para1: OOCAny): OOCServiceDetail; static; overload;
    class procedure insert(para1: OOCAny; para2: OOCServiceDetail); static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
  end;

  OOCServiceInformationHelper = class abstract external 'org.omg.CORBA' name 'ServiceInformationHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCServiceInformation); static; overload;
    class function read(para1: OOCPInputStream): OOCServiceInformation; static; overload;
    class function extract(para1: OOCAny): OOCServiceInformation; static; overload;
    class procedure insert(para1: OOCAny; para2: OOCServiceInformation); static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
  end;

  OOCSetOverrideTypeHelper = class abstract external 'org.omg.CORBA' name 'SetOverrideTypeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCSetOverrideType); static; overload;
    class function extract(para1: OOCAny): OOCSetOverrideType; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCSetOverrideType; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCSetOverrideType); static; overload;
  end;

  OOCShortSeqHelper = class abstract external 'org.omg.CORBA' name 'ShortSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jshort); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jshort); static; overload;
    class function extract(para1: OOCAny): Arr1jshort; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jshort; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jshort); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jshort); static; overload;
  end;

  OOCStringSeqHelper = class abstract external 'org.omg.CORBA' name 'StringSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1JLString); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of JLString); static; overload;
    class function extract(para1: OOCAny): Arr1JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1JLString); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of JLString); static; overload;
  end;

  OOCStructMemberHelper = class abstract external 'org.omg.CORBA' name 'StructMemberHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCStructMember); static; overload;
    class function extract(para1: OOCAny): OOCStructMember; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCStructMember; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCStructMember); static; overload;
  end;

  OOCTCKind = class external 'org.omg.CORBA' name 'TCKind' (JLObject)
  public
    const
      _tk_null = 0;
      _tk_void = 1;
      _tk_short = 2;
      _tk_long = 3;
      _tk_ushort = 4;
      _tk_ulong = 5;
      _tk_float = 6;
      _tk_double = 7;
      _tk_boolean = 8;
      _tk_char = 9;
      _tk_octet = 10;
      _tk_any = 11;
      _tk_TypeCode = 12;
      _tk_Principal = 13;
      _tk_objref = 14;
      _tk_struct = 15;
      _tk_union = 16;
      _tk_enum = 17;
      _tk_string = 18;
      _tk_sequence = 19;
      _tk_array = 20;
      _tk_alias = 21;
      _tk_except = 22;
      _tk_longlong = 23;
      _tk_ulonglong = 24;
      _tk_longdouble = 25;
      _tk_wchar = 26;
      _tk_wstring = 27;
      _tk_fixed = 28;
      _tk_value = 29;
      _tk_value_box = 30;
      _tk_native = 31;
      _tk_abstract_interface = 32;
  public
    final class var
      ftk_null: OOCTCKind; external name 'tk_null';
      ftk_void: OOCTCKind; external name 'tk_void';
      ftk_short: OOCTCKind; external name 'tk_short';
      ftk_long: OOCTCKind; external name 'tk_long';
      ftk_ushort: OOCTCKind; external name 'tk_ushort';
      ftk_ulong: OOCTCKind; external name 'tk_ulong';
      ftk_float: OOCTCKind; external name 'tk_float';
      ftk_double: OOCTCKind; external name 'tk_double';
      ftk_boolean: OOCTCKind; external name 'tk_boolean';
      ftk_char: OOCTCKind; external name 'tk_char';
      ftk_octet: OOCTCKind; external name 'tk_octet';
      ftk_any: OOCTCKind; external name 'tk_any';
      ftk_TypeCode: OOCTCKind; external name 'tk_TypeCode';
      ftk_Principal: OOCTCKind; external name 'tk_Principal';
      ftk_objref: OOCTCKind; external name 'tk_objref';
      ftk_struct: OOCTCKind; external name 'tk_struct';
      ftk_union: OOCTCKind; external name 'tk_union';
      ftk_enum: OOCTCKind; external name 'tk_enum';
      ftk_string: OOCTCKind; external name 'tk_string';
      ftk_sequence: OOCTCKind; external name 'tk_sequence';
      ftk_array: OOCTCKind; external name 'tk_array';
      ftk_alias: OOCTCKind; external name 'tk_alias';
      ftk_except: OOCTCKind; external name 'tk_except';
      ftk_longlong: OOCTCKind; external name 'tk_longlong';
      ftk_ulonglong: OOCTCKind; external name 'tk_ulonglong';
      ftk_longdouble: OOCTCKind; external name 'tk_longdouble';
      ftk_wchar: OOCTCKind; external name 'tk_wchar';
      ftk_wstring: OOCTCKind; external name 'tk_wstring';
      ftk_fixed: OOCTCKind; external name 'tk_fixed';
      ftk_value: OOCTCKind; external name 'tk_value';
      ftk_value_box: OOCTCKind; external name 'tk_value_box';
      ftk_native: OOCTCKind; external name 'tk_native';
      ftk_abstract_interface: OOCTCKind; external name 'tk_abstract_interface';
  public
    function value(): jint; overload; virtual;
    class function from_int(para1: jint): OOCTCKind; static; overload;
  strict protected
    constructor create(para1: jint); overload;
  end;

  OOCULongLongSeqHelper = class abstract external 'org.omg.CORBA' name 'ULongLongSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jlong); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jlong); static; overload;
    class function extract(para1: OOCAny): Arr1jlong; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jlong; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jlong); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jlong); static; overload;
  end;

  OOCULongSeqHelper = class abstract external 'org.omg.CORBA' name 'ULongSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jint); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jint); static; overload;
    class function extract(para1: OOCAny): Arr1jint; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jint; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jint); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jint); static; overload;
  end;

  OOCUNSUPPORTED_POLICY = interface external 'org.omg.CORBA' name 'UNSUPPORTED_POLICY' 
    const
      value = 1;
  end;

  OOCUNSUPPORTED_POLICY_VALUE = interface external 'org.omg.CORBA' name 'UNSUPPORTED_POLICY_VALUE' 
    const
      value = 4;
  end;

  OOCUShortSeqHelper = class abstract external 'org.omg.CORBA' name 'UShortSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jshort); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jshort); static; overload;
    class function extract(para1: OOCAny): Arr1jshort; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jshort; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jshort); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jshort); static; overload;
  end;

  OOCUnionMemberHelper = class abstract external 'org.omg.CORBA' name 'UnionMemberHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCUnionMember); static; overload;
    class function extract(para1: OOCAny): OOCUnionMember; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCUnionMember; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCUnionMember); static; overload;
  end;

  OOCUnknownUserExceptionHelper = class abstract external 'org.omg.CORBA' name 'UnknownUserExceptionHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCUnknownUserException); static; overload;
    class function extract(para1: OOCAny): OOCUnknownUserException; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCUnknownUserException; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCUnknownUserException); static; overload;
  end;

  OOCVM_ABSTRACT = interface external 'org.omg.CORBA' name 'VM_ABSTRACT' 
    const
      value = 2;
  end;

  OOCVM_CUSTOM = interface external 'org.omg.CORBA' name 'VM_CUSTOM' 
    const
      value = 1;
  end;

  OOCVM_NONE = interface external 'org.omg.CORBA' name 'VM_NONE' 
    const
      value = 0;
  end;

  OOCVM_TRUNCATABLE = interface external 'org.omg.CORBA' name 'VM_TRUNCATABLE' 
    const
      value = 3;
  end;

  OOCValueBaseHelper = class abstract external 'org.omg.CORBA' name 'ValueBaseHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JISerializable); static; overload;
    class function extract(para1: OOCAny): JISerializable; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JISerializable; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JISerializable); static; overload;
  end;

  OOCValueMemberHelper = class abstract external 'org.omg.CORBA' name 'ValueMemberHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCValueMember); static; overload;
    class function extract(para1: OOCAny): OOCValueMember; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCValueMember; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCValueMember); static; overload;
  end;

  OOCVersionSpecHelper = class abstract external 'org.omg.CORBA' name 'VersionSpecHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCVisibilityHelper = class abstract external 'org.omg.CORBA' name 'VisibilityHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jshort); static; overload;
    class function extract(para1: OOCAny): jshort; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jshort; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jshort); static; overload;
  end;

  OOCWCharSeqHelper = class abstract external 'org.omg.CORBA' name 'WCharSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jchar); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jchar); static; overload;
    class function extract(para1: OOCAny): Arr1jchar; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jchar; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jchar); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jchar); static; overload;
  end;

  OOCWStringSeqHelper = class abstract external 'org.omg.CORBA' name 'WStringSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1JLString); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of JLString); static; overload;
    class function extract(para1: OOCAny): Arr1JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1JLString); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of JLString); static; overload;
  end;

  OOCWrongTransactionHelper = class abstract external 'org.omg.CORBA' name 'WrongTransactionHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCWrongTransaction); static; overload;
    class function extract(para1: OOCAny): OOCWrongTransaction; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCWrongTransaction; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCWrongTransaction); static; overload;
  end;

  OOCPBoxedValueHelper = interface external 'org.omg.CORBA.portable' name 'BoxedValueHelper' 
    function read_value(para1: OOCPInputStream): JISerializable; overload;
    procedure write_value(para1: OOCPOutputStream; para2: JISerializable); overload;
    function get_id(): JLString; overload;
  end;

  OOCPDelegate = class abstract external 'org.omg.CORBA.portable' name 'Delegate' (JLObject)
  public
    constructor create(); overload;
    function get_interface_def(para1: OOCObject): OOCObject; overload; virtual; abstract;
    function duplicate(para1: OOCObject): OOCObject; overload; virtual; abstract;
    procedure release(para1: OOCObject); overload; virtual; abstract;
    function is_a(para1: OOCObject; para2: JLString): jboolean; overload; virtual; abstract;
    function non_existent(para1: OOCObject): jboolean; overload; virtual; abstract;
    function is_equivalent(para1: OOCObject; para2: OOCObject): jboolean; overload; virtual; abstract;
    function hash(para1: OOCObject; para2: jint): jint; overload; virtual; abstract;
    function request(para1: OOCObject; para2: JLString): OOCRequest; overload; virtual; abstract;
    function create_request(para1: OOCObject; para2: OOCContext; para3: JLString; para4: OOCNVList; para5: OOCNamedValue): OOCRequest; overload; virtual; abstract;
    function create_request(para1: OOCObject; para2: OOCContext; para3: JLString; para4: OOCNVList; para5: OOCNamedValue; para6: OOCExceptionList; para7: OOCContextList): OOCRequest; overload; virtual; abstract;
    function orb(para1: OOCObject): OOCORB; overload; virtual;
    function get_policy(para1: OOCObject; para2: jint): OOCPolicy; overload; virtual;
    function get_domain_managers(para1: OOCObject): Arr1OOCDomainManager; overload; virtual;
    function set_policy_override(para1: OOCObject; para2: Arr1OOCPolicy; para3: OOCSetOverrideType): OOCObject; overload; virtual;
    function set_policy_override(para1: OOCObject; var para2: array of OOCPolicy; para3: OOCSetOverrideType): OOCObject; overload; virtual;
    function is_local(para1: OOCObject): jboolean; overload; virtual;
    function servant_preinvoke(para1: OOCObject; para2: JLString; para3: JLClass): OOCPServantObject; overload; virtual;
    procedure servant_postinvoke(para1: OOCObject; para2: OOCPServantObject); overload; virtual;
    function request(para1: OOCObject; para2: JLString; para3: jboolean): OOCPOutputStream; overload; virtual;
    function invoke(para1: OOCObject; para2: OOCPOutputStream): OOCPInputStream; overload; virtual;  // throws org.omg.CORBA.portable.ApplicationException, org.omg.CORBA.portable.RemarshalException
    procedure releaseReply(para1: OOCObject; para2: OOCPInputStream); overload; virtual;
    function toString(para1: OOCObject): JLString; overload; virtual;
    function hashCode(para1: OOCObject): jint; overload; virtual;
    function equals(para1: OOCObject; para2: JLObject): jboolean; overload; virtual;
  end;

  OOCPInvokeHandler = interface external 'org.omg.CORBA.portable' name 'InvokeHandler' 
    function _invoke(para1: JLString; para2: OOCPInputStream; para3: OOCPResponseHandler): OOCPOutputStream; overload;  // throws org.omg.CORBA.SystemException
  end;

  OOCPResponseHandler = interface external 'org.omg.CORBA.portable' name 'ResponseHandler' 
    function createReply(): OOCPOutputStream; overload;
    function createExceptionReply(): OOCPOutputStream; overload;
  end;

  OOCPServantObject = class external 'org.omg.CORBA.portable' name 'ServantObject' (JLObject)
  public
    var
      fservant: JLObject; external name 'servant';
  public
    constructor create(); overload;
  end;

  OOCPStreamable = interface external 'org.omg.CORBA.portable' name 'Streamable' 
    procedure _read(para1: OOCPInputStream); overload;
    procedure _write(para1: OOCPOutputStream); overload;
    function _type(): OOCTypeCode; overload;
  end;

  OOCPValueFactory = interface external 'org.omg.CORBA.portable' name 'ValueFactory' 
    function read_value(para1: OOC_2_3PInputStream): JISerializable; overload;
  end;

  OOCPValueInputStream = interface external 'org.omg.CORBA.portable' name 'ValueInputStream' 
    procedure start_value(); overload;
    procedure end_value(); overload;
  end;

  OOCPValueOutputStream = interface external 'org.omg.CORBA.portable' name 'ValueOutputStream' 
    procedure start_value(para1: JLString); overload;
    procedure end_value(); overload;
  end;

  OOCBindingHelper = class abstract external 'org.omg.CosNaming' name 'BindingHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCBinding); static; overload;
    class function extract(para1: OOCAny): OOCBinding; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCBinding; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCBinding); static; overload;
  end;

  OOCBindingIteratorHelper = class abstract external 'org.omg.CosNaming' name 'BindingIteratorHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCBindingIterator); static; overload;
    class function extract(para1: OOCAny): OOCBindingIterator; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCBindingIterator; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCBindingIterator); static; overload;
    class function narrow(para1: OOCObject): OOCBindingIterator; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOCBindingIterator; static; overload;
  end;

  OOCBindingIteratorOperations = interface external 'org.omg.CosNaming' name 'BindingIteratorOperations' 
    function next_one(para1: OOCBindingHolder): jboolean; overload;
    function next_n(para1: jint; para2: OOCBindingListHolder): jboolean; overload;
    procedure destroy(); overload;
  end;

  OOCBindingListHelper = class abstract external 'org.omg.CosNaming' name 'BindingListHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOCBinding); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOCBinding); static; overload;
    class function extract(para1: OOCAny): Arr1OOCBinding; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOCBinding; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOCBinding); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOCBinding); static; overload;
  end;

  OOCBindingTypeHelper = class abstract external 'org.omg.CosNaming' name 'BindingTypeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCBindingType); static; overload;
    class function extract(para1: OOCAny): OOCBindingType; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCBindingType; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCBindingType); static; overload;
  end;

  OOCIstringHelper = class abstract external 'org.omg.CosNaming' name 'IstringHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCNameComponentHelper = class abstract external 'org.omg.CosNaming' name 'NameComponentHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNameComponent); static; overload;
    class function extract(para1: OOCAny): OOCNameComponent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNameComponent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNameComponent); static; overload;
  end;

  OOCNameHelper = class abstract external 'org.omg.CosNaming' name 'NameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOCNameComponent); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOCNameComponent); static; overload;
    class function extract(para1: OOCAny): Arr1OOCNameComponent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOCNameComponent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOCNameComponent); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOCNameComponent); static; overload;
  end;

  OOCNamingContextExtHelper = class abstract external 'org.omg.CosNaming' name 'NamingContextExtHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNamingContextExt); static; overload;
    class function extract(para1: OOCAny): OOCNamingContextExt; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNamingContextExt; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNamingContextExt); static; overload;
    class function narrow(para1: OOCObject): OOCNamingContextExt; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOCNamingContextExt; static; overload;
  end;

  OOCNAddressHelper = class abstract external 'org.omg.CosNaming.NamingContextExtPackage' name 'AddressHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCNInvalidAddressHelper = class abstract external 'org.omg.CosNaming.NamingContextExtPackage' name 'InvalidAddressHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNInvalidAddress); static; overload;
    class function extract(para1: OOCAny): OOCNInvalidAddress; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNInvalidAddress; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNInvalidAddress); static; overload;
  end;

  OOCNStringNameHelper = class abstract external 'org.omg.CosNaming.NamingContextExtPackage' name 'StringNameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCNURLStringHelper = class abstract external 'org.omg.CosNaming.NamingContextExtPackage' name 'URLStringHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOCNamingContextHelper = class abstract external 'org.omg.CosNaming' name 'NamingContextHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNamingContext); static; overload;
    class function extract(para1: OOCAny): OOCNamingContext; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNamingContext; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNamingContext); static; overload;
    class function narrow(para1: OOCObject): OOCNamingContext; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOCNamingContext; static; overload;
  end;

  OOCNamingContextOperations = interface external 'org.omg.CosNaming' name 'NamingContextOperations' 
    procedure bind(para1: Arr1OOCNameComponent; para2: OOCObject); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName, org.omg.CosNaming.NamingContextPackage.AlreadyBound
    procedure bind(var para1: array of OOCNameComponent; para2: OOCObject); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName, org.omg.CosNaming.NamingContextPackage.AlreadyBound
    procedure bind_context(para1: Arr1OOCNameComponent; para2: OOCNamingContext); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName, org.omg.CosNaming.NamingContextPackage.AlreadyBound
    procedure bind_context(var para1: array of OOCNameComponent; para2: OOCNamingContext); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName, org.omg.CosNaming.NamingContextPackage.AlreadyBound
    procedure rebind(para1: Arr1OOCNameComponent; para2: OOCObject); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    procedure rebind(var para1: array of OOCNameComponent; para2: OOCObject); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    procedure rebind_context(para1: Arr1OOCNameComponent; para2: OOCNamingContext); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    procedure rebind_context(var para1: array of OOCNameComponent; para2: OOCNamingContext); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    function resolve(para1: Arr1OOCNameComponent): OOCObject; overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    function resolve(var para1: array of OOCNameComponent): OOCObject; overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    procedure unbind(para1: Arr1OOCNameComponent); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    procedure unbind(var para1: array of OOCNameComponent); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    procedure list(para1: jint; para2: OOCBindingListHolder; para3: OOCBindingIteratorHolder); overload;
    function new_context(): OOCNamingContext; overload;
    function bind_new_context(para1: Arr1OOCNameComponent): OOCNamingContext; overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.AlreadyBound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    function bind_new_context(var para1: array of OOCNameComponent): OOCNamingContext; overload;  // throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.AlreadyBound, org.omg.CosNaming.NamingContextPackage.CannotProceed, org.omg.CosNaming.NamingContextPackage.InvalidName
    procedure destroy(); overload;  // throws org.omg.CosNaming.NamingContextPackage.NotEmpty
  end;

  OOCNAlreadyBoundHelper = class abstract external 'org.omg.CosNaming.NamingContextPackage' name 'AlreadyBoundHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNAlreadyBound); static; overload;
    class function extract(para1: OOCAny): OOCNAlreadyBound; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNAlreadyBound; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNAlreadyBound); static; overload;
  end;

  OOCNCannotProceedHelper = class abstract external 'org.omg.CosNaming.NamingContextPackage' name 'CannotProceedHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNCannotProceed); static; overload;
    class function extract(para1: OOCAny): OOCNCannotProceed; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNCannotProceed; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNCannotProceed); static; overload;
  end;

  OOCNInvalidNameHelper = class abstract external 'org.omg.CosNaming.NamingContextPackage' name 'InvalidNameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNInvalidName); static; overload;
    class function extract(para1: OOCAny): OOCNInvalidName; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNInvalidName; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNInvalidName); static; overload;
  end;

  OOCNNotEmptyHelper = class abstract external 'org.omg.CosNaming.NamingContextPackage' name 'NotEmptyHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNNotEmpty); static; overload;
    class function extract(para1: OOCAny): OOCNNotEmpty; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNNotEmpty; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNNotEmpty); static; overload;
  end;

  OOCNNotFoundHelper = class abstract external 'org.omg.CosNaming.NamingContextPackage' name 'NotFoundHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNNotFound); static; overload;
    class function extract(para1: OOCAny): OOCNNotFound; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNNotFound; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNNotFound); static; overload;
  end;

  OOCNNotFoundReasonHelper = class abstract external 'org.omg.CosNaming.NamingContextPackage' name 'NotFoundReasonHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOCNNotFoundReason); static; overload;
    class function extract(para1: OOCAny): OOCNNotFoundReason; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOCNNotFoundReason; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOCNNotFoundReason); static; overload;
  end;

  OODAnySeqHelper = class abstract external 'org.omg.DynamicAny' name 'AnySeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOCAny); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOCAny); static; overload;
    class function extract(para1: OOCAny): Arr1OOCAny; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOCAny; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOCAny); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOCAny); static; overload;
  end;

  OODDynAnyFactoryHelper = class abstract external 'org.omg.DynamicAny' name 'DynAnyFactoryHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynAnyFactory); static; overload;
    class function extract(para1: OOCAny): OODDynAnyFactory; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynAnyFactory; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynAnyFactory); static; overload;
    class function narrow(para1: OOCObject): OODDynAnyFactory; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynAnyFactory; static; overload;
  end;

  OODDynAnyFactoryOperations = interface external 'org.omg.DynamicAny' name 'DynAnyFactoryOperations' 
    function create_dyn_any(para1: OOCAny): OODDynAny; overload;  // throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    function create_dyn_any_from_type_code(para1: OOCTypeCode): OODDynAny; overload;  // throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
  end;

  OODDInconsistentTypeCodeHelper = class abstract external 'org.omg.DynamicAny.DynAnyFactoryPackage' name 'InconsistentTypeCodeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDInconsistentTypeCode); static; overload;
    class function extract(para1: OOCAny): OODDInconsistentTypeCode; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDInconsistentTypeCode; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDInconsistentTypeCode); static; overload;
  end;

  OODDynAnyHelper = class abstract external 'org.omg.DynamicAny' name 'DynAnyHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynAny); static; overload;
    class function extract(para1: OOCAny): OODDynAny; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynAny; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynAny); static; overload;
    class function narrow(para1: OOCObject): OODDynAny; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynAny; static; overload;
  end;

  OODDynAnyOperations = interface external 'org.omg.DynamicAny' name 'DynAnyOperations' 
    function &type(): OOCTypeCode; overload;
    procedure assign(para1: OODDynAny); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch
    procedure from_any(para1: OOCAny); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function to_any(): OOCAny; overload;
    function equal(para1: OODDynAny): jboolean; overload;
    procedure destroy(); overload;
    function copy(): OODDynAny; overload;
    procedure insert_boolean(para1: jboolean); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_octet(para1: jbyte); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_char(para1: jchar); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_short(para1: jshort); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_ushort(para1: jshort); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_long(para1: jint); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_ulong(para1: jint); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_float(para1: jfloat); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_double(para1: jdouble); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_string(para1: JLString); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_reference(para1: OOCObject); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_typecode(para1: OOCTypeCode); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_longlong(para1: jlong); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_ulonglong(para1: jlong); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_wchar(para1: jchar); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_wstring(para1: JLString); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_any(para1: OOCAny); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_dyn_any(para1: OODDynAny); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    procedure insert_val(para1: JISerializable); overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_boolean(): jboolean; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_octet(): jbyte; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_char(): jchar; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_short(): jshort; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_ushort(): jshort; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_long(): jint; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_ulong(): jint; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_float(): jfloat; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_double(): jdouble; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_string(): JLString; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_reference(): OOCObject; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_typecode(): OOCTypeCode; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_longlong(): jlong; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_ulonglong(): jlong; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_wchar(): jchar; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_wstring(): JLString; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_any(): OOCAny; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_dyn_any(): OODDynAny; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function get_val(): JISerializable; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch, org.omg.DynamicAny.DynAnyPackage.InvalidValue
    function seek(para1: jint): jboolean; overload;
    procedure rewind(); overload;
    function next(): jboolean; overload;
    function component_count(): jint; overload;
    function current_component(): OODDynAny; overload;  // throws org.omg.DynamicAny.DynAnyPackage.TypeMismatch
  end;

  OODDInvalidValueHelper = class abstract external 'org.omg.DynamicAny.DynAnyPackage' name 'InvalidValueHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDInvalidValue); static; overload;
    class function extract(para1: OOCAny): OODDInvalidValue; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDInvalidValue; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDInvalidValue); static; overload;
  end;

  OODDTypeMismatchHelper = class abstract external 'org.omg.DynamicAny.DynAnyPackage' name 'TypeMismatchHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDTypeMismatch); static; overload;
    class function extract(para1: OOCAny): OODDTypeMismatch; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDTypeMismatch; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDTypeMismatch); static; overload;
  end;

  OODDynAnySeqHelper = class abstract external 'org.omg.DynamicAny' name 'DynAnySeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OODDynAny); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OODDynAny); static; overload;
    class function extract(para1: OOCAny): Arr1OODDynAny; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OODDynAny; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OODDynAny); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OODDynAny); static; overload;
  end;

  OODDynArrayHelper = class abstract external 'org.omg.DynamicAny' name 'DynArrayHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynArray); static; overload;
    class function extract(para1: OOCAny): OODDynArray; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynArray; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynArray); static; overload;
    class function narrow(para1: OOCObject): OODDynArray; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynArray; static; overload;
  end;

  OODDynEnumHelper = class abstract external 'org.omg.DynamicAny' name 'DynEnumHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynEnum); static; overload;
    class function extract(para1: OOCAny): OODDynEnum; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynEnum; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynEnum); static; overload;
    class function narrow(para1: OOCObject): OODDynEnum; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynEnum; static; overload;
  end;

  OODDynFixedHelper = class abstract external 'org.omg.DynamicAny' name 'DynFixedHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynFixed); static; overload;
    class function extract(para1: OOCAny): OODDynFixed; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynFixed; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynFixed); static; overload;
    class function narrow(para1: OOCObject): OODDynFixed; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynFixed; static; overload;
  end;

  OODDynSequenceHelper = class abstract external 'org.omg.DynamicAny' name 'DynSequenceHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynSequence); static; overload;
    class function extract(para1: OOCAny): OODDynSequence; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynSequence; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynSequence); static; overload;
    class function narrow(para1: OOCObject): OODDynSequence; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynSequence; static; overload;
  end;

  OODDynStructHelper = class abstract external 'org.omg.DynamicAny' name 'DynStructHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynStruct); static; overload;
    class function extract(para1: OOCAny): OODDynStruct; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynStruct; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynStruct); static; overload;
    class function narrow(para1: OOCObject): OODDynStruct; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynStruct; static; overload;
  end;

  OODDynUnionHelper = class abstract external 'org.omg.DynamicAny' name 'DynUnionHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynUnion); static; overload;
    class function extract(para1: OOCAny): OODDynUnion; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynUnion; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynUnion); static; overload;
    class function narrow(para1: OOCObject): OODDynUnion; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynUnion; static; overload;
  end;

  OODDynValueHelper = class abstract external 'org.omg.DynamicAny' name 'DynValueHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODDynValue); static; overload;
    class function extract(para1: OOCAny): OODDynValue; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODDynValue; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODDynValue); static; overload;
    class function narrow(para1: OOCObject): OODDynValue; static; overload;
    class function unchecked_narrow(para1: OOCObject): OODDynValue; static; overload;
  end;

  OODFieldNameHelper = class abstract external 'org.omg.DynamicAny' name 'FieldNameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OODNameDynAnyPairHelper = class abstract external 'org.omg.DynamicAny' name 'NameDynAnyPairHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODNameDynAnyPair); static; overload;
    class function extract(para1: OOCAny): OODNameDynAnyPair; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODNameDynAnyPair; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODNameDynAnyPair); static; overload;
  end;

  OODNameDynAnyPairSeqHelper = class abstract external 'org.omg.DynamicAny' name 'NameDynAnyPairSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OODNameDynAnyPair); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OODNameDynAnyPair); static; overload;
    class function extract(para1: OOCAny): Arr1OODNameDynAnyPair; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OODNameDynAnyPair; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OODNameDynAnyPair); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OODNameDynAnyPair); static; overload;
  end;

  OODNameValuePairHelper = class abstract external 'org.omg.DynamicAny' name 'NameValuePairHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OODNameValuePair); static; overload;
    class function extract(para1: OOCAny): OODNameValuePair; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OODNameValuePair; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OODNameValuePair); static; overload;
  end;

  OODNameValuePairSeqHelper = class abstract external 'org.omg.DynamicAny' name 'NameValuePairSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OODNameValuePair); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OODNameValuePair); static; overload;
    class function extract(para1: OOCAny): Arr1OODNameValuePair; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OODNameValuePair; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OODNameValuePair); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OODNameValuePair); static; overload;
  end;

  OOICodeSets = interface external 'org.omg.IOP' name 'CodeSets' 
    const
      value = 1;
  end;

  OOICodecFactoryHelper = class abstract external 'org.omg.IOP' name 'CodecFactoryHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOICodecFactory); static; overload;
    class function extract(para1: OOCAny): OOICodecFactory; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOICodecFactory; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOICodecFactory); static; overload;
    class function narrow(para1: OOCObject): OOICodecFactory; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOICodecFactory; static; overload;
  end;

  OOICodecFactoryOperations = interface external 'org.omg.IOP' name 'CodecFactoryOperations' 
    function create_codec(para1: OOIEncoding): OOICodec; overload;  // throws org.omg.IOP.CodecFactoryPackage.UnknownEncoding
  end;

  OOICUnknownEncodingHelper = class abstract external 'org.omg.IOP.CodecFactoryPackage' name 'UnknownEncodingHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOICUnknownEncoding); static; overload;
    class function extract(para1: OOCAny): OOICUnknownEncoding; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOICUnknownEncoding; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOICUnknownEncoding); static; overload;
  end;

  OOICodecOperations = interface external 'org.omg.IOP' name 'CodecOperations' 
    function encode(para1: OOCAny): Arr1jbyte; overload;  // throws org.omg.IOP.CodecPackage.InvalidTypeForEncoding
    function decode(para1: Arr1jbyte): OOCAny; overload;  // throws org.omg.IOP.CodecPackage.FormatMismatch
    function decode(var para1: array of jbyte): OOCAny; overload;  // throws org.omg.IOP.CodecPackage.FormatMismatch
    function encode_value(para1: OOCAny): Arr1jbyte; overload;  // throws org.omg.IOP.CodecPackage.InvalidTypeForEncoding
    function decode_value(para1: Arr1jbyte; para2: OOCTypeCode): OOCAny; overload;  // throws org.omg.IOP.CodecPackage.FormatMismatch, org.omg.IOP.CodecPackage.TypeMismatch
    function decode_value(var para1: array of jbyte; para2: OOCTypeCode): OOCAny; overload;  // throws org.omg.IOP.CodecPackage.FormatMismatch, org.omg.IOP.CodecPackage.TypeMismatch
  end;

  OOICFormatMismatchHelper = class abstract external 'org.omg.IOP.CodecPackage' name 'FormatMismatchHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOICFormatMismatch); static; overload;
    class function extract(para1: OOCAny): OOICFormatMismatch; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOICFormatMismatch; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOICFormatMismatch); static; overload;
  end;

  OOICInvalidTypeForEncodingHelper = class abstract external 'org.omg.IOP.CodecPackage' name 'InvalidTypeForEncodingHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOICInvalidTypeForEncoding); static; overload;
    class function extract(para1: OOCAny): OOICInvalidTypeForEncoding; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOICInvalidTypeForEncoding; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOICInvalidTypeForEncoding); static; overload;
  end;

  OOICTypeMismatchHelper = class abstract external 'org.omg.IOP.CodecPackage' name 'TypeMismatchHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOICTypeMismatch); static; overload;
    class function extract(para1: OOCAny): OOICTypeMismatch; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOICTypeMismatch; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOICTypeMismatch); static; overload;
  end;

  OOIComponentIdHelper = class abstract external 'org.omg.IOP' name 'ComponentIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jint); static; overload;
    class function extract(para1: OOCAny): jint; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jint; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jint); static; overload;
  end;

  OOIENCODING_CDR_ENCAPS = interface external 'org.omg.IOP' name 'ENCODING_CDR_ENCAPS' 
    const
      value = 0;
  end;

  OOIExceptionDetailMessage = interface external 'org.omg.IOP' name 'ExceptionDetailMessage' 
    const
      value = 14;
  end;

  OOIIORHelper = class abstract external 'org.omg.IOP' name 'IORHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOIIOR); static; overload;
    class function extract(para1: OOCAny): OOIIOR; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOIIOR; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOIIOR); static; overload;
  end;

  OOIMultipleComponentProfileHelper = class abstract external 'org.omg.IOP' name 'MultipleComponentProfileHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOITaggedComponent); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOITaggedComponent); static; overload;
    class function extract(para1: OOCAny): Arr1OOITaggedComponent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOITaggedComponent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOITaggedComponent); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOITaggedComponent); static; overload;
  end;

  OOIProfileIdHelper = class abstract external 'org.omg.IOP' name 'ProfileIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jint); static; overload;
    class function extract(para1: OOCAny): jint; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jint; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jint); static; overload;
  end;

  OOIRMICustomMaxStreamFormat = interface external 'org.omg.IOP' name 'RMICustomMaxStreamFormat' 
    const
      value = 17;
  end;

  OOIServiceContextHelper = class abstract external 'org.omg.IOP' name 'ServiceContextHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOIServiceContext); static; overload;
    class function extract(para1: OOCAny): OOIServiceContext; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOIServiceContext; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOIServiceContext); static; overload;
  end;

  OOIServiceContextListHelper = class abstract external 'org.omg.IOP' name 'ServiceContextListHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOIServiceContext); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOIServiceContext); static; overload;
    class function extract(para1: OOCAny): Arr1OOIServiceContext; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOIServiceContext; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOIServiceContext); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOIServiceContext); static; overload;
  end;

  OOIServiceIdHelper = class abstract external 'org.omg.IOP' name 'ServiceIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jint); static; overload;
    class function extract(para1: OOCAny): jint; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jint; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jint); static; overload;
  end;

  OOITAG_ALTERNATE_IIOP_ADDRESS = interface external 'org.omg.IOP' name 'TAG_ALTERNATE_IIOP_ADDRESS' 
    const
      value = 3;
  end;

  OOITAG_CODE_SETS = interface external 'org.omg.IOP' name 'TAG_CODE_SETS' 
    const
      value = 1;
  end;

  OOITAG_INTERNET_IOP = interface external 'org.omg.IOP' name 'TAG_INTERNET_IOP' 
    const
      value = 0;
  end;

  OOITAG_JAVA_CODEBASE = interface external 'org.omg.IOP' name 'TAG_JAVA_CODEBASE' 
    const
      value = 25;
  end;

  OOITAG_MULTIPLE_COMPONENTS = interface external 'org.omg.IOP' name 'TAG_MULTIPLE_COMPONENTS' 
    const
      value = 1;
  end;

  OOITAG_ORB_TYPE = interface external 'org.omg.IOP' name 'TAG_ORB_TYPE' 
    const
      value = 0;
  end;

  OOITAG_POLICIES = interface external 'org.omg.IOP' name 'TAG_POLICIES' 
    const
      value = 2;
  end;

  OOITAG_RMI_CUSTOM_MAX_STREAM_FORMAT = interface external 'org.omg.IOP' name 'TAG_RMI_CUSTOM_MAX_STREAM_FORMAT' 
    const
      value = 38;
  end;

  OOITaggedComponentHelper = class abstract external 'org.omg.IOP' name 'TaggedComponentHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOITaggedComponent); static; overload;
    class function extract(para1: OOCAny): OOITaggedComponent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOITaggedComponent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOITaggedComponent); static; overload;
  end;

  OOITaggedProfileHelper = class abstract external 'org.omg.IOP' name 'TaggedProfileHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOITaggedProfile); static; overload;
    class function extract(para1: OOCAny): OOITaggedProfile; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOITaggedProfile; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOITaggedProfile); static; overload;
  end;

  OOITransactionService = interface external 'org.omg.IOP' name 'TransactionService' 
    const
      value = 0;
  end;

  OOMSYNC_WITH_TRANSPORT = interface external 'org.omg.Messaging' name 'SYNC_WITH_TRANSPORT' 
    const
      value = 1;
  end;

  OOMSyncScopeHelper = class abstract external 'org.omg.Messaging' name 'SyncScopeHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jshort); static; overload;
    class function extract(para1: OOCAny): jshort; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jshort; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jshort); static; overload;
  end;

  OOPACTIVE = interface external 'org.omg.PortableInterceptor' name 'ACTIVE' 
    const
      value = 1;
  end;

  OOPAdapterManagerIdHelper = class abstract external 'org.omg.PortableInterceptor' name 'AdapterManagerIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jint); static; overload;
    class function extract(para1: OOCAny): jint; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jint; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jint); static; overload;
  end;

  OOPAdapterNameHelper = class abstract external 'org.omg.PortableInterceptor' name 'AdapterNameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1JLString); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of JLString); static; overload;
    class function extract(para1: OOCAny): Arr1JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1JLString); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of JLString); static; overload;
  end;

  OOPAdapterStateHelper = class abstract external 'org.omg.PortableInterceptor' name 'AdapterStateHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: jshort); static; overload;
    class function extract(para1: OOCAny): jshort; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): jshort; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: jshort); static; overload;
  end;

  OOPInterceptorCurrentHelper = class abstract external 'org.omg.PortableInterceptor' name 'CurrentHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPInterceptorCurrent); static; overload;
    class function extract(para1: OOCAny): OOPInterceptorCurrent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPInterceptorCurrent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPInterceptorCurrent); static; overload;
    class function narrow(para1: OOCObject): OOPInterceptorCurrent; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOPInterceptorCurrent; static; overload;
  end;

  OOPDISCARDING = interface external 'org.omg.PortableInterceptor' name 'DISCARDING' 
    const
      value = 2;
  end;

  OOPInterceptorForwardRequestHelper = class abstract external 'org.omg.PortableInterceptor' name 'ForwardRequestHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPInterceptorForwardRequest); static; overload;
    class function extract(para1: OOCAny): OOPInterceptorForwardRequest; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPInterceptorForwardRequest; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPInterceptorForwardRequest); static; overload;
  end;

  OOPHOLDING = interface external 'org.omg.PortableInterceptor' name 'HOLDING' 
    const
      value = 0;
  end;

  OOPINACTIVE = interface external 'org.omg.PortableInterceptor' name 'INACTIVE' 
    const
      value = 3;
  end;

  OOPIORInfoOperations = interface external 'org.omg.PortableInterceptor' name 'IORInfoOperations' 
    function get_effective_policy(para1: jint): OOCPolicy; overload;
    procedure add_ior_component(para1: OOITaggedComponent); overload;
    procedure add_ior_component_to_profile(para1: OOITaggedComponent; para2: jint); overload;
    function manager_id(): jint; overload;
    function state(): jshort; overload;
    function adapter_template(): OOPObjectReferenceTemplate; overload;
    function current_factory(): OOPObjectReferenceFactory; overload;
    procedure current_factory(para1: OOPObjectReferenceFactory); overload;
  end;

  OOPIORInterceptor_3_0Helper = class abstract external 'org.omg.PortableInterceptor' name 'IORInterceptor_3_0Helper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPIORInterceptor_3_0); static; overload;
    class function extract(para1: OOCAny): OOPIORInterceptor_3_0; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPIORInterceptor_3_0; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPIORInterceptor_3_0); static; overload;
    class function narrow(para1: OOCObject): OOPIORInterceptor_3_0; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOPIORInterceptor_3_0; static; overload;
  end;

  OOPInterceptorOperations = interface external 'org.omg.PortableInterceptor' name 'InterceptorOperations' 
    function name(): JLString; overload;
    procedure destroy(); overload;
  end;

  OOPInvalidSlotHelper = class abstract external 'org.omg.PortableInterceptor' name 'InvalidSlotHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPInvalidSlot); static; overload;
    class function extract(para1: OOCAny): OOPInvalidSlot; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPInvalidSlot; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPInvalidSlot); static; overload;
  end;

  OOPLOCATION_FORWARD = interface external 'org.omg.PortableInterceptor' name 'LOCATION_FORWARD' 
    const
      value = 3;
  end;

  OOPNON_EXISTENT = interface external 'org.omg.PortableInterceptor' name 'NON_EXISTENT' 
    const
      value = 4;
  end;

  OOPORBIdHelper = class abstract external 'org.omg.PortableInterceptor' name 'ORBIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOPORBInitInfoOperations = interface external 'org.omg.PortableInterceptor' name 'ORBInitInfoOperations' 
    function arguments(): Arr1JLString; overload;
    function orb_id(): JLString; overload;
    function codec_factory(): OOICodecFactory; overload;
    procedure register_initial_reference(para1: JLString; para2: OOCObject); overload;  // throws org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName
    function resolve_initial_references(para1: JLString): OOCObject; overload;  // throws org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName
    procedure add_client_request_interceptor(para1: OOPClientRequestInterceptor); overload;  // throws org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName
    procedure add_server_request_interceptor(para1: OOPServerRequestInterceptor); overload;  // throws org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName
    procedure add_ior_interceptor(para1: OOPIORInterceptor); overload;  // throws org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName
    function allocate_slot_id(): jint; overload;
    procedure register_policy_factory(para1: jint; para2: OOPPolicyFactory); overload;
  end;

  OOPODuplicateNameHelper = class abstract external 'org.omg.PortableInterceptor.ORBInitInfoPackage' name 'DuplicateNameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPODuplicateName); static; overload;
    class function extract(para1: OOCAny): OOPODuplicateName; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPODuplicateName; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPODuplicateName); static; overload;
  end;

  OOPOInvalidNameHelper = class abstract external 'org.omg.PortableInterceptor.ORBInitInfoPackage' name 'InvalidNameHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPOInvalidName); static; overload;
    class function extract(para1: OOCAny): OOPOInvalidName; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPOInvalidName; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPOInvalidName); static; overload;
  end;

  OOPOObjectIdHelper = class abstract external 'org.omg.PortableInterceptor.ORBInitInfoPackage' name 'ObjectIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOPORBInitializerOperations = interface external 'org.omg.PortableInterceptor' name 'ORBInitializerOperations' 
    procedure pre_init(para1: OOPORBInitInfo); overload;
    procedure post_init(para1: OOPORBInitInfo); overload;
  end;

  OOPObjectIdHelper = class abstract external 'org.omg.PortableInterceptor' name 'ObjectIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1jbyte); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of jbyte); static; overload;
    class function extract(para1: OOCAny): Arr1jbyte; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1jbyte; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1jbyte); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of jbyte); static; overload;
  end;

  OOPObjectReferenceFactoryHelper = class abstract external 'org.omg.PortableInterceptor' name 'ObjectReferenceFactoryHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPObjectReferenceFactory); static; overload;
    class function extract(para1: OOCAny): OOPObjectReferenceFactory; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPObjectReferenceFactory; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPObjectReferenceFactory); static; overload;
  end;

  OOPObjectReferenceTemplateHelper = class abstract external 'org.omg.PortableInterceptor' name 'ObjectReferenceTemplateHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPObjectReferenceTemplate); static; overload;
    class function extract(para1: OOCAny): OOPObjectReferenceTemplate; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPObjectReferenceTemplate; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPObjectReferenceTemplate); static; overload;
  end;

  OOPObjectReferenceTemplateSeqHelper = class abstract external 'org.omg.PortableInterceptor' name 'ObjectReferenceTemplateSeqHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: Arr1OOPObjectReferenceTemplate); static; overload;
    class procedure insert(para1: OOCAny; var para2: array of OOPObjectReferenceTemplate); static; overload;
    class function extract(para1: OOCAny): Arr1OOPObjectReferenceTemplate; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): Arr1OOPObjectReferenceTemplate; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: Arr1OOPObjectReferenceTemplate); static; overload;
    class procedure write(para1: OOCPOutputStream; var para2: array of OOPObjectReferenceTemplate); static; overload;
  end;

  OOPPolicyFactoryOperations = interface external 'org.omg.PortableInterceptor' name 'PolicyFactoryOperations' 
    function create_policy(para1: jint; para2: OOCAny): OOCPolicy; overload;  // throws org.omg.CORBA.PolicyError
  end;

  OOPRequestInfoOperations = interface external 'org.omg.PortableInterceptor' name 'RequestInfoOperations' 
    function request_id(): jint; overload;
    function operation(): JLString; overload;
    function arguments(): Arr1OODParameter; overload;
    function exceptions(): Arr1OOCTypeCode; overload;
    function contexts(): Arr1JLString; overload;
    function operation_context(): Arr1JLString; overload;
    function result(): OOCAny; overload;
    function response_expected(): jboolean; overload;
    function sync_scope(): jshort; overload;
    function reply_status(): jshort; overload;
    function forward_reference(): OOCObject; overload;
    function get_slot(para1: jint): OOCAny; overload;  // throws org.omg.PortableInterceptor.InvalidSlot
    function get_request_service_context(para1: jint): OOIServiceContext; overload;
    function get_reply_service_context(para1: jint): OOIServiceContext; overload;
  end;

  OOPSUCCESSFUL = interface external 'org.omg.PortableInterceptor' name 'SUCCESSFUL' 
    const
      value = 0;
  end;

  OOPSYSTEM_EXCEPTION = interface external 'org.omg.PortableInterceptor' name 'SYSTEM_EXCEPTION' 
    const
      value = 1;
  end;

  OOPServerIdHelper = class abstract external 'org.omg.PortableInterceptor' name 'ServerIdHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: JLString); static; overload;
    class function extract(para1: OOCAny): JLString; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): JLString; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: JLString); static; overload;
  end;

  OOPTRANSPORT_RETRY = interface external 'org.omg.PortableInterceptor' name 'TRANSPORT_RETRY' 
    const
      value = 4;
  end;

  OOPUSER_EXCEPTION = interface external 'org.omg.PortableInterceptor' name 'USER_EXCEPTION' 
    const
      value = 2;
  end;

  OOPAdapterActivatorOperations = interface external 'org.omg.PortableServer' name 'AdapterActivatorOperations' 
    function unknown_adapter(para1: OOPPOA; para2: JLString): jboolean; overload;
  end;

  OOPServerCurrentHelper = class abstract external 'org.omg.PortableServer' name 'CurrentHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPServerCurrent); static; overload;
    class function extract(para1: OOCAny): OOPServerCurrent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPServerCurrent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPServerCurrent); static; overload;
    class function narrow(para1: OOCObject): OOPServerCurrent; static; overload;
  end;

  OOPCNoContextHelper = class abstract external 'org.omg.PortableServer.CurrentPackage' name 'NoContextHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPCNoContext); static; overload;
    class function extract(para1: OOCAny): OOPCNoContext; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPCNoContext; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPCNoContext); static; overload;
  end;

  OOPServerForwardRequestHelper = class abstract external 'org.omg.PortableServer' name 'ForwardRequestHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPServerForwardRequest); static; overload;
    class function extract(para1: OOCAny): OOPServerForwardRequest; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPServerForwardRequest; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPServerForwardRequest); static; overload;
  end;

  OOPID_ASSIGNMENT_POLICY_ID = interface external 'org.omg.PortableServer' name 'ID_ASSIGNMENT_POLICY_ID' 
    const
      value = 19;
  end;

  OOPID_UNIQUENESS_POLICY_ID = interface external 'org.omg.PortableServer' name 'ID_UNIQUENESS_POLICY_ID' 
    const
      value = 18;
  end;

  OOPIMPLICIT_ACTIVATION_POLICY_ID = interface external 'org.omg.PortableServer' name 'IMPLICIT_ACTIVATION_POLICY_ID' 
    const
      value = 20;
  end;

  OOPLIFESPAN_POLICY_ID = interface external 'org.omg.PortableServer' name 'LIFESPAN_POLICY_ID' 
    const
      value = 17;
  end;

  OOPPOAHelper = class abstract external 'org.omg.PortableServer' name 'POAHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPOA); static; overload;
    class function extract(para1: OOCAny): OOPPOA; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPOA; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPOA); static; overload;
    class function narrow(para1: OOCObject): OOPPOA; static; overload;
  end;

  OOPPOAManagerOperations = interface external 'org.omg.PortableServer' name 'POAManagerOperations' 
    procedure activate(); overload;  // throws org.omg.PortableServer.POAManagerPackage.AdapterInactive
    procedure hold_requests(para1: jboolean); overload;  // throws org.omg.PortableServer.POAManagerPackage.AdapterInactive
    procedure discard_requests(para1: jboolean); overload;  // throws org.omg.PortableServer.POAManagerPackage.AdapterInactive
    procedure deactivate(para1: jboolean; para2: jboolean); overload;  // throws org.omg.PortableServer.POAManagerPackage.AdapterInactive
    function get_state(): OOPPState; overload;
  end;

  OOPPAdapterInactiveHelper = class abstract external 'org.omg.PortableServer.POAManagerPackage' name 'AdapterInactiveHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPAdapterInactive); static; overload;
    class function extract(para1: OOCAny): OOPPAdapterInactive; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPAdapterInactive; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPAdapterInactive); static; overload;
  end;

  OOPPOAOperations = interface external 'org.omg.PortableServer' name 'POAOperations' 
    function create_POA(para1: JLString; para2: OOPPOAManager; para3: Arr1OOCPolicy): OOPPOA; overload;  // throws org.omg.PortableServer.POAPackage.AdapterAlreadyExists, org.omg.PortableServer.POAPackage.InvalidPolicy
    function create_POA(para1: JLString; para2: OOPPOAManager; var para3: array of OOCPolicy): OOPPOA; overload;  // throws org.omg.PortableServer.POAPackage.AdapterAlreadyExists, org.omg.PortableServer.POAPackage.InvalidPolicy
    function find_POA(para1: JLString; para2: jboolean): OOPPOA; overload;  // throws org.omg.PortableServer.POAPackage.AdapterNonExistent
    procedure destroy(para1: jboolean; para2: jboolean); overload;
    function create_thread_policy(para1: OOPThreadPolicyValue): OOPThreadPolicy; overload;
    function create_lifespan_policy(para1: OOPLifespanPolicyValue): OOPLifespanPolicy; overload;
    function create_id_uniqueness_policy(para1: OOPIdUniquenessPolicyValue): OOPIdUniquenessPolicy; overload;
    function create_id_assignment_policy(para1: OOPIdAssignmentPolicyValue): OOPIdAssignmentPolicy; overload;
    function create_implicit_activation_policy(para1: OOPImplicitActivationPolicyValue): OOPImplicitActivationPolicy; overload;
    function create_servant_retention_policy(para1: OOPServantRetentionPolicyValue): OOPServantRetentionPolicy; overload;
    function create_request_processing_policy(para1: OOPRequestProcessingPolicyValue): OOPRequestProcessingPolicy; overload;
    function the_name(): JLString; overload;
    function the_parent(): OOPPOA; overload;
    function the_children(): Arr1OOPPOA; overload;
    function the_POAManager(): OOPPOAManager; overload;
    function the_activator(): OOPAdapterActivator; overload;
    procedure the_activator(para1: OOPAdapterActivator); overload;
    function get_servant_manager(): OOPServantManager; overload;  // throws org.omg.PortableServer.POAPackage.WrongPolicy
    procedure set_servant_manager(para1: OOPServantManager); overload;  // throws org.omg.PortableServer.POAPackage.WrongPolicy
    function get_servant(): OOPServant; overload;  // throws org.omg.PortableServer.POAPackage.NoServant, org.omg.PortableServer.POAPackage.WrongPolicy
    procedure set_servant(para1: OOPServant); overload;  // throws org.omg.PortableServer.POAPackage.WrongPolicy
    function activate_object(para1: OOPServant): Arr1jbyte; overload;  // throws org.omg.PortableServer.POAPackage.ServantAlreadyActive, org.omg.PortableServer.POAPackage.WrongPolicy
    procedure activate_object_with_id(para1: Arr1jbyte; para2: OOPServant); overload;  // throws org.omg.PortableServer.POAPackage.ServantAlreadyActive, org.omg.PortableServer.POAPackage.ObjectAlreadyActive, org.omg.PortableServer.POAPackage.WrongPolicy
    procedure activate_object_with_id(var para1: array of jbyte; para2: OOPServant); overload;  // throws org.omg.PortableServer.POAPackage.ServantAlreadyActive, org.omg.PortableServer.POAPackage.ObjectAlreadyActive, org.omg.PortableServer.POAPackage.WrongPolicy
    procedure deactivate_object(para1: Arr1jbyte); overload;  // throws org.omg.PortableServer.POAPackage.ObjectNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    procedure deactivate_object(var para1: array of jbyte); overload;  // throws org.omg.PortableServer.POAPackage.ObjectNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    function create_reference(para1: JLString): OOCObject; overload;  // throws org.omg.PortableServer.POAPackage.WrongPolicy
    function create_reference_with_id(para1: Arr1jbyte; para2: JLString): OOCObject; overload;
    function create_reference_with_id(var para1: array of jbyte; para2: JLString): OOCObject; overload;
    function servant_to_id(para1: OOPServant): Arr1jbyte; overload;  // throws org.omg.PortableServer.POAPackage.ServantNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    function servant_to_reference(para1: OOPServant): OOCObject; overload;  // throws org.omg.PortableServer.POAPackage.ServantNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    function reference_to_servant(para1: OOCObject): OOPServant; overload;  // throws org.omg.PortableServer.POAPackage.ObjectNotActive, org.omg.PortableServer.POAPackage.WrongPolicy, org.omg.PortableServer.POAPackage.WrongAdapter
    function reference_to_id(para1: OOCObject): Arr1jbyte; overload;  // throws org.omg.PortableServer.POAPackage.WrongAdapter, org.omg.PortableServer.POAPackage.WrongPolicy
    function id_to_servant(para1: Arr1jbyte): OOPServant; overload;  // throws org.omg.PortableServer.POAPackage.ObjectNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    function id_to_servant(var para1: array of jbyte): OOPServant; overload;  // throws org.omg.PortableServer.POAPackage.ObjectNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    function id_to_reference(para1: Arr1jbyte): OOCObject; overload;  // throws org.omg.PortableServer.POAPackage.ObjectNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    function id_to_reference(var para1: array of jbyte): OOCObject; overload;  // throws org.omg.PortableServer.POAPackage.ObjectNotActive, org.omg.PortableServer.POAPackage.WrongPolicy
    function id(): Arr1jbyte; overload;
  end;

  OOPPAdapterAlreadyExistsHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'AdapterAlreadyExistsHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPAdapterAlreadyExists); static; overload;
    class function extract(para1: OOCAny): OOPPAdapterAlreadyExists; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPAdapterAlreadyExists; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPAdapterAlreadyExists); static; overload;
  end;

  OOPPAdapterNonExistentHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'AdapterNonExistentHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPAdapterNonExistent); static; overload;
    class function extract(para1: OOCAny): OOPPAdapterNonExistent; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPAdapterNonExistent; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPAdapterNonExistent); static; overload;
  end;

  OOPPInvalidPolicyHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'InvalidPolicyHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPInvalidPolicy); static; overload;
    class function extract(para1: OOCAny): OOPPInvalidPolicy; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPInvalidPolicy; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPInvalidPolicy); static; overload;
  end;

  OOPPNoServantHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'NoServantHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPNoServant); static; overload;
    class function extract(para1: OOCAny): OOPPNoServant; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPNoServant; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPNoServant); static; overload;
  end;

  OOPPObjectAlreadyActiveHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'ObjectAlreadyActiveHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPObjectAlreadyActive); static; overload;
    class function extract(para1: OOCAny): OOPPObjectAlreadyActive; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPObjectAlreadyActive; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPObjectAlreadyActive); static; overload;
  end;

  OOPPObjectNotActiveHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'ObjectNotActiveHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPObjectNotActive); static; overload;
    class function extract(para1: OOCAny): OOPPObjectNotActive; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPObjectNotActive; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPObjectNotActive); static; overload;
  end;

  OOPPServantAlreadyActiveHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'ServantAlreadyActiveHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPServantAlreadyActive); static; overload;
    class function extract(para1: OOCAny): OOPPServantAlreadyActive; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPServantAlreadyActive; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPServantAlreadyActive); static; overload;
  end;

  OOPPServantNotActiveHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'ServantNotActiveHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPServantNotActive); static; overload;
    class function extract(para1: OOCAny): OOPPServantNotActive; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPServantNotActive; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPServantNotActive); static; overload;
  end;

  OOPPWrongAdapterHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'WrongAdapterHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPWrongAdapter); static; overload;
    class function extract(para1: OOCAny): OOPPWrongAdapter; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPWrongAdapter; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPWrongAdapter); static; overload;
  end;

  OOPPWrongPolicyHelper = class abstract external 'org.omg.PortableServer.POAPackage' name 'WrongPolicyHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPPWrongPolicy); static; overload;
    class function extract(para1: OOCAny): OOPPWrongPolicy; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPPWrongPolicy; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPPWrongPolicy); static; overload;
  end;

  OOPREQUEST_PROCESSING_POLICY_ID = interface external 'org.omg.PortableServer' name 'REQUEST_PROCESSING_POLICY_ID' 
    const
      value = 22;
  end;

  OOPSERVANT_RETENTION_POLICY_ID = interface external 'org.omg.PortableServer' name 'SERVANT_RETENTION_POLICY_ID' 
    const
      value = 21;
  end;

  OOPServant = class abstract external 'org.omg.PortableServer' name 'Servant' (JLObject)
  public
    constructor create(); overload;
    function _get_delegate(): OOPPDelegate; overload; virtual; final;
    procedure _set_delegate(para1: OOPPDelegate); overload; virtual; final;
    function _this_object(): OOCObject; overload; virtual; final;
    function _this_object(para1: OOCORB): OOCObject; overload; virtual; final;
    function _orb(): OOCORB; overload; virtual; final;
    function _poa(): OOPPOA; overload; virtual; final;
    function _object_id(): Arr1jbyte; overload; virtual; final;
    function _default_POA(): OOPPOA; overload; virtual;
    function _is_a(para1: JLString): jboolean; overload; virtual;
    function _non_existent(): jboolean; overload; virtual;
    function _get_interface_def(): OOCObject; overload; virtual;
    function _all_interfaces(para1: OOPPOA; para2: Arr1jbyte): Arr1JLString; overload; virtual; abstract;
    function _all_interfaces(para1: OOPPOA; var para2: array of jbyte): Arr1JLString; overload; virtual; abstract;
  end;

  OOPServantActivatorHelper = class abstract external 'org.omg.PortableServer' name 'ServantActivatorHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPServantActivator); static; overload;
    class function extract(para1: OOCAny): OOPServantActivator; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPServantActivator; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPServantActivator); static; overload;
    class function narrow(para1: OOCObject): OOPServantActivator; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOPServantActivator; static; overload;
  end;

  OOPServantLocatorHelper = class abstract external 'org.omg.PortableServer' name 'ServantLocatorHelper' (JLObject)
  public
    constructor create(); overload;
    class procedure insert(para1: OOCAny; para2: OOPServantLocator); static; overload;
    class function extract(para1: OOCAny): OOPServantLocator; static; overload;
    class function &type(): OOCTypeCode; static; overload;
    class function id(): JLString; static; overload;
    class function read(para1: OOCPInputStream): OOPServantLocator; static; overload;
    class procedure write(para1: OOCPOutputStream; para2: OOPServantLocator); static; overload;
    class function narrow(para1: OOCObject): OOPServantLocator; static; overload;
    class function unchecked_narrow(para1: OOCObject): OOPServantLocator; static; overload;
  end;

  OOPServantManagerOperations = interface external 'org.omg.PortableServer' name 'ServantManagerOperations' 
  end;

  OOPTHREAD_POLICY_ID = interface external 'org.omg.PortableServer' name 'THREAD_POLICY_ID' 
    const
      value = 16;
  end;

  OOPPDelegate = interface external 'org.omg.PortableServer.portable' name 'Delegate' 
    function orb(para1: OOPServant): OOCORB; overload;
    function this_object(para1: OOPServant): OOCObject; overload;
    function poa(para1: OOPServant): OOPPOA; overload;
    function object_id(para1: OOPServant): Arr1jbyte; overload;
    function default_POA(para1: OOPServant): OOPPOA; overload;
    function is_a(para1: OOPServant; para2: JLString): jboolean; overload;
    function non_existent(para1: OOPServant): jboolean; overload;
    function get_interface_def(para1: OOPServant): OOCObject; overload;
  end;

  OOSRunTimeOperations = interface external 'org.omg.SendingContext' name 'RunTimeOperations' 
  end;

  OWDDOMConfiguration = interface external 'org.w3c.dom' name 'DOMConfiguration' 
    procedure setParameter(para1: JLString; para2: JLObject); overload;  // throws org.w3c.dom.DOMException
    function getParameter(para1: JLString): JLObject; overload;  // throws org.w3c.dom.DOMException
    function canSetParameter(para1: JLString; para2: JLObject): jboolean; overload;
    function getParameterNames(): OWDDOMStringList; overload;
  end;

  OWDDOMError = interface external 'org.w3c.dom' name 'DOMError' 
    const
      SEVERITY_WARNING = 1;
      SEVERITY_ERROR = 2;
      SEVERITY_FATAL_ERROR = 3;
    function getSeverity(): jshort; overload;
    function getMessage(): JLString; overload;
    function getType(): JLString; overload;
    function getRelatedException(): JLObject; overload;
    function getRelatedData(): JLObject; overload;
    function getLocation(): OWDDOMLocator; overload;
  end;

  OWDDOMErrorHandler = interface external 'org.w3c.dom' name 'DOMErrorHandler' 
    function handleError(para1: OWDDOMError): jboolean; overload;
  end;

  OWDDOMImplementation = interface external 'org.w3c.dom' name 'DOMImplementation' 
    function hasFeature(para1: JLString; para2: JLString): jboolean; overload;
    function createDocumentType(para1: JLString; para2: JLString; para3: JLString): OWDDocumentType; overload;  // throws org.w3c.dom.DOMException
    function createDocument(para1: JLString; para2: JLString; para3: OWDDocumentType): OWDDocument; overload;  // throws org.w3c.dom.DOMException
    function getFeature(para1: JLString; para2: JLString): JLObject; overload;
  end;

  OWDDOMImplementationList = interface external 'org.w3c.dom' name 'DOMImplementationList' 
    function item(para1: jint): OWDDOMImplementation; overload;
    function getLength(): jint; overload;
  end;

  OWDDOMImplementationSource = interface external 'org.w3c.dom' name 'DOMImplementationSource' 
    function getDOMImplementation(para1: JLString): OWDDOMImplementation; overload;
    function getDOMImplementationList(para1: JLString): OWDDOMImplementationList; overload;
  end;

  OWDDOMLocator = interface external 'org.w3c.dom' name 'DOMLocator' 
    function getLineNumber(): jint; overload;
    function getColumnNumber(): jint; overload;
    function getByteOffset(): jint; overload;
    function getUtf16Offset(): jint; overload;
    function getRelatedNode(): OWDNode; overload;
    function getUri(): JLString; overload;
  end;

  OWDDOMStringList = interface external 'org.w3c.dom' name 'DOMStringList' 
    function item(para1: jint): JLString; overload;
    function getLength(): jint; overload;
    function contains(para1: JLString): jboolean; overload;
  end;

  OWDNameList = interface external 'org.w3c.dom' name 'NameList' 
    function getName(para1: jint): JLString; overload;
    function getNamespaceURI(para1: jint): JLString; overload;
    function getLength(): jint; overload;
    function contains(para1: JLString): jboolean; overload;
    function containsNS(para1: JLString; para2: JLString): jboolean; overload;
  end;

  OWDNamedNodeMap = interface external 'org.w3c.dom' name 'NamedNodeMap' 
    function getNamedItem(para1: JLString): OWDNode; overload;
    function setNamedItem(para1: OWDNode): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function removeNamedItem(para1: JLString): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function item(para1: jint): OWDNode; overload;
    function getLength(): jint; overload;
    function getNamedItemNS(para1: JLString; para2: JLString): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function setNamedItemNS(para1: OWDNode): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function removeNamedItemNS(para1: JLString; para2: JLString): OWDNode; overload;  // throws org.w3c.dom.DOMException
  end;

  OWDNode = interface external 'org.w3c.dom' name 'Node' 
    const
      ELEMENT_NODE = 1;
      ATTRIBUTE_NODE = 2;
      TEXT_NODE = 3;
      CDATA_SECTION_NODE = 4;
      ENTITY_REFERENCE_NODE = 5;
      ENTITY_NODE = 6;
      PROCESSING_INSTRUCTION_NODE = 7;
      COMMENT_NODE = 8;
      DOCUMENT_NODE = 9;
      DOCUMENT_TYPE_NODE = 10;
      DOCUMENT_FRAGMENT_NODE = 11;
      NOTATION_NODE = 12;
      DOCUMENT_POSITION_DISCONNECTED = 1;
      DOCUMENT_POSITION_PRECEDING = 2;
      DOCUMENT_POSITION_FOLLOWING = 4;
      DOCUMENT_POSITION_CONTAINS = 8;
      DOCUMENT_POSITION_CONTAINED_BY = 16;
      DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    function getNodeName(): JLString; overload;
    function getNodeValue(): JLString; overload;  // throws org.w3c.dom.DOMException
    procedure setNodeValue(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getNodeType(): jshort; overload;
    function getParentNode(): OWDNode; overload;
    function getChildNodes(): OWDNodeList; overload;
    function getFirstChild(): OWDNode; overload;
    function getLastChild(): OWDNode; overload;
    function getPreviousSibling(): OWDNode; overload;
    function getNextSibling(): OWDNode; overload;
    function getAttributes(): OWDNamedNodeMap; overload;
    function getOwnerDocument(): OWDDocument; overload;
    function insertBefore(para1: OWDNode; para2: OWDNode): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function replaceChild(para1: OWDNode; para2: OWDNode): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function removeChild(para1: OWDNode): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function appendChild(para1: OWDNode): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function hasChildNodes(): jboolean; overload;
    function cloneNode(para1: jboolean): OWDNode; overload;
    procedure normalize(); overload;
    function isSupported(para1: JLString; para2: JLString): jboolean; overload;
    function getNamespaceURI(): JLString; overload;
    function getPrefix(): JLString; overload;
    procedure setPrefix(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getLocalName(): JLString; overload;
    function hasAttributes(): jboolean; overload;
    function getBaseURI(): JLString; overload;
    function compareDocumentPosition(para1: OWDNode): jshort; overload;  // throws org.w3c.dom.DOMException
    function getTextContent(): JLString; overload;  // throws org.w3c.dom.DOMException
    procedure setTextContent(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function isSameNode(para1: OWDNode): jboolean; overload;
    function lookupPrefix(para1: JLString): JLString; overload;
    function isDefaultNamespace(para1: JLString): jboolean; overload;
    function lookupNamespaceURI(para1: JLString): JLString; overload;
    function isEqualNode(para1: OWDNode): jboolean; overload;
    function getFeature(para1: JLString; para2: JLString): JLObject; overload;
    function setUserData(para1: JLString; para2: JLObject; para3: OWDUserDataHandler): JLObject; overload;
    function getUserData(para1: JLString): JLObject; overload;
  end;

  OWDNodeList = interface external 'org.w3c.dom' name 'NodeList' 
    function item(para1: jint): OWDNode; overload;
    function getLength(): jint; overload;
  end;

  OWDTypeInfo = interface external 'org.w3c.dom' name 'TypeInfo' 
    const
      DERIVATION_RESTRICTION = 1;
      DERIVATION_EXTENSION = 2;
      DERIVATION_UNION = 4;
      DERIVATION_LIST = 8;
    function getTypeName(): JLString; overload;
    function getTypeNamespace(): JLString; overload;
    function isDerivedFrom(para1: JLString; para2: JLString; para3: jint): jboolean; overload;
  end;

  OWDUserDataHandler = interface external 'org.w3c.dom' name 'UserDataHandler' 
    const
      NODE_CLONED = 1;
      NODE_IMPORTED = 2;
      NODE_DELETED = 3;
      NODE_RENAMED = 4;
      NODE_ADOPTED = 5;
    procedure handle(para1: jshort; para2: JLString; para3: JLObject; para4: OWDNode; para5: OWDNode); overload;
  end;

  OWDBDOMImplementationRegistry = class sealed external 'org.w3c.dom.bootstrap' name 'DOMImplementationRegistry' (JLObject)
  public
    const
      &PROPERTY = 'org.w3c.dom.DOMImplementationSourceList';
  public
    class function newInstance(): OWDBDOMImplementationRegistry; static; overload;  // throws java.lang.ClassNotFoundException, java.lang.InstantiationException, java.lang.IllegalAccessException, java.lang.ClassCastException
    function getDOMImplementation(para1: JLString): OWDDOMImplementation; overload; virtual;
    function getDOMImplementationList(para1: JLString): OWDDOMImplementationList; overload; virtual;
    procedure addSource(para1: OWDDOMImplementationSource); overload; virtual;
  end;

  OWDCCSS2Properties = interface external 'org.w3c.dom.css' name 'CSS2Properties' 
    function getAzimuth(): JLString; overload;
    procedure setAzimuth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBackground(): JLString; overload;
    procedure setBackground(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBackgroundAttachment(): JLString; overload;
    procedure setBackgroundAttachment(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBackgroundColor(): JLString; overload;
    procedure setBackgroundColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBackgroundImage(): JLString; overload;
    procedure setBackgroundImage(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBackgroundPosition(): JLString; overload;
    procedure setBackgroundPosition(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBackgroundRepeat(): JLString; overload;
    procedure setBackgroundRepeat(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorder(): JLString; overload;
    procedure setBorder(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderCollapse(): JLString; overload;
    procedure setBorderCollapse(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderColor(): JLString; overload;
    procedure setBorderColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderSpacing(): JLString; overload;
    procedure setBorderSpacing(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderStyle(): JLString; overload;
    procedure setBorderStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderTop(): JLString; overload;
    procedure setBorderTop(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderRight(): JLString; overload;
    procedure setBorderRight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderBottom(): JLString; overload;
    procedure setBorderBottom(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderLeft(): JLString; overload;
    procedure setBorderLeft(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderTopColor(): JLString; overload;
    procedure setBorderTopColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderRightColor(): JLString; overload;
    procedure setBorderRightColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderBottomColor(): JLString; overload;
    procedure setBorderBottomColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderLeftColor(): JLString; overload;
    procedure setBorderLeftColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderTopStyle(): JLString; overload;
    procedure setBorderTopStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderRightStyle(): JLString; overload;
    procedure setBorderRightStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderBottomStyle(): JLString; overload;
    procedure setBorderBottomStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderLeftStyle(): JLString; overload;
    procedure setBorderLeftStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderTopWidth(): JLString; overload;
    procedure setBorderTopWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderRightWidth(): JLString; overload;
    procedure setBorderRightWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderBottomWidth(): JLString; overload;
    procedure setBorderBottomWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderLeftWidth(): JLString; overload;
    procedure setBorderLeftWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBorderWidth(): JLString; overload;
    procedure setBorderWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getBottom(): JLString; overload;
    procedure setBottom(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCaptionSide(): JLString; overload;
    procedure setCaptionSide(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getClear(): JLString; overload;
    procedure setClear(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getClip(): JLString; overload;
    procedure setClip(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getColor(): JLString; overload;
    procedure setColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getContent(): JLString; overload;
    procedure setContent(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCounterIncrement(): JLString; overload;
    procedure setCounterIncrement(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCounterReset(): JLString; overload;
    procedure setCounterReset(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCue(): JLString; overload;
    procedure setCue(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCueAfter(): JLString; overload;
    procedure setCueAfter(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCueBefore(): JLString; overload;
    procedure setCueBefore(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCursor(): JLString; overload;
    procedure setCursor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getDirection(): JLString; overload;
    procedure setDirection(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getDisplay(): JLString; overload;
    procedure setDisplay(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getElevation(): JLString; overload;
    procedure setElevation(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getEmptyCells(): JLString; overload;
    procedure setEmptyCells(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCssFloat(): JLString; overload;
    procedure setCssFloat(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFont(): JLString; overload;
    procedure setFont(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFontFamily(): JLString; overload;
    procedure setFontFamily(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFontSize(): JLString; overload;
    procedure setFontSize(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFontSizeAdjust(): JLString; overload;
    procedure setFontSizeAdjust(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFontStretch(): JLString; overload;
    procedure setFontStretch(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFontStyle(): JLString; overload;
    procedure setFontStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFontVariant(): JLString; overload;
    procedure setFontVariant(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getFontWeight(): JLString; overload;
    procedure setFontWeight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getHeight(): JLString; overload;
    procedure setHeight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getLeft(): JLString; overload;
    procedure setLeft(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getLetterSpacing(): JLString; overload;
    procedure setLetterSpacing(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getLineHeight(): JLString; overload;
    procedure setLineHeight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getListStyle(): JLString; overload;
    procedure setListStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getListStyleImage(): JLString; overload;
    procedure setListStyleImage(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getListStylePosition(): JLString; overload;
    procedure setListStylePosition(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getListStyleType(): JLString; overload;
    procedure setListStyleType(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMargin(): JLString; overload;
    procedure setMargin(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMarginTop(): JLString; overload;
    procedure setMarginTop(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMarginRight(): JLString; overload;
    procedure setMarginRight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMarginBottom(): JLString; overload;
    procedure setMarginBottom(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMarginLeft(): JLString; overload;
    procedure setMarginLeft(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMarkerOffset(): JLString; overload;
    procedure setMarkerOffset(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMarks(): JLString; overload;
    procedure setMarks(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMaxHeight(): JLString; overload;
    procedure setMaxHeight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMaxWidth(): JLString; overload;
    procedure setMaxWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMinHeight(): JLString; overload;
    procedure setMinHeight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getMinWidth(): JLString; overload;
    procedure setMinWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getOrphans(): JLString; overload;
    procedure setOrphans(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getOutline(): JLString; overload;
    procedure setOutline(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getOutlineColor(): JLString; overload;
    procedure setOutlineColor(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getOutlineStyle(): JLString; overload;
    procedure setOutlineStyle(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getOutlineWidth(): JLString; overload;
    procedure setOutlineWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getOverflow(): JLString; overload;
    procedure setOverflow(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPadding(): JLString; overload;
    procedure setPadding(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPaddingTop(): JLString; overload;
    procedure setPaddingTop(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPaddingRight(): JLString; overload;
    procedure setPaddingRight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPaddingBottom(): JLString; overload;
    procedure setPaddingBottom(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPaddingLeft(): JLString; overload;
    procedure setPaddingLeft(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPage(): JLString; overload;
    procedure setPage(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPageBreakAfter(): JLString; overload;
    procedure setPageBreakAfter(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPageBreakBefore(): JLString; overload;
    procedure setPageBreakBefore(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPageBreakInside(): JLString; overload;
    procedure setPageBreakInside(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPause(): JLString; overload;
    procedure setPause(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPauseAfter(): JLString; overload;
    procedure setPauseAfter(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPauseBefore(): JLString; overload;
    procedure setPauseBefore(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPitch(): JLString; overload;
    procedure setPitch(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPitchRange(): JLString; overload;
    procedure setPitchRange(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPlayDuring(): JLString; overload;
    procedure setPlayDuring(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPosition(): JLString; overload;
    procedure setPosition(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getQuotes(): JLString; overload;
    procedure setQuotes(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getRichness(): JLString; overload;
    procedure setRichness(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getRight(): JLString; overload;
    procedure setRight(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getSize(): JLString; overload;
    procedure setSize(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getSpeak(): JLString; overload;
    procedure setSpeak(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getSpeakHeader(): JLString; overload;
    procedure setSpeakHeader(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getSpeakNumeral(): JLString; overload;
    procedure setSpeakNumeral(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getSpeakPunctuation(): JLString; overload;
    procedure setSpeakPunctuation(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getSpeechRate(): JLString; overload;
    procedure setSpeechRate(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getStress(): JLString; overload;
    procedure setStress(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getTableLayout(): JLString; overload;
    procedure setTableLayout(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getTextAlign(): JLString; overload;
    procedure setTextAlign(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getTextDecoration(): JLString; overload;
    procedure setTextDecoration(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getTextIndent(): JLString; overload;
    procedure setTextIndent(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getTextShadow(): JLString; overload;
    procedure setTextShadow(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getTextTransform(): JLString; overload;
    procedure setTextTransform(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getTop(): JLString; overload;
    procedure setTop(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getUnicodeBidi(): JLString; overload;
    procedure setUnicodeBidi(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getVerticalAlign(): JLString; overload;
    procedure setVerticalAlign(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getVisibility(): JLString; overload;
    procedure setVisibility(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getVoiceFamily(): JLString; overload;
    procedure setVoiceFamily(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getVolume(): JLString; overload;
    procedure setVolume(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getWhiteSpace(): JLString; overload;
    procedure setWhiteSpace(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getWidows(): JLString; overload;
    procedure setWidows(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getWidth(): JLString; overload;
    procedure setWidth(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getWordSpacing(): JLString; overload;
    procedure setWordSpacing(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getZIndex(): JLString; overload;
    procedure setZIndex(para1: JLString); overload;  // throws org.w3c.dom.DOMException
  end;

  OWDCCSSRule = interface external 'org.w3c.dom.css' name 'CSSRule' 
    const
      UNKNOWN_RULE = 0;
      STYLE_RULE = 1;
      CHARSET_RULE = 2;
      IMPORT_RULE = 3;
      MEDIA_RULE = 4;
      FONT_FACE_RULE = 5;
      PAGE_RULE = 6;
    function getType(): jshort; overload;
    function getCssText(): JLString; overload;
    procedure setCssText(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getParentStyleSheet(): OWDCCSSStyleSheet; overload;
    function getParentRule(): OWDCCSSRule; overload;
  end;

  OWDCCSSRuleList = interface external 'org.w3c.dom.css' name 'CSSRuleList' 
    function getLength(): jint; overload;
    function item(para1: jint): OWDCCSSRule; overload;
  end;

  OWDCCSSStyleDeclaration = interface external 'org.w3c.dom.css' name 'CSSStyleDeclaration' 
    function getCssText(): JLString; overload;
    procedure setCssText(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getPropertyValue(para1: JLString): JLString; overload;
    function getPropertyCSSValue(para1: JLString): OWDCCSSValue; overload;
    function removeProperty(para1: JLString): JLString; overload;  // throws org.w3c.dom.DOMException
    function getPropertyPriority(para1: JLString): JLString; overload;
    procedure setProperty(para1: JLString; para2: JLString; para3: JLString); overload;  // throws org.w3c.dom.DOMException
    function getLength(): jint; overload;
    function item(para1: jint): JLString; overload;
    function getParentRule(): OWDCCSSRule; overload;
  end;

  OWDCCSSValue = interface external 'org.w3c.dom.css' name 'CSSValue' 
    const
      CSS_INHERIT = 0;
      CSS_PRIMITIVE_VALUE = 1;
      CSS_VALUE_LIST = 2;
      CSS_CUSTOM = 3;
    function getCssText(): JLString; overload;
    procedure setCssText(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getCssValueType(): jshort; overload;
  end;

  OWDCCounter = interface external 'org.w3c.dom.css' name 'Counter' 
    function getIdentifier(): JLString; overload;
    function getListStyle(): JLString; overload;
    function getSeparator(): JLString; overload;
  end;

  OWDCElementCSSInlineStyle = interface external 'org.w3c.dom.css' name 'ElementCSSInlineStyle' 
    function getStyle(): OWDCCSSStyleDeclaration; overload;
  end;

  OWDCRGBColor = interface external 'org.w3c.dom.css' name 'RGBColor' 
    function getRed(): OWDCCSSPrimitiveValue; overload;
    function getGreen(): OWDCCSSPrimitiveValue; overload;
    function getBlue(): OWDCCSSPrimitiveValue; overload;
  end;

  OWDCRect = interface external 'org.w3c.dom.css' name 'Rect' 
    function getTop(): OWDCCSSPrimitiveValue; overload;
    function getRight(): OWDCCSSPrimitiveValue; overload;
    function getBottom(): OWDCCSSPrimitiveValue; overload;
    function getLeft(): OWDCCSSPrimitiveValue; overload;
  end;

  OWDEDocumentEvent = interface external 'org.w3c.dom.events' name 'DocumentEvent' 
    function createEvent(para1: JLString): OWDEEvent; overload;  // throws org.w3c.dom.DOMException
  end;

  OWDEEvent = interface external 'org.w3c.dom.events' name 'Event' 
    const
      CAPTURING_PHASE = 1;
      AT_TARGET = 2;
      BUBBLING_PHASE = 3;
    function getType(): JLString; overload;
    function getTarget(): OWDEEventTarget; overload;
    function getCurrentTarget(): OWDEEventTarget; overload;
    function getEventPhase(): jshort; overload;
    function getBubbles(): jboolean; overload;
    function getCancelable(): jboolean; overload;
    function getTimeStamp(): jlong; overload;
    procedure stopPropagation(); overload;
    procedure preventDefault(); overload;
    procedure initEvent(para1: JLString; para2: jboolean; para3: jboolean); overload;
  end;

  OWDEEventListener = interface external 'org.w3c.dom.events' name 'EventListener' 
    procedure handleEvent(para1: OWDEEvent); overload;
  end;

  OWDEEventTarget = interface external 'org.w3c.dom.events' name 'EventTarget' 
    procedure addEventListener(para1: JLString; para2: OWDEEventListener; para3: jboolean); overload;
    procedure removeEventListener(para1: JLString; para2: OWDEEventListener; para3: jboolean); overload;
    function dispatchEvent(para1: OWDEEvent): jboolean; overload;  // throws org.w3c.dom.events.EventException
  end;

  OWDHHTMLCollection = interface external 'org.w3c.dom.html' name 'HTMLCollection' 
    function getLength(): jint; overload;
    function item(para1: jint): OWDNode; overload;
    function namedItem(para1: JLString): OWDNode; overload;
  end;

  OWDLDOMImplementationLS = interface external 'org.w3c.dom.ls' name 'DOMImplementationLS' 
    const
      MODE_SYNCHRONOUS = 1;
      MODE_ASYNCHRONOUS = 2;
    function createLSParser(para1: jshort; para2: JLString): OWDLLSParser; overload;  // throws org.w3c.dom.DOMException
    function createLSSerializer(): OWDLLSSerializer; overload;
    function createLSInput(): OWDLLSInput; overload;
    function createLSOutput(): OWDLLSOutput; overload;
  end;

  OWDLLSInput = interface external 'org.w3c.dom.ls' name 'LSInput' 
    function getCharacterStream(): JIReader; overload;
    procedure setCharacterStream(para1: JIReader); overload;
    function getByteStream(): JIInputStream; overload;
    procedure setByteStream(para1: JIInputStream); overload;
    function getStringData(): JLString; overload;
    procedure setStringData(para1: JLString); overload;
    function getSystemId(): JLString; overload;
    procedure setSystemId(para1: JLString); overload;
    function getPublicId(): JLString; overload;
    procedure setPublicId(para1: JLString); overload;
    function getBaseURI(): JLString; overload;
    procedure setBaseURI(para1: JLString); overload;
    function getEncoding(): JLString; overload;
    procedure setEncoding(para1: JLString); overload;
    function getCertifiedText(): jboolean; overload;
    procedure setCertifiedText(para1: jboolean); overload;
  end;

  OWDLLSOutput = interface external 'org.w3c.dom.ls' name 'LSOutput' 
    function getCharacterStream(): JIWriter; overload;
    procedure setCharacterStream(para1: JIWriter); overload;
    function getByteStream(): JIOutputStream; overload;
    procedure setByteStream(para1: JIOutputStream); overload;
    function getSystemId(): JLString; overload;
    procedure setSystemId(para1: JLString); overload;
    function getEncoding(): JLString; overload;
    procedure setEncoding(para1: JLString); overload;
  end;

  OWDLLSParser = interface external 'org.w3c.dom.ls' name 'LSParser' 
    const
      ACTION_APPEND_AS_CHILDREN = 1;
      ACTION_REPLACE_CHILDREN = 2;
      ACTION_INSERT_BEFORE = 3;
      ACTION_INSERT_AFTER = 4;
      ACTION_REPLACE = 5;
    function getDomConfig(): OWDDOMConfiguration; overload;
    function getFilter(): OWDLLSParserFilter; overload;
    procedure setFilter(para1: OWDLLSParserFilter); overload;
    function getAsync(): jboolean; overload;
    function getBusy(): jboolean; overload;
    function parse(para1: OWDLLSInput): OWDDocument; overload;  // throws org.w3c.dom.DOMException, org.w3c.dom.ls.LSException
    function parseURI(para1: JLString): OWDDocument; overload;  // throws org.w3c.dom.DOMException, org.w3c.dom.ls.LSException
    function parseWithContext(para1: OWDLLSInput; para2: OWDNode; para3: jshort): OWDNode; overload;  // throws org.w3c.dom.DOMException, org.w3c.dom.ls.LSException
    procedure abort(); overload;
  end;

  OWDLLSParserFilter = interface external 'org.w3c.dom.ls' name 'LSParserFilter' 
    const
      FILTER_ACCEPT = 1;
      FILTER_REJECT = 2;
      FILTER_SKIP = 3;
      FILTER_INTERRUPT = 4;
    function startElement(para1: OWDElement): jshort; overload;
    function acceptNode(para1: OWDNode): jshort; overload;
    function getWhatToShow(): jint; overload;
  end;

  OWDLLSResourceResolver = interface external 'org.w3c.dom.ls' name 'LSResourceResolver' 
    function resolveResource(para1: JLString; para2: JLString; para3: JLString; para4: JLString; para5: JLString): OWDLLSInput; overload;
  end;

  OWDLLSSerializer = interface external 'org.w3c.dom.ls' name 'LSSerializer' 
    function getDomConfig(): OWDDOMConfiguration; overload;
    function getNewLine(): JLString; overload;
    procedure setNewLine(para1: JLString); overload;
    function getFilter(): OWDLLSSerializerFilter; overload;
    procedure setFilter(para1: OWDLLSSerializerFilter); overload;
    function write(para1: OWDNode; para2: OWDLLSOutput): jboolean; overload;  // throws org.w3c.dom.ls.LSException
    function writeToURI(para1: OWDNode; para2: JLString): jboolean; overload;  // throws org.w3c.dom.ls.LSException
    function writeToString(para1: OWDNode): JLString; overload;  // throws org.w3c.dom.DOMException, org.w3c.dom.ls.LSException
  end;

  OWDRDocumentRange = interface external 'org.w3c.dom.ranges' name 'DocumentRange' 
    function createRange(): OWDRRange; overload;
  end;

  OWDRRange = interface external 'org.w3c.dom.ranges' name 'Range' 
    const
      START_TO_START = 0;
      START_TO_END = 1;
      END_TO_END = 2;
      END_TO_START = 3;
    function getStartContainer(): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function getStartOffset(): jint; overload;  // throws org.w3c.dom.DOMException
    function getEndContainer(): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function getEndOffset(): jint; overload;  // throws org.w3c.dom.DOMException
    function getCollapsed(): jboolean; overload;  // throws org.w3c.dom.DOMException
    function getCommonAncestorContainer(): OWDNode; overload;  // throws org.w3c.dom.DOMException
    procedure setStart(para1: OWDNode; para2: jint); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    procedure setEnd(para1: OWDNode; para2: jint); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    procedure setStartBefore(para1: OWDNode); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    procedure setStartAfter(para1: OWDNode); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    procedure setEndBefore(para1: OWDNode); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    procedure setEndAfter(para1: OWDNode); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    procedure collapse(para1: jboolean); overload;  // throws org.w3c.dom.DOMException
    procedure selectNode(para1: OWDNode); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    procedure selectNodeContents(para1: OWDNode); overload;  // throws org.w3c.dom.ranges.RangeException, org.w3c.dom.DOMException
    function compareBoundaryPoints(para1: jshort; para2: OWDRRange): jshort; overload;  // throws org.w3c.dom.DOMException
    procedure deleteContents(); overload;  // throws org.w3c.dom.DOMException
    function extractContents(): OWDDocumentFragment; overload;  // throws org.w3c.dom.DOMException
    function cloneContents(): OWDDocumentFragment; overload;  // throws org.w3c.dom.DOMException
    procedure insertNode(para1: OWDNode); overload;  // throws org.w3c.dom.DOMException, org.w3c.dom.ranges.RangeException
    procedure surroundContents(para1: OWDNode); overload;  // throws org.w3c.dom.DOMException, org.w3c.dom.ranges.RangeException
    function cloneRange(): OWDRRange; overload;  // throws org.w3c.dom.DOMException
    function toString(): JLString; overload;  // throws org.w3c.dom.DOMException
    procedure detach(); overload;  // throws org.w3c.dom.DOMException
  end;

  OWDSDocumentStyle = interface external 'org.w3c.dom.stylesheets' name 'DocumentStyle' 
    function getStyleSheets(): OWDSStyleSheetList; overload;
  end;

  OWDSLinkStyle = interface external 'org.w3c.dom.stylesheets' name 'LinkStyle' 
    function getSheet(): OWDSStyleSheet; overload;
  end;

  OWDSMediaList = interface external 'org.w3c.dom.stylesheets' name 'MediaList' 
    function getMediaText(): JLString; overload;
    procedure setMediaText(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    function getLength(): jint; overload;
    function item(para1: jint): JLString; overload;
    procedure deleteMedium(para1: JLString); overload;  // throws org.w3c.dom.DOMException
    procedure appendMedium(para1: JLString); overload;  // throws org.w3c.dom.DOMException
  end;

  OWDSStyleSheet = interface external 'org.w3c.dom.stylesheets' name 'StyleSheet' 
    function getType(): JLString; overload;
    function getDisabled(): jboolean; overload;
    procedure setDisabled(para1: jboolean); overload;
    function getOwnerNode(): OWDNode; overload;
    function getParentStyleSheet(): OWDSStyleSheet; overload;
    function getHref(): JLString; overload;
    function getTitle(): JLString; overload;
    function getMedia(): OWDSMediaList; overload;
  end;

  OWDSStyleSheetList = interface external 'org.w3c.dom.stylesheets' name 'StyleSheetList' 
    function getLength(): jint; overload;
    function item(para1: jint): OWDSStyleSheet; overload;
  end;

  OWDTDocumentTraversal = interface external 'org.w3c.dom.traversal' name 'DocumentTraversal' 
    function createNodeIterator(para1: OWDNode; para2: jint; para3: OWDTNodeFilter; para4: jboolean): OWDTNodeIterator; overload;  // throws org.w3c.dom.DOMException
    function createTreeWalker(para1: OWDNode; para2: jint; para3: OWDTNodeFilter; para4: jboolean): OWDTTreeWalker; overload;  // throws org.w3c.dom.DOMException
  end;

  OWDTNodeFilter = interface external 'org.w3c.dom.traversal' name 'NodeFilter' 
    const
      FILTER_ACCEPT = 1;
      FILTER_REJECT = 2;
      FILTER_SKIP = 3;
      SHOW_ALL = -1;
      SHOW_ELEMENT = 1;
      SHOW_ATTRIBUTE = 2;
      SHOW_TEXT = 4;
      SHOW_CDATA_SECTION = 8;
      SHOW_ENTITY_REFERENCE = 16;
      SHOW_ENTITY = 32;
      SHOW_PROCESSING_INSTRUCTION = 64;
      SHOW_COMMENT = 128;
      SHOW_DOCUMENT = 256;
      SHOW_DOCUMENT_TYPE = 512;
      SHOW_DOCUMENT_FRAGMENT = 1024;
      SHOW_NOTATION = 2048;
    function acceptNode(para1: OWDNode): jshort; overload;
  end;

  OWDTNodeIterator = interface external 'org.w3c.dom.traversal' name 'NodeIterator' 
    function getRoot(): OWDNode; overload;
    function getWhatToShow(): jint; overload;
    function getFilter(): OWDTNodeFilter; overload;
    function getExpandEntityReferences(): jboolean; overload;
    function nextNode(): OWDNode; overload;  // throws org.w3c.dom.DOMException
    function previousNode(): OWDNode; overload;  // throws org.w3c.dom.DOMException
    procedure detach(); overload;
  end;

  OWDTTreeWalker = interface external 'org.w3c.dom.traversal' name 'TreeWalker' 
    function getRoot(): OWDNode; overload;
    function getWhatToShow(): jint; overload;
    function getFilter(): OWDTNodeFilter; overload;
    function getExpandEntityReferences(): jboolean; overload;
    function getCurrentNode(): OWDNode; overload;
    procedure setCurrentNode(para1: OWDNode); overload;  // throws org.w3c.dom.DOMException
    function parentNode(): OWDNode; overload;
    function firstChild(): OWDNode; overload;
    function lastChild(): OWDNode; overload;
    function previousSibling(): OWDNode; overload;
    function nextSibling(): OWDNode; overload;
    function previousNode(): OWDNode; overload;
    function nextNode(): OWDNode; overload;
  end;

  OWDVAbstractView = interface external 'org.w3c.dom.views' name 'AbstractView' 
    function getDocument(): OWDVDocumentView; overload;
  end;

  OWDVDocumentView = interface external 'org.w3c.dom.views' name 'DocumentView' 
    function getDefaultView(): OWDVAbstractView; overload;
  end;

  OWDXXPathEvaluator = interface external 'org.w3c.dom.xpath' name 'XPathEvaluator' 
    function createExpression(para1: JLString; para2: OWDXXPathNSResolver): OWDXXPathExpression; overload;  // throws org.w3c.dom.xpath.XPathException, org.w3c.dom.DOMException
    function createNSResolver(para1: OWDNode): OWDXXPathNSResolver; overload;
    function evaluate(para1: JLString; para2: OWDNode; para3: OWDXXPathNSResolver; para4: jshort; para5: JLObject): JLObject; overload;  // throws org.w3c.dom.xpath.XPathException, org.w3c.dom.DOMException
  end;

  OWDXXPathExpression = interface external 'org.w3c.dom.xpath' name 'XPathExpression' 
    function evaluate(para1: OWDNode; para2: jshort; para3: JLObject): JLObject; overload;  // throws org.w3c.dom.xpath.XPathException, org.w3c.dom.DOMException
  end;

  OWDXXPathNSResolver = interface external 'org.w3c.dom.xpath' name 'XPathNSResolver' 
    function lookupNamespaceURI(para1: JLString): JLString; overload;
  end;

  OWDXXPathResult = interface external 'org.w3c.dom.xpath' name 'XPathResult' 
    const
      ANY_TYPE = 0;
      NUMBER_TYPE = 1;
      STRING_TYPE = 2;
      BOOLEAN_TYPE = 3;
      UNORDERED_NODE_ITERATOR_TYPE = 4;
      ORDERED_NODE_ITERATOR_TYPE = 5;
      UNORDERED_NODE_SNAPSHOT_TYPE = 6;
      ORDERED_NODE_SNAPSHOT_TYPE = 7;
      ANY_UNORDERED_NODE_TYPE = 8;
      FIRST_ORDERED_NODE_TYPE = 9;
    function getResultType(): jshort; overload;
    function getNumberValue(): jdouble; overload;  // throws org.w3c.dom.xpath.XPathException
    function getStringValue(): JLString; overload;  // throws org.w3c.dom.xpath.XPathException
    function getBooleanValue(): jboolean; overload;  // throws org.w3c.dom.xpath.XPathException
    function getSingleNodeValue(): OWDNode; overload;  // throws org.w3c.dom.xpath.XPathException
    function getInvalidIteratorState(): jboolean; overload;
    function getSnapshotLength(): jint; overload;  // throws org.w3c.dom.xpath.XPathException
    function iterateNext(): OWDNode; overload;  // throws org.w3c.dom.xpath.XPathException, org.w3c.dom.DOMException
    function snapshotItem(para1: jint): OWDNode; overload;  // throws org.w3c.dom.xpath.XPathException
  end;

  OXSAttributeList = interface external 'org.xml.sax' name 'AttributeList' 
    function getLength(): jint; overload;
    function getName(para1: jint): JLString; overload;
    function getType(para1: jint): JLString; overload;
    function getValue(para1: jint): JLString; overload;
    function getType(para1: JLString): JLString; overload;
    function getValue(para1: JLString): JLString; overload;
  end;

  OXSAttributes = interface external 'org.xml.sax' name 'Attributes' 
    function getLength(): jint; overload;
    function getURI(para1: jint): JLString; overload;
    function getLocalName(para1: jint): JLString; overload;
    function getQName(para1: jint): JLString; overload;
    function getType(para1: jint): JLString; overload;
    function getValue(para1: jint): JLString; overload;
    function getIndex(para1: JLString; para2: JLString): jint; overload;
    function getIndex(para1: JLString): jint; overload;
    function getType(para1: JLString; para2: JLString): JLString; overload;
    function getType(para1: JLString): JLString; overload;
    function getValue(para1: JLString; para2: JLString): JLString; overload;
    function getValue(para1: JLString): JLString; overload;
  end;

  OXSContentHandler = interface external 'org.xml.sax' name 'ContentHandler' 
    procedure setDocumentLocator(para1: OXSLocator); overload;
    procedure startDocument(); overload;  // throws org.xml.sax.SAXException
    procedure endDocument(); overload;  // throws org.xml.sax.SAXException
    procedure startPrefixMapping(para1: JLString; para2: JLString); overload;  // throws org.xml.sax.SAXException
    procedure endPrefixMapping(para1: JLString); overload;  // throws org.xml.sax.SAXException
    procedure startElement(para1: JLString; para2: JLString; para3: JLString; para4: OXSAttributes); overload;  // throws org.xml.sax.SAXException
    procedure endElement(para1: JLString; para2: JLString; para3: JLString); overload;  // throws org.xml.sax.SAXException
    procedure characters(para1: Arr1jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure characters(var para1: array of jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure ignorableWhitespace(para1: Arr1jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure ignorableWhitespace(var para1: array of jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure processingInstruction(para1: JLString; para2: JLString); overload;  // throws org.xml.sax.SAXException
    procedure skippedEntity(para1: JLString); overload;  // throws org.xml.sax.SAXException
  end;

  OXSDTDHandler = interface external 'org.xml.sax' name 'DTDHandler' 
    procedure notationDecl(para1: JLString; para2: JLString; para3: JLString); overload;  // throws org.xml.sax.SAXException
    procedure unparsedEntityDecl(para1: JLString; para2: JLString; para3: JLString; para4: JLString); overload;  // throws org.xml.sax.SAXException
  end;

  OXSDocumentHandler = interface external 'org.xml.sax' name 'DocumentHandler' 
    procedure setDocumentLocator(para1: OXSLocator); overload;
    procedure startDocument(); overload;  // throws org.xml.sax.SAXException
    procedure endDocument(); overload;  // throws org.xml.sax.SAXException
    procedure startElement(para1: JLString; para2: OXSAttributeList); overload;  // throws org.xml.sax.SAXException
    procedure endElement(para1: JLString); overload;  // throws org.xml.sax.SAXException
    procedure characters(para1: Arr1jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure characters(var para1: array of jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure ignorableWhitespace(para1: Arr1jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure ignorableWhitespace(var para1: array of jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure processingInstruction(para1: JLString; para2: JLString); overload;  // throws org.xml.sax.SAXException
  end;

  OXSEntityResolver = interface external 'org.xml.sax' name 'EntityResolver' 
    function resolveEntity(para1: JLString; para2: JLString): OXSInputSource; overload;  // throws org.xml.sax.SAXException, java.io.IOException
  end;

  OXSErrorHandler = interface external 'org.xml.sax' name 'ErrorHandler' 
    procedure warning(para1: OXSSAXParseException); overload;  // throws org.xml.sax.SAXException
    procedure error(para1: OXSSAXParseException); overload;  // throws org.xml.sax.SAXException
    procedure fatalError(para1: OXSSAXParseException); overload;  // throws org.xml.sax.SAXException
  end;

  OXSInputSource = class external 'org.xml.sax' name 'InputSource' (JLObject)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JIInputStream); overload;
    constructor create(para1: JIReader); overload;
    procedure setPublicId(para1: JLString); overload; virtual;
    function getPublicId(): JLString; overload; virtual;
    procedure setSystemId(para1: JLString); overload; virtual;
    function getSystemId(): JLString; overload; virtual;
    procedure setByteStream(para1: JIInputStream); overload; virtual;
    function getByteStream(): JIInputStream; overload; virtual;
    procedure setEncoding(para1: JLString); overload; virtual;
    function getEncoding(): JLString; overload; virtual;
    procedure setCharacterStream(para1: JIReader); overload; virtual;
    function getCharacterStream(): JIReader; overload; virtual;
  end;

  OXSLocator = interface external 'org.xml.sax' name 'Locator' 
    function getPublicId(): JLString; overload;
    function getSystemId(): JLString; overload;
    function getLineNumber(): jint; overload;
    function getColumnNumber(): jint; overload;
  end;

  OXSParser = interface external 'org.xml.sax' name 'Parser' 
    procedure setLocale(para1: JULocale); overload;  // throws org.xml.sax.SAXException
    procedure setEntityResolver(para1: OXSEntityResolver); overload;
    procedure setDTDHandler(para1: OXSDTDHandler); overload;
    procedure setDocumentHandler(para1: OXSDocumentHandler); overload;
    procedure setErrorHandler(para1: OXSErrorHandler); overload;
    procedure parse(para1: OXSInputSource); overload;  // throws org.xml.sax.SAXException, java.io.IOException
    procedure parse(para1: JLString); overload;  // throws org.xml.sax.SAXException, java.io.IOException
  end;

  OXSXMLReader = interface external 'org.xml.sax' name 'XMLReader' 
    function getFeature(para1: JLString): jboolean; overload;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setFeature(para1: JLString; para2: jboolean); overload;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    function getProperty(para1: JLString): JLObject; overload;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setProperty(para1: JLString; para2: JLObject); overload;  // throws org.xml.sax.SAXNotRecognizedException, org.xml.sax.SAXNotSupportedException
    procedure setEntityResolver(para1: OXSEntityResolver); overload;
    function getEntityResolver(): OXSEntityResolver; overload;
    procedure setDTDHandler(para1: OXSDTDHandler); overload;
    function getDTDHandler(): OXSDTDHandler; overload;
    procedure setContentHandler(para1: OXSContentHandler); overload;
    function getContentHandler(): OXSContentHandler; overload;
    procedure setErrorHandler(para1: OXSErrorHandler); overload;
    function getErrorHandler(): OXSErrorHandler; overload;
    procedure parse(para1: OXSInputSource); overload;  // throws java.io.IOException, org.xml.sax.SAXException
    procedure parse(para1: JLString); overload;  // throws java.io.IOException, org.xml.sax.SAXException
  end;

  OXSEDeclHandler = interface external 'org.xml.sax.ext' name 'DeclHandler' 
    procedure elementDecl(para1: JLString; para2: JLString); overload;  // throws org.xml.sax.SAXException
    procedure attributeDecl(para1: JLString; para2: JLString; para3: JLString; para4: JLString; para5: JLString); overload;  // throws org.xml.sax.SAXException
    procedure internalEntityDecl(para1: JLString; para2: JLString); overload;  // throws org.xml.sax.SAXException
    procedure externalEntityDecl(para1: JLString; para2: JLString; para3: JLString); overload;  // throws org.xml.sax.SAXException
  end;

  OXSELexicalHandler = interface external 'org.xml.sax.ext' name 'LexicalHandler' 
    procedure startDTD(para1: JLString; para2: JLString; para3: JLString); overload;  // throws org.xml.sax.SAXException
    procedure endDTD(); overload;  // throws org.xml.sax.SAXException
    procedure startEntity(para1: JLString); overload;  // throws org.xml.sax.SAXException
    procedure endEntity(para1: JLString); overload;  // throws org.xml.sax.SAXException
    procedure startCDATA(); overload;  // throws org.xml.sax.SAXException
    procedure endCDATA(); overload;  // throws org.xml.sax.SAXException
    procedure comment(para1: Arr1jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
    procedure comment(var para1: array of jchar; para2: jint; para3: jint); overload;  // throws org.xml.sax.SAXException
  end;

  OXSHNamespaceSupport = class external 'org.xml.sax.helpers' name 'NamespaceSupport' (JLObject)
  public
    type
      InnerContext = class;
      Arr1InnerContext = array of InnerContext;
      Arr2InnerContext = array of Arr1InnerContext;
      Arr3InnerContext = array of Arr2InnerContext;
      InnerContext = class sealed external 'org.xml.sax.helpers' name 'Context' 
      end;

  public
    const
      XMLNS = 'http://www.w3.org/XML/1998/namespace';
      NSDECL = 'http://www.w3.org/xmlns/2000/';
  public
    constructor create(); overload;
    procedure reset(); overload; virtual;
    procedure pushContext(); overload; virtual;
    procedure popContext(); overload; virtual;
    function declarePrefix(para1: JLString; para2: JLString): jboolean; overload; virtual;
    function processName(para1: JLString; para2: Arr1JLString; para3: jboolean): Arr1JLString; overload; virtual;
    function processName(para1: JLString; var para2: array of JLString; para3: jboolean): Arr1JLString; overload; virtual;
    function getURI(para1: JLString): JLString; overload; virtual;
    function getPrefixes(): JUEnumeration; overload; virtual;
    function getPrefix(para1: JLString): JLString; overload; virtual;
    function getPrefixes(para1: JLString): JUEnumeration; overload; virtual;
    function getDeclaredPrefixes(): JUEnumeration; overload; virtual;
    procedure setNamespaceDeclUris(para1: jboolean); overload; virtual;
    function isNamespaceDeclUris(): jboolean; overload; virtual;
  end;

  OXSHNewInstance = class external 'org.xml.sax.helpers' name 'NewInstance' (JLObject)
  end;

  OXSHParserFactory = class external 'org.xml.sax.helpers' name 'ParserFactory' (JLObject)
  public
    class function makeParser(): OXSParser; static; overload;  // throws java.lang.ClassNotFoundException, java.lang.IllegalAccessException, java.lang.InstantiationException, java.lang.NullPointerException, java.lang.ClassCastException
    class function makeParser(para1: JLString): OXSParser; static; overload;  // throws java.lang.ClassNotFoundException, java.lang.IllegalAccessException, java.lang.InstantiationException, java.lang.ClassCastException
  end;

  OXSHXMLReaderFactory = class sealed external 'org.xml.sax.helpers' name 'XMLReaderFactory' (JLObject)
  public
    class function createXMLReader(): OXSXMLReader; static; overload;  // throws org.xml.sax.SAXException
    class function createXMLReader(para1: JLString): OXSXMLReader; static; overload;  // throws org.xml.sax.SAXException
  end;

  JAAWTError = class external 'java.awt' name 'AWTError' (JLError)
  public
    constructor create(para1: JLString); overload;
  end;

  JIIOError = class external 'java.io' name 'IOError' (JLError)
  public
    constructor create(para1: JLThrowable); overload;
  end;

  JLThreadDeath = class external 'java.lang' name 'ThreadDeath' (JLError)
  public
    constructor create(); overload;
  end;

  JLVirtualMachineError = class abstract external 'java.lang' name 'VirtualMachineError' (JLError)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLAAnnotationFormatError = class external 'java.lang.annotation' name 'AnnotationFormatError' (JLError)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
  end;

  JUServiceConfigurationError = class external 'java.util' name 'ServiceConfigurationError' (JLError)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
  end;

  JSTStateInvariantError = class external 'javax.swing.text' name 'StateInvariantError' (JLError)
  public
    constructor create(para1: JLString); overload;
  end;

  JXPFactoryConfigurationError = class external 'javax.xml.parsers' name 'FactoryConfigurationError' (JLError)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLException); overload;
    constructor create(para1: JLException; para2: JLString); overload;
    function getMessage(): JLString; overload; virtual;
    function getException(): JLException; overload; virtual;
  end;

  JXSFactoryConfigurationError = class external 'javax.xml.stream' name 'FactoryConfigurationError' (JLError)
  public
    constructor create(); overload;
    constructor create(para1: JLException); overload;
    constructor create(para1: JLException; para2: JLString); overload;
    constructor create(para1: JLString; para2: JLException); overload;
    constructor create(para1: JLString); overload;
    function getException(): JLException; overload; virtual;
    function getMessage(): JLString; overload; virtual;
  end;

  JXTTransformerFactoryConfigurationError = class external 'javax.xml.transform' name 'TransformerFactoryConfigurationError' (JLError)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLException); overload;
    constructor create(para1: JLException; para2: JLString); overload;
    function getMessage(): JLString; overload; virtual;
    function getException(): JLException; overload; virtual;
  end;

  JAAWTException = class external 'java.awt' name 'AWTException' (JLException)
  public
    constructor create(para1: JLString); overload;
  end;

  JAFontFormatException = class external 'java.awt' name 'FontFormatException' (JLException)
  public
    constructor create(para1: JLString); overload;
  end;

  JADMimeTypeParseException = class external 'java.awt.datatransfer' name 'MimeTypeParseException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JADUnsupportedFlavorException = class external 'java.awt.datatransfer' name 'UnsupportedFlavorException' (JLException)
  public
    constructor create(para1: JADDataFlavor); overload;
  end;

  JAGNoninvertibleTransformException = class external 'java.awt.geom' name 'NoninvertibleTransformException' (JLException)
  public
    constructor create(para1: JLString); overload;
  end;

  JAPPrinterException = class external 'java.awt.print' name 'PrinterException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JBIntrospectionException = class external 'java.beans' name 'IntrospectionException' (JLException)
  public
    constructor create(para1: JLString); overload;
  end;

  JBPropertyVetoException = class external 'java.beans' name 'PropertyVetoException' (JLException)
  public
    constructor create(para1: JLString; para2: JBPropertyChangeEvent); overload;
    function getPropertyChangeEvent(): JBPropertyChangeEvent; overload; virtual;
  end;

  JLClassNotFoundException = class external 'java.lang' name 'ClassNotFoundException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    function getException(): JLThrowable; overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
  end;

  JLCloneNotSupportedException = class external 'java.lang' name 'CloneNotSupportedException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLIllegalAccessException = class external 'java.lang' name 'IllegalAccessException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLInstantiationException = class external 'java.lang' name 'InstantiationException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLInterruptedException = class external 'java.lang' name 'InterruptedException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLNoSuchFieldException = class external 'java.lang' name 'NoSuchFieldException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLNoSuchMethodException = class external 'java.lang' name 'NoSuchMethodException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLIIllegalClassFormatException = class external 'java.lang.instrument' name 'IllegalClassFormatException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JLIUnmodifiableClassException = class external 'java.lang.instrument' name 'UnmodifiableClassException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JNURISyntaxException = class external 'java.net' name 'URISyntaxException' (JLException)
  public
    constructor create(para1: JLString; para2: JLString; para3: jint); overload;
    constructor create(para1: JLString; para2: JLString); overload;
    function getInput(): JLString; overload; virtual;
    function getReason(): JLString; overload; virtual;
    function getIndex(): jint; overload; virtual;
    function getMessage(): JLString; overload; virtual;
  end;

  JRAlreadyBoundException = class external 'java.rmi' name 'AlreadyBoundException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JRNotBoundException = class external 'java.rmi' name 'NotBoundException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JRAActivationException = class external 'java.rmi.activation' name 'ActivationException' (JLException)
  public
    var
      fdetail: JLThrowable; external name 'detail';
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    function getMessage(): JLString; overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
  end;

  JRSServerNotActiveException = class external 'java.rmi.server' name 'ServerNotActiveException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSGeneralSecurityException = class external 'java.security' name 'GeneralSecurityException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
  end;

  JSPrivilegedActionException = class external 'java.security' name 'PrivilegedActionException' (JLException)
  public
    constructor create(para1: JLException); overload;
    function getException(): JLException; overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JSAAclNotFoundException = class external 'java.security.acl' name 'AclNotFoundException' (JLException)
  public
    constructor create(); overload;
  end;

  JSALastOwnerException = class external 'java.security.acl' name 'LastOwnerException' (JLException)
  public
    constructor create(); overload;
  end;

  JSANotOwnerException = class external 'java.security.acl' name 'NotOwnerException' (JLException)
  public
    constructor create(); overload;
  end;

  JTParseException = class external 'java.text' name 'ParseException' (JLException)
  public
    constructor create(para1: JLString; para2: jint); overload;
    function getErrorOffset(): jint; overload; virtual;
  end;

  JUTooManyListenersException = class external 'java.util' name 'TooManyListenersException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JUCBrokenBarrierException = class external 'java.util.concurrent' name 'BrokenBarrierException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JUCExecutionException = class external 'java.util.concurrent' name 'ExecutionException' (JLException)
  strict protected
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  public
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
  end;

  JUCTimeoutException = class external 'java.util.concurrent' name 'TimeoutException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JUPBackingStoreException = class external 'java.util.prefs' name 'BackingStoreException' (JLException)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLThrowable); overload;
  end;

  JUPInvalidPreferencesFormatException = class external 'java.util.prefs' name 'InvalidPreferencesFormatException' (JLException)
  public
    constructor create(para1: JLThrowable); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
  end;

  JUZDataFormatException = class external 'java.util.zip' name 'DataFormatException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JAMimeTypeParseException = class external 'javax.activation' name 'MimeTypeParseException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JMBadAttributeValueExpException = class external 'javax.management' name 'BadAttributeValueExpException' (JLException)
  public
    constructor create(para1: JLObject); overload;
    function toString(): JLString; overload; virtual;
  end;

  JMBadBinaryOpValueExpException = class external 'javax.management' name 'BadBinaryOpValueExpException' (JLException)
  public
    constructor create(para1: JMValueExp); overload;
    function getExp(): JMValueExp; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JMBadStringOperationException = class external 'javax.management' name 'BadStringOperationException' (JLException)
  public
    constructor create(para1: JLString); overload;
    function toString(): JLString; overload; virtual;
  end;

  JMInvalidApplicationException = class external 'javax.management' name 'InvalidApplicationException' (JLException)
  public
    constructor create(para1: JLObject); overload;
  end;

  JMJMException = class external 'javax.management' name 'JMException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JMMInvalidTargetObjectTypeException = class external 'javax.management.modelmbean' name 'InvalidTargetObjectTypeException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLException; para2: JLString); overload;
  end;

  JMMXMLParseException = class external 'javax.management.modelmbean' name 'XMLParseException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLException; para2: JLString); overload;
  end;

  JNNamingException = class external 'javax.naming' name 'NamingException' (JLException)
  strict protected
    var
      fresolvedName: JNName; external name 'resolvedName';
      fresolvedObj: JLObject; external name 'resolvedObj';
      fremainingName: JNName; external name 'remainingName';
      frootException: JLThrowable; external name 'rootException';
  public
    constructor create(para1: JLString); overload;
    constructor create(); overload;
    function getResolvedName(): JNName; overload; virtual;
    function getRemainingName(): JNName; overload; virtual;
    function getResolvedObj(): JLObject; overload; virtual;
    function getExplanation(): JLString; overload; virtual;
    procedure setResolvedName(para1: JNName); overload; virtual;
    procedure setRemainingName(para1: JNName); overload; virtual;
    procedure setResolvedObj(para1: JLObject); overload; virtual;
    procedure appendRemainingComponent(para1: JLString); overload; virtual;
    procedure appendRemainingName(para1: JNName); overload; virtual;
    function getRootCause(): JLThrowable; overload; virtual;
    procedure setRootCause(para1: JLThrowable); overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
    function initCause(para1: JLThrowable): JLThrowable; overload; virtual;
    function toString(): JLString; overload; virtual;
    function toString(para1: jboolean): JLString; overload; virtual;
  end;

  JPPrintException = class external 'javax.print' name 'PrintException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLException); overload;
    constructor create(para1: JLString; para2: JLException); overload;
  end;

  JSScriptException = class external 'javax.script' name 'ScriptException' (JLException)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLException); overload;
    constructor create(para1: JLString; para2: JLString; para3: jint); overload;
    constructor create(para1: JLString; para2: JLString; para3: jint; para4: jint); overload;
    function getMessage(): JLString; overload; virtual;
    function getLineNumber(): jint; overload; virtual;
    function getColumnNumber(): jint; overload; virtual;
    function getFileName(): JLString; overload; virtual;
  end;

  JSADestroyFailedException = class external 'javax.security.auth' name 'DestroyFailedException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSARefreshFailedException = class external 'javax.security.auth' name 'RefreshFailedException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSACUnsupportedCallbackException = class external 'javax.security.auth.callback' name 'UnsupportedCallbackException' (JLException)
  public
    constructor create(para1: JSACCallback); overload;
    constructor create(para1: JSACCallback; para2: JLString); overload;
    function getCallback(): JSACCallback; overload; virtual;
  end;

  JxSCCertificateException = class external 'javax.security.cert' name 'CertificateException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSCardException = class external 'javax.smartcardio' name 'CardException' (JLException)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLThrowable); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
  end;

  JSMInvalidMidiDataException = class external 'javax.sound.midi' name 'InvalidMidiDataException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSMMidiUnavailableException = class external 'javax.sound.midi' name 'MidiUnavailableException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSSLineUnavailableException = class external 'javax.sound.sampled' name 'LineUnavailableException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSSUnsupportedAudioFileException = class external 'javax.sound.sampled' name 'UnsupportedAudioFileException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JSUnsupportedLookAndFeelException = class external 'javax.swing' name 'UnsupportedLookAndFeelException' (JLException)
  public
    constructor create(para1: JLString); overload;
  end;

  JSTBadLocationException = class external 'javax.swing.text' name 'BadLocationException' (JLException)
  public
    constructor create(para1: JLString; para2: jint); overload;
    function offsetRequested(): jint; overload; virtual;
  end;

  JSTExpandVetoException = class external 'javax.swing.tree' name 'ExpandVetoException' (JLException)
  strict protected
    var
      fevent: JSETreeExpansionEvent; external name 'event';
  public
    constructor create(para1: JSETreeExpansionEvent); overload;
    constructor create(para1: JSETreeExpansionEvent; para2: JLString); overload;
  end;

  JTXXAException = class external 'javax.transaction.xa' name 'XAException' (JLException)
  public
    var
      ferrorCode: jint; external name 'errorCode';
  public
    const
      XA_RBBASE = 100;
      XA_RBROLLBACK = 100;
      XA_RBCOMMFAIL = 101;
      XA_RBDEADLOCK = 102;
      XA_RBINTEGRITY = 103;
      XA_RBOTHER = 104;
      XA_RBPROTO = 105;
      XA_RBTIMEOUT = 106;
      XA_RBTRANSIENT = 107;
      XA_RBEND = 107;
      XA_NOMIGRATE = 9;
      XA_HEURHAZ = 8;
      XA_HEURCOM = 7;
      XA_HEURRB = 6;
      XA_HEURMIX = 5;
      XA_RETRY = 4;
      XA_RDONLY = 3;
      XAER_ASYNC = -2;
      XAER_RMERR = -3;
      XAER_NOTA = -4;
      XAER_INVAL = -5;
      XAER_PROTO = -6;
      XAER_RMFAIL = -7;
      XAER_DUPID = -8;
      XAER_OUTSIDE = -9;
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: jint); overload;
  end;

  JXBJAXBException = class external 'javax.xml.bind' name 'JAXBException' (JLException)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLString); overload;
    constructor create(para1: JLThrowable); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLString; para2: JLString; para3: JLThrowable); overload;
    function getErrorCode(): JLString; overload; virtual;
    function getLinkedException(): JLThrowable; overload; virtual;
    procedure setLinkedException(para1: JLThrowable); overload; virtual;
    function toString(): JLString; overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
  end;

  JXCKeySelectorException = class external 'javax.xml.crypto' name 'KeySelectorException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
    function getCause(): JLThrowable; overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
  end;

  JXCMarshalException = class external 'javax.xml.crypto' name 'MarshalException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
    function getCause(): JLThrowable; overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
  end;

  JXCURIReferenceException = class external 'javax.xml.crypto' name 'URIReferenceException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLString; para2: JLThrowable; para3: JXCURIReference); overload;
    constructor create(para1: JLThrowable); overload;
    function getURIReference(): JXCURIReference; overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
  end;

  JXCDTransformException = class external 'javax.xml.crypto.dsig' name 'TransformException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
    function getCause(): JLThrowable; overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
  end;

  JXCDXMLSignatureException = class external 'javax.xml.crypto.dsig' name 'XMLSignatureException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
    function getCause(): JLThrowable; overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
  end;

  JXDDatatypeConfigurationException = class external 'javax.xml.datatype' name 'DatatypeConfigurationException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
  end;

  JXPParserConfigurationException = class external 'javax.xml.parsers' name 'ParserConfigurationException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
  end;

  JXSSOAPException = class external 'javax.xml.soap' name 'SOAPException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLThrowable); overload;
    function getMessage(): JLString; overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
    function initCause(para1: JLThrowable): JLThrowable; overload; virtual;
  end;

  JXSXMLStreamException = class external 'javax.xml.stream' name 'XMLStreamException' (JLException)
  strict protected
    var
      fnested: JLThrowable; external name 'nested';
      flocation: JXSLocation; external name 'location';
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLThrowable); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLString; para2: JXSLocation; para3: JLThrowable); overload;
    constructor create(para1: JLString; para2: JXSLocation); overload;
    function getNestedException(): JLThrowable; overload; virtual;
    function getLocation(): JXSLocation; overload; virtual;
  end;

  JXTTransformerException = class external 'javax.xml.transform' name 'TransformerException' (JLException)
  public
    function getLocator(): JXTSourceLocator; overload; virtual;
    procedure setLocator(para1: JXTSourceLocator); overload; virtual;
    function getException(): JLThrowable; overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
    function initCause(para1: JLThrowable): JLThrowable; overload; virtual;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLThrowable); overload;
    constructor create(para1: JLString; para2: JLThrowable); overload;
    constructor create(para1: JLString; para2: JXTSourceLocator); overload;
    constructor create(para1: JLString; para2: JXTSourceLocator; para3: JLThrowable); overload;
    function getMessageAndLocation(): JLString; overload; virtual;
    function getLocationAsString(): JLString; overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
  end;

  JXXXPathException = class external 'javax.xml.xpath' name 'XPathException' (JLException)
  public
    constructor create(para1: JLString); overload;
    constructor create(para1: JLThrowable); overload;
    function getCause(): JLThrowable; overload; virtual;
    procedure printStackTrace(para1: JIPrintStream); overload; virtual;
    procedure printStackTrace(); overload; virtual;
    procedure printStackTrace(para1: JIPrintWriter); overload; virtual;
  end;

  OIJGSSException = class external 'org.ietf.jgss' name 'GSSException' (JLException)
  public
    const
      BAD_BINDINGS = 1;
      BAD_MECH = 2;
      BAD_NAME = 3;
      BAD_NAMETYPE = 4;
      BAD_STATUS = 5;
      BAD_MIC = 6;
      CONTEXT_EXPIRED = 7;
      CREDENTIALS_EXPIRED = 8;
      DEFECTIVE_CREDENTIAL = 9;
      DEFECTIVE_TOKEN = 10;
      FAILURE = 11;
      NO_CONTEXT = 12;
      NO_CRED = 13;
      BAD_QOP = 14;
      UNAUTHORIZED = 15;
      UNAVAILABLE = 16;
      DUPLICATE_ELEMENT = 17;
      NAME_NOT_MN = 18;
      DUPLICATE_TOKEN = 19;
      OLD_TOKEN = 20;
      UNSEQ_TOKEN = 21;
      GAP_TOKEN = 22;
  public
    constructor create(para1: jint); overload;
    constructor create(para1: jint; para2: jint; para3: JLString); overload;
    function getMajor(): jint; overload; virtual;
    function getMinor(): jint; overload; virtual;
    function getMajorString(): JLString; overload; virtual;
    function getMinorString(): JLString; overload; virtual;
    procedure setMinor(para1: jint; para2: JLString); overload; virtual;
    function toString(): JLString; overload; virtual;
    function getMessage(): JLString; overload; virtual;
  end;

  OOCPApplicationException = class external 'org.omg.CORBA.portable' name 'ApplicationException' (JLException)
  public
    constructor create(para1: JLString; para2: OOCPInputStream); overload;
    function getId(): JLString; overload; virtual;
    function getInputStream(): OOCPInputStream; overload; virtual;
  end;

  OOCPRemarshalException = class sealed external 'org.omg.CORBA.portable' name 'RemarshalException' (JLException)
  public
    constructor create(); overload;
  end;

  OXSSAXException = class external 'org.xml.sax' name 'SAXException' (JLException)
  public
    constructor create(); overload;
    constructor create(para1: JLString); overload;
    constructor create(para1: JLException); overload;
    constructor create(para1: JLString; para2: JLException); overload;
    function getMessage(): JLString; overload; virtual;
    function getException(): JLException; overload; virtual;
    function getCause(): JLThrowable; overload; virtual;
    function toString(): JLString; overload; virtual;
  end;

  JAAWTKeyStroke = class external 'java.awt' name 'AWTKeyStroke' (JLObject, JISerializable)
  strict protected
    constructor create(); overload;
    constructor create(para1: jchar; para2: jint; para3: jint; para4: jboolean); overload;
    class procedure registerSubclass(para1: JLClass); static; overload;
  public
    class function getAWTKeyStroke(para1: jchar): JAAWTKeyStroke; static; overload;
    class function getAWTKeyStroke(para1: JLCharacter; para2: jint): JAAWTKeyStroke; static; overload;
    class function getAWTKeyStroke(para1: jint; para2: jint; para3: jboolean): JAAWTKeyStroke; static; overload;
    class function getAWTKeyStroke(para1: jint; para2: jint): JAAWTKeyStroke; static; overload;
    class function getAWTKeyStrokeForEvent(para1: JAEKeyEvent): JAAWTKeyStroke; static; overload;
    class function getAWTKeyStroke(para1: JLString): JAAWTKeyStroke; static; overload;
    function getKeyChar(): jchar; overload; virtual; final;
    function getKeyCode(): jint; overload; virtual; final;
    function getModifiers(): jint; overload; virtual; final;
    function isOnKeyRelease(): jboolean; overload; virtual; final;
    function getKeyEventType(): jint; overload; virtual; final;
    function hashCode(): jint; overload; virtual;
    function equals(para1: JLObject): jboolean; overload; virtual; final;
    function to