/*
 * Decompiled with CFR 0.152.
 */
package com.lizardworks.tiff;

import com.lizardworks.tiff.IFD;
import com.lizardworks.tiff.RawImage;

class PackbitsImage
extends RawImage {
    public PackbitsImage(IFD ifd) {
        super(ifd);
    }

    @Override
    public Object getImageProducer() {
        if (!this.CanDecodeImage()) {
            return null;
        }
        if (this.imageBytes == null && this.imageStrips != null) {
            int i = 0;
            int len = 0;
            while (i < this.imageStrips.length) {
                len += this.imageStrips[i].length;
                ++i;
            }
            this.imageBytes = new byte[len];
            i = 0;
            int n = 0;
            while (i < this.imageStrips.length) {
                System.arraycopy(this.imageStrips[i], 0, this.imageBytes, n, this.imageStrips[i].length);
                n += this.imageStrips[i].length;
                ++i;
            }
            this.imageStrips = null;
        }
        if (!this.DecodeImage()) {
            return null;
        }
        return super.getImageProducer();
    }

    boolean DecodeImage() {
        int expectedCount = this.imageWidth * this.imageHeight;
        byte[] unPacked = new byte[expectedCount];
        int packedCount = this.imageBytes.length;
        int i = 0;
        int j = 0;
        while (packedCount > 0 && (long)expectedCount > 0L) {
            long n = this.imageBytes[i++];
            --packedCount;
            if (n >= 128L) {
                n -= 256L;
            }
            if (n < 0L) {
                if (n == -128L) continue;
                n = -n + 1L;
                expectedCount = (int)((long)expectedCount - n);
                byte b = this.imageBytes[i++];
                --packedCount;
                while (n-- > 0L) {
                    unPacked[j++] = b;
                }
                continue;
            }
            System.arraycopy(this.imageBytes, i, unPacked, j, (int)(++n));
            j = (int)((long)j + n);
            expectedCount = (int)((long)expectedCount - n);
            i = (int)((long)i + n);
            packedCount = (int)((long)packedCount - n);
        }
        this.imageBytes = new byte[unPacked.length];
        System.arraycopy(unPacked, 0, this.imageBytes, 0, unPacked.length);
        return true;
    }
}

