/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.exif;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.fibs.geotag.Settings;
import org.fibs.geotag.util.InputStreamGobbler;

public final class Exiftool {
    private static boolean available = false;
    private static int installedMajorVersion = 0;
    private static int installedMinorVersion = 0;

    private Exiftool() {
    }

    public static boolean isAvailable() {
        return available;
    }

    public static boolean versionAtLeast(int requiredMajorVersion, int requiredMinorVersion) {
        if (installedMajorVersion > requiredMajorVersion) {
            return true;
        }
        return installedMajorVersion == requiredMajorVersion && installedMinorVersion >= requiredMinorVersion;
    }

    public static void checkExiftoolAvailable() {
        boolean found = true;
        ArrayList<String> command = new ArrayList<String>();
        String exiftool = Settings.get(Settings.SETTING.EXIFTOOL_PATH, "exiftool");
        command.add(exiftool);
        command.add("-ver");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.redirectErrorStream(true).start();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            new InputStreamGobbler(process, (OutputStream)outputStream).start();
            process.waitFor();
            byte[] output = outputStream.toByteArray();
            String outputText = new String(output);
            String versionString = outputText.trim();
            StringTokenizer tokenizer = new StringTokenizer(versionString, ".,");
            installedMajorVersion = Integer.parseInt(tokenizer.nextToken());
            installedMinorVersion = Integer.parseInt(tokenizer.nextToken());
            System.out.println("Exiftool " + installedMajorVersion + '-' + installedMinorVersion);
        }
        catch (IOException e) {
            e.printStackTrace();
            found = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            found = false;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            found = false;
        }
        available = found;
    }
}

