/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.image.Orientation;

public class ImageRotator {
    private BufferedImage image;
    private ImageInfo imageInfo;

    public ImageRotator(BufferedImage image, ImageInfo imageInfo) {
        this.image = image;
        this.imageInfo = imageInfo;
    }

    private AffineTransform createTransformation() {
        AffineTransform transform = new AffineTransform();
        Orientation orientation = Orientation.getOrientation(this.imageInfo);
        switch (orientation) {
            case NORMAL: {
                break;
            }
            case FLIP_LEFT_RIGHT: {
                transform.scale(-1.0, 1.0);
                transform.translate(-this.image.getWidth(), 0.0);
                break;
            }
            case ROTATE_180: {
                transform.quadrantRotate(2);
                transform.translate(-this.image.getWidth(), -this.image.getHeight());
                break;
            }
            case FLIP_UP_DOWN: {
                transform.scale(1.0, -1.0);
                transform.translate(0.0, -this.image.getHeight());
                break;
            }
            case ROTATE_90_CLOCKWISE_FLIP_LEFT_RIGHT: {
                transform.quadrantRotate(1);
                transform.scale(1.0, -1.0);
                break;
            }
            case ROTATE_90_CLOCKWISE: {
                transform.quadrantRotate(1);
                transform.translate(0.0, -this.image.getHeight());
                break;
            }
            case FLIP_UP_DOWN_ROTATE_90_ANTICLOCK: {
                transform.scale(1.0, -1.0);
                transform.quadrantRotate(1);
                transform.translate(-this.image.getWidth(), -this.image.getHeight());
                break;
            }
            case ROTATE_90_ANTICLOCK: {
                transform.quadrantRotate(-1);
                transform.translate(-this.image.getWidth(), 0.0);
                break;
            }
        }
        return transform;
    }

    public BufferedImage rotate() {
        AffineTransform transform = this.createTransformation();
        if (transform.isIdentity()) {
            return this.image;
        }
        int newImageWidth = this.image.getWidth();
        int newImageHeight = this.image.getHeight();
        if (Orientation.getOrientation(this.imageInfo).changesAspect()) {
            newImageWidth = this.image.getHeight();
            newImageHeight = this.image.getWidth();
        }
        BufferedImage newImage = new BufferedImage(newImageWidth, newImageHeight, 1);
        Graphics2D graphics2D = newImage.createGraphics();
        graphics2D.drawImage(this.image, transform, null);
        return newImage;
    }
}

