/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.data.UpdateGPSLatitude;
import org.fibs.geotag.data.UpdateGPSLongitude;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Units;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CopyLocationTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(CopyLocationTask.class);
    private int currentProgress = 0;
    private ImagesTableModel imagesTableModel;
    private ImageInfo source;
    private List<ImageInfo> targets;

    public CopyLocationTask(String group, String name, ImagesTableModel imagesTableModel, ImageInfo source, List<ImageInfo> targets) {
        super(group, name);
        this.source = source;
        this.targets = targets;
        this.imagesTableModel = imagesTableModel;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.targets.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        for (ImageInfo target : this.targets) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            try {
                this.setProgressMessage();
                new UpdateGPSLatitude(target, this.source.getGpsLatitude(), ImageInfo.DATA_SOURCE.COPIED);
                new UpdateGPSLongitude(target, this.source.getGpsLongitude(), ImageInfo.DATA_SOURCE.COPIED);
                new UpdateGPSAltitude(target, this.source.getGpsAltitude(), ImageInfo.DATA_SOURCE.COPIED, Units.ALTITUDE.METRES);
                this.publish(target);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (this.currentProgress == 1) {
            result = i18n.tr("Location copied to one image.");
        } else {
            try {
                result = String.format(i18n.tr("Location copied to %d images."), this.currentProgress);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected void process(List<ImageInfo> images) {
        for (ImageInfo imageInfo : images) {
            int imageRow = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

