/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.data.UpdateGPSImgDirection;
import org.fibs.geotag.data.UpdateGPSLatitude;
import org.fibs.geotag.data.UpdateGPSLongitude;
import org.fibs.geotag.external.ExternalUpdate;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Units;
import org.fibs.geotag.util.Util;

public class ExternalUpdateTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final double LOCATION_CLOSE = 0.1;
    private ExternalUpdate externalUpdate;

    public ExternalUpdateTask(String name, ExternalUpdate externalUpdate) {
        super(null, name);
        this.externalUpdate = externalUpdate;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        ImageInfo imageInfo = ImageInfo.getImageInfo(this.externalUpdate.getImageNumber());
        if (imageInfo != null) {
            System.out.println(Util.greatCircleDistance(this.externalUpdate.getLatitude(), this.externalUpdate.getLongitude(), 51.477222222222224, 0.0));
            if (Util.greatCircleDistance(this.externalUpdate.getLatitude(), this.externalUpdate.getLongitude(), 51.477222222222224, 0.0) < 0.1) {
                new UpdateGPSLatitude(imageInfo, null, ImageInfo.DATA_SOURCE.NONE);
                new UpdateGPSLongitude(imageInfo, null, ImageInfo.DATA_SOURCE.NONE);
                new UpdateGPSAltitude(imageInfo, null, ImageInfo.DATA_SOURCE.NONE, Units.ALTITUDE.METRES);
            } else {
                new UpdateGPSLatitude(imageInfo, new Double(this.externalUpdate.getLatitude()).toString(), ImageInfo.DATA_SOURCE.MAP);
                new UpdateGPSLongitude(imageInfo, new Double(this.externalUpdate.getLongitude()).toString(), ImageInfo.DATA_SOURCE.MAP);
                if (imageInfo.getGpsAltitude() == null) {
                    new UpdateGPSAltitude(imageInfo, new Double(0.0).toString(), ImageInfo.DATA_SOURCE.MAP, Units.ALTITUDE.METRES);
                }
                if (!Double.isNaN(this.externalUpdate.getDirection())) {
                    new UpdateGPSImgDirection(imageInfo, new Double(this.externalUpdate.getDirection()).toString(), ImageInfo.DATA_SOURCE.MAP);
                }
            }
            this.publish(imageInfo);
        }
        return this.getPresentationName();
    }
}

