/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.Arrays;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.Checker;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.sort.SortMode;
import tim.prune.data.sort.WaypointComparer;
import tim.prune.function.RearrangeFunction;
import tim.prune.undo.UndoRearrangeWaypoints;

public class RearrangeWaypointsFunction
extends RearrangeFunction {
    public RearrangeWaypointsFunction(App app) {
        super(app, true);
    }

    @Override
    public String getNameKey() {
        return "function.rearrangewaypoints";
    }

    @Override
    protected boolean isSortByTimeAllowed() {
        return Checker.haveWaypointsGotTimestamps(this._app.getTrackInfo().getTrack());
    }

    @Override
    public String getDescriptionKey() {
        return "dialog.rearrangewaypoints.desc";
    }

    @Override
    protected String getSortNameKey() {
        return "sortbyname";
    }

    @Override
    protected void finish() {
        Track track = this._app.getTrackInfo().getTrack();
        RearrangeFunction.Rearrange rearrange = this.getRearrangeOption();
        SortMode sortMode = this.getSortMode();
        UndoRearrangeWaypoints undoRearrangeWaypoints = new UndoRearrangeWaypoints(track);
        boolean bl = false;
        bl = rearrange == RearrangeFunction.Rearrange.TO_START || rearrange == RearrangeFunction.Rearrange.TO_END ? this.collectWaypoints(rearrange, sortMode) : track.interleaveWaypoints();
        if (bl) {
            this._app.getTrackInfo().getSelection().clearAll();
            this._app.completeFunction(undoRearrangeWaypoints, I18nManager.getText("confirm.rearrangewaypoints"));
        } else {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("error.rearrange.noop"), I18nManager.getText("error.function.noop.title"), 2);
        }
    }

    private boolean collectWaypoints(RearrangeFunction.Rearrange rearrange, SortMode sortMode) {
        DataPoint[] dataPointArray;
        boolean bl;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        Track track = this._app.getTrackInfo().getTrack();
        int n3 = track.getNumPoints();
        DataPoint[] dataPointArray2 = new DataPoint[n3];
        DataPoint[] dataPointArray3 = new DataPoint[n3];
        DataPoint dataPoint = null;
        int n4 = 0;
        while (n4 < n3) {
            dataPoint = track.getPoint(n4);
            if (dataPoint.isWaypoint()) {
                dataPointArray2[n] = dataPoint;
                ++n;
                bl2 |= n2 > 0;
            } else {
                dataPointArray3[n2] = dataPoint;
                ++n2;
                bl3 |= n > 0;
            }
            ++n4;
        }
        n4 = rearrange == RearrangeFunction.Rearrange.TO_START ? 1 : 0;
        boolean bl4 = bl = sortMode != SortMode.DONT_SORT;
        if (n == 0 || n4 != 0 && !bl2 && bl3 && !bl || n4 == 0 && bl2 && !bl3 && !bl || rearrange == RearrangeFunction.Rearrange.TO_NEAREST) {
            return false;
        }
        DataPoint[] dataPointArray4 = new DataPoint[n3];
        System.arraycopy(dataPointArray2, 0, dataPointArray4, 0, n3);
        if (bl && n > 1) {
            dataPointArray = new WaypointComparer(sortMode);
            Arrays.sort(dataPointArray2, dataPointArray);
            boolean bl5 = RearrangeWaypointsFunction.areArraysSame(dataPointArray4, dataPointArray2);
            if (bl5 && (n2 == 0 || n4 != 0 && !bl2 && bl3 || n4 == 0 && bl2 && !bl3)) {
                return false;
            }
        }
        dataPointArray = new DataPoint[n3];
        if (n4 != 0) {
            System.arraycopy(dataPointArray2, 0, dataPointArray, 0, n);
            System.arraycopy(dataPointArray3, 0, dataPointArray, n, n2);
        } else {
            System.arraycopy(dataPointArray3, 0, dataPointArray, 0, n2);
            System.arraycopy(dataPointArray2, 0, dataPointArray, n2, n);
        }
        return track.replaceContents(dataPointArray);
    }

    private static boolean areArraysSame(DataPoint[] dataPointArray, DataPoint[] dataPointArray2) {
        if (dataPointArray == null && dataPointArray2 == null) {
            return true;
        }
        if (dataPointArray == null || dataPointArray2 == null) {
            return false;
        }
        if (dataPointArray.length != dataPointArray2.length) {
            return false;
        }
        int n = 0;
        while (n < dataPointArray.length) {
            DataPoint dataPoint = dataPointArray[n];
            DataPoint dataPoint2 = dataPointArray2[n];
            if ((dataPoint != null || dataPoint2 != null) && dataPoint != dataPoint2) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

