/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.sections.SectionReader;

public class DexHeader {
    private final String version;
    private final int classDefsSize;
    private final int classDefsOff;
    private final int stringIdsOff;
    private final int typeIdsOff;
    private final int typeIdsSize;
    private final int fieldIdsSize;
    private final int fieldIdsOff;
    private final int protoIdsSize;
    private final int protoIdsOff;
    private final int methodIdsOff;
    private final int methodIdsSize;

    public DexHeader(SectionReader buf) {
        byte[] magic = buf.readByteArray(4);
        this.version = buf.readString(3);
        buf.skip(1);
        int checksum = buf.readInt();
        byte[] signature = buf.readByteArray(20);
        int fileSize = buf.readInt();
        int headerSize = buf.readInt();
        int endianTag = buf.readInt();
        if (endianTag != 305419896) {
            throw new DexException("Unexpected endian tag: 0x" + Integer.toHexString(endianTag));
        }
        int linkSize = buf.readInt();
        int linkOff = buf.readInt();
        int mapListOff = buf.readInt();
        int stringIdsSize = buf.readInt();
        this.stringIdsOff = buf.readInt();
        this.typeIdsSize = buf.readInt();
        this.typeIdsOff = buf.readInt();
        this.protoIdsSize = buf.readInt();
        this.protoIdsOff = buf.readInt();
        this.fieldIdsSize = buf.readInt();
        this.fieldIdsOff = buf.readInt();
        this.methodIdsSize = buf.readInt();
        this.methodIdsOff = buf.readInt();
        this.classDefsSize = buf.readInt();
        this.classDefsOff = buf.readInt();
        int dataSize = buf.readInt();
        int dataOff = buf.readInt();
    }

    public String getVersion() {
        return this.version;
    }

    public int getClassDefsSize() {
        return this.classDefsSize;
    }

    public int getClassDefsOff() {
        return this.classDefsOff;
    }

    public int getStringIdsOff() {
        return this.stringIdsOff;
    }

    public int getTypeIdsOff() {
        return this.typeIdsOff;
    }

    public int getTypeIdsSize() {
        return this.typeIdsSize;
    }

    public int getFieldIdsSize() {
        return this.fieldIdsSize;
    }

    public int getFieldIdsOff() {
        return this.fieldIdsOff;
    }

    public int getProtoIdsSize() {
        return this.protoIdsSize;
    }

    public int getProtoIdsOff() {
        return this.protoIdsOff;
    }

    public int getMethodIdsOff() {
        return this.methodIdsOff;
    }

    public int getMethodIdsSize() {
        return this.methodIdsSize;
    }
}

