/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.IfOp;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.conditions.Compare;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class ConditionGen
extends InsnGen {
    public ConditionGen(InsnGen insnGen) {
        super(insnGen.mgen, insnGen.fallback);
    }

    void add(CodeWriter code, IfCondition condition) throws CodegenException {
        this.add(code, new CondStack(), condition);
    }

    void wrap(CodeWriter code, IfCondition condition) throws CodegenException {
        this.wrap(code, new CondStack(), condition);
    }

    private void add(CodeWriter code, CondStack stack, IfCondition condition) throws CodegenException {
        stack.push(condition);
        switch (condition.getMode()) {
            case COMPARE: {
                this.addCompare(code, stack, condition.getCompare());
                break;
            }
            case TERNARY: {
                this.addTernary(code, stack, condition);
                break;
            }
            case NOT: {
                this.addNot(code, stack, condition);
                break;
            }
            case AND: 
            case OR: {
                this.addAndOr(code, stack, condition);
                break;
            }
            default: {
                throw new JadxRuntimeException("Unknown condition mode: " + (Object)((Object)condition.getMode()));
            }
        }
        stack.pop();
    }

    private void wrap(CodeWriter code, CondStack stack, IfCondition cond) throws CodegenException {
        boolean wrap = this.isWrapNeeded(cond);
        if (wrap) {
            code.add('(');
        }
        this.add(code, stack, cond);
        if (wrap) {
            code.add(')');
        }
    }

    private void wrap(CodeWriter code, InsnArg firstArg) throws CodegenException {
        boolean wrap = ConditionGen.isArgWrapNeeded(firstArg);
        if (wrap) {
            code.add('(');
        }
        this.addArg(code, firstArg, false);
        if (wrap) {
            code.add(')');
        }
    }

    private void addCompare(CodeWriter code, CondStack stack, Compare compare) throws CodegenException {
        IfOp op = compare.getOp();
        InsnArg firstArg = compare.getA();
        InsnArg secondArg = compare.getB();
        if (firstArg.getType().equals(ArgType.BOOLEAN) && secondArg.isLiteral() && secondArg.getType().equals(ArgType.BOOLEAN)) {
            LiteralArg lit = (LiteralArg)secondArg;
            if (lit.getLiteral() == 0L) {
                op = op.invert();
            }
            if (op == IfOp.EQ) {
                if (stack.getStack().size() == 1) {
                    this.addArg(code, firstArg, false);
                } else {
                    this.wrap(code, firstArg);
                }
                return;
            }
            if (op == IfOp.NE) {
                code.add('!');
                this.wrap(code, firstArg);
                return;
            }
            this.mth.addWarn("Unsupported boolean condition " + op.getSymbol());
        }
        this.addArg(code, firstArg, ConditionGen.isArgWrapNeeded(firstArg));
        code.add(' ').add(op.getSymbol()).add(' ');
        this.addArg(code, secondArg, ConditionGen.isArgWrapNeeded(secondArg));
    }

    private void addTernary(CodeWriter code, CondStack stack, IfCondition condition) throws CodegenException {
        this.add(code, stack, condition.first());
        code.add(" ? ");
        this.add(code, stack, condition.second());
        code.add(" : ");
        this.add(code, stack, condition.third());
    }

    private void addNot(CodeWriter code, CondStack stack, IfCondition condition) throws CodegenException {
        code.add('!');
        this.wrap(code, stack, condition.getArgs().get(0));
    }

    private void addAndOr(CodeWriter code, CondStack stack, IfCondition condition) throws CodegenException {
        String mode = condition.getMode() == IfCondition.Mode.AND ? " && " : " || ";
        Iterator<IfCondition> it = condition.getArgs().iterator();
        while (it.hasNext()) {
            this.wrap(code, stack, it.next());
            if (!it.hasNext()) continue;
            code.add(mode);
        }
    }

    private boolean isWrapNeeded(IfCondition condition) {
        if (condition.isCompare() || condition.contains(AFlag.DONT_WRAP)) {
            return false;
        }
        return condition.getMode() != IfCondition.Mode.NOT;
    }

    private static boolean isArgWrapNeeded(InsnArg arg) {
        if (!arg.isInsnWrap()) {
            return false;
        }
        InsnNode insn = ((InsnWrapArg)arg).getWrapInsn();
        InsnType insnType = insn.getType();
        if (insnType == InsnType.ARITH) {
            switch (((ArithNode)insn).getOp()) {
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case REM: {
                    return false;
                }
            }
            return true;
        }
        switch (insnType) {
            case INVOKE: 
            case SGET: 
            case IGET: 
            case AGET: 
            case CONST: 
            case ARRAY_LENGTH: {
                return false;
            }
        }
        return true;
    }

    private static class CondStack {
        private final Queue<IfCondition> stack = new LinkedList<IfCondition>();

        private CondStack() {
        }

        public Queue<IfCondition> getStack() {
            return this.stack;
        }

        public void push(IfCondition cond) {
            this.stack.add(cond);
        }

        public IfCondition pop() {
            return this.stack.poll();
        }
    }
}

