#!/bin/sh

##############################################
#     Detect & load ISA modules              #
##############################################
	
get_isapnp_modules () {
   while read IGNORE ID IGNORE
       do
         DEVICE="0x"`echo $ID | cut -b6-7``echo $ID | cut -b4-5`
         cat /lib/modules/`uname -r`/modules.isapnpmap | grep "^[^ ][^ ]*  *[^ ][^ ]*  *$DEVICE " | cut -f 1 -d " "
       done
}

for MODULE in `get_isapnp_modules < /proc/bus/isapnp/devices | sort -u`
do 
  echo Found module $MODULE
  modprobe $MODULE
done
				
