/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;
import org.jdesktop.swingbinding.adapters.BeanAdapterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbstractButtonAdapterProvider
implements BeanAdapterProvider {
    private static final String SELECTED_P = "selected";

    @Override
    public boolean providesAdapter(Class<?> type, String property) {
        return AbstractButton.class.isAssignableFrom(type) && property.intern() == SELECTED_P;
    }

    @Override
    public Object createAdapter(Object source, String property) {
        if (!this.providesAdapter(source.getClass(), property)) {
            throw new IllegalArgumentException();
        }
        return new Adapter((AbstractButton)source);
    }

    @Override
    public Class<?> getAdapterClass(Class<?> type) {
        return AbstractButton.class.isAssignableFrom(type) ? Adapter.class : null;
    }

    public static final class Adapter
    extends BeanAdapterBase {
        private AbstractButton button;
        private Handler handler;
        private boolean cachedSelected;

        private Adapter(AbstractButton button) {
            super(AbstractButtonAdapterProvider.SELECTED_P);
            this.button = button;
        }

        public boolean isSelected() {
            return this.button.isSelected();
        }

        public void setSelected(boolean selected) {
            this.button.setSelected(selected);
        }

        protected void listeningStarted() {
            this.handler = new Handler();
            this.cachedSelected = this.isSelected();
            this.button.addItemListener(this.handler);
            this.button.addPropertyChangeListener("model", this.handler);
        }

        protected void listeningStopped() {
            this.button.removeItemListener(this.handler);
            this.button.removePropertyChangeListener("model", this.handler);
            this.handler = null;
        }

        private class Handler
        implements ItemListener,
        PropertyChangeListener {
            private Handler() {
            }

            private void buttonSelectedChanged() {
                boolean oldSelected = Adapter.this.cachedSelected;
                Adapter.this.cachedSelected = Adapter.this.isSelected();
                Adapter.this.firePropertyChange(oldSelected, Adapter.this.cachedSelected);
            }

            public void itemStateChanged(ItemEvent ie) {
                this.buttonSelectedChanged();
            }

            public void propertyChange(PropertyChangeEvent pe) {
                this.buttonSelectedChanged();
            }
        }
    }
}

