/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.gephi.appearance.api.Partition;

public abstract class PartitionImpl
implements Partition {
    protected final Map<Object, Color> colorMap = new HashMap<Object, Color>();

    protected PartitionImpl() {
    }

    @Override
    public Color getColor(Object value) {
        return this.colorMap.get(value);
    }

    @Override
    public void setColor(Object value, Color color) {
        this.colorMap.put(value, color);
    }

    @Override
    public void setColors(Color[] colors) {
        Collection c = this.getSortedValues();
        if (c.size() != colors.length) {
            throw new IllegalArgumentException("The colors size must match the partition size");
        }
        int i = 0;
        for (Object o : c) {
            this.setColor(o, colors[i++]);
        }
    }

    protected abstract void refresh();

    @Override
    public Collection getSortedValues() {
        ArrayList values = new ArrayList(this.getValues());
        Collections.sort(values, new Comparator(){

            public int compare(Object o1, Object o2) {
                float p2;
                float p1 = PartitionImpl.this.percentage(o1);
                return p1 > (p2 = PartitionImpl.this.percentage(o2)) ? -1 : (p1 < p2 ? 1 : 0);
            }
        });
        return values;
    }
}

