/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.api.JadxArgs;
import jadx.core.deobf.DeobfClsInfo;
import jadx.core.deobf.DeobfPresets;
import jadx.core.deobf.NameMapper;
import jadx.core.deobf.OverridedMethodsNode;
import jadx.core.deobf.PackageNode;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.kotlin.KotlinMetadataUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deobfuscator {
    private static final Logger LOG = LoggerFactory.getLogger(Deobfuscator.class);
    private static final boolean DEBUG = false;
    public static final String CLASS_NAME_SEPARATOR = ".";
    public static final String INNER_CLASS_SEPARATOR = "$";
    private final JadxArgs args;
    private final RootNode root;
    private final DeobfPresets deobfPresets;
    private final Map<ClassInfo, DeobfClsInfo> clsMap = new LinkedHashMap<ClassInfo, DeobfClsInfo>();
    private final Map<FieldInfo, String> fldMap = new HashMap<FieldInfo, String>();
    private final Map<MethodInfo, String> mthMap = new HashMap<MethodInfo, String>();
    private final Map<MethodInfo, OverridedMethodsNode> ovrdMap = new HashMap<MethodInfo, OverridedMethodsNode>();
    private final List<OverridedMethodsNode> ovrd = new ArrayList<OverridedMethodsNode>();
    private final PackageNode rootPackage = new PackageNode("");
    private final Set<String> pkgSet = new TreeSet<String>();
    private final Set<String> reservedClsNames = new HashSet<String>();
    private final int maxLength;
    private final int minLength;
    private final boolean useSourceNameAsAlias;
    private final boolean parseKotlinMetadata;
    private int pkgIndex = 0;
    private int clsIndex = 0;
    private int fldIndex = 0;
    private int mthIndex = 0;

    public Deobfuscator(JadxArgs args, RootNode root, Path deobfMapFile) {
        this.args = args;
        this.root = root;
        this.minLength = args.getDeobfuscationMinLength();
        this.maxLength = args.getDeobfuscationMaxLength();
        this.useSourceNameAsAlias = args.isUseSourceNameAsClassAlias();
        this.parseKotlinMetadata = args.isParseKotlinMetadata();
        this.deobfPresets = new DeobfPresets(this, deobfMapFile);
    }

    public void execute() {
        if (!this.args.isDeobfuscationForceSave()) {
            this.deobfPresets.load();
            this.initIndexes();
        }
        this.process();
    }

    public void savePresets() {
        this.deobfPresets.save(this.args.isDeobfuscationForceSave());
    }

    public void clear() {
        this.deobfPresets.clear();
        this.clsMap.clear();
        this.fldMap.clear();
        this.mthMap.clear();
        this.ovrd.clear();
        this.ovrdMap.clear();
    }

    private void initIndexes() {
        this.pkgIndex = this.pkgSet.size();
        this.clsIndex = this.deobfPresets.getClsPresetMap().size();
        this.fldIndex = this.deobfPresets.getFldPresetMap().size();
        this.mthIndex = this.deobfPresets.getMthPresetMap().size();
    }

    private void preProcess() {
        for (ClassNode cls : this.root.getClasses()) {
            Collections.addAll(this.reservedClsNames, cls.getPackage().split("\\."));
        }
        for (ClassNode cls : this.root.getClasses()) {
            this.preProcessClass(cls);
        }
    }

    private void process() {
        this.preProcess();
        for (ClassNode cls : this.root.getClasses()) {
            this.processClass(cls);
        }
        this.postProcess();
    }

    private void postProcess() {
        int id = 1;
        for (OverridedMethodsNode o : this.ovrd) {
            boolean aliasFromPreset = false;
            String aliasToUse = null;
            for (MethodInfo mth : o.getMethods()) {
                if (!mth.isAliasFromPreset()) continue;
                aliasToUse = mth.getAlias();
                aliasFromPreset = true;
            }
            for (MethodInfo mth : o.getMethods()) {
                if (aliasToUse == null) {
                    if (mth.hasAlias() && !mth.isAliasFromPreset()) {
                        mth.setAlias(String.format("mo%d%s", id, this.prepareNamePart(mth.getName())));
                    }
                    aliasToUse = mth.getAlias();
                }
                mth.setAlias(aliasToUse);
                mth.setAliasFromPreset(aliasFromPreset);
            }
            ++id;
        }
    }

    private void resolveOverriding(MethodNode mth) {
        LinkedHashSet<ClassNode> clsParents = new LinkedHashSet<ClassNode>();
        this.collectClassHierarchy(mth.getParentClass(), clsParents);
        String mthSignature = mth.getMethodInfo().makeSignature(false);
        LinkedHashSet<MethodInfo> overrideSet = new LinkedHashSet<MethodInfo>();
        for (ClassNode classNode : clsParents) {
            MethodInfo methodInfo = this.getMthOverride(classNode.getMethods(), mthSignature);
            if (methodInfo == null) continue;
            overrideSet.add(methodInfo);
        }
        if (overrideSet.isEmpty()) {
            return;
        }
        OverridedMethodsNode overrideNode = this.getOverrideMethodsNode(overrideSet);
        if (overrideNode == null) {
            overrideNode = new OverridedMethodsNode(overrideSet);
            this.ovrd.add(overrideNode);
        }
        for (MethodInfo overrideMth : overrideSet) {
            if (this.ovrdMap.containsKey(overrideMth)) continue;
            this.ovrdMap.put(overrideMth, overrideNode);
            overrideNode.add(overrideMth);
        }
    }

    private OverridedMethodsNode getOverrideMethodsNode(Set<MethodInfo> overrideSet) {
        for (MethodInfo overrideMth : overrideSet) {
            OverridedMethodsNode node = this.ovrdMap.get(overrideMth);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private MethodInfo getMthOverride(List<MethodNode> methods, String mthSignature) {
        for (MethodNode m : methods) {
            MethodInfo mthInfo = m.getMethodInfo();
            if (!mthInfo.getShortId().startsWith(mthSignature)) continue;
            return mthInfo;
        }
        return null;
    }

    private void collectClassHierarchy(ClassNode cls, Set<ClassNode> collected) {
        boolean added = collected.add(cls);
        if (added) {
            ClassNode superNode;
            ArgType superClass = cls.getSuperClass();
            if (superClass != null && (superNode = cls.root().resolveClass(superClass)) != null) {
                this.collectClassHierarchy(superNode, collected);
            }
            for (ArgType argType : cls.getInterfaces()) {
                ClassNode interfaceNode = cls.root().resolveClass(argType);
                if (interfaceNode == null) continue;
                this.collectClassHierarchy(interfaceNode, collected);
            }
        }
    }

    private void processClass(ClassNode cls) {
        PackageNode pkgNode;
        if (Deobfuscator.isR(cls.getParentClass())) {
            return;
        }
        ClassInfo clsInfo = cls.getClassInfo();
        DeobfClsInfo deobfClsInfo = this.clsMap.get(clsInfo);
        if (deobfClsInfo != null) {
            clsInfo.changeShortName(deobfClsInfo.getAlias());
            pkgNode = deobfClsInfo.getPkg();
            if (!clsInfo.isInner() && pkgNode.hasAnyAlias()) {
                clsInfo.changePkg(pkgNode.getFullAlias());
            }
        } else if (!clsInfo.isInner() && (pkgNode = this.getPackageNode(clsInfo.getPackage(), false)) != null && pkgNode.hasAnyAlias()) {
            clsInfo.changePkg(pkgNode.getFullAlias());
        }
        for (FieldNode field : cls.getFields()) {
            if (field.contains(AFlag.DONT_RENAME)) continue;
            this.renameField(field);
        }
        for (MethodNode mth : cls.getMethods()) {
            this.renameMethod(mth);
        }
        for (ClassNode innerCls : cls.getInnerClasses()) {
            this.processClass(innerCls);
        }
    }

    private void renameField(FieldNode field) {
        FieldInfo fieldInfo = field.getFieldInfo();
        String alias = this.getFieldAlias(field);
        if (alias != null) {
            fieldInfo.setAlias(alias);
        }
    }

    public void forceRenameField(FieldNode field) {
        field.getFieldInfo().setAlias(this.makeFieldAlias(field));
    }

    private void renameMethod(MethodNode mth) {
        String alias = this.getMethodAlias(mth);
        if (alias != null) {
            mth.getMethodInfo().setAlias(alias);
        }
        if (mth.isVirtual()) {
            this.resolveOverriding(mth);
        }
    }

    public void forceRenameMethod(MethodNode mth) {
        mth.getMethodInfo().setAlias(this.makeMethodAlias(mth));
        if (mth.isVirtual()) {
            this.resolveOverriding(mth);
        }
    }

    public void addPackagePreset(String origPkgName, String pkgAlias) {
        PackageNode pkg = this.getPackageNode(origPkgName, true);
        pkg.setAlias(pkgAlias);
    }

    private PackageNode getPackageNode(String fullPkgName, boolean create) {
        if (fullPkgName.isEmpty() || fullPkgName.equals(CLASS_NAME_SEPARATOR)) {
            return this.rootPackage;
        }
        PackageNode result = this.rootPackage;
        do {
            String pkgName;
            int idx;
            if ((idx = fullPkgName.indexOf(CLASS_NAME_SEPARATOR)) > -1) {
                pkgName = fullPkgName.substring(0, idx);
                fullPkgName = fullPkgName.substring(idx + 1);
            } else {
                pkgName = fullPkgName;
                fullPkgName = "";
            }
            PackageNode parentNode = result;
            result = result.getInnerPackageByName(pkgName);
            if (result != null || !create) continue;
            result = new PackageNode(pkgName);
            parentNode.addInnerPackage(result);
        } while (!fullPkgName.isEmpty() && result != null);
        return result;
    }

    String getNameWithoutPackage(ClassInfo clsInfo) {
        String prefix;
        ClassInfo parentClsInfo = clsInfo.getParentClass();
        if (parentClsInfo != null) {
            DeobfClsInfo parentDeobfClsInfo = this.clsMap.get(parentClsInfo);
            prefix = parentDeobfClsInfo != null ? parentDeobfClsInfo.makeNameWithoutPkg() : this.getNameWithoutPackage(parentClsInfo);
            prefix = prefix + INNER_CLASS_SEPARATOR;
        } else {
            prefix = "";
        }
        return prefix + clsInfo.getShortName();
    }

    private void preProcessClass(ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        String pkgFullName = classInfo.getPackage();
        PackageNode pkg = this.getPackageNode(pkgFullName, true);
        this.processPackageFull(pkg, pkgFullName);
        String alias = this.deobfPresets.getForCls(classInfo);
        if (alias != null) {
            this.clsMap.put(classInfo, new DeobfClsInfo(this, cls, pkg, alias));
        } else if (!this.clsMap.containsKey(classInfo)) {
            String clsShortName = classInfo.getShortName();
            boolean badName = this.shouldRename(clsShortName) || this.reservedClsNames.contains(clsShortName);
            this.makeClsAlias(cls, badName);
        }
        for (ClassNode innerCls : cls.getInnerClasses()) {
            this.preProcessClass(innerCls);
        }
    }

    public String getClsAlias(ClassNode cls) {
        DeobfClsInfo deobfClsInfo = this.clsMap.get(cls.getClassInfo());
        if (deobfClsInfo != null) {
            return deobfClsInfo.getAlias();
        }
        return this.makeClsAlias(cls, true);
    }

    public String getPkgAlias(ClassNode cls) {
        PackageNode pkg;
        ClassInfo classInfo = cls.getClassInfo();
        DeobfClsInfo deobfClsInfo = this.clsMap.get(classInfo);
        if (deobfClsInfo != null) {
            pkg = deobfClsInfo.getPkg();
        } else {
            String fullPkgName = classInfo.getPackage();
            pkg = this.getPackageNode(fullPkgName, true);
            this.processPackageFull(pkg, fullPkgName);
        }
        if (pkg.hasAnyAlias()) {
            return pkg.getFullAlias();
        }
        return pkg.getFullName();
    }

    private String makeClsAlias(ClassNode cls, boolean badName) {
        ClassInfo kotlinCls;
        String alias = null;
        String pkgName = null;
        if (this.parseKotlinMetadata && (kotlinCls = KotlinMetadataUtils.getClassName(cls)) != null) {
            alias = this.prepareNameFull(kotlinCls.getShortName(), "C");
            pkgName = kotlinCls.getPackage();
        }
        if (alias == null && this.useSourceNameAsAlias) {
            alias = this.getAliasFromSourceFile(cls);
        }
        ClassInfo classInfo = cls.getClassInfo();
        if (alias == null) {
            if (badName) {
                String clsName = classInfo.getShortName();
                String prefix = this.makeClsPrefix(cls);
                alias = String.format("%sC%04d%s", prefix, this.clsIndex++, this.prepareNamePart(clsName));
            } else {
                return classInfo.getShortName();
            }
        }
        if (pkgName == null) {
            pkgName = classInfo.getPackage();
        }
        PackageNode pkg = this.getPackageNode(pkgName, true);
        this.clsMap.put(classInfo, new DeobfClsInfo(this, cls, pkg, alias));
        return alias;
    }

    private String makeClsPrefix(ClassNode cls) {
        if (cls.isEnum()) {
            return "Enum";
        }
        String result = "";
        if (cls.getAccessFlags().isAbstract()) {
            result = result + "Abstract";
        }
        ClassNode currentCls = cls;
        block0: while (currentCls != null) {
            if (currentCls.getSuperClass() != null) {
                String superClsName = currentCls.getSuperClass().getObject();
                if (superClsName.startsWith("android.app.")) {
                    result = result + superClsName.substring(12);
                    break;
                }
                if (superClsName.startsWith("android.os.")) {
                    result = result + superClsName.substring(11);
                    break;
                }
            }
            for (ArgType intf : cls.getInterfaces()) {
                String intfClsName = intf.getObject();
                if (intfClsName.equals("java.lang.Runnable")) {
                    result = result + "Runnable";
                    break block0;
                }
                if (intfClsName.startsWith("java.util.concurrent.")) {
                    result = result + intfClsName.substring(21);
                    break block0;
                }
                if (intfClsName.startsWith("android.view.")) {
                    result = result + intfClsName.substring(13);
                    break block0;
                }
                if (!intfClsName.startsWith("android.content.")) continue;
                result = result + intfClsName.substring(16);
                break block0;
            }
            if (currentCls.getSuperClass() == null) break;
            currentCls = cls.root().resolveClass(currentCls.getSuperClass());
        }
        return result;
    }

    @Nullable
    private String getAliasFromSourceFile(ClassNode cls) {
        SourceFileAttr sourceFileAttr = cls.get(AType.SOURCE_FILE);
        if (sourceFileAttr == null) {
            return null;
        }
        if (cls.getClassInfo().isInner()) {
            return null;
        }
        String name = sourceFileAttr.getFileName();
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - ".java".length());
        } else if (name.endsWith(".kt")) {
            name = name.substring(0, name.length() - ".kt".length());
        }
        if (!NameMapper.isValidAndPrintable(name)) {
            return null;
        }
        for (DeobfClsInfo deobfClsInfo : this.clsMap.values()) {
            if (!deobfClsInfo.getAlias().equals(name)) continue;
            return null;
        }
        ClassNode otherCls = cls.root().resolveClass(cls.getPackage() + '.' + name);
        if (otherCls != null) {
            return null;
        }
        cls.remove(AType.SOURCE_FILE);
        return name;
    }

    @Nullable
    private String getFieldAlias(FieldNode field) {
        FieldInfo fieldInfo = field.getFieldInfo();
        String alias = this.fldMap.get(fieldInfo);
        if (alias != null) {
            return alias;
        }
        alias = this.deobfPresets.getForFld(fieldInfo);
        if (alias != null) {
            this.fldMap.put(fieldInfo, alias);
            return alias;
        }
        if (this.shouldRename(field.getName())) {
            return this.makeFieldAlias(field);
        }
        return null;
    }

    @Nullable
    private String getMethodAlias(MethodNode mth) {
        MethodInfo methodInfo = mth.getMethodInfo();
        if (methodInfo.isClassInit() || methodInfo.isConstructor()) {
            return null;
        }
        String alias = this.mthMap.get(methodInfo);
        if (alias != null) {
            return alias;
        }
        alias = this.deobfPresets.getForMth(methodInfo);
        if (alias != null) {
            this.mthMap.put(methodInfo, alias);
            methodInfo.setAliasFromPreset(true);
            return alias;
        }
        if (this.shouldRename(mth.getName())) {
            return this.makeMethodAlias(mth);
        }
        return null;
    }

    public String makeFieldAlias(FieldNode field) {
        String alias = String.format("f%d%s", this.fldIndex++, this.prepareNamePart(field.getName()));
        this.fldMap.put(field.getFieldInfo(), alias);
        return alias;
    }

    public String makeMethodAlias(MethodNode mth) {
        String alias = String.format("m%d%s", this.mthIndex++, this.prepareNamePart(mth.getName()));
        this.mthMap.put(mth.getMethodInfo(), alias);
        return alias;
    }

    private void processPackageFull(PackageNode pkg, String fullName) {
        if (this.pkgSet.contains(fullName)) {
            return;
        }
        this.pkgSet.add(fullName);
        PackageNode parentPkg = pkg.getParentPackage();
        while (!parentPkg.getName().isEmpty()) {
            if (!parentPkg.hasAlias()) {
                this.processPackageFull(parentPkg, parentPkg.getFullName());
            }
            parentPkg = parentPkg.getParentPackage();
        }
        if (!pkg.hasAlias()) {
            String pkgName = pkg.getName();
            if (this.args.isDeobfuscationOn() && this.shouldRename(pkgName) || this.args.isRenameValid() && !NameMapper.isValidIdentifier(pkgName) || this.args.isRenamePrintable() && !NameMapper.isAllCharsPrintable(pkgName)) {
                String pkgAlias = String.format("p%03d%s", this.pkgIndex++, this.prepareNamePart(pkg.getName()));
                pkg.setAlias(pkgAlias);
            }
        }
    }

    private boolean shouldRename(String s) {
        int len = s.length();
        return len < this.minLength || len > this.maxLength;
    }

    private String prepareNamePart(String name) {
        if (name.length() > this.maxLength) {
            return 'x' + Integer.toHexString(name.hashCode());
        }
        return NameMapper.removeInvalidCharsMiddle(name);
    }

    private String prepareNameFull(String name, String prefix) {
        if (name.length() > this.maxLength) {
            return Deobfuscator.makeHashName(name, prefix);
        }
        String result = NameMapper.removeInvalidChars(name, prefix);
        if (result.isEmpty()) {
            return Deobfuscator.makeHashName(name, prefix);
        }
        if (NameMapper.isReserved(result)) {
            return prefix + result;
        }
        return result;
    }

    private static String makeHashName(String name, String invalidPrefix) {
        return invalidPrefix + 'x' + Integer.toHexString(name.hashCode());
    }

    private void dumpClassAlias(ClassNode cls) {
        PackageNode pkg = this.getPackageNode(cls.getPackage(), false);
        if (pkg != null) {
            if (!cls.getFullName().equals(this.getClassFullName(cls))) {
                LOG.info("Alias name for class '{}' is '{}'", (Object)cls.getFullName(), (Object)this.getClassFullName(cls));
            }
        } else {
            LOG.error("Can't find package node for '{}'", (Object)cls.getPackage());
        }
    }

    private void dumpAlias() {
        for (ClassNode cls : this.root.getClasses()) {
            this.dumpClassAlias(cls);
        }
    }

    private String getPackageName(String packageName) {
        PackageNode pkg = this.getPackageNode(packageName, false);
        if (pkg != null) {
            return pkg.getFullAlias();
        }
        return packageName;
    }

    private String getClassName(ClassInfo clsInfo) {
        DeobfClsInfo deobfClsInfo = this.clsMap.get(clsInfo);
        if (deobfClsInfo != null) {
            return deobfClsInfo.makeNameWithoutPkg();
        }
        return this.getNameWithoutPackage(clsInfo);
    }

    private String getClassFullName(ClassNode cls) {
        ClassInfo clsInfo = cls.getClassInfo();
        DeobfClsInfo deobfClsInfo = this.clsMap.get(clsInfo);
        if (deobfClsInfo != null) {
            return deobfClsInfo.getFullName();
        }
        return this.getPackageName(clsInfo.getPackage()) + CLASS_NAME_SEPARATOR + this.getClassName(clsInfo);
    }

    public Map<ClassInfo, DeobfClsInfo> getClsMap() {
        return this.clsMap;
    }

    public Map<FieldInfo, String> getFldMap() {
        return this.fldMap;
    }

    public Map<MethodInfo, String> getMthMap() {
        return this.mthMap;
    }

    public PackageNode getRootPackage() {
        return this.rootPackage;
    }

    private static boolean isR(ClassNode cls) {
        if (!cls.getClassInfo().getShortName().equals("R")) {
            return false;
        }
        if (!cls.getMethods().isEmpty() || !cls.getFields().isEmpty()) {
            return false;
        }
        for (ClassNode inner : cls.getInnerClasses()) {
            for (MethodNode m : inner.getMethods()) {
                if (m.getMethodInfo().isConstructor() || m.getMethodInfo().isClassInit()) continue;
                return false;
            }
            for (FieldNode field : cls.getFields()) {
                ArgType type = field.getType();
                if (type == ArgType.INT || type.isArray() && type.getArrayElement() == ArgType.INT) continue;
                return false;
            }
        }
        return true;
    }
}

