/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import org.a11y.brlapi.BasicConnection;
import org.a11y.brlapi.ConnectionSettings;
import org.a11y.brlapi.DisplaySize;

public class Connection
extends BasicConnection {
    public Connection(ConnectionSettings connectionSettings) {
        super(connectionSettings);
    }

    public int getCellCount() {
        DisplaySize displaySize = this.getDisplaySize();
        return displaySize.getWidth() * displaySize.getHeight();
    }

    public int enterTtyMode(int n) {
        return this.enterTtyMode(n, null);
    }

    public int enterTtyMode(String string) {
        return this.enterTtyMode(-1, string);
    }

    public int enterTtyMode() {
        return this.enterTtyMode(null);
    }

    public void enterTtyModeWithPath(int ... nArray) {
        this.enterTtyModeWithPath(nArray, null);
    }

    @Override
    public void writeDots(byte[] byArray) {
        int n = this.getCellCount();
        if (byArray.length != n) {
            byte[] byArray2 = new byte[n];
            while (n > byArray.length) {
                byArray2[--n] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        super.writeDots(byArray);
    }

    @Override
    public void writeText(int n, String string) {
        if (string != null) {
            int n2 = this.getCellCount();
            StringBuilder stringBuilder = new StringBuilder(string);
            while (stringBuilder.length() < n2) {
                stringBuilder.append(' ');
            }
            string = stringBuilder.toString();
            string = string.substring(0, n2);
        }
        super.writeText(n, string);
    }

    public void writeText(String string, int n) {
        this.writeText(n, string);
    }

    public void writeText(int n) {
        this.writeText(n, null);
    }

    public void writeText(String string) {
        this.writeText(0, string);
    }
}

