/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJTransform;

public class TJTransformer
extends TJDecompressor {
    private int[] transformedSizes = null;

    public TJTransformer() throws TJException {
        this.init();
    }

    public TJTransformer(byte[] byArray) throws TJException {
        this.init();
        this.setSourceImage(byArray, byArray.length);
    }

    public TJTransformer(byte[] byArray, int n) throws TJException {
        this.init();
        this.setSourceImage(byArray, n);
    }

    public void transform(byte[][] byArray, TJTransform[] tJTransformArray, int n) throws TJException {
        if (this.jpegBuf == null) {
            throw new IllegalStateException("JPEG buffer not initialized");
        }
        this.transformedSizes = this.transform(this.jpegBuf, this.jpegBufSize, byArray, tJTransformArray, n);
    }

    public TJDecompressor[] transform(TJTransform[] tJTransformArray, int n) throws TJException {
        int n2;
        byte[][] byArrayArray = new byte[tJTransformArray.length][];
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new IllegalStateException("JPEG buffer not initialized");
        }
        for (int i = 0; i < tJTransformArray.length; ++i) {
            n2 = this.jpegWidth;
            int n3 = this.jpegHeight;
            if ((tJTransformArray[i].options & 4) != 0) {
                if (tJTransformArray[i].width != 0) {
                    n2 = tJTransformArray[i].width;
                }
                if (tJTransformArray[i].height != 0) {
                    n3 = tJTransformArray[i].height;
                }
            }
            byArrayArray[i] = new byte[TJ.bufSize(n2, n3, this.jpegSubsamp)];
        }
        TJDecompressor[] tJDecompressorArray = new TJDecompressor[tJTransformArray.length];
        this.transform(byArrayArray, tJTransformArray, n);
        for (n2 = 0; n2 < tJTransformArray.length; ++n2) {
            tJDecompressorArray[n2] = new TJDecompressor(byArrayArray[n2], this.transformedSizes[n2]);
        }
        return tJDecompressorArray;
    }

    public int[] getTransformedSizes() {
        if (this.transformedSizes == null) {
            throw new IllegalStateException("No image has been transformed yet");
        }
        return this.transformedSizes;
    }

    private native void init() throws TJException;

    private native int[] transform(byte[] var1, int var2, byte[][] var3, TJTransform[] var4, int var5) throws TJException;

    static {
        TJLoader.load();
    }
}

