/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.catalina.tribes.util.ExecutorFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class McastServiceImpl {
    private static final Log log = LogFactory.getLog(McastService.class);
    protected static int MAX_PACKET_SIZE = 65535;
    protected volatile boolean doRunSender = false;
    protected volatile boolean doRunReceiver = false;
    protected volatile int startLevel = 0;
    protected MulticastSocket socket;
    protected MemberImpl member;
    protected InetAddress address;
    protected int port;
    protected long timeToExpiration;
    protected long sendFrequency;
    protected DatagramPacket sendPacket;
    protected DatagramPacket receivePacket;
    protected Membership membership;
    protected MembershipListener service;
    protected MessageListener msgservice;
    protected ReceiverThread receiver;
    protected SenderThread sender;
    protected int mcastTTL = -1;
    protected int mcastSoTimeout = -1;
    protected InetAddress mcastBindAddress = null;
    protected int recoveryCounter = 10;
    protected long recoverySleepTime = 5000L;
    protected boolean recoveryEnabled = true;
    protected ExecutorService executor = ExecutorFactory.newThreadPool(0, 2, 2L, TimeUnit.SECONDS);
    protected boolean localLoopbackDisabled = false;
    private Channel channel;
    protected final Object expiredMutex = new Object();
    private final Object sendLock = new Object();

    public McastServiceImpl(MemberImpl memberImpl, long l, long l2, int n, InetAddress inetAddress, InetAddress inetAddress2, int n2, int n3, MembershipListener membershipListener, MessageListener messageListener, boolean bl) throws IOException {
        this.member = memberImpl;
        this.address = inetAddress2;
        this.port = n;
        this.mcastSoTimeout = n3;
        this.mcastTTL = n2;
        this.mcastBindAddress = inetAddress;
        this.timeToExpiration = l2;
        this.service = membershipListener;
        this.msgservice = messageListener;
        this.sendFrequency = l;
        this.localLoopbackDisabled = bl;
        this.init();
    }

    public void init() throws IOException {
        this.setupSocket();
        this.sendPacket = new DatagramPacket(new byte[MAX_PACKET_SIZE], MAX_PACKET_SIZE);
        this.sendPacket.setAddress(this.address);
        this.sendPacket.setPort(this.port);
        this.receivePacket = new DatagramPacket(new byte[MAX_PACKET_SIZE], MAX_PACKET_SIZE);
        this.receivePacket.setAddress(this.address);
        this.receivePacket.setPort(this.port);
        this.member.setCommand(new byte[0]);
        this.member.getData(true, true);
        if (this.membership == null) {
            this.membership = new Membership(this.member);
        }
    }

    protected void setupSocket() throws IOException {
        if (this.mcastBindAddress != null) {
            try {
                log.info((Object)("Attempting to bind the multicast socket to " + this.address + ":" + this.port));
                this.socket = new MulticastSocket(new InetSocketAddress(this.address, this.port));
            }
            catch (BindException bindException) {
                log.info((Object)"Binding to multicast address, failed. Binding to port only.");
                this.socket = new MulticastSocket(this.port);
            }
        } else {
            this.socket = new MulticastSocket(this.port);
        }
        this.socket.setLoopbackMode(this.localLoopbackDisabled);
        if (this.mcastBindAddress != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting multihome multicast interface to:" + this.mcastBindAddress));
            }
            this.socket.setInterface(this.mcastBindAddress);
        }
        if (this.mcastSoTimeout <= 0) {
            this.mcastSoTimeout = (int)this.sendFrequency;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting cluster mcast soTimeout to " + this.mcastSoTimeout));
        }
        this.socket.setSoTimeout(this.mcastSoTimeout);
        if (this.mcastTTL >= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting cluster mcast TTL to " + this.mcastTTL));
            }
            this.socket.setTimeToLive(this.mcastTTL);
        }
    }

    public synchronized void start(int n) throws IOException {
        boolean bl = false;
        if ((n & 4) == 4) {
            if (this.receiver != null) {
                throw new IllegalStateException("McastService.receive already running.");
            }
            try {
                if (this.sender == null) {
                    this.socket.joinGroup(this.address);
                }
            }
            catch (IOException iOException) {
                log.error((Object)"Unable to join multicast group, make sure your system has multicasting enabled.");
                throw iOException;
            }
            this.doRunReceiver = true;
            this.receiver = new ReceiverThread();
            this.receiver.setDaemon(true);
            this.receiver.start();
            bl = true;
        }
        if ((n & 8) == 8) {
            if (this.sender != null) {
                throw new IllegalStateException("McastService.send already running.");
            }
            if (this.receiver == null) {
                this.socket.joinGroup(this.address);
            }
            this.send(false);
            this.doRunSender = true;
            this.sender = new SenderThread(this.sendFrequency);
            this.sender.setDaemon(true);
            this.sender.start();
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("Invalid start level. Only acceptable levels are Channel.MBR_RX_SEQ and Channel.MBR_TX_SEQ");
        }
        this.waitForMembers(n);
        this.startLevel |= n;
    }

    private void waitForMembers(int n) {
        long l = this.sendFrequency * 2L;
        if (log.isInfoEnabled()) {
            log.info((Object)("Sleeping for " + l + " milliseconds to establish cluster membership, start level:" + n));
        }
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Done sleeping, membership established, start level:" + n));
        }
    }

    public synchronized boolean stop(int n) throws IOException {
        boolean bl = false;
        if ((n & 4) == 4) {
            bl = true;
            this.doRunReceiver = false;
            if (this.receiver != null) {
                this.receiver.interrupt();
            }
            this.receiver = null;
        }
        if ((n & 8) == 8) {
            bl = true;
            this.doRunSender = false;
            if (this.sender != null) {
                this.sender.interrupt();
            }
            this.sender = null;
        }
        if (!bl) {
            throw new IllegalArgumentException("Invalid stop level. Only acceptable levels are Channel.MBR_RX_SEQ and Channel.MBR_TX_SEQ");
        }
        this.startLevel &= ~n;
        if (this.startLevel == 0) {
            this.member.setCommand(Member.SHUTDOWN_PAYLOAD);
            this.member.getData(true, true);
            this.send(false);
            try {
                this.socket.leaveGroup(this.address);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.member.setServiceStartTime(-1L);
        }
        return this.startLevel == 0;
    }

    public void receive() throws IOException {
        boolean bl = true;
        try {
            this.socket.receive(this.receivePacket);
            if (this.receivePacket.getLength() > MAX_PACKET_SIZE) {
                log.error((Object)("Multicast packet received was too long, dropping package:" + this.receivePacket.getLength()));
            } else {
                byte[] byArray = new byte[this.receivePacket.getLength()];
                System.arraycopy(this.receivePacket.getData(), this.receivePacket.getOffset(), byArray, 0, byArray.length);
                if (XByteBuffer.firstIndexOf(byArray, 0, MemberImpl.TRIBES_MBR_BEGIN) == 0) {
                    this.memberDataReceived(byArray);
                } else {
                    this.memberBroadcastsReceived(byArray);
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        if (bl) {
            this.checkExpired();
        }
    }

    private void memberDataReceived(byte[] byArray) {
        final MemberImpl memberImpl = MemberImpl.getMember(byArray);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mcast receive ping from member " + memberImpl));
        }
        Runnable runnable = null;
        if (Arrays.equals(memberImpl.getCommand(), Member.SHUTDOWN_PAYLOAD)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member has shutdown:" + memberImpl));
            }
            this.membership.removeMember(memberImpl);
            runnable = new Runnable(){

                @Override
                public void run() {
                    String string = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("Membership-MemberDisappeared.");
                        McastServiceImpl.this.service.memberDisappeared(memberImpl);
                    }
                    finally {
                        Thread.currentThread().setName(string);
                    }
                }
            };
        } else if (this.membership.memberAlive(memberImpl)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mcast add member " + memberImpl));
            }
            runnable = new Runnable(){

                @Override
                public void run() {
                    String string = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("Membership-MemberAdded.");
                        McastServiceImpl.this.service.memberAdded(memberImpl);
                    }
                    finally {
                        Thread.currentThread().setName(string);
                    }
                }
            };
        }
        if (runnable != null) {
            this.executor.execute(runnable);
        }
    }

    private void memberBroadcastsReceived(byte[] byArray) {
        XByteBuffer xByteBuffer;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Mcast received broadcasts.");
        }
        if ((xByteBuffer = new XByteBuffer(byArray, true)).countPackages(true) > 0) {
            int n = xByteBuffer.countPackages();
            final ChannelData[] channelDataArray = new ChannelData[n];
            for (int i = 0; i < n; ++i) {
                try {
                    channelDataArray[i] = xByteBuffer.extractPackage(true);
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    log.debug((Object)"Unable to decode message.", (Throwable)illegalStateException);
                    continue;
                }
                catch (IOException iOException) {
                    log.debug((Object)"Unable to decode message.", (Throwable)iOException);
                }
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String string = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("Membership-MemberAdded.");
                        for (ChannelData channelData : channelDataArray) {
                            try {
                                if (channelData == null || McastServiceImpl.this.member.equals(channelData.getAddress())) continue;
                                McastServiceImpl.this.msgservice.messageReceived(channelData);
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof ThreadDeath) {
                                    throw (ThreadDeath)throwable;
                                }
                                if (throwable instanceof VirtualMachineError) {
                                    throw (VirtualMachineError)throwable;
                                }
                                log.error((Object)"Unable to receive broadcast message.", throwable);
                            }
                        }
                    }
                    finally {
                        Thread.currentThread().setName(string);
                    }
                }
            };
            this.executor.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkExpired() {
        Object object = this.expiredMutex;
        synchronized (object) {
            MemberImpl[] memberImplArray;
            for (final MemberImpl memberImpl : memberImplArray = this.membership.expire(this.timeToExpiration)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mcast expire  member " + memberImpl));
                }
                try {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            String string = Thread.currentThread().getName();
                            try {
                                Thread.currentThread().setName("Membership-MemberExpired.");
                                McastServiceImpl.this.service.memberDisappeared(memberImpl);
                            }
                            finally {
                                Thread.currentThread().setName(string);
                            }
                        }
                    };
                    this.executor.execute(runnable);
                }
                catch (Exception exception) {
                    log.error((Object)"Unable to process member disappeared message.", (Throwable)exception);
                }
            }
        }
    }

    public void send(boolean bl) throws IOException {
        this.send(bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(boolean bl, DatagramPacket datagramPacket) throws IOException {
        Object object;
        boolean bl2 = bl = bl && datagramPacket == null;
        if (datagramPacket == null) {
            this.member.inc();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Mcast send ping from member " + this.member));
            }
            object = this.member.getData();
            datagramPacket = new DatagramPacket((byte[])object, ((byte[])object).length);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Sending message broadcast " + datagramPacket.getLength() + " bytes from " + this.member));
        }
        datagramPacket.setAddress(this.address);
        datagramPacket.setPort(this.port);
        Object object2 = this.sendLock;
        object = object2;
        synchronized (object2) {
            this.socket.send(datagramPacket);
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            if (bl) {
                this.checkExpired();
            }
            return;
        }
    }

    public long getServiceStartTime() {
        return this.member != null ? this.member.getServiceStartTime() : -1L;
    }

    public int getRecoveryCounter() {
        return this.recoveryCounter;
    }

    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public long getRecoverySleepTime() {
        return this.recoverySleepTime;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setRecoveryCounter(int n) {
        this.recoveryCounter = n;
    }

    public void setRecoveryEnabled(boolean bl) {
        this.recoveryEnabled = bl;
    }

    public void setRecoverySleepTime(long l) {
        this.recoverySleepTime = l;
    }

    protected static class RecoveryThread
    extends Thread {
        static volatile boolean running = false;
        McastServiceImpl parent = null;

        public static synchronized void recover(McastServiceImpl mcastServiceImpl) {
            if (running) {
                return;
            }
            if (!mcastServiceImpl.isRecoveryEnabled()) {
                return;
            }
            running = true;
            RecoveryThread recoveryThread = new RecoveryThread(mcastServiceImpl);
            String string = "";
            if (mcastServiceImpl.channel instanceof GroupChannel && ((GroupChannel)mcastServiceImpl.channel).getName() != null) {
                string = "[" + ((GroupChannel)mcastServiceImpl.channel).getName() + "]";
            }
            recoveryThread.setName("Tribes-MembershipRecovery" + string);
            recoveryThread.setDaemon(true);
            recoveryThread.start();
        }

        public RecoveryThread(McastServiceImpl mcastServiceImpl) {
            this.parent = mcastServiceImpl;
        }

        public boolean stopService() {
            try {
                this.parent.stop(12);
                return true;
            }
            catch (Exception exception) {
                log.warn((Object)"Recovery thread failed to stop membership service.", (Throwable)exception);
                return false;
            }
        }

        public boolean startService() {
            try {
                this.parent.init();
                this.parent.start(12);
                return true;
            }
            catch (Exception exception) {
                log.warn((Object)"Recovery thread failed to start membership service.", (Throwable)exception);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            int n = 0;
            try {
                while (!bl) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Tribes membership, running recovery thread, multicasting is not functional.");
                    }
                    if (this.stopService() & this.startService()) {
                        bl = true;
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Membership recovery was successful.");
                        }
                    }
                    try {
                        if (bl) continue;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Recovery attempt " + ++n + " failed, trying again in " + this.parent.recoverySleepTime + " seconds"));
                        }
                        Thread.sleep(this.parent.recoverySleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            finally {
                running = false;
            }
        }
    }

    public class SenderThread
    extends Thread {
        long time;
        int errorCounter = 0;

        public SenderThread(long l) {
            this.time = l;
            String string = "";
            if (McastServiceImpl.this.channel instanceof GroupChannel && ((GroupChannel)McastServiceImpl.this.channel).getName() != null) {
                string = "[" + ((GroupChannel)McastServiceImpl.this.channel).getName() + "]";
            }
            this.setName("Tribes-MembershipSender" + string);
        }

        @Override
        public void run() {
            while (McastServiceImpl.this.doRunSender) {
                block7: {
                    try {
                        McastServiceImpl.this.send(true);
                        this.errorCounter = 0;
                    }
                    catch (Exception exception) {
                        if (this.errorCounter == 0) {
                            log.warn((Object)"Unable to send mcast message.", (Throwable)exception);
                        } else {
                            log.debug((Object)"Unable to send mcast message.", (Throwable)exception);
                        }
                        if (++this.errorCounter < McastServiceImpl.this.recoveryCounter) break block7;
                        this.errorCounter = 0;
                        RecoveryThread.recover(McastServiceImpl.this);
                    }
                }
                try {
                    Thread.sleep(this.time);
                }
                catch (Exception exception) {}
            }
        }
    }

    public class ReceiverThread
    extends Thread {
        int errorCounter = 0;

        public ReceiverThread() {
            String string = "";
            if (McastServiceImpl.this.channel instanceof GroupChannel && ((GroupChannel)McastServiceImpl.this.channel).getName() != null) {
                string = "[" + ((GroupChannel)McastServiceImpl.this.channel).getName() + "]";
            }
            this.setName("Tribes-MembershipReceiver" + string);
        }

        @Override
        public void run() {
            while (McastServiceImpl.this.doRunReceiver) {
                try {
                    McastServiceImpl.this.receive();
                    this.errorCounter = 0;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Invalid member mcast package.", (Throwable)arrayIndexOutOfBoundsException);
                }
                catch (Exception exception) {
                    if (exception instanceof InterruptedException) {
                        ReceiverThread.interrupted();
                        continue;
                    }
                    if (this.errorCounter == 0 && McastServiceImpl.this.doRunReceiver) {
                        log.warn((Object)"Error receiving mcast package. Sleeping 500ms", (Throwable)exception);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("Error receiving mcast package" + (McastServiceImpl.this.doRunReceiver ? ". Sleeping 500ms" : ".")), (Throwable)exception);
                    }
                    if (!McastServiceImpl.this.doRunReceiver) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (++this.errorCounter < McastServiceImpl.this.recoveryCounter) continue;
                    this.errorCounter = 0;
                    RecoveryThread.recover(McastServiceImpl.this);
                }
            }
        }
    }
}

