/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio.util;

public class SingleRemoveSynchronizedAddLock {
    private long addWaitTimeout = 10000L;
    private long removeWaitTimeout = 30000L;
    private Thread remover = null;
    private boolean addLocked = false;
    private boolean removeLocked = false;
    private boolean removeEnabled = true;
    private boolean dataAvailable = false;

    public SingleRemoveSynchronizedAddLock() {
    }

    public SingleRemoveSynchronizedAddLock(boolean bl) {
        this.dataAvailable = bl;
    }

    public synchronized long getAddWaitTimeout() {
        return this.addWaitTimeout;
    }

    public synchronized void setAddWaitTimeout(long l) {
        this.addWaitTimeout = l;
    }

    public synchronized long getRemoveWaitTimeout() {
        return this.removeWaitTimeout;
    }

    public synchronized void setRemoveWaitTimeout(long l) {
        this.removeWaitTimeout = l;
    }

    public synchronized boolean isDataAvailable() {
        return this.dataAvailable;
    }

    public synchronized boolean isAddLocked() {
        return this.addLocked;
    }

    public synchronized boolean isRemoveLocked() {
        return this.removeLocked;
    }

    public synchronized boolean isRemovePolling() {
        return this.remover != null;
    }

    public synchronized void lockAdd() {
        if (this.addLocked || this.removeLocked) {
            do {
                try {
                    this.wait(this.addWaitTimeout);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            } while (this.addLocked || this.removeLocked);
        }
        this.addLocked = true;
    }

    public synchronized boolean lockRemove() {
        this.removeLocked = false;
        this.removeEnabled = true;
        if ((this.addLocked || !this.dataAvailable) && this.removeEnabled) {
            this.remover = Thread.currentThread();
            do {
                try {
                    this.wait(this.removeWaitTimeout);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            } while ((this.addLocked || !this.dataAvailable) && this.removeEnabled);
            this.remover = null;
        }
        if (this.removeEnabled) {
            this.removeLocked = true;
        }
        return this.removeLocked;
    }

    public synchronized void unlockAdd(boolean bl) {
        this.addLocked = false;
        this.dataAvailable = bl;
        if (this.remover != null && (bl || !this.removeEnabled)) {
            this.remover.interrupt();
        } else {
            this.notifyAll();
        }
    }

    public synchronized void unlockRemove() {
        this.removeLocked = false;
        this.dataAvailable = false;
        this.notifyAll();
    }

    public synchronized void abortRemove() {
        this.removeEnabled = false;
        if (this.remover != null) {
            this.remover.interrupt();
        }
    }
}

