/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javax.management.ObjectName;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class WebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    private static boolean first = true;
    private WebappClassLoaderBase classLoader = null;
    private Container container = null;
    private boolean delegate = false;
    private int jarOpenInterval = 90000;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    private String loaderClass = "org.apache.catalina.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.loader");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;
    private ArrayList<String> loaderRepositories = null;
    private boolean searchExternalFirst = false;
    private static final Log log = LogFactory.getLog(WebappLoader.class);

    public WebappLoader() {
        this(null);
    }

    @Deprecated
    public WebappLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean bl) {
        boolean bl2 = this.delegate;
        this.delegate = bl;
        this.support.firePropertyChange("delegate", (Object)bl2, (Object)this.delegate);
    }

    public void setJarOpenInterval(int n) {
        this.jarOpenInterval = n;
    }

    public int getJarOpenInterval() {
        return this.jarOpenInterval;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String string) {
        this.loaderClass = string;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean bl) {
        boolean bl2 = this.reloadable;
        this.reloadable = bl;
        this.support.firePropertyChange("reloadable", (Object)bl2, (Object)this.reloadable);
    }

    public boolean getSearchExternalFirst() {
        return this.searchExternalFirst;
    }

    public void setSearchExternalFirst(boolean bl) {
        this.searchExternalFirst = bl;
        if (this.classLoader != null) {
            this.classLoader.setSearchExternalFirst(bl);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addRepository(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.addRepository", new Object[]{string}));
        }
        for (int i = 0; i < this.repositories.length; ++i) {
            if (!string.equals(this.repositories[i])) continue;
            return;
        }
        String[] stringArray = new String[this.repositories.length + 1];
        for (int i = 0; i < this.repositories.length; ++i) {
            stringArray[i] = this.repositories[i];
        }
        stringArray[this.repositories.length] = string;
        this.repositories = stringArray;
        if (this.getState().isAvailable() && this.classLoader != null) {
            this.classLoader.addRepository(string);
            if (this.loaderRepositories != null) {
                this.loaderRepositories.add(string);
            }
            this.setClassPath();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(WebappLoader.class.getClassLoader());
                if (!(this.container instanceof StandardContext)) return;
                ((StandardContext)this.container).reload();
                return;
            }
            finally {
                if (this.container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.container.getLoader().getClassLoader());
                }
            }
        } else {
            this.closeJARs(false);
        }
    }

    @Override
    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public String[] getRepositories() {
        return (String[])this.repositories.clone();
    }

    public String getRepositoriesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.repositories.length; ++i) {
            stringBuilder.append(this.repositories[i]).append(":");
        }
        return stringBuilder.toString();
    }

    public String[] getLoaderRepositories() {
        if (this.loaderRepositories == null) {
            return null;
        }
        String[] stringArray = new String[this.loaderRepositories.size()];
        this.loaderRepositories.toArray(stringArray);
        return stringArray;
    }

    public String getLoaderRepositoriesString() {
        String[] stringArray = this.getLoaderRepositories();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(":");
        }
        return stringBuilder.toString();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader != null ? this.classLoader.modified() : false;
    }

    public void closeJARs(boolean bl) {
        if (this.classLoader != null) {
            this.classLoader.closeJARs(bl);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("WebappLoader[");
        if (this.container != null) {
            stringBuilder.append(this.container.getName());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.starting"));
        }
        if (this.container.getResources() == null) {
            log.info((Object)("No resources for " + this.container));
            this.setState(LifecycleState.STARTING);
            return;
        }
        DirContextURLStreamHandlerFactory dirContextURLStreamHandlerFactory = DirContextURLStreamHandlerFactory.getInstance();
        if (first) {
            first = false;
            try {
                URL.setURLStreamHandlerFactory(dirContextURLStreamHandlerFactory);
            }
            catch (Exception exception) {
                log.error((Object)"Error registering jndi stream handler", (Throwable)exception);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.info((Object)("Dual registration of jndi stream handler: " + throwable.getMessage()));
            }
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setJarOpenInterval(this.jarOpenInterval);
            this.classLoader.setResources(this.container.getResources());
            this.classLoader.setDelegate(this.delegate);
            this.classLoader.setSearchExternalFirst(this.searchExternalFirst);
            if (this.container instanceof StandardContext) {
                this.classLoader.setAntiJARLocking(((StandardContext)this.container).getAntiJARLocking());
                this.classLoader.setClearReferencesRmiTargets(((StandardContext)this.container).getClearReferencesRmiTargets());
                this.classLoader.setClearReferencesStatic(((StandardContext)this.container).getClearReferencesStatic());
                this.classLoader.setClearReferencesStopThreads(((StandardContext)this.container).getClearReferencesStopThreads());
                this.classLoader.setClearReferencesStopTimerThreads(((StandardContext)this.container).getClearReferencesStopTimerThreads());
                this.classLoader.setClearReferencesHttpClientKeepAliveThread(((StandardContext)this.container).getClearReferencesHttpClientKeepAliveThread());
                this.classLoader.setClearReferencesObjectStreamClassCaches(((StandardContext)this.container).getClearReferencesObjectStreamClassCaches());
                this.classLoader.setClearReferencesThreadLocals(((StandardContext)this.container).getClearReferencesThreadLocals());
            }
            for (int i = 0; i < this.repositories.length; ++i) {
                this.classLoader.addRepository(this.repositories[i]);
            }
            this.setRepositories();
            this.setClassPath();
            this.setPermissions();
            this.classLoader.start();
            DirContextURLStreamHandler.bind(this.classLoader, this.container.getResources());
            StandardContext standardContext = (StandardContext)this.container;
            String string = standardContext.getName();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            ObjectName objectName = new ObjectName(MBeanUtils.getDomain(standardContext) + ":type=WebappClassLoader,context=" + string + ",host=" + standardContext.getParent().getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, objectName, null);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
            ExceptionUtils.handleThrowable((Throwable)throwable2);
            log.error((Object)"LifecycleException ", throwable2);
            throw new LifecycleException("start: ", throwable2);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.stopping"));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.container instanceof Context) {
            object = ((Context)this.container).getServletContext();
            object.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader != null) {
            this.classLoader.stop();
            DirContextURLStreamHandler.unbind(this.classLoader);
        }
        try {
            object = (StandardContext)this.container;
            String string = ((ContainerBase)object).getName();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            ObjectName objectName = new ObjectName(MBeanUtils.getDomain((Container)object) + ":type=WebappClassLoader,context=" + string + ",host=" + ((ContainerBase)object).getParent().getName());
            Registry.getRegistry(null, null).unregisterComponent(objectName);
        }
        catch (Exception exception) {
            log.warn((Object)"LifecycleException ", (Throwable)exception);
        }
        this.classLoader = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!(propertyChangeEvent.getSource() instanceof Context)) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)propertyChangeEvent.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)sm.getString("webappLoader.reloadable", new Object[]{propertyChangeEvent.getNewValue().toString()}));
            }
        }
    }

    private WebappClassLoaderBase createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoaderBase webappClassLoaderBase = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.container.getParentClassLoader();
        } else {
            this.container.setParentClassLoader(this.parentClassLoader);
        }
        Class[] classArray = new Class[]{ClassLoader.class};
        Object[] objectArray = new Object[]{this.parentClassLoader};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        webappClassLoaderBase = (WebappClassLoaderBase)constructor.newInstance(objectArray);
        return webappClassLoaderBase;
    }

    private void setPermissions() {
        block20: {
            Object object;
            if (!Globals.IS_SECURITY_ENABLED) {
                return;
            }
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (file != null) {
                try {
                    object = file.getCanonicalPath();
                    this.classLoader.addPermission(new FilePermission((String)object, "read,write"));
                    this.classLoader.addPermission(new FilePermission((String)object + File.separator + "-", "read,write,delete"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                String string;
                File file2;
                object = servletContext.getResource("/");
                this.classLoader.addPermission((URL)object);
                String string2 = servletContext.getRealPath("/");
                if (string2 != null) {
                    try {
                        string2 = new File(string2).getCanonicalPath();
                        this.classLoader.addPermission(string2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                URL uRL = servletContext.getResource("/WEB-INF/classes/");
                this.classLoader.addPermission(uRL);
                URL uRL2 = servletContext.getResource("/WEB-INF/lib/");
                this.classLoader.addPermission(uRL2);
                if (string2 != null) {
                    if (uRL2 != null) {
                        File file3 = new File(string2);
                        File file4 = new File(file3, "WEB-INF/lib/");
                        try {
                            String string3 = file4.getCanonicalPath();
                            this.classLoader.addPermission(string3);
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
                if (file == null) break block20;
                if (uRL2 != null) {
                    file2 = new File(file, "WEB-INF/lib/");
                    try {
                        string = file2.getCanonicalPath();
                        this.classLoader.addPermission(string);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (uRL != null) {
                    file2 = new File(file, "WEB-INF/classes/");
                    try {
                        string = file2.getCanonicalPath();
                        this.classLoader.addPermission(string);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void setRepositories() throws IOException {
        Object object;
        Object object2;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        this.loaderRepositories = new ArrayList();
        File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (file == null) {
            log.info((Object)("No work dir for " + servletContext));
        }
        if (log.isDebugEnabled() && file != null) {
            log.debug((Object)sm.getString("webappLoader.deploy", new Object[]{file.getAbsolutePath()}));
        }
        this.classLoader.setWorkDir(file);
        DirContext dirContext = this.container.getResources();
        String string = "/WEB-INF/classes";
        DirContext dirContext2 = null;
        try {
            object2 = dirContext.lookup(string);
            if (object2 instanceof DirContext) {
                dirContext2 = (DirContext)object2;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (dirContext2 != null) {
            object2 = null;
            object = servletContext.getRealPath(string);
            if (object != null) {
                object2 = new File((String)object);
            } else {
                object2 = new File(file, string);
                if (!((File)object2).mkdirs() && !((File)object2).isDirectory()) {
                    throw new IOException(sm.getString("webappLoader.mkdirFailure"));
                }
                if (!this.copyDir(dirContext2, (File)object2)) {
                    throw new IOException(sm.getString("webappLoader.copyFailure"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappLoader.classDeploy", new Object[]{string, ((File)object2).getAbsolutePath()}));
            }
            this.classLoader.addRepository(string + "/", (File)object2);
            this.loaderRepositories.add(string + "/");
        }
        object2 = "/WEB-INF/lib";
        this.classLoader.setJarPath((String)object2);
        object = null;
        try {
            Object object3 = dirContext.lookup((String)object2);
            if (object3 instanceof DirContext) {
                object = (DirContext)object3;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object != null) {
            boolean bl = false;
            String string2 = servletContext.getRealPath((String)object2);
            File file2 = null;
            if (string2 != null) {
                file2 = new File(string2);
            } else {
                bl = true;
                file2 = new File(file, (String)object2);
                if (!file2.mkdirs() && !file2.isDirectory()) {
                    throw new IOException(sm.getString("webappLoader.mkdirFailure"));
                }
            }
            NamingEnumeration<NameClassPair> namingEnumeration = null;
            try {
                namingEnumeration = object.list("");
            }
            catch (NamingException namingException) {
                IOException iOException = new IOException(sm.getString("webappLoader.namingFailure", new Object[]{object2}));
                iOException.initCause(namingException);
                throw iOException;
            }
            while (namingEnumeration.hasMoreElements()) {
                Object object4;
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                String string3 = (String)object2 + "/" + nameClassPair.getName();
                if (!string3.endsWith(".jar")) continue;
                File file3 = new File(file2, nameClassPair.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("webappLoader.jarDeploy", new Object[]{string3, file3.getAbsolutePath()}));
                }
                Object object5 = null;
                try {
                    object5 = object.lookup(nameClassPair.getName());
                }
                catch (NamingException namingException) {
                    object4 = new IOException(sm.getString("webappLoader.namingFailure", new Object[]{string3}));
                    ((Throwable)object4).initCause(namingException);
                    throw object4;
                }
                if (!(object5 instanceof Resource)) continue;
                Resource resource = (Resource)object5;
                if (bl && !this.copy(resource.streamContent(), new FileOutputStream(file3))) {
                    throw new IOException(sm.getString("webappLoader.copyFailure"));
                }
                try {
                    object4 = JreCompat.getInstance().jarFileNewInstance(file3);
                    this.classLoader.addJar(string3, (JarFile)object4, file3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.loaderRepositories.add(string3);
            }
        }
    }

    private void setClassPath() {
        CharSequence charSequence;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        if (this.container instanceof StandardContext && (charSequence = ((StandardContext)this.container).getCompilerClasspath()) != null) {
            servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)charSequence);
            return;
        }
        charSequence = new StringBuilder();
        ClassLoader classLoader = this.getClassLoader();
        if (this.delegate && classLoader != null) {
            classLoader = classLoader.getParent();
        }
        while (classLoader != null && this.buildClassPath(servletContext, (StringBuilder)charSequence, classLoader)) {
            classLoader = classLoader.getParent();
        }
        if (this.delegate && (classLoader = this.getClassLoader()) != null) {
            this.buildClassPath(servletContext, (StringBuilder)charSequence, classLoader);
        }
        this.classpath = ((StringBuilder)charSequence).toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)((StringBuilder)charSequence).toString());
    }

    private boolean buildClassPath(ServletContext servletContext, StringBuilder stringBuilder, ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URL[] uRLArray;
            for (URL uRL : uRLArray = ((URLClassLoader)classLoader).getURLs()) {
                String string = uRL.toString();
                if (string.startsWith("file://")) {
                    string = UDecoder.URLDecode((String)string.substring(7), (Charset)B2CConverter.ISO_8859_1);
                } else if (string.startsWith("file:")) {
                    string = UDecoder.URLDecode((String)string.substring(5), (Charset)B2CConverter.ISO_8859_1);
                } else {
                    if (!string.startsWith("jndi:")) continue;
                    string = servletContext.getRealPath(string.substring(5));
                }
                if (string == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(File.pathSeparator);
                }
                stringBuilder.append(string);
            }
        } else {
            if (classLoader == ClassLoader.getSystemClassLoader()) {
                String string = System.getProperty("java.class.path");
                if (string != null && string.length() > 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(File.pathSeparator);
                    }
                    stringBuilder.append(string);
                }
                return false;
            }
            log.info((Object)("Unknown loader " + classLoader + " " + classLoader.getClass()));
            return false;
        }
        return true;
    }

    private boolean copyDir(DirContext dirContext, File file) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = dirContext.list("");
            while (namingEnumeration.hasMoreElements()) {
                Closeable closeable;
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                String string = nameClassPair.getName();
                Object object = dirContext.lookup(string);
                File file2 = new File(file, string);
                if (object instanceof Resource) {
                    FileOutputStream fileOutputStream;
                    closeable = ((Resource)object).streamContent();
                    if (this.copy((InputStream)closeable, fileOutputStream = new FileOutputStream(file2))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    closeable = new FileOutputStream(file2);
                    if (this.copy((InputStream)object, (OutputStream)closeable)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                if (!file2.isDirectory() && !file2.mkdir()) {
                    return false;
                }
                if (this.copyDir((DirContext)object, file2)) continue;
                return false;
            }
        }
        catch (NamingException namingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean copy(InputStream inputStream, OutputStream outputStream) {
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=Loader");
        if (this.container instanceof Context) {
            stringBuilder.append(",context=");
            Context context = (Context)this.container;
            String string = context.getName();
            if (!string.startsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string);
            stringBuilder.append(",host=");
            stringBuilder.append(context.getParent().getName());
        } else {
            stringBuilder.append(",container=");
            stringBuilder.append(this.container.getName());
        }
        return stringBuilder.toString();
    }
}

