/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public final class Tool {
    private static final Log log = LogFactory.getLog(Tool.class);
    private static boolean ant = false;
    private static String catalinaHome = System.getProperty("catalina.home");
    private static boolean common = false;
    private static boolean server = false;
    private static boolean shared = false;

    public static void main(String[] stringArray) {
        Object[] objectArray;
        Object object;
        Serializable serializable;
        if (catalinaHome == null) {
            log.error((Object)"Must set 'catalina.home' system property");
            System.exit(1);
        }
        int n = 0;
        while (true) {
            if (n == stringArray.length) {
                Tool.usage();
                System.exit(1);
            }
            if ("-ant".equals(stringArray[n])) {
                ant = true;
            } else if ("-common".equals(stringArray[n])) {
                common = true;
            } else if ("-server".equals(stringArray[n])) {
                server = true;
            } else {
                if (!"-shared".equals(stringArray[n])) break;
                shared = true;
            }
            ++n;
        }
        if (n > stringArray.length) {
            Tool.usage();
            System.exit(1);
        }
        if (ant) {
            System.setProperty("ant.home", catalinaHome);
        }
        ClassLoader classLoader = null;
        try {
            serializable = new ArrayList<File>();
            object = new ArrayList<File>();
            ((ArrayList)object).add(new File(catalinaHome, "classes"));
            ((ArrayList)serializable).add(new File(catalinaHome, "lib"));
            if (common) {
                ((ArrayList)object).add(new File(catalinaHome, "common" + File.separator + "classes"));
                ((ArrayList)serializable).add(new File(catalinaHome, "common" + File.separator + "lib"));
            }
            if (server) {
                ((ArrayList)object).add(new File(catalinaHome, "server" + File.separator + "classes"));
                ((ArrayList)serializable).add(new File(catalinaHome, "server" + File.separator + "lib"));
            }
            if (shared) {
                ((ArrayList)object).add(new File(catalinaHome, "shared" + File.separator + "classes"));
                ((ArrayList)serializable).add(new File(catalinaHome, "shared" + File.separator + "lib"));
            }
            classLoader = ClassLoaderFactory.createClassLoader(((ArrayList)object).toArray(new File[0]), ((ArrayList)serializable).toArray(new File[0]), null);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)"Class loader creation threw exception", throwable);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        serializable = null;
        object = stringArray[n++];
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading application class " + (String)object));
            }
            serializable = classLoader.loadClass((String)object);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)("Exception creating instance of " + (String)object), throwable);
            System.exit(1);
        }
        Method method = null;
        String[] stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identifying main() method");
            }
            objectArray = "main";
            Class[] classArray = new Class[]{stringArray2.getClass()};
            method = ((Class)serializable).getMethod((String)objectArray, classArray);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)"Exception locating main() method", throwable);
            System.exit(1);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling main() method");
            }
            objectArray = new Object[]{stringArray2};
            method.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
            ExceptionUtils.handleThrowable((Throwable)throwable2);
            log.error((Object)"Exception calling main() method", throwable2);
            System.exit(1);
        }
    }

    private static void usage() {
        log.info((Object)"Usage:  java org.apache.catalina.startup.Tool [<options>] <class> [<arguments>]");
    }
}

