/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.res.StringManager;

public final class RequestUtil {
    private static final Log log = LogFactory.getLog(RequestUtil.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.util");

    public static String filter(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        StringBuilder stringBuilder = new StringBuilder(cArray.length + 50);
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(cArray[i]);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String normalize(String string) {
        return org.apache.tomcat.util.http.RequestUtil.normalize((String)string);
    }

    @Deprecated
    public static String normalize(String string, boolean bl) {
        return org.apache.tomcat.util.http.RequestUtil.normalize((String)string, (boolean)bl);
    }

    public static void parseParameters(Map<String, String[]> map, String string, String string2) {
        block3: {
            if (string != null && string.length() > 0) {
                byte[] byArray = null;
                try {
                    byArray = string.getBytes(B2CConverter.getCharset((String)string2));
                    RequestUtil.parseParameters(map, byArray, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)sm.getString("requestUtil.parseParameters.uee", new Object[]{string2}), (Throwable)unsupportedEncodingException);
                }
            }
        }
    }

    public static String URLDecode(String string) {
        return RequestUtil.URLDecode(string, null);
    }

    public static String URLDecode(String string, String string2) {
        return RequestUtil.URLDecode(string, string2, false);
    }

    public static String URLDecode(String string, String string2, boolean bl) {
        byte[] byArray;
        block3: {
            if (string == null) {
                return null;
            }
            byArray = null;
            try {
                byArray = string2 == null ? string.getBytes(Charset.defaultCharset()) : string.getBytes(B2CConverter.getCharset((String)string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)sm.getString("requestUtil.urlDecode.uee", new Object[]{string2}), (Throwable)unsupportedEncodingException);
            }
        }
        return RequestUtil.URLDecode(byArray, string2, bl);
    }

    public static String URLDecode(byte[] byArray) {
        return RequestUtil.URLDecode(byArray, null);
    }

    @Deprecated
    public static String URLDecode(byte[] byArray, String string) {
        return RequestUtil.URLDecode(byArray, string, false);
    }

    public static String URLDecode(byte[] byArray, String string, boolean bl) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            if ((n4 = byArray[n2++]) == 43 && bl) {
                n4 = 32;
            } else if (n4 == 37) {
                if (n2 + 2 > n) {
                    throw new IllegalArgumentException(sm.getString("requestUtil.urlDecode.missingDigit"));
                }
                n4 = (byte)((RequestUtil.convertHexDigit(byArray[n2++]) << 4) + RequestUtil.convertHexDigit(byArray[n2++]));
            }
            byArray[n3++] = n4;
        }
        if (string != null) {
            try {
                return new String(byArray, 0, n3, B2CConverter.getCharset((String)string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("requestUtil.urlDecode.uee", new Object[]{string}), (Throwable)unsupportedEncodingException);
                }
                return null;
            }
        }
        return new String(byArray, 0, n3);
    }

    private static byte convertHexDigit(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 97 + 10);
        }
        if (by >= 65 && by <= 70) {
            return (byte)(by - 65 + 10);
        }
        throw new IllegalArgumentException(sm.getString("requestUtil.convertHexDigit.notHex", new Object[]{Character.valueOf((char)by)}));
    }

    private static void putMapEntry(Map<String, String[]> map, String string, String string2) {
        String[] stringArray = null;
        String[] stringArray2 = map.get(string);
        if (stringArray2 == null) {
            stringArray = new String[]{string2};
        } else {
            stringArray = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[stringArray2.length] = string2;
        }
        map.put(string, stringArray);
    }

    public static void parseParameters(Map<String, String[]> map, byte[] byArray, String string) throws UnsupportedEncodingException {
        Charset charset = B2CConverter.getCharset((String)string);
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            int n2 = 0;
            String string2 = null;
            String string3 = null;
            block6: while (n < byArray.length) {
                byte by = byArray[n++];
                switch ((char)by) {
                    case '&': {
                        string3 = new String(byArray, 0, n2, charset);
                        if (string2 != null) {
                            RequestUtil.putMapEntry(map, string2, string3);
                            string2 = null;
                        }
                        n2 = 0;
                        continue block6;
                    }
                    case '=': {
                        if (string2 == null) {
                            string2 = new String(byArray, 0, n2, charset);
                            n2 = 0;
                            continue block6;
                        }
                        byArray[n2++] = by;
                        continue block6;
                    }
                    case '+': {
                        byArray[n2++] = 32;
                        continue block6;
                    }
                    case '%': {
                        byArray[n2++] = (byte)((RequestUtil.convertHexDigit(byArray[n++]) << 4) + RequestUtil.convertHexDigit(byArray[n++]));
                        continue block6;
                    }
                }
                byArray[n2++] = by;
            }
            if (string2 != null) {
                string3 = new String(byArray, 0, n2, charset);
                RequestUtil.putMapEntry(map, string2, string3);
            }
        }
    }
}

