/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.MapFormat;
import org.openide.util.Parameters;

public final class FileBuilder {
    private final CreateDescriptor descriptor;
    Mode defaultMode;
    Format format;

    @NonNull
    public static FileBuilder fromDescriptor(@NonNull CreateDescriptor createDescriptor) {
        Parameters.notNull((CharSequence)"desc", (Object)createDescriptor);
        return new FileBuilder(createDescriptor.getTemplate(), createDescriptor.getTarget()).name(createDescriptor.getProposedName()).useLocale(createDescriptor.getLocale()).withParameters(createDescriptor.getParameters());
    }

    public FileBuilder(@NonNull FileObject fileObject, @NonNull FileObject fileObject2) {
        this.descriptor = new CreateDescriptor(fileObject, fileObject2);
    }

    public FileBuilder useLocale(@NonNull Locale locale) {
        this.descriptor.locale = locale;
        return this;
    }

    public FileBuilder name(String string) {
        this.descriptor.name = string;
        return this;
    }

    public FileBuilder withParameters(@NullAllowed Map<String, ?> map) {
        if (this.descriptor.parameters != null) {
            this.descriptor.parameters.putAll(map);
        } else {
            HashMap hashMap = this.descriptor.parameters = map == null ? null : new HashMap(map);
        }
        if (map != null) {
            boolean bl;
            Object obj = map.get("freeFileExtension");
            if (obj instanceof Boolean) {
                this.descriptor.freeExtension = bl = Boolean.TRUE.equals(obj);
            }
            if ((obj = map.get("org-netbeans-modules-java-preformattedSource")) instanceof Boolean) {
                this.descriptor.preformatted = bl = Boolean.TRUE.equals(obj);
            }
        }
        return this;
    }

    public FileBuilder param(@NonNull String string, Object object) {
        if (this.descriptor.parameters == null) {
            this.descriptor.parameters = new HashMap<String, Object>();
        }
        this.descriptor.parameters.put(string, object);
        if (object instanceof Boolean) {
            boolean bl;
            if ("freeFileExtension".equals(string)) {
                this.descriptor.freeExtension = bl = Boolean.TRUE.equals(object);
            }
            if ("org-netbeans-modules-java-preformattedSource".equals(string)) {
                this.descriptor.preformatted = bl = Boolean.TRUE.equals(object);
            }
        }
        return this;
    }

    public FileBuilder defaultMode(@NonNull Mode mode) {
        this.defaultMode = mode;
        return this;
    }

    public FileBuilder useFormat(@NonNull Format format) {
        this.format = format;
        return this.defaultMode(Mode.FORMAT);
    }

    @CheckForNull
    public List<FileObject> build() throws IOException {
        return CreateFromTemplateImpl.build(this);
    }

    CreateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NonNull
    public CreateDescriptor createDescriptor(boolean bl) {
        if (bl) {
            CreateFromTemplateImpl.collectAttributes(this);
        }
        CreateFromTemplateImpl.computeEffectiveName(this.descriptor);
        return this.descriptor;
    }

    @CheckForNull
    public static FileObject createFromTemplate(@NonNull FileObject fileObject, @NonNull FileObject fileObject2, @NullAllowed String string, @NullAllowed Map<String, ?> map, Mode mode) throws IOException {
        Object object;
        Object object2 = null;
        switch (mode) {
            case FORMAT: {
                object = new MapFormat(new HashMap());
                object.setExactMatch(false);
                object.setLeftBrace("__");
                object.setRightBrace("__");
                object2 = object;
                break;
            }
            case COPY: {
                object2 = new Format(){

                    @Override
                    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                        stringBuffer.append(object);
                        return stringBuffer;
                    }

                    @Override
                    public Object parseObject(String string, ParsePosition parsePosition) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        }
        object = new FileBuilder(fileObject, fileObject2).name(string).withParameters(map).useFormat((Format)object2).defaultMode(mode);
        List<FileObject> list = ((FileBuilder)object).build();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.iterator().next();
    }

    public static enum Mode {
        FORMAT,
        COPY,
        FAIL;

    }
}

