/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.DiffObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class AllocMemoryResultsDiff
extends AllocMemoryResultsSnapshot {
    private final AllocMemoryResultsSnapshot snapshot1;
    private final AllocMemoryResultsSnapshot snapshot2;
    private String[] classNames;
    private int[] objectsCounts;
    private long[] objectsSizePerClass;
    private int nClasses;
    private long maxObjectsSizePerClassDiff;
    private long minObjectsSizePerClassDiff;

    public AllocMemoryResultsDiff(AllocMemoryResultsSnapshot allocMemoryResultsSnapshot, AllocMemoryResultsSnapshot allocMemoryResultsSnapshot2) {
        this.snapshot1 = allocMemoryResultsSnapshot;
        this.snapshot2 = allocMemoryResultsSnapshot2;
        this.computeDiff(allocMemoryResultsSnapshot, allocMemoryResultsSnapshot2);
    }

    @Override
    public long getBeginTime() {
        return -1L;
    }

    @Override
    public String getClassName(int n) {
        return this.classNames[n];
    }

    @Override
    public String[] getClassNames() {
        return this.classNames;
    }

    @Override
    public JMethodIdTable getJMethodIdTable() {
        return null;
    }

    public long getMaxObjectsSizePerClassDiff() {
        return this.maxObjectsSizePerClassDiff;
    }

    public long getMinObjectsSizePerClassDiff() {
        return this.minObjectsSizePerClassDiff;
    }

    @Override
    public int getNProfiledClasses() {
        return this.nClasses;
    }

    @Override
    public int[] getObjectsCounts() {
        return this.objectsCounts;
    }

    @Override
    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    @Override
    public long getTimeTaken() {
        return -1L;
    }

    @Override
    public boolean containsStacks() {
        return this.snapshot1.containsStacks() && this.snapshot2.containsStacks();
    }

    @Override
    public PresoObjAllocCCTNode createPresentationCCT(int n, boolean bl) {
        PresoObjAllocCCTNode presoObjAllocCCTNode = this.snapshot1.createPresentationCCT(this.classId1(n), bl);
        PresoObjAllocCCTNode presoObjAllocCCTNode2 = this.snapshot2.createPresentationCCT(this.classId2(n), bl);
        return new DiffObjAllocCCTNode(presoObjAllocCCTNode, presoObjAllocCCTNode2);
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, boolean bl) {
        PresoObjAllocCCTNode presoObjAllocCCTNode = this.snapshot1.createPresentationCCT(runtimeMemoryCCTNode, this.classId1(n), bl);
        PresoObjAllocCCTNode presoObjAllocCCTNode2 = this.snapshot2.createPresentationCCT(runtimeMemoryCCTNode, this.classId2(n), bl);
        return new DiffObjAllocCCTNode(presoObjAllocCCTNode, presoObjAllocCCTNode2);
    }

    private int classId1(int n) {
        return this.classId(n, this.snapshot1);
    }

    private int classId2(int n) {
        return this.classId(n, this.snapshot2);
    }

    private int classId(int n, AllocMemoryResultsSnapshot allocMemoryResultsSnapshot) {
        if (allocMemoryResultsSnapshot == null) {
            return -1;
        }
        String string = this.getClassName(n);
        String[] stringArray = allocMemoryResultsSnapshot.getClassNames();
        if (stringArray == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void computeDiff(AllocMemoryResultsSnapshot allocMemoryResultsSnapshot, AllocMemoryResultsSnapshot allocMemoryResultsSnapshot2) {
        Object object;
        int n = Math.min(allocMemoryResultsSnapshot.getNProfiledClasses(), allocMemoryResultsSnapshot.getObjectsCounts().length);
        n = Math.min(n, allocMemoryResultsSnapshot.getObjectsSizePerClass().length);
        int n2 = Math.min(allocMemoryResultsSnapshot2.getNProfiledClasses(), allocMemoryResultsSnapshot2.getObjectsCounts().length);
        n2 = Math.min(n2, allocMemoryResultsSnapshot2.getObjectsSizePerClass().length);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        ArrayList<Long> arrayList2 = new ArrayList<Long>(n);
        String[] stringArray = allocMemoryResultsSnapshot.getClassNames();
        int[] nArray = allocMemoryResultsSnapshot.getObjectsCounts();
        long[] lArray = allocMemoryResultsSnapshot.getObjectsSizePerClass();
        for (int i = 0; i < n; ++i) {
            object = (Integer)hashMap.get(stringArray[i]);
            if (object != null) {
                arrayList.set((Integer)object, (Integer)arrayList.get((Integer)object) - nArray[i]);
                arrayList2.set((Integer)object, (Long)arrayList2.get((Integer)object) - lArray[i]);
                continue;
            }
            hashMap.put(stringArray[i], arrayList.size());
            arrayList.add(-nArray[i]);
            arrayList2.add(-lArray[i]);
        }
        String[] stringArray2 = allocMemoryResultsSnapshot2.getClassNames();
        object = allocMemoryResultsSnapshot2.getObjectsCounts();
        long[] lArray2 = allocMemoryResultsSnapshot2.getObjectsSizePerClass();
        for (int i = 0; i < n2; ++i) {
            Integer n3 = (Integer)hashMap.get(stringArray2[i]);
            if (n3 != null) {
                arrayList.set(n3, (Integer)arrayList.get(n3) + object[i]);
                arrayList2.set(n3, (Long)arrayList2.get(n3) + lArray2[i]);
                continue;
            }
            hashMap.put(stringArray2[i], arrayList.size());
            arrayList.add((int)object[i]);
            arrayList2.add(lArray2[i]);
        }
        this.nClasses = hashMap.size();
        this.classNames = new String[this.nClasses];
        this.objectsCounts = new int[this.nClasses];
        this.objectsSizePerClass = new long[this.nClasses];
        this.minObjectsSizePerClassDiff = Long.MAX_VALUE;
        this.maxObjectsSizePerClassDiff = Long.MIN_VALUE;
        Iterator iterator = hashMap.entrySet().iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n5 = (Integer)entry.getValue();
            this.classNames[n4] = (String)entry.getKey();
            this.objectsCounts[n4] = (Integer)arrayList.get(n5);
            this.objectsSizePerClass[n4] = (Long)arrayList2.get(n5);
            this.minObjectsSizePerClassDiff = Math.min(this.minObjectsSizePerClassDiff, this.objectsSizePerClass[n4]);
            this.maxObjectsSizePerClassDiff = Math.max(this.maxObjectsSizePerClassDiff, this.objectsSizePerClass[n4]);
            ++n4;
        }
        if (this.minObjectsSizePerClassDiff > 0L && this.maxObjectsSizePerClassDiff > 0L) {
            this.minObjectsSizePerClassDiff = 0L;
        } else if (this.minObjectsSizePerClassDiff < 0L && this.maxObjectsSizePerClassDiff < 0L) {
            this.maxObjectsSizePerClassDiff = 0L;
        }
    }
}

