/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.selection;

import java.io.Serializable;
import java.security.Permission;
import javax.tv.locator.Locator;

public final class SelectPermission
extends Permission
implements Serializable {
    private String actions;
    private String locator;
    private static final long serialVersionUID = 3418810478648506665L;

    public SelectPermission(Locator locator, String actions) {
        super(locator == null ? "*" : locator.toExternalForm());
        if (actions == null) {
            throw new NullPointerException();
        }
        this.locator = locator == null ? "*" : locator.toExternalForm();
        this.actions = actions;
    }

    public SelectPermission(String locator, String actions) {
        super(locator == null ? "*" : locator);
        if (actions == null) {
            throw new NullPointerException();
        }
        this.locator = locator == null ? "*" : locator;
        this.actions = actions;
    }

    @Override
    public boolean implies(Permission perm) {
        if (!(perm instanceof SelectPermission)) {
            return false;
        }
        SelectPermission sperm = (SelectPermission)perm;
        if (!sperm.actions.equals(this.actions) && !this.actions.equals("*")) {
            return false;
        }
        return sperm.locator.equals(this.locator) || this.locator.equals("*");
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SelectPermission)) {
            return false;
        }
        SelectPermission other = (SelectPermission)obj;
        if (!this.actions.equals(other.actions)) {
            return false;
        }
        return this.locator.equals(other.locator);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.locator == null ? 0 : this.locator.hashCode());
        return result;
    }

    @Override
    public String getActions() {
        return this.actions;
    }
}

