/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.juife.wizard.UserInputPage;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.OrchestraInstrument;
import org.jsampler.OrchestraModel;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.MidiInstrumentInfo;

class OrchestraSelectWizardPage
extends UserInputPage {
    private final JLabel lOrchestras = new JLabel(StdI18n.i18n.getLabel("OrchestraSelectWizardPage.lOrchestras"));
    private final JLabel lInstruments = new JLabel(StdI18n.i18n.getLabel("OrchestraSelectWizardPage.lInstruments"));
    private final JLabel lLoadMode = new JLabel(StdI18n.i18n.getLabel("OrchestraSelectWizardPage.lLoadMode"));
    private final JComboBox cbOrchestras = new JComboBox();
    private final JComboBox cbInstruments = new JComboBox();
    private final JComboBox cbLoadMode = new JComboBox();

    OrchestraSelectWizardPage() {
        super(StdI18n.i18n.getLabel("OrchestraSelectWizardPage.subtitle"));
        int n;
        this.setMainInstructions(StdI18n.i18n.getLabel("OrchestraSelectWizardPage.mainInstructions"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 6, 16);
        gridBagLayout.setConstraints(this.lOrchestras, gridBagConstraints);
        jPanel.add(this.lOrchestras);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lInstruments, gridBagConstraints);
        jPanel.add(this.lInstruments);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 0, 6, 16);
        gridBagLayout.setConstraints(this.lLoadMode, gridBagConstraints);
        jPanel.add(this.lLoadMode);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 48);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.cbOrchestras, gridBagConstraints);
        jPanel.add(this.cbOrchestras);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.cbInstruments, gridBagConstraints);
        jPanel.add(this.cbInstruments);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 0, 6, 48);
        gridBagLayout.setConstraints(this.cbLoadMode, gridBagConstraints);
        jPanel.add(this.cbLoadMode);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.setMainPane(jPanel);
        int n2 = this.preferences().getIntProperty("OrchestraSelectWizardPage.OrchestraIndex", 0);
        this.cbOrchestras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrchestraSelectWizardPage.this.orchestraChanged();
            }
        });
        for (n = 0; n < CC.getOrchestras().getOrchestraCount(); ++n) {
            this.cbOrchestras.addItem(CC.getOrchestras().getOrchestra(n));
        }
        if (CC.getOrchestras().getOrchestraCount() > n2) {
            this.cbOrchestras.setSelectedIndex(n2);
        }
        this.cbInstruments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrchestraSelectWizardPage.this.instrumentChanged();
            }
        });
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.DEFAULT);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND_HOLD);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.PERSISTENT);
        n = this.preferences().getIntProperty("std.midiInstrument.loadMode", 0);
        if (this.cbLoadMode.getItemCount() > n) {
            this.cbLoadMode.setSelectedIndex(n);
        }
        this.cbLoadMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = OrchestraSelectWizardPage.this.cbLoadMode.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                OrchestraSelectWizardPage.this.preferences().setIntProperty("std.midiInstrument.loadMode", n);
            }
        });
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void orchestraChanged() {
        String string;
        OrchestraModel orchestraModel = (OrchestraModel)this.cbOrchestras.getSelectedItem();
        String string2 = string = orchestraModel == null ? null : orchestraModel.getDescription();
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.cbOrchestras.setToolTipText(string);
        string = "OrchestraSelectWizardPage.OrchestraIndex";
        int n = this.cbOrchestras.getSelectedIndex();
        if (n >= 0) {
            this.preferences().setIntProperty(string, n);
        }
        this.cbInstruments.removeAllItems();
        if (orchestraModel == null || orchestraModel.getInstrumentCount() == 0) {
            this.cbInstruments.setEnabled(false);
            return;
        }
        this.cbInstruments.setEnabled(true);
        for (int i = 0; i < orchestraModel.getInstrumentCount(); ++i) {
            this.cbInstruments.addItem(orchestraModel.getInstrument(i));
        }
    }

    private void instrumentChanged() {
        String string;
        OrchestraInstrument orchestraInstrument = (OrchestraInstrument)this.cbInstruments.getSelectedItem();
        String string2 = string = orchestraInstrument == null ? null : orchestraInstrument.getDescription();
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.cbInstruments.setToolTipText(string);
        this.getWizard().enableNextButton(orchestraInstrument != null);
    }

    @Override
    public void postinitPage() {
        this.getWizard().enableNextButton(this.cbInstruments.getSelectedItem() != null);
    }

    public OrchestraInstrument getInstrument() {
        return (OrchestraInstrument)this.cbInstruments.getSelectedItem();
    }

    public MidiInstrumentInfo.LoadMode getLoadMode() {
        return (MidiInstrumentInfo.LoadMode)((Object)this.cbLoadMode.getSelectedItem());
    }
}

