# _ErrorPrinter
<span class="source-link">[[Source]](src/options/options.md#L352)</span>
```pony
class ref _ErrorPrinter
```

## Constructors

### _ambiguous
<span class="source-link">[[Source]](src/options/options.md#L356)</span>


```pony
new ref _ambiguous(
  matches: Array[_Option ref] ref)
: _ErrorPrinter ref^
```
#### Parameters

*   matches: [Array](builtin-Array.md)\[[_Option](options-_Option.md) ref\] ref

#### Returns

* [_ErrorPrinter](options-_ErrorPrinter.md) ref^

---

### _unrecognised
<span class="source-link">[[Source]](src/options/options.md#L369)</span>


```pony
new ref _unrecognised(
  option: String box)
: _ErrorPrinter ref^
```
#### Parameters

*   option: [String](builtin-String.md) box

#### Returns

* [_ErrorPrinter](options-_ErrorPrinter.md) ref^

---

### _invalid
<span class="source-link">[[Source]](src/options/options.md#L373)</span>


```pony
new ref _invalid(
  argument: String box,
  option: _Option ref)
: _ErrorPrinter ref^
```
#### Parameters

*   argument: [String](builtin-String.md) box
*   option: [_Option](options-_Option.md) ref

#### Returns

* [_ErrorPrinter](options-_ErrorPrinter.md) ref^

---

### _missing
<span class="source-link">[[Source]](src/options/options.md#L377)</span>


```pony
new ref _missing(
  option: _Option ref)
: _ErrorPrinter ref^
```
#### Parameters

*   option: [_Option](options-_Option.md) ref

#### Returns

* [_ErrorPrinter](options-_ErrorPrinter.md) ref^

---

## Public Functions

### reason
<span class="source-link">[[Source]](src/options/options.md#L381)</span>


```pony
fun box reason()
: (UnrecognisedOption val | MissingArgument val | InvalidArgument val | 
    AmbiguousMatch val)
```

#### Returns

* ([UnrecognisedOption](options-UnrecognisedOption.md) val | [MissingArgument](options-MissingArgument.md) val | [InvalidArgument](options-InvalidArgument.md) val | 
    [AmbiguousMatch](options-AmbiguousMatch.md) val)

---

### report
<span class="source-link">[[Source]](src/options/options.md#L384)</span>


```pony
fun box report(
  out: OutStream tag)
: None val
```
#### Parameters

*   out: [OutStream](builtin-OutStream.md) tag

#### Returns

* [None](builtin-None.md) val

---

