S2 = Manifold(2, 'S^2', structure='topological')
U = S2.open_subset('U') ; V = S2.open_subset('V')
S2.declare_union(U,V)
c_xy = U.chart('x y'); x, y = c_xy[:]
c_uv = V.chart('u v'); u, v = c_uv[:]
xy_to_uv = c_xy.transition_map(c_uv, (x/(x**2+y**2), y/(x**2+y**2)),
                 intersection_name='W', restrictions1= x**2+y**2!=0,
                 restrictions2= u**2+v**2!=0)
uv_to_xy = xy_to_uv.inverse()
R3 = Manifold(3, 'R^3', structure='topological')
c_cart = R3.chart('X Y Z')
Phi = S2.continuous_map(R3, {(c_xy, c_cart): [2*x/(1+x**2+y**2),
                  2*y/(1+x**2+y**2), (x**2+y**2-1)/(1+x**2+y**2)],
                  (c_uv, c_cart): [2*u/(1+u**2+v**2),
                  2*v/(1+u**2+v**2), (1-u**2-v**2)/(1+u**2+v**2)]},
                  name='Phi', latex_name=r'\Phi')
sphinx_plot(c_xy.plot(c_cart, mapping=Phi))