M = Manifold(2, 'M', structure='Riemannian')
X = M.chart('x y'); x, y = X[:]
g = M.metric()
g[0,0], g[1,1] = 1/y**2, 1/y**2
p = M((0,1), name='p')
v = M.tangent_space(p)((1,3/2), name='v')
t = var('t')
c = M.integrated_geodesic(g, (t, 0, 10), v, name='c')
sol = c.solve()
interp = c.interpolate()
graph = c.plot_integrated()
p_plot = p.plot(size=30, label_offset=-0.07, fontsize=20)
v_plot = v.plot(label_offset=0.05, fontsize=20)
sphinx_plot(graph + p_plot + v_plot)