M = Manifold(3, 'M', structure="topological")
N = Manifold(2, 'N', ambient = M, structure="topological")
CM = M.chart('x y z'); x, y, z = CM[:]
CN = N.chart('u v'); u, v = CN[:]
t = var('t')
phi = N.continuous_map(M, {(CN,CM): [u,v,t+u**2+v**2]})
phi_inv = M.continuous_map(N, {(CM,CN): [x,y]})
phi_inv_t = M.scalar_field({CM: z-x**2-y**2})
N.set_embedding(phi, inverse=phi_inv, var=t,
                t_inverse = {t:phi_inv_t})
N.adapted_chart()
P0 = N.plot({t:0}, srange(-1, 1, 0.1), srange(-1, 1, 0.1),
            CN, CM, opacity=0.3, mesh=True)
P1 = N.plot({t:1}, srange(-1, 1, 0.1), srange(-1, 1, 0.1),
            CN, CM, opacity=0.3, mesh=True)
P2 = N.plot({t:2}, srange(-1, 1, 0.1), srange(-1, 1, 0.1),
            CN, CM, opacity=0.3, mesh=True)
P3 = N.plot({t:3}, srange(-1, 1, 0.1), srange(-1, 1, 0.1),
            CN, CM, opacity=0.3, mesh=True)
sphinx_plot(P0 + P1 + P2 + P3)