/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.mahout.math.matrix.impl;

import org.carrot2.mahout.math.matrix.DoubleMatrix1D;
import org.carrot2.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.WrapperDoubleMatrix1D;

class DelegateDoubleMatrix1D
extends WrapperDoubleMatrix1D {
    private final DoubleMatrix2D content;
    private final int row;

    DelegateDoubleMatrix1D(DoubleMatrix2D newContent, int row) {
        super(null);
        if (row < 0 || row >= newContent.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(newContent.columns());
        this.row = row;
        this.content = newContent;
    }

    @Override
    public double getQuick(int index) {
        return this.content.getQuick(this.row, index);
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return this.content.like1D(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public void setQuick(int index, double value) {
        this.content.setQuick(this.row, index, value);
    }
}

