/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.handler.dataimport.ConfigParseUtil;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.config.Entity;
import org.w3c.dom.Element;

public class Field {
    private final String column;
    private final String name;
    private final float boost;
    private final boolean toWrite;
    private final boolean multiValued;
    private final boolean dynamicName;
    private final Entity entity;
    private final Map<String, String> allAttributes;

    public Field(Builder b) {
        this.column = b.column;
        this.name = b.name;
        this.boost = b.boost;
        this.toWrite = b.toWrite;
        this.multiValued = b.multiValued;
        this.dynamicName = b.dynamicName;
        this.entity = b.entity;
        this.allAttributes = Collections.unmodifiableMap(new HashMap<String, String>(b.allAttributes));
    }

    public String getName() {
        return this.name == null ? this.column : this.name;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getColumn() {
        return this.column;
    }

    public float getBoost() {
        return this.boost;
    }

    public boolean isToWrite() {
        return this.toWrite;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public boolean isDynamicName() {
        return this.dynamicName;
    }

    public Map<String, String> getAllAttributes() {
        return this.allAttributes;
    }

    public static class Builder {
        public String column;
        public String name;
        public float boost;
        public boolean toWrite = true;
        public boolean multiValued = false;
        public boolean dynamicName;
        public Entity entity;
        public Map<String, String> allAttributes = new HashMap<String, String>();

        public Builder(Element e) {
            this.name = ConfigParseUtil.getStringAttribute(e, "name", null);
            this.column = ConfigParseUtil.getStringAttribute(e, "column", null);
            if (this.column == null) {
                throw new DataImportHandlerException(500, "Field must have a column attribute");
            }
            this.boost = Float.parseFloat(ConfigParseUtil.getStringAttribute(e, "boost", "1.0f"));
            this.allAttributes = new HashMap<String, String>(ConfigParseUtil.getAllAttributes(e));
        }

        public String getNameOrColumn() {
            return this.name == null ? this.column : this.name;
        }
    }
}

