/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.RoutedAliasTypes;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.api.collections.CategoryRoutedAlias;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.update.AddUpdateCommand;

public class DimensionalRoutedAlias
extends RoutedAlias {
    private final String name;
    private List<RoutedAlias> dimensions;
    private Set<String> reqParams = new HashSet<String>();
    private Set<String> optParams = new HashSet<String>();
    private Map<String, String> aliasMetadata;
    private static final Pattern SEP_MATCHER = Pattern.compile("(" + Arrays.stream(RoutedAliasTypes.values()).filter(v -> v != RoutedAliasTypes.DIMENSIONAL).map(RoutedAliasTypes::getSeparatorPrefix).collect(Collectors.joining("|")) + ")");

    DimensionalRoutedAlias(List<RoutedAlias> dimensions, String name, Map<String, String> props) {
        this.dimensions = dimensions;
        this.name = name;
        this.aliasMetadata = props;
    }

    static RoutedAlias dimensionForType(Map<String, String> props, RoutedAliasTypes type, int index, Deffered<DimensionalRoutedAlias> dra) {
        switch (type) {
            case TIME: {
                return new TimeRoutedAliasDimension(props, index, dra);
            }
            case CATEGORY: {
                return new CategoryRoutedAliasDimension(props, index, dra);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Router " + type + " is not fully implemented. If you see thiserror in an official release please file a bug report. Available types were:" + Arrays.asList(RoutedAliasTypes.values()));
    }

    @Override
    public boolean updateParsedCollectionAliases(ZkStateReader zkStateReader, boolean contextualize) {
        boolean result = false;
        for (RoutedAlias dimension : this.dimensions) {
            result |= dimension.updateParsedCollectionAliases(zkStateReader, contextualize);
        }
        return result;
    }

    @Override
    public String computeInitialCollectionName() {
        StringBuilder sb = new StringBuilder(this.getAliasName());
        for (RoutedAlias dimension : this.dimensions) {
            String routeString = dimension.computeInitialCollectionName().replaceAll(dimension.getAliasName(), "");
            sb.append(routeString);
        }
        return sb.toString();
    }

    @Override
    String[] formattedRouteValues(SolrInputDocument doc) {
        String[] result = new String[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            RoutedAlias dimension = this.dimensions.get(i);
            result[i] = dimension.formattedRouteValues(doc)[0];
        }
        return result;
    }

    @Override
    public String getAliasName() {
        return this.name;
    }

    @Override
    public String getRouteField() {
        throw new UnsupportedOperationException("DRA's route via their dimensions, this method should not be called");
    }

    @Override
    public RoutedAliasTypes getRoutedAliasType() {
        return RoutedAliasTypes.DIMENSIONAL;
    }

    @Override
    public void validateRouteValue(AddUpdateCommand cmd) throws SolrException {
        for (RoutedAlias dimension : this.dimensions) {
            dimension.validateRouteValue(cmd);
        }
    }

    @Override
    public Map<String, String> getAliasMetadata() {
        return this.aliasMetadata;
    }

    @Override
    public Set<String> getRequiredParams() {
        if (this.reqParams.size() == 0) {
            DimensionalRoutedAlias.indexParams(this.reqParams, this.dimensions, RoutedAlias::getRequiredParams);
            this.reqParams.add("router.name");
            this.reqParams.add("router.field");
        }
        return this.reqParams;
    }

    @Override
    public Set<String> getOptionalParams() {
        if (this.optParams.size() == 0) {
            DimensionalRoutedAlias.indexParams(this.optParams, this.dimensions, RoutedAlias::getOptionalParams);
        }
        return this.optParams;
    }

    @Override
    public RoutedAlias.CandidateCollection findCandidateGivenValue(AddUpdateCommand cmd) {
        this.contextualizeDimensions(this.formattedRouteValues(cmd.solrDoc));
        ArrayList<RoutedAlias.CandidateCollection> subPartCandidates = new ArrayList<RoutedAlias.CandidateCollection>();
        for (RoutedAlias dimension : this.dimensions) {
            subPartCandidates.add(dimension.findCandidateGivenValue(cmd));
        }
        StringBuilder col2Create = new StringBuilder(this.getAliasName());
        StringBuilder destCol = new StringBuilder(this.getAliasName());
        RoutedAlias.CreationType max = RoutedAlias.CreationType.NONE;
        for (RoutedAlias.CandidateCollection subCol : subPartCandidates) {
            col2Create.append(subCol.getCreationCollection());
            destCol.append(subCol.getDestinationCollection());
            if (subCol.getCreationType().ordinal() <= max.ordinal()) continue;
            max = subCol.getCreationType();
        }
        return new RoutedAlias.CandidateCollection(this, max, destCol.toString(), col2Create.toString());
    }

    @Override
    protected String getHeadCollectionIfOrdered(AddUpdateCommand cmd) {
        StringBuilder head = new StringBuilder(this.getAliasName());
        for (RoutedAlias dimension : this.dimensions) {
            head.append(dimension.getHeadCollectionIfOrdered(cmd).substring(this.getAliasName().length()));
        }
        return head.toString();
    }

    @Override
    protected List<RoutedAlias.Action> calculateActions(String targetCol) {
        String[] routeValues = SEP_MATCHER.split(targetCol);
        routeValues = Arrays.copyOfRange(routeValues, 1, routeValues.length);
        ArrayList<List<RoutedAlias.Action>> dimActs = new ArrayList<List<RoutedAlias.Action>>(routeValues.length);
        this.contextualizeDimensions(routeValues);
        for (int i = 0; i < routeValues.length; ++i) {
            String routeValue = routeValues[i];
            RoutedAlias dim = this.dimensions.get(i);
            dimActs.add(dim.calculateActions(dim.getAliasName() + DimensionalRoutedAlias.getSeparatorPrefix(dim) + routeValue));
        }
        LinkedHashSet<RoutedAlias.Action> result = new LinkedHashSet<RoutedAlias.Action>();
        StringBuilder currentSuffix = new StringBuilder();
        for (int i = routeValues.length - 1; i >= 0; --i) {
            String routeValue = routeValues[i];
            RoutedAlias dim = this.dimensions.get(i);
            String dimStr = dim.getRoutedAliasType().getSeparatorPrefix() + routeValue;
            List actions = (List)dimActs.get(i);
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                RoutedAlias.Action action = (RoutedAlias.Action)iterator.next();
                iterator.remove();
                result.add(new RoutedAlias.Action(action.sourceAlias, action.actionType, action.targetCollection + currentSuffix));
            }
            result.addAll(actions);
            LinkedHashSet<RoutedAlias.Action> revisedResult = new LinkedHashSet<RoutedAlias.Action>();
            for (RoutedAlias.Action action : result) {
                if (action.sourceAlias == dim) {
                    revisedResult.add(action);
                    continue;
                }
                revisedResult.add(new RoutedAlias.Action(action.sourceAlias, action.actionType, dimStr + action.targetCollection));
            }
            result = revisedResult;
            currentSuffix.append(dimStr);
        }
        LinkedHashSet<RoutedAlias.Action> revisedResult = new LinkedHashSet<RoutedAlias.Action>();
        for (RoutedAlias.Action action : result) {
            revisedResult.add(new RoutedAlias.Action(action.sourceAlias, action.actionType, this.getAliasName() + action.targetCollection));
        }
        return new ArrayList<RoutedAlias.Action>(revisedResult);
    }

    private void contextualizeDimensions(String[] routeValues) {
        for (RoutedAlias dimension : this.dimensions) {
            ((DraContextualized)((Object)dimension)).setContext(routeValues);
        }
    }

    private static String getSeparatorPrefix(RoutedAlias dim) {
        return dim.getRoutedAliasType().getSeparatorPrefix();
    }

    private static void indexParams(Set<String> result, List<RoutedAlias> dimensions, Function<RoutedAlias, Set<String>> supplier) {
        for (int i = 0; i < dimensions.size(); ++i) {
            RoutedAlias dimension = dimensions.get(i);
            Set<String> params = supplier.apply(dimension);
            for (String param : params) {
                CollectionAdminRequest.DimensionalRoutedAlias.addDimensionIndexIfRequired(result, (int)i, (String)param);
            }
        }
    }

    private static class TimeRoutedAliasDimension
    extends TimeRoutedAlias
    implements DraContextualized {
        private final int index;
        private final Deffered<DimensionalRoutedAlias> dra;
        private String[] context;

        TimeRoutedAliasDimension(Map<String, String> props, int index, Deffered<DimensionalRoutedAlias> dra) throws SolrException {
            super("", props);
            this.index = index;
            this.dra = dra;
        }

        @Override
        List<String> getCollectionList(Aliases aliases) {
            return DraContextualized.dimensionCollectionListView(this.index, aliases, this.dra, this.context, true);
        }

        @Override
        public void setContext(String[] context) {
            this.context = context;
        }
    }

    static interface Deffered<T> {
        public T get();
    }

    private static class CategoryRoutedAliasDimension
    extends CategoryRoutedAlias
    implements DraContextualized {
        private final int index;
        private final Deffered<DimensionalRoutedAlias> dra;
        private String[] context;

        CategoryRoutedAliasDimension(Map<String, String> props, int index, Deffered<DimensionalRoutedAlias> dra) {
            super("", props);
            this.index = index;
            this.dra = dra;
        }

        @Override
        List<String> getCollectionList(Aliases aliases) {
            return DraContextualized.dimensionCollectionListView(this.index, aliases, this.dra, this.context, false);
        }

        @Override
        public void setContext(String[] context) {
            this.context = context;
        }
    }

    private static interface DraContextualized {
        public static List<String> dimensionCollectionListView(int index, Aliases aliases, Deffered<DimensionalRoutedAlias> dra, String[] context, boolean ordered) {
            List cols = (List)aliases.getCollectionAliasListMap().get(dra.get().name);
            LinkedHashSet<String> view = new LinkedHashSet<String>(cols.size());
            List dimensions = dra.get().dimensions;
            for (String col : cols) {
                boolean matchesAllLowerDims;
                Matcher m = SEP_MATCHER.matcher(col);
                if (!m.find()) {
                    throw new IllegalStateException("Invalid Dimensional Routed Alias name:" + col);
                }
                String[] split = SEP_MATCHER.split(col);
                if (split.length != dimensions.size() + 1) {
                    throw new IllegalStateException("Dimension Routed Alias collection with wrong number of dimensions. (" + col + ") expecting " + dimensions.stream().map(d -> d.getRoutedAliasType().toString()).collect(Collectors.toList()));
                }
                boolean matchesAllHigherDims = index == 0;
                boolean bl = matchesAllLowerDims = context == null || index == context.length - 1;
                if (context != null) {
                    for (int i = 0; i < context.length; ++i) {
                        if (i == index) continue;
                        String s = split[i + 1];
                        String ctx = context[i];
                        if (i <= index) {
                            matchesAllHigherDims |= s.equals(ctx);
                            continue;
                        }
                        matchesAllLowerDims |= s.equals(ctx);
                    }
                } else {
                    matchesAllHigherDims = true;
                    matchesAllLowerDims = true;
                }
                if ((!matchesAllHigherDims || ordered) && (!matchesAllHigherDims || !matchesAllLowerDims)) continue;
                view.add("" + DimensionalRoutedAlias.getSeparatorPrefix((RoutedAlias)dimensions.get(index)) + split[index + 1]);
            }
            return new ArrayList<String>(view);
        }

        public void setContext(String[] var1);
    }
}

