/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Iterators;
import com.google.common.collect.MapMaker;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.RecoveryStrategy;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.MemClassLoader;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrDeletionPolicy;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrPaths;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.StandardIndexReaderFactory;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.pkg.PackageLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.CSVResponseWriter;
import org.apache.solr.response.GeoJSONResponseWriter;
import org.apache.solr.response.GraphMLResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.PHPResponseWriter;
import org.apache.solr.response.PHPSerializedResponseWriter;
import org.apache.solr.response.PythonResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.RubyResponseWriter;
import org.apache.solr.response.SchemaXmlResponseWriter;
import org.apache.solr.response.SmileResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XMLResponseWriter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.rest.ManagedResourceStorage;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrFieldCacheBean;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.stats.LocalStatsCache;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.update.DefaultSolrCoreState;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.NestedUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.IOFunction;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.PropertiesInputStream;
import org.apache.solr.util.PropertiesOutputStream;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.circuitbreaker.CircuitBreakerManager;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SolrCore
implements SolrInfoBean,
SolrMetricProducer,
Closeable {
    public static final String version = "1.0";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Logger requestLog = LoggerFactory.getLogger((String)(MethodHandles.lookup().lookupClass().getName() + ".Request"));
    private static final Logger slowLog = LoggerFactory.getLogger((String)(MethodHandles.lookup().lookupClass().getName() + ".SlowRequest"));
    private String name;
    private String logid;
    public final UUID uniqueId = UUID.randomUUID();
    private boolean isReloaded = false;
    private final CoreDescriptor coreDescriptor;
    private final CoreContainer coreContainer;
    private final SolrConfig solrConfig;
    private final SolrResourceLoader resourceLoader;
    private volatile IndexSchema schema;
    private final NamedList configSetProperties;
    private final String dataDir;
    private final String ulogDir;
    private final UpdateHandler updateHandler;
    private final SolrCoreState solrCoreState;
    private final Date startTime = new Date();
    private final long startNanoTime = System.nanoTime();
    private final RequestHandlers reqHandlers;
    private final PluginBag<SearchComponent> searchComponents = new PluginBag<SearchComponent>(SearchComponent.class, this);
    private final PluginBag<UpdateRequestProcessorFactory> updateProcessors = new PluginBag<UpdateRequestProcessorFactory>(UpdateRequestProcessorFactory.class, this, true);
    private final Map<String, UpdateRequestProcessorChain> updateProcessorChains;
    private final SolrCoreMetricManager coreMetricManager;
    private final Map<String, SolrInfoBean> infoRegistry = new ConcurrentHashMap<String, SolrInfoBean>();
    private final IndexDeletionPolicyWrapper solrDelPolicy;
    private final SolrSnapshotMetaDataManager snapshotMgr;
    private final DirectoryFactory directoryFactory;
    private final RecoveryStrategy.Builder recoveryStrategyBuilder;
    private IndexReaderFactory indexReaderFactory;
    private final Codec codec;
    private final ConfigSet configSet;
    private final MemClassLoader memClassLoader;
    private final CircuitBreakerManager circuitBreakerManager;
    private final List<Runnable> confListeners = new CopyOnWriteArrayList<Runnable>();
    private final ReentrantLock ruleExpiryLock;
    private final ReentrantLock snapshotDelLock;
    private Timer newSearcherTimer;
    private Timer newSearcherWarmupTimer;
    private Counter newSearcherCounter;
    private Counter newSearcherMaxReachedCounter;
    private Counter newSearcherOtherErrorsCounter;
    private final String metricTag = SolrMetricProducer.getUniqueMetricTag(this, null);
    private final SolrMetricsContext solrMetricsContext;
    public volatile boolean searchEnabled = true;
    public volatile boolean indexEnabled = true;
    public volatile boolean readOnly = false;
    private PackageListeners packageListeners = new PackageListeners(this);
    private final Map<IndexReader.CacheKey, IndexFingerprint> perSegmentFingerprintCache = new MapMaker().weakKeys().makeMap();
    private final RestManager restManager;
    static int boolean_query_max_clause_count = Integer.MIN_VALUE;
    private ExecutorService coreAsyncTaskExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((String)"Core Async Task");
    private String lastNewIndexDir;
    final List<SolrEventListener> firstSearcherListeners = new ArrayList<SolrEventListener>();
    final List<SolrEventListener> newSearcherListeners = new ArrayList<SolrEventListener>();
    private static Set<String> dirs = new HashSet<String>();
    private final AtomicInteger refCount = new AtomicInteger(1);
    private Collection<CloseHook> closeHooks = null;
    public static boolean VERBOSE = Boolean.parseBoolean(System.getProperty("tests.verbose", "false"));
    private RefCounted<SolrIndexSearcher> _searcher;
    private final LinkedList<RefCounted<SolrIndexSearcher>> _searchers = new LinkedList();
    private final LinkedList<RefCounted<SolrIndexSearcher>> _realtimeSearchers = new LinkedList();
    final ExecutorService searcherExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new SolrNamedThreadFactory("searcherExecutor"));
    private int onDeckSearchers;
    private Object searcherLock = new Object();
    private ReentrantLock openSearcherLock = new ReentrantLock(true);
    private final int maxWarmingSearchers;
    private final int slowQueryThresholdMillis;
    private RefCounted<SolrIndexSearcher> realtimeSearcher;
    private Callable<DirectoryReader> newReaderCreator;
    private final PluginBag<QueryResponseWriter> responseWriters = new PluginBag<QueryResponseWriter>(QueryResponseWriter.class, this);
    public static final Map<String, QueryResponseWriter> DEFAULT_RESPONSE_WRITERS;
    private final PluginBag<QParserPlugin> qParserPlugins = new PluginBag<QParserPlugin>(QParserPlugin.class, this);
    private final PluginBag<ValueSourceParser> valueSourceParsers = new PluginBag<ValueSourceParser>(ValueSourceParser.class, this);
    private final PluginBag<TransformerFactory> transformerFactories = new PluginBag<TransformerFactory>(TransformerFactory.class, this);
    private static final Map implicitPluginsInfo;

    public Date getStartTimeStamp() {
        return this.startTime;
    }

    public long getStartNanoTime() {
        return this.startNanoTime;
    }

    public long getUptimeMs() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.startNanoTime, TimeUnit.NANOSECONDS);
    }

    public RestManager getRestManager() {
        return this.restManager;
    }

    public PackageListeners getPackageListeners() {
        return this.packageListeners;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public SolrResourceLoader getResourceLoader(String pkg) {
        if (pkg == null) {
            return this.resourceLoader;
        }
        PackageLoader.Package aPackage = this.coreContainer.getPackageLoader().getPackage(pkg);
        PackageLoader.Package.Version latest = aPackage.getLatest();
        return latest.getLoader();
    }

    public String getConfigResource() {
        return this.solrConfig.getResourceName();
    }

    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public String getSchemaResource() {
        return this.getLatestSchema().getResourceName();
    }

    public IndexSchema getLatestSchema() {
        return this.schema;
    }

    public Path getInstancePath() {
        return this.getCoreDescriptor().getInstanceDir();
    }

    public void setLatestSchema(IndexSchema replacementSchema) {
        SimilarityFactory similarityFactory = replacementSchema.getSimilarityFactory();
        if (similarityFactory instanceof SolrCoreAware) {
            ((SolrCoreAware)((Object)similarityFactory)).inform(this);
        }
        this.schema = replacementSchema;
    }

    public NamedList getConfigSetProperties() {
        return this.configSetProperties;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getUlogDir() {
        return this.ulogDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIndexDir() {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher == null) {
                return this.getNewIndexDir();
            }
            SolrIndexSearcher searcher = this._searcher.get();
            String string = searcher.getPath() == null ? this.dataDir + "index/" : searcher.getPath();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNewIndexDir() {
        String string;
        Directory dir = null;
        try {
            dir = this.getDirectoryFactory().get(this.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.getSolrConfig().indexConfig.lockType);
            String result = this.getIndexPropertyFromPropFile(dir);
            if (!result.equals(this.lastNewIndexDir)) {
                log.debug("New index directory detected: old={} new={}", (Object)this.lastNewIndexDir, (Object)result);
            }
            this.lastNewIndexDir = result;
            string = result;
            if (dir == null) return string;
        }
        catch (IOException e) {
            try {
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in getNewIndexDir, exception: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (dir == null) throw throwable;
                try {
                    this.getDirectoryFactory().release(dir);
                    throw throwable;
                }
                catch (IOException e2) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.getDirectoryFactory().release(dir);
            return string;
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)"", (Throwable)e);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIndexPropertyFromPropFile(Directory dir) throws IOException {
        IndexInput input;
        try {
            input = dir.openInput("index.properties", IOContext.DEFAULT);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return this.dataDir + "index/";
        }
        PropertiesInputStream is = new PropertiesInputStream(input);
        try {
            Properties p = new Properties();
            p.load(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            String s = p.getProperty("index");
            if (s != null && s.trim().length() > 0) {
                String string = this.dataDir + s.trim();
                return string;
            }
            String string = this.dataDir + "index/";
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
    }

    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    public IndexReaderFactory getIndexReaderFactory() {
        return this.indexReaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIndexSize() {
        long size;
        block5: {
            size = 0L;
            try {
                if (!this.directoryFactory.exists(this.getIndexDir())) break block5;
                Directory dir = this.directoryFactory.get(this.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrConfig.indexConfig.lockType);
                try {
                    size = DirectoryFactory.sizeOfDirectory(dir);
                }
                finally {
                    this.directoryFactory.release(dir);
                }
            }
            catch (IOException e) {
                SolrException.log((Logger)log, (String)"IO error while trying to get the size of the Directory", (Throwable)e);
            }
        }
        return size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        boolean renamed;
        Objects.requireNonNull(v);
        boolean bl = renamed = this.name != null && !this.name.equals(v);
        assert (!renamed || this.coreDescriptor.getCloudDescriptor() == null) : "Cores are not renamed in SolrCloud";
        this.name = v;
        this.logid = "[" + v + "] ";
        if (renamed && this.coreMetricManager != null) {
            this.coreMetricManager.afterCoreRename();
        }
    }

    public String getLogId() {
        return this.logid;
    }

    public SolrCoreMetricManager getCoreMetricManager() {
        return this.coreMetricManager;
    }

    public Map<String, SolrInfoBean> getInfoRegistry() {
        return this.infoRegistry;
    }

    private IndexDeletionPolicyWrapper initDeletionPolicy(IndexDeletionPolicyWrapper delPolicyWrapper) {
        SolrDeletionPolicy delPolicy;
        if (delPolicyWrapper != null) {
            return delPolicyWrapper;
        }
        PluginInfo info = this.solrConfig.getPluginInfo(IndexDeletionPolicy.class.getName());
        if (info != null) {
            delPolicy = SolrCore.createInstance(info.className, IndexDeletionPolicy.class, "Deletion Policy for SOLR", this, this.getResourceLoader());
            if (delPolicy instanceof NamedListInitializedPlugin) {
                ((NamedListInitializedPlugin)delPolicy).init(info.initArgs);
            }
        } else {
            delPolicy = new SolrDeletionPolicy();
        }
        return new IndexDeletionPolicyWrapper(delPolicy, this.snapshotMgr);
    }

    private SolrSnapshotMetaDataManager initSnapshotMetaDataManager() {
        try {
            String dirName = this.getDataDir() + "snapshot_metadata" + "/";
            Directory snapshotDir = this.directoryFactory.get(dirName, DirectoryFactory.DirContext.DEFAULT, this.getSolrConfig().indexConfig.lockType);
            return new SolrSnapshotMetaDataManager(this, snapshotDir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNamedSnapshot(String commitName) throws IOException {
        block8: {
            this.snapshotDelLock.lock();
            try {
                Optional<SolrSnapshotMetaDataManager.SnapshotMetaData> metadata = this.snapshotMgr.release(commitName);
                if (!metadata.isPresent()) break block8;
                long gen = metadata.get().getGenerationNumber();
                String indexDirPath = metadata.get().getIndexDirPath();
                if (indexDirPath.equals(this.getIndexDir())) break block8;
                Directory d = this.getDirectoryFactory().get(indexDirPath, DirectoryFactory.DirContext.DEFAULT, "none");
                try {
                    Collection<SolrSnapshotMetaDataManager.SnapshotMetaData> snapshots = this.snapshotMgr.listSnapshotsInIndexDir(indexDirPath);
                    log.info("Following snapshots exist in the index directory {} : {}", (Object)indexDirPath, snapshots);
                    if (snapshots.isEmpty()) {
                        log.info("Removing index directory {} since all named snapshots are deleted.", (Object)indexDirPath);
                        this.getDirectoryFactory().remove(d);
                    } else {
                        SolrSnapshotManager.deleteSnapshotIndexFiles(this, d, gen);
                    }
                }
                finally {
                    this.getDirectoryFactory().release(d);
                }
            }
            finally {
                this.snapshotDelLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNonSnapshotIndexFiles(String indexDirPath) throws IOException {
        if (this.getIndexDir().equals(indexDirPath)) {
            return;
        }
        this.snapshotDelLock.lock();
        Directory dir = this.getDirectoryFactory().get(indexDirPath, DirectoryFactory.DirContext.DEFAULT, "none");
        try {
            Collection<SolrSnapshotMetaDataManager.SnapshotMetaData> snapshots = this.snapshotMgr.listSnapshotsInIndexDir(indexDirPath);
            log.info("Following snapshots exist in the index directory {} : {}", (Object)indexDirPath, snapshots);
            if (snapshots.isEmpty()) {
                log.info("Removing index directory {} since all named snapshots are deleted.", (Object)indexDirPath);
                this.getDirectoryFactory().remove(dir);
            } else {
                SolrSnapshotManager.deleteNonSnapshotIndexFiles(this, dir, snapshots);
            }
        }
        finally {
            this.snapshotDelLock.unlock();
            if (dir != null) {
                this.getDirectoryFactory().release(dir);
            }
        }
    }

    private void initListeners() {
        Class<SolrEventListener> clazz = SolrEventListener.class;
        String label = "Event Listener";
        for (PluginInfo info : this.solrConfig.getPluginInfos(SolrEventListener.class.getName())) {
            SolrEventListener obj;
            String event = info.attributes.get("event");
            if ("firstSearcher".equals(event)) {
                obj = this.createInitInstance(info, clazz, "Event Listener", null);
                this.firstSearcherListeners.add(obj);
                log.debug("[{}] Added SolrEventListener for firstSearcher: [{}]", (Object)this.logid, (Object)obj);
                continue;
            }
            if (!"newSearcher".equals(event)) continue;
            obj = this.createInitInstance(info, clazz, "Event Listener", null);
            this.newSearcherListeners.add(obj);
            log.debug("[{}] Added SolrEventListener for newSearcher: [{}]", (Object)this.logid, (Object)obj);
        }
    }

    public void registerFirstSearcherListener(SolrEventListener listener) {
        this.firstSearcherListeners.add(listener);
    }

    public void registerNewSearcherListener(SolrEventListener listener) {
        this.newSearcherListeners.add(listener);
    }

    public QueryResponseWriter registerResponseWriter(String name, QueryResponseWriter responseWriter) {
        return this.responseWriters.put(name, responseWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore reload(ConfigSet coreConfig) throws IOException {
        Object object = this.getUpdateHandler().getSolrCoreState().getReloadLock();
        synchronized (object) {
            SolrCore solrCore;
            block7: {
                this.solrCoreState.increfSolrCoreState();
                SolrCore currentCore = !this.getNewIndexDir().equals(this.getIndexDir()) ? null : this;
                boolean success = false;
                SolrCore core = null;
                try {
                    CoreDescriptor cd = new CoreDescriptor(this.name, this.getCoreDescriptor());
                    cd.loadExtraProperties();
                    core = new SolrCore(this.coreContainer, cd, coreConfig, this.getDataDir(), this.updateHandler, this.solrDelPolicy, currentCore, true);
                    core.getUpdateHandler().getSolrCoreState().newIndexWriter(core, false);
                    core.getSearcher(true, false, null, true);
                    success = true;
                    solrCore = core;
                    if (success || core == null || core.getOpenCount() <= 0) break block7;
                }
                catch (Throwable throwable) {
                    if (!success && core != null && core.getOpenCount() > 0) {
                        IOUtils.closeQuietly((Closeable)core);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)core);
            }
            return solrCore;
        }
    }

    private DirectoryFactory initDirectoryFactory() {
        return DirectoryFactory.loadDirectoryFactory(this.solrConfig, this.coreContainer, this.coreMetricManager.getRegistryName());
    }

    private RecoveryStrategy.Builder initRecoveryStrategyBuilder() {
        RecoveryStrategy.Builder rsBuilder;
        PluginInfo info = this.solrConfig.getPluginInfo(RecoveryStrategy.Builder.class.getName());
        if (info != null && info.className != null) {
            log.info(info.className);
            rsBuilder = this.getResourceLoader().newInstance(info.className, RecoveryStrategy.Builder.class);
        } else {
            log.debug("solr.RecoveryStrategy.Builder");
            rsBuilder = new RecoveryStrategy.Builder();
        }
        if (info != null) {
            rsBuilder.init(info.initArgs);
        }
        return rsBuilder;
    }

    private void initIndexReaderFactory() {
        IndexReaderFactory indexReaderFactory;
        PluginInfo info = this.solrConfig.getPluginInfo(IndexReaderFactory.class.getName());
        if (info != null) {
            indexReaderFactory = this.resourceLoader.newInstance(info.className, IndexReaderFactory.class);
            indexReaderFactory.init(info.initArgs);
        } else {
            indexReaderFactory = new StandardIndexReaderFactory();
        }
        this.indexReaderFactory = indexReaderFactory;
    }

    @Deprecated
    private static boolean isWriterLocked(Directory directory) throws IOException {
        try {
            directory.obtainLock("write.lock").close();
            return false;
        }
        catch (LockObtainFailedException failed) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initIndex(boolean passOnPreviousState, boolean reload) throws IOException {
        String indexDir = this.getNewIndexDir();
        boolean indexExists = this.getDirectoryFactory().exists(indexDir);
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            boolean firstTime = dirs.add(this.getDirectoryFactory().normalize(indexDir));
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.initIndexReaderFactory();
            if (indexExists && firstTime && !passOnPreviousState) {
                String lockType = this.getSolrConfig().indexConfig.lockType;
                Directory dir = this.directoryFactory.get(indexDir, DirectoryFactory.DirContext.DEFAULT, lockType);
                try {
                    if (SolrCore.isWriterLocked(dir)) {
                        log.error("{}Solr index directory '{}' is locked (lockType={}).  Throwing exception.", new Object[]{this.logid, indexDir, lockType});
                        throw new LockObtainFailedException("Index dir '" + indexDir + "' of core '" + this.name + "' is already locked. The most likely cause is another Solr server (or another solr core in this server) also configured to use this directory; other possible causes may be specific to lockType: " + lockType);
                    }
                }
                finally {
                    this.directoryFactory.release(dir);
                }
            }
            if (!indexExists) {
                log.debug("{}Solr index directory '{}' doesn't exist. Creating new index...", (Object)this.logid, (Object)indexDir);
                SolrIndexWriter writer = null;
                try {
                    writer = SolrIndexWriter.create(this, "SolrCore.initIndex", indexDir, this.getDirectoryFactory(), true, this.getLatestSchema(), this.solrConfig.indexConfig, this.solrDelPolicy, this.codec);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)((Object)writer));
            }
            this.cleanupOldIndexDirectories(reload);
            return;
        }
    }

    public static <T> T createInstance(String className, Class<T> cast, String msg, SolrCore core, ResourceLoader resourceLoader) {
        Class clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            Constructor<?>[] cons;
            clazz = resourceLoader.findClass(className, cast);
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] types = con.getParameterTypes();
                if (types.length != 1 || types[0] != SolrCore.class) continue;
                return cast.cast(con.newInstance(core));
            }
            return (T)resourceLoader.newInstance(className, cast);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            if (null != e.getCause() && e.getCause() instanceof SolrException) {
                SolrException inner = (SolrException)e.getCause();
                throw inner;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + cast.getName(), (Throwable)e);
        }
    }

    private UpdateHandler createReloadedUpdateHandler(String className, String msg, UpdateHandler updateHandler) {
        Class<UpdateHandler> clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            Constructor<?>[] cons;
            clazz = this.getResourceLoader().findClass(className, UpdateHandler.class);
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] types = con.getParameterTypes();
                if (types.length != 2 || types[0] != SolrCore.class || types[1] != UpdateHandler.class) continue;
                return (UpdateHandler)UpdateHandler.class.cast(con.newInstance(this, updateHandler));
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " could not find proper constructor for " + UpdateHandler.class.getName());
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            if (null != e.getCause() && e.getCause() instanceof SolrException) {
                SolrException inner = (SolrException)e.getCause();
                throw inner;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + UpdateHandler.class.getName(), (Throwable)e);
        }
    }

    public <T> T createInitInstance(PluginInfo info, Class<T> cast, String msg, String defClassName) {
        if (info == null) {
            return null;
        }
        T o = SolrCore.createInstance(info.className == null ? defClassName : info.className, cast, msg, this, this.getResourceLoader(info.pkgName));
        return SolrCore.initPlugin(info, o);
    }

    public static <T> T initPlugin(PluginInfo info, T o) {
        if (o instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)o).init(info);
        } else if (o instanceof NamedListInitializedPlugin) {
            ((NamedListInitializedPlugin)o).init(info.initArgs);
        }
        if (o instanceof SearchComponent) {
            ((SearchComponent)o).setName(info.name);
        }
        return o;
    }

    private UpdateHandler createUpdateHandler(String className) {
        return SolrCore.createInstance(className, UpdateHandler.class, "Update Handler", this, this.getResourceLoader());
    }

    private UpdateHandler createUpdateHandler(String className, UpdateHandler updateHandler) {
        return this.createReloadedUpdateHandler(className, "Update Handler", updateHandler);
    }

    public SolrCore(CoreContainer coreContainer, CoreDescriptor cd, ConfigSet configSet) {
        this(coreContainer, cd, configSet, null, null, null, null, false);
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    private SolrCore(CoreContainer coreContainer, CoreDescriptor coreDescriptor, ConfigSet configSet, String dataDir, UpdateHandler updateHandler, IndexDeletionPolicyWrapper delPolicy, SolrCore prev, boolean reload) {
        assert (ObjectReleaseTracker.track((Object)this.searcherExecutor));
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.coreContainer = coreContainer;
            this.configSet = configSet;
            this.coreDescriptor = Objects.requireNonNull(coreDescriptor, "coreDescriptor cannot be null");
            this.setName(coreDescriptor.getName());
            this.solrConfig = configSet.getSolrConfig();
            this.resourceLoader = configSet.getSolrConfig().getResourceLoader();
            IndexSchema schema = configSet.getIndexSchema();
            this.configSetProperties = configSet.getProperties();
            this.coreMetricManager = this.initCoreMetricManager(this.solrConfig);
            this.circuitBreakerManager = this.initCircuitBreakerManager();
            this.solrMetricsContext = this.coreMetricManager.getSolrMetricsContext();
            this.coreMetricManager.loadReporters();
            if (updateHandler == null) {
                this.directoryFactory = this.initDirectoryFactory();
                this.recoveryStrategyBuilder = this.initRecoveryStrategyBuilder();
                this.solrCoreState = new DefaultSolrCoreState(this.directoryFactory, this.recoveryStrategyBuilder);
            } else {
                this.solrCoreState = updateHandler.getSolrCoreState();
                this.directoryFactory = this.solrCoreState.getDirectoryFactory();
                this.recoveryStrategyBuilder = this.solrCoreState.getRecoveryStrategyBuilder();
                this.isReloaded = true;
            }
            this.dataDir = this.initDataDir(dataDir, this.solrConfig, coreDescriptor);
            this.ulogDir = this.initUpdateLogDir(coreDescriptor);
            if (log.isInfoEnabled()) {
                log.info("[{}] Opening new SolrCore at [{}], dataDir=[{}]", new Object[]{this.logid, this.getInstancePath(), this.dataDir});
            }
            this.checkVersionFieldExistsInSchema(schema, coreDescriptor);
            this.setLatestSchema(schema);
            this.initializeMetrics(this.solrMetricsContext, null);
            SolrFieldCacheBean solrFieldCacheBean = new SolrFieldCacheBean();
            solrFieldCacheBean.initializeMetrics(this.solrMetricsContext, "core");
            this.infoRegistry.put("fieldCache", solrFieldCacheBean);
            this.maxWarmingSearchers = this.solrConfig.maxWarmingSearchers;
            this.slowQueryThresholdMillis = this.solrConfig.slowQueryThresholdMillis;
            this.initListeners();
            this.snapshotMgr = this.initSnapshotMetaDataManager();
            this.solrDelPolicy = this.initDeletionPolicy(delPolicy);
            this.codec = this.initCodec(this.solrConfig, this.schema);
            this.memClassLoader = new MemClassLoader(PluginBag.RuntimeLib.getLibObjects(this, this.solrConfig.getPluginInfos(PluginBag.RuntimeLib.class.getName())), this.getResourceLoader());
            this.initIndex(prev != null, reload);
            this.initWriters();
            this.qParserPlugins.init(QParserPlugin.standardPlugins, this);
            this.valueSourceParsers.init(ValueSourceParser.standardValueSourceParsers, this);
            this.transformerFactories.init(TransformerFactory.defaultFactories, this);
            this.loadSearchComponents();
            this.updateProcessors.init(Collections.emptyMap(), this);
            this.updateProcessorChains = this.loadUpdateProcessorChains();
            this.reqHandlers = new RequestHandlers(this);
            this.reqHandlers.initHandlersFromConfig(this.solrConfig);
            this.searcherExecutor.submit(() -> {
                latch.await();
                return null;
            });
            this.updateHandler = this.initUpdateHandler(updateHandler);
            this.initSearcher(prev);
            this.restManager = this.initRestManager();
            this.memClassLoader.loadRemoteJars();
            this.resourceLoader.inform(this.resourceLoader);
            this.resourceLoader.inform(this);
            this.updateHandler.informEventListeners(this);
            this.infoRegistry.put("core", this);
            this.resourceLoader.inform(this.infoRegistry);
            if (this.directoryFactory instanceof SolrMetricProducer) {
                ((SolrMetricProducer)((Object)this.directoryFactory)).initializeMetrics(this.solrMetricsContext.metricManager, this.solrMetricsContext.registry, this.solrMetricsContext.tag, "directoryFactory");
            }
            this.seedVersionBuckets();
            this.bufferUpdatesIfConstructing(coreDescriptor);
            this.ruleExpiryLock = new ReentrantLock();
            this.snapshotDelLock = new ReentrantLock();
            this.registerConfListener();
        }
        catch (Throwable e) {
            latch.countDown();
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            try {
                this.close();
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)t;
                }
                log.error("Error while closing", t);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), e);
        }
        finally {
            latch.countDown();
        }
        assert (ObjectReleaseTracker.track((Object)this));
    }

    public void seedVersionBuckets() {
        UpdateHandler uh = this.getUpdateHandler();
        if (uh != null && uh.getUpdateLog() != null) {
            RefCounted<SolrIndexSearcher> newestSearcher = this.getRealtimeSearcher();
            if (newestSearcher != null) {
                try {
                    uh.getUpdateLog().seedBucketsWithHighestVersion(newestSearcher.get());
                }
                finally {
                    newestSearcher.decref();
                }
            } else {
                log.warn("No searcher available! Cannot seed version buckets with max from index.");
            }
        }
    }

    private void bufferUpdatesIfConstructing(CoreDescriptor coreDescriptor) {
        if (this.coreContainer != null && this.coreContainer.isZooKeeperAware()) {
            ClusterState clusterState;
            DocCollection collection;
            Slice slice;
            if (this.reqHandlers.get("/get") == null) {
                log.warn("WARNING: RealTimeGetHandler is not registered at /get. SolrCloud will always use full index replication instead of the more efficient PeerSync method.");
            }
            if ((slice = (collection = (clusterState = this.coreContainer.getZkController().getClusterState()).getCollection(coreDescriptor.getCloudDescriptor().getCollectionName())).getSlice(coreDescriptor.getCloudDescriptor().getShardId())).getState() == Slice.State.CONSTRUCTION) {
                this.getUpdateHandler().getUpdateLog().bufferUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSearcher(SolrCore prev) throws IOException {
        RefCounted<IndexWriter> iwRef = null;
        if (prev != null && (iwRef = prev.getUpdateHandler().getSolrCoreState().getIndexWriter(null)) != null) {
            IndexWriter iw = iwRef.get();
            SolrCore core = this;
            this.newReaderCreator = () -> this.indexReaderFactory.newReader(iw, core);
        }
        try {
            this.getSearcher(false, false, null, true);
        }
        finally {
            this.newReaderCreator = null;
            if (iwRef != null) {
                iwRef.decref();
            }
        }
    }

    private UpdateHandler initUpdateHandler(UpdateHandler updateHandler) {
        UpdateHandler newUpdateHandler;
        String updateHandlerClass = this.solrConfig.getUpdateHandlerInfo().className;
        if (updateHandlerClass == null) {
            updateHandlerClass = DirectUpdateHandler2.class.getName();
        }
        if ((newUpdateHandler = updateHandler == null ? this.createUpdateHandler(updateHandlerClass) : this.createUpdateHandler(updateHandlerClass, updateHandler)) instanceof SolrMetricProducer) {
            this.coreMetricManager.registerMetricProducer("updateHandler", (SolrMetricProducer)((Object)newUpdateHandler));
        }
        this.infoRegistry.put("updateHandler", newUpdateHandler);
        return newUpdateHandler;
    }

    private SolrCoreMetricManager initCoreMetricManager(SolrConfig config) {
        SolrCoreMetricManager coreMetricManager = new SolrCoreMetricManager(this);
        return coreMetricManager;
    }

    private CircuitBreakerManager initCircuitBreakerManager() {
        PluginInfo info = this.solrConfig.getPluginInfo(CircuitBreakerManager.class.getName());
        CircuitBreakerManager circuitBreakerManager = CircuitBreakerManager.build(info);
        return circuitBreakerManager;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        CloudDescriptor cd;
        this.newSearcherCounter = parentContext.counter(this, "new", SolrInfoBean.Category.SEARCHER.toString());
        this.newSearcherTimer = parentContext.timer(this, "time", SolrInfoBean.Category.SEARCHER.toString(), "new");
        this.newSearcherWarmupTimer = parentContext.timer(this, "warmup", SolrInfoBean.Category.SEARCHER.toString(), "new");
        this.newSearcherMaxReachedCounter = parentContext.counter(this, "maxReached", SolrInfoBean.Category.SEARCHER.toString(), "new");
        this.newSearcherOtherErrorsCounter = parentContext.counter(this, "errors", SolrInfoBean.Category.SEARCHER.toString(), "new");
        parentContext.gauge(this, () -> this.name == null ? "(null)" : this.name, true, "coreName", SolrInfoBean.Category.CORE.toString());
        parentContext.gauge(this, () -> this.startTime, true, "startTime", SolrInfoBean.Category.CORE.toString());
        parentContext.gauge(this, () -> this.getOpenCount(), true, "refCount", SolrInfoBean.Category.CORE.toString());
        parentContext.gauge(this, () -> this.getInstancePath().toString(), true, "instanceDir", SolrInfoBean.Category.CORE.toString());
        parentContext.gauge(this, () -> this.isClosed() ? "(closed)" : this.getIndexDir(), true, "indexDir", SolrInfoBean.Category.CORE.toString());
        parentContext.gauge(this, () -> this.isClosed() ? 0L : this.getIndexSize(), true, "sizeInBytes", SolrInfoBean.Category.INDEX.toString());
        parentContext.gauge(this, () -> this.isClosed() ? "(closed)" : NumberUtils.readableSize(this.getIndexSize()), true, "size", SolrInfoBean.Category.INDEX.toString());
        if (this.coreContainer != null && (cd = this.getCoreDescriptor().getCloudDescriptor()) != null) {
            parentContext.gauge(this, () -> {
                if (cd.getCollectionName() != null) {
                    return cd.getCollectionName();
                }
                return "_notset_";
            }, true, "collection", SolrInfoBean.Category.CORE.toString());
            parentContext.gauge(this, () -> {
                if (cd.getShardId() != null) {
                    return cd.getShardId();
                }
                return "_auto_";
            }, true, "shard", SolrInfoBean.Category.CORE.toString());
        }
        Path dataDirPath = Paths.get(this.dataDir, new String[0]);
        File dataDirFile = dataDirPath.toFile();
        parentContext.gauge(this, () -> dataDirFile.getTotalSpace(), true, "totalSpace", SolrInfoBean.Category.CORE.toString(), "fs");
        parentContext.gauge(this, () -> dataDirFile.getUsableSpace(), true, "usableSpace", SolrInfoBean.Category.CORE.toString(), "fs");
        parentContext.gauge(this, () -> dataDirPath.toAbsolutePath().toString(), true, "path", SolrInfoBean.Category.CORE.toString(), "fs");
        parentContext.gauge(this, () -> {
            try {
                return org.apache.lucene.util.IOUtils.spins((Path)dataDirPath.toAbsolutePath());
            }
            catch (IOException e) {
                return true;
            }
        }, true, "spins", SolrInfoBean.Category.CORE.toString(), "fs");
    }

    public String getMetricTag() {
        return this.metricTag;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    private void checkVersionFieldExistsInSchema(IndexSchema schema, CoreDescriptor coreDescriptor) {
        if (null != coreDescriptor.getCloudDescriptor()) {
            try {
                VersionInfo.getAndCheckVersionField(schema);
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Schema will not work with SolrCloud mode: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String initDataDir(String dataDir, SolrConfig config, CoreDescriptor coreDescriptor) {
        return SolrCore.findDataDir(this.getDirectoryFactory(), dataDir, config, coreDescriptor);
    }

    static String findDataDir(DirectoryFactory directoryFactory, String dataDir, SolrConfig config, CoreDescriptor coreDescriptor) {
        if (dataDir == null) {
            if (coreDescriptor.usingDefaultDataDir()) {
                dataDir = config.getDataDir();
            }
            if (dataDir == null) {
                try {
                    dataDir = coreDescriptor.getDataDir();
                    if (!directoryFactory.isAbsolute(dataDir)) {
                        dataDir = directoryFactory.getDataHome(coreDescriptor);
                    }
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
        return SolrPaths.normalizeDir(dataDir);
    }

    public boolean modifyIndexProps(String tmpIdxDirName) {
        return SolrCore.modifyIndexProps(this.getDirectoryFactory(), this.getDataDir(), this.getSolrConfig(), tmpIdxDirName);
    }

    static boolean modifyIndexProps(DirectoryFactory directoryFactory, String dataDir, SolrConfig solrConfig, String tmpIdxDirName) {
        log.info("Updating index properties... index={}", (Object)tmpIdxDirName);
        Directory dir = null;
        try {
            dir = directoryFactory.get(dataDir, DirectoryFactory.DirContext.META_DATA, solrConfig.indexConfig.lockType);
            String tmpIdxPropName = "index.properties." + System.nanoTime();
            SolrCore.writeNewIndexProps(dir, tmpIdxPropName, tmpIdxDirName);
            directoryFactory.renameWithOverwrite(dir, tmpIdxPropName, "index.properties");
            boolean bl = true;
            return bl;
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            if (dir != null) {
                try {
                    directoryFactory.release(dir);
                }
                catch (IOException e) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNewIndexProps(Directory dir, String tmpFileName, String tmpIdxDirName) {
        if (tmpFileName == null) {
            tmpFileName = "index.properties";
        }
        Properties p = new Properties();
        try {
            IndexInput input = dir.openInput("index.properties", DirectoryFactory.IOCONTEXT_NO_CACHE);
            PropertiesInputStream is = new PropertiesInputStream(input);
            try {
                p.load(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                log.error("Unable to load {}", (Object)"index.properties", (Object)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)is);
            }
        }
        catch (IOException input) {
            // empty catch block
        }
        p.put("index", tmpIdxDirName);
        OutputStreamWriter os = null;
        try {
            IndexOutput out = dir.createOutput(tmpFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
            os = new OutputStreamWriter((OutputStream)new PropertiesOutputStream(out), StandardCharsets.UTF_8);
            p.store(os, "index.properties");
            dir.sync(Collections.singleton(tmpFileName));
        }
        catch (Exception e) {
            try {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to write index.properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)os);
    }

    private String initUpdateLogDir(CoreDescriptor coreDescriptor) {
        String updateLogDir = coreDescriptor.getUlogDir();
        if (updateLogDir == null) {
            updateLogDir = coreDescriptor.getInstanceDir().resolve(this.dataDir).toString();
        }
        return updateLogDir;
    }

    public void closeAndWait() {
        this.close();
        while (!this.isClosed()) {
            long milliSleep = 100L;
            if (log.isInfoEnabled()) {
                log.info("Core {} is not yet closed, waiting {} ms before checking again.", (Object)this.getName(), (Object)100L);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Caught InterruptedException whilst waiting for core " + this.getName() + " to close: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private Codec initCodec(SolrConfig solrConfig, IndexSchema schema) {
        CodecFactory factory;
        PluginInfo info = solrConfig.getPluginInfo(CodecFactory.class.getName());
        if (info != null) {
            factory = this.resourceLoader.newInstance(info.className, CodecFactory.class);
            factory.init(info.initArgs);
        } else {
            factory = new CodecFactory(){

                @Override
                public Codec getCodec() {
                    return Codec.getDefault();
                }
            };
        }
        if (factory instanceof SolrCoreAware) {
            ((SolrCoreAware)((Object)factory)).inform(this);
        } else {
            for (FieldType ft : schema.getFieldTypes().values()) {
                if (null != ft.getPostingsFormat()) {
                    String msg = "FieldType '" + ft.getTypeName() + "' is configured with a postings format, but the codec does not support it: " + factory.getClass();
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                if (null == ft.getDocValuesFormat()) continue;
                String msg = "FieldType '" + ft.getTypeName() + "' is configured with a docValues format, but the codec does not support it: " + factory.getClass();
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
        }
        return factory.getCodec();
    }

    public StatsCache createStatsCache() {
        StatsCache cache;
        PluginInfo pluginInfo = this.solrConfig.getPluginInfo(StatsCache.class.getName());
        if (pluginInfo != null && pluginInfo.className != null && pluginInfo.className.length() > 0) {
            cache = this.createInitInstance(pluginInfo, StatsCache.class, null, LocalStatsCache.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Using statsCache impl: {}", (Object)cache.getClass().getName());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Using default statsCache cache: {}", (Object)LocalStatsCache.class.getName());
            }
            cache = new LocalStatsCache();
        }
        return cache;
    }

    private Map<String, UpdateRequestProcessorChain> loadUpdateProcessorChains() {
        HashMap<String, UpdateRequestProcessorChain> map = new HashMap<String, UpdateRequestProcessorChain>();
        UpdateRequestProcessorChain def = this.initPlugins(map, UpdateRequestProcessorChain.class, UpdateRequestProcessorChain.class.getName());
        if (def == null) {
            def = (UpdateRequestProcessorChain)map.get(null);
        }
        if (def == null) {
            log.debug("no updateRequestProcessorChain defined as default, creating implicit default");
            UpdateRequestProcessorFactory[] factories = new UpdateRequestProcessorFactory[]{new LogUpdateProcessorFactory(), new DistributedUpdateProcessorFactory(), new RunUpdateProcessorFactory()};
            def = new UpdateRequestProcessorChain(Arrays.asList(factories), this);
        }
        map.put(null, def);
        map.put("", def);
        map.computeIfAbsent("_preRun_", k -> new UpdateRequestProcessorChain(Collections.singletonList(new NestedUpdateProcessorFactory()), this));
        return map;
    }

    public SolrCoreState getSolrCoreState() {
        return this.solrCoreState;
    }

    public UpdateRequestProcessorChain getUpdateProcessingChain(String name) {
        UpdateRequestProcessorChain chain = this.updateProcessorChains.get(name);
        if (chain == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown UpdateRequestProcessorChain: " + name);
        }
        return chain;
    }

    public UpdateRequestProcessorChain getUpdateProcessorChain(SolrParams params) {
        String chainName = params.get("update.chain");
        UpdateRequestProcessorChain defaultUrp = this.getUpdateProcessingChain(chainName);
        UpdateRequestProcessorChain.ProcessorInfo processorInfo = new UpdateRequestProcessorChain.ProcessorInfo(params);
        if (processorInfo.isEmpty()) {
            return defaultUrp;
        }
        return UpdateRequestProcessorChain.constructChain(defaultUrp, processorInfo, this);
    }

    public PluginBag<UpdateRequestProcessorFactory> getUpdateProcessors() {
        return this.updateProcessors;
    }

    public CircuitBreakerManager getCircuitBreakerManager() {
        return this.circuitBreakerManager;
    }

    public void open() {
        this.refCount.incrementAndGet();
        MDCLoggingContext.setCore(this);
    }

    @Override
    public void close() {
        block46: {
            boolean coreStateClosed;
            block45: {
                block44: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    block39: {
                                        MDCLoggingContext.clear();
                                        int count = this.refCount.decrementAndGet();
                                        if (count > 0) {
                                            return;
                                        }
                                        if (count < 0) {
                                            log.error("Too many close [count:{}] on {}. Please report this exception to solr-user@lucene.apache.org", (Object)count, (Object)this);
                                            assert (false) : "Too many closes on SolrCore";
                                            return;
                                        }
                                        log.info("{} CLOSING SolrCore {}", (Object)this.logid, (Object)this);
                                        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreAsyncTaskExecutor);
                                        try {
                                            this.coreMetricManager.close();
                                        }
                                        catch (Throwable e) {
                                            SolrException.log((Logger)log, (Throwable)e);
                                            if (!(e instanceof Error)) break block39;
                                            throw (Error)e;
                                        }
                                    }
                                    if (this.closeHooks != null) {
                                        for (CloseHook hook : this.closeHooks) {
                                            try {
                                                hook.preClose(this);
                                            }
                                            catch (Throwable e) {
                                                SolrException.log((Logger)log, (Throwable)e);
                                                if (!(e instanceof Error)) continue;
                                                throw (Error)e;
                                            }
                                        }
                                    }
                                    if (this.reqHandlers != null) {
                                        this.reqHandlers.close();
                                    }
                                    this.responseWriters.close();
                                    this.searchComponents.close();
                                    this.qParserPlugins.close();
                                    this.valueSourceParsers.close();
                                    this.transformerFactories.close();
                                    if (this.memClassLoader != null) {
                                        try {
                                            this.memClassLoader.close();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    try {
                                        if (null != this.updateHandler) {
                                            this.updateHandler.close();
                                        }
                                    }
                                    catch (Throwable e) {
                                        SolrException.log((Logger)log, (Throwable)e);
                                        if (!(e instanceof Error)) break block40;
                                        throw (Error)e;
                                    }
                                }
                                coreStateClosed = false;
                                try {
                                    if (this.solrCoreState != null) {
                                        coreStateClosed = this.updateHandler instanceof SolrCoreState.IndexWriterCloser ? this.solrCoreState.decrefSolrCoreState((SolrCoreState.IndexWriterCloser)((Object)this.updateHandler)) : this.solrCoreState.decrefSolrCoreState(null);
                                    }
                                }
                                catch (Throwable e) {
                                    SolrException.log((Logger)log, (Throwable)e);
                                    if (!(e instanceof Error)) break block41;
                                    throw (Error)e;
                                }
                            }
                            try {
                                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.searcherExecutor);
                            }
                            catch (Throwable e) {
                                SolrException.log((Logger)log, (Throwable)e);
                                if (!(e instanceof Error)) break block42;
                                throw (Error)e;
                            }
                        }
                        assert (ObjectReleaseTracker.release((Object)this.searcherExecutor));
                        try {
                            this.closeSearcher();
                        }
                        catch (Throwable e) {
                            SolrException.log((Logger)log, (Throwable)e);
                            if (!(e instanceof Error)) break block43;
                            throw (Error)e;
                        }
                    }
                    if (coreStateClosed) {
                        try {
                            this.cleanupOldIndexDirectories(false);
                        }
                        catch (Exception e) {
                            SolrException.log((Logger)log, (Throwable)e);
                        }
                    }
                    try {
                        this.infoRegistry.clear();
                    }
                    catch (Throwable e) {
                        SolrException.log((Logger)log, (Throwable)e);
                        if (!(e instanceof Error)) break block44;
                        throw (Error)e;
                    }
                }
                Directory snapshotsDir = this.snapshotMgr.getSnapshotsDir();
                try {
                    this.directoryFactory.release(snapshotsDir);
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                    if (!(e instanceof Error)) break block45;
                    throw (Error)e;
                }
            }
            if (coreStateClosed) {
                try {
                    this.directoryFactory.close();
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                    if (!(e instanceof Error)) break block46;
                    throw (Error)e;
                }
            }
        }
        if (this.closeHooks != null) {
            for (CloseHook hook : this.closeHooks) {
                try {
                    hook.postClose(this);
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public int getOpenCount() {
        return this.refCount.get();
    }

    public boolean isClosed() {
        return this.refCount.get() <= 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.getOpenCount() != 0) {
                log.error("REFCOUNT ERROR: unreferenced {} ({}) has a reference count of {}", new Object[]{this, this.getName(), this.getOpenCount()});
            }
        }
        finally {
            super.finalize();
        }
    }

    public void addCloseHook(CloseHook hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new ArrayList<CloseHook>();
        }
        this.closeHooks.add(hook);
    }

    public static void verbose(Object ... args) {
        if (!VERBOSE) {
            return;
        }
        StringBuilder sb = new StringBuilder("VERBOSE:");
        for (Object o : args) {
            sb.append(' ');
            sb.append(o == null ? "(null)" : o.toString());
        }
        log.info("{}", (Object)sb);
    }

    public SolrRequestHandler getRequestHandler(String handlerName) {
        return RequestHandlerBase.getRequestHandler(RequestHandlers.normalize(handlerName), this.reqHandlers.handlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.reqHandlers.handlers;
    }

    public SolrRequestHandler registerRequestHandler(String handlerName, SolrRequestHandler handler) {
        return this.reqHandlers.register(handlerName, handler);
    }

    private void loadSearchComponents() {
        Map instances = this.createInstances(SearchComponent.standard_components);
        for (Map.Entry e : instances.entrySet()) {
            ((SearchComponent)e.getValue()).setName(e.getKey());
        }
        this.searchComponents.init(instances, this);
        for (String name : this.searchComponents.keySet()) {
            if (!this.searchComponents.isLoaded(name) || !(this.searchComponents.get(name) instanceof HighlightComponent)) continue;
            if ("highlight".equals(name)) break;
            this.searchComponents.put("highlight", this.searchComponents.getRegistry().get(name));
            break;
        }
    }

    public SearchComponent getSearchComponent(String name) {
        return this.searchComponents.get(name);
    }

    public PluginBag<SearchComponent> getSearchComponents() {
        return this.searchComponents;
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areAllSearcherReferencesEmpty() {
        boolean isEmpty;
        Object object = this.searcherLock;
        synchronized (object) {
            isEmpty = this._searchers.isEmpty();
            isEmpty = isEmpty && this._realtimeSearchers.isEmpty();
            isEmpty = isEmpty && this._searcher == null;
            isEmpty = isEmpty && this.realtimeSearcher == null;
        }
        return isEmpty;
    }

    public RefCounted<SolrIndexSearcher> getSearcher() {
        if (this.searchEnabled) {
            return this.getSearcher(false, true, null);
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Search is temporarily disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R withSearcher(IOFunction<SolrIndexSearcher, R> lambda) throws IOException {
        RefCounted<SolrIndexSearcher> refCounted = this.getSearcher();
        try {
            R r = lambda.apply(refCounted.get());
            return r;
        }
        finally {
            refCounted.decref();
        }
    }

    public IndexFingerprint getIndexFingerprint(SolrIndexSearcher searcher, LeafReaderContext ctx, long maxVersion) throws IOException {
        IndexReader.CacheHelper cacheHelper = ctx.reader().getReaderCacheHelper();
        if (cacheHelper == null) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot cache IndexFingerprint as reader does not support caching. searcher:{} reader:{} readerHash:{} maxVersion:{}", new Object[]{searcher, ctx.reader(), ctx.reader().hashCode(), maxVersion});
            }
            return IndexFingerprint.getFingerprint(searcher, ctx, maxVersion);
        }
        IndexFingerprint f = null;
        f = this.perSegmentFingerprintCache.get(cacheHelper.getKey());
        if (f == null || f.getMaxInHash() > maxVersion || f.getNumDocs() != (long)ctx.reader().numDocs()) {
            if (log.isDebugEnabled()) {
                log.debug("IndexFingerprint cache miss for searcher:{} reader:{} readerHash:{} maxVersion:{}", new Object[]{searcher, ctx.reader(), ctx.reader().hashCode(), maxVersion});
            }
            if ((f = IndexFingerprint.getFingerprint(searcher, ctx, maxVersion)).getMaxVersionEncountered() == f.getMaxInHash()) {
                log.debug("Caching fingerprint for searcher:{} leafReaderContext:{} mavVersion:{}", new Object[]{searcher, ctx, maxVersion});
                this.perSegmentFingerprintCache.put(cacheHelper.getKey(), f);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("IndexFingerprint cache hit for searcher:{} reader:{} readerHash:{} maxVersion:{}", new Object[]{searcher, ctx.reader(), ctx.reader().hashCode(), maxVersion});
        }
        if (log.isDebugEnabled()) {
            log.debug("Cache Size: {}, Segments Size:{}", (Object)this.perSegmentFingerprintCache.size(), (Object)searcher.getTopReaderContext().leaves().size());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getRegisteredSearcher() {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null) {
                this._searcher.incref();
            }
            return this._searcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getNewestSearcher(boolean openNew) {
        Object object = this.searcherLock;
        synchronized (object) {
            if (!this._searchers.isEmpty()) {
                RefCounted<SolrIndexSearcher> newest = this._searchers.getLast();
                newest.incref();
                return newest;
            }
        }
        return openNew ? this.getRealtimeSearcher() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefCounted<SolrIndexSearcher> getRealtimeSearcher() {
        RefCounted<SolrIndexSearcher> refCounted = this.searcherLock;
        synchronized (refCounted) {
            if (this.realtimeSearcher != null) {
                this.realtimeSearcher.incref();
                return this.realtimeSearcher;
            }
        }
        this.openSearcherLock.lock();
        try {
            refCounted = this.searcherLock;
            synchronized (refCounted) {
                if (this.realtimeSearcher != null) {
                    this.realtimeSearcher.incref();
                    RefCounted<SolrIndexSearcher> refCounted2 = this.realtimeSearcher;
                    return refCounted2;
                }
            }
            refCounted = this.openNewSearcher(true, true);
            return refCounted;
        }
        finally {
            this.openSearcherLock.unlock();
        }
    }

    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher) {
        return this.getSearcher(forceNew, returnSearcher, waitSearcher, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> openNewSearcher(boolean updateHandlerReopens, boolean realtime) {
        if (this.isClosed()) {
            throw new SolrCoreState.CoreIsClosedException();
        }
        RefCounted<SolrIndexSearcher> newestSearcher = null;
        this.openSearcherLock.lock();
        try {
            SolrIndexSearcher tmp;
            DirectoryReader newReader;
            String newIndexDir = this.getNewIndexDir();
            String indexDirFile = null;
            String newIndexDirFile = null;
            if (!updateHandlerReopens) {
                indexDirFile = this.getDirectoryFactory().normalize(this.getIndexDir());
                newIndexDirFile = this.getDirectoryFactory().normalize(newIndexDir);
            }
            Object object = this.searcherLock;
            synchronized (object) {
                newestSearcher = this.realtimeSearcher;
                if (newestSearcher != null) {
                    newestSearcher.incref();
                }
            }
            if (newestSearcher != null && (updateHandlerReopens || indexDirFile.equals(newIndexDirFile))) {
                DirectoryReader currentReader = newestSearcher.get().getRawReader();
                RefCounted<IndexWriter> writer = this.getSolrCoreState().getIndexWriter(null);
                try {
                    newReader = writer != null ? DirectoryReader.openIfChanged((DirectoryReader)currentReader, (IndexWriter)writer.get(), (boolean)true) : DirectoryReader.openIfChanged((DirectoryReader)currentReader);
                }
                finally {
                    if (writer != null) {
                        writer.decref();
                    }
                }
                if (newReader == null) {
                    if (realtime) {
                        newestSearcher.incref();
                        RefCounted<SolrIndexSearcher> refCounted = newestSearcher;
                        return refCounted;
                    }
                    if (newestSearcher.get().isCachingEnabled() && newestSearcher.get().getSchema() == this.getLatestSchema()) {
                        newestSearcher.incref();
                        if (log.isDebugEnabled()) {
                            log.debug("SolrIndexSearcher has not changed - not re-opening: {}", (Object)newestSearcher.get().getName());
                        }
                        RefCounted<SolrIndexSearcher> refCounted = newestSearcher;
                        return refCounted;
                    }
                    currentReader.incRef();
                    newReader = currentReader;
                }
                boolean useCaches = !realtime;
                String newName = realtime ? "realtime" : "main";
                tmp = new SolrIndexSearcher(this, newIndexDir, this.getLatestSchema(), newName, newReader, true, useCaches, true, this.directoryFactory);
            } else if (this.newReaderCreator != null) {
                newReader = this.newReaderCreator.call();
                tmp = new SolrIndexSearcher(this, newIndexDir, this.getLatestSchema(), realtime ? "realtime" : "main", newReader, true, !realtime, true, this.directoryFactory);
            } else {
                RefCounted<IndexWriter> writer = this.getSolrCoreState().getIndexWriter(this);
                DirectoryReader newReader2 = null;
                try {
                    newReader2 = this.indexReaderFactory.newReader(writer.get(), this);
                }
                finally {
                    writer.decref();
                }
                tmp = new SolrIndexSearcher(this, newIndexDir, this.getLatestSchema(), realtime ? "realtime" : "main", newReader2, true, !realtime, true, this.directoryFactory);
            }
            LinkedList<RefCounted<SolrIndexSearcher>> searcherList = realtime ? this._realtimeSearchers : this._searchers;
            RefCounted<SolrIndexSearcher> newSearcher = this.newHolder(tmp, searcherList);
            newSearcher.incref();
            RefCounted<SolrIndexSearcher> refCounted = this.searcherLock;
            synchronized (refCounted) {
                if (this.isClosed()) {
                    newSearcher.decref();
                    newSearcher.decref();
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "openNewSearcher called on closed core");
                }
                if (this.realtimeSearcher != null) {
                    this.realtimeSearcher.decref();
                }
                this.realtimeSearcher = newSearcher;
                searcherList.add(this.realtimeSearcher);
            }
            refCounted = newSearcher;
            return refCounted;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error opening new searcher", (Throwable)e);
        }
        finally {
            this.openSearcherLock.unlock();
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher, boolean updateHandlerReopens) {
        Object object = this.searcherLock;
        synchronized (object) {
            block46: {
                while (true) {
                    block45: {
                        if (this._searcher != null && !forceNew) {
                            if (returnSearcher) {
                                this._searcher.incref();
                                return this._searcher;
                            }
                            return null;
                        }
                        if (this.onDeckSearchers > 0 && !forceNew && this._searcher == null) {
                            try {
                                this.searcherLock.wait();
                            }
                            catch (InterruptedException e) {
                                if (!log.isInfoEnabled()) break block45;
                                log.info(SolrException.toStr((Throwable)e));
                            }
                        }
                    }
                    if (this._searcher != null && !forceNew) {
                        if (returnSearcher) {
                            this._searcher.incref();
                            return this._searcher;
                        }
                        return null;
                    }
                    ++this.onDeckSearchers;
                    this.newSearcherCounter.inc();
                    if (this.onDeckSearchers < 1) {
                        log.error("{}ERROR!!! onDeckSearchers is {}", (Object)this.logid, (Object)this.onDeckSearchers);
                        this.onDeckSearchers = 1;
                        break block46;
                    }
                    if (this.onDeckSearchers <= this.maxWarmingSearchers) break;
                    --this.onDeckSearchers;
                    this.newSearcherMaxReachedCounter.inc();
                    try {
                        this.searcherLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (!log.isInfoEnabled()) continue;
                        log.info(SolrException.toStr((Throwable)e));
                    }
                }
                if (this.onDeckSearchers > 1) {
                    log.warn("{}PERFORMANCE WARNING: Overlapping onDeckSearchers={}", (Object)this.logid, (Object)this.onDeckSearchers);
                }
            }
        }
        boolean[] decrementOnDeckCount = new boolean[]{true};
        RefCounted<SolrIndexSearcher> currSearcherHolder = null;
        RefCounted<SolrIndexSearcher> searchHolder = null;
        boolean success = false;
        this.openSearcherLock.lock();
        Timer.Context timerContext = this.newSearcherTimer.time();
        try {
            searchHolder = this.openNewSearcher(updateHandlerReopens, false);
            if (returnSearcher) {
                searchHolder.incref();
            }
            RefCounted<SolrIndexSearcher> newSearchHolder = searchHolder;
            SolrIndexSearcher newSearcher = newSearchHolder.get();
            boolean alreadyRegistered = false;
            Object object2 = this.searcherLock;
            synchronized (object2) {
                if (this._searcher == null) {
                    if (this.solrConfig.useColdSearcher) {
                        this.registerSearcher(newSearchHolder);
                        decrementOnDeckCount[0] = false;
                        alreadyRegistered = true;
                    }
                } else {
                    currSearcherHolder = this._searcher;
                    currSearcherHolder.incref();
                }
            }
            SolrIndexSearcher currSearcher = currSearcherHolder == null ? null : currSearcherHolder.get();
            Future<Object> future = null;
            if (newSearcher != currSearcher) {
                if (currSearcher != null) {
                    future = this.searcherExecutor.submit(() -> {
                        try (Timer.Context warmupContext = this.newSearcherWarmupTimer.time();){
                            newSearcher.warm(currSearcher);
                        }
                        return null;
                    });
                }
                if (currSearcher == null) {
                    future = this.searcherExecutor.submit(() -> {
                        block3: {
                            try {
                                for (SolrEventListener listener : this.firstSearcherListeners) {
                                    listener.newSearcher(newSearcher, null);
                                }
                            }
                            catch (Throwable e) {
                                SolrException.log((Logger)log, null, (Throwable)e);
                                if (!(e instanceof Error)) break block3;
                                throw (Error)e;
                            }
                        }
                        return null;
                    });
                }
                if (currSearcher != null) {
                    future = this.searcherExecutor.submit(() -> {
                        block3: {
                            try {
                                for (SolrEventListener listener : this.newSearcherListeners) {
                                    listener.newSearcher(newSearcher, currSearcher);
                                }
                            }
                            catch (Throwable e) {
                                SolrException.log((Logger)log, null, (Throwable)e);
                                if (!(e instanceof Error)) break block3;
                                throw (Error)e;
                            }
                        }
                        return null;
                    });
                }
            }
            RefCounted<SolrIndexSearcher> currSearcherHolderF = currSearcherHolder;
            if (!alreadyRegistered) {
                future = this.searcherExecutor.submit(() -> {
                    try {
                        this.registerSearcher(newSearchHolder);
                    }
                    catch (Throwable e) {
                        SolrException.log((Logger)log, (Throwable)e);
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                    }
                    finally {
                        if (currSearcherHolderF != null) {
                            currSearcherHolderF.decref();
                        }
                    }
                    return null;
                });
            }
            if (waitSearcher != null) {
                waitSearcher[0] = future;
            }
            success = true;
            RefCounted<SolrIndexSearcher> refCounted = returnSearcher ? newSearchHolder : null;
            return refCounted;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            timerContext.close();
            if (!success) {
                this.newSearcherOtherErrorsCounter.inc();
                Object object3 = this.searcherLock;
                synchronized (object3) {
                    --this.onDeckSearchers;
                    if (this.onDeckSearchers < 0) {
                        log.error("{}ERROR!!! onDeckSearchers after decrement={}", (Object)this.logid, (Object)this.onDeckSearchers);
                        this.onDeckSearchers = 0;
                    }
                    this.searcherLock.notify();
                }
                if (currSearcherHolder != null) {
                    currSearcherHolder.decref();
                }
                if (searchHolder != null) {
                    searchHolder.decref();
                    if (returnSearcher) {
                        searchHolder.decref();
                    }
                }
            }
            this.openSearcherLock.unlock();
        }
    }

    private RefCounted<SolrIndexSearcher> newHolder(SolrIndexSearcher newSearcher, final List<RefCounted<SolrIndexSearcher>> searcherList) {
        RefCounted<SolrIndexSearcher> holder = new RefCounted<SolrIndexSearcher>(newSearcher){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    Object object = SolrCore.this.searcherLock;
                    synchronized (object) {
                        if (this.refcount.get() > 0) {
                            return;
                        }
                        searcherList.remove(this);
                    }
                    ((SolrIndexSearcher)this.resource).close();
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error closing searcher:" + this), (Throwable)e);
                }
            }
        };
        holder.incref();
        return holder;
    }

    public boolean isReloaded() {
        return this.isReloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerSearcher(RefCounted<SolrIndexSearcher> newSearcherHolder) {
        Object object = this.searcherLock;
        synchronized (object) {
            block12: {
                if (this._searcher != newSearcherHolder) break block12;
                newSearcherHolder.decref();
                --this.onDeckSearchers;
                this.searcherLock.notifyAll();
                assert (TestInjection.injectSearcherHooks(this.getCoreDescriptor() != null && this.getCoreDescriptor().getCloudDescriptor() != null ? this.getCoreDescriptor().getCloudDescriptor().getCollectionName() : null));
                return;
            }
            try {
                if (this._searcher != null) {
                    this._searcher.decref();
                    this._searcher = null;
                }
                this._searcher = newSearcherHolder;
                SolrIndexSearcher newSearcher = newSearcherHolder.get();
                newSearcher.register();
                if (log.isInfoEnabled()) {
                    log.info("{} Registered new searcher autowarm time: {} ms", (Object)this.logid, (Object)newSearcher.getWarmupTime());
                }
                --this.onDeckSearchers;
                this.searcherLock.notifyAll();
                if ($assertionsDisabled || TestInjection.injectSearcherHooks(this.getCoreDescriptor() != null && this.getCoreDescriptor().getCloudDescriptor() != null ? this.getCoreDescriptor().getCloudDescriptor().getCollectionName() : null)) return;
            }
            catch (Exception e) {
                try {
                    SolrCore.log(e);
                    --this.onDeckSearchers;
                    this.searcherLock.notifyAll();
                    if ($assertionsDisabled || TestInjection.injectSearcherHooks(this.getCoreDescriptor() != null && this.getCoreDescriptor().getCloudDescriptor() != null ? this.getCoreDescriptor().getCloudDescriptor().getCollectionName() : null)) return;
                }
                catch (Throwable throwable) {
                    --this.onDeckSearchers;
                    this.searcherLock.notifyAll();
                    if ($assertionsDisabled || TestInjection.injectSearcherHooks(this.getCoreDescriptor() != null && this.getCoreDescriptor().getCloudDescriptor() != null ? this.getCoreDescriptor().getCloudDescriptor().getCollectionName() : null)) throw throwable;
                    throw new AssertionError();
                }
                throw new AssertionError();
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSearcher() {
        log.debug("{}Closing main searcher on request.", (Object)this.logid);
        Object object = this.searcherLock;
        synchronized (object) {
            if (this.realtimeSearcher != null) {
                this.realtimeSearcher.decref();
                this.realtimeSearcher = null;
            }
            if (this._searcher != null) {
                this._searcher.decref();
                this._searcher = null;
            }
        }
    }

    public void execute(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        if (handler == null) {
            String msg = "Null Request Handler '" + req.getParams().get("qt") + "'";
            log.warn("{}{}:{}", new Object[]{this.logid, msg, req});
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        SolrCore.preDecorateResponse(req, rsp);
        if (requestLog.isDebugEnabled() && rsp.getToLog().size() > 0) {
            requestLog.debug(rsp.getToLogAsString(this.logid));
        }
        handler.handleRequest(req, rsp);
        SolrCore.postDecorateResponse(handler, req, rsp);
        if (rsp.getToLog().size() > 0) {
            long qtime;
            if (requestLog.isInfoEnabled()) {
                requestLog.info(rsp.getToLogAsString(this.logid));
            }
            if (log.isWarnEnabled() && this.slowQueryThresholdMillis >= 0 && (qtime = (long)req.getRequestTimer().getTime()) >= (long)this.slowQueryThresholdMillis) {
                slowLog.warn("slow: {}", (Object)rsp.getToLogAsString(this.logid));
            }
        }
    }

    public static void preDecorateResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        rsp.addResponseHeader((NamedList<Object>)responseHeader);
        NamedList<Object> toLog = rsp.getToLog();
        toLog.add("webapp", req.getContext().get("webapp"));
        toLog.add("path", req.getContext().get("path"));
        final SolrParams params = req.getParams();
        String lpList = params.get("logParamsList");
        if (lpList == null) {
            toLog.add("params", (Object)("{" + req.getParamString() + "}"));
        } else if (lpList.length() > 0) {
            final HashSet<String> lpSet = new HashSet<String>(Arrays.asList(lpList.split(",")));
            SolrParams filteredParams = new SolrParams(){
                private static final long serialVersionUID = -643991638344314066L;

                public Iterator<String> getParameterNamesIterator() {
                    return Iterators.filter((Iterator)params.getParameterNamesIterator(), lpSet::contains);
                }

                public String get(String param) {
                    return params.get(param);
                }

                public String[] getParams(String param) {
                    return params.getParams(param);
                }
            };
            toLog.add("params", (Object)("{" + filteredParams + "}"));
        }
    }

    public static void postDecorateResponse(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        String ep;
        NamedList<Object> responseHeader = rsp.getResponseHeader();
        int qtime = (int)req.getRequestTimer().getTime();
        int status = 0;
        Exception exception = rsp.getException();
        if (exception != null) {
            status = exception instanceof SolrException ? ((SolrException)((Object)exception)).code() : 500;
        }
        responseHeader.add("status", (Object)status);
        responseHeader.add("QTime", (Object)qtime);
        if (rsp.getToLog().size() > 0) {
            rsp.getToLog().add("status", (Object)status);
            rsp.getToLog().add("QTime", (Object)qtime);
        }
        SolrParams params = req.getParams();
        if (null != handler && params.getBool("echoHandler", false)) {
            responseHeader.add("handler", (Object)handler.getName());
        }
        if ((ep = params.get("echoParams", null)) != null) {
            CommonParams.EchoParamStyle echoParams = CommonParams.EchoParamStyle.get((String)ep);
            if (echoParams == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value '" + ep + "' for " + "echoParams" + " parameter, use '" + CommonParams.EchoParamStyle.EXPLICIT + "' or '" + CommonParams.EchoParamStyle.ALL + "'");
            }
            if (echoParams == CommonParams.EchoParamStyle.EXPLICIT) {
                responseHeader.add("params", (Object)req.getOriginalParams().toNamedList());
            } else if (echoParams == CommonParams.EchoParamStyle.ALL) {
                responseHeader.add("params", (Object)req.getParams().toNamedList());
            }
        }
    }

    public static final void log(Throwable e) {
        SolrException.log((Logger)log, null, (Throwable)e);
    }

    public PluginBag<QueryResponseWriter> getResponseWriters() {
        return this.responseWriters;
    }

    private static BinaryResponseWriter getFileStreamWriter() {
        return new BinaryResponseWriter(){

            @Override
            public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
                RawWriter rawWriter = (RawWriter)response.getValues().get("filestream");
                if (rawWriter != null) {
                    rawWriter.write(out);
                    if (rawWriter instanceof Closeable) {
                        ((Closeable)((Object)rawWriter)).close();
                    }
                }
            }

            @Override
            public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
                RawWriter rawWriter = (RawWriter)response.getValues().get("filestream");
                if (rawWriter != null) {
                    return rawWriter.getContentType();
                }
                return "application/octet-stream";
            }
        };
    }

    public MemClassLoader getMemClassLoader() {
        return this.memClassLoader;
    }

    public void fetchLatestSchema() {
        IndexSchema schema = this.configSet.getIndexSchema(true);
        this.setLatestSchema(schema);
    }

    private void initWriters() {
        this.responseWriters.init(DEFAULT_RESPONSE_WRITERS, this);
        if (this.responseWriters.getDefault() == null) {
            this.responseWriters.setDefault("standard");
        }
    }

    public final QueryResponseWriter getQueryResponseWriter(String writerName) {
        return this.responseWriters.get(writerName, true);
    }

    public final QueryResponseWriter getQueryResponseWriter(SolrQueryRequest request) {
        return this.getQueryResponseWriter(request.getParams().get("wt"));
    }

    public QParserPlugin getQueryPlugin(String parserName) {
        return this.qParserPlugins.get(parserName);
    }

    <T> Map<String, T> createInstances(Map<String, Class<? extends T>> map) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(map.size(), 1.0f);
        for (Map.Entry<String, Class<T>> e : map.entrySet()) {
            try {
                T o = this.getResourceLoader().newInstance(e.getValue().getName(), e.getValue());
                result.put(e.getKey(), o);
            }
            catch (Exception exp) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to instantiate class", (Throwable)exp);
            }
        }
        return result;
    }

    public TransformerFactory getTransformerFactory(String name) {
        return this.transformerFactories.get(name);
    }

    public void addTransformerFactory(String name, TransformerFactory factory) {
        this.transformerFactories.put(name, factory);
    }

    private <T> T initPlugins(Map<String, T> registry, Class<T> type, String defClassName) {
        return this.initPlugins(this.solrConfig.getPluginInfos(type.getName()), registry, type, defClassName);
    }

    public <T> T initPlugins(List<PluginInfo> pluginInfos, Map<String, T> registry, Class<T> type, String defClassName) {
        T def = null;
        for (PluginInfo info : pluginInfos) {
            T o = this.createInitInstance(info, type, type.getSimpleName(), defClassName);
            registry.put(info.name, o);
            if (o instanceof SolrMetricProducer) {
                this.coreMetricManager.registerMetricProducer(type.getSimpleName() + "." + info.name, (SolrMetricProducer)o);
            }
            if (!info.isDefault()) continue;
            def = o;
        }
        return def;
    }

    public void initDefaultPlugin(Object plugin, Class type) {
        if (plugin instanceof SolrMetricProducer) {
            this.coreMetricManager.registerMetricProducer(type.getSimpleName() + ".default", (SolrMetricProducer)plugin);
        }
    }

    public <T> List<T> initPlugins(List<PluginInfo> pluginInfos, Class<T> type, String defClassName) {
        if (pluginInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(pluginInfos.size());
        for (PluginInfo info : pluginInfos) {
            result.add(this.createInitInstance(info, type, type.getSimpleName(), defClassName));
        }
        return result;
    }

    public <T> T initPlugins(Map<String, T> registry, Class<T> type) {
        return this.initPlugins(registry, type, null);
    }

    public ValueSourceParser getValueSourceParser(String parserName) {
        return this.valueSourceParsers.get(parserName);
    }

    protected RestManager initRestManager() throws SolrException {
        PluginInfo restManagerPluginInfo = this.getSolrConfig().getPluginInfo(RestManager.class.getName());
        NamedList initArgs = null;
        RestManager mgr = null;
        if (restManagerPluginInfo != null) {
            if (restManagerPluginInfo.className != null) {
                mgr = this.resourceLoader.newInstance(restManagerPluginInfo.className, RestManager.class);
            }
            if (restManagerPluginInfo.initArgs != null) {
                initArgs = restManagerPluginInfo.initArgs;
            }
        }
        if (mgr == null) {
            mgr = new RestManager();
        }
        if (initArgs == null) {
            initArgs = new NamedList();
        }
        String collection = this.getCoreDescriptor().getCollectionName();
        ManagedResourceStorage.StorageIO storageIO = ManagedResourceStorage.newStorageIO(collection, this.resourceLoader, (NamedList<String>)initArgs);
        mgr.init(this.resourceLoader, (NamedList<String>)initArgs, storageIO);
        return mgr;
    }

    public CoreDescriptor getCoreDescriptor() {
        return this.coreDescriptor;
    }

    public IndexDeletionPolicyWrapper getDeletionPolicy() {
        return this.solrDelPolicy;
    }

    public SolrSnapshotMetaDataManager getSnapshotMetaDataManager() {
        return this.snapshotMgr;
    }

    public ReentrantLock getRuleExpiryLock() {
        return this.ruleExpiryLock;
    }

    @Override
    public String getDescription() {
        return "SolrCore";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.CORE;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.coreMetricManager.getRegistry();
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void unloadOnClose(final CoreDescriptor desc, boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        if (deleteIndexDir) {
            try {
                this.directoryFactory.remove(this.getIndexDir());
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Failed to flag index dir for removal for core:" + this.name + " dir:" + this.getIndexDir()));
            }
        }
        if (deleteDataDir) {
            try {
                this.directoryFactory.remove(this.getDataDir(), true);
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Failed to flag data dir for removal for core:" + this.name + " dir:" + this.getDataDir()));
            }
        }
        if (deleteInstanceDir) {
            this.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                }

                @Override
                public void postClose(SolrCore core) {
                    if (desc != null) {
                        try {
                            FileUtils.deleteDirectory((File)desc.getInstanceDir().toFile());
                        }
                        catch (IOException e) {
                            SolrException.log((Logger)log, (String)("Failed to delete instance dir for core:" + core.getName() + " dir:" + desc.getInstanceDir()));
                        }
                    }
                }
            });
        }
    }

    public static void deleteUnloadedCore(CoreDescriptor cd, boolean deleteDataDir, boolean deleteInstanceDir) {
        if (deleteDataDir) {
            File dataDir = cd.getInstanceDir().resolve(cd.getDataDir()).toFile();
            try {
                FileUtils.deleteDirectory((File)dataDir);
            }
            catch (IOException e) {
                log.error("Failed to delete data dir for unloaded core: {} dir: {}", new Object[]{cd.getName(), dataDir.getAbsolutePath(), e});
            }
        }
        if (deleteInstanceDir) {
            try {
                FileUtils.deleteDirectory((File)cd.getInstanceDir().toFile());
            }
            catch (IOException e) {
                log.error("Failed to delete instance dir for unloaded core: {} dir: {}", new Object[]{cd.getName(), cd.getInstanceDir(), e});
            }
        }
    }

    public void addConfListener(Runnable runnable) {
        this.confListeners.add(runnable);
    }

    public boolean removeConfListener(Runnable runnable) {
        return this.confListeners.remove(runnable);
    }

    private void registerConfListener() {
        if (!(this.resourceLoader instanceof ZkSolrResourceLoader)) {
            return;
        }
        ZkSolrResourceLoader zkSolrResourceLoader = (ZkSolrResourceLoader)this.resourceLoader;
        if (zkSolrResourceLoader != null) {
            zkSolrResourceLoader.getZkController().registerConfListenerForCore(zkSolrResourceLoader.getConfigSetZkPath(), this, SolrCore.getConfListener(this, zkSolrResourceLoader));
        }
    }

    public static Runnable getConfListener(SolrCore core, ZkSolrResourceLoader zkSolrResourceLoader) {
        String coreName = core.getName();
        UUID coreId = core.uniqueId;
        CoreContainer cc = core.getCoreContainer();
        String overlayPath = zkSolrResourceLoader.getConfigSetZkPath() + "/" + "configoverlay.json";
        String solrConfigPath = zkSolrResourceLoader.getConfigSetZkPath() + "/" + core.getSolrConfig().getName();
        String schemaRes = null;
        if (core.getLatestSchema().isMutable() && core.getLatestSchema() instanceof ManagedIndexSchema) {
            ManagedIndexSchema mis = (ManagedIndexSchema)core.getLatestSchema();
            schemaRes = mis.getResourceName();
        }
        String managedSchmaResourcePath = schemaRes == null ? null : zkSolrResourceLoader.getConfigSetZkPath() + "/" + schemaRes;
        return () -> {
            int overlayVersion;
            int solrConfigversion;
            log.info("config update listener called for core {}", (Object)coreName);
            SolrZkClient zkClient = cc.getZkController().getZkClient();
            int managedSchemaVersion = 0;
            SolrConfig cfg = null;
            try (SolrCore solrCore = cc.solrCores.getCoreFromAnyList(coreName, true, coreId);){
                if (solrCore == null || solrCore.isClosed() || solrCore.getCoreContainer().isShutDown()) {
                    return;
                }
                cfg = solrCore.getSolrConfig();
                solrConfigversion = solrCore.getSolrConfig().getOverlay().getZnodeVersion();
                overlayVersion = solrCore.getSolrConfig().getZnodeVersion();
                if (managedSchmaResourcePath != null) {
                    managedSchemaVersion = ((ManagedIndexSchema)solrCore.getLatestSchema()).getSchemaZkVersion();
                }
            }
            if (cfg != null) {
                cfg.refreshRequestParams();
            }
            if (SolrCore.checkStale(zkClient, overlayPath, solrConfigversion) || SolrCore.checkStale(zkClient, solrConfigPath, overlayVersion) || SolrCore.checkStale(zkClient, managedSchmaResourcePath, managedSchemaVersion)) {
                log.info("core reload {}", (Object)coreName);
                SolrConfigHandler configHandler = (SolrConfigHandler)core.getRequestHandler("/config");
                if (configHandler.getReloadLock().tryLock()) {
                    try {
                        cc.reload(coreName, coreId);
                    }
                    catch (SolrCoreState.CoreIsClosedException coreIsClosedException) {
                    }
                    finally {
                        configHandler.getReloadLock().unlock();
                    }
                } else {
                    log.info("Another reload is in progress. Not doing anything.");
                }
                return;
            }
            solrCore = cc.solrCores.getCoreFromAnyList(coreName, true, coreId);
            try {
                if (solrCore == null || solrCore.isClosed() || cc.isShutDown()) {
                    return;
                }
                for (Runnable listener : solrCore.confListeners) {
                    try {
                        listener.run();
                    }
                    catch (Exception e) {
                        log.error("Error in listener ", (Throwable)e);
                    }
                }
            }
            finally {
                if (solrCore != null) {
                    solrCore.close();
                }
            }
        };
    }

    public void registerInfoBean(String name, SolrInfoBean solrInfoBean) {
        this.infoRegistry.put(name, solrInfoBean);
        if (solrInfoBean instanceof SolrMetricProducer) {
            SolrMetricProducer producer = (SolrMetricProducer)((Object)solrInfoBean);
            this.coreMetricManager.registerMetricProducer(name, producer);
        }
    }

    private static boolean checkStale(SolrZkClient zkClient, String zkPath, int currentVersion) {
        if (zkPath == null) {
            return false;
        }
        try {
            Stat stat = zkClient.exists(zkPath, null, true);
            if (stat == null) {
                return currentVersion > -1;
            }
            if (stat.getVersion() > currentVersion) {
                if (log.isDebugEnabled()) {
                    log.debug("{} is stale will need an update from {} to {}", new Object[]{zkPath, currentVersion, stat.getVersion()});
                }
                return true;
            }
            return false;
        }
        catch (KeeperException.NoNodeException stat) {
        }
        catch (KeeperException e) {
            log.error("error refreshing solrconfig ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public void cleanupOldIndexDirectories(boolean reload) {
        DirectoryFactory myDirFactory = this.getDirectoryFactory();
        String myDataDir = this.getDataDir();
        String myIndexDir = this.getNewIndexDir();
        String coreName = this.getName();
        if (myDirFactory != null && myDataDir != null && myIndexDir != null) {
            Thread cleanupThread = new Thread(() -> {
                log.debug("Looking for old index directories to cleanup for core {} in {}", (Object)coreName, (Object)myDataDir);
                try {
                    myDirFactory.cleanupOldIndexDirectories(myDataDir, myIndexDir, reload);
                }
                catch (Exception exc) {
                    log.error("Failed to cleanup old index directories for core {}", (Object)coreName, (Object)exc);
                }
            }, "OldIndexDirectoryCleanupThreadForCore-" + coreName);
            cleanupThread.setDaemon(true);
            cleanupThread.start();
        }
    }

    public List<PluginInfo> getImplicitHandlers() {
        ArrayList<PluginInfo> implicits = new ArrayList<PluginInfo>();
        Map requestHandlers = (Map)implicitPluginsInfo.get("requestHandler");
        Iterator iterator = requestHandlers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            Map info = Utils.getDeepCopy((Map)((Map)entry.getValue()), (int)4);
            info.put("name", entry.getKey());
            implicits.add(new PluginInfo("requestHandler", info));
        }
        return implicits;
    }

    public BlobRepository.BlobContentRef loadDecodeAndCacheBlob(String key, BlobRepository.Decoder<Object> decoder) {
        if (!BlobRepository.BLOB_KEY_PATTERN_CHECKER.matcher(key).matches()) {
            throw new IllegalArgumentException("invalid key format, must end in /N where N is the version number");
        }
        final BlobRepository.BlobContentRef<Object> blobRef = this.coreContainer.getBlobRepository().getBlobIncRef(key, decoder);
        this.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
            }

            @Override
            public void postClose(SolrCore core) {
                SolrCore.this.coreContainer.getBlobRepository().decrementBlobRefCount(blobRef);
            }
        });
        return blobRef;
    }

    public void runAsync(Runnable r) {
        this.coreAsyncTaskExecutor.submit(r);
    }

    static {
        HashMap<String, QueryResponseWriter> m = new HashMap<String, QueryResponseWriter>(15, 1.0f);
        m.put("xml", new XMLResponseWriter());
        m.put("json", new JSONResponseWriter());
        m.put("standard", (QueryResponseWriter)m.get("json"));
        m.put("geojson", new GeoJSONResponseWriter());
        m.put("graphml", new GraphMLResponseWriter());
        m.put("python", new PythonResponseWriter());
        m.put("php", new PHPResponseWriter());
        m.put("phps", new PHPSerializedResponseWriter());
        m.put("ruby", new RubyResponseWriter());
        m.put("raw", new RawResponseWriter());
        m.put("javabin", new BinaryResponseWriter());
        m.put("csv", new CSVResponseWriter());
        m.put("schema.xml", new SchemaXmlResponseWriter());
        m.put("smile", new SmileResponseWriter());
        m.put("filestream", SolrCore.getFileStreamWriter());
        DEFAULT_RESPONSE_WRITERS = Collections.unmodifiableMap(m);
        try {
            m.put("xlsx", (QueryResponseWriter)Class.forName("org.apache.solr.handler.extraction.XLSXResponseWriter").newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        implicitPluginsInfo = (Map)Utils.fromJSONResource((String)"ImplicitPlugins.json");
    }

    public static interface RawWriter {
        default public String getContentType() {
            return "application/octet-stream";
        }

        public void write(OutputStream var1) throws IOException;
    }
}

