/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.params.ShardParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommandResult;
import org.apache.solr.search.grouping.distributed.shardresultserializer.SearchGroupsResultTransformer;

public class SearchGroupShardResponseProcessor
implements ShardResponseProcessor {
    @Override
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        SortSpec groupSortSpec = rb.getGroupingSpec().getGroupSortSpec();
        Sort groupSort = rb.getGroupingSpec().getGroupSortSpec().getSort();
        String[] fields = rb.getGroupingSpec().getFields();
        Sort withinGroupSort = rb.getGroupingSpec().getWithinGroupSortSpec().getSort();
        assert (withinGroupSort != null);
        HashMap commandSearchGroups = new HashMap(fields.length, 1.0f);
        HashMap tempSearchGroupToShards = new HashMap(fields.length, 1.0f);
        for (String field : fields) {
            commandSearchGroups.put(field, new ArrayList(shardRequest.responses.size()));
            tempSearchGroupToShards.put(field, new HashMap());
            if (rb.searchGroupToShards.containsKey(field)) continue;
            rb.searchGroupToShards.put(field, new HashMap());
        }
        SearchGroupsResultTransformer serializer = new SearchGroupsResultTransformer(rb.req.getSearcher());
        int maxElapsedTime = 0;
        int hitCountDuringFirstPhase = 0;
        SimpleOrderedMap shardInfo = null;
        if (rb.req.getParams().getBool("shards.info", false)) {
            shardInfo = new SimpleOrderedMap(shardRequest.responses.size());
            rb.rsp.getValues().add("shards.info.firstPhase", (Object)shardInfo);
        }
        for (ShardResponse shardResponse : shardRequest.responses) {
            if (shardInfo != null) {
                SimpleOrderedMap nl = new SimpleOrderedMap(4);
                if (shardResponse.getException() != null) {
                    Throwable t = shardResponse.getException();
                    if (t instanceof SolrServerException) {
                        t = ((SolrServerException)t).getCause();
                    }
                    nl.add("error", (Object)t.toString());
                    StringWriter trace = new StringWriter();
                    t.printStackTrace(new PrintWriter(trace));
                    nl.add("trace", (Object)trace.toString());
                } else {
                    nl.add("numFound", (Object)((Integer)shardResponse.getSolrResponse().getResponse().get("totalHitCount")));
                }
                if (shardResponse.getSolrResponse() != null) {
                    nl.add("time", (Object)shardResponse.getSolrResponse().getElapsedTime());
                }
                if (shardResponse.getShardAddress() != null) {
                    nl.add("shardAddress", (Object)shardResponse.getShardAddress());
                }
                shardInfo.add(shardResponse.getShard(), (Object)nl);
            }
            if (ShardParams.getShardsTolerantAsBool((SolrParams)rb.req.getParams()) && shardResponse.getException() != null) {
                rb.rsp.getResponseHeader().asShallowMap().put("partialResults", Boolean.TRUE);
                continue;
            }
            maxElapsedTime = (int)Math.max((long)maxElapsedTime, shardResponse.getSolrResponse().getElapsedTime());
            NamedList firstPhaseResult = (NamedList)shardResponse.getSolrResponse().getResponse().get("firstPhase");
            Object result = serializer.transformToNative(firstPhaseResult, groupSort, withinGroupSort, shardResponse.getShard());
            for (Map.Entry entry : commandSearchGroups.entrySet()) {
                Collection<SearchGroup<BytesRef>> searchGroups;
                String field = (String)entry.getKey();
                SearchGroupsFieldCommandResult firstPhaseCommandResult = (SearchGroupsFieldCommandResult)result.get(field);
                Integer groupCount = firstPhaseCommandResult.getGroupCount();
                if (groupCount != null) {
                    Integer existingGroupCount = rb.mergedGroupCounts.get(field);
                    rb.mergedGroupCounts.put(field, existingGroupCount != null ? Integer.valueOf(existingGroupCount + groupCount) : groupCount);
                }
                if ((searchGroups = firstPhaseCommandResult.getSearchGroups()) == null) continue;
                ((List)entry.getValue()).add(searchGroups);
                for (SearchGroup<BytesRef> searchGroup : searchGroups) {
                    Map map = (Map)tempSearchGroupToShards.get(field);
                    HashSet<String> shards = (HashSet<String>)map.get(searchGroup);
                    if (shards == null) {
                        shards = new HashSet<String>();
                        map.put(searchGroup, shards);
                    }
                    shards.add(shardResponse.getShard());
                }
            }
            hitCountDuringFirstPhase += ((Integer)shardResponse.getSolrResponse().getResponse().get("totalHitCount")).intValue();
        }
        rb.totalHitCount = hitCountDuringFirstPhase;
        rb.firstPhaseElapsedTime = maxElapsedTime;
        for (Map.Entry entry : commandSearchGroups.entrySet()) {
            String groupField = (String)entry.getKey();
            List topGroups = (List)entry.getValue();
            Collection mergedTopGroups = SearchGroup.merge((List)topGroups, (int)groupSortSpec.getOffset(), (int)groupSortSpec.getCount(), (Sort)groupSort);
            if (mergedTopGroups == null) continue;
            rb.mergedSearchGroups.put(groupField, mergedTopGroups);
            for (SearchGroup mergedTopGroup : mergedTopGroups) {
                rb.searchGroupToShards.get(groupField).put((SearchGroup<BytesRef>)mergedTopGroup, (Set)((Map)tempSearchGroupToShards.get(groupField)).get(mergedTopGroup));
            }
        }
    }
}

