/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ShortCircuitReplica {
    public static final Logger LOG = LoggerFactory.getLogger(ShortCircuitCache.class);
    final ExtendedBlockId key;
    private final FileInputStream dataStream;
    private final FileInputStream metaStream;
    private final BlockMetadataHeader metaHeader;
    private final ShortCircuitCache cache;
    private final long creationTimeMs;
    private final ShortCircuitShm.Slot slot;
    Object mmapData;
    boolean purged = false;
    int refCount = 2;
    private Long evictableTimeNs = null;

    public ShortCircuitReplica(ExtendedBlockId key, FileInputStream dataStream, FileInputStream metaStream, ShortCircuitCache cache, long creationTimeMs, ShortCircuitShm.Slot slot) throws IOException {
        this.key = key;
        this.dataStream = dataStream;
        this.metaStream = metaStream;
        this.metaHeader = BlockMetadataHeader.preadHeader(metaStream.getChannel());
        if (this.metaHeader.getVersion() != 1) {
            throw new IOException("invalid metadata header version " + this.metaHeader.getVersion() + ".  Can only handle version 1.");
        }
        this.cache = cache;
        this.creationTimeMs = creationTimeMs;
        this.slot = slot;
    }

    public void unref() {
        this.cache.unref(this);
    }

    boolean isStale() {
        long staleThresholdMs;
        if (this.slot != null) {
            boolean stale = !this.slot.isValid();
            LOG.trace("{}: checked shared memory segment.  isStale={}", (Object)this, (Object)stale);
            return stale;
        }
        long deltaMs = Time.monotonicNow() - this.creationTimeMs;
        if (deltaMs > (staleThresholdMs = this.cache.getStaleThresholdMs())) {
            LOG.trace("{} is stale because it's {} ms old and staleThreadholdMS={}", new Object[]{this, deltaMs, staleThresholdMs});
            return true;
        }
        LOG.trace("{} is not stale because it's only {} ms old and staleThresholdMs={}", new Object[]{this, deltaMs, staleThresholdMs});
        return false;
    }

    public boolean addNoChecksumAnchor() {
        if (this.slot == null) {
            return false;
        }
        boolean result = this.slot.addAnchor();
        LOG.trace("{}: {} no-checksum anchor to slot {}", new Object[]{this, result ? "added" : "could not add", this.slot});
        return result;
    }

    public void removeNoChecksumAnchor() {
        if (this.slot != null) {
            this.slot.removeAnchor();
        }
    }

    @VisibleForTesting
    public boolean hasMmap() {
        return this.mmapData != null && this.mmapData instanceof MappedByteBuffer;
    }

    void munmap() {
        MappedByteBuffer mmap = (MappedByteBuffer)this.mmapData;
        NativeIO.POSIX.munmap((MappedByteBuffer)mmap);
        this.mmapData = null;
    }

    void close() {
        String suffix = "";
        Preconditions.checkState((this.refCount == 0 ? 1 : 0) != 0, (String)"tried to close replica with refCount %d: %s", (Object[])new Object[]{this.refCount, this});
        this.refCount = -1;
        Preconditions.checkState((boolean)this.purged, (String)"tried to close unpurged replica %s", (Object[])new Object[]{this});
        if (this.hasMmap()) {
            this.munmap();
            if (LOG.isTraceEnabled()) {
                suffix = suffix + "  munmapped.";
            }
        }
        IOUtilsClient.cleanupWithLogger(LOG, this.dataStream, this.metaStream);
        if (this.slot != null) {
            this.cache.scheduleSlotReleaser(this.slot);
            if (LOG.isTraceEnabled()) {
                suffix = suffix + "  scheduling " + this.slot + " for later release.";
            }
        }
        LOG.trace("closed {}{}", (Object)this, (Object)suffix);
    }

    public FileInputStream getDataStream() {
        return this.dataStream;
    }

    public FileInputStream getMetaStream() {
        return this.metaStream;
    }

    public BlockMetadataHeader getMetaHeader() {
        return this.metaHeader;
    }

    public ExtendedBlockId getKey() {
        return this.key;
    }

    public ClientMmap getOrCreateClientMmap(boolean anchor) {
        return this.cache.getOrCreateClientMmap(this, anchor);
    }

    MappedByteBuffer loadMmapInternal() {
        try {
            FileChannel channel = this.dataStream.getChannel();
            MappedByteBuffer mmap = channel.map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(Integer.MAX_VALUE, channel.size()));
            LOG.trace("{}: created mmap of size {}", (Object)this, (Object)channel.size());
            return mmap;
        }
        catch (IOException e) {
            LOG.warn(this + ": mmap error", (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            LOG.warn(this + ": mmap error", (Throwable)e);
            return null;
        }
    }

    public Long getEvictableTimeNs() {
        return this.evictableTimeNs;
    }

    void setEvictableTimeNs(Long evictableTimeNs) {
        this.evictableTimeNs = evictableTimeNs;
    }

    @VisibleForTesting
    public ShortCircuitShm.Slot getSlot() {
        return this.slot;
    }

    public String toString() {
        return "ShortCircuitReplica{key=" + this.key + ", metaHeader.version=" + this.metaHeader.getVersion() + ", metaHeader.checksum=" + this.metaHeader.getChecksum() + ", ident=0x" + Integer.toHexString(System.identityHashCode(this)) + ", creationTimeMs=" + this.creationTimeMs + "}";
    }
}

