/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermStatistics;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public abstract class StatsCache
implements PluginInfoInitialized {
    public static final String TERM_STATS_KEY = "solr.stats.term";
    public static final String COL_STATS_KEY = "solr.stats.col";
    public static final String TERMS_KEY = "solr.stats.terms";
    public static final String FIELDS_KEY = "solr.stats.fields";
    protected StatsCacheMetrics statsCacheMetrics = new StatsCacheMetrics();
    protected PluginInfo pluginInfo;

    public StatsCacheMetrics getCacheMetrics() {
        return this.statsCacheMetrics;
    }

    @Override
    public void init(PluginInfo info) {
        this.pluginInfo = info;
    }

    public ShardRequest retrieveStatsRequest(ResponseBuilder rb) {
        this.statsCacheMetrics.retrieveStats.increment();
        return this.doRetrieveStatsRequest(rb);
    }

    protected abstract ShardRequest doRetrieveStatsRequest(ResponseBuilder var1);

    public void returnLocalStats(ResponseBuilder rb, SolrIndexSearcher searcher) {
        this.statsCacheMetrics.returnLocalStats.increment();
        this.doReturnLocalStats(rb, searcher);
    }

    protected abstract void doReturnLocalStats(ResponseBuilder var1, SolrIndexSearcher var2);

    public void mergeToGlobalStats(SolrQueryRequest req, List<ShardResponse> responses) {
        this.statsCacheMetrics.mergeToGlobalStats.increment();
        this.doMergeToGlobalStats(req, responses);
    }

    protected abstract void doMergeToGlobalStats(SolrQueryRequest var1, List<ShardResponse> var2);

    public void receiveGlobalStats(SolrQueryRequest req) {
        this.statsCacheMetrics.receiveGlobalStats.increment();
        this.doReceiveGlobalStats(req);
    }

    protected abstract void doReceiveGlobalStats(SolrQueryRequest var1);

    public void sendGlobalStats(ResponseBuilder rb, ShardRequest outgoing) {
        this.statsCacheMetrics.sendGlobalStats.increment();
        this.doSendGlobalStats(rb, outgoing);
    }

    protected abstract void doSendGlobalStats(ResponseBuilder var1, ShardRequest var2);

    public StatsSource get(SolrQueryRequest req) {
        this.statsCacheMetrics.lookups.increment();
        return this.doGet(req);
    }

    protected abstract StatsSource doGet(SolrQueryRequest var1);

    public void clear() {
        this.statsCacheMetrics.clear();
    }

    public int approxCheckMissingStats(ResponseBuilder rb, StatsSource statsSource, Consumer<Term> missingTermStats, Consumer<String> missingFieldStats) throws IOException {
        CheckingIndexSearcher checkingSearcher = new CheckingIndexSearcher(statsSource, (IndexReader)rb.req.getSearcher().getIndexReader(), missingTermStats, missingFieldStats);
        Query q = rb.getQuery();
        q = checkingSearcher.rewrite(q);
        checkingSearcher.createWeight(q, ScoreMode.COMPLETE, 1.0f);
        return checkingSearcher.missingFieldsCount + checkingSearcher.missingTermsCount;
    }

    public static final class StatsCacheMetrics {
        public final LongAdder lookups = new LongAdder();
        public final LongAdder retrieveStats = new LongAdder();
        public final LongAdder receiveGlobalStats = new LongAdder();
        public final LongAdder returnLocalStats = new LongAdder();
        public final LongAdder mergeToGlobalStats = new LongAdder();
        public final LongAdder sendGlobalStats = new LongAdder();
        public final LongAdder useCachedGlobalStats = new LongAdder();
        public final LongAdder missingGlobalTermStats = new LongAdder();
        public final LongAdder missingGlobalFieldStats = new LongAdder();

        public void clear() {
            this.lookups.reset();
            this.retrieveStats.reset();
            this.receiveGlobalStats.reset();
            this.returnLocalStats.reset();
            this.mergeToGlobalStats.reset();
            this.sendGlobalStats.reset();
            this.useCachedGlobalStats.reset();
            this.missingGlobalTermStats.reset();
            this.missingGlobalFieldStats.reset();
        }

        public void getSnapshot(BiConsumer<String, Object> consumer) {
            consumer.accept("lookups", this.lookups.longValue());
            consumer.accept("retrieveStats", this.retrieveStats.longValue());
            consumer.accept("receiveGlobalStats", this.receiveGlobalStats.longValue());
            consumer.accept("returnLocalStats", this.returnLocalStats.longValue());
            consumer.accept("mergeToGlobalStats", this.mergeToGlobalStats.longValue());
            consumer.accept("sendGlobalStats", this.sendGlobalStats.longValue());
            consumer.accept("useCachedGlobalStats", this.useCachedGlobalStats.longValue());
            consumer.accept("missingGlobalTermStats", this.missingGlobalTermStats.longValue());
            consumer.accept("missingGlobalFieldStats", this.missingGlobalFieldStats.longValue());
        }

        public String toString() {
            HashMap map = new HashMap();
            this.getSnapshot(map::put);
            return ((Object)map).toString();
        }
    }

    static final class CheckingIndexSearcher
    extends IndexSearcher {
        final StatsSource statsSource;
        final Consumer<Term> missingTermStats;
        final Consumer<String> missingFieldStats;
        int missingTermsCount;
        int missingFieldsCount;

        CheckingIndexSearcher(StatsSource statsSource, IndexReader reader, Consumer<Term> missingTermStats, Consumer<String> missingFieldStats) {
            super(reader);
            this.statsSource = statsSource;
            this.missingTermStats = missingTermStats;
            this.missingFieldStats = missingFieldStats;
        }

        public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
            if (this.statsSource.termStatistics(null, term, docFreq, totalTermFreq) == null) {
                this.missingTermStats.accept(term);
                ++this.missingTermsCount;
            }
            return super.termStatistics(term, docFreq, totalTermFreq);
        }

        public CollectionStatistics collectionStatistics(String field) throws IOException {
            if (this.statsSource.collectionStatistics(null, field) == null) {
                this.missingFieldStats.accept(field);
                ++this.missingFieldsCount;
            }
            return super.collectionStatistics(field);
        }
    }
}

