/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.reduction.DateMedianFunction;
import org.apache.solr.analytics.function.reduction.DoubleMedianFunction;
import org.apache.solr.analytics.function.reduction.FloatMedianFunction;
import org.apache.solr.analytics.function.reduction.IntMedianFunction;
import org.apache.solr.analytics.function.reduction.LongMedianFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

public class MedianFunction {
    public static final String name = "median";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The median function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof DateValueStream) {
            return new DateMedianFunction((DateValueStream)param);
        }
        if (param instanceof IntValueStream) {
            return new IntMedianFunction((IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return new LongMedianFunction((LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return new FloatMedianFunction((FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleMedianFunction((DoubleValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The median function requires a date or numeric parameter.");
    };
}

