/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Connection;
import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointInfo;
import com.zeroc.Ice.IPConnectionInfo;
import com.zeroc.Ice.IPEndpointInfo;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.Instrumentation.CommunicatorObserver;
import com.zeroc.Ice.Instrumentation.ConnectionObserver;
import com.zeroc.Ice.Instrumentation.ConnectionState;
import com.zeroc.Ice.Instrumentation.DispatchObserver;
import com.zeroc.Ice.Instrumentation.InvocationObserver;
import com.zeroc.Ice.Instrumentation.Observer;
import com.zeroc.Ice.Instrumentation.ObserverUpdater;
import com.zeroc.Ice.Instrumentation.ThreadObserver;
import com.zeroc.Ice.Instrumentation.ThreadState;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.UDPConnectionInfo;
import com.zeroc.Ice.Util;
import com.zeroc.IceInternal.ConnectionObserverI;
import com.zeroc.IceInternal.DispatchObserverI;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.InvocationObserverI;
import com.zeroc.IceInternal.MetricsAdminI;
import com.zeroc.IceInternal.ThreadObserverI;
import com.zeroc.IceMX.CollocatedMetrics;
import com.zeroc.IceMX.ConnectionMetrics;
import com.zeroc.IceMX.DispatchMetrics;
import com.zeroc.IceMX.InvocationMetrics;
import com.zeroc.IceMX.Metrics;
import com.zeroc.IceMX.MetricsHelper;
import com.zeroc.IceMX.ObserverFactoryWithDelegate;
import com.zeroc.IceMX.ObserverWithDelegateI;
import com.zeroc.IceMX.RemoteMetrics;
import com.zeroc.IceMX.ThreadMetrics;
import java.util.Map;

public class CommunicatorObserverI
implements CommunicatorObserver {
    private final MetricsAdminI _metrics;
    private final CommunicatorObserver _delegate;
    private final ObserverFactoryWithDelegate<ConnectionMetrics, ConnectionObserverI, ConnectionObserver> _connections;
    private final ObserverFactoryWithDelegate<DispatchMetrics, DispatchObserverI, DispatchObserver> _dispatch;
    private final ObserverFactoryWithDelegate<InvocationMetrics, InvocationObserverI, InvocationObserver> _invocations;
    private final ObserverFactoryWithDelegate<ThreadMetrics, ThreadObserverI, ThreadObserver> _threads;
    private final ObserverFactoryWithDelegate<Metrics, ObserverWithDelegateI, Observer> _connects;
    private final ObserverFactoryWithDelegate<Metrics, ObserverWithDelegateI, Observer> _endpointLookups;

    static void addEndpointAttributes(MetricsHelper.AttributeResolver r, Class<?> cl) throws Exception {
        r.add("endpoint", cl.getDeclaredMethod("getEndpoint", new Class[0]));
        Class<EndpointInfo> cli = EndpointInfo.class;
        r.add("endpointType", cl.getDeclaredMethod("getEndpointInfo", new Class[0]), cli.getDeclaredMethod("type", new Class[0]));
        r.add("endpointIsDatagram", cl.getDeclaredMethod("getEndpointInfo", new Class[0]), cli.getDeclaredMethod("datagram", new Class[0]));
        r.add("endpointIsSecure", cl.getDeclaredMethod("getEndpointInfo", new Class[0]), cli.getDeclaredMethod("secure", new Class[0]));
        r.add("endpointTimeout", cl.getDeclaredMethod("getEndpointInfo", new Class[0]), cli.getDeclaredField("timeout"));
        r.add("endpointCompress", cl.getDeclaredMethod("getEndpointInfo", new Class[0]), cli.getDeclaredField("compress"));
        cli = IPEndpointInfo.class;
        r.add("endpointHost", cl.getDeclaredMethod("getEndpointInfo", new Class[0]), cli.getDeclaredField("host"));
        r.add("endpointPort", cl.getDeclaredMethod("getEndpointInfo", new Class[0]), cli.getDeclaredField("port"));
    }

    static void addConnectionAttributes(MetricsHelper.AttributeResolver r, Class<?> cl) throws Exception {
        Class<ConnectionInfo> cli = ConnectionInfo.class;
        r.add("incoming", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("incoming"));
        r.add("adapterName", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("adapterName"));
        r.add("connectionId", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("connectionId"));
        cli = IPConnectionInfo.class;
        r.add("localHost", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("localAddress"));
        r.add("localPort", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("localPort"));
        r.add("remoteHost", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("remoteAddress"));
        r.add("remotePort", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("remotePort"));
        cli = UDPConnectionInfo.class;
        r.add("mcastHost", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("mcastAddress"));
        r.add("mcastPort", cl.getDeclaredMethod("getConnectionInfo", new Class[0]), cli.getDeclaredField("mcastPort"));
        CommunicatorObserverI.addEndpointAttributes(r, cl);
    }

    public CommunicatorObserverI(InitializationData initData) {
        block2: {
            this._metrics = new MetricsAdminI(initData.properties, initData.logger);
            this._delegate = initData.observer;
            this._connections = new ObserverFactoryWithDelegate(this._metrics, "Connection", ConnectionMetrics.class);
            this._dispatch = new ObserverFactoryWithDelegate(this._metrics, "Dispatch", DispatchMetrics.class);
            this._invocations = new ObserverFactoryWithDelegate(this._metrics, "Invocation", InvocationMetrics.class);
            this._threads = new ObserverFactoryWithDelegate(this._metrics, "Thread", ThreadMetrics.class);
            this._connects = new ObserverFactoryWithDelegate(this._metrics, "ConnectionEstablishment", Metrics.class);
            this._endpointLookups = new ObserverFactoryWithDelegate(this._metrics, "EndpointLookup", Metrics.class);
            try {
                this._invocations.registerSubMap("Remote", RemoteMetrics.class, InvocationMetrics.class.getDeclaredField("remotes"));
                this._invocations.registerSubMap("Collocated", CollocatedMetrics.class, InvocationMetrics.class.getDeclaredField("collocated"));
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public Observer getConnectionEstablishmentObserver(Endpoint endpt, String connector) {
        if (this._connects.isEnabled()) {
            try {
                Observer delegate = null;
                if (this._delegate != null) {
                    delegate = this._delegate.getConnectionEstablishmentObserver(endpt, connector);
                }
                return this._connects.getObserver((MetricsHelper<Metrics>)new EndpointHelper(endpt, connector), ObserverWithDelegateI.class, delegate);
            }
            catch (Exception ex) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(ex));
            }
        }
        return null;
    }

    @Override
    public Observer getEndpointLookupObserver(Endpoint endpt) {
        if (this._endpointLookups.isEnabled()) {
            try {
                Observer delegate = null;
                if (this._delegate != null) {
                    delegate = this._delegate.getEndpointLookupObserver(endpt);
                }
                return this._endpointLookups.getObserver((MetricsHelper<Metrics>)new EndpointHelper(endpt), ObserverWithDelegateI.class, delegate);
            }
            catch (Exception ex) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(ex));
            }
        }
        return null;
    }

    @Override
    public ConnectionObserver getConnectionObserver(ConnectionInfo c, Endpoint e, ConnectionState s, ConnectionObserver observer) {
        if (this._connections.isEnabled()) {
            try {
                ConnectionObserverI o;
                ConnectionObserver delegate = null;
                ConnectionObserverI connectionObserverI = o = observer instanceof ConnectionObserverI ? (ConnectionObserverI)observer : null;
                if (this._delegate != null) {
                    delegate = this._delegate.getConnectionObserver(c, e, s, o != null ? (ConnectionObserver)o.getDelegate() : observer);
                }
                return this._connections.getObserver(new ConnectionHelper(c, e, s), o, ConnectionObserverI.class, delegate);
            }
            catch (Exception ex) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(ex));
            }
        }
        return null;
    }

    @Override
    public ThreadObserver getThreadObserver(String parent, String id, ThreadState s, ThreadObserver observer) {
        if (this._threads.isEnabled()) {
            try {
                ThreadObserverI o;
                ThreadObserver delegate = null;
                ThreadObserverI threadObserverI = o = observer instanceof ThreadObserverI ? (ThreadObserverI)observer : null;
                if (this._delegate != null) {
                    delegate = this._delegate.getThreadObserver(parent, id, s, o != null ? (ThreadObserver)o.getDelegate() : observer);
                }
                return this._threads.getObserver(new ThreadHelper(parent, id, s), o, ThreadObserverI.class, delegate);
            }
            catch (Exception ex) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(ex));
            }
        }
        return null;
    }

    @Override
    public InvocationObserver getInvocationObserver(ObjectPrx prx, String operation, Map<String, String> ctx) {
        if (this._invocations.isEnabled()) {
            try {
                InvocationObserver delegate = null;
                if (this._delegate != null) {
                    delegate = this._delegate.getInvocationObserver(prx, operation, ctx);
                }
                return this._invocations.getObserver((MetricsHelper<InvocationMetrics>)new InvocationHelper(prx, operation, ctx), InvocationObserverI.class, delegate);
            }
            catch (Exception ex) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(ex));
            }
        }
        return null;
    }

    @Override
    public DispatchObserver getDispatchObserver(Current c, int size) {
        if (this._dispatch.isEnabled()) {
            try {
                DispatchObserver delegate = null;
                if (this._delegate != null) {
                    delegate = this._delegate.getDispatchObserver(c, size);
                }
                return this._dispatch.getObserver((MetricsHelper<DispatchMetrics>)new DispatchHelper(c, size), DispatchObserverI.class, delegate);
            }
            catch (Exception ex) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(ex));
            }
        }
        return null;
    }

    @Override
    public void setObserverUpdater(ObserverUpdater updater) {
        if (updater == null) {
            this._connections.setUpdater(null);
            this._threads.setUpdater(null);
        } else {
            this._connections.setUpdater(() -> updater.updateConnectionObservers());
            this._threads.setUpdater(() -> updater.updateThreadObservers());
        }
        if (this._delegate != null) {
            this._delegate.setObserverUpdater(updater);
        }
    }

    public MetricsAdminI getFacet() {
        return this._metrics;
    }

    public static final class EndpointHelper
    extends MetricsHelper<Metrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        this.add("parent", EndpointHelper.class.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", EndpointHelper.class.getDeclaredMethod("getId", new Class[0]));
                        CommunicatorObserverI.addEndpointAttributes(this, EndpointHelper.class);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final Endpoint _endpoint;
        private String _id;
        private EndpointInfo _endpointInfo;

        EndpointHelper(Endpoint endpt, String id) {
            super(_attributes);
            this._endpoint = endpt;
            this._id = id;
        }

        EndpointHelper(Endpoint endpt) {
            super(_attributes);
            this._endpoint = endpt;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._endpointInfo == null) {
                this._endpointInfo = this._endpoint.getInfo();
            }
            return this._endpointInfo;
        }

        public String getParent() {
            return "Communicator";
        }

        public String getId() {
            if (this._id == null) {
                this._id = this._endpoint.toString();
            }
            return this._id;
        }

        public String getEndpoint() {
            return this._endpoint.toString();
        }
    }

    public static class ConnectionHelper
    extends MetricsHelper<ConnectionMetrics> {
        private static MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        this.add("parent", ConnectionHelper.class.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", ConnectionHelper.class.getDeclaredMethod("getId", new Class[0]));
                        this.add("state", ConnectionHelper.class.getDeclaredMethod("getState", new Class[0]));
                        CommunicatorObserverI.addConnectionAttributes(this, ConnectionHelper.class);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final ConnectionInfo _connectionInfo;
        private final Endpoint _endpoint;
        private final ConnectionState _state;
        private String _id;
        private EndpointInfo _endpointInfo;

        ConnectionHelper(ConnectionInfo con, Endpoint endpt, ConnectionState state) {
            super(_attributes);
            this._connectionInfo = con;
            this._endpoint = endpt;
            this._state = state;
        }

        public String getId() {
            if (this._id == null) {
                StringBuilder os = new StringBuilder();
                IPConnectionInfo info = this.getIPConnectionInfo();
                if (info != null) {
                    os.append(info.localAddress).append(':').append(info.localPort);
                    os.append(" -> ");
                    os.append(info.remoteAddress).append(':').append(info.remotePort);
                } else {
                    os.append("connection-").append(this._connectionInfo);
                }
                if (!this._connectionInfo.connectionId.isEmpty()) {
                    os.append(" [").append(this._connectionInfo.connectionId).append("]");
                }
                this._id = os.toString();
            }
            return this._id;
        }

        public String getState() {
            switch (this._state) {
                case ConnectionStateValidating: {
                    return "validating";
                }
                case ConnectionStateHolding: {
                    return "holding";
                }
                case ConnectionStateActive: {
                    return "active";
                }
                case ConnectionStateClosing: {
                    return "closing";
                }
                case ConnectionStateClosed: {
                    return "closed";
                }
            }
            assert (false);
            return "";
        }

        public String getParent() {
            if (this._connectionInfo.adapterName != null && !this._connectionInfo.adapterName.isEmpty()) {
                return this._connectionInfo.adapterName;
            }
            return "Communicator";
        }

        public ConnectionInfo getConnectionInfo() {
            return this._connectionInfo;
        }

        public Endpoint getEndpoint() {
            return this._endpoint;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._endpointInfo == null) {
                this._endpointInfo = this._endpoint.getInfo();
            }
            return this._endpointInfo;
        }

        private IPConnectionInfo getIPConnectionInfo() {
            ConnectionInfo p = this._connectionInfo;
            while (p != null) {
                if (p instanceof IPConnectionInfo) {
                    return (IPConnectionInfo)p;
                }
                p = p.underlying;
            }
            return null;
        }
    }

    public static final class ThreadHelper
    extends MetricsHelper<ThreadMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        this.add("parent", ThreadHelper.class.getDeclaredField("_parent"));
                        this.add("id", ThreadHelper.class.getDeclaredField("_id"));
                    }
                    catch (Exception ex) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        public final String _parent;
        public final String _id;
        private final ThreadState _state;

        ThreadHelper(String parent, String id, ThreadState state) {
            super(_attributes);
            this._parent = parent;
            this._id = id;
            this._state = state;
        }

        @Override
        public void initMetrics(ThreadMetrics v) {
            switch (this._state) {
                case ThreadStateInUseForIO: {
                    ++v.inUseForIO;
                    break;
                }
                case ThreadStateInUseForUser: {
                    ++v.inUseForUser;
                    break;
                }
                case ThreadStateInUseForOther: {
                    ++v.inUseForOther;
                    break;
                }
            }
        }
    }

    public static final class InvocationHelper
    extends MetricsHelper<InvocationMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<InvocationHelper> cl = InvocationHelper.class;
                        this.add("parent", cl.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", cl.getDeclaredMethod("getId", new Class[0]));
                        this.add("operation", cl.getDeclaredMethod("getOperation", new Class[0]));
                        this.add("identity", cl.getDeclaredMethod("getIdentity", new Class[0]));
                        Class<ObjectPrx> cli = ObjectPrx.class;
                        this.add("facet", cl.getDeclaredMethod("getProxy", new Class[0]), cli.getDeclaredMethod("ice_getFacet", new Class[0]));
                        this.add("encoding", cl.getDeclaredMethod("getEncodingVersion", new Class[0]));
                        this.add("mode", cl.getDeclaredMethod("getMode", new Class[0]));
                        this.add("proxy", cl.getDeclaredMethod("getProxy", new Class[0]));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final ObjectPrx _proxy;
        private final String _operation;
        private final Map<String, String> _context;
        private String _id;
        private static final Endpoint[] emptyEndpoints = new Endpoint[0];

        InvocationHelper(ObjectPrx proxy, String op, Map<String, String> ctx) {
            super(_attributes);
            this._proxy = proxy;
            this._operation = op;
            this._context = ctx;
        }

        @Override
        protected String defaultResolve(String attribute) {
            String v;
            if (attribute.indexOf("context.", 0) == 0 && (v = this._context.get(attribute.substring(8))) != null) {
                return v;
            }
            throw new IllegalArgumentException(attribute);
        }

        public String getMode() {
            if (this._proxy == null) {
                throw new IllegalArgumentException("mode");
            }
            if (this._proxy.ice_isTwoway()) {
                return "twoway";
            }
            if (this._proxy.ice_isOneway()) {
                return "oneway";
            }
            if (this._proxy.ice_isBatchOneway()) {
                return "batch-oneway";
            }
            if (this._proxy.ice_isDatagram()) {
                return "datagram";
            }
            if (this._proxy.ice_isBatchDatagram()) {
                return "batch-datagram";
            }
            throw new IllegalArgumentException("mode");
        }

        public String getId() {
            if (this._id == null) {
                if (this._proxy != null) {
                    StringBuilder os = new StringBuilder();
                    try {
                        os.append(this._proxy.ice_endpoints(emptyEndpoints)).append(" [").append(this._operation).append(']');
                    }
                    catch (Exception ex) {
                        os.append(this._proxy.ice_getCommunicator().identityToString(this._proxy.ice_getIdentity()));
                        os.append(" [").append(this._operation).append(']');
                    }
                    this._id = os.toString();
                } else {
                    this._id = this._operation;
                }
            }
            return this._id;
        }

        public String getParent() {
            return "Communicator";
        }

        public ObjectPrx getProxy() {
            return this._proxy;
        }

        public String getIdentity() {
            if (this._proxy != null) {
                return this._proxy.ice_getCommunicator().identityToString(this._proxy.ice_getIdentity());
            }
            return "";
        }

        public String getOperation() {
            return this._operation;
        }

        public String getEncodingVersion() {
            return Util.encodingVersionToString(this._proxy.ice_getEncodingVersion());
        }
    }

    public static final class DispatchHelper
    extends MetricsHelper<DispatchMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<DispatchHelper> cl = DispatchHelper.class;
                        this.add("parent", cl.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", cl.getDeclaredMethod("getId", new Class[0]));
                        CommunicatorObserverI.addConnectionAttributes(this, cl);
                        Class<Current> clc = Current.class;
                        this.add("operation", cl.getDeclaredMethod("getCurrent", new Class[0]), clc.getDeclaredField("operation"));
                        this.add("identity", cl.getDeclaredMethod("getIdentity", new Class[0]));
                        this.add("facet", cl.getDeclaredMethod("getCurrent", new Class[0]), clc.getDeclaredField("facet"));
                        this.add("requestId", cl.getDeclaredMethod("getCurrent", new Class[0]), clc.getDeclaredField("requestId"));
                        this.add("mode", cl.getDeclaredMethod("getMode", new Class[0]));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final Current _current;
        private final int _size;
        private String _id;
        private EndpointInfo _endpointInfo;

        DispatchHelper(Current current, int size) {
            super(_attributes);
            this._current = current;
            this._size = size;
        }

        @Override
        public void initMetrics(DispatchMetrics v) {
            v.size += (long)this._size;
        }

        @Override
        protected String defaultResolve(String attribute) {
            String v;
            if (attribute.indexOf("context.", 0) == 0 && (v = this._current.ctx.get(attribute.substring(8))) != null) {
                return v;
            }
            throw new IllegalArgumentException(attribute);
        }

        public String getMode() {
            return this._current.requestId == 0 ? "oneway" : "twoway";
        }

        public String getId() {
            if (this._id == null) {
                StringBuilder os = new StringBuilder();
                if (this._current.id.category != null && !this._current.id.category.isEmpty()) {
                    os.append(this._current.id.category).append('/');
                }
                os.append(this._current.id.name).append(" [").append(this._current.operation).append(']');
                this._id = os.toString();
            }
            return this._id;
        }

        public int getRequestId() {
            return this._current.requestId;
        }

        public String getParent() {
            return this._current.adapter.getName();
        }

        public ConnectionInfo getConnectionInfo() {
            if (this._current.con != null) {
                return this._current.con.getInfo();
            }
            return null;
        }

        public Endpoint getEndpoint() {
            if (this._current.con != null) {
                return this._current.con.getEndpoint();
            }
            return null;
        }

        public Connection getConnection() {
            return this._current.con;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._current.con != null && this._endpointInfo == null) {
                this._endpointInfo = this._current.con.getEndpoint().getInfo();
            }
            return this._endpointInfo;
        }

        public Current getCurrent() {
            return this._current;
        }

        public String getIdentity() {
            return this._current.adapter.getCommunicator().identityToString(this._current.id);
        }
    }
}

