/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.AlreadyRegisteredException;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.FileException;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.IllegalIdentityException;
import com.zeroc.Ice.ImplicitContextI;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.InitializationException;
import com.zeroc.Ice.Instrumentation.CommunicatorObserver;
import com.zeroc.Ice.Instrumentation.ObserverUpdater;
import com.zeroc.Ice.Instrumentation.ThreadObserver;
import com.zeroc.Ice.Instrumentation.ThreadState;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.LoggerI;
import com.zeroc.Ice.NotRegisteredException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectFactory;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.PluginManager;
import com.zeroc.Ice.PluginManagerI;
import com.zeroc.Ice.ProcessPrx;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.PropertiesI;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice.ServerNotFoundException;
import com.zeroc.Ice.SysLoggerI;
import com.zeroc.Ice.ToStringMode;
import com.zeroc.Ice.Value;
import com.zeroc.Ice.ValueFactory;
import com.zeroc.IceInternal.ACMConfig;
import com.zeroc.IceInternal.BufSizeWarnInfo;
import com.zeroc.IceInternal.CommunicatorObserverI;
import com.zeroc.IceInternal.DefaultsAndOverrides;
import com.zeroc.IceInternal.EndpointFactoryManager;
import com.zeroc.IceInternal.EndpointHostResolver;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.HTTPNetworkProxy;
import com.zeroc.IceInternal.LocatorManager;
import com.zeroc.IceInternal.LoggerAdminLogger;
import com.zeroc.IceInternal.LoggerAdminLoggerI;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.NetworkProxy;
import com.zeroc.IceInternal.ObjectAdapterFactory;
import com.zeroc.IceInternal.OutgoingConnectionFactory;
import com.zeroc.IceInternal.ProcessI;
import com.zeroc.IceInternal.PropertiesAdminI;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceInternal.ProxyFactory;
import com.zeroc.IceInternal.QueueExecutorService;
import com.zeroc.IceInternal.ReferenceFactory;
import com.zeroc.IceInternal.RequestHandlerFactory;
import com.zeroc.IceInternal.RetryQueue;
import com.zeroc.IceInternal.RouterManager;
import com.zeroc.IceInternal.SOCKSNetworkProxy;
import com.zeroc.IceInternal.TcpEndpointFactory;
import com.zeroc.IceInternal.ThreadPool;
import com.zeroc.IceInternal.TraceLevels;
import com.zeroc.IceInternal.UdpEndpointFactory;
import com.zeroc.IceInternal.Util;
import com.zeroc.IceInternal.ValueFactoryManagerI;
import com.zeroc.IceInternal.WSEndpointFactory;
import com.zeroc.IceUtilInternal.Assert;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class Instance
implements Function<String, Class<?>> {
    private static final int StateActive = 0;
    private static final int StateDestroyInProgress = 1;
    private static final int StateDestroyed = 2;
    private int _state = 0;
    private final InitializationData _initData;
    private final TraceLevels _traceLevels;
    private final DefaultsAndOverrides _defaultsAndOverrides;
    private final int _messageSizeMax;
    private final int _batchAutoFlushSize;
    private final ToStringMode _toStringMode;
    private final int _cacheMessageBuffers;
    private final ACMConfig _clientACM;
    private final ACMConfig _serverACM;
    private final ImplicitContextI _implicitContext;
    private RouterManager _routerManager;
    private LocatorManager _locatorManager;
    private ReferenceFactory _referenceFactory;
    private RequestHandlerFactory _requestHandlerFactory;
    private ProxyFactory _proxyFactory;
    private OutgoingConnectionFactory _outgoingConnectionFactory;
    private ObjectAdapterFactory _objectAdapterFactory;
    private int _protocolSupport;
    private boolean _preferIPv6;
    private NetworkProxy _networkProxy;
    private ThreadPool _clientThreadPool;
    private ThreadPool _serverThreadPool;
    private EndpointHostResolver _endpointHostResolver;
    private RetryQueue _retryQueue;
    private Timer _timer;
    private EndpointFactoryManager _endpointFactoryManager;
    private PluginManager _pluginManager;
    private boolean _adminEnabled = false;
    private ObjectAdapter _adminAdapter;
    private Map<String, Object> _adminFacets = new HashMap<String, Object>();
    private Set<String> _adminFacetFilter = new HashSet<String>();
    private Identity _adminIdentity;
    private Map<Short, BufSizeWarnInfo> _setBufSizeWarn = new HashMap<Short, BufSizeWarnInfo>();
    private Map<String, String> _typeToClassMap = new HashMap<String, String>();
    private final String[] _packages;
    private final boolean _useApplicationClassLoader;
    private static boolean _oneOffDone = false;
    private QueueExecutorService _queueExecutorService;
    private QueueExecutor _queueExecutor;
    private HashMap<String, ObjectFactory> _objectFactoryMap = new HashMap();

    public InitializationData initializationData() {
        return this._initData;
    }

    public TraceLevels traceLevels() {
        assert (this._traceLevels != null);
        return this._traceLevels;
    }

    public DefaultsAndOverrides defaultsAndOverrides() {
        assert (this._defaultsAndOverrides != null);
        return this._defaultsAndOverrides;
    }

    public synchronized RouterManager routerManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._routerManager != null);
        return this._routerManager;
    }

    public synchronized LocatorManager locatorManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._locatorManager != null);
        return this._locatorManager;
    }

    public synchronized ReferenceFactory referenceFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._referenceFactory != null);
        return this._referenceFactory;
    }

    public synchronized RequestHandlerFactory requestHandlerFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._requestHandlerFactory != null);
        return this._requestHandlerFactory;
    }

    public synchronized ProxyFactory proxyFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._proxyFactory != null);
        return this._proxyFactory;
    }

    public synchronized OutgoingConnectionFactory outgoingConnectionFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._outgoingConnectionFactory != null);
        return this._outgoingConnectionFactory;
    }

    public synchronized ObjectAdapterFactory objectAdapterFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._objectAdapterFactory != null);
        return this._objectAdapterFactory;
    }

    public int protocolSupport() {
        return this._protocolSupport;
    }

    public boolean preferIPv6() {
        return this._preferIPv6;
    }

    public NetworkProxy networkProxy() {
        return this._networkProxy;
    }

    public synchronized ThreadPool clientThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._clientThreadPool != null);
        return this._clientThreadPool;
    }

    public synchronized ThreadPool serverThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._serverThreadPool == null) {
            if (this._state == 1) {
                throw new CommunicatorDestroyedException();
            }
            int timeout = this._initData.properties.getPropertyAsInt("Ice.ServerIdleTime");
            this._serverThreadPool = new ThreadPool(this, "Ice.ThreadPool.Server", timeout);
        }
        return this._serverThreadPool;
    }

    public synchronized EndpointHostResolver endpointHostResolver() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._endpointHostResolver != null);
        return this._endpointHostResolver;
    }

    public synchronized RetryQueue retryQueue() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._retryQueue != null);
        return this._retryQueue;
    }

    public synchronized ScheduledExecutorService timer() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._timer != null);
        return this._timer;
    }

    public synchronized EndpointFactoryManager endpointFactoryManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._endpointFactoryManager != null);
        return this._endpointFactoryManager;
    }

    public synchronized PluginManager pluginManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._pluginManager != null);
        return this._pluginManager;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public int batchAutoFlushSize() {
        return this._batchAutoFlushSize;
    }

    public ToStringMode toStringMode() {
        return this._toStringMode;
    }

    public int cacheMessageBuffers() {
        return this._cacheMessageBuffers;
    }

    public ACMConfig clientACM() {
        return this._clientACM;
    }

    public ACMConfig serverACM() {
        return this._serverACM;
    }

    public ImplicitContextI getImplicitContext() {
        return this._implicitContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectPrx createAdmin(ObjectAdapter adminAdapter, Identity adminIdentity) {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        boolean createAdapter = adminAdapter == null;
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            if (adminIdentity == null || adminIdentity.name == null || adminIdentity.name.isEmpty()) {
                throw new IllegalIdentityException(adminIdentity);
            }
            if (this._adminAdapter != null) {
                throw new InitializationException("Admin already created");
            }
            if (!this._adminEnabled) {
                throw new InitializationException("Admin is disabled");
            }
            if (createAdapter) {
                if (!this._initData.properties.getProperty("Ice.Admin.Endpoints").isEmpty()) {
                    adminAdapter = this._objectAdapterFactory.createObjectAdapter("Ice.Admin", null);
                } else {
                    throw new InitializationException("Ice.Admin.Endpoints is not set");
                }
            }
            this._adminIdentity = adminIdentity;
            this._adminAdapter = adminAdapter;
            this.addAllAdminFacets();
        }
        if (createAdapter) {
            try {
                adminAdapter.activate();
            }
            catch (LocalException ex) {
                adminAdapter.destroy();
                Instance instance2 = this;
                synchronized (instance2) {
                    this._adminAdapter = null;
                }
                throw ex;
            }
        }
        this.setServerProcessProxy(adminAdapter, adminIdentity);
        return adminAdapter.createProxy(adminIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPrx getAdmin() {
        Identity adminIdentity;
        ObjectAdapter adminAdapter;
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            if (this._adminAdapter != null) {
                return this._adminAdapter.createProxy(this._adminIdentity);
            }
            if (this._adminEnabled) {
                if (this._initData.properties.getProperty("Ice.Admin.Endpoints").isEmpty()) {
                    return null;
                }
                adminAdapter = this._objectAdapterFactory.createObjectAdapter("Ice.Admin", null);
                adminIdentity = new Identity("admin", this._initData.properties.getProperty("Ice.Admin.InstanceName"));
                if (adminIdentity.category.isEmpty()) {
                    adminIdentity.category = UUID.randomUUID().toString();
                }
            } else {
                return null;
            }
            this._adminIdentity = adminIdentity;
            this._adminAdapter = adminAdapter;
            this.addAllAdminFacets();
        }
        try {
            adminAdapter.activate();
        }
        catch (LocalException ex) {
            adminAdapter.destroy();
            Instance instance2 = this;
            synchronized (instance2) {
                this._adminAdapter = null;
            }
            throw ex;
        }
        this.setServerProcessProxy(adminAdapter, adminIdentity);
        return adminAdapter.createProxy(adminIdentity);
    }

    public synchronized void addAdminFacet(Object servant, String facet) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(facet)) {
            if (this._adminFacets.get(facet) != null) {
                throw new AlreadyRegisteredException("facet", facet);
            }
            this._adminFacets.put(facet, servant);
        } else {
            this._adminAdapter.addFacet(servant, this._adminIdentity, facet);
        }
    }

    public synchronized Object removeAdminFacet(String facet) {
        Object result;
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(facet)) {
            result = this._adminFacets.remove(facet);
            if (result == null) {
                throw new NotRegisteredException("facet", facet);
            }
        } else {
            result = this._adminAdapter.removeFacet(this._adminIdentity, facet);
        }
        return result;
    }

    public synchronized Object findAdminFacet(String facet) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        Object result = null;
        result = this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(facet) ? this._adminFacets.get(facet) : this._adminAdapter.findFacet(this._adminIdentity, facet);
        return result;
    }

    public synchronized Map<String, Object> findAllAdminFacets() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._adminAdapter == null) {
            return new HashMap<String, Object>(this._adminFacets);
        }
        Map<String, Object> result = this._adminAdapter.findAllFacets(this._adminIdentity);
        if (!this._adminFacets.isEmpty()) {
            result.putAll(this._adminFacets);
        }
        return result;
    }

    public synchronized void setDefaultLocator(LocatorPrx locator) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._referenceFactory = this._referenceFactory.setDefaultLocator(locator);
    }

    public synchronized void setDefaultRouter(RouterPrx router) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._referenceFactory = this._referenceFactory.setDefaultRouter(router);
    }

    public void setLogger(Logger logger) {
        this._initData.logger = logger;
    }

    public void setThreadHooks(Runnable threadStart, Runnable threadStop) {
        this._initData.threadStart = threadStart;
        this._initData.threadStop = threadStop;
    }

    public Class<?> findClass(String className) {
        return Util.findClass(className, this._initData.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this._initData.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> apply(String typeId) {
        String pkg;
        int pos;
        String className;
        Class<?> c = null;
        boolean addClass = false;
        Instance instance = this;
        synchronized (instance) {
            className = this._typeToClassMap.get(typeId);
        }
        if (className == null) {
            className = com.zeroc.Ice.Util.typeIdToClass(typeId);
            addClass = true;
        }
        if ((c = this.getConcreteClass(className)) == null && (pos = typeId.indexOf(58, 2)) != -1) {
            String topLevelModule = typeId.substring(2, pos);
            String pkg2 = this._initData.properties.getProperty("Ice.Package." + topLevelModule);
            if (pkg2.length() > 0) {
                c = this.getConcreteClass(pkg2 + "." + className);
            }
        }
        if (c == null && (pkg = this._initData.properties.getProperty("Ice.Default.Package")).length() > 0) {
            c = this.getConcreteClass(pkg + "." + className);
        }
        if (c != null && addClass) {
            Instance instance2 = this;
            synchronized (instance2) {
                className = c.getName();
                if (this._typeToClassMap.containsKey(typeId)) {
                    assert (this._typeToClassMap.get(typeId).equals(className));
                } else {
                    this._typeToClassMap.put(typeId, className);
                }
            }
        }
        return c;
    }

    public String resolveCompactId(int compactId) {
        block5: {
            String className = "com.zeroc.IceCompactId.TypeId_" + Integer.toString(compactId);
            Class<?> c = this.getConcreteClass(className);
            if (c == null) {
                String pkg;
                String[] stringArray = this._packages;
                int n = stringArray.length;
                for (int i = 0; i < n && (c = this.getConcreteClass((pkg = stringArray[i]) + "." + className)) == null; ++i) {
                }
            }
            if (c != null) {
                try {
                    return (String)c.getField("typeId").get(null);
                }
                catch (Exception ex) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        return "";
    }

    public Class<?> getConcreteClass(String className) throws LinkageError {
        int modifiers;
        Class<?> c = this.findClass(className);
        if (c != null && ((modifiers = c.getModifiers()) & 0x200) == 0 && (modifiers & 0x400) == 0) {
            return c;
        }
        return null;
    }

    public boolean useApplicationClassLoader() {
        return this._useApplicationClassLoader;
    }

    public boolean queueRequests() {
        return this._queueExecutorService != null;
    }

    public synchronized QueueExecutorService getQueueExecutor() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._queueExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance(Communicator communicator, InitializationData initData) {
        this._initData = initData;
        try {
            if (this._initData.properties == null) {
                this._initData.properties = com.zeroc.Ice.Util.createProperties();
            }
            Class<Instance> clazz = Instance.class;
            synchronized (Instance.class) {
                boolean ipv6;
                int num;
                if (!_oneOffDone) {
                    String stdOut = this._initData.properties.getProperty("Ice.StdOut");
                    String stdErr = this._initData.properties.getProperty("Ice.StdErr");
                    PrintStream outStream = null;
                    if (stdOut.length() > 0) {
                        System.out.close();
                        try {
                            outStream = new PrintStream(new FileOutputStream(stdOut, true));
                        }
                        catch (FileNotFoundException ex) {
                            throw new FileException(0, stdOut, ex);
                        }
                        System.setOut(outStream);
                    }
                    if (stdErr.length() > 0) {
                        System.err.close();
                        if (stdErr.equals(stdOut)) {
                            System.setErr(outStream);
                        } else {
                            try {
                                System.setErr(new PrintStream(new FileOutputStream(stdErr, true)));
                            }
                            catch (FileNotFoundException ex) {
                                throw new FileException(0, stdErr, ex);
                            }
                        }
                    }
                    _oneOffDone = true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (this._initData.logger == null) {
                    String logfile = this._initData.properties.getProperty("Ice.LogFile");
                    if (this._initData.properties.getPropertyAsInt("Ice.UseSyslog") > 0 && !System.getProperty("os.name").startsWith("Windows")) {
                        if (logfile.length() != 0) {
                            throw new InitializationException("Both syslog and file logger cannot be enabled.");
                        }
                        this._initData.logger = new SysLoggerI(this._initData.properties.getProperty("Ice.ProgramName"), this._initData.properties.getPropertyWithDefault("Ice.SyslogFacility", "LOG_USER"));
                    } else if (logfile.length() != 0) {
                        this._initData.logger = new LoggerI(this._initData.properties.getProperty("Ice.ProgramName"), logfile);
                    } else {
                        this._initData.logger = com.zeroc.Ice.Util.getProcessLogger();
                        if (this._initData.logger instanceof LoggerI) {
                            this._initData.logger = new LoggerI(this._initData.properties.getProperty("Ice.ProgramName"), "");
                        }
                    }
                }
                this._packages = this.validatePackages();
                this._useApplicationClassLoader = this._initData.properties.getPropertyAsInt("Ice.UseApplicationClassLoader") > 0;
                this._traceLevels = new TraceLevels(this._initData.properties);
                this._defaultsAndOverrides = new DefaultsAndOverrides(this._initData.properties, this._initData.logger);
                this._clientACM = new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM.Client", new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM", new ACMConfig(false)));
                this._serverACM = new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM.Server", new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM", new ACMConfig(true)));
                int defaultMessageSizeMax = 1024;
                int num2 = this._initData.properties.getPropertyAsIntWithDefault("Ice.MessageSizeMax", 1024);
                this._messageSizeMax = num2 < 1 || num2 > 0x1FFFFF ? Integer.MAX_VALUE : num2 * 1024;
                this._batchAutoFlushSize = this._initData.properties.getProperty("Ice.BatchAutoFlushSize").isEmpty() && !this._initData.properties.getProperty("Ice.BatchAutoFlush").isEmpty() ? (this._initData.properties.getPropertyAsInt("Ice.BatchAutoFlush") > 0 ? this._messageSizeMax : 0) : ((num = this._initData.properties.getPropertyAsIntWithDefault("Ice.BatchAutoFlushSize", 1024)) < 1 ? num : (num > 0x1FFFFF ? Integer.MAX_VALUE : num * 1024));
                String toStringModeStr = this._initData.properties.getPropertyWithDefault("Ice.ToStringMode", "Unicode");
                if (toStringModeStr.equals("Unicode")) {
                    this._toStringMode = ToStringMode.Unicode;
                } else if (toStringModeStr.equals("ASCII")) {
                    this._toStringMode = ToStringMode.ASCII;
                } else if (toStringModeStr.equals("Compat")) {
                    this._toStringMode = ToStringMode.Compat;
                } else {
                    throw new InitializationException("The value for Ice.ToStringMode must be Unicode, ASCII or Compat");
                }
                this._implicitContext = ImplicitContextI.create(this._initData.properties.getProperty("Ice.ImplicitContext"));
                this._routerManager = new RouterManager();
                this._locatorManager = new LocatorManager(this._initData.properties);
                this._referenceFactory = new ReferenceFactory(this, communicator);
                this._requestHandlerFactory = new RequestHandlerFactory(this);
                this._proxyFactory = new ProxyFactory(this);
                boolean isIPv6Supported = Network.isIPv6Supported();
                boolean ipv4 = this._initData.properties.getPropertyAsIntWithDefault("Ice.IPv4", 1) > 0;
                boolean bl = ipv6 = this._initData.properties.getPropertyAsIntWithDefault("Ice.IPv6", isIPv6Supported ? 1 : 0) > 0;
                if (!ipv4 && !ipv6) {
                    throw new InitializationException("Both IPV4 and IPv6 support cannot be disabled.");
                }
                this._protocolSupport = ipv4 && ipv6 ? 2 : (ipv4 ? 0 : 1);
                this._preferIPv6 = this._initData.properties.getPropertyAsInt("Ice.PreferIPv6Address") > 0;
                this._networkProxy = this.createNetworkProxy(this._initData.properties, this._protocolSupport);
                this._endpointFactoryManager = new EndpointFactoryManager(this);
                ProtocolInstance tcpProtocol = new ProtocolInstance(this, 1, "tcp", false);
                this._endpointFactoryManager.add(new TcpEndpointFactory(tcpProtocol));
                ProtocolInstance udpProtocol = new ProtocolInstance(this, 3, "udp", false);
                this._endpointFactoryManager.add(new UdpEndpointFactory(udpProtocol));
                ProtocolInstance wsProtocol = new ProtocolInstance(this, 4, "ws", false);
                this._endpointFactoryManager.add(new WSEndpointFactory(wsProtocol, 1));
                ProtocolInstance wssProtocol = new ProtocolInstance(this, 5, "wss", true);
                this._endpointFactoryManager.add(new WSEndpointFactory(wssProtocol, 2));
                this._pluginManager = new PluginManagerI(communicator, this);
                if (this._initData.valueFactoryManager == null) {
                    this._initData.valueFactoryManager = new ValueFactoryManagerI();
                }
                this._outgoingConnectionFactory = new OutgoingConnectionFactory(communicator, this);
                this._objectAdapterFactory = new ObjectAdapterFactory(this, communicator);
                this._retryQueue = new RetryQueue(this);
                if (this._initData.properties.getPropertyAsInt("Ice.ThreadInterruptSafe") > 0 || Util.isAndroid()) {
                    this._queueExecutor = new QueueExecutor(this._initData.properties, Util.createThreadName(this._initData.properties, "Ice.BackgroundIO"));
                    this._queueExecutorService = new QueueExecutorService(this._queueExecutor);
                    this._cacheMessageBuffers = 0;
                } else {
                    this._cacheMessageBuffers = this._initData.properties.getPropertyAsIntWithDefault("Ice.CacheMessageBuffers", 2);
                }
            }
        }
        catch (LocalException ex) {
            this.destroy(false);
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._state == 2);
            Assert.FinalizerAssert(this._referenceFactory == null);
            Assert.FinalizerAssert(this._requestHandlerFactory == null);
            Assert.FinalizerAssert(this._proxyFactory == null);
            Assert.FinalizerAssert(this._outgoingConnectionFactory == null);
            Assert.FinalizerAssert(this._objectAdapterFactory == null);
            Assert.FinalizerAssert(this._clientThreadPool == null);
            Assert.FinalizerAssert(this._serverThreadPool == null);
            Assert.FinalizerAssert(this._endpointHostResolver == null);
            Assert.FinalizerAssert(this._timer == null);
            Assert.FinalizerAssert(this._routerManager == null);
            Assert.FinalizerAssert(this._locatorManager == null);
            Assert.FinalizerAssert(this._endpointFactoryManager == null);
            Assert.FinalizerAssert(this._pluginManager == null);
            Assert.FinalizerAssert(this._retryQueue == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public String[] finishSetup(String[] args, Communicator communicator) {
        LocatorPrx loc;
        RouterPrx router;
        String s;
        assert (this._serverThreadPool == null);
        PluginManagerI pluginManagerImpl = (PluginManagerI)this._pluginManager;
        args = pluginManagerImpl.loadPlugins(args);
        this._endpointFactoryManager.initialize();
        this._adminEnabled = this._initData.properties.getProperty("Ice.Admin.Enabled").isEmpty() ? !this._initData.properties.getProperty("Ice.Admin.Endpoints").isEmpty() : this._initData.properties.getPropertyAsInt("Ice.Admin.Enabled") > 0;
        String[] facetFilter = this._initData.properties.getPropertyAsList("Ice.Admin.Facets");
        if (facetFilter.length > 0) {
            this._adminFacetFilter.addAll(Arrays.asList(facetFilter));
        }
        if (this._adminEnabled) {
            String processFacetName = "Process";
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(processFacetName)) {
                this._adminFacets.put(processFacetName, new ProcessI(communicator));
            }
            String loggerFacetName = "Logger";
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(loggerFacetName)) {
                LoggerAdminLoggerI logger = new LoggerAdminLoggerI(this._initData.properties, this._initData.logger);
                this.setLogger(logger);
                this._adminFacets.put(loggerFacetName, logger.getFacet());
            }
            String propertiesFacetName = "Properties";
            PropertiesAdminI propsAdmin = null;
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(propertiesFacetName)) {
                propsAdmin = new PropertiesAdminI(this);
                this._adminFacets.put(propertiesFacetName, propsAdmin);
            }
            String metricsFacetName = "Metrics";
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(metricsFacetName)) {
                CommunicatorObserverI observer = new CommunicatorObserverI(this._initData);
                this._initData.observer = observer;
                this._adminFacets.put(metricsFacetName, observer.getFacet());
                if (propsAdmin != null) {
                    propsAdmin.addUpdateCallback(observer.getFacet());
                }
            }
        }
        if (this._initData.observer != null) {
            this._initData.observer.setObserverUpdater(new ObserverUpdaterI());
        }
        try {
            this._timer = new Timer(this._initData.properties, Util.createThreadName(this._initData.properties, "Ice.Timer"));
        }
        catch (RuntimeException ex) {
            s = "cannot create thread for timer:\n" + Ex.toString(ex);
            this._initData.logger.error(s);
            throw ex;
        }
        try {
            this._endpointHostResolver = new EndpointHostResolver(this);
        }
        catch (RuntimeException ex) {
            s = "cannot create thread for endpoint host resolver:\n" + Ex.toString(ex);
            this._initData.logger.error(s);
            throw ex;
        }
        this._clientThreadPool = new ThreadPool(this, "Ice.ThreadPool.Client", 0);
        if (this._referenceFactory.getDefaultRouter() == null && (router = RouterPrx.uncheckedCast(this._proxyFactory.propertyToProxy("Ice.Default.Router"))) != null) {
            this._referenceFactory = this._referenceFactory.setDefaultRouter(router);
        }
        if (this._referenceFactory.getDefaultLocator() == null && (loc = LocatorPrx.uncheckedCast(this._proxyFactory.propertyToProxy("Ice.Default.Locator"))) != null) {
            this._referenceFactory = this._referenceFactory.setDefaultLocator(loc);
        }
        if (this._initData.properties.getPropertyAsIntWithDefault("Ice.InitPlugins", 1) > 0) {
            pluginManagerImpl.initializePlugins();
        }
        if (this._initData.properties.getPropertyAsIntWithDefault("Ice.Admin.DelayCreation", 0) <= 0) {
            this.getAdmin();
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean interruptible) {
        if (interruptible && Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        Instance instance = this;
        synchronized (instance) {
            while (this._state == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    if (!interruptible) continue;
                    throw new OperationInterruptedException();
                }
            }
            if (this._state == 2) {
                return;
            }
            this._state = 1;
        }
        try {
            List<String> unusedProperties;
            block49: {
                if (this._objectAdapterFactory != null) {
                    this._objectAdapterFactory.shutdown();
                }
                if (this._outgoingConnectionFactory != null) {
                    this._outgoingConnectionFactory.destroy();
                }
                if (this._objectAdapterFactory != null) {
                    this._objectAdapterFactory.destroy();
                }
                if (this._outgoingConnectionFactory != null) {
                    this._outgoingConnectionFactory.waitUntilFinished();
                }
                if (this._retryQueue != null) {
                    this._retryQueue.destroy();
                }
                if (this._initData.observer != null) {
                    this._initData.observer.setObserverUpdater(null);
                }
                if (this._initData.logger instanceof LoggerAdminLogger) {
                    ((LoggerAdminLogger)this._initData.logger).destroy();
                }
                if (this._serverThreadPool != null) {
                    this._serverThreadPool.destroy();
                }
                if (this._clientThreadPool != null) {
                    this._clientThreadPool.destroy();
                }
                if (this._endpointHostResolver != null) {
                    this._endpointHostResolver.destroy();
                }
                if (this._timer != null) {
                    this._timer.shutdown();
                }
                try {
                    if (this._clientThreadPool != null) {
                        this._clientThreadPool.joinWithAllThreads();
                    }
                    if (this._serverThreadPool != null) {
                        this._serverThreadPool.joinWithAllThreads();
                    }
                    if (this._endpointHostResolver != null) {
                        this._endpointHostResolver.joinWithThread();
                    }
                    if (this._queueExecutor != null) {
                        this._queueExecutor.destroy();
                    }
                    if (this._timer != null) {
                        while (!this._timer.isTerminated()) {
                            this._timer.awaitTermination(100000L, TimeUnit.SECONDS);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    if (!interruptible) break block49;
                    throw new OperationInterruptedException();
                }
            }
            for (ObjectFactory f : this._objectFactoryMap.values()) {
                f.destroy();
            }
            this._objectFactoryMap.clear();
            if (this._routerManager != null) {
                this._routerManager.destroy();
            }
            if (this._locatorManager != null) {
                this._locatorManager.destroy();
            }
            if (this._endpointFactoryManager != null) {
                this._endpointFactoryManager.destroy();
            }
            if (this._initData.properties.getPropertyAsInt("Ice.Warn.UnusedProperties") > 0 && (unusedProperties = ((PropertiesI)this._initData.properties).getUnusedProperties()).size() != 0) {
                StringBuilder message = new StringBuilder("The following properties were set but never read:");
                for (String p : unusedProperties) {
                    message.append("\n    ");
                    message.append(p);
                }
                this._initData.logger.warning(message.toString());
            }
            if (this._pluginManager != null) {
                this._pluginManager.destroy();
            }
            if (this._initData.logger instanceof LoggerI) {
                LoggerI logger = (LoggerI)this._initData.logger;
                logger.destroy();
            }
            instance = this;
            synchronized (instance) {
                this._objectAdapterFactory = null;
                this._outgoingConnectionFactory = null;
                this._retryQueue = null;
                this._serverThreadPool = null;
                this._clientThreadPool = null;
                this._endpointHostResolver = null;
                this._timer = null;
                this._referenceFactory = null;
                this._requestHandlerFactory = null;
                this._proxyFactory = null;
                this._routerManager = null;
                this._locatorManager = null;
                this._endpointFactoryManager = null;
                this._pluginManager = null;
                this._adminAdapter = null;
                this._adminFacets.clear();
                this._queueExecutor = null;
                this._queueExecutorService = null;
                this._typeToClassMap.clear();
                this._state = 2;
                this.notifyAll();
            }
        }
        finally {
            instance = this;
            synchronized (instance) {
                if (this._state == 1) {
                    assert (interruptible);
                    this._state = 0;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufSizeWarnInfo getBufSizeWarn(short type) {
        Map<Short, BufSizeWarnInfo> map = this._setBufSizeWarn;
        synchronized (map) {
            BufSizeWarnInfo info;
            if (!this._setBufSizeWarn.containsKey(type)) {
                info = new BufSizeWarnInfo();
                info.sndWarn = false;
                info.sndSize = -1;
                info.rcvWarn = false;
                info.rcvSize = -1;
                this._setBufSizeWarn.put(type, info);
            } else {
                info = this._setBufSizeWarn.get(type);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSndBufSizeWarn(short type, int size) {
        Map<Short, BufSizeWarnInfo> map = this._setBufSizeWarn;
        synchronized (map) {
            BufSizeWarnInfo info = this.getBufSizeWarn(type);
            info.sndWarn = true;
            info.sndSize = size;
            this._setBufSizeWarn.put(type, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRcvBufSizeWarn(short type, int size) {
        Map<Short, BufSizeWarnInfo> map = this._setBufSizeWarn;
        synchronized (map) {
            BufSizeWarnInfo info = this.getBufSizeWarn(type);
            info.rcvWarn = true;
            info.rcvSize = size;
            this._setBufSizeWarn.put(type, info);
        }
    }

    public synchronized void addObjectFactory(final ObjectFactory factory, String id) {
        this._initData.valueFactoryManager.add(new ValueFactory(){

            @Override
            public Value create(String id) {
                return factory.create(id);
            }
        }, id);
        this._objectFactoryMap.put(id, factory);
    }

    public synchronized ObjectFactory findObjectFactory(String id) {
        return this._objectFactoryMap.get(id);
    }

    private void updateConnectionObservers() {
        try {
            assert (this._outgoingConnectionFactory != null);
            this._outgoingConnectionFactory.updateConnectionObservers();
            assert (this._objectAdapterFactory != null);
            this._objectAdapterFactory.updateConnectionObservers();
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
    }

    private void updateThreadObservers() {
        try {
            if (this._clientThreadPool != null) {
                this._clientThreadPool.updateObservers();
            }
            if (this._serverThreadPool != null) {
                this._serverThreadPool.updateObservers();
            }
            assert (this._objectAdapterFactory != null);
            this._objectAdapterFactory.updateThreadObservers();
            if (this._endpointHostResolver != null) {
                this._endpointHostResolver.updateObserver();
            }
            if (this._timer != null) {
                this._timer.updateObserver(this._initData.observer);
            }
            if (this._queueExecutor != null) {
                this._queueExecutor.updateObserver(this._initData.observer);
            }
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
    }

    private String[] validatePackages() {
        String prefix = "Ice.Package.";
        Map<String, String> map = this._initData.properties.getPropertiesForPrefix("Ice.Package.");
        ArrayList<String> packages = new ArrayList<String>();
        for (Map.Entry<String, String> p : map.entrySet()) {
            String key = p.getKey();
            String pkg = p.getValue();
            if (key.length() == "Ice.Package.".length()) {
                this._initData.logger.warning("ignoring invalid property: " + key + "=" + pkg);
            }
            String module = key.substring("Ice.Package.".length());
            String className = pkg + "." + module + "._Marker";
            Class<?> cls = null;
            try {
                cls = this.findClass(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cls == null) {
                this._initData.logger.warning("unable to validate package: " + key + "=" + pkg);
                continue;
            }
            packages.add(pkg);
        }
        String pkg = this._initData.properties.getProperty("Ice.Default.Package");
        if (pkg.length() > 0) {
            packages.add(pkg);
        }
        return packages.toArray(new String[packages.size()]);
    }

    private synchronized void addAllAdminFacets() {
        HashMap<String, Object> filteredFacets = new HashMap<String, Object>();
        for (Map.Entry<String, Object> p : this._adminFacets.entrySet()) {
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(p.getKey())) {
                this._adminAdapter.addFacet(p.getValue(), this._adminIdentity, p.getKey());
                continue;
            }
            filteredFacets.put(p.getKey(), p.getValue());
        }
        this._adminFacets = filteredFacets;
    }

    private void setServerProcessProxy(ObjectAdapter adminAdapter, Identity adminIdentity) {
        ObjectPrx admin = adminAdapter.createProxy(adminIdentity);
        LocatorPrx locator = adminAdapter.getLocator();
        String serverId = this._initData.properties.getProperty("Ice.Admin.ServerId");
        if (locator != null && !serverId.isEmpty()) {
            ProcessPrx process = ProcessPrx.uncheckedCast(admin.ice_facet("Process"));
            try {
                locator.getRegistry().setServerProcessProxy(serverId, process);
            }
            catch (ServerNotFoundException ex) {
                if (this._traceLevels.location >= 1) {
                    StringBuilder s = new StringBuilder(128);
                    s.append("couldn't register server `");
                    s.append(serverId);
                    s.append("' with the locator registry:\n");
                    s.append("the server is not known to the locator registry");
                    this._initData.logger.trace(this._traceLevels.locationCat, s.toString());
                }
                throw new InitializationException("Locator knows nothing about server `" + serverId + "'");
            }
            catch (LocalException ex) {
                if (this._traceLevels.location >= 1) {
                    StringBuilder s = new StringBuilder(128);
                    s.append("couldn't register server `");
                    s.append(serverId);
                    s.append("' with the locator registry:\n");
                    s.append(ex.toString());
                    this._initData.logger.trace(this._traceLevels.locationCat, s.toString());
                }
                throw ex;
            }
            if (this._traceLevels.location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("registered server `");
                s.append(serverId);
                s.append("' with the locator registry");
                this._initData.logger.trace(this._traceLevels.locationCat, s.toString());
            }
        }
    }

    private NetworkProxy createNetworkProxy(Properties properties, int protocolSupport) {
        String proxyHost = properties.getProperty("Ice.SOCKSProxyHost");
        if (!proxyHost.isEmpty()) {
            if (protocolSupport == 1) {
                throw new InitializationException("IPv6 only is not supported with SOCKS4 proxies");
            }
            int proxyPort = properties.getPropertyAsIntWithDefault("Ice.SOCKSProxyPort", 1080);
            return new SOCKSNetworkProxy(proxyHost, proxyPort);
        }
        proxyHost = properties.getProperty("Ice.HTTPProxyHost");
        if (!proxyHost.isEmpty()) {
            return new HTTPNetworkProxy(proxyHost, properties.getPropertyAsIntWithDefault("Ice.HTTPProxyPort", 1080));
        }
        return null;
    }

    private static class Timer
    extends ScheduledThreadPoolExecutor {
        private final ThreadObserverHelper _observerHelper;

        Timer(Properties props, String threadName) {
            super(1, Util.createThreadFactory(props, threadName));
            this.setRemoveOnCancelPolicy(true);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this._observerHelper = new ThreadObserverHelper(threadName);
        }

        public void updateObserver(CommunicatorObserver obsv) {
            this._observerHelper.updateObserver(obsv);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            this._observerHelper.beforeExecute();
        }

        @Override
        protected void afterExecute(Runnable t, Throwable e) {
            this._observerHelper.afterExecute();
        }
    }

    private static class QueueExecutor
    extends ThreadPoolExecutor {
        private final ThreadObserverHelper _observerHelper;

        QueueExecutor(Properties props, String threadName) {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Util.createThreadFactory(props, threadName));
            this._observerHelper = new ThreadObserverHelper(threadName);
        }

        public void updateObserver(CommunicatorObserver obsv) {
            this._observerHelper.updateObserver(obsv);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            this._observerHelper.beforeExecute();
        }

        @Override
        protected void afterExecute(Runnable t, Throwable e) {
            this._observerHelper.afterExecute();
        }

        public void destroy() throws InterruptedException {
            this.shutdown();
            while (!this.isTerminated()) {
                this.awaitTermination(100000L, TimeUnit.SECONDS);
            }
        }
    }

    private class ObserverUpdaterI
    implements ObserverUpdater {
        private ObserverUpdaterI() {
        }

        @Override
        public void updateConnectionObservers() {
            Instance.this.updateConnectionObservers();
        }

        @Override
        public void updateThreadObservers() {
            Instance.this.updateThreadObservers();
        }
    }

    private static class ThreadObserverHelper {
        private final String _threadName;
        private volatile ThreadObserver _observer;
        private ThreadObserver _threadObserver;

        ThreadObserverHelper(String threadName) {
            this._threadName = threadName;
        }

        public synchronized void updateObserver(CommunicatorObserver obsv) {
            assert (obsv != null);
            this._observer = obsv.getThreadObserver("Communicator", this._threadName, ThreadState.ThreadStateIdle, this._observer);
            if (this._observer != null) {
                this._observer.attach();
            }
        }

        protected void beforeExecute() {
            this._threadObserver = this._observer;
            if (this._threadObserver != null) {
                this._threadObserver.stateChanged(ThreadState.ThreadStateIdle, ThreadState.ThreadStateInUseForOther);
            }
        }

        protected void afterExecute() {
            if (this._threadObserver != null) {
                this._threadObserver.stateChanged(ThreadState.ThreadStateInUseForOther, ThreadState.ThreadStateIdle);
                this._threadObserver = null;
            }
        }
    }
}

