/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.AdapterDescriptor;
import com.zeroc.IceGrid.CommunicatorDescriptor;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServiceDescriptor;
import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Adapter;
import com.zeroc.IceGridGUI.Application.DbEnv;
import com.zeroc.IceGridGUI.Application.DescriptorHolder;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.PlainServer;
import com.zeroc.IceGridGUI.Application.PlainService;
import com.zeroc.IceGridGUI.Application.Service;
import com.zeroc.IceGridGUI.Application.ServiceInstance;
import com.zeroc.IceGridGUI.Application.ServiceTemplate;
import com.zeroc.IceGridGUI.Application.TemplateInstance;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.TreeNodeBase;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

abstract class Communicator
extends TreeNode
implements DescriptorHolder {
    protected Adapters _adapters = new Adapters();
    protected DbEnvs _dbEnvs = new DbEnvs();
    protected Services _services = new Services();
    protected ChildList[] _childListArray = new ChildList[]{this._adapters, this._dbEnvs, this._services};

    @Override
    public Enumeration<javax.swing.tree.TreeNode> children() {
        return new Enumeration<javax.swing.tree.TreeNode>(){
            private int _index = 0;
            private Iterator<javax.swing.tree.TreeNode> _p;
            {
                this._p = Communicator.this._childListArray[0].iterator();
            }

            @Override
            public boolean hasMoreElements() {
                if (this._p.hasNext()) {
                    return true;
                }
                while (++this._index < Communicator.this._childListArray.length) {
                    this._p = Communicator.this._childListArray[this._index].iterator();
                    if (!this._p.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public javax.swing.tree.TreeNode nextElement() {
                try {
                    return this._p.next();
                }
                catch (NoSuchElementException nse) {
                    if (this.hasMoreElements()) {
                        return this._p.next();
                    }
                    throw nse;
                }
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public javax.swing.tree.TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        int offset = 0;
        for (ChildList childList : this._childListArray) {
            if (childIndex < offset + childList.size()) {
                return childList.get(childIndex - offset);
            }
            offset += childList.size();
        }
        throw new ArrayIndexOutOfBoundsException(childIndex);
    }

    @Override
    public int getChildCount() {
        int result = 0;
        for (ChildList childList : this._childListArray) {
            result += childList.size();
        }
        return result;
    }

    @Override
    public int getIndex(javax.swing.tree.TreeNode node) {
        int offset = 0;
        for (ChildList childList : this._childListArray) {
            int index = childList.indexOf(node);
            if (index == -1) {
                offset += childList.size();
                continue;
            }
            return offset + index;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        for (ChildList childList : this._childListArray) {
            if (childList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void newAdapter() {
        this._adapters.newChild();
    }

    @Override
    public void newDbEnv() {
        this._dbEnvs.newChild();
    }

    @Override
    public void newService() {
        this._services.newChild();
    }

    @Override
    public void newServiceFromTemplate() {
        this._services.newServiceFromTemplate();
    }

    @Override
    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor instanceof Adapter.AdapterCopy) {
            Adapter.AdapterCopy copy = (Adapter.AdapterCopy)descriptor;
            this._adapters.newAdapter(Adapter.copyDescriptor(copy.descriptor), new HashMap<String, String>(copy.parentProperties));
        } else if (descriptor instanceof DbEnvDescriptor) {
            DbEnvDescriptor d = (DbEnvDescriptor)descriptor;
            this._dbEnvs.newDbEnv(DbEnv.copyDescriptor(d));
        } else if (descriptor instanceof ServiceInstanceDescriptor && this._services.initialized()) {
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)descriptor;
            this._services.newService(ServiceInstance.copyDescriptor(d));
        } else {
            ((TreeNode)this._parent).paste();
        }
    }

    abstract CommunicatorDescriptor getCommunicatorDescriptor();

    abstract Editable getEnclosingEditable();

    List<? extends TemplateInstance> findInstances() {
        LinkedList<TemplateInstance> result = new LinkedList<TemplateInstance>();
        result.add((TemplateInstance)((Object)this));
        return result;
    }

    @Override
    TreeNode findChildLike(TreeNode other) {
        if (other instanceof Adapter) {
            return this._adapters.findChildById(other.getId());
        }
        if (other instanceof DbEnv) {
            return this._dbEnvs.findChildById(other.getId());
        }
        if (other instanceof Service) {
            return this._dbEnvs.findChildById(other.getId());
        }
        return null;
    }

    boolean isIceBox() {
        return false;
    }

    protected Communicator(TreeNode parent, String id) {
        super(parent, id);
    }

    Adapters getAdapters() {
        return this._adapters;
    }

    DbEnvs getDbEnvs() {
        return this._dbEnvs;
    }

    Services getServices() {
        return this._services;
    }

    List<ServiceInstance> findServiceInstances(String template) {
        LinkedList<ServiceInstance> result = new LinkedList<ServiceInstance>();
        Iterator<TreeNode> p = this._services.iterator();
        while (p.hasNext()) {
            ServiceInstance obj = (ServiceInstance)p.next();
            if (!(obj instanceof ServiceInstance)) continue;
            ServiceInstance service = obj;
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)service.getDescriptor();
            if (!d.template.equals(template)) continue;
            result.add(service);
        }
        return result;
    }

    void removeServiceInstances(String template) {
        boolean updated = false;
        Iterator<TreeNode> p = this._services.iterator();
        while (p.hasNext()) {
            TreeNode obj = p.next();
            if (!(obj instanceof ServiceInstance)) continue;
            ServiceInstance service = (ServiceInstance)obj;
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)service.getDescriptor();
            if (!d.template.equals(template)) continue;
            p.remove();
            this._services.removeDescriptor(d);
            this.getEnclosingEditable().markModified();
            updated = true;
        }
        if (updated) {
            this.getRoot().getTreeModel().nodeStructureChanged(this);
        }
    }

    void removeSortedChildren(String[] childIds, List<TreeNodeBase> fromChildren) {
        this.removeSortedChildren(childIds, fromChildren, this.getRoot().getTreeModel());
    }

    void childrenChanged(List<TreeNodeBase> children) {
        this.childrenChanged(children, this.getRoot().getTreeModel());
    }

    String getProperty(String key) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        for (PropertyDescriptor p : descriptor.propertySet.properties) {
            if (!p.name.equals(key)) continue;
            return p.value;
        }
        return null;
    }

    String lookupPropertyValue(String val) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        for (PropertyDescriptor p : descriptor.propertySet.properties) {
            if (!p.value.equals(val)) continue;
            return p.name;
        }
        return "";
    }

    void setProperty(String key, String newValue) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        this.removeProperty(key);
        ((LinkedList)descriptor.propertySet.properties).addFirst(new PropertyDescriptor(key, newValue));
    }

    void removeProperty(String key) {
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        Iterator p = descriptor.propertySet.properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            if (!pd.name.equals(key)) continue;
            p.remove();
        }
    }

    Map<String, String> propertiesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        CommunicatorDescriptor descriptor = this.getCommunicatorDescriptor();
        for (PropertyDescriptor p : descriptor.propertySet.properties) {
            result.put(p.name, p.value);
        }
        return result;
    }

    abstract class ChildList<T> {
        protected List<TreeNode> _children = new LinkedList<TreeNode>();
        protected List<T> _descriptors;
        protected boolean _sorted;

        abstract TreeNode createChild(T var1) throws UpdateFailedException;

        abstract void newChild();

        protected ChildList(boolean sorted) {
            this._sorted = sorted;
        }

        void write(XMLWriter writer) throws IOException {
            for (TreeNode p : this._children) {
                p.write(writer);
            }
        }

        Iterator<TreeNode> iterator() {
            return this._children.iterator();
        }

        TreeNode get(int index) {
            return this._children.get(index);
        }

        int indexOf(Object obj) {
            return this._children.indexOf(obj);
        }

        int size() {
            return this._children.size();
        }

        boolean isEmpty() {
            return this._children.isEmpty();
        }

        void init(List<T> descriptors) throws UpdateFailedException {
            assert (this._descriptors == null);
            assert (this._children.isEmpty());
            this._descriptors = descriptors;
            for (T descriptor : this._descriptors) {
                TreeNode child = this.createChild(descriptor);
                this.addChild(child, false);
            }
        }

        boolean initialized() {
            return this._descriptors != null;
        }

        void clear() {
            this._descriptors = null;
            this._children.clear();
        }

        TreeNode addNewChild(T descriptor) throws UpdateFailedException {
            TreeNode child = this.createChild(descriptor);
            this.addChild(child, true);
            return child;
        }

        TreeNode findChildWithDescriptor(T descriptor) {
            for (TreeNode p : this._children) {
                if (p.getDescriptor() != descriptor) continue;
                return p;
            }
            return null;
        }

        TreeNode findChildById(String id) {
            for (TreeNode p : this._children) {
                if (!p.getId().equals(id)) continue;
                return p;
            }
            return null;
        }

        void addChild(TreeNode child, boolean fireEvent) throws UpdateFailedException {
            if (this._sorted) {
                DefaultTreeModel treeModel;
                DefaultTreeModel defaultTreeModel = treeModel = fireEvent ? Communicator.this.getRoot().getTreeModel() : null;
                if (!Communicator.this.insertSortedChild(child, this._children, treeModel)) {
                    throw new UpdateFailedException(Communicator.this, child.getId());
                }
            } else {
                this._children.add(child);
                if (fireEvent) {
                    Communicator.this.getRoot().getTreeModel().nodesWereInserted(Communicator.this, new int[]{Communicator.this.getIndex(child)});
                }
            }
        }

        int removeChild(TreeNode child) {
            int index = Communicator.this.getIndex(child);
            this._children.remove(child);
            Communicator.this.getRoot().getTreeModel().nodesWereRemoved(Communicator.this, new int[]{index}, new Object[]{child});
            return index;
        }

        void destroyChild(TreeNode child) {
            if (child.isEphemeral()) {
                this.removeChild(child);
            } else {
                Object descriptor = child.getDescriptor();
                this.removeDescriptor(descriptor);
                Communicator.this.getEnclosingEditable().markModified();
                Communicator.this.getRoot().updated();
                this.removeChild(child);
            }
        }

        void addDescriptor(T descriptor) {
            this._descriptors.add(descriptor);
        }

        void removeDescriptor(T descriptor) {
            Iterator<T> p = this._descriptors.iterator();
            while (p.hasNext()) {
                if (descriptor != p.next()) continue;
                p.remove();
                break;
            }
        }

        boolean canMove(TreeNode child, boolean up) {
            int i = this._children.indexOf(child);
            assert (i != -1);
            return up && i > 0 || !up && i < this._children.size() - 1;
        }

        void tryAdd(T descriptor) throws UpdateFailedException {
            this.addDescriptor(descriptor);
            try {
                this.addNewChild(descriptor);
            }
            catch (UpdateFailedException e) {
                this.removeDescriptor(descriptor);
                throw e;
            }
            Communicator.this.getEnclosingEditable().markModified();
        }

        void tryUpdate(TreeNode child) throws UpdateFailedException {
            assert (this._sorted);
            Object descriptor = child.getDescriptor();
            this.removeChild(child);
            try {
                this.addNewChild(descriptor);
            }
            catch (UpdateFailedException e) {
                this.addChild(child, true);
                throw e;
            }
            Communicator.this.getEnclosingEditable().markModified();
        }

        protected String makeNewChildId(String base) {
            String id = base;
            int i = 0;
            while (this.findChildById(id) != null) {
                id = base + "-" + ++i;
            }
            return id;
        }
    }

    class Adapters
    extends ChildList<AdapterDescriptor> {
        Adapters() {
            super(true);
        }

        void write(XMLWriter writer, List<PropertyDescriptor> props) throws IOException {
            for (TreeNode p : this._children) {
                ((Adapter)p).write(writer, props);
            }
        }

        @Override
        void newChild() {
            AdapterDescriptor descriptor = new AdapterDescriptor("NewAdapter", "", null, "", "", false, true, new LinkedList(), new LinkedList());
            this.newAdapter(descriptor, null);
        }

        @Override
        TreeNode createChild(AdapterDescriptor descriptor) {
            String name = Utils.substitute(descriptor.name, Communicator.this.getResolver());
            return new Adapter(Communicator.this, name, descriptor, null, false);
        }

        private void newAdapter(AdapterDescriptor descriptor, Map<String, String> parentProperties) {
            Adapter adapter;
            block6: {
                String newName = this.makeNewChildId(descriptor.name);
                if (!newName.equals(descriptor.name) && parentProperties != null) {
                    String key = descriptor.name + ".Endpoints";
                    String val = parentProperties.remove(key);
                    if (val != null) {
                        parentProperties.put(newName + ".Endpoints", val);
                    }
                    if ((val = parentProperties.remove(key = descriptor.name + ".PublishedEndpoints")) != null) {
                        parentProperties.put(newName + ".PublishedEndpoints", val);
                    }
                    if ((val = parentProperties.remove(key = descriptor.name + ".ProxyOptions")) != null) {
                        parentProperties.put(newName + ".ProxyOptions", val);
                    }
                }
                descriptor.name = newName;
                adapter = new Adapter(Communicator.this, descriptor.name, descriptor, parentProperties, true);
                try {
                    this.addChild(adapter, true);
                }
                catch (UpdateFailedException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            Communicator.this.getRoot().setSelectedNode(adapter);
        }
    }

    class DbEnvs
    extends ChildList<DbEnvDescriptor> {
        DbEnvs() {
            super(true);
        }

        @Override
        void newChild() {
            DbEnvDescriptor descriptor = new DbEnvDescriptor("NewDbEnv", "", "", new LinkedList());
            this.newDbEnv(descriptor);
        }

        @Override
        TreeNode createChild(DbEnvDescriptor descriptor) {
            String name = Utils.substitute(descriptor.name, Communicator.this.getResolver());
            return new DbEnv(Communicator.this, name, descriptor, false);
        }

        private void newDbEnv(DbEnvDescriptor descriptor) {
            DbEnv dbEnv;
            block2: {
                descriptor.name = this.makeNewChildId(descriptor.name);
                dbEnv = new DbEnv(Communicator.this, descriptor.name, descriptor, true);
                try {
                    this.addChild(dbEnv, true);
                }
                catch (UpdateFailedException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
            Communicator.this.getRoot().setSelectedNode(dbEnv);
        }
    }

    class Services
    extends ChildList<ServiceInstanceDescriptor> {
        Services() {
            super(false);
        }

        @Override
        void newChild() {
            ServiceDescriptor serviceDescriptor = new ServiceDescriptor(new LinkedList(), new PropertySetDescriptor(new String[0], new LinkedList()), new LinkedList(), new String[0], "", "NewService", "");
            ServiceInstanceDescriptor descriptor = new ServiceInstanceDescriptor("", new HashMap(), serviceDescriptor, new PropertySetDescriptor(new String[0], new LinkedList()));
            this.newService(descriptor);
        }

        void newServiceFromTemplate() {
            ServiceInstanceDescriptor descriptor = new ServiceInstanceDescriptor("", new HashMap(), null, new PropertySetDescriptor(new String[0], new LinkedList()));
            this.newService(descriptor);
        }

        void move(TreeNode child, boolean up) {
            int index = Communicator.this.getIndex(child);
            int listIndex = this._children.indexOf(child);
            ServiceInstanceDescriptor descriptor = (ServiceInstanceDescriptor)child.getDescriptor();
            Communicator.this.getEnclosingEditable().markModified();
            Communicator.this.getRoot().updated();
            this._descriptors.remove(listIndex);
            if (up) {
                this._descriptors.add(listIndex - 1, descriptor);
            } else {
                this._descriptors.add(listIndex + 1, descriptor);
            }
            this._children.remove(listIndex);
            Communicator.this.getRoot().getTreeModel().nodesWereRemoved(Communicator.this, new int[]{index}, new Object[]{child});
            if (up) {
                this._children.add(listIndex - 1, child);
                Communicator.this.getRoot().getTreeModel().nodesWereInserted(Communicator.this, new int[]{index - 1});
            } else {
                this._children.add(listIndex + 1, child);
                Communicator.this.getRoot().getTreeModel().nodesWereInserted(Communicator.this, new int[]{index + 1});
            }
            Communicator.this.getRoot().setSelectedNode(child);
            Communicator.this.getCoordinator().showActions(child);
        }

        @Override
        TreeNode createChild(ServiceInstanceDescriptor descriptor) throws UpdateFailedException {
            if (descriptor.descriptor == null) {
                String serviceName = null;
                String displayString = null;
                Utils.Resolver serviceResolver = null;
                if (Communicator.this instanceof PlainServer) {
                    TemplateDescriptor templateDescriptor = Communicator.this.getRoot().findServiceTemplateDescriptor(descriptor.template);
                    if (templateDescriptor == null) {
                        throw new UpdateFailedException("Cannot find template descriptor '" + descriptor.template + "' referenced by service-instance");
                    }
                    serviceResolver = new Utils.Resolver(Communicator.this.getResolver(), descriptor.parameterValues, templateDescriptor.parameterDefaults);
                    ServiceDescriptor serviceDescriptor = (ServiceDescriptor)templateDescriptor.descriptor;
                    assert (serviceDescriptor != null);
                    serviceName = serviceResolver.substitute(serviceDescriptor.name);
                    serviceResolver.put("service", serviceName);
                    displayString = serviceName + ": " + descriptor.template + "<>";
                } else {
                    serviceName = descriptor.template + "<>";
                }
                return new ServiceInstance(Communicator.this, serviceName, displayString, descriptor, serviceResolver);
            }
            ServiceDescriptor serviceDescriptor = descriptor.descriptor;
            String serviceName = null;
            Utils.Resolver serviceResolver = null;
            if (Communicator.this instanceof PlainServer) {
                serviceResolver = new Utils.Resolver(Communicator.this.getResolver());
                serviceName = serviceResolver.substitute(serviceDescriptor.name);
                serviceResolver.put("service", serviceName);
            } else {
                serviceName = serviceDescriptor.name;
            }
            return new PlainService(Communicator.this, serviceName, descriptor, serviceResolver);
        }

        @Override
        void tryUpdate(TreeNode child) throws UpdateFailedException {
            ServiceInstanceDescriptor descriptor = (ServiceInstanceDescriptor)child.getDescriptor();
            int listIndex = this._children.indexOf(child);
            assert (listIndex != -1);
            TreeNode newChild = this.createChild(descriptor);
            this._children.set(listIndex, newChild);
            Communicator.this.getRoot().getTreeModel().nodeStructureChanged(newChild);
            Communicator.this.getEnclosingEditable().markModified();
        }

        private void newService(ServiceInstanceDescriptor descriptor) {
            if (descriptor.descriptor == null) {
                ServiceInstance service;
                block8: {
                    String name = this.makeNewChildId("NewService");
                    ServiceTemplate t = Communicator.this.getRoot().findServiceTemplate(descriptor.template);
                    if (t == null) {
                        if (Communicator.this.getRoot().getServiceTemplates().getChildCount() == 0) {
                            JOptionPane.showMessageDialog(Communicator.this.getCoordinator().getMainFrame(), "You need to create a service template before you can create a service from a template.", "No Service Template", 1);
                            return;
                        }
                        t = (ServiceTemplate)Communicator.this.getRoot().getServiceTemplates().getChildAt(0);
                        descriptor.template = t.getId();
                        descriptor.parameterValues = new HashMap();
                    }
                    TemplateDescriptor td = (TemplateDescriptor)t.getDescriptor();
                    descriptor.parameterValues = Editor.makeParameterValues(descriptor.parameterValues, td.parameters);
                    service = new ServiceInstance(Communicator.this, name, descriptor);
                    try {
                        this.addChild(service, true);
                    }
                    catch (UpdateFailedException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                Communicator.this.getRoot().setSelectedNode(service);
            } else {
                PlainService service;
                block9: {
                    descriptor.descriptor.name = this.makeNewChildId(descriptor.descriptor.name);
                    service = new PlainService(Communicator.this, descriptor);
                    try {
                        this.addChild(service, true);
                    }
                    catch (UpdateFailedException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                Communicator.this.getRoot().setSelectedNode(service);
            }
        }
    }
}

