/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LogMessage;
import com.zeroc.Ice.LogMessageType;
import com.zeroc.Ice.LoggerAdminPrx;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.RemoteLogger;
import com.zeroc.Ice.RemoteLoggerPrx;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveDeployment.LogFilterDialog;
import com.zeroc.IceGridGUI.LiveDeployment.LogPrefsDialog;
import com.zeroc.IceGridGUI.LiveDeployment.TreeNode;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class ShowIceLogDialog
extends JDialog {
    private final TreeNode _parent;
    private final LoggerAdminPrx _loggerAdmin;
    private final String _title;
    private final String _defaultFileName;
    private RemoteLoggerI _remoteLogger;
    private RemoteLoggerPrx _remoteLoggerPrx;
    private int _maxMessages;
    private int _initialMessages;
    private LogMessageType[] _messageTypeFilter;
    private String[] _traceCategoryFilter;
    private Action _play;
    private Action _pause;
    private Action _stop;
    private JRadioButtonMenuItem _playItem;
    private JRadioButtonMenuItem _pauseItem;
    private JRadioButtonMenuItem _stopItem;
    private JToggleButton _playButton;
    private JToggleButton _pauseButton;
    private JToggleButton _stopButton;
    private final java.lang.Object[] _columnNames = new java.lang.Object[]{"Timestamp", "Type", "Trace Category", "Log Message"};
    private final DefaultTableModel _tableModel;
    private final JTable _table;
    private final Preferences _preferences;
    private static final DateFormat _dateFormat = DateFormat.getDateInstance(3);
    private static final DateFormat _timeFormat = new SimpleDateFormat(" HH:mm:ss:SSS");

    ShowIceLogDialog(TreeNode parent, String title, LoggerAdminPrx loggerAdmin, String defaultFileName, int maxMessages, int initialMessages) {
        super(parent.getRoot().getCoordinator().getMainFrame(), title + " - IceGrid GUI", false);
        this._parent = parent;
        this._title = title;
        this._loggerAdmin = loggerAdmin;
        this._defaultFileName = defaultFileName;
        this._maxMessages = maxMessages;
        this._initialMessages = initialMessages;
        this._preferences = Coordinator.getPreferences().node("LiveDeployment");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowIceLogDialog.this.close(true);
            }
        });
        this._pause = new AbstractAction("Pause"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowIceLogDialog.this.pause();
            }
        };
        this._play = new AbstractAction("Play"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowIceLogDialog.this.play();
            }
        };
        this._stop = new AbstractAction("Stop"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowIceLogDialog.this.stop();
            }
        };
        this._tableModel = new DefaultTableModel(this._columnNames, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this._table = new JTable(this._tableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!this.isRowSelected(row)) {
                    int modelRow = this.convertRowIndexToModel(row);
                    LogMessageType type = (LogMessageType)this.getModel().getValueAt(modelRow, 1);
                    if (type != null) {
                        switch (type) {
                            case ErrorMessage: {
                                c.setBackground(Color.RED);
                                break;
                            }
                            case WarningMessage: {
                                c.setBackground(Color.ORANGE);
                                break;
                            }
                            case PrintMessage: {
                                c.setBackground(Color.LIGHT_GRAY);
                                break;
                            }
                            default: {
                                c.setBackground(this.getBackground());
                            }
                        }
                    }
                }
                return c;
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                java.lang.Object obj;
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int col = this.columnAtPoint(p);
                if (col == 3 && row >= 0 && (obj = this.getValueAt(row, col)) != null) {
                    tip = "<html>" + obj.toString().replace("\n", "<br>") + "</html>";
                }
                return tip;
            }
        };
        this._table.setAutoResizeMode(3);
        this._table.setAutoCreateColumnsFromModel(false);
        this._table.getColumnModel().getColumn(0).setCellRenderer(new DateRenderer());
        this._table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this._table.getColumnModel().getColumn(0).setMaxWidth(300);
        this._table.getColumnModel().getColumn(1).setCellRenderer(new LogMessageTypeRenderer());
        this._table.getColumnModel().getColumn(1).setPreferredWidth(75);
        this._table.getColumnModel().getColumn(1).setMaxWidth(100);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this._table.getColumnModel().getColumn(2).setMaxWidth(300);
        this._table.getColumnModel().getColumn(3).setCellRenderer(new MessageRenderer());
        this._table.getTableHeader().setReorderingAllowed(false);
        int fontSize = this._table.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this._table.getRowHeight() < minRowHeight) {
            this._table.setRowHeight(minRowHeight);
        }
        this._table.setRowSelectionAllowed(true);
        this._table.setOpaque(false);
        this._table.setPreferredScrollableViewportSize(new Dimension(800, 400));
        this._table.setFillsViewportHeight(true);
        this.setJMenuBar(new MenuBar());
        this.getContentPane().add((Component)new ToolBar(), "First");
        JScrollPane scrollPane = new JScrollPane(this._table, 20, 31);
        this.getContentPane().add(scrollPane);
        this.setResizable(true);
        this.pack();
        Utils.restoreWindowBounds(this, this._preferences, "IceLogDialog", this._parent.getRoot().getCoordinator().getMainFrame());
        this._parent.getRoot().addShowIceLogDialog(this._title, this);
        this.setVisible(true);
        this.play();
    }

    private void pause() {
        this._pauseItem.setSelected(true);
        this._pauseButton.setSelected(true);
        assert (this._remoteLogger != null);
        this._remoteLogger.pause();
    }

    private void play() {
        if (this._remoteLogger == null) {
            this._tableModel.setRowCount(0);
            if (this._messageTypeFilter != null || this._traceCategoryFilter != null) {
                this.setTitle(this._title + " (Filtered) - IceGrid GUI");
            } else {
                this.setTitle(this._title + " (No filter) - IceGrid GUI");
            }
            this._playItem.setSelected(true);
            this._playButton.setSelected(true);
            this._pause.setEnabled(false);
            String id = this._loggerAdmin.ice_getIdentity().name + "-" + UUID.randomUUID().toString();
            this._remoteLogger = new RemoteLoggerI();
            this._remoteLoggerPrx = RemoteLoggerPrx.uncheckedCast((ObjectPrx)this._parent.getRoot().getCoordinator().addCallback((Object)this._remoteLogger, id, ""));
            String prefix = "Attaching remote logger to " + this._loggerAdmin.ice_getIdentity().name + "...";
            String errorTitle = "Failed to attach remote logger to " + this._loggerAdmin.ice_getIdentity().name;
            this._parent.getRoot().getCoordinator().getStatusBar().setText(prefix);
            try {
                this._loggerAdmin.attachRemoteLoggerAsync(this._remoteLoggerPrx, this._messageTypeFilter, this._traceCategoryFilter, this._initialMessages).whenComplete((result, ex) -> {
                    if (ex == null) {
                        this._parent.getRoot().amiSuccess(prefix);
                    } else {
                        SwingUtilities.invokeLater(() -> {
                            this._parent.getRoot().failure(prefix, errorTitle, ex.toString());
                            this.stopped();
                        });
                    }
                });
            }
            catch (LocalException ex2) {
                this._parent.getRoot().failure(prefix, errorTitle, ex2.toString());
                this.stopped();
            }
        } else {
            this._remoteLogger.play();
            this._pause.setEnabled(true);
        }
    }

    private void stop(boolean detach) {
        if (this._remoteLogger != null && detach) {
            String prefix = "Detaching remote logger from " + this._loggerAdmin.ice_getIdentity().name + "...";
            this._parent.getRoot().getCoordinator().getStatusBar().setText(prefix);
            try {
                this._loggerAdmin.detachRemoteLoggerAsync(this._remoteLoggerPrx).whenComplete((result, ex) -> {
                    if (ex == null) {
                        if (result.booleanValue()) {
                            this._parent.getRoot().amiSuccess(prefix);
                        } else {
                            this._parent.getRoot().amiSuccess(prefix, "not found");
                        }
                    } else {
                        this._parent.getRoot().amiSuccess(prefix, ex.toString());
                    }
                });
            }
            catch (LocalException ex2) {
                this._parent.getRoot().success(prefix, ex2.ice_id());
            }
        }
        if (this._remoteLogger != null) {
            this._remoteLogger.stop();
            this._remoteLogger = null;
        }
        if (this._remoteLoggerPrx != null) {
            this._parent.getRoot().getCoordinator().removeCallback(this._remoteLoggerPrx.ice_getIdentity().name, "");
            this._remoteLoggerPrx = null;
        }
        this._stopItem.setSelected(true);
        this._stopButton.setSelected(true);
        this._pause.setEnabled(false);
    }

    int getMaxMessages() {
        return this._maxMessages;
    }

    int getInitialMessages() {
        return this._initialMessages;
    }

    void setPrefs(int maxMessages, int initialMessages) {
        if (maxMessages < 50) {
            maxMessages = 50;
        }
        this._maxMessages = maxMessages;
        this._initialMessages = initialMessages;
        if (this._remoteLogger != null) {
            this._remoteLogger.setMaxRows(this._maxMessages);
        }
        this._parent.getRoot().setLogPrefs(this._maxMessages, this._initialMessages);
    }

    LogMessageType[] getMessageTypeFilter() {
        return this._messageTypeFilter;
    }

    String[] getTraceCategoryFilter() {
        return this._traceCategoryFilter;
    }

    void setFilters(LogMessageType[] messageTypeFilter, String[] traceCategoryFilter) {
        this._messageTypeFilter = messageTypeFilter;
        this._traceCategoryFilter = traceCategoryFilter;
        if (this._remoteLogger != null) {
            this.stop();
            this.play();
        }
    }

    void stop() {
        this.stop(true);
    }

    void stopped() {
        this.stop(false);
    }

    void close(boolean notifyRoot) {
        this.stop();
        this._parent.clearShowIceLogDialog();
        if (notifyRoot) {
            this._parent.getRoot().removeShowIceLogDialog(this._title);
        }
        Utils.storeWindowBounds(this, this._preferences.node("IceLogDialog"));
        this.dispose();
    }

    private java.lang.Object[] logMessageToRow(LogMessage msg) {
        java.lang.Object[] row = new java.lang.Object[]{new Date(msg.timestamp / 1000L), msg.type, msg.traceCategory, msg.message};
        return row;
    }

    private static String renderDate(Date date) {
        return _dateFormat.format(date) + _timeFormat.format(date);
    }

    private static String renderLogMessageType(LogMessageType type) {
        String s = type.toString();
        assert (s.length() > 7);
        return s.substring(0, s.length() - 7);
    }

    private static String renderMessage(String msg) {
        return msg.replace("\n", " ");
    }

    static /* synthetic */ int access$1700(ShowIceLogDialog x0) {
        return x0._maxMessages;
    }

    private static class DateRenderer
    extends DefaultTableCellRenderer {
        private DateRenderer() {
        }

        @Override
        public void setValue(java.lang.Object value) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(ShowIceLogDialog.renderDate((Date)value));
            }
        }
    }

    private static class LogMessageTypeRenderer
    extends DefaultTableCellRenderer {
        private LogMessageTypeRenderer() {
        }

        @Override
        public void setValue(java.lang.Object value) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(ShowIceLogDialog.renderLogMessageType((LogMessageType)value));
            }
        }
    }

    private static class MessageRenderer
    extends DefaultTableCellRenderer {
        private MessageRenderer() {
        }

        @Override
        public void setValue(java.lang.Object value) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(ShowIceLogDialog.renderMessage((String)value));
            }
        }
    }

    private class MenuBar
    extends JMenuBar {
        private MenuBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic(70);
            this.add(fileMenu);
            ButtonGroup bg = new ButtonGroup();
            ShowIceLogDialog.this._pauseItem = new JRadioButtonMenuItem(ShowIceLogDialog.this._pause);
            fileMenu.add(ShowIceLogDialog.this._pauseItem);
            bg.add(ShowIceLogDialog.this._pauseItem);
            ShowIceLogDialog.this._playItem = new JRadioButtonMenuItem(ShowIceLogDialog.this._play);
            fileMenu.add(ShowIceLogDialog.this._playItem);
            bg.add(ShowIceLogDialog.this._playItem);
            ShowIceLogDialog.this._stopItem = new JRadioButtonMenuItem(ShowIceLogDialog.this._stop);
            fileMenu.add(ShowIceLogDialog.this._stopItem);
            bg.add(ShowIceLogDialog.this._stopItem);
            fileMenu.addSeparator();
            AbstractAction save = new AbstractAction("Save As..."){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    int result;
                    JFileChooser fileChooser = ShowIceLogDialog.this._parent.getRoot().getCoordinator().getSaveIceLogChooser();
                    fileChooser.setSelectedFile(new File(fileChooser.getCurrentDirectory(), ShowIceLogDialog.this._defaultFileName + ".csv"));
                    File file = null;
                    while (file == null && (result = fileChooser.showSaveDialog(ShowIceLogDialog.this)) == 0) {
                        file = fileChooser.getSelectedFile();
                        if (file == null) continue;
                        if (!file.exists() && file.getName().indexOf(46) == -1) {
                            file = new File(file.getAbsolutePath() + ".csv");
                        }
                        OutputStreamWriter os = null;
                        try {
                            os = new OutputStreamWriter(new FileOutputStream(file));
                            Iterator<Vector> iterator = ShowIceLogDialog.this._tableModel.getDataVector().iterator();
                            while (iterator.hasNext()) {
                                Vector p;
                                Vector row = p = iterator.next();
                                String txt = "\"" + ShowIceLogDialog.renderDate((Date)row.elementAt(0)) + "\"," + ShowIceLogDialog.renderLogMessageType((LogMessageType)row.elementAt(1)) + ",\"" + row.elementAt(2).toString().replace("\"", "\"\"") + "\",\"" + row.elementAt(3).toString().replace("\"", "\"\"") + "\"";
                                txt = txt + "\r\n";
                                os.write(txt, 0, txt.length());
                            }
                        }
                        catch (IOException io) {
                            JOptionPane.showMessageDialog(ShowIceLogDialog.this, io.toString(), "Cannot write file", 0);
                        }
                        finally {
                            if (os == null) continue;
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            };
            save.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, MENU_MASK));
            save.putValue("ShortDescription", "Save As...");
            fileMenu.add(save);
            fileMenu.addSeparator();
            fileMenu.add(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowIceLogDialog.this.close(true);
                }
            });
            JMenu editMenu = new JMenu("Edit");
            editMenu.setMnemonic(69);
            this.add(editMenu);
            AbstractAction copy = new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String txt = new String();
                    for (int i : ShowIceLogDialog.this._table.getSelectedRows()) {
                        int j = ShowIceLogDialog.this._table.convertRowIndexToModel(i);
                        txt = txt + ShowIceLogDialog.renderDate((Date)ShowIceLogDialog.this._tableModel.getValueAt(j, 0)) + "\t" + ShowIceLogDialog.renderLogMessageType((LogMessageType)ShowIceLogDialog.this._tableModel.getValueAt(j, 1)) + "\t" + ShowIceLogDialog.this._tableModel.getValueAt(j, 2).toString() + "\t" + ShowIceLogDialog.renderMessage(ShowIceLogDialog.this._tableModel.getValueAt(j, 3).toString()) + "\n";
                    }
                    StringSelection ss = new StringSelection(txt);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
                }
            };
            copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, MENU_MASK));
            copy.putValue("ShortDescription", "Copy");
            ShowIceLogDialog.this._table.getActionMap().put("copy", copy);
            editMenu.add(copy);
            editMenu.addSeparator();
            AbstractAction selectAll = new AbstractAction("Select All"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowIceLogDialog.this._table.grabFocus();
                    ShowIceLogDialog.this._table.selectAll();
                }
            };
            selectAll.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, MENU_MASK));
            selectAll.putValue("ShortDescription", "Select All");
            editMenu.add(selectAll);
            editMenu.addSeparator();
            editMenu.add(new AbstractAction("Preferences..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new LogPrefsDialog(ShowIceLogDialog.this);
                }
            });
            editMenu.addSeparator();
            editMenu.add(new AbstractAction("Filter..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new LogFilterDialog(ShowIceLogDialog.this);
                }
            });
        }
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            ShowIceLogDialog.this._pauseButton = new JToggleButton(ShowIceLogDialog.this._pause);
            ShowIceLogDialog.this._pauseButton.setText(null);
            ShowIceLogDialog.this._pauseButton.setIcon(Utils.getIcon("/icons/16x16/pause.png"));
            this.add(ShowIceLogDialog.this._pauseButton);
            ShowIceLogDialog.this._playButton = new JToggleButton(ShowIceLogDialog.this._play);
            ShowIceLogDialog.this._playButton.setText(null);
            ShowIceLogDialog.this._playButton.setIcon(Utils.getIcon("/icons/16x16/start.png"));
            this.add(ShowIceLogDialog.this._playButton);
            ShowIceLogDialog.this._stopButton = new JToggleButton(ShowIceLogDialog.this._stop);
            ShowIceLogDialog.this._stopButton.setText(null);
            ShowIceLogDialog.this._stopButton.setIcon(Utils.getIcon("/icons/16x16/stop.png"));
            this.add(ShowIceLogDialog.this._stopButton);
            ButtonGroup bg = new ButtonGroup();
            bg.add(ShowIceLogDialog.this._pauseButton);
            bg.add(ShowIceLogDialog.this._playButton);
            bg.add(ShowIceLogDialog.this._stopButton);
        }
    }

    private class RemoteLoggerI
    implements RemoteLogger {
        private boolean _paused = true;
        private boolean _destroyed = false;
        private final Deque<LogMessage> _queue = new ArrayDeque<LogMessage>();
        private int _rowCount = 0;
        private int _maxRows = ShowIceLogDialog.access$1700(ShowIceLogDialog.this);

        private RemoteLoggerI() {
        }

        public synchronized void init(String prefix, LogMessage[] logMessages, Current current) {
            if (!this._destroyed) {
                int i;
                this._rowCount = logMessages.length + this._queue.size() < this._maxRows ? logMessages.length + this._queue.size() : this._maxRows;
                java.lang.Object[][] data = new java.lang.Object[this._rowCount][];
                Iterator<LogMessage> p = this._queue.descendingIterator();
                for (i = this._rowCount - 1; p.hasNext() && i >= 0; --i) {
                    data[i] = ShowIceLogDialog.this.logMessageToRow(p.next());
                }
                for (int j = logMessages.length - 1; i >= 0 && j >= 0; --i, --j) {
                    data[i] = ShowIceLogDialog.this.logMessageToRow(logMessages[j]);
                }
                this._queue.clear();
                this._paused = false;
                SwingUtilities.invokeLater(() -> {
                    ShowIceLogDialog.this._tableModel.setDataVector(data, ShowIceLogDialog.this._columnNames);
                    ShowIceLogDialog.this._table.scrollRectToVisible(ShowIceLogDialog.this._table.getCellRect(ShowIceLogDialog.this._table.getRowCount() - 1, 0, true));
                    ShowIceLogDialog.this._pause.setEnabled(true);
                });
            }
        }

        public synchronized void log(LogMessage message, Current current) {
            if (!this._destroyed) {
                if (this._paused) {
                    this._queue.addLast(message);
                    while (this._queue.size() > this._maxRows) {
                        this._queue.removeFirst();
                    }
                } else {
                    this.showLogMessage(message);
                }
            }
        }

        private synchronized void setMaxRows(int maxRows) {
            this._maxRows = maxRows;
            int rowsToRemove = this._rowCount - this._maxRows;
            if (rowsToRemove > 0) {
                this._rowCount -= rowsToRemove;
                SwingUtilities.invokeLater(() -> {
                    int i = rowsToRemove;
                    while (i-- > 0) {
                        ShowIceLogDialog.this._tableModel.removeRow(0);
                    }
                });
            }
        }

        private synchronized void pause() {
            assert (!this._destroyed);
            this._paused = true;
        }

        private synchronized void play() {
            assert (!this._destroyed);
            for (LogMessage p : this._queue) {
                this.showLogMessage(p);
            }
            this._queue.clear();
            this._paused = false;
        }

        private synchronized void stop() {
            this._destroyed = true;
        }

        private void showLogMessage(LogMessage msg) {
            java.lang.Object[] row = ShowIceLogDialog.this.logMessageToRow(msg);
            ++this._rowCount;
            int rowsToRemove = this._rowCount - this._maxRows;
            if (rowsToRemove > 0) {
                this._rowCount -= rowsToRemove;
            }
            SwingUtilities.invokeLater(() -> {
                ShowIceLogDialog.this._tableModel.addRow(row);
                int i = rowsToRemove;
                while (i-- > 0) {
                    ShowIceLogDialog.this._tableModel.removeRow(0);
                }
                ShowIceLogDialog.this._table.scrollRectToVisible(ShowIceLogDialog.this._table.getCellRect(ShowIceLogDialog.this._table.getRowCount() - 1, 0, true));
            });
        }
    }
}

