/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.IceGrid.PropertyDescriptor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class Utils {
    public static ImageIcon getIcon(String path) {
        URL imgURL = Utils.class.getResource(path);
        if (imgURL == null) {
            System.err.println("Could not find icon " + path);
            return null;
        }
        return new ImageIcon(imgURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        Graphics g = null;
        try {
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight());
            g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    public static void addEscapeListener(final JDialog dialog) {
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static void removeEscapeListener(JDialog dialog) {
        dialog.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    public static int getIntVersion(String version) {
        int result = 0;
        if ((version = version.trim()).length() > 0) {
            try {
                int firstDotPos = version.indexOf(46);
                if (firstDotPos == -1) {
                    result = -1;
                } else {
                    result = Integer.parseInt(version.substring(0, firstDotPos));
                    if (result == 0) {
                        return -1;
                    }
                    result *= 100;
                    int secondDotPos = version.indexOf(46, firstDotPos + 1);
                    if (secondDotPos == -1) {
                        result += Integer.parseInt(version.substring(firstDotPos + 1));
                        result *= 100;
                    } else {
                        result += Integer.parseInt(version.substring(firstDotPos + 1, secondDotPos));
                        result *= 100;
                        result += Integer.parseInt(version.substring(secondDotPos + 1));
                    }
                }
            }
            catch (NumberFormatException e) {
                result = -1;
            }
        }
        return result;
    }

    public static void storeWindowBounds(Window window, Preferences prefs) {
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            boolean maximized = frame.getExtendedState() == 6;
            prefs.putBoolean("maximized", maximized);
        }
        Rectangle rect = window.getBounds();
        prefs.putInt("x", rect.x);
        prefs.putInt("y", rect.y);
        prefs.putInt("width", rect.width);
        prefs.putInt("height", rect.height);
    }

    public static Preferences restoreWindowBounds(Window window, Preferences parent, String node, Component parentComponent) {
        Preferences prefs = null;
        try {
            if (parent.nodeExists(node)) {
                prefs = parent.node(node);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        boolean locationVisible = false;
        if (prefs != null) {
            GraphicsDevice[] screens;
            int x = prefs.getInt("x", 0);
            int y = prefs.getInt("y", 0);
            int width = prefs.getInt("width", 0);
            int height = prefs.getInt("height", 0);
            boolean maximized = prefs.getBoolean("maximized", false);
            Rectangle visibleBounds = new Rectangle();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice s : screens = ge.getScreenDevices()) {
                visibleBounds.add(s.getDefaultConfiguration().getBounds());
            }
            boolean bl = locationVisible = visibleBounds.contains(x, y) || maximized && visibleBounds.contains(x + 20, y + 20);
            if (locationVisible) {
                if (maximized) {
                    Frame frame = (Frame)window;
                    frame.setBounds(new Rectangle(x + 20, y + 20, width, height));
                    frame.setExtendedState(6);
                } else {
                    window.setBounds(new Rectangle(x, y, width, height));
                }
            } else {
                window.setSize(width, height);
            }
        }
        if (!locationVisible) {
            if (parentComponent != null) {
                Dimension parentSize = parentComponent.getSize();
                Dimension thisSize = window.getSize();
                if (parentSize.width < thisSize.width || parentSize.height < thisSize.height) {
                    window.setLocationRelativeTo(null);
                } else {
                    window.setLocationRelativeTo(parentComponent);
                }
            } else {
                window.setLocation(100, 100);
            }
        }
        return prefs;
    }

    public static StringifyResult stringify(Collection<?> col, Stringifier stringifier, String separator) {
        StringifyResult r = new StringifyResult();
        r.returnValue = "";
        Iterator<?> p = col.iterator();
        boolean firstElement = true;
        while (p.hasNext()) {
            String elt = stringifier.toString(p.next());
            if (elt == null) continue;
            if (firstElement) {
                firstElement = false;
                r.toolTip = "<html>";
            } else {
                r.returnValue = r.returnValue + separator;
                r.toolTip = r.toolTip + "<br>";
            }
            r.returnValue = elt.length() == 0 ? r.returnValue + "\"\"" : (elt.matches("\\S*") ? r.returnValue + elt : r.returnValue + '\"' + elt + '\"');
            r.toolTip = r.toolTip + elt;
        }
        if (r.toolTip != null) {
            r.toolTip = r.toolTip + "</html>";
        }
        return r;
    }

    public static StringifyResult stringify(Collection<?> col, String separator) {
        Stringifier stringifier = new Stringifier(){

            @Override
            public String toString(Object obj) {
                return (String)obj;
            }
        };
        return Utils.stringify(col, stringifier, separator);
    }

    public static StringifyResult stringify(String[] stringSeq, String separator) {
        return Utils.stringify(Arrays.asList(stringSeq), separator);
    }

    public static StringifyResult stringify(Map<String, String> stringMap, final String pairSeparator, String separator) {
        Stringifier stringifier = new Stringifier(){

            @Override
            public String toString(Object obj) {
                Map.Entry entry = (Map.Entry)obj;
                return (String)entry.getKey() + pairSeparator + (String)entry.getValue();
            }
        };
        return Utils.stringify(stringMap.entrySet(), stringifier, separator);
    }

    public static String substitute(String input, Resolver resolver) {
        if (resolver != null) {
            return resolver.substitute(input);
        }
        return input;
    }

    public static SortedMap<String, String> propertySetsToMap(List<ExpandedPropertySet> propertySets, Resolver resolver) {
        TreeMap<String, String> toMap = new TreeMap<String, String>();
        for (ExpandedPropertySet p : propertySets) {
            Utils.addSet(p, resolver, toMap);
        }
        return toMap;
    }

    public static SortedMap<String, String> propertySetToMap(ExpandedPropertySet propertySet, Resolver resolver) {
        LinkedList<ExpandedPropertySet> list = new LinkedList<ExpandedPropertySet>();
        list.add(propertySet);
        return Utils.propertySetsToMap(list, resolver);
    }

    private static void addSet(ExpandedPropertySet set, Resolver resolver, SortedMap<String, String> toMap) {
        for (ExpandedPropertySet s : set.references) {
            Utils.addSet(s, resolver, toMap);
        }
        for (PropertyDescriptor p : set.properties) {
            String name = Utils.substitute(p.name, resolver);
            String val = Utils.substitute(p.value, resolver);
            toMap.put(name, val);
        }
    }

    public static class StringifyResult {
        public String returnValue;
        public String toolTip;
    }

    public static interface Stringifier {
        public String toString(Object var1);
    }

    public static class Resolver {
        private Map<String, String>[] _variables;
        private Map<String, String> _parameters;
        private Map<String, String> _predefinedVariables;
        private Resolver _subResolver;

        public Resolver(Map<String, String> variables) {
            this(new Map[]{variables});
        }

        public Resolver(Map<String, String>[] variables) {
            this._variables = variables;
            this._predefinedVariables = new HashMap<String, String>();
            this._parameters = null;
            this._subResolver = this;
        }

        public Resolver(Resolver parent, Map<String, String> parameters, Map<String, String> defaults) {
            this._variables = parent._variables;
            this.reset(parent, parameters, defaults);
        }

        public Resolver(Resolver parent) {
            this._variables = parent._variables;
            this._predefinedVariables = new HashMap<String, String>(parent._predefinedVariables);
            this._parameters = parent._parameters;
            this._subResolver = this._parameters == null ? this : new Resolver(this._variables, this._predefinedVariables);
        }

        private Resolver(Map<String, String>[] variables, Map<String, String> predefinedVariables) {
            this._variables = variables;
            this._predefinedVariables = predefinedVariables;
            this._parameters = null;
            this._subResolver = this;
        }

        public String find(String name) {
            String val;
            if (this._parameters != null && (val = this._parameters.get(name)) != null) {
                return val;
            }
            val = this._predefinedVariables.get(name);
            if (val != null) {
                return val;
            }
            for (Map<String, String> map : this._variables) {
                val = map.get(name);
                if (val == null) continue;
                return this._subResolver.substitute(val);
            }
            return null;
        }

        public boolean put(String name, String value) {
            String oldVal = this._predefinedVariables.get(name);
            if (oldVal == null || !oldVal.equals(value)) {
                this._predefinedVariables.put(name, value);
                return true;
            }
            return false;
        }

        public void reset(Resolver parent, Map<String, String> parameters, Map<String, String> defaults) {
            assert (this._variables == parent._variables);
            this._predefinedVariables = new HashMap<String, String>(parent._predefinedVariables);
            this._parameters = parent.substituteParameterValues(parameters, defaults);
            this._subResolver = new Resolver(this._variables, this._predefinedVariables);
        }

        public void reset(Resolver parent) {
            assert (this._variables == parent._variables);
            this._predefinedVariables = new HashMap<String, String>(parent._predefinedVariables);
            assert (this._parameters == parent._parameters);
            this._subResolver = this._parameters == null ? this : new Resolver(this._variables, this._predefinedVariables);
        }

        public Map<String, String> getParameters() {
            return this._parameters;
        }

        public String substitute(String input) {
            if (input == null) {
                return input;
            }
            int beg = 0;
            int end = 0;
            while ((beg = input.indexOf("${", beg)) != -1) {
                if (beg > 0 && input.charAt(beg - 1) == '$') {
                    int escape;
                    for (escape = beg - 1; escape > 0 && input.charAt(escape - 1) == '$'; --escape) {
                    }
                    input = input.substring(0, escape) + input.substring(beg - (beg - escape) / 2);
                    if ((beg - escape) % 2 != 0) {
                        ++beg;
                        continue;
                    }
                    beg -= (beg - escape) / 2;
                }
                if ((end = input.indexOf(125, beg)) == -1) {
                    return input;
                }
                String name = input.substring(beg + 2, end);
                String val = this.find(name);
                if (val != null) {
                    input = input.substring(0, beg) + val + input.substring(end + 1);
                    beg += val.length();
                    continue;
                }
                ++beg;
            }
            return input;
        }

        public Map<String, String> substituteParameterValues(Map<String, String> input, Map<String, String> defaults) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<String, String> p : input.entrySet()) {
                result.put(p.getKey(), this.substitute(p.getValue()));
            }
            for (Map.Entry<String, String> p : defaults.entrySet()) {
                if (result.containsKey(p.getKey())) continue;
                result.put(p.getKey(), this.substitute(p.getValue()));
            }
            return result;
        }
    }

    public static class ExpandedPropertySet {
        public ExpandedPropertySet[] references;
        public List<PropertyDescriptor> properties;
    }
}

